"======================================================================
|
|   Array Method Definitions
|
|   $Revision: 1.95.1$
|   $Date: 2000/12/27 10:45:49$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Steve Byrne.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


ArrayedCollection variableSubclass: #Array
		  instanceVariableNames: ''
		  classVariableNames: ''
		  poolDictionaries: ''
		  category: 'Collections-Sequenceable'
!

Array comment: 
'My instances are objects that have array-like properties: they are directly 
indexable by integers starting at 1, and they are fixed in size.  I inherit
object creation behavior messages such as #with:, as well as iteration
and general access behavior from SequenceableCollection.' !


!Array methodsFor: 'printing'!

printOn: aStream
    "Print a representation for the receiver on aStream"
    aStream nextPut: $(.
    self do:
	[ :elt | elt printOn: aStream.
		 aStream space ].
    aStream nextPut: $)
! !


!Array methodsFor: 'mutating objects'!

multiBecome: anArray
    "Transform every object in the receiver in each corresponding
     object in anArray. anArray and the receiver must have the same
     size"

    | index |
    index := 0.
    ^self collect: [:object |
	index := index + 1.
	object become: (anArray at: index)
    ]
! !



!Array methodsFor: 'testing'!

isArray
    ^true
! !