/******************************** -*- C -*- ****************************
 *
 *	External definitions for C callin module
 *
 *	$Revision: 1.95.1$
 *	$Date: 2000/12/27 10:45:49$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Steve Byrne.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/



#ifndef __GSTCALLIN__
#define __GSTCALLIN__


#include "gst.h"
#include "gstpub.h"

#ifndef HAVE_STDARG_H
#ifndef __PROTO
# define __PROTO(args) ()
#endif
# define __DOTS
#else					/* must be ANSI */
#ifndef __PROTO
# define __PROTO(args) args
#endif
# define __DOTS		, ...
#endif

extern OOP	msgSend __PROTO ((OOP receiver, OOP selector __DOTS));
extern OOP      vmsgSend __PROTO ((OOP receiver, OOP selector, OOP *args));
extern OOP      nvmsgSend __PROTO ((OOP receiver, OOP selector, OOP *args, int nargs));
extern OOP	   strMsgSend __PROTO ((OOP receiver __DOTS));
extern void	   msgSendf __PROTO ((voidPtr resultPtr __DOTS));

/* Actually funcAddr is a function pointer, but we don't know
extern  the returned type so we must declare it as voidPtr */
extern void	   defineCFunc __PROTO (( char *funcName, voidPtr funcAddr));
extern OOP         registerOOP __PROTO((OOP oop));
extern OOP	   evalExpr __PROTO((char *str));
extern void	   unregisterOOP __PROTO((OOP oop));
extern void	   evalCode __PROTO((char *str));
extern void	   asyncSignal __PROTO((OOP semaphoreOOP));
extern void	   initSmalltalk __PROTO((void));
extern void	   smalltalkArgs __PROTO((int argc, char **argv));
extern void	   topLevelLoop __PROTO((void));

/* Convert C datatypes to Smalltalk types */

extern OOP	   idToOOP __PROTO((long i));
extern OOP	   intToOOP __PROTO((long i));
extern OOP	   floatToOOP __PROTO((double f));
extern OOP	   boolToOOP __PROTO((int b));
extern OOP	   charToOOP __PROTO((char c));
extern OOP	   classNameToOOP __PROTO((char *name));
extern OOP	   stringToOOP __PROTO((char *str));
extern OOP	   symbolToOOP __PROTO((char *str));
extern OOP	   cObjectToOOP __PROTO((voidPtr co));
extern OOP	   typeNameToOOP __PROTO((char *name));

/* Convert Smalltalk datatypes to C data types */

extern long	    OOPToC __PROTO((OOP oop));   /* sometimes answers a voidPtr */
extern long	    OOPToId __PROTO((OOP oop)); 
extern long	    OOPToInt __PROTO((OOP oop)); 
extern double       OOPToFloat __PROTO((OOP oop));
extern int 	    OOPToBool __PROTO((OOP oop));
extern char	    OOPToChar __PROTO((OOP oop));
extern char	    *OOPToString __PROTO((OOP oop));
extern voidPtr      OOPToCObject __PROTO((OOP oop));

extern VMProxy  interpreterProxy;

extern void	markRegisteredOOPs(), initOOPRegistry(), initVMProxy();

#endif /* __GSTCALLIN__ */
