/******************************** -*- C -*- ****************************
 *
 *	Public definitions for extensions to Smalltalk.
 *
 *	$Revision: 1.95.1$
 *	$Date: 2000/12/27 10:45:49$
 *	$Author: pb$
 *
 ***********************************************************************/


/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Steve Byrne and Paolo Bonzini.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/


#ifndef __GSTPUB__
#define __GSTPUB__

/* Don't change the comment below */
/* INSERT CONFIGURATION OPTIONS HERE!!!! */

/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#if defined(c_plusplus) && !defined(__cplusplus)
#define __cplusplus c_plusplus
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define __GST_FROM_GSTPUB_H__
#include "gst.h"
#undef __GST_FROM_GSTPUB_H__

#ifndef __STDC__
# ifndef __PROTO
#  define __PROTO(args) ()
# endif
# define __DOTS
#else					/* must be ANSI */
# ifndef __PROTO
#  define __PROTO(args) args
# endif
# define __DOTS		, ...
#endif

typedef struct VMProxyStruct {
  OOP      nilOOP, trueOOP, falseOOP;

  OOP	   (*msgSend) __PROTO ((OOP receiver, OOP selector __DOTS));
  OOP      (*vmsgSend) __PROTO ((OOP receiver, OOP selector, OOP *args));
  OOP      (*nvmsgSend) __PROTO ((OOP receiver, OOP selector, OOP *args, int nargs));
  OOP	   (*strMsgSend) __PROTO ((OOP receiver __DOTS));
  void	   (*msgSendf) __PROTO ((voidPtr resultPtr __DOTS));

/* Actually funcAddr is a function pointer, but we don't know
   the returned type so we must declare it as voidPtr */
  void	   (*defineCFunc) __PROTO (( char *funcName, voidPtr funcAddr));
  OOP      (*registerOOP) __PROTO((OOP oop));
  OOP	   (*evalExpr) __PROTO((char *str));
  void	   (*unregisterOOP) __PROTO((OOP oop));
  void	   (*evalCode) __PROTO((char *str));
  void	   (*asyncSignal) __PROTO((OOP semaphoreOOP));

/* Convert C datatypes to Smalltalk types */

  OOP	   (*idToOOP) __PROTO((long i));
  OOP	   (*intToOOP) __PROTO((long i));
  OOP	   (*floatToOOP) __PROTO((double f));
  OOP	   (*boolToOOP) __PROTO((int b));
  OOP	   (*charToOOP) __PROTO((char c));
  OOP	   (*classNameToOOP) __PROTO((char *name));
  OOP	   (*stringToOOP) __PROTO((char *str));
  OOP	   (*symbolToOOP) __PROTO((char *str));
  OOP	   (*cObjectToOOP) __PROTO((voidPtr co));
  OOP	   (*typeNameToOOP) __PROTO((char *name));

/* Convert Smalltalk datatypes to C data types */

  long	    (*OOPToC) __PROTO((OOP oop));   /* sometimes answers a voidPtr */
  long	    (*OOPToId) __PROTO((OOP oop)); 
  long	    (*OOPToInt) __PROTO((OOP oop)); 
  double    (*OOPToFloat) __PROTO((OOP oop));
  int 	    (*OOPToBool) __PROTO((OOP oop));
  char	    (*OOPToChar) __PROTO((OOP oop));
  char	    *(*OOPToString) __PROTO((OOP oop));
  voidPtr   (*OOPToCObject) __PROTO((OOP oop));
} VMProxy;

#define indexedWord(obj, n)   ( ((long *) ((obj) + 1))		    [(n)-1] )
#define indexedByte(obj, n)   ( ((char *) ((obj) + 1))		    [(n)-1] )
#define indexedOOP(obj, n)    ( ((OOP  *) ((obj) + 1))		    [(n)-1] )
#define arrayOOPAt(obj, n)    ( ((OOP  *) ((mst_Object) obj)->data) [(n)-1] )
#define stringOOPAt(obj, n)   ( ((char *) ((mst_Object) obj)->data) [(n)-1] )

/* These are extern in case one wants to link to libgst.a; these
 * are not meant to be called by a module, which is brought up by
 * GNU Smalltalk when the VM is already up and running.
 */
extern void	   initSmalltalk __PROTO((void));
extern void	   smalltalkArgs __PROTO((int argc, char **argv));
extern void	   topLevelLoop __PROTO((void));

#ifdef __cplusplus
extern "C" }
#endif

#undef __PROTO
#undef __DOTS

#endif /* __GSTPUB__ */
