/******************************** -*- C -*- ****************************
 *
 *	Byte Code interpreter declarations.
 *
 *	$Revision: 1.95.1$
 *	$Date: 2000/12/27 10:45:49$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Steve Byrne.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/


#ifndef __GSTINTERP__
#define __GSTINTERP__

#include "comp.h"

#define NUM_PRIORITIES		9

#define FIXED_CTX_SIZE	(sizeof(struct MethodContextStruct) / sizeof(long) - 1)
#define CTX_SIZE(depth) (((depth) << DEPTH_SCALE) + FIXED_CTX_SIZE)

typedef struct MethodContextStruct {
  OBJ_HEADER;
  OOP		parentContext;
  OOP		returnIP;	/* used by JIT */
  OOP		ipOffset;	/* an integer byte index into method */
  OOP		spOffset;	/* an integer index into cur context stack */
  OOP		receiver;	/* the receiver OOP */
  OOP		method;		/* the method that we're executing */
  OOP		flags;		/* must be an int to distinguish Block/MethodContext */
  OOP		contextStack[1];
} *MethodContext;

typedef struct BlockContextStruct {
  OBJ_HEADER;
  OOP           parentContext;
  OOP		returnIP;	/* used by JIT */
  OOP		ipOffset;	/* an integer byte index into method */
  OOP		spOffset;	/* an integer index into cur context stack */
  OOP		receiver;	/* the receiver OOP */
  OOP		method;		/* the method that we're executing */
  OOP		outerContext;   /* the parent BlockContext or MethodContext */
  OOP		contextStack[1];
} *BlockContext;

typedef struct SemaphoreStruct {
  OBJ_HEADER;
  OOP		firstLink;
  OOP		lastLink;
  OOP		signals;
} *Semaphore;

typedef struct ProcessStruct {
  OBJ_HEADER;
  OOP		nextLink;
  OOP		suspendedContext;
  OOP		priority;
  OOP		myList;
  OOP		name;
  OOP		exceptionHandlers;
  OOP		unwindPoints;
} *Process;

typedef struct ProcessorSchedulerStruct {
  OBJ_HEADER;
  OOP		processLists;
  OOP		activeProcess;
  OOP		idleTasks;
} *ProcessorScheduler;

extern unsigned long		primitivesExecuted;
extern unsigned long		literalReturns, instVarReturns, selfReturns;
extern unsigned long		byteCodeCounter, sampleCounter;
extern unsigned long		cacheMisses;
extern mst_Boolean		executionTracing;
extern mst_Boolean		makeCoreFile;
extern mst_Boolean		nonInteractive;
extern OOP			thisMethod;
extern OOP			*temporaries, *literals;
extern OOP			self;
extern OOP			thisContextOOP;


#ifdef USE_JIT_TRANSLATION
  typedef int			IPType;
  extern char			*nativeIP;
#else /* plain bytecode interpreter */
  typedef Byte *		IPType;
# define ip			outerIP
#endif

extern IPType			ip;
extern volatile mst_Boolean	exceptFlag;

extern OOP			finishExecutionEnvironment();
extern void			interpret(), sendMessageInternal(),
				initInterpreter(), emptyContextPool(),
				prepareExecutionEnvironment(), asyncSignal(),
				invalidateMethodCache(), showBacktrace(), 
				initSignals(), /* deallocPoolContext(), */
  				fixupObjectPointers(), restoreObjectPointers(),
  				initProcessSystem(), markProcessorRegisters(),
  				printProcessState(), showStackContents(),
  				validateMethodCacheEntries(), sendMethod();

/************************************************** PRIMITIVES ****************/

#define PRIM_SUCCEED			0x0001
#define PRIM_FAIL			0x0002
#define PRIM_RELOAD_IP			0x0004
#define PRIM_OUTCOMES			0x0007
#define PRIM_CACHE_NEW_IP		0x0008
#define PRIM_INLINED			0x0010
#define PRIM_RETURN_SMALL_INTEGER	0x0100  /* 31 or 63 bits */
#define PRIM_RETURN_SMALL_SMALLINTEGER	0x0300	/* 30 or 62 bits */

typedef long			(*PrimitiveFunc)();

extern long			executePrimitiveOperation(),
				getPrimitiveAttributes();

extern PrimitiveFunc		getPrimitiveAddress();

#include "interp.inl"

#endif /* __GSTINTERP__ */
