/******************************** -*- C -*- ****************************
 *
 *	Byte code interpreter inlines
 *
 *	$Revision: 1.95.1$
 *	$Date: 2000/12/27 10:45:49$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Steve Byrne.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/


#ifndef __GSTINTERP_INLINES__
#define __GSTINTERP_INLINES__

#include "dict.h"

static inline long		mulWithCheck();


/* using stackAt is correct: numArgs == 0 means that there's just the
 * receiver on the stack, at 0.  numArgs = 1 means that at location 0 is
 * the arg, location 1 is the receiver.  And so on. */
#define sendMessage(sendSelector, sendArgs, dummy) do {			\
  register OOP _receiver;						\
  _receiver = stackAt(sendArgs);					\
  sendMessageInternal(sendSelector, sendArgs, _receiver, 		\
    isInt(_receiver) ? smallIntegerClass : oopClass(_receiver));	\
} while(0);


/*
 *	long mulWithCheck(a, b)
 *
 * Description
 *
 *	Called to handle multiplication with overflow checking.	 In case of
 *	an overflow, answer OVERFLOWING_INT so that we can work it out the
 *	same way we do with adds and subtracts.
 *	Is there a better way to do this?!?
 *
 * Inputs
 *
 *	a, b   : The two factors
 *
 * Outputs
 *
 *	either a valid integer in the MIN_ST_INT to MAX_ST_INT range, or
 *	OVERFLOWING_INT
 */

long
mulWithCheck(a, b)
     register long a;
     register long b;
{
#define LIMIT		   (1L << (ST_INT_SIZE / 2))
#define HIGHPART(x)	   ((x) >> (ST_INT_SIZE / 2))
#define LOWPART(x)	   ((x) & (LIMIT - 1))
#define COMPOSE(u, h, l)   ((l) | ((h) * LIMIT) | ((u) * LIMIT * LIMIT) )

#if 1
  /* 1 multiplication & (maybe) 1 division */

  register long result = a * b;
  if ((a | b) < LIMIT || b == 0 || (result / b == a)) {
    return (result);
  } else {
    return (OVERFLOWING_INT);
  }

#else
  /* 3 multiplications, no division */
  if ((a | b) < LIMIT) {
    return (a * b);
  } else {
    long upperBits, highBits, lowBits;

    upperBits = HIGHPART(a) * HIGHPART(b);

    if (upperBits != 0 && upperBits != -1)
      return (OVERFLOWING_INT);

    lowBits = LOWPART(a) * LOWPART(b);
    highBits = LOWPART(a) * HIGHPART(b) + LOWPART(b) * HIGHPART(a);

    highBits += HIGHPART(lowBits);
    lowBits &= LIMIT - 1;
    if (highBits >= LIMIT || highBits < -LIMIT)
      return (OVERFLOWING_INT);

    return (COMPOSE(upperBits, highBits, lowBits));
  }
#endif
}

#endif
