/******************************** -*- C -*- ****************************
 *
 *	Object table module Inlines.
 *
 *	$Revision: 1.95.1$
 *	$Date: 2000/12/27 10:45:49$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Steve Byrne.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/


#ifndef __GSTOOP_INLINES__
#define  __GSTOOP_INLINES__

#include "alloc.h"
#include "input.h"

static inline OOP allocOOP();

#define maybeMarkOOP(oop) do {				  \
  if (isOOP(oop) && !isOOPMarked(oop)) {		  \
    markAnOOPInternal(oop, nil, nil);			  \
  }							  \
} while(0);

#define markOOPRange(startOOP, endOOP) do {		  \
  if ((startOOP) < (endOOP)) {				  \
    markAnOOPInternal(nil, startOOP, endOOP);		  \
  }							  \
} while(0);

/* In the non-incremental GC world, being FREE is all that matters for
 * validity.
 */
#define oopValid(oop) \
  (!(oop->flags & F_FREE))

#define oopAt(index) \
  ( &oopTable[index] )

#define oopAvailable(index) \
  ( oopTable[index].flags & F_FREE )

#define oopIndex(oop) \
  ( (OOP)(oop) - oopTable )

#define setOOPObject(oop, obj) do {				\
  (oop)->object = (mst_Object) (obj);				\
} while(0);

#define freeOOP(oop) do {				\
  extern OOP firstFreeOOP;				\
  register OOP _theOOP = (oop);				\
  _theOOP->flags   = F_FREE;				\
  -theOOP->object  = (mst_Object) firstFreeOOP;		\
  firstFreeOOP = _theOOP;				\
} while(0);

#define isOOPAddr(addr)							\
  ((OOP)(addr) >= allOopsTable && (OOP)(addr) < &oopTable[oopTableSize] \
    && (((long)addr & (SIZEOF_LONG - 1)) == 0))

#define isObjAddr(addr)							\
  ((char *)(addr) >= memSpace.space && (char *)(addr) < memSpace.allocPtr \
    && (((long)(addr) & (SIZEOF_LONG - 1)) == 0))

#include "gst.h"
#include "lex.h"
#include "dict.h"




/*
 *	OOP allocOOP(obj)
 *
 * Description
 *
 *	Given an object OBJ, this routine allocates an OOP table slot for it
 *	and returns it.  It marks the OOP so that it indicates the object is in
 *	new space, and that the oop has been referenced on this pass (to keep
 *	the OOP table reaper from reclaiming this OOP).
 *
 * Inputs
 *
 *	obj   : Object that the new OOP should point to.
 *
 * Outputs
 *
 *	An OOP, which is the address of an element in the OOP table.
 */
static inline OOP allocOOP(obj)
     mst_Object	obj;
{
  REGISTER(1, OOP	oop);
  extern   OOP 		firstFreeOOP;

  if(numFreeOOPs-- < LOW_WATER_OOP_THRESHOLD) {
    int newSize;
    gcFlip();

    if(numFreeOOPs < (oopTableSize * growThresholdPercent / 100)) {
      newSize = oopTableSize * (spaceGrowRate + 100) / 100;
      if (newSize - oopTableSize < LOW_WATER_OOP_THRESHOLD) {
	newSize = oopTableSize + LOW_WATER_OOP_THRESHOLD;
      }
      reallocOOPTable(newSize);
      if(numFreeOOPs < LOW_WATER_OOP_THRESHOLD) {
	nomemory(true);
      }
    }
  }

  oop = firstFreeOOP;
  firstFreeOOP = (OOP)oop->object;
  if (oop > lastUsedOOP) {
    lastUsedOOP = oop;
  }

#ifndef OPTIMIZE
  if (!(oop->flags & F_FREE)) {
    errorf("Non-free OOP in OOP free list!!!");
    exit(1);
  }
#endif

  oop->object = obj;
  oop->flags = 0;				/* no flags on this one */
  return (oop);
}

#endif
