AC_DEFUN(GST_DOUBLE_ALIGNMENT, [

AC_CACHE_CHECK(for double alignment, gst_cv_double_alignment, [
AC_TRY_RUN([
  main(argc)
  int argc;
  {
    long vec[3];
    double *testptr;

    /* The argument to exit is always 0, and the reference to argc
     * has no purpose other than that to fool the optimizer -- of
     * course argc != -1, so exit's parameter will always be 0 and
     * the test will only fail if the program segfaults.
     */
    testptr = (double *) &vec[1];
    exit (*testptr == 1.0 && argc == -1);
  }],
  gst_cv_double_alignment=SIZEOF_CHAR_P,
  gst_cv_double_alignment="2*SIZEOF_CHAR_P",
  gst_cv_double_alignment="2*SIZEOF_CHAR_P")     dnl Assume the worst
])

AC_DEFINE_UNQUOTED(DOUBLE_ALIGNMENT, $gst_cv_double_alignment,
               [Define this to the memory alignment required by type "double"])

])dnl
