dnl Calls several commonly used macros; also provides support for
dnl selectively enabling or disabling some GCC optimizations
dnl
AC_DEFUN(GST_PROG_CC, [
AC_REQUIRE([AC_PROG_CC])
AC_REQUIRE([AC_PROG_CPP])
AC_REQUIRE([AC_PROG_GCC_TRADITIONAL])
AC_REQUIRE([AC_AIX])
AC_REQUIRE([AC_ISC_POSIX])

ifelse([$1$2], , , [dnl
if test "$GCC" = yes; then
  gcc_help="`$CC -v --help 2>&1`"
  case "$gcc_help" in
    *peephole*) ;;
    *) gcc_help="-ffloat-store -fdefault-inline -fdefer-pop -fforce-mem \
	-fforce-addr -fomit-frame-pointer -finline -finline-functions \
	-fkeep-inline-functions -ffunction-cse -ffast-math \
	-fstrength-reduce -fthread-jumps -fcse-follow-jumps \
	-fcse-skip-blocks -frerun-cse-after-loop -fexpensive-optimizations \
	-fdelayed-branch -fschedule-insns -fschedule-insns2 \
	-fcaller-saves -funroll-loops -funroll-all-loops -fpeephole "
  esac

  ifelse([$1], , , [
    for i in $1; do
      case "$gcc_help" in
        *-f$i*) CFLAGS="$CFLAGS -f$i" ;;
        *)	;;
      esac
    done
  ])dnl
  ifelse([$2], , , [
    for i in $2; do
      case "$gcc_help" in
        *-f$i*) CFLAGS="$CFLAGS -fno-$i" ;;
        *)	;;
      esac
    done
  ])dnl
fi
])dnl
])dnl
