AC_DEFUN(GST_HAVE_READLINE, [

AC_ARG_WITH(readline, 
	[  --with-readline=path    set path to readline and termcap libraries
  --without-readline      don't try to detect readline])


if test "$with_readline" != no; then
  AC_CACHE_CHECK(how to link with readline, gst_cv_readline_libs, [
    test "$with_readline" && test -d "$with_readline" && \
      LDFLAGS="$LDFLAGS -L$with_readline"
    gst_cv_readline_libs="not found"
    ac_save_LIBS="$LIBS"
    for lib in "" -ltermcap -ltermlib -lncurses; do
      LIBS="$ac_save_LIBS -lreadline $lib"

      cat > conftest.$ac_ext <<\EOF
#include <stdio.h>
#include <readline/readline.h>
main()
{
  rl_bind_key ('\t', rl_insert);
  exit(0);
}
EOF
      dnl Link the program.  If not cross-compiling, run it too,
      dnl to detect shared library dependancies.

      ok=yes
      (AC_TRY_EVAL(ac_link) && test -s conftest${ac_exeext})	    || ok=no
      test $cross_compiling = no -a $ok = yes && (./conftest; exit) || ok=no
      rm -rf conftest*

      test $ok = yes && gst_cv_readline_libs="-lreadline $lib" break
    done
    LIBS="$ac_save_LIBS"
  ])

  if test "$gst_cv_readline_libs" != "not found"; then
    LIBS="$LIBS $gst_cv_readline_libs"
    AC_DEFINE(HAVE_READLINE, 1,
          [Define if your system has the GNU readline library.])
  fi
fi

])dnl
