AC_DEFUN(GST_REVISION, [

VERSION=[`echo '$1'|sed 's/$[^0-9.]*//g'`]
VERSION_INFO=$2

AC_SUBST(VERSION_INFO)

# Split the version number
[
  ST_MAJOR_VERSION=`echo $VERSION| sed "s%\\..*%%g"`
  if test `echo $VERSION| sed "s%[^.]%%g"` = ".."; then
    ST_MINOR_VERSION=`echo $VERSION| sed "s%.*\\.\\(.*\\)\\..*%\\1%g"`
    ST_EDIT_VERSION=`echo $VERSION| sed "s%.*\\.%%g"`
  else
    ST_MINOR_VERSION=`echo $VERSION| sed "s%.*\\.%%g"`
    ST_EDIT_VERSION=0
  fi
]

AC_DEFINE_UNQUOTED(VERSION_INFO, "$VERSION_INFO",
                   [Version of the GNU Smalltalk interface library])
AC_DEFINE_UNQUOTED(ST_MAJOR_VERSION, $ST_MAJOR_VERSION,
                   [Major version of GNU Smalltalk])
AC_DEFINE_UNQUOTED(ST_VERSION_INFO, $ST_VERSION_INFO,
                   [Version of the GNU Smalltalk interface library])
AC_DEFINE_UNQUOTED(ST_MINOR_VERSION, $ST_MINOR_VERSION,
                   [Minor version of GNU Smalltalk])
AC_DEFINE_UNQUOTED(ST_EDIT_VERSION, $ST_EDIT_VERSION,
                   [Patch level version of GNU Smalltalk])
AC_DEFINE_UNQUOTED(MAINTAINER, "$MAINTAINER",
                   [E-Mail address of the person maintaining this package])
])