"======================================================================
|
|   Socket implementations for the TCP/IP stack
|
|   $Revision: 1.95.1$
|   $Date: 2000/12/27 10:45:49$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


SocketImpl subclass: #TCPSocketImpl
	   instanceVariableNames: ''
	   classVariableNames: ''
	   poolDictionaries: ''
	   category: 'Sockets-Protocols'
!

DatagramSocketImpl subclass: #OOBSocketImpl
	   instanceVariableNames: ''
	   classVariableNames: ''
	   poolDictionaries: ''
	   category: 'Sockets-Protocols'
!

MulticastSocketImpl subclass: #UDPSocketImpl
	   instanceVariableNames: ''
	   classVariableNames: ''
	   poolDictionaries: ''
	   category: 'Sockets-Protocols'
!

RawSocketImpl subclass: #ICMPSocketImpl
	   instanceVariableNames: ''
	   classVariableNames: ''
	   poolDictionaries: ''
	   category: 'Sockets-Protocols'
!

!TCPSocketImpl methodsFor: 'implementation'!

addressClass
    ^IPAddress
!

outOfBandImplClass
    "Return an implementation class to be used for out-of-band data
     on the receiver."
    ^OOBSocketImpl
! !

!OOBSocketImpl methodsFor: 'implementation'!

canRead
    | result |
    self isOpen ifFalse: [ ^false ].
    result := self oobAvailable: self fd.
    result == -1 ifTrue: [ self nowDead; close ].
    ^result == 1
!

addressClass
    ^IPAddress
!

create
    self shouldNotImplement
! !

!OOBSocketImpl methodsFor: 'private'!

flags
    ^self msgOOB
! !

!UDPSocketImpl methodsFor: 'implementation'!

addressClass
    ^IPAddress
! !

!UDPSocketImpl methodsFor: 'multicasting'!

ipMulticastIf
    ^(self
	optionAt: self class ipMulticastIf
	level: self class ipprotoIp
	size: CInt sizeof) intAt: 1
!

ipMulticastIf: interface
    self
	optionAt: self class ipMulticastIf
	level: self class ipprotoIp
	put: interface
!

join: ipAddress
    "Join the multicast socket at the given address"
    self primJoinLeave: ipAddress option: self class ipAddMembership
!

leave: ipAddress
    "Leave the multicast socket at the given address"
    self primJoinLeave: ipAddress option: self class ipDropMembership
!

primJoinLeave: ipAddress option: opt
    | data |
    data := ByteArray new: IPAddress addressSize * 2.
    data
	replaceFrom: 1
	to: IPAddress addressSize
	with: ipAddress asByteArray
	startingAt: 1;

	replaceFrom: IPAddress addressSize + 1
	to: data size
	with: IPAddress anyLocalAddress asByteArray
	startingAt: 1.

    self
	optionAt: opt
	level: self ipprotoIp
	put: data
!

timeToLive
    "Answer the time to live of the datagrams sent through the receiver
     to a multicast socket."
    ^(self
	optionAt: self class ipMulticastTtl
	level: self ipprotoIp
	size: CInt sizeof) intAt: 1
!

timeToLive: ttl
    "Set the time to live of the datagrams sent through the receiver
     to a multicast socket."
    self
	optionAt: self class ipMulticastTtl
	level: self ipprotoIp
	put: ttl
! !

!ICMPSocketImpl methodsFor: 'implementation'!

addressClass
    ^IPAddress
!

protocol
    ^self class ipprotoIcmp
! !

