"======================================================================
|
|   SUnit testing framework - Camp Smalltalk extensions
|
|   This file is in the public domain.
|
 ======================================================================"

TestCase subclass: #TestCaseProtocol
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'SUnit-Protocol-Framework'!

TestCaseProtocol subclass: #MainTestCase
	instanceVariableNames: 'messages helpers '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'SUnit-Protocol-Framework'!

MainTestCase class
	instanceVariableNames: 'helpers messages '!

TestCaseProtocol subclass: #TestCaseHelper
	instanceVariableNames: 'testCase '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'SUnit-Protocol-Framework'!

TestCaseHelper class
	instanceVariableNames: 'testSelectors '!

!TestCase methodsFor: 'asserting'!

value: aBlock shouldRaise: anException
	| works |
	#'ACSUEnh'. 
	works := false.
	aBlock on: anException do: [:ex | works := true. ex sunitExitWith: nil ].
	works ifTrue: [ ^self ].
	TestResult failure sunitSignalWith: 'Failed to raise ' , anException printString!

value: aBlock shouldntRaise: anException 
	| works |
	#'ACSUEnh'. 
	works := true.
	aBlock on: anException do: [:ex | works := false. ex sunitExitWith: nil ].
	works ifTrue: [ ^self ].
	TestResult failure sunitSignalWith: 'Should not have raised ' , anException printString! !

TestCaseProtocol comment:
'TestCaseProtocol adds enhancements to TestCase for asserting conformance
to a message protocol.  It has two subclasses.  MainTestCase tests a class,
TestCaseHelper tests a protocol.  Since a single class often must implement
several protocols, a MainTestCase often has several TestCaseHelpers.  It
delegates tests to the helper that is responsible for it.'!


!TestCaseProtocol methodsFor: 'asserting'!

assertSend: aSelector 
	self assertSend: aSelector inProtocol: self protocol.
!

assertSend: aSelector inProtocol: aSymbol 
	self assertSend: aSelector toObject: self cannonicalObject inProtocol: aSymbol.
!

assertSend: aSelector toObject: anObject inProtocol: aSymbol 
	| opResult msgSpec |
	opResult := anObject perform: aSelector.
	msgSpec := (self protocolManager protocolNamed: aSymbol)
					messageOrNilAtSelector: aSelector.
	msgSpec isNil ifTrue: [self signalFailure: aSelector , ' is not in protocol ', aSymbol].
	self assert: (msgSpec isConformingReturn: opResult)
!

msgSpecFor: msgSelector inProtocol: protocolName
	| msgSpec newEx |
	[msgSpec := (self protocolManager protocolNamed: protocolName)
			messageAtSelector: msgSelector
	] on: Exception do: [ :except |
		"Generate TestFailure as if originally signaled in except's place."
		newEx := TestResult failure new.
		newEx messageText: except description.
		except resignalAs: newEx
	].
	^msgSpec
!

selector: aSelector inProtocol: aSymbol behavesLike: arrays 
	arrays asANSITestArray do: [:each | self
			value: [each first perform: aSelector withArguments: (each copyFrom: 2 to: each size - 1)]
			should: [:r | r = each last]
			conformTo: aSymbol
			selector: aSelector]
!

value: opBlock should: shouldBlock conformTo: protocolName selector: msgSelector 
	"	self value: [2 = 2] should: [:result | result] conformTo: #'Object' selector: 
	#'='. "
	| msgSpec opResult |
	opResult := opBlock value.
	self assert: (shouldBlock value: opResult).
	[msgSpec := (self protocolManager protocolNamed: protocolName)
				messageAtSelector: msgSelector]
		on: Exception do: [:except | "Generate TestFailure as if originally signaled in except's place."
		self signalFailure: except description].
	msgSpec isReturnValueSpecByRule ifTrue: [self signalFailure: 'Conformence failed - requires rule.'].
	(msgSpec isConformingReturn: opResult)
		ifFalse: [self signalFailure: 'Conformence failed']
!

value: opBlock should: shouldBlock conformTo: protocolName selector: msgSelector opRECEIVER: receiver 
	"	| negFlt2 |	negFlt2 := -2.0. 
	self value: [negFlt2 abs] should: [:result | result = 2.0] 
	conformTo: #'number' selector: #'abs' opRECEIVER: negFlt2.
	"
	| msgSpec opResult |
	opResult := opBlock value.
	self assert: (shouldBlock value: opResult).
	msgSpec := self msgSpecFor: msgSelector inProtocol: protocolName.
	(msgSpec
		isConformingReturn: opResult
		opRECEIVER: receiver
		conformTo: protocolName
		selector: msgSelector)
		ifFalse: [self signalFailure: 'Conformence failed return RECEIVER: ' , receiver printString]
!

value: opBlock should: shouldBlock conformTo: protocolName selector: msgSelector ruleReceiver: receiver 
	"	| negFlt2 |	negFlt2 := -2.0. 
	self value: [negFlt2 integerPart] should: [:result | result = -2] 
	conformTo: #'number' selector: #'integerPart' ruleReceiver: negFlt2.
	"
	| msgSpec opResult |
	opResult := opBlock value.
	self assert: (shouldBlock value: opResult).
	msgSpec := self msgSpecFor: msgSelector inProtocol: protocolName.
	msgSpec isReturnValueSpecByRule ifFalse: [TestResult failure signal: 'Conformence failed - requires rule.'].
	(msgSpec isConformingReturn: opResult ruleReceiver: receiver)
		ifFalse: [self signalFailure: 'Conformence failed rule value: ' , receiver printString]
!

value: opBlock should: shouldBlock conformTo: protocolName selector: msgSelector
ruleReceiver: receiver operand: operand
"	| negInt2 posInt2 |	negInt2 := -2.	posInt2 := 2.
	self value: [negInt2 * posInt2] should: [:result | result = -4]
		conformTo: #'number' selector: #'*'
		ruleReceiver: negInt2 operand: posInt2"
	| msgSpec opResult |
	opResult := opBlock value.
	self assert: (shouldBlock value: opResult).
	msgSpec := self msgSpecFor: msgSelector inProtocol: protocolName.
	msgSpec isReturnValueSpecByRule 
		ifFalse: [self signalFailure: 'Conformence failed - requires rule.'].
	(msgSpec
		isConformingReturn: opResult
		ruleReceiver: receiver
		operand: operand
	) ifFalse: [self signalFailure: ('Conformence failed rule value: ', receiver printString, ' rec: ', operand printString)].
!

!TestCaseProtocol methodsFor: 'asserting'!
value: opBlock shouldnt: shouldNotBlock conformTo: protocolName
selector: msgSelector
"	self value: [2 = -2]
		shouldnt: [:result | result] conformTo: #'Object' selector: #'='.
"
	self value: opBlock
		should: [:result | (shouldNotBlock value: result) not]
		conformTo: protocolName
		selector: msgSelector
! !

!TestCaseProtocol methodsFor: 'asserting'!
value: opBlock shouldnt: shouldNotBlock conformTo: protocolName
selector: msgSelector 
opRECEIVER: receiver
"	| negFlt2 |	negFlt2 := -2.0.
	self value: [negFlt2 abs] shouldnt: [:result | result = 0.0]
		conformTo: #'number' selector: #'abs' opRECEIVER: negFlt2.
"
	self value: opBlock
		should: [:result | (shouldNotBlock value: result) not]
		conformTo: protocolName
		selector: msgSelector
		opRECEIVER: receiver! !

!TestCaseProtocol methodsFor: 'asserting'!
value: opBlock shouldnt: shouldNotBlock conformTo: protocolName
selector: msgSelector ruleReceiver: receiver
"	| negFlt2 |	negFlt2 := -2.0.
	self value: [negFlt2 integerPart]
		shouldnt: [:result | result = 2]
		conformTo: #'number' selector: #'integerPart' ruleReceiver: negFlt2.
"
	self value: opBlock
		should: [:result | (shouldNotBlock value: result) not]
		conformTo: protocolName
		selector: msgSelector
		ruleReceiver: receiver
! !

!TestCaseProtocol methodsFor: 'asserting'!
value: opBlock shouldnt: shouldNotBlock
conformTo: protocolName selector: msgSelector
ruleReceiver: receiver operand: operand
"	| negInt2 posInt2 |	negInt2 := -2.	posInt2 := 2.
	self value: [negInt2 * posInt2] shouldnt: [:result | result = 4]
		conformTo: #'number' selector: #'*'
		ruleReceiver: negInt2 operand: posInt2.
"
	self value: opBlock
		should: [:result | (shouldNotBlock value: result) not]
		conformTo: protocolName
		selector: msgSelector
		ruleReceiver: receiver
		operand: operand
! !


!TestCaseProtocol methodsFor: 'error handling'!
notDone
	"change this to self halt when you want to find all methods that are not done"! !

!TestCaseProtocol class methodsFor: 'accessing'!
testMethods
	^self selectors select: [:each | 'test*' match: each].! !


!MainTestCase methodsFor: 'testing'!

setUp
	| helper1 |
	helpers := Array new.
	self class helperClassesDo: [:each | 
		helper1 := each new.
		helper1 attachTo: self.
		helper1 object: self cannonicalObject.
		helpers := helpers copyWith: helper1]! !

!MainTestCase methodsFor: 'running'!

receiverFor: aSelector 
	(self respondsTo: aSelector) ifTrue: [^self].
	helpers do: [:each | (each respondsTo: aSelector) ifTrue: [^each]].
	self error: 'not a legal test selector'!

runCase 
	self setUp.
	[(self receiverFor: testSelector) perform: testSelector]
		ifError: [:msg :rcvr |
			self tearDown.
			self error: msg] "Don't know yet how to set the original :rcvr"!

!MainTestCase class methodsFor: 'instance creation'!

helperClassesDo: aBlock
	aBlock value: (Smalltalk at: #'ObjectHelper').
!

isAbstract
	"Assume that concrete testcase classes do not have subclasses."
	^self subclasses isEmpty not
!

suite
	| testSuite testMethods |
	testSuite := TestSuite new.
	self isAbstract ifTrue: [^testSuite].
	testMethods := self testMethods.
	self helperClassesDo: [:eachClass | testMethods addAll: eachClass testMethods].
	testMethods do: [:each | testSuite addTest: (self selector: each)].
	^testSuite
! !

!MainTestCase class methodsFor: 'deleting methods'!

deleteEmptyMethodsImplementedByHelpers
	self testMethods do: [:each | self deleteIfUnnecessary: each]
!

deleteIfUnnecessary: aSelector
	(self hasEmptyMethodFor: aSelector) ifFalse: [^self].
	(self helpersImplement: aSelector) ifTrue: [self removeSelector: aSelector]
!

hasEmptyMethodFor: aSelector
	"Warning - only works for gst"
	^(self >> aSelector) flags between: 1 and: 3
!

helpersImplement: aSelector
	self helperClassesDo: [:each | (each selectors includes: aSelector) ifTrue: [^true]].
	^false
!

removeAllCodeThatShouldBeInHelpers
	"Warning - only works for Squeak"
	"MainTestCase removeAllCodeThatShouldBeInHelpers"
	self allSubclasses do: [:each | each deleteEmptyMethodsImplementedByHelpers]
! !

!TestCaseHelper methodsFor: 'testing'!

attachTo: mainTestCase 
	testCase := mainTestCase.
!

printOn: aStream

	aStream
		nextPutAll: self class printString;
		nextPutAll: '>>'!

protocol
	^testCase protocol! !


!TestCaseHelper class methodsFor: 'accessing'!

testMethods
	testSelectors isNil ifTrue: [testSelectors := self selectors select: [:each | 'test*' match: each]].
	^testSelectors! !

!TestCaseHelper class methodsFor: 'instance creation'!

suite
	^TestSuite new.
! !

!SequenceableCollection methodsFor: 'converting'!
asANSITestArray
	^self collect: [:each | each asANSITestArray ]
! !

!Object methodsFor: 'converting'!
asANSITestArray
	^self
! !

!Symbol methodsFor: 'converting'!
asANSITestArray
	self == #nil ifTrue: [ ^nil ].
	self == #true ifTrue: [ ^true ].
	self == #false ifTrue: [ ^false ] ifFalse: [ ^self ].
! !
