"======================================================================
|
|   ANSI test suite implemetation
|
|   This file is in the public domain.
|
 ======================================================================"


MainTestCase subclass: #ArrayFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

MainTestCase subclass: #BagFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

MainTestCase subclass: #BooleanANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Fundamental'!

MainTestCase subclass: #ByteArrayFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

MainTestCase subclass: #CharacterANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Fundamental'!

MainTestCase subclass: #CharacterFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Fundamental'!

TestCaseHelper subclass: #CollectionHelper
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

MainTestCase subclass: #CollectionTest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

CollectionTest subclass: #ArrayANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

CollectionTest subclass: #BagANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

CollectionTest subclass: #ByteArrayANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

MainTestCase subclass: #DateAndTimeANSITest
	instanceVariableNames: 'd19970426t8 '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Date and Time'!

MainTestCase subclass: #DateAndTimeFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Date and Time'!

CollectionTest subclass: #DictionaryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

MainTestCase subclass: #DictionaryFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

MainTestCase subclass: #DurationANSITest
	instanceVariableNames: 'off0123 smallInt2 largeNegInt2000000000 largePosInt2000000000 float2 fractionHalf numList '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Date and Time'!

MainTestCase subclass: #DurationFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Date and Time'!

MainTestCase subclass: #DyadicValuableANSITest
	instanceVariableNames: 'blk2args '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Valuable'!

TestCaseProtocol subclass: #ErrorANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Exception'!

TestCaseProtocol subclass: #ErrorClassANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Exception'!

TestCaseProtocol subclass: #ExceptionANSITest
	instanceVariableNames: 'unchanged changed value '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Exception'!

TestCaseProtocol subclass: #ExceptionClassANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Exception'!

TestCaseProtocol subclass: #ExceptionSetANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Exception'!

MainTestCase subclass: #FailedMessageANSITest
	instanceVariableNames: 'failedMsg '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Fundamental'!

MainTestCase subclass: #FileStreamFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-File Stream'!

MainTestCase subclass: #FloatANSITest
	instanceVariableNames: 'smallInt2 largeNegInt2000000000 largePosInt2000000000 float2 fractionHalf sclDec2s3 numList '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Numeric'!

MainTestCase subclass: #FloatCharacterizationANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Numeric'!

MainTestCase subclass: #FractionANSITest
	instanceVariableNames: 'smallInt2 largeNegInt2000000000 largePosInt2000000000 float2 fractionHalf sclDec2s3 numList '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Numeric'!

MainTestCase subclass: #FractionFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Numeric'!

MainTestCase subclass: #IdentityDictionaryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

MainTestCase subclass: #IdentityDictionaryFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

MainTestCase subclass: #IntegerANSITest
	instanceVariableNames: 'smallInt2 largeNegInt2000000000 largePosInt2000000000 float2 fractionHalf sclDec2s3 numList '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Numeric'!

CollectionTest subclass: #IntervalANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

MainTestCase subclass: #IntervalFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

TestCaseProtocol subclass: #MessageNotUnderstoodANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Exception'!

TestCaseProtocol subclass: #MessageNotUnderstoodSelectorANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Exception'!

MainTestCase subclass: #MonadicBlockANSITest
	instanceVariableNames: 'blk1args '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Valuable'!

MainTestCase subclass: #NilANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Fundamental'!

MainTestCase subclass: #NiladicBlockANSITest
	instanceVariableNames: 'blk0args canonicalObject '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Valuable'!

TestCaseProtocol subclass: #NotificationANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Exception'!

TestCaseProtocol subclass: #NotificationClassANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Exception'!

MainTestCase subclass: #ObjectANSITest
	instanceVariableNames: 'object '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Fundamental'!

MainTestCase subclass: #ObjectClassANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Fundamental'!

TestCaseHelper subclass: #ObjectHelper
	instanceVariableNames: 'object '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Fundamental'!

CollectionTest subclass: #OrderedCollectionANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

MainTestCase subclass: #OrderedCollectionFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

MainTestCase subclass: #ReadFileStreamANSITest
	instanceVariableNames: 'readFileStream '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-File Stream'!

MainTestCase subclass: #ReadStreamANSITest
	instanceVariableNames: 'readStream '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Stream'!

MainTestCase subclass: #ReadStreamFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Stream'!

MainTestCase subclass: #ReadWriteStreamANSITest
	instanceVariableNames: 'readWriteStream '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Stream'!

MainTestCase subclass: #ReadWriteStreamFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Stream'!

MainTestCase subclass: #ScaledDecimalANSITest
	instanceVariableNames: 'smallInt2 largeNegInt2000000000 largePosInt2000000000 float2 fractionHalf sclDec2s3 numList '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Numeric'!

MainTestCase subclass: #SelectorANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Fundamental'!

TestCaseHelper subclass: #SequencedCollectionHelper
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

TestCaseHelper subclass: #SequencedReadableCollectionHelper
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

CollectionTest subclass: #SetANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

MainTestCase subclass: #SetFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

CollectionTest subclass: #SortedCollectionANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

MainTestCase subclass: #SortedCollectionFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

CollectionTest subclass: #StringANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

MainTestCase subclass: #StringFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

CollectionTest subclass: #SymbolANSITest
	instanceVariableNames: 'smalltalkSymbol '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Collection'!

MainTestCase subclass: #TranscriptANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Stream'!

TestCaseProtocol subclass: #WarningANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Exception'!

TestCaseProtocol subclass: #WarningClassANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Exception'!

MainTestCase subclass: #WriteFileStreamANSITest
	instanceVariableNames: 'writeFileStream '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-File Stream'!

MainTestCase subclass: #WriteStreamANSITest
	instanceVariableNames: 'writeStream '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Stream'!

MainTestCase subclass: #WriteStreamFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Stream'!

TestCaseProtocol subclass: #ZeroDivideANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Exception'!

TestCaseProtocol subclass: #ZeroDivideFactoryANSITest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Tests-ANSI-Exception'!

!ArrayFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXnew
	" <Array factory>#new "
	#'Collection'.
! !

!ArrayFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXnewX
	" <Array factory>#new: "
	#'Collection'.
! !

!ArrayFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXwithAllX
	" <Array factory>#withAll: "
	#'Collection'.
! !

!ArrayFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXwithX
	" <Array factory>#with: "
	#'Collection'.
! !

!ArrayFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXwithXwithX
	" <Array factory>#with:with: "
	#'Collection'.
! !

!ArrayFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXwithXwithXwithX
	" <Array factory>#with:with:with: "
	#'Collection'.
! !

!ArrayFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXwithXwithXwithXwithX
	" <Array factory>#with:with:with:with: "
	#'Collection'.
! !

!ArrayFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/25/2000 23:57'!
cannonicalObject
	^Array! !

!ArrayFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/25/2000 23:58'!
protocol
	^#'Array factory'! !


!BagFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXnew
	" <Bag factory>#new "
	#'Collection'.
! !

!BagFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXnewX
	" <Bag factory>#new: "
	#'Collection'.
! !

!BagFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXwithAllX
	" <Bag factory>#withAll: "
	#'Collection'.
! !

!BagFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXwithX
	" <Bag factory>#with: "
	#'Collection'.
! !

!BagFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXwithXwithX
	" <Bag factory>#with:with: "
	#'Collection'.
! !

!BagFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXwithXwithXwithX
	" <Bag factory>#with:with:with: "
	#'Collection'.
! !

!BagFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXwithXwithXwithXwithX
	" <Bag factory>#with:with:with:with: "
	#'Collection'.
! !

!BagFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:36'!
cannonicalObject
	^Bag! !

!BagFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:37'!
protocol
	^#'Bag factory'! !


!BooleanANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXandOp
	" <boolean>#& "
	#'Fundamental'.
	self value: [true & true] should: [:r | r]
		conformTo: #'boolean' selector: #'&'.
	self value: [true & false] shouldnt: [:r | r]
		conformTo: #'boolean' selector: #'&'.
	self value: [false & true] shouldnt: [:r | r]
		conformTo: #'boolean' selector: #'&'.
	self value: [false & false] shouldnt: [:r | r]
		conformTo: #'boolean' selector: #'&'.
! !

!BooleanANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXandX
	" <boolean>#and: "
	#'Fundamental'.
	self value: [ true and: [true] ] should: [:r | r]
		conformTo: #'boolean' selector: #'and:'.
	self value: [ true and: [nil isNil] ] should: [:r | r]
		conformTo: #'boolean' selector: #'and:'.
	self value: [ true and: [false] ] shouldnt: [:r | r]
		conformTo: #'boolean' selector: #'and:'.
	self value: [ true and: [nil notNil] ] shouldnt: [:r | r]
		conformTo: #'boolean' selector: #'and:'.
	self value: [ true and: [nil selector] ]
		shouldRaise: MessageNotUnderstood.

	self value: [ false and: [true] ] shouldnt: [:r | r]
		conformTo: #'boolean' selector: #'and:'.
	self value: [ false and: [nil isNil] ] shouldnt: [:r | r]
		conformTo: #'boolean' selector: #'and:'.
	self value: [ false and: [false] ] shouldnt: [:r | r]
		conformTo: #'boolean' selector: #'and:'.
	self value: [ false and: [nil notNil] ] shouldnt: [:r | r]
		conformTo: #'boolean' selector: #'and:'.
	"No error:"
	self value: [ false and: [nil selector] ] shouldnt: [:r | r]
		conformTo: #'boolean' selector: #'and:'.
! !

!BooleanANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXeqvX
	" <boolean>#eqv: "
	#'Fundamental'.
	self value: [true eqv: true] should: [:r | r]
		conformTo: #'boolean' selector: #'eqv:'.
	self value: [true eqv: false] shouldnt: [:r | r]
		conformTo: #'boolean' selector: #'eqv:'.
	self value: [false eqv: true] shouldnt: [:r | r]
		conformTo: #'boolean' selector: #'eqv:'.
	self value: [false eqv: false] should: [:r | r]
		conformTo: #'boolean' selector: #'eqv:'.
! !

!BooleanANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXifFalseX
	" <boolean>#ifFalse: "
	#'Fundamental'.
	self value: [ false ifFalse: [0] ] should: [:r | r = 0]
		conformTo: #'boolean' selector: #'ifFalse:'.
	self value: [ true ifFalse: [0] ] should: [:r | true "unspecified"]
		conformTo: #'boolean' selector: #'ifFalse:'.
! !

!BooleanANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXifFalseXifTrueX
	" <boolean>#ifFalse:ifTrue: "
	#'Fundamental'.
	self value: [ false
				ifFalse: [0]
				ifTrue: [nil selector] ]
		should: [:r | r = 0]
		conformTo: #'boolean' selector: #'ifFalse:ifTrue:'.
	self value: [ true
				ifFalse: [nil selector]
				ifTrue: [1] ]
		should: [:r | r = 1]
		conformTo: #'boolean' selector: #'ifFalse:ifTrue:'.
! !

!BooleanANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXifTrueX
	" <boolean>#ifTrue: "
	#'Fundamental'.
	self value: [ true ifTrue: [1] ] should: [:r | r = 1]
		conformTo: #'boolean' selector: #'ifTrue:'.
	self value: [ false ifTrue: [1] ] should: [:r | true "unspecified"]
		conformTo: #'boolean' selector: #'ifTrue:'.
! !

!BooleanANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXifTrueXifFalseX
	" <boolean>#ifTrue:ifFalse: "
	#'Fundamental'.
	self value: [ true
				ifTrue: [ 1 ]
				ifFalse: [ nil selector ] ]
		should: [:r | r = 1]
		conformTo: #'boolean' selector: #'ifTrue:ifFalse:'.
	self value: [ false
				ifTrue: [ nil selector ]
				ifFalse: [ 0 ] ]
		should: [:r | r = 0]
		conformTo: #'boolean' selector: #'ifTrue:ifFalse:'.
! !

!BooleanANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXnot
	" <boolean>#not "
	#'Fundamental'.
	self value: [true not] should: [:r | r = false]
		conformTo: #'boolean' selector: #'not'.
	self value: [false not] should: [:r | r = true]
		conformTo: #'boolean' selector: #'not'.
! !

!BooleanANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXorOp
	" <boolean>#| "
	#'Fundamental'.
	self value: [true | true] should: [:r | r]
		conformTo: #'boolean' selector: #'|'.
	self value: [true | false] should: [:r | r]
		conformTo: #'boolean' selector: #'|'.
	self value: [false | true] should: [:r | r]
		conformTo: #'boolean' selector: #'|'.
	self value: [false | false] shouldnt: [:r | r]
		conformTo: #'boolean' selector: #'|'.
! !

!BooleanANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXorX
	" <boolean>#or: "
	#'Fundamental'.
	self value: [ true or: [true] ] should: [:r | r]
		conformTo: #'boolean' selector: #'or:'.
	self value: [ true or: [false] ] should: [:r | r]
		conformTo: #'boolean' selector: #'or:'.
	"No error:"
	self value: [ true or: [nil selector] ] should: [:r | r]
		conformTo: #'boolean' selector: #'or:'.

	self value: [ false or: [true] ] should: [:r | r]
		conformTo: #'boolean' selector: #'or:'.
	self value: [ false or: [nil isNil] ] should: [:r | r]
		conformTo: #'boolean' selector: #'or:'.
	self value: [ false or: [false] ] shouldnt: [:r | r]
		conformTo: #'boolean' selector: #'or:'.
	self value: [ false or: [nil notNil] ] shouldnt: [:r | r]
		conformTo: #'boolean' selector: #'or:'.

	self value: [ false or: [nil selector] ]
		shouldRaise: MessageNotUnderstood.
! !

!BooleanANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXprintString
	" <boolean>#printString "
	#'Fundamental'.
	self value: [true printString] should: [:r | r = 'true']
		conformTo: #'boolean' selector: #'printString'.
	self value: [false printString] should: [:r | r = 'false']
		conformTo: #'boolean' selector: #'printString'.
! !

!BooleanANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXxorX
	" <boolean>#xor: "
	#'Fundamental'.
	self value: [true xor: true] shouldnt: [:r | r]
		conformTo: #'boolean' selector: #'xor:'.
	self value: [true xor: false] should: [:r | r]
		conformTo: #'boolean' selector: #'xor:'.
	self value: [false xor: true] should: [:r | r]
		conformTo: #'boolean' selector: #'xor:'.
	self value: [false xor: false] shouldnt: [:r | r]
		conformTo: #'boolean' selector: #'xor:'.
! !

!BooleanANSITest methodsFor: 'constants' stamp: 'djm 3/15/2000 18:54'!
cannonicalObject
	^true! !

!BooleanANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 09:06'!
protocol
	^#boolean! !


!ByteArrayFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXnew
	" <ByteArray factory>#new "
	#'Collection'.
! !

!ByteArrayFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXnewX
	" <ByteArray factory>#new: "
	#'Collection'.
! !

!ByteArrayFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXwithAllX
	" <ByteArray factory>#withAll: "
	#'Collection'.
! !

!ByteArrayFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXwithX
	" <ByteArray factory>#with: "
	#'Collection'.
! !

!ByteArrayFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXwithXwithX
	" <ByteArray factory>#with:with: "
	#'Collection'.
! !

!ByteArrayFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXwithXwithXwithX
	" <ByteArray factory>#with:with:with: "
	#'Collection'.
! !

!ByteArrayFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXwithXwithXwithXwithX
	" <ByteArray factory>#with:with:with:with: "
	#'Collection'.
! !

!ByteArrayFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:38'!
cannonicalObject
	^ByteArray! !

!ByteArrayFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:39'!
protocol
	^#'ByteArray factory'! !


!CharacterANSITest methodsFor: 'constants' stamp: 'djm 3/15/2000 18:56'!
cannonicalObject
	^ Character space! !

!CharacterANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 09:08'!
protocol
^#Character! !

!CharacterANSITest methodsFor: 'testing' stamp: 'djm 3/15/2000 10:33'!
testXasLowercase
	" <Character>#asLowercase "
	#'Fundamental'.
"	If the receiver is equal to the value of a character literal in the receiver row of the following table, the result object must be equal to the value of the corresponding character literal in the result row.

	receiver	$A - $Z
	result		$a - $z

	An implemention may define other #asLowercase mappings.  If the receiver does not correspond to a character in the receiver row of the table and does not have an implementation defined mapping the receiver is returned as the result.
"
	self selector: #'asLowercase' inProtocol: #'Character' 
		behavesLike: #( #($A $a) #($b $b) #($1 $1) #($: $:) )
! !

!CharacterANSITest methodsFor: 'testing' stamp: 'djm 3/15/2000 17:59'!
testXasString
	" <Character>#asString "
	#'Fundamental'.
	self selector: #'asString' inProtocol: #'Character' 
		behavesLike: #( #($A 'A') #($B 'B') #($a 'a') #($1 '1') #($: ':') )

! !

!CharacterANSITest methodsFor: 'testing' stamp: 'djm 3/15/2000 10:35'!
testXasUppercase
	" <Character>#asUppercase "
	#'Fundamental'.
"	If the receiver is equal to the value of a character literal in the receiver row of the following table, the result object must be equal to the value of the corresponding character literal in the result row.

	receiver	$a - $z
	result		$A - $Z

	An implemention may define other #asUppercase mappings.  If the receiver does not correspond to a character in the receiver row of the table and does not have an implementation defined mapping the receiver is returned as the result.
"
	self selector: #'asUppercase' inProtocol: #'Character' 
		behavesLike: #( #($a $A) #($B $B) #($1 $1) #($: $:) )
! !

!CharacterANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXcodePoint
	" <Character>#codePoint "
	#'Fundamental'.
"	The following invariant must hold:

	(charFactory codePoint: x) codePoint = x

where charFactory is an object that implements <Character factory> and x is an <integer>.
"
	self value: [$a codePoint]
		should: [:r | (Character codePoint: r) codePoint = r]
		conformTo: #'Character' selector: #'codePoint'.
! !

!CharacterANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXisAlphaNumeric
	" <Character>#isAlphaNumeric "
	#'Fundamental'.
"	Return true if the receiver is either a letter or digit.  Otherwise return false.  In other words character isAlphaNumeric is true if and only if either character isLetter is true or character isDigit is true.
"
	self value: [$A isAlphaNumeric] should: [:r | r & ($A isLetter | $A isDigit)]
		conformTo: #'Character' selector: #'isAlphaNumeric'.
	self value: [$B isAlphaNumeric] should: [:r | r & ($B isLetter | $B isDigit)]
		conformTo: #'Character' selector: #'isAlphaNumeric'.
	self value: [$a isAlphaNumeric] should: [:r | r & ($a isLetter | $a isDigit)]
		conformTo: #'Character' selector: #'isAlphaNumeric'.
	self value: [$1 isAlphaNumeric] should: [:r | r & ($1 isLetter | $1 isDigit)]
		conformTo: #'Character' selector: #'isAlphaNumeric'.

	self value: [$: isAlphaNumeric] shouldnt: [:r | r & ($: isLetter | $: isDigit)]
		conformTo: #'Character' selector: #'isAlphaNumeric'.
! !

!CharacterANSITest methodsFor: 'testing' stamp: 'djm 3/15/2000 11:00'!
testXisDigit
	" <Character>#isDigit "
	#'Fundamental'.

	self 
		selector: #isDigit 
		inProtocol: #Character 
		behavesLike: #(#($1 true) #($A false) #($B false) #($b false) #($: false)).

! !

!CharacterANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXisLetter
	" <Character>#isLetter "
	| alphaChars |
	#'Fundamental'.
	alphaChars := #( $A $B $C $D $E $F $G $H $I $J $K $L $M
					$N $O $P $Q $R $S $T $U $V $W $X $Y $Z
					$a $b $c $d $e $f $g $h $i $j $k $l $m
					$n $o $p $q $r $s $t $u $v $w $x $y $z ).

	self value: [$A isLetter] should: [:r | r & (alphaChars includes: $A)]
		conformTo: #'Character' selector: #'isLetter'.
	self value: [$B isLetter] should: [:r | r & (alphaChars includes: $B)]
		conformTo: #'Character' selector: #'isLetter'.
	self value: [$a isLetter] should: [:r | r & (alphaChars includes: $a)]
		conformTo: #'Character' selector: #'isLetter'.

	self value: [$1 isLetter] shouldnt: [:r | r & (alphaChars includes: $1)]
		conformTo: #'Character' selector: #'isLetter'.
	self value: [$: isLetter] shouldnt: [:r | r & (alphaChars includes: $:)]
		conformTo: #'Character' selector: #'isLetter'.
! !

!CharacterANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXisLowercase
	" <Character>#isLowercase "
	| lowerChars |
	#'Fundamental'.
	lowerChars := #( $a $b $c $d $e $f $g $h $i $j $k $l $m
					$n $o $p $q $r $s $t $u $v $w $x $y $z ).

	self value: [$a isLowercase]
		should: [:r | r & (lowerChars includes: $a)]
		conformTo: #'Character' selector: #'isLowercase'.

	self value: [$A isLowercase]
		shouldnt: [:r | r & (lowerChars includes: $A)]
		conformTo: #'Character' selector: #'isLowercase'.
	self value: [$B isLowercase]
		shouldnt: [:r | r & (lowerChars includes: $B)]
		conformTo: #'Character' selector: #'isLowercase'.
	self value: [$1 isLowercase]
		shouldnt: [:r | r & (lowerChars includes: $1)]
		conformTo: #'Character' selector: #'isLowercase'.
	self value: [$: isLowercase]
		shouldnt: [:r | r & (lowerChars includes: $:)]
		conformTo: #'Character' selector: #'isLowercase'.
! !

!CharacterANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXisUppercase
	" <Character>#isUppercase "
	| upperChars |
	#'Fundamental'.
	upperChars := #( $A $B $C $D $E $F $G $H $I $J $K $L $M
					$N $O $P $Q $R $S $T $U $V $W $X $Y $Z ).

	self value: [$A isUppercase]
		should: [:r | r & (upperChars includes: $A)]
		conformTo: #'Character' selector: #'isUppercase'.
	self value: [$B isUppercase]
		should: [:r | r & (upperChars includes: $B)]
		conformTo: #'Character' selector: #'isUppercase'.

	self value: [$a isUppercase]
		shouldnt: [:r | r & (upperChars includes: $a)]
		conformTo: #'Character' selector: #'isUppercase'.
	self value: [$1 isUppercase]
		shouldnt: [:r | r & (upperChars includes: $1)]
		conformTo: #'Character' selector: #'isUppercase'.
	self value: [$: isUppercase]
		shouldnt: [:r | r & (upperChars includes: $:)]
		conformTo: #'Character' selector: #'isUppercase'.
! !


!CharacterFactoryANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 14:08'!
cannonicalObject
	^Character! !

!CharacterFactoryANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 14:33'!
protocol
	^#'Character factory'! !

!CharacterFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXcodePointX
	" <Character factory>#codePoint: "
	#'Fundamental'.
	self value: [Character codePoint: ($a codePoint)] should: [:r | r = $a]
		conformTo: #'Character factory' selector: #'codePoint:'.

	self value: [Character codePoint: 300] shouldRaise: Error.
! !

!CharacterFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXcr
	" <Character factory>#cr "
	#'Fundamental'.
	self value: [Character cr]
		should: [:r | true "implementation defined "]
		conformTo: #'Character factory' selector: #'cr'.
! !

!CharacterFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXlf
	" <Character factory>#lf "
	#'Fundamental'.
	self value: [Character lf]
		should: [:r | true "implementation defined "]
		conformTo: #'Character factory' selector: #'lf'.
! !

!CharacterFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXspace
	" <Character factory>#space "
	#'Fundamental'.
	self value: [Character space]
		should: [:r | true "implementation defined "]
		conformTo: #'Character factory' selector: #'space'.
! !

!CharacterFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXtab
	" <Character factory>#tab "
	#'Fundamental'.
	self value: [Character tab]
		should: [:r | true "implementation defined "]
		conformTo: #'Character factory' selector: #'tab'.
! !


!CollectionHelper methodsFor: 'testing' stamp: 'rej 5/26/2000 06:23'!
cannonicalObject
	^testCase cannonicalObject! !

!CollectionHelper methodsFor: 'testing'!
object
	^testCase cannonicalObject! !

!CollectionHelper methodsFor: 'testing'!
testXallSatisfyX
	" <collection>#allSatisfy: "
	#'Collection'.
! !

!CollectionHelper methodsFor: 'testing'!
testXanySatisfyX
	" <collection>#anySatisfy: "
	#'Collection'.
! !

!CollectionHelper methodsFor: 'testing'!
testXasArray
	" <collection>#asArray "
	#'Collection'.
	self assertSend: #asArray ! !

!CollectionHelper methodsFor: 'testing'!
testXasBag
	" <collection>#asBag "
	#'Collection'.
	self assertSend: #asBag
! !

!CollectionHelper methodsFor: 'testing'!
testXasByteArray
	" <collection>#asByteArray "
	#'Collection'.
	self assertSend: #asByteArray
! !

!CollectionHelper methodsFor: 'testing'!
testXasOrderedCollection
	" <collection>#asOrderedCollection "
	#'Collection'.
	self assertSend: #asOrderedCollection
! !

!CollectionHelper methodsFor: 'testing'!
testXasSet
	" <collection>#asSet "
	#'Collection'.
	self assertSend: #asSet
! !

!CollectionHelper methodsFor: 'testing'!
testXasSortedCollection
	" <collection>#asSortedCollection "
	#'Collection'.
	self assertSend: #asSortedCollection
! !

!CollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXasSortedCollectionX
	" <collection>#asSortedCollection: "
	#'Collection'.
! !

!CollectionHelper methodsFor: 'testing'!
testXcollectX
	" <collection>#collect: (Return Values: <RECEIVER>)"
	#'Collection'.
! !

!CollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXdetectX
	" <collection>#detect: "
	#'Collection'.
! !

!CollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXdetectXifNoneX
	" <collection>#detect:ifNone: "
	#'Collection'.
! !

!CollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXdoX
	" <sequencedReadableCollection>#do: "
	#'Collection'.
! !

!CollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXdoXseparatedByX
	" <collection>#do:separatedBy: "
	#'Collection'.
! !

!CollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXincludesX
	" <collection>#includes: "
	#'Collection'.
! !

!CollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXinjectXintoX
	" <collection>#inject:into: "
	#'Collection'.
! !

!CollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXisEmpty
	" <collection>#isEmpty "
	#'Collection'.
! !

!CollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXnotEmpty
	" <collection>#notEmpty "
	#'Collection'.
! !

!CollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXoccurrencesOfX
	" <collection>#occurrencesOf: "
	#'Collection'.
! !

!CollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXrehash
	" <collection>#rehash "
	#'Collection'.
! !

!CollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXrejectX
	" <collection>#reject: (Return Values: <RECEIVER>)"
	#'Collection'.
! !

!CollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXselectX
	" <collection>#select: (Return Values: <RECEIVER>)"
	#'Collection'.
! !

!CollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXsize
	" <collection>#size "
	#'Collection'.
! !

!CollectionHelper methodsFor: 'accessing' stamp: 'rej 5/27/2000 08:54'!
object: anObject! !


!CollectionHelper class methodsFor: 'initialize-release'!
initialize
	"CollectionHelper  initialize"
	super initialize! !


!ArrayANSITest methodsFor: 'constants' stamp: 'rej 5/25/2000 23:52'!
cannonicalObject
	^#(1 2 3 4)! !

!ArrayANSITest methodsFor: 'constants' stamp: 'rej 5/25/2000 23:53'!
protocol
	^#Array! !


!BagANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXaddAllX
	" <Bag>#addAll: "
	#'Collection'.
! !

!BagANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXaddX
	" <Bag>#add: "
	#'Collection'.
! !

!BagANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXaddXwithOccurrencesX
	" <Bag>#add:withOccurrences: "
	#'Collection'.
! !

!BagANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXremoveAllX
	" <extensibleCollection>#removeAll: "
	#'Collection'.
! !

!BagANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXremoveX
	" <extensibleCollection>#remove: "
	#'Collection'.
! !

!BagANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXremoveXifAbsentX
	" <extensibleCollection>#remove:ifAbsent: "
	#'Collection'.
! !

!BagANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:35'!
cannonicalObject
	^Bag with: 1 with: 2 with: 3 with: 4! !

!BagANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:36'!
protocol
	^#'Bag'! !


!ByteArrayANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:37'!
cannonicalObject
	^ByteArray with: 1 with: 2 with: 3 with: 4! !

!ByteArrayANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:38'!
protocol
	^#'ByteArray'! !


!CollectionTest class methodsFor: 'instance creation' stamp: 'rej 5/27/2000 07:37'!
helperClassesDo: aBlock
	super helperClassesDo: aBlock.
	aBlock value: CollectionHelper
! !


!ArrayANSITest class methodsFor: 'instance creation' stamp: 'rej 5/27/2000 08:43'!
helperClassesDo: aBlock
	super helperClassesDo: aBlock.
	aBlock value: SequencedCollectionHelper.
	aBlock value: SequencedReadableCollectionHelper
! !


!ByteArrayANSITest class methodsFor: 'instance creation' stamp: 'rej 5/27/2000 16:14'!
helperClassesDo: aBlock
	super helperClassesDo: aBlock.
	aBlock value: SequencedCollectionHelper.
	aBlock value: SequencedReadableCollectionHelper
! !


!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 10:39'!
setUp
	super setUp.
	d19970426t8 := DateAndTime
		year: 1997 month: 4 day: 26
		hour: 8 minute: 0 second: 0.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXaddOp
	" <DateAndTime>#+ "
	#'Date and Time'.
	self value: [d19970426t8
				+ (Duration days: 1 hours: 0 minutes: 0 seconds: 1)]
		should: [:r | r = (DateAndTime year: 1997 month: 4 day: 27
							hour: 8 minute: 0 second: 1)]
		conformTo: #'DateAndTime' selector: #'+'.

	self value: [d19970426t8
				+ (Duration days: -1 hours: 0 minutes: 0 seconds: -1)]
		should: [:r | r = (DateAndTime year: 1997 month: 4 day: 25
							hour: 7 minute: 59 second: 59)]
		conformTo: #'DateAndTime' selector: #'+'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXasLocal
	" <DateAndTime>#asLocal "
	#'Date and Time'.
#todo. "??? I'm not sure how to test. ???"
	self value: [d19970426t8 asLocal] should: [:r | true]
		conformTo: #'DateAndTime' selector: #'asLocal'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXasUTC
	" <DateAndTime>#asUTC "
	#'Date and Time'.
#todo. "??? I'm not sure how to test. ???"
	self value: [d19970426t8 asUTC]
		should: [:r | "Invariant:" r offset = Duration zero]
		conformTo: #'DateAndTime' selector: #'asUTC'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXbetweenXandX
	" <magnitude>#between:and: "
	#'Date and Time'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXdayOfMonth
	" <DateAndTime>#dayOfMonth "
	#'Date and Time'.
	self value: [d19970426t8 dayOfMonth] should: [:r | r = 26]
		conformTo: #'DateAndTime' selector: #'dayOfMonth'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXdayOfWeek
	" <DateAndTime>#dayOfWeek "
	#'Date and Time'.
	self value: [d19970426t8 dayOfWeek] should: [:r | r = 7]
		conformTo: #'DateAndTime' selector: #'dayOfWeek'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXdayOfWeekAbbreviation
	" <DateAndTime>#dayOfWeekAbbreviation "
	#'Date and Time'.
	self value: [d19970426t8 dayOfWeekAbbreviation]
		should: [:r | r asString = 'Sat']
		conformTo: #'DateAndTime' selector: #'dayOfWeekAbbreviation'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXdayOfWeekName
	" <DateAndTime>#dayOfWeekName "
	#'Date and Time'.
	self value: [d19970426t8 dayOfWeekName] should: [:r | r asString = 'Saturday']
		conformTo: #'DateAndTime' selector: #'dayOfWeekName'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXdayOfYear
	" <DateAndTime>#dayOfYear "
	#'Date and Time'.
	self value: [d19970426t8 dayOfYear] should: [:r | r = 116]
		conformTo: #'DateAndTime' selector: #'dayOfYear'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'RAH 6/23/2000 14:22'!
testXequalityOp
	" <DateAndTime>#="
	"Changed 2000/06/23 Harmon, R. Needs Daylight Savings Fix."
	| d19970426t8CST d19970426t7MST d19970426t7CST tmp1 tmp2 |
	#'Date and Time'.
	d19970426t8CST := DateAndTime year: 1997 month: 4 day: 26
								hour: 8 minute: 0 second: 0.
	"1997-04-26T08:00:00-06:00 CST"
	self	value: [d19970426t8 = d19970426t8CST]
		should: [:r | r & (d19970426t8 hash = d19970426t8CST hash)]
		conformTo: #DateAndTime selector: #=.

	d19970426t8CST := DateAndTime year: 1997 month: 4 day: 26
								hour: 8 minute: 0 second: 0.
	"1997-04-26T08:00:00-06:00 CST"
	tmp1 := DateAndTime year: 1996 month: 4 day: 26
						hour: 5 minute: 59 second: 50
						offset: (Duration seconds: -10).
	tmp2 := DateAndTime year: 1996 month: 4 day: 26
						hour: 6 minute: 0 second: 10
						offset: (Duration seconds: 10).
	self	value: [tmp1 = tmp2]
		should: [:r | r & (tmp1 hash = tmp2 hash)]
		conformTo: #DateAndTime selector: #=.

	d19970426t7MST := DateAndTime year: 1997 month: 4 day: 26
							hour: 7 minute: 0 second: 0
							offset: (Duration days: 0 hours: -7
									minutes: 0 seconds: 0).
	"1997-04-26T07:00:00-07:00 MST"
#todo.">>>Fails because d19970426t7MST is Daylight Savings not Standard.
	self	value: [d19970426t8 = d19970426t7MST]
		should: [:r | r & (d19970426t8 hash = d19970426t7MST hash)]
		conformTo: #DateAndTime selector: #=.
<<<"
	d19970426t7CST := DateAndTime year: 1996 month: 4 day: 27
								hour: 7 minute: 0 second: 0.
	"1997-04-26T07:00:00-07:00 MST"
	self value: [d19970426t8 = d19970426t7CST]
		shouldnt: [:r | r & (d19970426t8 hash = d19970426t7CST hash)]
		conformTo: #DateAndTime selector: #=.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXgreaterThanOp
	" <DateAndTime>#> "
	#'Date and Time'.
	self value: [(DateAndTime year: 1997 month: 4 day: 27
					hour: 8 minute: 0 second: 1) > d19970426t8]
		should: [:r | r] conformTo: #'DateAndTime' selector: #'>'.
	self value: [(DateAndTime year: 2000 month: 4 day: 27
				hour: 8 minute: 0 second: 0) > d19970426t8]
		should: [:r | r] conformTo: #'DateAndTime' selector: #'>'.

	self value: [(DateAndTime year: 1996 month: 4 day: 27
				hour: 7 minute: 0 second: 0) > d19970426t8]
		shouldnt: [:r | r] conformTo: #'DateAndTime' selector: #'>'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXgreaterThanOrEqualToOp
	" <magnitude>#>= "
	#'Date and Time'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXhour
	" <DateAndTime>#hour "
	#'Date and Time'.
	self value: [d19970426t8 hour] should: [:r | r = 8]
		conformTo: #'DateAndTime' selector: #'hour'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXhour12
	" <DateAndTime>#hour12 "
	#'Date and Time'.
	self value: [d19970426t8 hour12] should: [:r | r = 8]
		conformTo: #'DateAndTime' selector: #'hour12'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXhour24
	" <DateAndTime>#hour24 "
	#'Date and Time'.
	self value: [d19970426t8 hour24] should: [:r | r = 8]
		conformTo: #'DateAndTime' selector: #'hour24'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXisLeapYear
	" <DateAndTime>#isLeapYear "
	#'Date and Time'.
	self value: [d19970426t8 isLeapYear] shouldnt: [:r | r]
		conformTo: #'DateAndTime' selector: #'isLeapYear'.

	self value: [(DateAndTime year: 1996 month: 2 day: 1
				hour: 0 minute: 0 second: 0 ) isLeapYear]
		should: [:r | r]
		conformTo: #'DateAndTime' selector: #'isLeapYear'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXlessThanOp
	" <DateAndTime>#< "
	#'Date and Time'.
	self value: [d19970426t8 < (DateAndTime year: 1997 month: 4 day: 27
							hour: 8 minute: 0 second: 1)]
		should: [:r | r] conformTo: #'DateAndTime' selector: #'<'.
	self value: [d19970426t8 < (DateAndTime year: 2000 month: 4 day: 27
							hour: 8 minute: 0 second: 0)]
		should: [:r | r] conformTo: #'DateAndTime' selector: #'<'.

	self value: [d19970426t8 < (DateAndTime year: 1996 month: 4 day: 27
							hour: 7 minute: 0 second: 0)]
		shouldnt: [:r | r] conformTo: #'DateAndTime' selector: #'<'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXlessThanOrEqualToOp
	" <magnitude>#<= "
	#'Date and Time'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXmaxX
	" <magnitude>#max: "
	#'Date and Time'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXmeridianAbbreviation
	" <DateAndTime>#meridianAbbreviation "
	#'Date and Time'.
	self value: [d19970426t8 meridianAbbreviation] should: [:r | r asString = 'AM']
		conformTo: #'DateAndTime' selector: #'meridianAbbreviation'.

	self value: [(DateAndTime year: 1996 month: 2 day: 1
				hour: 12 minute: 0 second: 0 ) meridianAbbreviation]
		should: [:r | r asString = 'PM']
		conformTo: #'DateAndTime' selector: #'meridianAbbreviation'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXminX
	" <magnitude>#min: "
	#'Date and Time'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXminute
	" <DateAndTime>#minute "
	#'Date and Time'.
	self value: [d19970426t8 minute] should: [:r | r = 0]
		conformTo: #'DateAndTime' selector: #'minute'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXmonth
	" <DateAndTime>#month "
	#'Date and Time'.
	self value: [d19970426t8 month] should: [:r | r = 4]
		conformTo: #'DateAndTime' selector: #'month'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXmonthAbbreviation
	" <DateAndTime>#monthAbbreviation "
	#'Date and Time'.
	self value: [d19970426t8 monthAbbreviation] should: [:r | r asString = 'Apr']
		conformTo: #'DateAndTime' selector: #'monthAbbreviation'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXmonthName
	" <DateAndTime>#monthName "
	#'Date and Time'.
	self value: [d19970426t8 monthName] should: [:r | r asString = 'April']
		conformTo: #'DateAndTime' selector: #'monthName'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXoffset
	" <DateAndTime>#offset "
	| d19970426t8Tmp off123 |
	#'Date and Time'.
	off123 := Duration days: 0 hours: 1 minutes: 2 seconds: 3.
	d19970426t8Tmp := DateAndTime year: 1997 month: 4 day: 26
						hour: 0 minute: 0 second: 0 offset: off123.
	self value: [d19970426t8Tmp offset] should: [:r | r = off123]
		conformTo: #'DateAndTime' selector: #'offset'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXoffsetX
	" <DateAndTime>#offset: "
	| d19970426t08Tmp off123 |
	#'Date and Time'.
#todo. "??? Add int, flt, frac offset: tests. ???"
	off123 := Duration days: 0 hours: 1 minutes: 2 seconds: 3.
	d19970426t08Tmp := DateAndTime year: 1997 month: 4 day: 26
				hour: 0 minute: 0 second: 0 offset: (Duration zero).
	self value: [(d19970426t08Tmp offset: off123)]
		should: [:r | r = (DateAndTime year: 1997 month: 4 day: 26
						hour: 0 minute: 0 second: 0 offset: off123)]
		conformTo: #'DateAndTime' selector: #'offset:'.
	"Invariant:"
	self should: [(d19970426t08Tmp offset: off123) offset = off123].
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXprintString
	" <DateAndTime>#printString "
	#'Date and Time'.
	self value: [(DateAndTime year: 1997 month: 4 day: 26
				hour: 1 minute: 2 second: 3
				offset: (Duration days: 0 hours: 1 minutes: 2 seconds: 3) 			) printString]
		should: [:r | r = ' 1997-04-26T01:02:03+01:02:3']
		conformTo: #'DateAndTime' selector: #'printString'.

	"Example: 8:33:14.321 PM EST January 5, 1200 B.C. 
		'-1199-01-05T20:33:14.321-05:00'
		8:33:14.321 PM -> 20:33:14.321 24 hour"
#'testAnom'. "??? '  0701-01-05T20:33:14-05:00' wrong--not neg.
		-> '-1199-01-05T20:33:14-05:00'
	self value: [(DateAndTime year: -1199 month: 1 day: 5
				hour: 20 minute: 33 second: 14
				offset: (Duration hours: -5 ??EST??)) printString]
		should: [:r | r = '-1199-01-05T20:33:14.321-05:00']
		conformTo: #'DateAndTime' selector: #'printString'.
???"
	"Example: 12 midnight UTC January 1,  2001 A.D. 
			' 2001-01-01T00:00:00+00:00'"
	self value: [(DateAndTime year: 2001 month: 1 day: 1
				hour: 0 minute: 0 second: 0
				offset: Duration zero) printString]
		should: [:r | r = ' 2001-01-01T00:00:00+00:00']
		conformTo: #'DateAndTime' selector: #'printString'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXsecond
	" <DateAndTime>#second "
	#'Date and Time'.
	self value: [d19970426t8 second] should: [:r | r = 0]
		conformTo: #'DateAndTime' selector: #'second'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXsubtractOp
	" <DateAndTime>#- "
	#'Date and Time'.
	"If operand is a <DateAndTime>, answer a <Duration>."
	self value: [d19970426t8 - (DateAndTime year: 1997 month: 4 day: 26
								hour: 7 minute: 0 second: 0)]
		should: [:r | (r isKindOf: Duration)
				& r = (Duration days: 0 hours: 1 minutes: 0 seconds: 0)]
		conformTo: #'DateAndTime' selector: #'-'.
	self value: [d19970426t8 - (DateAndTime year: 1998 month: 4 day: 26
									hour: 7 minute: 0 second: 0)]
		should: [:r | (r isKindOf: Duration)
			& r = (Duration days: -364 hours: -23 minutes: 0 seconds: 0)]
		conformTo: #'DateAndTime' selector: #'-'.
	"If operand is a <Duration>, answer a new <DateAndTime>"
	self value: [d19970426t8 - (Duration days: 1 hours: 0
		minutes: 0 seconds: 1)]
		should: [:r | (r isKindOf: DateAndTime)
					& r = (DateAndTime year: 1997 month: 4 day: 25
							hour: 7 minute: 59 second: 59)]
		conformTo: #'DateAndTime' selector: #'-'.
	self value: [d19970426t8 - (Duration days: -1 hours: 0
		minutes: 0 seconds: -1)]
		should: [:r | (r isKindOf: DateAndTime)
					& r = (DateAndTime year: 1997 month: 4 day: 27
							hour: 8 minute: 0 second: 1)]
		conformTo: #'DateAndTime' selector: #'-'.
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'RAH 6/23/2000 14:27'!
testXtimeZoneAbbreviation
	" <DateAndTime>#timeZoneAbbreviation "
	"Changed 2000/06/23 Harmon, R. Needs Daylight Savings Fix."
	| offTmp |
	#'Date and Time'.
#'testAnom'.">>>
	offTmp := Duration days: 0 hours: -5 minutes: 0 seconds: 0.

	self value: [(d19970426t8 offset: offTmp) timeZoneAbbreviation]
		should: [:r | r asString = 'EST']
		conformTo: #'DateAndTime' selector: #'timeZoneAbbreviation'.
<<<"

#todo.">>>Fails because d19970426t7MST is Daylight Savings not Standard.
	offTmp := Duration days: 0 hours: -6 minutes: 0 seconds: 0.
	self value: [(d19970426t8 offset: offTmp) timeZoneAbbreviation]
		should: [:r | r asString = 'CST']
		conformTo: #'DateAndTime' selector: #'timeZoneAbbreviation'.
<<<"
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'RAH 6/23/2000 14:24'!
testXtimeZoneName
	" <DateAndTime>#timeZoneName "
	"Changed 2000/06/23 Harmon, R. Needs Daylight Savings Fix."
	| offTmp |
	#'Date and Time'.
#'testAnom'.">>>
	offTmp := Duration days: 0 hours: -5 minutes: 0 seconds: 0.
	self value: [(d19970426t8 offset: offTmp) timeZoneName]
		should: [:r | r asString = 'EST']
		conformTo: #'DateAndTime' selector: #'timeZoneName'.
<<<"

#todo.">>>Fails because d19970426t7MST is Daylight Savings not Standard.
	offTmp := Duration days: 0 hours: -6 minutes: 0 seconds: 0.
	self value: [(d19970426t8 offset: offTmp) timeZoneName]
		should: [:r | r asString = 'Central Standard Time']
		conformTo: #'DateAndTime' selector: #'timeZoneName'.
<<<"
! !

!DateAndTimeANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXyear
	" <DateAndTime>#year "
	#'Date and Time'.
	self value: [d19970426t8 year] should: [:r | r = 1997]
		conformTo: #'DateAndTime' selector: #'year'.
! !

!DateAndTimeANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:52'!
cannonicalObject
	^DateAndTime year: 2000 month: 3 day: 16 hour: 16 minute: 49 second: 43! !

!DateAndTimeANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:45'!
protocol
	^#'DateAndTime'! !


!DateAndTimeFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXclockPrecision
	" <DateAndTime factory>#clockPrecision "
	#'Date and Time'.
	self value: [DateAndTime clockPrecision]
		should: [:r | "unspecified" true]
		conformTo: #'DateAndTime factory' selector: #'clockPrecision'.
! !

!DateAndTimeFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnow
	" <DateAndTime factory>#now "
	#'Date and Time'.
	self value: [DateAndTime now] should: [:r | "unspecified" true]
		conformTo: #'DateAndTime factory' selector: #'now'.
! !

!DateAndTimeFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXyearXdayXhourXminuteXsecondX
	" <DateAndTime factory>#year:day:hour:minute:second: "
	#'Date and Time'.
#'todo'. "??? finish impl this. ???"
	"April 26, 1997 CST"
	self value: [DateAndTime year: 1997 day: 116
				hour: 1 minute: 2 second: 3]
		should: [:r | (r year = 1997) & (r month = 4)
					& (r dayOfMonth = 26)
					& (r hour = 1) & (r minute = 2) & (r second = 3)]
		conformTo: #'DateAndTime factory'
		selector: #'year:day:hour:minute:second:'.
! !

!DateAndTimeFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXyearXdayXhourXminuteXsecondXoffsetX
	" <DateAndTime factory>#year:day:hour:minute:second:offset: "
	#'Date and Time'.
#'todo'. "??? finish impl this. ???"
	"April 26, 1997 CST"
	self value: [DateAndTime year: 1997 day: 116
				hour: 1 minute: 2 second: 3
						offset: (Duration hours: -6 "CST")]
		should: [:r | (r year = 1997) & (r month = 4)
					& (r dayOfMonth = 26)
					& (r hour = 1) & (r minute = 2) & (r second = 3)]
		conformTo: #'DateAndTime factory'
		selector: #'year:day:hour:minute:second:offset:'.
! !

!DateAndTimeFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXyearXmonthXdayXhourXminuteXsecondX
	" <DateAndTime factory>#year:month:day:hour:minute:second: "
	#'Date and Time'.
#'todo'. "??? finish impl this. ???"
	"April 26, 1997 CST"
	self value: [DateAndTime year: 1997 month: 4 day: 26
						hour: 1 minute: 2 second: 3]
		should: [:r | (r year = 1997) & (r month = 4) & (r dayOfMonth = 26)
					& (r hour = 1) & (r minute = 2) & (r second = 3).
			]
		conformTo: #'DateAndTime factory'
		selector: #'year:month:day:hour:minute:second:'.
! !

!DateAndTimeFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXyearXmonthXdayXhourXminuteXsecondXoffsetX
	" <DateAndTime factory>#year:month:day:hour:minute:second:offset: "
	#'Date and Time'.
#'todo'. "??? finish impl this. ???"
	"April 26, 1997 CST"
	self value: [DateAndTime year: 1997 month: 4 day: 26
						hour: 1 minute: 2 second: 3
						offset: (Duration hours: -6 "CST")]
		should: [:r | (r year = 1997) & (r month = 4) & (r dayOfMonth = 26)
					& (r hour = 1) & (r minute = 2) & (r second = 3)]
		conformTo: #'DateAndTime factory'
		selector: #'year:month:day:hour:minute:second:offset:'.
! !

!DateAndTimeFactoryANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:44'!
cannonicalObject
	^DateAndTime! !

!DateAndTimeFactoryANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:40'!
protocol
	^#'DateAndTime factory'! !


!DictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXaddAllX
	" <abstractDictionary>#addAll: "
	#'Collection'.
! !

!DictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXatX
	" <abstractDictionary>#at: "
	#'Collection'.
! !

!DictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXatXifAbsentPutX
	" <abstractDictionary>#at:ifAbsentPut: "
	#'Collection'.
! !

!DictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXatXifAbsentX
	" <abstractDictionary>#at:ifAbsent: "
	#'Collection'.
! !

!DictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXatXputX
	" <abstractDictionary>#at:put: "
	#'Collection'.
! !

!DictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXincludesKeyX
	" <abstractDictionary>#includesKey: "
	#'Collection'.
! !

!DictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXkeyAtValueX
	" <abstractDictionary>#keyAtValue: "
	#'Collection'.
! !

!DictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXkeyAtValueXifAbsentX
	" <abstractDictionary>#keyAtValue:ifAbsent: "
	#'Collection'.
! !

!DictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXkeys
	" <abstractDictionary>#keys "
	#'Collection'.
! !

!DictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXkeysAndValuesDoX
	" <abstractDictionary>#keysAndValuesDo: "
	#'Collection'.
! !

!DictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXkeysDoX
	" <abstractDictionary>#keysDo: "
	#'Collection'.
! !

!DictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXremoveAllKeysX
	" <abstractDictionary>#removeAllKeys: "
	#'Collection'.
! !

!DictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXremoveAllKeysXifAbsentX
	" <abstractDictionary>#removeAllKeys:ifAbsent: "
	#'Collection'.
! !

!DictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXremoveKeyX
	" <abstractDictionary>#removeKey: "
	#'Collection'.
! !

!DictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXremoveKeyXifAbsentX
	" <abstractDictionary>#removeKey:ifAbsent: "
	#'Collection'.
! !


!DictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:14'!
testXvalues
	" <abstractDictionary>#values "
	#'Collection'.
! !

!DictionaryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:59'!
cannonicalObject
	^Dictionary new at: 1 put: 1; at: 2 put: 2; at:3 put: 3; at:4 put: 4; yourself! !

!DictionaryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:41'!
protocol
	^#'Dictionary'! !


!DictionaryFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXnew
	" <Dictionary factory>#new "
	#'Collection'.
! !

!DictionaryFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXnewX
	" <Dictionary factory>#new: "
	#'Collection'.
! !

!DictionaryFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXwithAllX
	" <Dictionary factory>#withAll: "
	#'Collection'.
! !

!DictionaryFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:42'!
cannonicalObject
	^Dictionary! !

!DictionaryFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:42'!
protocol
^#'Dictionary factory'! !


!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 10:40'!
setUp
	super setUp.
	off0123 := Duration days: 0 hours: 1 minutes: 2 seconds: 3.
	smallInt2 := 2.
	largeNegInt2000000000 := -2000000000.
	largePosInt2000000000 := 2000000000.
	float2 := 2.0.
	fractionHalf := 1/2.
	numList := Array new: 5.
	numList at: 1 put: smallInt2.
	numList at: 2 put: largeNegInt2000000000.
	numList at: 3 put: largePosInt2000000000.
	numList at: 4 put: float2.
	numList at: 5 put: fractionHalf.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXabs
	" <Duration>#abs "
	| absDuration rcvr |
	#'Date and Time'.
	absDuration := Duration days: 0 hours: 1 minutes: 2 seconds: 3.

	self value: [off0123 abs] should: [:r | r = absDuration]
		conformTo: #'Duration' selector: #'abs' opRECEIVER: off0123.

	rcvr := Duration days: 0 hours: -1 minutes: -2 seconds: -3.

	self value: [rcvr abs] should: [:r | r = absDuration]
		conformTo: #'Duration' selector: #'abs' opRECEIVER: rcvr.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXaddOp
	" <Duration>#+ "
	#'Date and Time'.
	self value: [off0123 + (Duration days: 1 hours: 1 minutes: 1 seconds: 1)]
		should: [:r | r = (Duration days: 1 hours: 2 minutes: 3 seconds: 4)]
		conformTo: #'Duration' selector: #'+'
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXasSeconds
	" <Duration>#asSeconds "
	#'Date and Time'.
	self value: [off0123 asSeconds] should: [:r | r = 3723]
		conformTo: #'Duration' selector: #'asSeconds'.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXbetweenXandX
	" <magnitude>#between:and: "
	#'Date and Time'.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXdays
	" <Duration>#days "
	#'Date and Time'.
	self value: [off0123 days] should: [:r | r = 0]
		conformTo: #'Duration' selector: #'days'.
	self value: [(Duration days: 9 hours: 0 minutes: 2 seconds: 0) days]
		should: [:r | r = 9]
		conformTo: #'Duration' selector: #'days'.

	self value: [(Duration days: -9 hours: -1 minutes: -2 seconds: -3) days]
		should: [:r | r = -9]
		conformTo: #'Duration' selector: #'days'.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXdivideOp
	" <Duration>#/ "
	| retVals |
	#'Date and Time'.
	retVals := Array new: 5.
	"If operand is a <number> answer a new <Duration>."
	"#( 2 -2000000000 2000000000 2.0 1/2 )"
	retVals at: 1 put: (Duration days: 0 hours: 0 minutes: 31 seconds: 1.5).
	retVals at: 2 put: (Duration days: -0 hours: 0
								minutes: 0 seconds: -01.8615e-6).
	retVals at: 3 put: (Duration days: 0 hours: 0
								minutes: 0 seconds: 1.8615e-6).
	retVals at: 4 put: (Duration days: 0 hours: 0 minutes: 31 seconds: 1.5).
	retVals at: 5 put: (Duration days: 0 hours: 2 minutes: 4 seconds: 6).
	
#'testAnom'. "??? <Object> float = test give false for  -0:00:00:01.8615e-6
	1 to: numList size do: [ :ndx |
		self value: [off0123 / (numList at: ndx)]
			should: [:r | (r isKindOf: Duration)
						and: [r = (retVals at: ndx)] ]
			conformTo: #'Duration' selector: #'/'
	].
???"
	"If operand is a <Duration> answer a <number>."
	"#( 2 -2000000000 2000000000 2.0 1/2 )"
	retVals at: 1 put: (3723/2).
	retVals at: 2 put: (-3723/2000000000).
	retVals at: 3 put: (3723/2000000000).
	retVals at: 4 put: 1861.5.
	retVals at: 5 put: 7446.0.
	1 to: numList size do: [ :ndx |
		self value: [off0123 / (Duration seconds: (numList at: ndx))]
			should: [:r | (r isKindOf: Number)
						and: [r = (retVals at: ndx)] ]
			conformTo: #'Duration' selector: #'/'
	].
	self value: [off0123 / 0] shouldRaise: ZeroDivide.
	self value: [off0123 / (Duration zero)] shouldRaise: ZeroDivide.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXequalityOp
	" <Duration>#= "
	| tmpDuration |
	#'Date and Time'.
	tmpDuration := (Duration days: 0 hours: 1 minutes: 2 seconds: 3).
	self value: [off0123 = tmpDuration] should: [:r | r]
		conformTo: #'Duration' selector: #'='.
	self should: [off0123 hash = tmpDuration hash].
	tmpDuration := (Duration days: 1 hours: 1 minutes: 1 seconds: 1).
	self value: [off0123 = tmpDuration] shouldnt: [:r | r]
		conformTo: #'Duration' selector: #'='.
	self shouldnt: [off0123 hash = tmpDuration hash].
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXgreaterThanOp
	" <Duration>#> "
	#'Date and Time'.
	self value: [(Duration days: 1 hours: 1 minutes: 1 seconds: 1)
				> off0123]
		should: [:r | r]
		conformTo: #'Duration' selector: #'>'.
	self value: [(Duration days: 0 hours: 1 minutes: 2 seconds: 3)
				> off0123]
		shouldnt: [:r | r]
		conformTo: #'Duration' selector: #'>'.
	self value: [off0123 > 0] shouldRaise: Error.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXgreaterThanOrEqualToOp
	" <magnitude>#>= "
	#'Date and Time'.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXhours
	" <Duration>#hours "
	#'Date and Time'.
	self value: [off0123 hours] should: [:r | r = 1]
		conformTo: #'Duration' selector: #'hours'.
	self value: [(Duration days: 9 hours: 0 minutes: 2 seconds: 0) hours]
		should: [:r | r = 0]
		conformTo: #'Duration' selector: #'hours'.
	self value: [(Duration days: -9 hours: -1 minutes: -2 seconds: -3) hours]
		should: [:r | r = -1]
		conformTo: #'Duration' selector: #'hours'.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXlessThanOp
	" <Duration>#< "
	#'Date and Time'.
	self value: [off0123
				< (Duration days: 1 hours: 1 minutes: 1 seconds: 1)]
		should: [:r | r]
		conformTo: #'Duration' selector: #'<'.

	self value: [off0123
				< (Duration days: 0 hours: 1 minutes: 2 seconds: 3)]
		shouldnt: [:r | r]
		conformTo: #'Duration' selector: #'<'.
	self value: [off0123 < 0] shouldRaise: Error.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXlessThanOrEqualToOp
	" <magnitude>#<= "
	#'Date and Time'.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXmaxX
	" <magnitude>#max: "
	#'Date and Time'.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXminX
	" <magnitude>#min: "
	#'Date and Time'.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXminutes
	" <Duration>#minutes "
	#'Date and Time'.
	self value: [off0123 minutes] should: [:r | r = 2]
		conformTo: #'Duration' selector: #'minutes'.
	self value: [(Duration days: 9 hours: 0 minutes: 0 seconds: 0) minutes]
		should: [:r | r = 0]
		conformTo: #'Duration' selector: #'minutes'.
	self value: [(Duration days: -9 hours: -1 minutes: -2 seconds: -3) minutes]
		should: [:r | r = -2]
		conformTo: #'Duration' selector: #'minutes'.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXmultiplyOp
	" <Duration>#* "
	| retVals |
	#'Date and Time'.
	retVals := Array new: 5.		"#( 2 -2000000000 2000000000 2.0 1/2 )"
	retVals at: 1 put: (Duration days: 0 hours: 2 minutes: 4 seconds: 6).
	retVals at: 2 put: (Duration days: -86180555 hours: -13
								minutes: -20 seconds: 0).
	retVals at: 3 put: (Duration days: 86180555 hours: 13
								minutes:  20 seconds: 0).
	retVals at: 4 put: (Duration days: 0 hours: 2 minutes: 4 seconds: 6).
	retVals at: 5 put: (Duration days: 0 hours: 0 minutes: 31 seconds: 1.5).
	
	1 to: numList size do: [ :ndx |
		self value: [off0123 * (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'Duration' selector: #'*'
	].
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnegated
	" <Duration>#negated "
	| negatedDuration rcvr |
	#'Date and Time'.
	negatedDuration := Duration days: 0 hours: -1 minutes: -2 seconds: -3.

	self value: [off0123 negated] should: [:r | r = negatedDuration]
		conformTo: #'Duration' selector: #'negated' opRECEIVER: off0123.

	self value: [negatedDuration negated] should: [:r | r = off0123]
		conformTo: #'Duration' selector: #'negated'
		opRECEIVER: negatedDuration.

	rcvr := Duration zero.

	self value: [rcvr negated] should: [:r | r = (Duration zero)]
		conformTo: #'Duration' selector: #'negated' opRECEIVER: rcvr.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnegative
	" <Duration>#negative "
	#'Date and Time'.
	self value: [off0123 negative] shouldnt: [:r | r]
		conformTo: #'Duration' selector: #'negative'.
	self value: [(Duration days: 0 hours: -1 minutes: -2 seconds: -3) negative]
		should: [:r | r]
		conformTo: #'Duration' selector: #'negative'.
	self value: [(Duration zero) negative] shouldnt: [:r | r]
		conformTo: #'Duration' selector: #'negative'.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXpositive
	" <Duration>#positive "
	#'Date and Time'.
	self value: [off0123 positive] should: [:r | r]
		conformTo: #'Duration' selector: #'positive'.
	self value: [(Duration days: 0 hours: -1 minutes: -2 seconds: -3) positive]
		shouldnt: [:r | r]
		conformTo: #'Duration' selector: #'positive'.
	self value: [(Duration zero) positive] should: [:r | r]
		conformTo: #'Duration' selector: #'positive'.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXprintString
	" <Duration>#printString "
	#'Date and Time'.
	self value: [off0123 printString] should: [:r | r = '0:01:02:03']
		conformTo: #'Duration' selector: #'printString'.
	self value: [(Duration days: 0 hours: -1 minutes: -2 seconds: -3.5) printString]
		should: [:r | r = '-0:01:02:03.5']
		conformTo: #'Duration' selector: #'printString'.
	self value: [(Duration zero) printString] should: [:r | r = '0:00:00:00']
		conformTo: #'Duration' selector: #'printString'.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXseconds
	" <Duration>#seconds "
	#'Date and Time'.
	self value: [off0123 seconds] should: [:r | r = 3]
		conformTo: #'Duration' selector: #'seconds'.
	self value: [(Duration days: 9 hours: 0 minutes: 0 seconds: 0) seconds]
		should: [:r | r = 0]
		conformTo: #'Duration' selector: #'seconds'.
	self value: [(Duration days: -9 hours: -1 minutes: -2 seconds: -3.5) seconds]
		should: [:r | r = -3.5]
		conformTo: #'Duration' selector: #'seconds'.
! !

!DurationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXsubtractOp
	" <Duration>#- "
	#'Date and Time'.
	self value: [off0123 - (Duration days: 1 hours: 1 minutes: 1 seconds: 1)]
		should: [:r | r = (Duration days:-0 hours:-23 minutes:-58 seconds:-58)]
		conformTo: #'Duration' selector: #'-'
! !

!DurationANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:47'!
cannonicalObject
	^Duration seconds: 500000000
	! !

!DurationANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:46'!
protocol
	^#'Duration'! !


!DurationFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXdaysXhoursXminutesXsecondsX
	" <Duration factory>#days:hours:minutes:seconds: "
	#'Date and Time'.
#'todo'. "??? finish impl this. ???"
	self value: [(Duration days: 0 hours: 1 minutes: 2 seconds: 3)]
		should: [:r | r = (Duration days: 0 hours: 1 minutes: 2 seconds: 3)]
		conformTo: #'Duration factory'
		selector: #'days:hours:minutes:seconds:'.
! !

!DurationFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXsecondsX
	" <Duration factory>#seconds: "
	#'Date and Time'.
#'todo'. "??? finish impl this. ???"
	"((1 * (24 * 60 * 60) + (1 * (60 * 60)) + (1 * 60) + 1)) -> 90061"
	self value: [(Duration seconds: 3)]
		should: [:r | r = (Duration days: 0 hours: 0 minutes: 0 seconds: 3)]
		conformTo: #'Duration factory' selector: #'seconds:'.
! !

!DurationFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXzero
	" <Duration factory>#zero "
	#'Date and Time'.
	self value: [Duration zero] should: [:r | r asSeconds = 0]
		conformTo: #'Duration factory' selector: #'seconds:'.
! !

!DurationFactoryANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:07'!
cannonicalObject
	^Duration! !

!DurationFactoryANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:06'!
protocol
	^#'Duration factory'! !


!DyadicValuableANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 10:31'!
setUp
	super setUp.
	blk2args := [ :arg1 :arg2 | Array with: arg1 with: arg2 ].
! !

!DyadicValuableANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXargumentCount
	" <dyadicValuable>#argumentCount "
	#'Valuable'.
	self value: [blk2args argumentCount] should: [:r | r = 2]
		conformTo: #'dyadicValuable' selector: #'argumentCount'.
! !

!DyadicValuableANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXvalueWithArgumentsX
	" <valuable>#valueWithArguments: "
	#'Valuable'.
	self value: [blk2args valueWithArguments: #(1 2)]
		should: [:r | r = #(1 2)]
		conformTo: #'valuable' selector: #'valueWithArguments:'.
! !

!DyadicValuableANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXvalueXvalueX
	" <dyadicValuable>#value:value: "
	#'Valuable'.
	self value: [blk2args value: 1 value: 2] should: [:r | r = #(1 2)]
		conformTo: #'dyadicValuable' selector: #'value:value:'.
! !

!DyadicValuableANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:31'!
cannonicalObject
	^blk2args! !

!DyadicValuableANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 15:19'!
protocol
	^#'dyadicValuable'! !


!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXclass
	" <Object>#class "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXdefaultAction
	" <Error>#defaultAction "
	#'Exception'.
#'todo'."??? I don't know what to test here.
	self value: [Error signal] should: [:r | true ??UNSPECIFIED??]
		conformTo: #'Error' selector: #'defaultAction'.
???"

	self value: [Error signal] shouldRaise: Error.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXdescription
	" <exceptionDescription>#description "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXdoesNotUnderstandX
	" <Object>#doesNotUnderstand: "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXequalityOp
	" <Object>#= "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXerrorX
	" <Object>#error: "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXhash
	" <Object>#hash "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXidentityHash
	" <Object>#identityHash "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXidentityOp
	" <Object>#== "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXisKindOfX
	" <Object>#isKindOf: "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXisMemberOfX
	" <Object>#isMemberOf: "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/15/2000 13:15'!
testXisNested
	" <signaledException>#isNested "
	#'Exception'.

	self value: [ [ Error signal ] on: Error do: [ :exception |
					exception return: exception isNested ] ]
		should: [:r | r ]
		conformTo: #'signaledException' selector: #'isNested'.! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXisNil
	" <Object>#isNil "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXisResumable
	" <Error>#isResumable "
	#'Exception'.
	self value: [ [ Error signal ] on: Error do: [ :aError |
					aError return: aError isResumable ] ]
		shouldnt: [:r | r] conformTo: #'Error' selector: #'isResumable'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXmessageText
	" <exceptionDescription>#messageText "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXmessageTextX
	" <exceptionBuilder>#messageText: (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXnotEqualityOp
	" <Object>#~= "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXnotIdentityOp
	" <Object>#~~ "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXnotNil
	" <Object>#notNil "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXouter
	" <signaledException>#outer "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXpass
	" <signaledException>#pass "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXperformX
	" <Object>#perform: "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXperformXwithArgumentsX
	" <Object>#perform:withArguments: "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXperformXwithX
	" <Object>#perform:with: "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXperformXwithXwithX
	" <Object>#perform:with:with: "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXperformXwithXwithXwithX
	" <Object>#perform:with:with:with: "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXprintOnX
	" <Object>#printOn: "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXprintString
	" <Object>#printString "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXresignalAsX
	" <signaledException>#resignalAs: "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXrespondsToX
	" <Object>#respondsTo: "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXresume
	" <signaledException>#resume "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXresumeX
	" <signaledException>#resume: "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXretry
	" <signaledException>#retry "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXretryUsingX
	" <signaledException>#retryUsing: "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXreturn
	" <signaledException>#return "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXreturnX
	" <signaledException>#return: "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXsignal
	" <exceptionSignaler>#signal "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXsignalX
	" <exceptionSignaler>#signal: "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXtag
	" <exceptionDescription>#tag "
	#'Exception'.
! !

!ErrorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXyourself
	" <Object>#yourself (Return Values: <RECEIVER>) "
	#'Exception'.
! !


!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXallSubclasses
	" <classDescription>#allSubclasses "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXallSuperclasses
	" <classDescription>#allSuperclasses "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXclass
	" <Object>#class "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXconcatenateOp
	" <exceptionSelector>#, "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXdoesNotUnderstandX
	" <Object>#doesNotUnderstand: "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXequalityOp
	" <Object>#= "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXerrorX
	" <Object>#error: "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXhandlesX
	" <Exception class>#handles: "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXhash
	" <Object>#hash "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXidentityHash
	" <Object>#identityHash "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXidentityOp
	" <Object>#== "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXisKindOfX
	" <Object>#isKindOf: "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXisMemberOfX
	" <Object>#isMemberOf: "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXisNil
	" <Object>#isNil "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXname
	" <classDescription>#name "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXnew
	" <Error class>#new "
	#'Exception'.
	self value: [Error new] should: [:r | true "??? r = Error signal ???"]
		conformTo: #'Error class' selector: #'new'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXnotEqualityOp
	" <Object>#~= "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXnotIdentityOp
	" <Object>#~~ "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXnotNil
	" <Object>#notNil "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXperformX
	" <Object>#perform: "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXperformXwithArgumentsX
	" <Object>#perform:withArguments: "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXperformXwithX
	" <Object>#perform:with: "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXperformXwithXwithX
	" <Object>#perform:with:with: "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXperformXwithXwithXwithX
	" <Object>#perform:with:with:with: "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXprintOnX
	" <Object>#printOn: "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXprintString
	" <Object>#printString "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXrespondsToX
	" <Object>#respondsTo: "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXsignal
	" <Exception class>#signal "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXsignalX
	" <exceptionSignaler>#signal: "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXsubclasses
	" <classDescription>#subclasses "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXsuperclass
	" <classDescription>#superclass "
	#'Exception'.
! !

!ErrorClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXyourself
	" <Object>#yourself (Return Values: <RECEIVER>) "
	#'Exception'.
! !


!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/16/2000 16:55'!
exceptionOuterReturn

	^[[Exception signal]
		on: Exception
		do:
			[:except |
			except outer.
			unchanged := false]]
				on: Exception
				do: [:except | except return: true]! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/16/2000 17:01'!
exceptionPass
	" <signaledException>#pass "
	^[[Exception signal]
		on: Exception
		do:
			[:ex |
			ex pass.
			unchanged := false]]
				on: Exception
				do:
					[:ex |
					changed := true.
					ex return]

	"conformTo: #'signaledException' selector: #'pass'."
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/16/2000 17:07'!
exceptionReturn
	^[Exception signal]
		on: Exception
		do:
			[:except |
			except return.
			unchanged := false]
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/17/2000 14:22'!
mustBeBoolean: anObject
	self should: [anObject == true or: [anObject == false]].! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 15:35'!
notificationOuterDefault
"A bug in Squeak's #outer leads this next thing to an infinite loop ..."
"	value := 1.
	value := [Notification signal]
		on: Notification
		do:
			[:except |
			except outer.
			unchanged := false]. 
"! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/16/2000 16:55'!
notificationOuterResume

	[[changed := Notification signal]
		on: Notification
		do:
			[:except |
			except outer.
			unchanged := false]]
				on: Notification
				do: [:except | except resume: true]! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/17/2000 14:36'!
resignalExceptionAsNotification

	| firstTime |
	firstTime := true.
	^[[Exception signal]
		on: Exception
		do:
			[:ex |
			firstTime
				ifTrue:
					[firstTime := false.
					ex resignalAs: Notification new.
					unchanged := false]
				ifFalse: [ex pass]]]
				on: Notification
				do: [:ex | ex return: true]
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/17/2000 14:29'!
resignalNotificationAsException
	^[[Notification signal]
		on: Notification
		do:
			[:ex |
			ex resignalAs: Exception new.
			unchanged := false]]
				on: Exception
				do:
					[:ex | ex return: true]
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/17/2000 14:46'!
resumedException
	^[[Exception signal] 
		on: Exception 
		do: 
			[:except |
			except resume: false. "Exception isn't resumable - this throws an exception"
			unchanged := false]]
				on: Exception
				do:
					[:ex | ex return: true]
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/17/2000 14:48'!
resumedExceptionWithValue
	^[[Exception signal] 
		on: Exception 
		do: 
			[:except |
			except resume: false.
			unchanged := false]]
				on: Exception
				do:
					[:ex | ex return: true]
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/16/2000 19:27'!
resumedNotification
	[value := Notification signal] 
		on: Notification 
		do: 
			[:except |
			except resume.
			unchanged := false]
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/16/2000 19:26'!
resumedNotificationWithValue
	[changed := Notification signal] 
		on: Notification 
		do: 
			[:except |
			except resume: true.
			unchanged := false]
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/16/2000 14:24'!
setUp
	unchanged := true.
	value := nil.
	changed := false.! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/17/2000 14:16'!
signalExceptionNestedWithError
	^[[Exception signal]
		on: Exception
		do: [:exception | exception return: exception isNested]]
			on: Error
			do: [:error | error return]! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/17/2000 14:16'!
signalNestedException
	^[[Exception signal]
		on: Exception
		do: [:exception | exception return: exception isNested]]
			on: Exception
			do: [:exception | exception return]! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/17/2000 14:17'!
signalUnnestedException
	^[Exception signal]
		on: Exception 
		do: [:exception | exception return: exception isNested]! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXclass
	" <Object>#class "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/16/2000 15:08'!
testXdefaultAction
	" <exceptionDescription>#defaultAction "
	self should: [Notification signal == nil]! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/16/2000 19:10'!
testXdescription
	" <exceptionDescription>#description "
	| exception messageText |
"not sure - spec only says that default should be something 'readable'; well, at least it shouldn't be nil ..."
	self shouldnt: [Exception new description == nil].
	exception := Exception new.
	messageText := 'our chief weapon is fear'.
	exception messageText: messageText.
	self shouldnt: [(exception description indexOfSubCollection: messageText) = 0].! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXdoesNotUnderstandX
	" <Object>#doesNotUnderstand: "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXequalityOp
	" <Object>#= "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXerrorX
	" <Object>#error: "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXhash
	" <Object>#hash "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXidentityHash
	" <Object>#identityHash "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXidentityOp
	" <Object>#== "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXisKindOfX
	" <Object>#isKindOf: "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXisMemberOfX
	" <Object>#isMemberOf: "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/16/2000 16:50'!
testXisNested
	" <signaledException>#isNested "
	self shouldnt: [self signalUnnestedException].
	self shouldnt: [self signalExceptionNestedWithError].
	self should: [self signalNestedException].
"	conformTo: #'signaledException' selector: #'isNested'."! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXisNil
	" <Object>#isNil "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/17/2000 14:22'!
testXisResumable
	" <exceptionDescription>#isResumable "
	#'Exception'.
	self mustBeBoolean: Exception new isResumable.
	self shouldnt: [Error new isResumable].
	self should: [Notification new isResumable].
	self should: [ZeroDivide new isResumable].
	self should: [MessageNotUnderstood new isResumable].! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/17/2000 14:25'!
testXmessageText
	" <exceptionDescription>#messageText "
	| exception messageText |
	exception := Exception new.
	self should: [exception messageText == nil].
	messageText := 'our chief weapon is fear'.
	exception messageText: messageText.
	self should: [exception messageText = messageText].! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/16/2000 18:12'!
testXmessageTextX
	" <exceptionBuilder>#messageText: (Return Values: <RECEIVER>) "
	#'Exception'.! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXnotEqualityOp
	" <Object>#~= "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXnotIdentityOp
	" <Object>#~~ "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXnotNil
	" <Object>#notNil "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/16/2000 16:58'!
testXouter
	" <signaledException>#outer "
	#'Exception'.
	changed := self exceptionOuterReturn.
	self should: [changed and: [unchanged]].
	self setUp.
	value := self notificationOuterDefault.
	self should: [value == nil and: [unchanged]].
	self setUp.
	self notificationOuterResume.
	self should: [changed and: [unchanged]].

! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/16/2000 17:02'!
testXpass
	" <signaledException>#pass "
	self exceptionPass.
	self should: [changed and: [unchanged]]! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXperformX
	" <Object>#perform: "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXperformXwithArgumentsX
	" <Object>#perform:withArguments: "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXperformXwithX
	" <Object>#perform:with: "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXperformXwithXwithX
	" <Object>#perform:with:with: "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXperformXwithXwithXwithX
	" <Object>#perform:with:with:with: "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXprintOnX
	" <Object>#printOn: "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXprintString
	" <Object>#printString "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/16/2000 16:45'!
testXresignalAsX
	" <signaledException>#resignalAs: "
	changed := self resignalNotificationAsException.
	self should: [changed and: [unchanged]].
	self setUp.
	changed := self resignalExceptionAsNotification.
	self should: [changed and: [unchanged]].
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXrespondsToX
	" <Object>#respondsTo: "
	#'Exception'.
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/16/2000 19:28'!
testXresume
	" <signaledException>#resume "
	value := 1.
	self resumedNotification.
	self should: [(value == nil) and: [unchanged]].
	self setUp.
	changed := self resumedException.
	self should: [changed and: [unchanged]]! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/17/2000 14:49'!
testXresumeX
	" <signaledException>#resume: "
	self resumedNotificationWithValue.
	self should: [changed and: [unchanged]].
	self setUp.
	changed := self resumedExceptionWithValue.
	self should: [changed and: [unchanged]]! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/17/2000 14:55'!
testXretry
	" <signaledException>#retry "
	| firstTime |
	firstTime := true.
	[firstTime
		ifTrue: [Exception signal] 
		ifFalse: [changed := true]]
			on: Exception 
			do: 
				[:except |
				firstTime := false.
				except retry.
				unchanged := false].
	self should: [changed and: [unchanged]]
! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/17/2000 14:56'!
testXretryUsingX
	" <signaledException>#retryUsing: "
	[Exception signal]
		on: Exception
		do:
			[:except |
			except retryUsing: [changed := true].
			unchanged := false].
	self should: [changed and: [unchanged]]! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/17/2000 14:57'!
testXreturn
	" <signaledException>#return "
	value := 1.
	value := self exceptionReturn.
	self should: [value == nil and: [unchanged]]! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/17/2000 14:58'!
testXreturnX
	" <signaledException>#return: "
	changed := [Exception signal]
		on: Exception
		do:
			[:except |
			except return: true.
			unchanged := false].
	self should: [changed and: [unchanged]]! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/15/2000 15:12'!
testXsignal
	" <exceptionSignaler>#signal "
	#'Exception'.
	"tested by the zillion other sends of signal"! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/15/2000 15:10'!
testXsignalX
	" <exceptionSignaler>#signal: "
	#'Exception'.
	"tested by the zillion other sends of signal"! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/17/2000 15:01'!
testXtag
	" <exceptionDescription>#tag "
	| exception messageText |
	exception := Exception new.
	self should: [exception tag == nil].
	messageText := 'our chief weapon is fear'.
	exception messageText: messageText.
	self should: [exception tag = messageText].
	exception tag: 1.
	self should: [exception tag = 1].! !

!ExceptionANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXyourself
	" <Object>#yourself (Return Values: <RECEIVER>) "
	#'Exception'.
! !


!ExceptionANSITest class methodsFor: 'instance creation' stamp: 'rej 6/5/2000 21:44'!
suite
	^TestSuite new! !


!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXallSubclasses
	" <classDescription>#allSubclasses "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXallSuperclasses
	" <classDescription>#allSuperclasses "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXclass
	" <Object>#class "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXconcatenateOp
	" <exceptionSelector>#, "
	#'Exception'.
	self value: [ Exception, Error ]
		should: [:r | true "(r class = (self protocolTestsMgr classAt: 'exceptionSet'))"
					and: [(r handles: (Exception new))
							& (r handles: (Error new))] ]
		conformTo: #'exceptionSelector' selector: #','.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXdoesNotUnderstandX
	" <Object>#doesNotUnderstand: "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXequalityOp
	" <Object>#= "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXerrorX
	" <Object>#error: "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXhandlesX
	" <Exception class>#handles: "
	#'Exception'.
	self value: [ [ Exception signal ] on: Exception do: [ :except |
					except return: (Exception  handles: except) ] ]
		should: [:r | r]
		conformTo: #'Exception class' selector: #'handles:'.


	self value: [ [ Exception signal ] on: Exception do: [ :except |
					except return: (Error  handles: except) ] ]
		shouldnt: [:r | r]
		conformTo: #'Exception class' selector: #'handles:'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXhash
	" <Object>#hash "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXidentityHash
	" <Object>#identityHash "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXidentityOp
	" <Object>#== "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXisKindOfX
	" <Object>#isKindOf: "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXisMemberOfX
	" <Object>#isMemberOf: "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:01'!
testXisNil
	" <Object>#isNil "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXname
	" <classDescription>#name "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnew
	" <Exception class>#new "
	#'Exception'.
	self value: [Exception new] should: [:r | true "??? r = Exception signal ???"]
		conformTo: #'Exception class' selector: #'new'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotEqualityOp
	" <Object>#~= "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotIdentityOp
	" <Object>#~~ "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotNil
	" <Object>#notNil "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformX
	" <Object>#perform: "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithArgumentsX
	" <Object>#perform:withArguments: "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithX
	" <Object>#perform:with: "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithX
	" <Object>#perform:with:with: "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithXwithX
	" <Object>#perform:with:with:with: "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintOnX
	" <Object>#printOn: "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintString
	" <Object>#printString "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXrespondsToX
	" <Object>#respondsTo: "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsignal
	" <Exception class>#signal "
	#'Exception'.
	self value: [ [Exception signal] on: Exception do: [ :except | except return ] ]
		should: [:r | true "unspecified"]
		conformTo: #'Exception class' selector: #'signal'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsignalX
	" <exceptionSignaler>#signal: "
	#'Exception'.
#'todo'."??? I don't know what to test here.
	[	Exception signal
	] on: Exception do: [ :anException | anException signal: ??? ].

	self op: [xxx] should: [:r | xxx]
		conformTo: #'exceptionDescription' selector: #'signal:'.

	self should: [ [xxx] ensure: [ flag := 1 ] ]
		raise: Exception.
???"
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsubclasses
	" <classDescription>#subclasses "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!

testXsuperclass
	" <classDescription>#superclass "
	#'Exception'.
! !

!ExceptionClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXyourself
	" <Object>#yourself (Return Values: <RECEIVER>) "
	#'Exception'.
! !


!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXclass
	" <Object>#class "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXconcatenateOp
	" <exceptionSet>#, "
	#'Exception'.
	self value: [ Warning, Error ]
		should: [:r | "(r class = (self protocolTestsMgr classAt: 'exceptionSet'))"
			true		and: [(r handles: (Warning new))
							& (r handles: (Error new))] ]
		conformTo: #'exceptionSet' selector: #','.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdoesNotUnderstandX
	" <Object>#doesNotUnderstand: "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXequalityOp
	" <Object>#= "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXerrorX
	" <Object>#error: "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXhandlesX
	" <exceptionSelector>#handles: "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXhash
	" <Object>#hash "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityHash
	" <Object>#identityHash "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityOp
	" <Object>#== "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisKindOfX
	" <Object>#isKindOf: "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisMemberOfX
	" <Object>#isMemberOf: "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisNil
	" <Object>#isNil "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotEqualityOp
	" <Object>#~= "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotIdentityOp
	" <Object>#~~ "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotNil
	" <Object>#notNil "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformX
	" <Object>#perform: "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithArgumentsX
	" <Object>#perform:withArguments: "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithX
	" <Object>#perform:with: "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithX
	" <Object>#perform:with:with: "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithXwithX
	" <Object>#perform:with:with:with: "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintOnX
	" <Object>#printOn: "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintString
	" <Object>#printString "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXrespondsToX
	" <Object>#respondsTo: "
	#'Exception'.
! !

!ExceptionSetANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXyourself
	" <Object>#yourself (Return Values: <RECEIVER>) "
	#'Exception'.
! !


!FailedMessageANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 10:21'!
setUp
	"Make a failed message and put it in failedMsg"
	super setUp.
	[nil foo] on: MessageNotUnderstood do: [:ex | failedMsg := ex message].
! !

!FailedMessageANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXarguments
	" <failedMessage>#arguments "
	#'Fundamental'.

#todo. "???
	self op: [failedMsg := nil.
			self + 1.
			failedMsg arguments]
		should: [:r | r size = 1 & (r first = 1) ]
		conformTo: #'failedMessage' selector: #'arguments'.

	self op: [failedMsg := nil.
			self dum.
			failedMsg arguments]
		should: [:r | r size = 0]
		conformTo: #'failedMessage' selector: #'arguments'.

	self op: [failedMsg := nil.
			self dum: 1 dum: 2 dum: 3.
			failedMsg arguments]
		should: [:r | r size = 3 & (r first = 1) & (r last = 3) ]
		conformTo: #'failedMessage' selector: #'arguments'.

???"
! !

!FailedMessageANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXselector
	" <failedMessage>#selector "
	#'Fundamental'.

#todo. "???
	self op: [failedMsg := nil.
			self + 1.
			failedMsg selector]
		should: [:r | r = #'+']
		conformTo: #'failedMessage' selector: #'selector'.

	self op: [failedMsg := nil.
			self dum.
			failedMsg selector]
		should: [:r | r = #'dum']
		conformTo: #'failedMessage' selector: #'selector'.

	self op: [failedMsg := nil.
			self dum: 1 dum: 2 dum: 3.
			failedMsg selector]
		should: [:r | r = #'dum:dum:dum:']
		conformTo: #'failedMessage' selector: #'selector'.

???"
! !

!FailedMessageANSITest methodsFor: 'constants' stamp: 'djm 3/17/2000 18:16'!
cannonicalObject
	"Return a Message object, which is created when the VM traps a misunderstood message"
	^failedMsg! !

!FailedMessageANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 15:07'!
protocol
	^#'failedMessage'! !


!FileStreamFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXreadX
	" <FileStream factory>#read: "
	#'File Stream'.
! !

!FileStreamFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXreadXtypeX
	" <FileStream factory>#read:type: "
	#'File Stream'.
! !

!FileStreamFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXwriteX
	" <FileStream factory>#write: "
	#'File Stream'.
! !

!FileStreamFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXwriteXmodeX
	" <FileStream factory>#write:mode: "
	#'File Stream'.
! !

!FileStreamFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXwriteXmodeXcheckXtypeX
	" <FileStream factory>#write:mode:check:type: "
	#'File Stream'.
! !

!FileStreamFactoryANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:52'!
cannonicalObject
	^FileStream! !

!FileStreamFactoryANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:52'!
protocol
	^#'FileStream factory'! !


!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 10:33'!
setUp
	super setUp.
	smallInt2 := 2.
	largeNegInt2000000000 := -2000000000.
	largePosInt2000000000 := 2000000000.
	float2 := 2.0.
	fractionHalf := 1/2.
	sclDec2s3 := 2.0s3.
	numList := Array new: 6.
	numList at: 1 put: smallInt2.
	numList at: 2 put: largeNegInt2000000000.
	numList at: 3 put: largePosInt2000000000.
	numList at: 4 put: float2.
	numList at: 5 put: fractionHalf.

	numList at: 6 put: sclDec2s3.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testLiterals
	#'Numeric'.
	self should: [1.1e1 = 11.0].
	self should: [1.1d1 = 11.0].
	self should: [1.1q1 = 11.0].
	"Not ANSI conforming:"
#todo. "??? fix ???"
"	self shouldnt: [1.0q = 1.0].
	self shouldnt: [10e10 = 1.0].
"! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:00'!
testXabs
	" <number>#abs (Return Values: <RECEIVER>) "
	| rcvr |
	#'Numeric'.
	rcvr := 2.0.
	self value: [rcvr abs] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'abs' opRECEIVER: rcvr.
	rcvr := -2.0.
	self value: [rcvr abs] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'abs' opRECEIVER: rcvr.
	rcvr := 0.0.
	self value: [rcvr abs] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'abs' opRECEIVER: rcvr.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:00'!
testXaddOp
	" <number>#+ (returnRule - :receiver :operand) "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(4.0 -1999999998.0 2000000002.0 4.0 2.5 4.0).
	1 to: numList size do: [ :ndx |
		self value: [float2 + (numList at: ndx)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'+'
			ruleReceiver: float2 operand: (numList at: ndx)
	].
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:00'!
testXarcCos
	" <Float>#arcCos "
	#'Numeric'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:00'!
testXarcSin
	" <Float>#arcSin "
	#'Numeric'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:00'!
testXarcTan
	" <Float>#arcTan "
	#'Numeric'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:00'!
testXasFloat
	" <number>#asFloat "
	#'Numeric'.
	self value: [2.0 asFloat] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'asFloat'.
	self value: [-2.0 asFloat] should: [:r | r = -2.0]
		conformTo: #'number' selector: #'asFloat'.
	self value: [0.0 asFloat] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'asFloat'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:00'!
testXasFloatD
	" <number>#asFloatD "
	#'Numeric'.
	self value: [2.0 asFloatD] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'asFloatD'.
	self value: [-2.0 asFloatD] should: [:r | r = -2.0]
		conformTo: #'number' selector: #'asFloatD'.
	self value: [0.0 asFloatD] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'asFloatD'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:00'!
testXasFloatE
	" <number>#asFloatE "
	#'Numeric'.
	self value: [2.0 asFloatE] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'asFloatE'.
	self value: [-2.0 asFloatE] should: [:r | r = -2.0]
		conformTo: #'number' selector: #'asFloatE'.
	self value: [0.0 asFloatE] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'asFloatE'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:00'!
testXasFloatQ
	" <number>#asFloatQ "
	#'Numeric'.
	self value: [2.0 asFloatQ] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'asFloatQ'.
	self value: [-2.0 asFloatQ] should: [:r | r = -2.0]
		conformTo: #'number' selector: #'asFloatQ'.
	self value: [0.0 asFloatQ] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'asFloatQ'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasFraction
	" <number>#asFraction "
	#'Numeric'.
	self value: [2.0 asFraction] should: [:r | r = 2]
		conformTo: #'number' selector: #'asFraction'.
	self value: [-2.5 asFraction] should: [:r | r = (-5/2)]
		conformTo: #'number' selector: #'asFraction'.
	self value: [0.0 asFraction] should: [:r | r = 0]
		conformTo: #'number' selector: #'asFraction'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasInteger
	" <number>#asInteger "
	#'Numeric'.
	self value: [2.0 asInteger] should: [:r | r = 2]
		conformTo: #'number' selector: #'asInteger'.
	self value: [2.1 asInteger] should: [:r | r = 2]
		conformTo: #'number' selector: #'asInteger'.
	self value: [2.5 asInteger] should: [:r | r = 3]
		conformTo: #'number' selector: #'asInteger'.
	self value: [-2.0 asInteger] should: [:r | r = -2]
		conformTo: #'number' selector: #'asInteger'.
	self value: [-2.1 asInteger] should: [:r | r = -2]
		conformTo: #'number' selector: #'asInteger'.
	self value: [-2.5 asInteger] should: [:r | r = -3]
		conformTo: #'number' selector: #'asInteger'.
	self value: [0.0 asInteger] should: [:r | r = 0]
		conformTo: #'number' selector: #'asInteger'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasScaledDecimalX
	" <number>#asScaledDecimal: "
	#'Numeric'.
	self value: [2.0 asScaledDecimal: 2]
		should: [:r | r = 2.0s2 & (r scale = 2)]
		conformTo: #'number' selector: #'asScaledDecimal:'.
	self value: [-2.0 asScaledDecimal: 2]
		should: [:r | r = -2.0s2 & (r scale = 2)]
		conformTo: #'number' selector: #'asScaledDecimal:'.
	self value: [0.0 asScaledDecimal: 2]
		should: [:r | r = 0.0s2 & (r scale = 2)]
		conformTo: #'number' selector: #'asScaledDecimal:'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXbetweenXandX
	" <magnitude>#between:and: "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
#'todo'."It is erroneous if the receiver  and min or max are not comparable"

	self value: [2.0 between: 1 and: 3]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [-2000000002.0 between: -2000000003 and: -2000000001]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2000000002.0 between: 2000000001 and: 2000000003]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2.0 between: 1.0 and: 3.0]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2.0 between: (3/2) and: (5/2)]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2.0 between: 1.0s3 and: 3.0s3]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.

	self value: [2.0 between: (3/2) and: 2000000003]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2.0 between: -2000000001 and: 3.0s3]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.

	"Num between: Num and: Num -> true"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx)
					between: (numList at: ndx)
					and: (numList at: ndx)]
			should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'
	].

	self value: [2.0 between: 3 and: 4]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [-2000000000.0 between: -2000000003 and: -2000000005]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2000000000.0 between: 2000000003 and: 2000000005]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2.0 between: 3.0 and: 5.0]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2.0 between: (5/2) and: (7/2)]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2.0 between: 3.0s3 and: 5.0s3]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.

	"??? min not min but max and vice versa -> false ???"
	self value: [2.0 between: 3 and: 1]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXceiling
	" <number>#ceiling "
	#'Numeric'.
	self value: [2.0 ceiling] should: [:r | r = 2]
		conformTo: #'number' selector: #'ceiling'.
	self value: [2.1 ceiling] should: [:r | r = 3]
		conformTo: #'number' selector: #'ceiling'.
	self value: [2.5 ceiling] should: [:r | r = 3]
		conformTo: #'number' selector: #'ceiling'.
	self value: [-2.0 ceiling] should: [:r | r = -2]
		conformTo: #'number' selector: #'ceiling'.
	self value: [-2.1 ceiling] should: [:r | r = -2]
		conformTo: #'number' selector: #'ceiling'.
	self value: [-2.5 ceiling] should: [:r | r = -2]
		conformTo: #'number' selector: #'ceiling'.
	self value: [0.0 ceiling] should: [:r | r = 0]
		conformTo: #'number' selector: #'ceiling'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Numeric'.
"	Return a new object that must be as similar as possible to the receiver in its initial state and behavior.  Any operation that changes the state of the new object should not as a side-effect change the state or behavior of the receiver.  Similarly, any change to the receiver should not as a side-effect change the new object.
	If the receiver is an identity object, return the receiver.
"
#todo. "??? add change-side-effect test ???"
	self value: [float2 copy] should: [:r | (r = float2) & (r ~~ float2)]
		conformTo: #'Object' selector: #'copy' opRECEIVER: float2.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXcos
	" <Float>#cos "
	#'Numeric'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXdegreesToRadians
	" <Float>#degreesToRadians "
	#'Numeric'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXdivideOp
	" <number>#/ (returnRule - :receiver :operand) "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(1.0 -1.0e-9 1.0e-9 1.0 4.0  1.0).
	1 to: numList size do: [ :ndx |
		self value: [float2 / (numList at: ndx)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'/'
			ruleReceiver: float2 operand: (numList at: ndx)
	].

	self value: [0.0 / float2] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'/'
		ruleReceiver: float2 operand: 0.0.

	"The implementation must either signal the ZeroDivide exception
		or provide a continuation value."
	self value: [float2 / 0.0] shouldRaise: ZeroDivide.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXequalityOp
	" <Float>#= "
	#'Numeric'.
"
	receiver = comparand	=>
	receiver hash = comparand hash
"
	self value: [float2 = float2]
		should: [:r | r & (float2 hash = float2 hash) ]
		conformTo: #'Float' selector: #'='.
	self value: [ float2 = 2.1 ]
		shouldnt: [ :r | r | (float2 hash = 2.1 hash) ]
		conformTo: #'Float' selector: #'='.

"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	self value: [ float2 = 2 ]
		should: [ :r | r  ifTrue: [ float2 hash = 2 hash ]
							ifFalse: [ float2 hash ~= 2 hash ]  ]
		conformTo: #'Float' selector: #'='.
	self value: [ -2000000000.0 = -2000000000 ]
		should: [ :r | r ifTrue: [ -2000000000.0 hash = -2000000000 hash ]
						ifFalse: [ -2000000000.0 hash ~= -2000000000 hash ]  ]
		conformTo: #'Float' selector: #'='.

	self value: [ 2000000000.0 = 2000000000 ]
		should: [ :r | r ifTrue: [ 2000000000.0 hash = 2000000000 hash ]
						ifFalse: [ 2000000000.0 hash ~= 2000000000 hash ]  ]
		conformTo: #'Float' selector: #'='.
	self value: [ 2.5 = (5/2) ]
		should: [ :r | r ifTrue: [ 2.5 hash = (5/2) hash ]
						ifFalse: [ 2.5 hash ~= (5/2) hash ]  ]
		conformTo: #'Float' selector: #'='.
	self value: [ float2 = 2.0s3 ]
		should: [ :r | r ifTrue: [ float2 hash = 2.0s3 hash ]
						ifFalse: [ float2 hash ~= 2.0s3 hash ]  ]
		conformTo: #'Float' selector: #'='.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXexp
	" <Float>#exp "
	#'Numeric'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXfloor
	" <number>#floor "
	#'Numeric'.
	self value: [2.0 floor] should: [:r | r = 2]
		conformTo: #'number' selector: #'floor'.
	self value: [2.1 floor] should: [:r | r = 2]
		conformTo: #'number' selector: #'floor'.
	self value: [2.5 floor] should: [:r | r = 2]
		conformTo: #'number' selector: #'floor'.
	self value: [-2.0 floor] should: [:r | r = -2]
		conformTo: #'number' selector: #'floor'.
	self value: [-2.1 floor] should: [:r | r = -3]
		conformTo: #'number' selector: #'floor'.
	self value: [-2.5 floor] should: [:r | r = -3]
		conformTo: #'number' selector: #'floor'.
	self value: [0.0 floor] should: [:r | r = 0]
		conformTo: #'number' selector: #'floor'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXfloorLogX
	" <Float>#floorLog: "
	#'Numeric'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXfractionPart
	" <number>#fractionPart (Return Values: <RECEIVER>)"
	| rcvr |
	#'Numeric'.
	"Within the limits of representation, the following invariants should hold:

		receiver integerPart + receiver fractionPart = receiver
		receiver \\1 = receiver fractionPart	(RAH - erroneous, add #'abs')
"
	rcvr := 26.5.
	self value: [rcvr fractionPart]
		should: [:r | r = 0.5 & (rcvr integerPart + rcvr fractionPart = rcvr)
					& (rcvr \\ 1 = rcvr fractionPart abs)]
		conformTo: #'number' selector: #'fractionPart' opRECEIVER: rcvr.

	rcvr := -26.5.
	self value: [rcvr fractionPart]
		should: [:r | r = -0.5 & (rcvr integerPart + rcvr fractionPart = rcvr)
					& (rcvr \\ 1 = rcvr fractionPart abs)]
		conformTo: #'number' selector: #'fractionPart' opRECEIVER: rcvr.

	rcvr := 26.0.
	self value: [rcvr fractionPart]
		should: [:r | r = 0.0 & (rcvr integerPart + rcvr fractionPart = rcvr)
					& (rcvr \\ 1 = rcvr fractionPart abs)]
		conformTo: #'number' selector: #'fractionPart' opRECEIVER: rcvr.

	rcvr := 0.0.
	self value: [rcvr fractionPart]
		should: [:r | r = 0.0 & (rcvr integerPart + rcvr fractionPart = rcvr)
					& (rcvr \\ 1 = rcvr fractionPart abs)]
		conformTo: #'number' selector: #'fractionPart' opRECEIVER: rcvr.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXgreaterThanOp
	" <number>#> "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."

#'todo'."It is erroneous if the receiver and operand are not comparable."
	"Small > Big -> false"
	#( 2 2000000000 2.0 2.0s3 ) do: [ :tstNum |
		self value: [0.3 > tstNum] shouldnt: [:r | r]
			conformTo: #'number' selector: #'>'
	].
	self value: [-2000000005.0 > -2000000000] shouldnt: [:r | r]
		conformTo: #'number' selector: #'>'.
	self value: [0.25 > (1/2)] shouldnt: [:r | r]
		conformTo: #'number' selector: #'>'.

	"Num > Num -> false"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) > (numList at: ndx)]
			shouldnt: [:r | r ] conformTo: #'number' selector: #'>'
	].

	"Big > Small -> true"
	#( 2 2.0 2.0s3 ) do: [ :tstNum |
		self value: [5.0 > tstNum] should: [:r | r]
			conformTo: #'number' selector: #'>'
	].
	self value: [9000000000.0 > 2000000000] should: [:r | r]
		conformTo: #'number' selector: #'>'.
	self value: [-1000000005.0 > -2000000000] should: [:r | r]
		conformTo: #'number' selector: #'>'.
	self value: [9.0 > (1/2)] should: [:r | r] conformTo: #'number' selector: #'>'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXgreaterThanOrEqualToOp
	" <magnitude>#>= "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
#'todo'."It is erroneous if the receiver and operand are not comparable."

	"Small >= Big -> false"
	#( 2 2000000000 2.0 2.0s3 ) do: [ :tstNum |
		self value: [0.3 >= tstNum] shouldnt: [:r | r]
			conformTo: #'magnitude' selector: #'>='
	].
	self value: [-2000000005.0 >= -2000000000] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'>='.
	self value: [0.25 >= (1/2)] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'>='.

	"Num >= Num -> true"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) >= (numList at: ndx)]
			should: [:r | r ] conformTo: #'magnitude' selector: #'>='
	].

	"Big >= Small -> true"
	#( 2 2.0 2.0s3 ) do: [ :tstNum |
		self value: [5.0 >= tstNum] should: [:r | r]
			conformTo: #'magnitude' selector: #'>='
	].
	self value: [9000000000.0 >= 2000000000] should: [:r | r]
		conformTo: #'magnitude' selector: #'>='.
	self value: [-1000000005.0 >= -2000000000] should: [:r | r]
		conformTo: #'magnitude' selector: #'>='.
	self value: [9.0 >= (1/2)] should: [:r | r]
		conformTo: #'magnitude' selector: #'>='.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXhash
	" <Object>#hash "
	#'Numeric'.
"	Any two objects that are considered equivalent using the #= message must have the same hash value.  More formally:

	receiver = comparand	=>
	receiver hash = comparand hash
"
	self value: [float2 hash]
		should: [:r | r = float2 hash] conformTo: #'Object' selector: #'hash'.
	self value: [float2 hash]
		shouldnt: [:r | r = 2.1 hash] conformTo: #'Object' selector: #'hash'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXidentityHash
	" <Object>#identityHash "
	#'Numeric'.
	self value: [float2 identityHash]
		should: [:r | r = float2 identityHash]
		conformTo: #'Object' selector: #'identityHash'.

	self value: [float2 identityHash]
		shouldnt: [:r | r = 2.1 identityHash]
		conformTo: #'Object' selector: #'identityHash'.

	self shouldnt: [smallInt2 identityHash = float2 identityHash].
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXidentityOp
	" <Object>#== "
	#'Numeric'.
"	The value of receiver == comparand is true if and only if the value of comparand == receiver would also be true. If the value of receiver == comparand is true then the receiver and comparand must have equivalent identity hash values.  Or more formally:

	receiver == comparand =>
	receiver identityHash = comparand identityHash
"
	self shouldnt: [smallInt2 == float2].
	self shouldnt: [smallInt2 identityHash == float2 identityHash].

	self value: [float2 == float2]
		should: [:r | r] conformTo: #'Object' selector: #'=='.

	self value: [float2 == 2.1]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'=='.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXintegerDivideOp
	" <number>#// "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	"The sign of the result is positive if the receiver and operand
		have the same sign, and negative if the signs are different."
	retVals := #(1 -1 0 1 4 1).
	1 to: numList size do: [ :ndx |
		self value: [float2 // (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'//'.
	].

	retVals := #(-1 0 -1 -1 -4 -1).
	1 to: numList size do: [ :ndx |
		self value: [float2 // ((numList at: ndx) negated)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'//'
	].


	self should: [25.5 // 5.1 = 5].
	self should: [25.5 // 5 = 5].
	self should: [25500000000.5 // 5000000000 = 5].
	self should: [-25500000000.5 // -5000000000 = 5].
	self should: [25.5 // (51/10) = 5].
	self should: [25.5 // 5.1s1 = 5].

	self value: [0.0 // float2] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'//'.

	"If the operand has a value of zero the ZeroDivide exception is signaled."
	self value: [float2 // 0.0] shouldRaise: ZeroDivide.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXintegerPart
	" <number>#integerPart (returnRule - :receiver) "
	| rcvr |
	#'Numeric'.
	rcvr := 2.5.
	self value: [rcvr integerPart] should: [:result | result = 2.0]
		conformTo: #'number' selector: #'integerPart' ruleReceiver: rcvr.

	rcvr := 2.0.
	self value: [rcvr integerPart] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'integerPart' ruleReceiver: rcvr.

	rcvr := -2.0.
	self value: [rcvr integerPart] should: [:result | result = -2.0]
		conformTo: #'number' selector: #'integerPart' ruleReceiver: rcvr.

	rcvr := 0.0.
	self value: [rcvr integerPart] should: [:result | result = 0.0]
		conformTo: #'number' selector: #'integerPart' ruleReceiver: rcvr.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXisKindOfX
	" <Object>#isKindOf: "
	#'Numeric'.
"	The return value is unspecified if the receiver is a class object or candidateClass is not a class object.
"
#todo. "Fix find a test for unspecified rule above ???"
	self value: [float2 isKindOf: Float]
		should: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.

	"Metaclass tests:"
	self value: [float2 class isKindOf: (Float class)]
		should: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.

	"Inherit tests:"
	self value: [float2 class isKindOf: (Number class)]
		should: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.

	self value: [float2 isKindOf: Symbol]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXisMemberOfX
	" <Object>#isMemberOf: "
	#'Numeric'.
"	The return value is unspecified if the receiver is a class object or candidateClass is not a class object.
"
		#'Fundamental'.
#todo. "Fix find a test for unspecified rule above ???"
	self value: [float2 isMemberOf: Float]
		should: [:r | r] conformTo: #'Object' selector: #'isMemberOf:'.

	"Metaclass tests:"
	self value: [float2 class isMemberOf: (Float class)]
		should: [:r | r] conformTo: #'Object' selector: #'isMemberOf:'.

	"Fail inherit tests:"
	self value: [float2 class isMemberOf: (Number class)]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'isMemberOf:'.

	self value: [float2 isMemberOf: Symbol]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'isMemberOf:'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXlessThanOp
	" <number>#< "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."

#'todo'."It is erroneous if the receiver and operand are not comparable."
	"Small < Big -> true"
	#( 2 2000000000 2.0 2.0s3 ) do: [ :tstNum |
		self value: [0.3 < tstNum] should: [:r | r]
			conformTo: #'number' selector: #'<'
	].
	self value: [-2000000005.0 < -2000000000] should: [:r | r]
		conformTo: #'number' selector: #'<'.
	self value: [0.25 < (1/2)] should: [:r | r] conformTo: #'number' selector: #'<'.

	"Num < Num -> false"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) < (numList at: ndx)]
			shouldnt: [:r | r ] conformTo: #'number' selector: #'<'
	].

	"Big < Small -> false"
	#( 2 2.0 2.0s3 ) do: [ :tstNum |
		self value: [5.0 < tstNum] shouldnt: [:r | r]
			conformTo: #'number' selector: #'<'
	].
	self value: [9000000000.0 < 2000000000] shouldnt: [:r | r]
		conformTo: #'number' selector: #'<'.
	self value: [-1000000005.0 < -2000000000] shouldnt: [:r | r]
		conformTo: #'number' selector: #'<'.
	self value: [9.0 < (1/2)] shouldnt: [:r | r] conformTo: #'number' selector: #'<'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXlessThanOrEqualToOp
	" <magnitude>#<= "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."

#'todo'."It is erroneous if the receiver and operand are not comparable."
	"Small <= Big -> true"
	#( 2 2000000000 2.0 2.0s3 ) do: [ :tstNum |
		self value: [0.3 <= tstNum] should: [:r | r]
			conformTo: #'magnitude' selector: #'<='
	].
	self value: [-2000000005.0 <= -2000000000] should: [:r | r]
		conformTo: #'magnitude' selector: #'<='.
	self value: [0.25 <= (1/2)] should: [:r | r]
		conformTo: #'magnitude' selector: #'<='.

	"Num <= Num -> true"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) <= (numList at: ndx)]
			should: [:r | r ] conformTo: #'magnitude' selector: #'<='
	].

	"Big <= Small -> false"
	#( 2 2.0 2.0s3 ) do: [ :tstNum |
		self value: [5.0 <= tstNum] shouldnt: [:r | r]
			conformTo: #'magnitude' selector: #'<='
	].
	self value: [9000000000.0 <= 2000000000] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'<='.
	self value: [-1000000005.0 <= -2000000000] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'<='.
	self value: [9.0 <= (1/2)] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'<='.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXln
	" <Float>#ln "
	#'Numeric'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXlogX
	" <Float>#log: "
	#'Numeric'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXmaxX
	" <magnitude>#max: "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
#'todo'."It is erroneous if the receiver and operand are not comparable."

	self value: [2.0 max: 3] should: [:r | r = 3]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [-3000000000.0 max: -2000000000] should: [:r | r = -2000000000]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [2000000000.0 max: 2000000003] should: [:r | r = 2000000003]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [2.0 max: 3.0] should: [:r | r = 3.0]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [2.0 max: (5/2)] should: [:r | r = (5/2)]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [2.0 max: 3.0s3] should: [:r | r = 3.0s3]
		conformTo: #'magnitude' selector: #'max:'.

	"Num max: Num -> Num"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) max: (numList at: ndx)]
			should: [:r | r = (numList at: ndx)]
			conformTo: #'magnitude' selector: #'max:'
	].
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXminX
	" <magnitude>#min: "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
#'todo'."It is erroneous if the receiver and operand are not comparable."

	self value: [2.0 min: 1] should: [:r | r = 1]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [-1000000000.0 min: -2000000000] should: [:r | r = -2000000000]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [2000000003.0 min: 2000000001] should: [:r | r = 2000000001]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [2.0 min: 1.0] should: [:r | r = 1.0]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [2.0 min: (3/2)] should: [:r | r = (3/2)]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [2.0 min: 1.0s5] should: [:r | r = 1.0s5]
		conformTo: #'magnitude' selector: #'min:'.

	"Num min: Num -> Num"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) min: (numList at: ndx)]
			should: [:r | r = (numList at: ndx)]
			conformTo: #'magnitude' selector: #'min:'
	].
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXmultiplyOp
	" <number>#* (returnRule - :receiver :operand) "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(4.0 -4000000000.0 4000000000.0 4.0 1.0 4.0).
	1 to: numList size do: [ :ndx |
		self value: [float2 * (numList at: ndx)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'*'
			ruleReceiver: float2 operand: (numList at: ndx)
	].
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXnegated
	" <number>#negated (Return Values: <RECEIVER>) "
	| rcvr |
	#'Numeric'.
	rcvr := 2.0.
	self value: [rcvr negated] should: [:r | r = -2.0]
		conformTo: #'number' selector: #'negated' opRECEIVER: rcvr.
	rcvr := -2.0.
	self value: [rcvr negated] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'negated' opRECEIVER: rcvr.
	rcvr := 0.0.
	self value: [rcvr negated] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'negated' opRECEIVER: rcvr.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXnegative
	" <number>#negative "
	#'Numeric'.
	self value: [-2.0 negative] should: [:r | r]
		conformTo: #'number' selector: #'negative'.
	self value: [2.0 negative] shouldnt: [:r | r]
		conformTo: #'number' selector: #'negative'.
	self value: [0.0 negative] shouldnt: [:r | r]
		conformTo: #'number' selector: #'negative'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXnotIdentityOp
	" <Object>#~~ "
	#'Numeric'.
"	The value of receiver ~~ comparand is true if and only if the value of comparand ~~ receiver would also be true.
"
	self should: [smallInt2 ~~ float2 and: [float2 ~~ smallInt2]].

	self value: [float2 ~~ 2.1] should: [:r | r]
		conformTo: #'Object' selector: #'~~'.

	self value: [float2 ~~ float2] shouldnt: [:r | r]
		conformTo: #'Object' selector: #'~~'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXpositive
	" <number>#positive "
	#'Numeric'.
	self value: [2.0 positive] should: [:r | r]
		conformTo: #'number' selector: #'positive'.
	self value: [0.0 positive] should: [:r | r]
		conformTo: #'number' selector: #'positive'.
	self value: [-2.0 positive] shouldnt: [:r | r]
		conformTo: #'number' selector: #'positive'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXprintString
	" <Float>#printString "
	#'Numeric'.
	"Answer a string which is a valid Smalltalk literal representation approximately equal to the receiver. An exponent literal form is produced if the value of the exponent is greater than the precision of the receiver."

#'todo'."??? Add test exponent literal form."

	self value: [2.0 printString] should: [:r | r = '2.0']
		conformTo: #'Float' selector: #'printString'.
	self value: [0.0 printString] should: [:r | r = '0.0']
		conformTo: #'Float' selector: #'printString'.
	self value: [-2.0 printString] should: [:r | r = '-2.0']
		conformTo: #'Float' selector: #'printString'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXquoX
	" <number>#quo: "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(1 0 0 1 4 1 ).
	1 to: numList size do: [ :ndx |
		self value: [float2 quo: (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'quo:'.
	].

	retVals := #(-1 0 0 -1 -4 -1 ).
	1 to: numList size do: [ :ndx |
		self value: [float2 quo: ((numList at: ndx) negated)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'quo:'
	].

	self should: [(25.5 quo: 5.1) = 5].
	self should: [(25.5 quo: 5) = 5].
	self should: [(25500000000.5 quo: 5000000000) = 5].
	self should: [(-25500000000.5 quo: -5000000000) = 5].
	self should: [(25.5 quo: (51/10)) = 5].
	self should: [(25.5 quo: 5.1s1) = 5].

	self value: [0.0 quo: float2] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'quo:'.

	"If the operand has a value of zero the ZeroDivide exception is signaled."
	self value: [float2 quo: 0.0] shouldRaise: ZeroDivide.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXradiansToDegrees
	" <Float>#radiansToDegrees "
	#'Numeric'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXraisedToIntegerX
	" <number>#raisedToInteger: (Return Values: <RECEIVER>)"
	| rcvr |
	#'Numeric'.
	rcvr := 5.1.
	self value: [rcvr raisedToInteger: 0] should: [:r | r = 1.0]
		conformTo: #'number' selector: #'raisedToInteger:' opRECEIVER: rcvr.

	self value: [rcvr raisedToInteger: 1] should: [:r | r = rcvr]
		conformTo: #'number' selector: #'raisedToInteger:' opRECEIVER: rcvr.

	self value: [rcvr raisedToInteger: 2] should: [:r | r closeTo: 26.01]
		conformTo: #'number' selector: #'raisedToInteger:' opRECEIVER: rcvr.

	self value: [rcvr negated raisedToInteger: 2] should: [:r | r closeTo: 26.01]
		conformTo: #'number' selector: #'raisedToInteger:' opRECEIVER: rcvr.

	self value: [rcvr raisedToInteger: -2]
		should: [:r | r closeTo: 0.0384467512495194]
		conformTo: #'number' selector: #'raisedToInteger:' opRECEIVER: rcvr.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXraisedToX
	" <number>#raisedTo: "
	| numVals retVals |
	#'Numeric'.
	numVals := #(2 2.0 0 2.0s3 ) copy.
	numVals at: 3 put: (1/2).
	retVals := #(4.0 4.0 1.414213562373095 4.0 ).
	1 to: numVals size do: [ :ndx |
		self value: [float2 raisedTo: (numVals at: ndx)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'raisedTo:'.
	].


	retVals := #(0.25 0.25 0.7071067811865475 0.25).
	1 to: numVals size do: [ :ndx |
		self value: [float2 raisedTo: ((numVals at: ndx) negated)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'raisedTo:'
	].

	self value: [float2 raisedTo: 0.0] should: [:r | r = 1.0]
		conformTo: #'number' selector: #'raisedTo:'.

	self value: [0.0 raisedTo: float2] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'raisedTo:'.

	self value: [float2 raisedTo: 1.0] should: [:r | r = float2]
		conformTo: #'number' selector: #'raisedTo:'.

	"It is erroneous if the receiver equals zero
		and the operand is less than or equal to zero,"
	self value: [0.0 raisedTo: -2] shouldRaise: ArithmeticError.

	"	or if the receiver is less than zero."
	self value: [float2 negated raisedTo: 2.0]
		shouldRaise: ArithmeticError.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXreciprocal
	" <number>#reciprocal (returnRule - :receiver) "
	#'Numeric'.
	self value: [float2 reciprocal] should: [:r | r = (1.0/float2)]
		conformTo: #'number' selector: #'reciprocal'
		ruleReceiver: float2.

	self value: [float2 negated reciprocal]
		should: [:r | r = (1.0/(float2 negated))]
		conformTo: #'number' selector: #'reciprocal'
		ruleReceiver: (float2 negated).

	"Signal a ZeroDivide exception if the receiver is equal to zero."
	self value: [0.0 reciprocal] shouldRaise: ZeroDivide.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXremX
	" <number>#rem: "
	| num2 flt |
	#'Numeric'.
	"Within the limits of representation, the following invariant should hold:
		(receiver quo: operand)*operand + (receiver rem: operand) = receiver"
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	numList := #( 5 5.0 5.0s3 ).
	flt := 26.5.
	numList do: [ :num |
		self value: [flt rem: num]
			should: [:r | r = 1.5
					& ((flt quo: num) * num + (flt rem: num) = flt)]
			conformTo: #'number' selector: #'rem:'
	].

	numList := numList collect: [ :num | num negated ].
	numList do: [ :num |
		self value: [flt rem: num]
			should: [:r | r = 1.5
					& ((flt quo: num) * num + (flt rem: num) = flt)]
			conformTo: #'number' selector: #'rem:'
	].

	numList := #( 5 5.0 5.0s3 ).
	flt := -26.5.
	numList do: [ :num |
		self should: [(flt rem: num) = -1.5
				& ((flt quo: num) * num + (flt rem: num) = flt)]
	].

	numList := numList collect: [ :num | num negated ].
	numList do: [ :num |
		self should: [(flt rem: num) = -1.5
					& ((flt quo: num) * num + (flt rem: num) = flt)]
	].

	flt := 26.5.
	num2 := (5/2).
	self value: [flt rem: num2]
		should: [:r | r = 1.5
				& ((flt quo: num2) * num2 + (flt rem: num2) = flt)]
		conformTo: #'number' selector: #'rem:'.

	numList := #( -2000000000 2000000000 ).
	flt :=  10000000001.5.
	numList do: [ :num |
		self value: [flt rem: num]
			should: [:r | r = 1.5
					& ((flt quo: num) * num + (flt rem: num) = flt)]
			conformTo: #'number' selector: #'rem:'
	].

	"If either the receiver or operand are of type <Float> and the operand has a value of zero, the result is implementation defined.  The implementation may signal the ZeroDivide exception or provide a continuation value "
	self value: [float2 rem: 0.0] shouldRaise: ZeroDivide.
	self value: [float2 rem: 0] shouldRaise: ZeroDivide.
	self value: [2 rem: 0.0] shouldRaise: ZeroDivide.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXremainderIntegerDivideOp
	" <number>#\\ (returnRule - :receiver :operand) "
	"The remainder has the same sign as operand.
	Within the limits of representation, the following invariant should hold:

		(receiver // operand) * operand + (receiver \\ operand) = receiver
 "
	| retVals recList ndx |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	recList := #( 26 -26000000001 26000000001 26.0 0 26.0s3 ) copy.
	recList at: 5 put: (53/2).
	retVals := #(1.0 4.0 1.0 1.0 1.5 1.0 ).
	ndx := 0.
	recList do: [ :rec |
		ndx := ndx + 1.
		self value: [rec \\ 5.0]
			should: [:r | r = (retVals at: ndx)
					& ((rec // 5.0) * 5.0 + (rec \\ 5.0) = rec)]
			conformTo: #'number' selector: #'\\'
			ruleReceiver: rec operand:  5.0.
	].

	"The remainder has the same sign as operand."
	retVals := #(-4.0 -1.0 -4.0 -4.0 -3.5 -4.0 ).
	ndx := 0.
	recList do: [ :rec |
		ndx := ndx + 1.
		self value: [rec \\ -5.0]
			should: [:r | r = (retVals at: ndx)
					& ((rec // -5.0) * -5.0 + (rec \\ -5.0) = rec)]
			conformTo: #'number' selector: #'\\'
			ruleReceiver: rec operand:  -5.0.
	].

	self should: [26.5 \\ 5.0 = 1.5 & ((26.5 // 5.0) * 5.0 + (26.5 \\ 5.0) = 26.5)].
	self should: [26.5 \\ -5.0 = -3.5
					& ((26.5 // -5.0) * -5.0 + (26.5 \\ -5.0) = 26.5)].

	self should: [0.0 \\ float2 = 0.0].

	"If the operand is zero, the implementation may signal
		the ZeroDivide exception or provide a continuation value."
	self value: [float2 \\ 0.0] shouldRaise: ZeroDivide.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXroundToX
	" <number>#roundTo: (returnRule - :receiver :operand) "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(2 0 0 2.0 2 2.000s3).
	1 to: numList size do: [ :ndx |
		self value: [float2 roundTo: (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'roundTo:'
			ruleReceiver: float2 operand: (numList at: ndx)
	].

	self should: [(0.0 roundTo: float2) = 0.0].

	"The result is undefined if factor equals zero."
	self value: [float2 / 0.0] shouldRaise: ZeroDivide.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXrounded
	" <number>#rounded "
	#'Numeric'.
	self value: [2.0 rounded] should: [:r | r = 2]
		conformTo: #'number' selector: #'rounded'.
	self value: [2.1 rounded] should: [:r | r = 2]
		conformTo: #'number' selector: #'rounded'.
	self value: [2.5 rounded] should: [:r | r = 3]
		conformTo: #'number' selector: #'rounded'.
	self value: [-2.0 rounded] should: [:r | r = -2]
		conformTo: #'number' selector: #'rounded'.
	self value: [-2.1 rounded] should: [:r | r = -2]
		conformTo: #'number' selector: #'rounded'.
	self value: [-2.5 rounded] should: [:r | r = -3]
		conformTo: #'number' selector: #'rounded'.
	self value: [0.0 rounded] should: [:r | r = 0]
		conformTo: #'number' selector: #'rounded'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXsign
	" <number>#sign "
	#'Numeric'.
	self value: [2.0 sign] should: [:r | r = 1]
		conformTo: #'number' selector: #'sign'.
	self value: [0.0 sign] should: [:r | r = 0]
		conformTo: #'number' selector: #'sign'.
	self value: [-2.0 sign] should: [:r | r = -1]
		conformTo: #'number' selector: #'sign'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXsin
	" <Float>#sin "
	#'Numeric'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXsqrt
	" <number>#sqrt "
	#'Numeric'.
	self value: [26.01 sqrt] should: [:r | r closeTo: 5.1]
		conformTo: #'number' selector: #'sqrt'.
	self value: [4.0 sqrt] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'sqrt'.
	self value: [0.0 sqrt] should: [:r | r =  0.0]
		conformTo: #'number' selector: #'sqrt'.

	"The result is undefined if the receiver is less than zero."
	self value: [-1.0 sqrt] shouldRaise: ArithmeticError.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXsquared
	" <number>#squared (Return Values: <RECEIVER>)"
	| rcvr |
	#'Numeric'.
	rcvr := 5.1.
	self value: [rcvr squared] should: [:r | r closeTo: 26.01]
		conformTo: #'number' selector: #'squared' opRECEIVER: rcvr.

	rcvr := -5.1.
	self value: [rcvr squared] should: [:r | r closeTo: 26.01]
		conformTo: #'number' selector: #'squared' opRECEIVER: rcvr.
	rcvr := 0.0.
	self value: [rcvr squared] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'squared' opRECEIVER: rcvr.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXstrictlyPositive
	" <number>#strictlyPositive "
	#'Numeric'.
	self value: [2.0 strictlyPositive] should: [:r | r]
		conformTo: #'number' selector: #'strictlyPositive'.

	self value: [0.0 strictlyPositive] shouldnt: [:r | r]
		conformTo: #'number' selector: #'strictlyPositive'.
	self value: [-2.0 strictlyPositive] shouldnt: [:r | r]
		conformTo: #'number' selector: #'strictlyPositive'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXsubtractOp
	" <number>#- (returnRule - :receiver :operand) "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(0.0 2000000002.0 -1999999998.0 0.0 1.5 0.0).
	1 to: numList size do: [ :ndx |
		self value: [float2 - (numList at: ndx)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'-'
			ruleReceiver: float2 operand: (numList at: ndx)
	].
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtan
	" <Float>#tan "
	#'Numeric'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtoX
	" <number>#to: "
	| start middleNdx stop2 |
	#'Numeric'.
	start := 1.0.
	numList := #( 2 2.0 0 2.0s3 ) copy.
	numList at: 3 put: (5/2).
	numList do: [ :stop |
		self value: [start to: stop]
			should: [:r | (r size = 2)
					". . . the last element in the sequence . . . is . . .[:]
						receiver + ((stop - receiver) // 1)"
					& (r last = (start + ((stop - start) // 1)))
					"The elements conform to the receiver's protocol."
					& (r allSatisfy: [ :elem |
						elem class conformsToProtocolNamed: #'Float'])
			]
			conformTo: #'number' selector: #'to:'
	].

	stop2 := 2000000000.
	middleNdx := 1000000000.	"Check conformance of first, middle and last."
	self value: [start to: stop2]
		should: [:r | (r size = 2000000000)
				". . . the last element in the sequence . . . is . . .[:]
					receiver + ((stop - receiver) // 1)"
				& (r last = (start + ((stop2 - start) // 1)))
				"The elements conform to the receiver's protocol."
				& ((Array with: (r at: 1)
						with: (r at: middleNdx)
						with: (r at: 3)
				) allSatisfy: [ :elem |
					elem class conformsToProtocolNamed: #'Float'])
		]
		conformTo: #'number' selector: #'to:'.

	start := -2000000000.0.
	stop2 := -1.
	middleNdx := 1000000000.	"Check conformance of first, middle and last."
	self value: [start to: stop2]
		should: [:r | (r size = 2000000000)
				". . . the last element in the sequence . . . is . . .[:]
					receiver + ((stop - receiver) // 1)"
				& (r last = (start + ((stop2 - start) // 1)))
				"The elements conform to the receiver's protocol."
				& ((Array with: (r at: 1)
						with: (r at: middleNdx)
						with: (r at: 3)
				) allSatisfy: [ :elem |
					elem class conformsToProtocolNamed: #'Float'])
		]
		conformTo: #'number' selector: #'to:'.

	"The interval answered will be empty if the receiver is greater than stop."
	self value: [1.0 to: -1.0]
		should: [:r | (r isEmpty)] conformTo: #'number' selector: #'to:'
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtoXbyX
	" <number>#to:by: "
	#'Numeric'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtoXbyXdoX
	" <number>#to:by:do: "
	#'Numeric'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtoXdoX
	" <number>#to:do: "
	#'Numeric'.
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtruncateToX
	" <number>#truncateTo: (returnRule - :receiver :operand) "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(2 0 0 2.0 2 2.000s3).
	1 to: numList size do: [ :ndx |
		self value: [float2 truncateTo: (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'truncateTo:'
			ruleReceiver: float2 operand: (numList at: ndx)
	].

	self should: [(0.0 truncateTo: float2) = 0.0].
! !

!FloatANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtruncated
	" <number>#truncated "
	#'Numeric'.
	self value: [2.0 truncated] should: [:r | r = 2]
		conformTo: #'number' selector: #'truncated'.
	self value: [2.1 truncated] should: [:r | r = 2]
		conformTo: #'number' selector: #'truncated'.
	self value: [2.5 truncated] should: [:r | r = 2]
		conformTo: #'number' selector: #'truncated'.
	self value: [-2.0 truncated] should: [:r | r = -2]
		conformTo: #'number' selector: #'truncated'.
	self value: [-2.1 truncated] should: [:r | r = -2]
		conformTo: #'number' selector: #'truncated'.
	self value: [-2.5 truncated] should: [:r | r = -2]
		conformTo: #'number' selector: #'truncated'.
	self value: [0.0 truncated] should: [:r | r = 0]
		conformTo: #'number' selector: #'truncated'.
! !

!FloatANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:04'!
cannonicalObject
	^Float pi   "3.141592653589793"! !

!FloatANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:02'!
protocol
	^#'Float'! !


!FloatCharacterizationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXdenormalized
	" <floatCharacterization>#denormalized "
	#'Numeric'.
! !

!FloatCharacterizationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXe
	" <floatCharacterization>#e "
	#'Numeric'.
! !

!FloatCharacterizationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXemax
	" <floatCharacterization>#emax "
	#'Numeric'.
! !

!FloatCharacterizationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXemin
	" <floatCharacterization>#emin "
	#'Numeric'.
! !

!FloatCharacterizationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXepsilon
	" <floatCharacterization>#epsilon "
	#'Numeric'.
! !

!FloatCharacterizationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXfmax
	" <floatCharacterization>#fmax "
	#'Numeric'.
! !

!FloatCharacterizationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXfmin
	" <floatCharacterization>#fmin "
	#'Numeric'.
! !

!FloatCharacterizationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXfminDenormalized
	" <floatCharacterization>#fminDenormalized "
	#'Numeric'.
! !

!FloatCharacterizationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXfminNormalized
	" <floatCharacterization>#fminNormalized "
	#'Numeric'.
! !

!FloatCharacterizationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXpi
	" <floatCharacterization>#pi "
	#'Numeric'.
! !

!FloatCharacterizationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXprecision
	" <floatCharacterization>#precision "
	#'Numeric'.
! !

!FloatCharacterizationANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXradix
	" <floatCharacterization>#radix "
	#'Numeric'.
! !

!FloatCharacterizationANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:07'!
cannonicalObject
	^Float! !

!FloatCharacterizationANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:07'!
protocol
	^#'floatCharacterization'! !


!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 10:36'!
setUp
	super setUp.
	smallInt2 := 2.
	largeNegInt2000000000 := -2000000000.
	largePosInt2000000000 := 2000000000.
	float2 := 2.0.
	fractionHalf := 1/2.
	sclDec2s3 := 2.0s3.
	numList := Array new: 6.
	numList at: 1 put: smallInt2.
	numList at: 2 put: largeNegInt2000000000.
	numList at: 3 put: largePosInt2000000000.
	numList at: 4 put: float2.
	numList at: 5 put: fractionHalf.

	numList at: 6 put: sclDec2s3.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXabs
	" <number>#abs (Return Values: <RECEIVER>) "
	| rcvr |
	#'Numeric'.
	rcvr := 1/2.
	self value: [rcvr abs] should: [:r | r = (1/2)]
		conformTo: #'number' selector: #'abs' opRECEIVER: rcvr.
	rcvr := -1/2.
	self value: [rcvr abs] should: [:r | r = (1/2)]
		conformTo: #'number' selector: #'abs' opRECEIVER: rcvr.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXaddOp
	" <number>#+ (returnRule - :receiver :operand) "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := Array new: 6.
	retVals at: 1 put: (5/2).

	retVals at: 2 put: (-3999999999/2).
	retVals at: 3 put: (4000000001/2).
	retVals at: 4 put: 2.5.
	retVals at: 5 put: 1.
	retVals at: 6 put: (5/2).
	1 to: numList size do: [ :ndx |
		self value: [fractionHalf + (numList at: ndx)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'+'
			ruleReceiver: fractionHalf operand: (numList at: ndx)
	].
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasFloat
	" <number>#asFloat "
	#'Numeric'.
	self value: [(1/2) asFloat] should: [:r | r = 0.5]
		conformTo: #'number' selector: #'asFloat'.
	self value: [(-1/2) asFloat] should: [:r | r = -0.5]
		conformTo: #'number' selector: #'asFloat'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasFloatD
	" <number>#asFloatD "
	#'Numeric'.
	self value: [(1/2) asFloatD] should: [:r | r = 0.5]
		conformTo: #'number' selector: #'asFloatD'.
	self value: [(-1/2) asFloatD] should: [:r | r = -0.5]
		conformTo: #'number' selector: #'asFloatD'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasFloatE
	" <number>#asFloatE "
	#'Numeric'.
	self value: [(1/2) asFloatE] should: [:r | r = 0.5]
		conformTo: #'number' selector: #'asFloatE'.
	self value: [(-1/2) asFloatE] should: [:r | r = -0.5]
		conformTo: #'number' selector: #'asFloatE'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasFloatQ
	" <number>#asFloatQ "
	#'Numeric'.
	self value: [(1/2) asFloatQ] should: [:r | r = 0.5]
		conformTo: #'number' selector: #'asFloatQ'.
	self value: [(-1/2) asFloatQ] should: [:r | r = -0.5]
		conformTo: #'number' selector: #'asFloatQ'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasFraction
	" <number>#asFraction "
	#'Numeric'.
	self value: [(1/2) asFraction] should: [:r | r = (1/2)]
		conformTo: #'number' selector: #'asFraction'.
	self value: [(-1/2) asFraction] should: [:r | r = (-1/2)]
		conformTo: #'number' selector: #'asFraction'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasInteger
	" <number>#asInteger "
	#'Numeric'.
	self value: [(1/3) asInteger] should: [:r | r = 0]
		conformTo: #'number' selector: #'asInteger'.
	self value: [(1/2) asInteger] should: [:r | r = 1]
		conformTo: #'number' selector: #'asInteger'.
	self value: [(-1/2) asInteger] should: [:r | r = -1]
		conformTo: #'number' selector: #'asInteger'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasScaledDecimalX
	" <number>#asScaledDecimal: "
	#'Numeric'.
	self value: [(1/2) asScaledDecimal: 2]
		should: [:r | r = 0.5s2 & (r scale = 2)]
		conformTo: #'number' selector: #'asScaledDecimal:'.
	self value: [(-1/2) asScaledDecimal: 2]
		should: [:r | r = -0.5s2 & (r scale = 2)]
		conformTo: #'number' selector: #'asScaledDecimal:'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXbetweenXandX
	" <magnitude>#between:and: "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
#'todo'."It is erroneous if the receiver  and min or max are not comparable"

	self value: [(1/2) between: 0 and: 3]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [(1/-2) between: -2000000003 and: 0]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [(1/2) between: 0 and: 2000000003]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [(1/2) between: 0.0 and: 3.0]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [(1/2) between: (1/4) and: (5/2)]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [(1/2) between: 0.0s3 and: 3.0s3]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.

	self value: [(1/2) between: -2000000001 and: 2000000003]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [(1/2) between: 0.0 and: 3.0s3]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.

	"Num between: Num and: Num -> true"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx)
					between: (numList at: ndx)
					and: (numList at: ndx)]
			should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'
	].

	self value: [(1/2) between: 3 and: 4]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [(1/2) between: -2000000003 and: -2000000005]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [(1/2) between: 2000000003 and: 2000000005]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [(1/2) between: 3.0 and: 5.0]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [(1/2) between: (5/2) and: (7/2)]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [(1/2) between: 3.0s3 and: 5.0s3]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.

	"??? min not min but max and vice versa -> false ???"
	self value: [(1/2) between: 3 and: 1]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXceiling
	" <number>#ceiling "
	#'Numeric'.
	self value: [(1/3) ceiling] should: [:r | r = 1]
		conformTo: #'number' selector: #'ceiling'.
	self value: [(1/2) ceiling] should: [:r | r = 1]
		conformTo: #'number' selector: #'ceiling'.
	self value: [(-1/2) ceiling] should: [:r | r = 0]
		conformTo: #'number' selector: #'ceiling'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Numeric'.
"	Return a new object that must be as similar as possible to the receiver in its initial state and behavior.  Any operation that changes the state of the new object should not as a side-effect change the state or behavior of the receiver.  Similarly, any change to the receiver should not as a side-effect change the new object.
	If the receiver is an identity object, return the receiver.
"
#todo. "??? add change-side-effect test ???"
	self value: [fractionHalf copy]
		should: [:r | (r = fractionHalf) & (r ~~ fractionHalf)]
		conformTo: #'Object' selector: #'copy' opRECEIVER: fractionHalf.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXdenominator
	" <Fraction>#denominator "
	#'Numeric'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXdivideOp
	" <number>#/ (returnRule - :receiver :operand) "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := Array new: 6.
	retVals at: 1 put: (1/4).
	retVals at: 2 put: (-1/4000000000).
	retVals at: 3 put: (1/4000000000).
	retVals at: 4 put: 0.25.
	retVals at: 5 put: 1.
	retVals at: 6 put:  (1/4).
	1 to: numList size do: [ :ndx |
		self value: [fractionHalf / (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'/'
			ruleReceiver: fractionHalf operand: (numList at: ndx)
	].

	self value: [0 / fractionHalf] should: [:r | r = 0]
		conformTo: #'number' selector: #'/'
		ruleReceiver: fractionHalf operand: 0.

	"The implementation must signal the ZeroDivide exception."
	self value: [fractionHalf / 0] shouldRaise: ZeroDivide.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXequalityOp
	" <number>#= "
	#'Numeric'.
"	receiver = comparand	=>
	receiver hash = comparand hash
"
	self value: [fractionHalf = fractionHalf]
		should: [:r | r & (fractionHalf hash = fractionHalf hash) ]
		conformTo: #'number' selector: #'='.
	self value: [ fractionHalf = (5/2) ]
		shouldnt: [ :r | r | (fractionHalf hash = (5/2) hash) ]
		conformTo: #'number' selector: #'='.

"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	self value: [ fractionHalf = 2 ]
		should: [ :r | r  ifTrue: [ fractionHalf hash = 2 hash ]
							ifFalse: [ fractionHalf hash ~= 2 hash ]  ]
		conformTo: #'number' selector: #'='.
	self value: [ fractionHalf = -2000000000 ]
		should: [ :r | r ifTrue: [ fractionHalf hash = -2000000000 hash ]
						ifFalse: [ fractionHalf hash ~= -2000000000 hash ]  ]
		conformTo: #'number' selector: #'='.
	self value: [ fractionHalf = 2000000000 ]
		should: [ :r | r ifTrue: [ fractionHalf hash = 2000000000 hash ]
						ifFalse: [ fractionHalf hash ~= 2000000000 hash ]  ]
		conformTo: #'number' selector: #'='.
	self value: [ fractionHalf = 0.5 ]
		should: [ :r | r ifTrue: [ fractionHalf hash = 0.5 hash ]
						ifFalse: [ fractionHalf hash ~= 0.5 hash ]  ]
		conformTo: #'number' selector: #'='.
	self value: [ fractionHalf = 0.5s3 ]
		should: [ :r | r ifTrue: [ fractionHalf hash = 0.5s3 hash ]
						ifFalse: [ fractionHalf hash ~= 0.5s3 hash ]  ]
		conformTo: #'number' selector: #'='.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXfloor
	" <number>#floor "
	#'Numeric'.
	self value: [(1/3) floor] should: [:r | r = 0]
		conformTo: #'number' selector: #'floor'.
	self value: [(1/2) floor] should: [:r | r = 0]
		conformTo: #'number' selector: #'floor'.
	self value: [(3/2) floor] should: [:r | r = 1]
		conformTo: #'number' selector: #'floor'.
	self value: [(-1/2) floor] should: [:r | r = -1]
		conformTo: #'number' selector: #'floor'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXfractionPart
	" <number>#fractionPart (Return Values: <RECEIVER>)"
	| rcvr |
	#'Numeric'.
	"Within the limits of representation, the following invariants should hold:

		receiver integerPart + receiver fractionPart = receiver
		receiver \\1 = receiver fractionPart	(RAH - erroneous, add #'abs')
"
	rcvr := (3/2).
	self value: [rcvr fractionPart]
		should: [:r | r = (1/2) & (rcvr integerPart + rcvr fractionPart = rcvr)
					& (rcvr \\ 1 = rcvr fractionPart abs)]
		conformTo: #'number' selector: #'fractionPart' opRECEIVER: rcvr.

	rcvr := (-3/2).
	self value: [rcvr fractionPart]
		should: [:r | r = (-1/2) & (rcvr integerPart + rcvr fractionPart = rcvr)
					& (rcvr \\ 1 = rcvr fractionPart abs)]
		conformTo: #'number' selector: #'fractionPart' opRECEIVER: rcvr.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXgreaterThanOp
	" <number>#> "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."

#'todo'."It is erroneous if the receiver and operand are not comparable."
	"Small > Big -> false"
	#( 2 2000000000 2.0 2.0s3 ) do: [ :tstNum |
		self value: [(1/3) > tstNum] shouldnt: [:r | r]
			conformTo: #'number' selector: #'>'
	].
	self value: [(-9000000005/3) > -2000000000] shouldnt: [:r | r]
		conformTo: #'number' selector: #'>'.
	self value: [(1/4) > (1/2)] shouldnt: [:r | r]
		conformTo: #'number' selector: #'>'.

	"Num > Num -> false"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) > (numList at: ndx)]
			shouldnt: [:r | r ] conformTo: #'number' selector: #'>'
	].

	"Big > Small -> true"
	#( 2 2.0 2.0s3 ) do: [ :tstNum |
		self value: [(11/2) > tstNum] should: [:r | r]
			conformTo: #'number' selector: #'>'
	].
	self value: [(9000000005/3) > 2000000000] should: [:r | r]
		conformTo: #'number' selector: #'>'.
	self value: [(-1000000005/3) > -2000000000] should: [:r | r]
		conformTo: #'number' selector: #'>'.
	self value: [(11/2) > (1/2)] should: [:r | r]
		conformTo: #'number' selector: #'>'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXgreaterThanOrEqualToOp
	" <magnitude>#>= "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."

#'todo'."It is erroneous if the receiver and operand are not comparable."
	"Small >= Big -> false"
	#( 2 2000000000 2.0 2.0s3 ) do: [ :tstNum |
		self value: [(1/3) >= tstNum] shouldnt: [:r | r]
			conformTo: #'magnitude' selector: #'>='
	].
	self value: [(-9000000005/3) >= -2000000000] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'>='.
	self value: [(1/4) >= (1/2)] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'>='.

	"Num >= Num -> true"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) >= (numList at: ndx)]
			should: [:r | r ] conformTo: #'magnitude' selector: #'>='
	].

	"Big >= Small -> true"
	#( 2 2.0 2.0s3 ) do: [ :tstNum |
		self value: [(11/2) >= tstNum] should: [:r | r]
			conformTo: #'magnitude' selector: #'>='
	].
	self value: [(9000000005/3) >= 2000000000] should: [:r | r]
		conformTo: #'magnitude' selector: #'>='.
	self value: [(-1000000005/3) >= -2000000000] should: [:r | r]
		conformTo: #'magnitude' selector: #'>='.
	self value: [(11/2) >= (1/2)] should: [:r | r]
		conformTo: #'magnitude' selector: #'>='.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXhash
	" <Object>#hash "
	#'Numeric'.
"	Any two objects that are considered equivalent using the #= message must have the same hash value.  More formally:

	receiver = comparand	=>
	receiver hash = comparand hash
"
#'testAnom'. "??? <Object> test of equivalence seems to confilict
				with <Number> convert then test.
	self shouldnt: [smallInt2 = float2].
	self shouldnt: [smallInt2 hash = float2 hash].
 ???"
	self value: [fractionHalf hash]
		should: [:r | r = fractionHalf hash]
		conformTo: #'Object' selector: #'hash'.

	self value: [fractionHalf hash]
		shouldnt: [:r | r = (2/3) hash] conformTo: #'Object' selector: #'hash'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXidentityHash
	" <Object>#identityHash "
	#'Numeric'.
	self value: [fractionHalf identityHash]
		should: [:r | r = fractionHalf identityHash]
		conformTo: #'Object' selector: #'identityHash'.

	self value: [smallInt2 identityHash]
		should: [:r | r = (4/2) identityHash]
		conformTo: #'Object' selector: #'identityHash'.

	self value: [fractionHalf identityHash]
		shouldnt: [:r | r = (2/3) identityHash]
		conformTo: #'Object' selector: #'identityHash'.

	self value: [smallInt2 identityHash]
		shouldnt: [:r | r = (6/2) identityHash]
		conformTo: #'Object' selector: #'identityHash'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXidentityOp
	" <Object>#== "
	#'Numeric'.
"	The value of receiver == comparand is true if and only if the value of comparand == receiver would also be true. If the value of receiver == comparand is true then the receiver and comparand must have equivalent identity hash values.  Or more formally:

	receiver == comparand =>
	receiver identityHash = comparand identityHash
"
	self value: [fractionHalf == fractionHalf]
		should: [:r | r] conformTo: #'Object' selector: #'=='.

	self value: [smallInt2 == (4/2)]
		should: [:r | r] conformTo: #'Object' selector: #'=='.

	self value: [fractionHalf == (2/3)]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'=='.

	self value: [smallInt2 == (6/2)]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'=='.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXintegerDivideOp
	" <number>#// "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	"The sign of the result is positive if the receiver and operand
		have the same sign, and negative if the signs are different."
	retVals := #(666666666 -1 0 666666666 2666666666 666666666 ).
	1 to: numList size do: [ :ndx |
		self value: [(4000000000/3) // (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'//'.
	].

"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #( -666666667 0 -1 -666666667 -2666666667 -666666667 ).
	1 to: numList size do: [ :ndx |
		self value: [(4000000000/3) // ((numList at: ndx) negated)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'//'
	].

	self should: [(256/5) // (50/5) = 5].

	self should: [(126/5) // 5 = 5].
	self should: [(125000000001/5) // 5000000000 = 5].
	self should: [(-125000000001/5) // -5000000000 = 5].
	self should: [(131/5) // 5.1 = 5].
	self should: [(131/5) // 5.1s1 = 5].

	self value: [0 // fractionHalf] should: [:r | r = 0]
		conformTo: #'number' selector: #'//'.

	"If the operand has a value of zero the ZeroDivide exception is signaled."
	self value: [fractionHalf // 0] shouldRaise: ZeroDivide.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXintegerPart
	" <number>#integerPart (returnRule - :receiver) "
	| rcvr |
	#'Numeric'.
	rcvr := (1/2).
	self value: [rcvr integerPart] should: [:result | result = 0]
		conformTo: #'number' selector: #'integerPart' ruleReceiver: rcvr.

	rcvr := (3/2).
	self value: [rcvr integerPart] should: [:result | result = 1]
		conformTo: #'number' selector: #'integerPart' ruleReceiver: rcvr.

	rcvr := (-3/2).
	self value: [rcvr integerPart] should: [:result | result = -1]
		conformTo: #'number' selector: #'integerPart' ruleReceiver: rcvr.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXisKindOfX
	" <Object>#isKindOf: "
	#'Numeric'.
"	The return value is unspecified if the receiver is a class object or candidateClass is not a class object.
"
#todo. "Fix find a test for unspecified rule above ???"
	self value: [fractionHalf isKindOf: Fraction]
		should: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.

	"Metaclass tests:"
	self value: [fractionHalf class isKindOf: (Fraction class)]
		should: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.

	"Inherit tests:"
	self value: [fractionHalf class isKindOf: (Number class)]
		should: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.

	self value: [fractionHalf isKindOf: Symbol]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXisMemberOfX
	" <Object>#isMemberOf: "
	#'Numeric'.
"	The return value is unspecified if the receiver is a class object or candidateClass is not a class object.
"
#todo. "Fix find a test for unspecified rule above ???"
	self value: [fractionHalf isMemberOf: Fraction]
		should: [:r | r] conformTo: #'Object' selector: #'isMemberOf:'.

	"Metaclass tests:"
	self value: [fractionHalf class isMemberOf: (Fraction class)]
		should: [:r | r] conformTo: #'Object' selector: #'isMemberOf:'.

	"Fail inherit tests:"
	self value: [fractionHalf class isMemberOf: (Number class)]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'isMemberOf:'.

	self value: [fractionHalf isMemberOf: Float]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'isMemberOf:'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXlessThanOp
	" <number>#< "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."

#'todo'."It is erroneous if the receiver and operand are not comparable."
	"Small < Big -> true"
	#( 2 2000000000 2.0 2.0s3 ) do: [ :tstNum |
		self value: [(1/3) < tstNum] should: [:r | r]
			conformTo: #'number' selector: #'<'
	].
	self value: [(-9000000005/3) < -2000000000] should: [:r | r]
		conformTo: #'number' selector: #'<'.
	self value: [(1/4) < (1/2)] should: [:r | r]
		conformTo: #'number' selector: #'<'.

	"Num < Num -> false"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) < (numList at: ndx)]
			shouldnt: [:r | r ] conformTo: #'number' selector: #'<'
	].

	"Big < Small -> false"
	#( 2 2.0 2.0s3 ) do: [ :tstNum |
		self value: [(11/2) < tstNum] shouldnt: [:r | r]
			conformTo: #'number' selector: #'<'
	].
	self value: [(9000000005/3) < 2000000000] shouldnt: [:r | r]
		conformTo: #'number' selector: #'<'.
	self value: [(-1000000005/3) < -2000000000] shouldnt: [:r | r]
		conformTo: #'number' selector: #'<'.
	self value: [(11/2) < (1/2)] shouldnt: [:r | r]
		conformTo: #'number' selector: #'<'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXlessThanOrEqualToOp
	" <magnitude>#<= "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."

#'todo'."It is erroneous if the receiver and operand are not comparable."
	"Small <= Big -> true"
	#( 2 2000000000 2.0 2.0s3 ) do: [ :tstNum |
		self value: [(1/3) <= tstNum] should: [:r | r]
			conformTo: #'magnitude' selector: #'<='
	].
	self value: [(-9000000005/3) <= -2000000000] should: [:r | r]
		conformTo: #'magnitude' selector: #'<='.
	self value: [(1/4) <= (1/2)] should: [:r | r]
		conformTo: #'magnitude' selector: #'<='.

	"Num <= Num -> false"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) <= (numList at: ndx)]
			should: [:r | r ] conformTo: #'magnitude' selector: #'<='
	].

	"Big <= Small -> false"
	#( 2 2.0 2.0s3 ) do: [ :tstNum |
		self value: [(11/2) <= tstNum] shouldnt: [:r | r]
			conformTo: #'magnitude' selector: #'<='
	].
	self value: [(9000000005/3) <= 2000000000] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'<='.
	self value: [(-1000000005/3) <= -2000000000] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'<='.
	self value: [(11/2) <= (1/2)] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'<='.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXmaxX
	" <magnitude>#max: "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
#'todo'."It is erroneous if the receiver and operand are not comparable."

	self value: [(1/2) max: 3] should: [:r | r = 3]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [(-9000000000/2) max: -2000000000]
		should: [:r | r = -2000000000]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [(1/2) max: 2000000003] should: [:r | r = 2000000003]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [(1/2) max: 3.0] should: [:r | r = 3.0]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [(1/2) max: (5/2)] should: [:r | r = (5/2)]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [(1/2) max: 3.0s3] should: [:r | r = 3.0s3]
		conformTo: #'magnitude' selector: #'max:'.

	"Num max: Num -> Num"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) max: (numList at: ndx)]
			should: [:r | r = (numList at: ndx)]
			conformTo: #'magnitude' selector: #'max:'
	].
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXminX
	" <magnitude>#min: "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
#'todo'."It is erroneous if the receiver and operand are not comparable."

	self value: [(1/2) min: 0] should: [:r | r = 0]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [(-2000000000/2) min: -2000000000]
		should: [:r | r = -2000000000]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [(9000000000/2) min: 2000000003]
		should: [:r | r = 2000000003]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [(1/2) min: 0.0] should: [:r | r = 0.0]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [(1/2) min: (1/4)] should: [:r | r = (1/4)]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [(1/2) min: 0.1s3] should: [:r | r = 0.1s3]
		conformTo: #'magnitude' selector: #'min:'.

	"Num min: Num -> Num"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) min: (numList at: ndx)]
			should: [:r | r = (numList at: ndx)]
			conformTo: #'magnitude' selector: #'min:'
	].
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXmultiplyOp
	" <number>#* (returnRule - :receiver :operand) "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(1 -1000000000 1000000000 1.0 0 1) copy.
	retVals at: 5 put: (1/4).
	1 to: numList size do: [ :ndx |
		self value: [fractionHalf * (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'*'
			ruleReceiver: fractionHalf operand: (numList at: ndx)
	].
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXnegated
	" <number>#negated (Return Values: <RECEIVER>) "
	| rcvr |
	#'Numeric'.
	rcvr := 3/2.
	self value: [rcvr negated] should: [:r | r = (-3/2)]
		conformTo: #'number' selector: #'negated' opRECEIVER: rcvr.
	rcvr := -3/2.
	self value: [rcvr negated] should: [:r | r = (3/2)]
		conformTo: #'number' selector: #'negated' opRECEIVER: rcvr.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXnegative
	" <number>#negative "
	#'Numeric'.
	self value: [(-1/2) negative] should: [:r | r]
		conformTo: #'number' selector: #'negative'.
	self value: [(1/2) negative] shouldnt: [:r | r]
		conformTo: #'number' selector: #'negative'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXnotEqualityOp
	" <Object>#~= "
	#'Numeric'.
"	The value of receiver ~= comparand is true if and only if the value of
comparand ~= receiver would also be true.
"
	self value: [fractionHalf ~= (2/3)]
		should: [:r | r] conformTo: #'Object' selector: #'~='.

	self value: [smallInt2 ~= (6/2)]
		should: [:r | r] conformTo: #'Object' selector: #'~='.

	self value: [fractionHalf ~= fractionHalf]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'~='.

	self value: [smallInt2 ~= (4/2)]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'~='.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXnotIdentityOp
	" <Object>#~~ "
	#'Numeric'.
"	The value of receiver ~~ comparand is true if and only if the value of comparand ~~ receiver would also be true.
"
	self should: [fractionHalf ~~ (2/3) and: [(2/3) ~~ fractionHalf]].

	self value: [fractionHalf ~~ (2/3)]
		should: [:r | r] conformTo: #'Object' selector: #'~~'.

	self value: [smallInt2 ~~ (6/2)]
		should: [:r | r] conformTo: #'Object' selector: #'~~'.

	self value: [fractionHalf ~~ fractionHalf]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'~~'.

	self value: [smallInt2 ~~ (4/2)]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'~~'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXnumerator
	" <Fraction>#numerator "
	#'Numeric'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXpositive
	" <number>#positive "
	#'Numeric'.
	self value: [(1/2) positive] should: [:r | r]
		conformTo: #'number' selector: #'positive'.
	self value: [(-1/2) positive] shouldnt: [:r | r]
		conformTo: #'number' selector: #'positive'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXprintString
	" <Fraction>#printString "
	#'Numeric'.
	self value: [(1/2) printString] should: [:r | r = '1/2']
		conformTo: #'Fraction' selector: #'printString'.
	self value: [(1/-2) printString] should: [:r | r = '-1/2']
		conformTo: #'Fraction' selector: #'printString'.
	self value: [(3/33) printString] should: [:r | r = '1/11']
		conformTo: #'Fraction' selector: #'printString'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXquoX
	" <number>#quo: "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #( 666666666 0 0 666666666 2666666666 666666666 ).
	1 to: numList size do: [ :ndx |
		self value: [(4000000000/3) quo: (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'quo:'.
	].

"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #( -666666666 0 0 -666666666 -2666666666 -666666666 ).
	1 to: numList size do: [ :ndx |
		self value: [(4000000000/3) quo: ((numList at: ndx) negated)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'quo:'
	].

	self should: [((256/5) quo: (50/5)) = 5].

	self should: [((126/5) quo: 5) = 5].
	self should: [((125000000001/5) quo: 5000000000) = 5].
	self should: [((-125000000001/5) quo: -5000000000) = 5].
	self should: [((131/5) quo: 5.1) = 5].
	self should: [((131/5) quo: 5.1s1) = 5].

	self value: [0 quo: fractionHalf] should: [:r | r = 0]
		conformTo: #'number' selector: #'quo:'.

	"If the operand has a value of zero the ZeroDivide exception is signaled."
	self value: [fractionHalf quo: 0] shouldRaise: ZeroDivide.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXraisedToIntegerX
	" <number>#raisedToInteger: (Return Values: <RECEIVER>)"
	| rcvr |
	#'Numeric'.
	rcvr := 51/10.
	self value: [rcvr raisedToInteger: 0] should: [:r | r = 1]
		conformTo: #'number' selector: #'raisedToInteger:' opRECEIVER: rcvr.

	self value: [rcvr raisedToInteger: 1] should: [:r | r = rcvr]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.

	self value: [rcvr raisedToInteger: 2] should: [:r | r = (2601/100)]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.

	self value: [rcvr negated raisedToInteger: 2]
		should: [:r | r = (2601/100)]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.

	self value: [rcvr raisedToInteger: -2] should: [:r | r = ( 100/2601)]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.

	"It is erroneous if the operand does not conform
		to the protocol <integer>."
	self value: [rcvr raisedToInteger: (51/10)]
		shouldRaise: ArithmeticError.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXraisedToX
	" <number>#raisedTo: "
	| numVals retVals |
	#'Numeric'.
	numVals := #(2 2.0 0 2.0s3 ) copy.
	numVals at: 3 put: (1/2).
	retVals := #(0 0.25 0.7071067811865475 0.25 ) copy.
	retVals at: 1 put: (1/4).
	1 to: numVals size do: [ :ndx |
		self value: [fractionHalf raisedTo: (numVals at: ndx)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'raisedTo:'.
	].


	retVals := #(4 4.0 1.414213562373095 4.0 ).
	1 to: numVals size do: [ :ndx |
		self value: [fractionHalf raisedTo: ((numVals at: ndx) negated)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'raisedTo:'
	].

	self value: [fractionHalf raisedTo: 0.0] should: [:r | r = 1]
		conformTo: #'number' selector: #'raisedTo:'.

	self value: [0.0 raisedTo: fractionHalf] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'raisedTo:'.

	self value: [fractionHalf raisedTo: 1.0] should: [:r | r = fractionHalf]
		conformTo: #'number' selector: #'raisedTo:'.

	"It is erroneous if the receiver equals zero
		and the operand is less than or equal to zero,"
	self value: [0.0 raisedTo: (fractionHalf negated)]
		shouldRaise: ArithmeticError.

	"	or if the receiver is less than zero."
	self value: [fractionHalf negated raisedTo: 2.0]
		shouldRaise: ArithmeticError.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXreciprocal
	" <number>#reciprocal (returnRule - :receiver) "
	#'Numeric'.
	self value: [fractionHalf reciprocal] should: [:r | r = 2]
		conformTo: #'number' selector: #'reciprocal'
		ruleReceiver: fractionHalf
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXremX
	" <number>#rem: "
	| retVals ndx num2 frac |
	#'Numeric'.
	"Within the limits of representation, the following invariant should hold:
		(receiver quo: operand)*operand + (receiver rem: operand) = receiver"
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	numList := #( 5 5.0 5.0s3 ).
	frac := (53/2).
	retVals := Array with: (3/2) with: 1.5 with: (3/2).
	ndx := 0.
	numList do: [ :num |
		ndx := ndx + 1.
		self value: [frac rem: num]
			should: [:r | r = (retVals at: ndx)
					& ((frac quo: num) * num + (frac rem: num)
						= frac)]
			conformTo: #'number' selector: #'rem:'
	].

	numList := numList collect: [ :num | num negated ].
	ndx := 0.
	numList do: [ :num |
		ndx := ndx + 1.
		self value: [frac rem: num]
			should: [:r | r = (retVals at: ndx)
					& ((frac quo: num) * num + (frac rem: num)
						= frac)]
			conformTo: #'number' selector: #'rem:'
	].

	frac := (-53/2).
	numList := #( 5 5.0 5.0s3 ).
	retVals := retVals collect: [ :num | num negated ].
	ndx := 0.
	numList do: [ :num |
		ndx := ndx + 1.
		self should: [(frac rem: num) = (retVals at: ndx)
					& ((frac quo: num) * num + (frac rem: num)
						= frac)]
	].

	ndx := 0.
	numList do: [ :num |
		ndx := ndx + 1.
		self should: [(frac rem: num) = (retVals at: ndx)
					& ((frac quo: num) * num + (frac rem: num)
						= frac)]
	].

	frac := (53/2).
	num2 := (5/2).
	self value: [frac rem: num2]
		should: [:r | r = (3/2)
				& ((frac quo: num2) * num2 + (frac rem: num2)
					= frac)]
		conformTo: #'number' selector: #'rem:'.

	frac := (20000000003/2).
	numList := #( -2000000000 2000000000 ).
	numList do: [ :num |
		self value: [frac rem: num]
			should: [:r | r = (3/2)
					& ((frac quo: num) * num + (frac rem: num)
						= frac)]
			conformTo: #'number' selector: #'rem:'
	].

	"If either the receiver or operand are of type <Float> and the operand has a value of zero, the result is implementation defined.  The implementation may signal the ZeroDivide exception or provide a continuation value "
	self value: [fractionHalf rem: 0.0] shouldRaise: ZeroDivide.
	self value: [fractionHalf rem: 0] shouldRaise: ZeroDivide.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXremainderIntegerDivideOp
	" <number>#\\ (returnRule - :receiver :operand) "
	"The remainder has the same sign as operand.
	Within the limits of representation, the following invariant should hold:

		(receiver // operand) * operand + (receiver \\ operand) = receiver
 "
	| retVals recList ndx |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	recList := #( 26 -26000000006 26000000006 26.0 0 26.0s3 ) copy.
	recList at: 5 put: (53/2).
	retVals := #( 0 1 0 0.5 1 0 ) copy.
	retVals at: 1 put: (1/2).
	retVals at: 3 put: (1/2).
	retVals at: 6 put: (1/2).
	ndx := 0.
	recList do: [ :rec |
		ndx := ndx + 1.
		self value: [rec \\ (3/2)]
			should: [:r | r = (retVals at: ndx)
					& ((rec // (3/2)) * (3/2) + (rec \\ (3/2)) = rec)]
			conformTo: #'number' selector: #'\\'
			ruleReceiver: rec operand:  (3/2).
	].

	"The remainder has the same sign as operand."
	retVals := #(-1 0 -1 -1.0 0 -1.000s3 ) copy.
	retVals at: 2 put: (-1/2).
	retVals at: 5 put: (-1/2).
	ndx := 0.
	recList do: [ :rec |
		ndx := ndx + 1.
		self value: [rec \\ (-3/2)]
			should: [:r | r = (retVals at: ndx)
					& ((rec // (-3/2)) * (-3/2) + (rec \\ (-3/2)) = rec)]
			conformTo: #'number' selector: #'\\'
			ruleReceiver: rec operand:  (-3/2).
	].

	self should: [(53/2) \\ (3/2) = 1
				& (((53/2) // (3/2)) * (3/2) + ((53/2) \\ (3/2)) = (53/2))].
	self should: [(53/2) \\ (-3/2) = (-1/2)
				& (((53/2) // (-3/2)) * (-3/2) + ((53/2) \\ (-3/2)) = (53/2))].

	self should: [0 \\ fractionHalf = 0].

	"If the operand is zero, the ZeroDivide must be signaled."
	self value: [fractionHalf \\ 0] shouldRaise: ZeroDivide.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXroundToX
	" <number>#roundTo: (returnRule - :receiver :operand) "
	| retVals frac |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	frac := (51/10).
	retVals := #(6 0 0 6.0 5 6.000s3).
	1 to: numList size do: [ :ndx |
		self value: [frac roundTo: (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'roundTo:'
			ruleReceiver: frac operand: (numList at: ndx)
	].

	self should: [(0.0 roundTo: fractionHalf) = 0.0].

	"The result is undefined if factor equals zero."
	self value: [fractionHalf / 0.0] shouldRaise: ZeroDivide.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXrounded
	" <number>#rounded "
	#'Numeric'.
	self value: [(1/3) rounded] should: [:r | r = 0]
		conformTo: #'number' selector: #'rounded'.
	self value: [(1/2) rounded] should: [:r | r = 1]
		conformTo: #'number' selector: #'rounded'.
	self value: [(-1/2) rounded] should: [:r | r = -1]
		conformTo: #'number' selector: #'rounded'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXsign
	" <number>#sign "
	#'Numeric'.
	self value: [(1/2) sign] should: [:r | r = 1]
		conformTo: #'number' selector: #'sign'.
	self value: [(-1/2) sign] should: [:r | r = -1]
		conformTo: #'number' selector: #'sign'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXsqrt
	" <number>#sqrt "
	self value: [(2601/100) sqrt] should: [:r | r closeTo: 5.1]
		conformTo: #'number' selector: #'sqrt'.
	self value: [(1/4) sqrt] should: [:r | r = 0.5]
		conformTo: #'number' selector: #'sqrt'.

	"The result is undefined if the receiver is less than zero."
	self value: [(-1/2) sqrt] shouldRaise: ArithmeticError.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXsquared
	" <number>#squared (Return Values: <RECEIVER>)"
	| rcvr |
	#'Numeric'.
	rcvr := 51/10.
	self value: [rcvr squared] should: [:r | r = (2601/100)]
		conformTo: #'number' selector: #'squared' opRECEIVER: rcvr.

	rcvr := -51/10.
	self value: [rcvr squared] should: [:r | r = (2601/100)]
		conformTo: #'number' selector: #'squared' opRECEIVER: rcvr.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXstrictlyPositive
	" <number>#strictlyPositive "
	#'Numeric'.
	self value: [(1/2) strictlyPositive] should: [:r | r]
		conformTo: #'number' selector: #'strictlyPositive'.

	self value: [(-1/2) strictlyPositive] shouldnt: [:r | r]
		conformTo: #'number' selector: #'strictlyPositive'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXsubtractOp
	" <number>#- (returnRule - :receiver :operand) "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := Array new: 6.
	retVals at: 1 put: (-3/2).
	retVals at: 2 put: (4000000001/2).
	retVals at: 3 put: (-3999999999/2).
	retVals at: 4 put: -1.5.
	retVals at: 5 put: 0.
	retVals at: 6 put: (-3/2).
	1 to: numList size do: [ :ndx |
		self value: [fractionHalf - (numList at: ndx)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'-'
			ruleReceiver: fractionHalf operand: (numList at: ndx)
	].
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtoX
	" <number>#to: "
	| start middleNdx stop2 |
	#'Numeric'.
	start := (1/2).
	numList := #( 2 2.0 0 2.0s3 ) copy.
	numList at: 3 put: (3/2).
	numList do: [ :stop |
		self value: [start to: stop]
			should: [:r | (r size = 2)
					". . . the last element in the sequence . . . is . . .[:]
						receiver + ((stop - receiver) // 1)"
					& (r last = (start + ((stop - start) // 1)))
					"The elements conform to the receiver's protocol."
					& (r allSatisfy: [ :elem |
						elem class conformsToProtocolNamed: #'Fraction'])
			]
			conformTo: #'number' selector: #'to:'
	].

	start := (3/2).
	stop2 := (4000000001/2).
	middleNdx := 1000000000.	"Check conformance of first, middle and last."
	self value: [start to: stop2]
		should: [:r | (r size = 2000000000)
				". . . the last element in the sequence . . . is . . .[:]
					receiver + ((stop - receiver) // 1)"
				& (r last = (start + ((stop2 - start) // 1)))
				"The elements conform to the receiver's protocol."
				& ((Array with: (r at: 1)
						with: (r at: middleNdx)
						with: (r at: 3)
				) allSatisfy: [ :elem |
					elem class conformsToProtocolNamed: #'Fraction'])
		]
		conformTo: #'number' selector: #'to:'.

	start := (-4000000001/2).
	stop2 := (-3/2).
	middleNdx := 1000000000.	"Check conformance of first, middle and last."
	self value: [start to: stop2]
		should: [:r | (r size = 2000000000)
				". . . the last element in the sequence . . . is . . .[:]
					receiver + ((stop - receiver) // 1)"
				& (r last = (start + ((stop2 - start) // 1)))
				"The elements conform to the receiver's protocol."
				& ((Array with: (r at: 1)
						with: (r at: middleNdx)
						with: (r at: 3)
				) allSatisfy: [ :elem |
					elem class conformsToProtocolNamed: #'Fraction'])
		]
		conformTo: #'number' selector: #'to:'.

	"The interval answered will be empty if the receiver is greater than stop."
	self value: [(1/2) to: (-1/2)]
		should: [:r | (r isEmpty)] conformTo: #'number' selector: #'to:'
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtoXbyX
	" <number>#to:by: "
	#'Numeric'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtoXbyXdoX
	" <number>#to:by:do: "
	#'Numeric'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtoXdoX
	" <number>#to:do: "
	#'Numeric'.
! !

!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtruncateToX
	" <number>#truncateTo: (returnRule - :receiver :operand) "
	| retVals frac |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	frac := (51/10).
	retVals := #(4 0 0 4.0 5 4).
	1 to: numList size do: [ :ndx |
		self value: [frac truncateTo: (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'truncateTo:'
			ruleReceiver: frac operand: (numList at: ndx)
	].

	self should: [(0.0 truncateTo: fractionHalf) = 0.0].
! !


!FractionANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtruncated
	" <number>#truncated "
	#'Numeric'.
	self value: [(1/3) truncated] should: [:r | r = 0]
		conformTo: #'number' selector: #'truncated'.
	self value: [(3/2) truncated] should: [:r | r = 1]
		conformTo: #'number' selector: #'truncated'.
	self value: [(-1/2) truncated] should: [:r | r = 0]
		conformTo: #'number' selector: #'truncated'.
! !

!FractionANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:09'!
cannonicalObject
	^1/3! !

!FractionANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:08'!
protocol
	^#'Fraction'! !


!FractionFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXnumeratorXdenominatorX
	" <Fraction factory>#numerator:denominator: "
	#'Numeric'.
! !

!FractionFactoryANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:12'!
cannonicalObject
	^Fraction! !

!FractionFactoryANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:12'!
protocol
	^#'Fraction factory'! !


!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXaddAllX
	" <abstractDictionary>#addAll: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXallSatisfyX
	" <collection>#allSatisfy: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXanySatisfyX
	" <collection>#anySatisfy: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXasArray
	" <collection>#asArray "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXasBag
	" <collection>#asBag "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXasByteArray
	" <collection>#asByteArray "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXasOrderedCollection
	" <collection>#asOrderedCollection "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXasSet
	" <collection>#asSet "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXasSortedCollection
	" <collection>#asSortedCollection "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXasSortedCollectionX
	" <collection>#asSortedCollection: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXatX
	" <abstractDictionary>#at: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXatXifAbsentPutX
	" <abstractDictionary>#at:ifAbsentPut: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXatXifAbsentX
	" <abstractDictionary>#at:ifAbsent: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXatXputX
	" <abstractDictionary>#at:put: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXcollectX
	" <abstractDictionary>#collect: (Return Values: <RECEIVER>)"
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXdetectX
	" <collection>#detect: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXdetectXifNoneX
	" <collection>#detect:ifNone: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXdoX
	" <collection>#do: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXdoXseparatedByX
	" <collection>#do:separatedBy: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXincludesKeyX
	" <abstractDictionary>#includesKey: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXincludesX
	" <collection>#includes: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXinjectXintoX
	" <collection>#inject:into: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXisEmpty
	" <collection>#isEmpty "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXkeyAtValueX
	" <abstractDictionary>#keyAtValue: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXkeyAtValueXifAbsentX
	" <abstractDictionary>#keyAtValue:ifAbsent: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXkeys
	" <abstractDictionary>#keys "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXkeysAndValuesDoX
	" <abstractDictionary>#keysAndValuesDo: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXkeysDoX
	" <abstractDictionary>#keysDo: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXnotEmpty
	" <collection>#notEmpty "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXoccurrencesOfX
	" <collection>#occurrencesOf: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXrehash
	" <collection>#rehash "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXrejectX
	" <abstractDictionary>#reject: (Return Values: <RECEIVER>)"
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXremoveAllKeysX
	" <abstractDictionary>#removeAllKeys: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXremoveAllKeysXifAbsentX
	" <abstractDictionary>#removeAllKeys:ifAbsent: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXremoveKeyX
	" <abstractDictionary>#removeKey: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXremoveKeyXifAbsentX
	" <abstractDictionary>#removeKey:ifAbsent: "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXselectX
	" <abstractDictionary>#select: (Return Values: <RECEIVER>)"
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXsize
	" <collection>#size "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXvalues
	" <abstractDictionary>#values "
	#'Collection'.
! !

!IdentityDictionaryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 07:00'!
cannonicalObject
	^IdentityDictionary new at: 1 put: 1; at: 2 put: 2; at:3 put: 3; at:4 put: 4; yourself! !

!IdentityDictionaryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:48'!
protocol
	^#'IdentityDictionary'! !


!IdentityDictionaryFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXnew
	" <IdentityDictionary factory>#new "
	#'Collection'.
! !

!IdentityDictionaryFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXnewX
	" <IdentityDictionary factory>#new: "
	#'Collection'.
! !

!IdentityDictionaryFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXwithAllX
	" <IdentityDictionary factory>#withAll: "
	#'Collection'.
! !

!IdentityDictionaryFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:48'!
cannonicalObject
	^IdentityDictionary! !

!IdentityDictionaryFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:51'!
protocol
	^#'IdentityDictionary factory'! !


!IntegerANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:16'!
cannonicalObject
	^47
	! !

!IntegerANSITest methodsFor: 'constants' stamp: 'djm 3/17/2000 17:50'!
protocol
	^#'integer'! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 10:36'!
setUp
	super setUp.
	smallInt2 := 2.
	largeNegInt2000000000 := -2000000000.
	largePosInt2000000000 := 2000000000.
	float2 := 2.0.
	fractionHalf := 1/2.
	sclDec2s3 := 2.0s3.
	numList := Array new: 6.
	numList at: 1 put: smallInt2.
	numList at: 2 put: largeNegInt2000000000.
	numList at: 3 put: largePosInt2000000000.
	numList at: 4 put: float2.
	numList at: 5 put: fractionHalf.


	numList at: 6 put: sclDec2s3.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXabs
	" <number>#abs (Return Values: <RECEIVER>) "
	| rcvr |
	#'Numeric'.
	rcvr := 2.
	self value: [rcvr abs] should: [:r | r = 2]
		conformTo: #'number' selector: #'abs' opRECEIVER: rcvr.
	rcvr := -2.
	self value: [rcvr abs] should: [:r | r = 2]
		conformTo: #'number' selector: #'abs' opRECEIVER: rcvr.
	rcvr := -2000000000.
	self value: [rcvr abs] should: [:r | r = 2000000000]
		conformTo: #'number' selector: #'abs' opRECEIVER: rcvr.
	rcvr := 2000000000.
	self value: [rcvr abs] should: [:r | r = 2000000000]
		conformTo: #'number' selector: #'abs' opRECEIVER: rcvr.
	rcvr := 0.
	self value: [rcvr abs] should: [:r | r = 0]
		conformTo: #'number' selector: #'abs' opRECEIVER: rcvr.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXaddOp
	" <number>#+ (returnRule - :receiver :operand) "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."

	retVals := #(4 -1999999998 2000000002 4.0s3 0 4.0) copy.
	retVals at: 5 put: (5/2).
	1 to: numList size do: [ :ndx |
		self value: [smallInt2 + (numList at: ndx)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'+'
			ruleReceiver: smallInt2 operand: (numList at: ndx)
	].

	retVals := #(-1999999998 -4000000000 0 -1999999998.0s3 0 -1999999998.0) copy.
	retVals at: 5 put: (-3999999999/2).
	1 to: numList size do: [ :ndx |
		self value: [largeNegInt2000000000 + (numList at: ndx)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'+'
			ruleReceiver: largeNegInt2000000000
			operand: (numList at: ndx)
	].

	retVals := #(2000000002 0 4000000000 2000000002.0s3 0 2000000002.0) copy.
	retVals at: 5 put: (4000000001/2).
	1 to: numList size do: [ :ndx |
		self value: [largePosInt2000000000 + (numList at: ndx)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'+'
			ruleReceiver: largePosInt2000000000
			operand: (numList at: ndx)
	].
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXallMaskX
	" <integer>#allMask: "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXanyMaskX
	" <integer>#anyMask: "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasFloat
	" <number>#asFloat "
	#'Numeric'.
	self value: [2 asFloat] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'asFloat'.
	self value: [-2 asFloat] should: [:r | r = -2.0]
		conformTo: #'number' selector: #'asFloat'.
	self value: [-2000000000 asFloat] should: [:r | r = -2000000000.0]
		conformTo: #'number' selector: #'asFloat'.
	self value: [2000000000 asFloat] should: [:r | r = 2000000000.0]
		conformTo: #'number' selector: #'asFloat'.
	self value: [0 asFloat] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'asFloat'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasFloatD
	" <number>#asFloatD "
	#'Numeric'.
	self value: [2 asFloatD] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'asFloatD'.
	self value: [-2 asFloatD] should: [:r | r = -2.0]
		conformTo: #'number' selector: #'asFloatD'.
	self value: [-2000000000 asFloatD] should: [:r | r = -2000000000.0]
		conformTo: #'number' selector: #'asFloatD'.
	self value: [2000000000 asFloatD] should: [:r | r = 2000000000.0]
		conformTo: #'number' selector: #'asFloatD'.
	self value: [0 asFloatD] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'asFloatD'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasFloatE
	" <number>#asFloatE "
	#'Numeric'.
	self value: [2 asFloatE] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'asFloatE'.
	self value: [-2 asFloatE] should: [:r | r = -2.0]
		conformTo: #'number' selector: #'asFloatE'.
	self value: [-2000000000 asFloatE] should: [:r | r = -2000000000.0]
		conformTo: #'number' selector: #'asFloatE'.
	self value: [2000000000 asFloatE] should: [:r | r = 2000000000.0]
		conformTo: #'number' selector: #'asFloatE'.
	self value: [0 asFloatE] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'asFloatE'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasFloatQ
	" <number>#asFloatQ "
	#'Numeric'.
	self value: [2 asFloatQ] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'asFloatQ'.
	self value: [-2 asFloatQ] should: [:r | r = -2.0]
		conformTo: #'number' selector: #'asFloatQ'.
	self value: [-2000000000 asFloatQ] should: [:r | r = -2000000000.0]
		conformTo: #'number' selector: #'asFloatQ'.
	self value: [2000000000 asFloatQ] should: [:r | r = 2000000000.0]
		conformTo: #'number' selector: #'asFloatQ'.
	self value: [0 asFloatQ] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'asFloatQ'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasFraction
	" <number>#asFraction "
	#'Numeric'.
	self value: [2 asFraction] should: [:r | r = 2]
		conformTo: #'number' selector: #'asFraction'.
	self value: [-2 asFraction] should: [:r | r = -2]
		conformTo: #'number' selector: #'asFraction'.
	self value: [-2000000000 asFraction] should: [:r | r = -2000000000]
		conformTo: #'number' selector: #'asFraction'.
	self value: [2000000000 asFraction] should: [:r | r = 2000000000]
		conformTo: #'number' selector: #'asFraction'.
	self value: [0 asFraction] should: [:r | r = 0]
		conformTo: #'number' selector: #'asFraction'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasInteger
	" <number>#asInteger "
	#'Numeric'.
	self value: [2 asInteger] should: [:r | r = 2]
		conformTo: #'number' selector: #'asInteger'.
	self value: [-2 asInteger] should: [:r | r = -2]
		conformTo: #'number' selector: #'asInteger'.
	self value: [-2000000000 asInteger] should: [:r | r = -2000000000]
		conformTo: #'number' selector: #'asInteger'.
	self value: [2000000000 asInteger] should: [:r | r = 2000000000]
		conformTo: #'number' selector: #'asInteger'.
	self value: [0 asInteger] should: [:r | r = 0]
		conformTo: #'number' selector: #'asInteger'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasScaledDecimalX
	" <integer>#asScaledDecimal: "
	#'Numeric'.
	"The number of significant digits of the answer is the same as the number of decimal digits in the receiver. The scale of the answer is 0."
	self value: [2 asScaledDecimal: 2]
		should: [:r | r = 2.0s0 & (r scale = 0)]
		conformTo: #'integer' selector: #'asScaledDecimal:'.
	self value: [-2 asScaledDecimal: 2]
		should: [:r | r = -2.0s0 & (r scale = 0)]
		conformTo: #'integer' selector: #'asScaledDecimal:'.
	self value: [-2000000000 asScaledDecimal: 2]
		should: [:r | r = -2000000000.0s0 & (r scale = 0)]
		conformTo: #'integer' selector: #'asScaledDecimal:'.
	self value: [2000000000 asScaledDecimal: 2]
		should: [:r | r = 2000000000.0s0 & (r scale = 0)]
		conformTo: #'integer' selector: #'asScaledDecimal:'.
	self value: [0 asScaledDecimal: 2] should: [:r | r = 0.0s0 & (r scale = 0)]
		conformTo: #'integer' selector: #'asScaledDecimal:'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXbetweenXandX
	" <magnitude>#between:and: "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
#'todo'."It is erroneous if the receiver  and min or max are not comparable"

	self value: [2 between: 1 and: 3]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [-2000000002 between: -2000000003 and: -2000000001]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2000000002 between: 2000000001 and: 2000000003]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2 between: 1.0 and: 3.0]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2 between: (3/2) and: (5/2)]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2 between: 1.0s3 and: 3.0s3]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.

	self value: [2 between: (3/2) and: 2000000003]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2 between: -2000000001.0 and: 3.0s3]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.

	"Num between: Num and: Num -> true"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx)
					between: (numList at: ndx)
					and: (numList at: ndx)]
			should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'
	].

	self value: [2 between: 3 and: 4]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [-2000000000 between: -2000000003 and: -2000000005]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2000000000 between: 2000000003 and: 2000000005]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2 between: 3.0 and: 5.0]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2 between: (5/2) and: (7/2)]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2 between: 3.0s3 and: 5.0s3]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.

	"??? min not min but max and vice versa -> false ???"
	self value: [2 between: 3 and: 1]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXbitAndX
	" <integer>#bitAnd: "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXbitAtX
	" <integer>#bitAt: "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXbitAtXputX
	" <integer>#bitAt:put: "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXbitOrX
	" <integer>#bitOr: "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXbitShiftX
	" <integer>#bitShift: "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXbitXorX
	" <integer>#bitXor: "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXceiling
	" <number>#ceiling "
	#'Numeric'.
	self value: [2 ceiling] should: [:r | r = 2]
		conformTo: #'number' selector: #'ceiling'.
	self value: [-2 ceiling] should: [:r | r = -2]
		conformTo: #'number' selector: #'ceiling'.
	self value: [-2000000000 ceiling] should: [:r | r = -2000000000]
		conformTo: #'number' selector: #'ceiling'.
	self value: [2000000000 ceiling] should: [:r | r = 2000000000]
		conformTo: #'number' selector: #'ceiling'.
	self value: [0 ceiling] should: [:r | r = 0]
		conformTo: #'number' selector: #'ceiling'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Numeric'.
#todo. "??? add change-side-effect test ???"
	
"
If the receiver is an identity object, return the receiver.
"
	self value: [smallInt2 copy]
		should: [:r | (r = smallInt2) & (r == smallInt2)]
		conformTo: #'Object' selector: #'copy' opRECEIVER: smallInt2.
	self value: [largeNegInt2000000000 copy]
		should: [:r | (r = largeNegInt2000000000)
					& (r ~~ largeNegInt2000000000)]
		conformTo: #'Object' selector: #'copy'
		opRECEIVER: largeNegInt2000000000.
	self value: [largePosInt2000000000 copy]
		should: [:r | (r = largePosInt2000000000)
					& (r ~~ largePosInt2000000000)]
		conformTo: #'Object' selector: #'copy'
		opRECEIVER: largePosInt2000000000.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXdenominator
	" <rational>#denominator "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXdivideOp
	" <number>#/ (returnRule - :receiver :operand) "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(1 0 0 1.0 4 1.000s3) copy.
	retVals at: 2 put: (-1/1000000000).
	retVals at: 3 put: (1/1000000000).
	1 to: numList size do: [ :ndx |
		self value: [smallInt2 / (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'/'
			ruleReceiver: smallInt2 operand: (numList at: ndx)
	].

	retVals := #(-1000000000 1 -1 -1000000000.0 -4000000000 -1000000000.000s3).
	1 to: numList size do: [ :ndx |
		self value: [largeNegInt2000000000 / (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'/'
			ruleReceiver: largeNegInt2000000000
			operand: (numList at: ndx)
	].

	retVals := #(1000000000 -1 1 1000000000.0 4000000000 1000000000.000s3).
	1 to: numList size do: [ :ndx |
		self value: [largePosInt2000000000 / (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'/'
			ruleReceiver: largePosInt2000000000
			operand: (numList at: ndx)
	].


	self value: [0 / smallInt2] should: [:r | r = 0]
		conformTo: #'number' selector: #'/'
		ruleReceiver: smallInt2 operand: 0.
	self value: [0 / largeNegInt2000000000] should: [:r | r = 0]
		conformTo: #'number' selector: #'/'
		ruleReceiver: fractionHalf operand: 0.
	self value: [0 / largePosInt2000000000] should: [:r | r = 0]
		conformTo: #'number' selector: #'/'
		ruleReceiver: fractionHalf operand: 0.

	"The implementation must signal the ZeroDivide exception."
	self value: [smallInt2 / 0] shouldRaise: ZeroDivide.
	self value: [largeNegInt2000000000 / 0] shouldRaise: ZeroDivide.
	self value: [largePosInt2000000000 / 0] shouldRaise: ZeroDivide.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXequalityOp
	" <number>#= "
	#'Numeric'.
"
	receiver = comparand	=>
	receiver hash = comparand hash
"
	self value: [smallInt2 = smallInt2]
		should: [:r | r & (smallInt2 hash = smallInt2 hash) ]
		conformTo: #'number' selector: #'='.
	self value: [ smallInt2 = 3 ]
		shouldnt: [ :r | r | (smallInt2 hash = 3 hash) ]
		conformTo: #'number' selector: #'='.
	self value: [largeNegInt2000000000 = largeNegInt2000000000]
		should: [:r | r & (largeNegInt2000000000 hash
						= largeNegInt2000000000 hash) ]
		conformTo: #'number' selector: #'='.
	self value: [largePosInt2000000000 = largePosInt2000000000]
		should: [:r | r & (largePosInt2000000000 hash
						= largePosInt2000000000 hash) ]
		conformTo: #'number' selector: #'='.

"	#( 2 2.0 2.0s3 )."
	self value: [ smallInt2 = 2 ]
		should: [ :r | r  ifTrue: [ smallInt2 hash = 2 hash ]
							ifFalse: [ smallInt2 hash ~= 2 hash ]  ]
		conformTo: #'number' selector: #'='.
	self value: [ smallInt2 = 2.0 ]
		should: [ :r | r ifTrue: [ smallInt2 hash = 2.0 hash ]
						ifFalse: [ smallInt2 hash ~= 2.0 hash ]  ]
		conformTo: #'number' selector: #'='.
	self value: [ 2.5s3 = (5/2) ]
		should: [ :r | r ifTrue: [ 2.5s3 hash = (5/2) hash ]
						ifFalse: [ 2.5s3 hash ~= (5/2) hash ]  ]
		conformTo: #'number' selector: #'='.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXeven
	" <integer>#even "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXfactorial
	" <integer>#factorial "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXfloor
	" <number>#floor "
	#'Numeric'.
	self value: [2 floor] should: [:r | r = 2]
		conformTo: #'number' selector: #'floor'.
	self value: [-2 floor] should: [:r | r = -2]
		conformTo: #'number' selector: #'floor'.
	self value: [-2000000000 floor] should: [:r | r = -2000000000]
		conformTo: #'number' selector: #'floor'.
	self value: [2000000000 floor] should: [:r | r = 2000000000]
		conformTo: #'number' selector: #'floor'.
	self value: [0 floor] should: [:r | r = 0]
		conformTo: #'number' selector: #'floor'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXfractionPart
	" <number>#fractionPart (Return Values: <RECEIVER>)"
	| rcvr |
	#'Numeric'.
	"Within the limits of representation, the following invariants should hold:

		receiver integerPart + receiver fractionPart = receiver
		receiver \\1 = receiver fractionPart	(RAH - erroneous, add #'abs')
"
	rcvr := 2.
	self value: [rcvr fractionPart]
		should: [:r | r = 0 & (rcvr integerPart + rcvr fractionPart = rcvr)
					& (rcvr \\ 1 = rcvr fractionPart abs)]
		conformTo: #'number' selector: #'fractionPart' opRECEIVER: rcvr.

	rcvr := -2.
	self value: [rcvr fractionPart]
		should: [:r | r = 0 & (rcvr integerPart + rcvr fractionPart = rcvr)
					& (rcvr \\ 1 = rcvr fractionPart abs)]
		conformTo: #'number' selector: #'fractionPart' opRECEIVER: rcvr.

	rcvr := -2000000000.
	self value: [rcvr fractionPart]
		should: [:r | r = 0 & (rcvr integerPart + rcvr fractionPart = rcvr)
					& (rcvr \\ 1 = rcvr fractionPart abs)]
		conformTo: #'number' selector: #'fractionPart' opRECEIVER: rcvr.

	rcvr := 2000000000.
	self value: [rcvr fractionPart]
		should: [:r | r = 0 & (rcvr integerPart + rcvr fractionPart = rcvr)
					& (rcvr \\ 1 = rcvr fractionPart abs)]
		conformTo: #'number' selector: #'fractionPart' opRECEIVER: rcvr.

	rcvr := 0.
	self value: [rcvr fractionPart]
		should: [:r | r = 0 & (rcvr integerPart + rcvr fractionPart = rcvr)
					& (rcvr \\ 1 = rcvr fractionPart abs)]
		conformTo: #'number' selector: #'fractionPart' opRECEIVER: rcvr.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXgcdX
	" <integer>#gcd: "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXgreaterThanOp
	" <number>#> "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."

#'todo'."It is erroneous if the receiver and operand are not comparable."
	"Small > Big -> false"
	#( 2 2000000000 2.0 2.0s3 ) do: [ :tstNum |
		self value: [1 > tstNum] shouldnt: [:r | r]
			conformTo: #'number' selector: #'>'
	].
	self value: [-2000000005 > -2000000000] shouldnt: [:r | r]
		conformTo: #'number' selector: #'>'.
	self value: [0 > (1/2)] shouldnt: [:r | r] conformTo: #'number' selector: #'>'.

	"Num > Num -> false"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) > (numList at: ndx)]
			shouldnt: [:r | r ] conformTo: #'number' selector: #'>'
	].

	"Big > Small -> true"
	#( 2 2.0 2.0s3 ) do: [ :tstNum |
		self value: [5 > tstNum] should: [:r | r]
			conformTo: #'number' selector: #'>'
	].
	self value: [9000000000 > 2000000000] should: [:r | r]
		conformTo: #'number' selector: #'>'.
	self value: [-1000000005 > -2000000000] should: [:r | r]
		conformTo: #'number' selector: #'>'.
	self value: [9 > (1/2)] should: [:r | r] conformTo: #'number' selector: #'>'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXgreaterThanOrEqualToOp
	" <magnitude>#>= "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."

#'todo'."It is erroneous if the receiver and operand are not comparable."
	"Small >= Big -> false"
	#( 2 2000000000 2.0 2.0s3 ) do: [ :tstNum |
		self value: [1 >= tstNum] shouldnt: [:r | r]
			conformTo: #'magnitude' selector: #'>='
	].
	self value: [-2000000005 >= -2000000000] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'>='.
	self value: [0 >= (1/2)] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'>='.

	"Num >= Num -> true"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) >= (numList at: ndx)]
			should: [:r | r ] conformTo: #'magnitude' selector: #'>='
	].

	"Big >= Small -> true"
	#( 2 2.0 2.0s3 ) do: [ :tstNum |
		self value: [5 >= tstNum] should: [:r | r]
			conformTo: #'magnitude' selector: #'>='
	].
	self value: [9000000000 >= 2000000000] should: [:r | r]
		conformTo: #'magnitude' selector: #'>='.
	self value: [-1000000005 >= -2000000000] should: [:r | r]
		conformTo: #'magnitude' selector: #'>='.
	self value: [9 >= (1/2)] should: [:r | r] conformTo: #'magnitude' selector: #'>'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXhash
	" <Object>#hash "
	#'Numeric'.
"	Any two objects that are considered equivalent using the #= message must have the same hash value.  More formally:

	receiver = comparand	=>
	receiver hash = comparand hash
"
#'testAnom'. "??? <Object> test of equivalence seems to confilict
				with <Number> convert then test. ???
	self shouldnt: [smallInt2 = float2].
	self shouldnt: [smallInt2 hash = float2 hash].
"
	self value: [smallInt2 hash]
		should: [:r | r = smallInt2 hash]
		conformTo: #'Object' selector: #'hash'.
	self value: [largeNegInt2000000000 hash]
		should: [:r | r = largeNegInt2000000000 hash]
		conformTo: #'Object' selector: #'hash'.
	self value: [largePosInt2000000000 hash]
		should: [:r | r = largePosInt2000000000 hash]
		conformTo: #'Object' selector: #'hash'.

	self value: [smallInt2 hash]
		should: [:r | r = (4/2) hash] conformTo: #'Object' selector: #'hash'.
	self value: [smallInt2 hash]
		should: [:r | r = (3 - 1) hash] conformTo: #'Object' selector: #'hash'.

	self value: [smallInt2 hash]
		shouldnt: [:r | r = 3 hash] conformTo: #'Object' selector: #'hash'.
	self value: [largeNegInt2000000000 hash]
		shouldnt: [:r | r = 2000000001 hash]
		conformTo: #'Object' selector: #'hash'.
	self value: [largePosInt2000000000 hash]
		shouldnt: [:r | r = 2000000001 hash]
		conformTo: #'Object' selector: #'hash'.

	self value: [smallInt2 hash]
		shouldnt: [:r | r = (6/2) hash] conformTo: #'Object' selector: #'hash'.
	self value: [smallInt2 hash]
		shouldnt: [:r | r = (2 + 1) hash] conformTo: #'Object' selector: #'hash'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXhighBit
	" <integer>#highBit "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXidentityHash
	" <Object>#identityHash "
	#'Numeric'.
	self value: [smallInt2 identityHash]
		should: [:r | r = smallInt2 identityHash]
		conformTo: #'Object' selector: #'identityHash'.
	self value: [largeNegInt2000000000 identityHash]
		should: [:r | r = largeNegInt2000000000 identityHash]
		conformTo: #'Object' selector: #'identityHash'.
	self value: [largePosInt2000000000 identityHash]
		should: [:r | r = largePosInt2000000000 identityHash]
		conformTo: #'Object' selector: #'identityHash'.

	self value: [smallInt2 identityHash]
		should: [:r | r = (4/2) identityHash]
		conformTo: #'Object' selector: #'identityHash'.
	self value: [smallInt2 identityHash]
		should: [:r | r = (3 - 1) identityHash]
		conformTo: #'Object' selector: #'identityHash'.

	self value: [smallInt2 identityHash]
		shouldnt: [:r | r = 3 identityHash]
		conformTo: #'Object' selector: #'identityHash'.
	self value: [largeNegInt2000000000 identityHash]
		shouldnt: [:r | r = 2000000001 identityHash]
		conformTo: #'Object' selector: #'identityHash'.
	self value: [largePosInt2000000000 identityHash]
		shouldnt: [:r | r = 2000000001 identityHash]
		conformTo: #'Object' selector: #'identityHash'.

	self value: [smallInt2 identityHash]
		shouldnt: [:r | r = (6/2) identityHash]
		conformTo: #'Object' selector: #'identityHash'.
	self value: [smallInt2 identityHash]
		shouldnt: [:r | r = (2 + 1) identityHash]
		conformTo: #'Object' selector: #'identityHash'.

	self shouldnt: [smallInt2 identityHash = float2 identityHash].
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXidentityOp
	" <Object>#== "
	#'Numeric'.
"	The value of receiver == comparand is true if and only if the value of comparand == receiver would also be true. If the value of receiver == comparand is true then the receiver and comparand must have equivalent identity hash values.  Or more formally:

	receiver == comparand =>
	receiver identityHash = comparand identityHash
"
	self shouldnt: [smallInt2 == float2].
	self shouldnt: [smallInt2 identityHash == float2 identityHash].

	self value: [smallInt2 == smallInt2]
		should: [:r | r] conformTo: #'Object' selector: #'=='.
	self value: [largeNegInt2000000000 == largeNegInt2000000000]
		should: [:r | r] conformTo: #'Object' selector: #'=='.
	self value: [largePosInt2000000000 == largePosInt2000000000]
		should: [:r | r] conformTo: #'Object' selector: #'=='.

	self value: [smallInt2 == (4/2)]
		should: [:r | r] conformTo: #'Object' selector: #'=='.
	self value: [smallInt2 == (3 - 1)]
		should: [:r | r] conformTo: #'Object' selector: #'=='.

	self value: [smallInt2 == 3]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'=='.
	self value: [largeNegInt2000000000 == 2000000001]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'=='.
	self value: [largePosInt2000000000 == 2000000001]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'=='.

	self value: [smallInt2 == (6/2)]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'=='.
	self value: [smallInt2 == (2 + 1)]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'=='.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXintegerDivideOp
	" <number>#// "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	"The sign of the result is positive if the receiver and operand
		have the same sign, and negative if the signs are different."
	retVals := #(1 -1 0 1 4 1).
	1 to: numList size do: [ :ndx |
		self value: [smallInt2 // (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'//'.
	].

	retVals := #(-1 0 -1 -1 -4 -1).
	1 to: numList size do: [ :ndx |
		self value: [smallInt2 // ((numList at: ndx) negated)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'//'
	].

	self should: [26 // 5.1 = 5].
	self should: [26 // 5 = 5].
	self should: [25500000000 // 5000000000 = 5].
	self should: [-25500000000 // -5000000000 = 5].
	self should: [26 // (51/10) = 5].
	self should: [26 // 5.1s1 = 5].

	self value: [0 // smallInt2] should: [:r | r = 0]
		conformTo: #'number' selector: #'//'.

	"If the operand has a value of zero the ZeroDivide exception is signaled."
	self value: [smallInt2 // 0] shouldRaise: ZeroDivide.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXintegerPart
	" <number>#integerPart (returnRule - :receiver) "
	| rcvr |
	#'Numeric'.
	rcvr := 2.
	self value: [rcvr integerPart] should: [:result | result = 2]
		conformTo: #'number' selector: #'integerPart' ruleReceiver: rcvr.

	rcvr := -2.
	self value: [rcvr integerPart] should: [:result | result = -2]
		conformTo: #'number' selector: #'integerPart' ruleReceiver: rcvr.

	rcvr := -2000000000.
	self value: [rcvr integerPart] should: [:result | result = -2000000000]
		conformTo: #'number' selector: #'integerPart' ruleReceiver: rcvr.

	rcvr := 2000000000.
	self value: [rcvr integerPart] should: [:result | result = 2000000000]
		conformTo: #'number' selector: #'integerPart' ruleReceiver: rcvr.

	rcvr := 0.
	self value: [rcvr integerPart] should: [:result | result = 0]
		conformTo: #'number' selector: #'integerPart' ruleReceiver: rcvr.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXisKindOfX
	" <Object>#isKindOf: "
	#'Numeric'.
"	The return value is unspecified if the receiver is a class object or candidateClass is not a class object.
"
		#'Fundamental'.
#todo. "Fix find a test for unspecified rule above ???"
	self value: [smallInt2 isKindOf: Integer]
		should: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.
	self value: [largeNegInt2000000000 isKindOf: Integer]
		should: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.
	self value: [largePosInt2000000000 isKindOf: Integer]
		should: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.

	"Metaclass tests:"
	self value: [smallInt2 class isKindOf: (Integer class)]
		should: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.
	self value: [largeNegInt2000000000 class isKindOf: (Integer class)]
		should: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.
	self value: [largePosInt2000000000 class isKindOf: (Integer class)]
		should: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.

	"Inherit tests:"
	self value: [smallInt2 class isKindOf: (Integer class)]
		should: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.
	self value: [smallInt2 class isKindOf: (Number class)]
		should: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.

	self value: [smallInt2 isKindOf: Float]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXlcmX
	" <integer>#lcm: "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXlessThanOp
	" <number>#< "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."

#'todo'."It is erroneous if the receiver and operand are not comparable."
	"Small < Big -> true"
	#( 2 2000000000 2.0 2.0s3 ) do: [ :tstNum |
		self value: [1 < tstNum] should: [:r | r]
			conformTo: #'number' selector: #'<'
	].
	self value: [-2000000005 < -2000000000] should: [:r | r]
		conformTo: #'number' selector: #'<'.
	self value: [0 < (1/2)] should: [:r | r] conformTo: #'number' selector: #'<'.

	"Num < Num -> false"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) < (numList at: ndx)]
			shouldnt: [:r | r ] conformTo: #'number' selector: #'<'
	].

	"Big < Small -> false"
	#( 2 2.0 2.0s3 ) do: [ :tstNum |
		self value: [5 < tstNum] shouldnt: [:r | r]
			conformTo: #'number' selector: #'<'
	].
	self value: [9000000000 < 2000000000] shouldnt: [:r | r]
		conformTo: #'number' selector: #'<'.
	self value: [-1000000005 < -2000000000] shouldnt: [:r | r]
		conformTo: #'number' selector: #'<'.
	self value: [9 < (1/2)] shouldnt: [:r | r] conformTo: #'number' selector: #'<'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXlessThanOrEqualToOp
	" <magnitude>#<= "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."

#'todo'."It is erroneous if the receiver and operand are not comparable."
	"Small <= Big -> true"
	#( 2 2000000000 2.0 2.0s3 ) do: [ :tstNum |
		self value: [1 <= tstNum] should: [:r | r]
			conformTo: #'magnitude' selector: #'<='
	].
	self value: [-2000000005 <= -2000000000] should: [:r | r]
		conformTo: #'magnitude' selector: #'<='.
	self value: [0 <= (1/2)] should: [:r | r]
		conformTo: #'magnitude' selector: #'<='.

	"Num <= Num -> false"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) <= (numList at: ndx)]
			should: [:r | r ] conformTo: #'magnitude' selector: #'<='
	].

	"Big <= Small -> false"
	#( 2 2.0 2.0s3 ) do: [ :tstNum |
		self value: [5 <= tstNum] shouldnt: [:r | r]
			conformTo: #'magnitude' selector: #'<='
	].
	self value: [9000000000 <= 2000000000] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'<='.
	self value: [-1000000005 <= -2000000000] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'<='.
	self value: [9 <= (1/2)] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'<='.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXmaxX
	" <magnitude>#max: "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
#'todo'."It is erroneous if the receiver and operand are not comparable."

	self value: [2 max: 3] should: [:r | r = 3]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [-3000000000 max: -2000000000] should: [:r | r = -2000000000]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [2000000000 max: 2000000003] should: [:r | r = 2000000003]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [2 max: 3.0] should: [:r | r = 3.0]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [2 max: (5/2)] should: [:r | r = (5/2)]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [2 max: 3.0s3] should: [:r | r = 3.0s3]
		conformTo: #'magnitude' selector: #'max:'.

	"Num max: Num -> Num"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) max: (numList at: ndx)]
			should: [:r | r = (numList at: ndx)]
			conformTo: #'magnitude' selector: #'max:'
	].
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXminX
	" <magnitude>#min: "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
#'todo'."It is erroneous if the receiver and operand are not comparable."

	self value: [2 min: 1] should: [:r | r = 1]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [-1000000000 min: -2000000000] should: [:r | r = -2000000000]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [2000000003 min: 2000000001] should: [:r | r = 2000000001]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [2 min: 1.0] should: [:r | r = 1.0]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [2 min: (3/2)] should: [:r | r = (3/2)]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [2 min: 1.0s5] should: [:r | r = 1.0s5]
		conformTo: #'magnitude' selector: #'min:'.

	"Num min: Num -> Num"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) min: (numList at: ndx)]
			should: [:r | r = (numList at: ndx)]
			conformTo: #'magnitude' selector: #'min:'
	].
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXmultiplyOp
	" <number>#* (returnRule - :receiver :operand) "
	| retVals negInt2 posInt2 |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(4 -4000000000 4000000000 4.0 1 4.000s3).
	1 to: numList size do: [ :ndx |
		self value: [smallInt2 * (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'*'
			ruleReceiver: smallInt2 operand: (numList at: ndx)
	].

	retVals := #(-4000000000 4000000000000000000 -4000000000000000000 -4000000000.0 -1000000000 -4000000000.000s3).
	1 to: numList size do: [ :ndx |
		self value: [largeNegInt2000000000 * (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'*'
			ruleReceiver: largeNegInt2000000000
			operand: (numList at: ndx)
	].

	retVals := #(4000000000 -4000000000000000000 4000000000000000000 4000000000.0 1000000000 4000000000.000s3).
	1 to: numList size do: [ :ndx |
		self value: [largePosInt2000000000 * (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'*'
			ruleReceiver: largePosInt2000000000
			operand: (numList at: ndx)
	].

	negInt2 := -2.
	posInt2 := 2.
	self value: [negInt2 * posInt2] should: [:result | result = -4]
		conformTo: #'number' selector: #'*'
		ruleReceiver: negInt2 operand: posInt2.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXnegated
	" <number>#negated (Return Values: <RECEIVER>)"
	| rcvr |
	#'Numeric'.
	rcvr := 2.
	self value: [rcvr negated] should: [:r | r = -2]
		conformTo: #'number' selector: #'negated' opRECEIVER: rcvr.

	rcvr := -2.
	self value: [rcvr negated] should: [:r | r = 2]
		conformTo: #'number' selector: #'negated' opRECEIVER: rcvr.

	rcvr := -2000000000.
	self value: [rcvr negated] should: [:r | r = 2000000000]
		conformTo: #'number' selector: #'negated' opRECEIVER: rcvr.

	rcvr := 2000000000.
	self value: [rcvr negated] should: [:r | r = -2000000000]
		conformTo: #'number' selector: #'negated' opRECEIVER: rcvr.

	rcvr := 0.
	self value: [rcvr negated] should: [:r | r = 0]
		conformTo: #'number' selector: #'negated' opRECEIVER: rcvr.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXnegative
	" <number>#negative "
	#'Numeric'.
	self value: [-2 negative] should: [:r | r]
		conformTo: #'number' selector: #'negative'.
	self value: [-2000000000 negative] should: [:r | r]
		conformTo: #'number' selector: #'negative'.
	self value: [2 negative] shouldnt: [:r | r]
		conformTo: #'number' selector: #'negative'.
	self value: [2000000000 negative] shouldnt: [:r | r]
		conformTo: #'number' selector: #'negative'.
	self value: [0 negative] shouldnt: [:r | r]
		conformTo: #'number' selector: #'negative'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXnoMaskX
	" <integer>#noMask: "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXnotEqualityOp
	" <Object>#~= "
	#'Numeric'.
"	The value of receiver ~= comparand is true if and only if the value of
comparand ~= receiver would also be true.
"
#'testAnom'. "??? <Object> test of equivalence seems to confilict
				with <Number> convert then test. ???
	self should: [(smallInt2 ~= float2) & (float2 ~= smallInt2)].
"

	self value: [smallInt2 ~= 3]
		should: [:r | r] conformTo: #'Object' selector: #'~='.
	self value: [largeNegInt2000000000 ~= 2000000001]
		should: [:r | r] conformTo: #'Object' selector: #'~='.
	self value: [largePosInt2000000000 ~= 2000000001]
		should: [:r | r] conformTo: #'Object' selector: #'~='.

	self value: [smallInt2 ~= (6/2)]
		should: [:r | r] conformTo: #'Object' selector: #'~='.
	self value: [smallInt2 ~= (2 + 1)]
		should: [:r | r] conformTo: #'Object' selector: #'~='.

	self value: [smallInt2 ~= smallInt2]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'~='.
	self value: [largeNegInt2000000000 ~= largeNegInt2000000000]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'~='.
	self value: [largePosInt2000000000 ~= largePosInt2000000000]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'~='.

	self value: [smallInt2 ~= (4/2)]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'~='.
	self value: [smallInt2 ~= (3 - 1)]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'~='.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXnotIdentityOp
	" <Object>#~~ "
	#'Numeric'.
"	The value of receiver ~~ comparand is true if and only if the value of comparand ~~ receiver would also be true.
"
	self should: [smallInt2 ~~ float2 and: [float2 ~~ smallInt2]].

	self value: [smallInt2 ~~ 3]
		should: [:r | r] conformTo: #'Object' selector: #'~~'.
	self value: [largeNegInt2000000000 ~~ 2000000001]
		should: [:r | r] conformTo: #'Object' selector: #'~~'.
	self value: [largePosInt2000000000 ~~ 2000000001]
		should: [:r | r] conformTo: #'Object' selector: #'~~'.

	self value: [smallInt2 ~~ (6/2)]
		should: [:r | r] conformTo: #'Object' selector: #'~~'.
	self value: [smallInt2 ~~ (2 + 1)]
		should: [:r | r] conformTo: #'Object' selector: #'~~'.

	self value: [smallInt2 ~~ smallInt2]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'~~'.
	self value: [largeNegInt2000000000 ~~ largeNegInt2000000000]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'~~'.
	self value: [largePosInt2000000000 ~~ largePosInt2000000000]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'~~'.

	self value: [smallInt2 ~~ (4/2)]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'~~'.
	self value: [smallInt2 ~~ (3 - 1)]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'~~'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXnumerator
	" <rational>#numerator "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXodd
	" <integer>#odd "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXpositive
	" <number>#positive "
	#'Numeric'.
	self value: [2 positive] should: [:r | r]
		conformTo: #'number' selector: #'positive'.
	self value: [2000000000 positive] should: [:r | r]
		conformTo: #'number' selector: #'positive'.
	self value: [0 positive] should: [:r | r]
		conformTo: #'number' selector: #'positive'.
	self value: [-2 positive] shouldnt: [:r | r]
		conformTo: #'number' selector: #'positive'.
	self value: [-2000000000 positive] shouldnt: [:r | r]
		conformTo: #'number' selector: #'positive'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXprintOnXbaseXshowRadixX
	" <integer>#printOn:base:showRadix: "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXprintString
	" <number>#printString "
	#'Numeric'.
	self value: [2 printString] should: [:r | r = '2']
		conformTo: #'number' selector: #'printString'.
	self value: [-2 printString] should: [:r | r = '-2']
		conformTo: #'number' selector: #'printString'.
	self value: [2000000000 printString] should: [:r | r = '2000000000']
		conformTo: #'number' selector: #'printString'.
	self value: [-2000000000 printString] should: [:r | r = '-2000000000']
		conformTo: #'number' selector: #'printString'.
	self value: [0 printString] should: [:r | r = '0']
		conformTo: #'number' selector: #'printString'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXprintStringRadixX
	" <integer>#printStringRadix: "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXquoX
	" <number>#quo: "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(1 0 0 1 4 1 ).
	1 to: numList size do: [ :ndx |
		self value: [smallInt2 quo: (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'quo:'.
	].

	retVals := #(-1 0 0 -1 -4 -1 ).
	1 to: numList size do: [ :ndx |
		self value: [smallInt2 quo: ((numList at: ndx) negated)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'quo:'
	].

	self should: [(26 quo: 5.1) = 5].
	self should: [(26 quo: 5) = 5].
	self should: [(25500000000 quo: 5000000000) = 5].
	self should: [(-25500000000 quo: -5000000000) = 5].
	self should: [(26 quo: (51/10)) = 5].
	self should: [(26 quo: 5.1s1) = 5].

	self value: [0 quo: smallInt2] should: [:r | r = 0]
		conformTo: #'number' selector: #'quo:'.

	"If the operand has a value of zero the ZeroDivide exception is signaled."
	self value: [smallInt2 quo: 0] shouldRaise: ZeroDivide.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXraisedToIntegerX
	" <number>#raisedToInteger: (Return Values: <RECEIVER>)"
	| rcvr |
	#'Numeric'.
	rcvr := 2.
	self value: [rcvr raisedToInteger: 0] should: [:r | r = 1]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.

	self value: [rcvr raisedToInteger: 1] should: [:r | r = rcvr]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.

	self value: [rcvr raisedToInteger: 2] should: [:r | r = 4]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.

	self value: [rcvr negated raisedToInteger: 2] should: [:r | r = 4]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.

	self value: [rcvr raisedToInteger: -2] should: [:r | r = (1/4)]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.

#'todo'."??? these take 5-10 min.
	self value: [rcvr raisedToInteger: 2000000000]
		should: [:r | r =  ???]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.
	self value: [rcvr raisedToInteger: -2000000000]
		should: [:r | r =  ???]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.
"
	rcvr := 2000000000.
	self value: [rcvr raisedToInteger: 2]
		should: [:r | r = 4000000000000000000]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.

	rcvr := -2000000000.
	self value: [rcvr raisedToInteger: 2]
		should: [:r | r = 4000000000000000000]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.

	"It is erroneous if the operand does not conform to the protocol <integer>."
	self value: [2 raisedToInteger: 2.0] shouldRaise: ArithmeticError.
	self value: [0 raisedToInteger: -2] shouldRaise: ZeroDivide.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXraisedToX
	" <number>#raisedTo: "
	| numVals retVals |
	#'Numeric'.
	numVals := #(2 2.0 0 2.0s3 ) copy.
	numVals at: 3 put: (1/2).
	retVals := #(4 4.0 1.414213562373095 4.0 ).
	1 to: numVals size do: [ :ndx |
		self value: [smallInt2 raisedTo: (numVals at: ndx)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'raisedTo:'.
	].


	retVals := #(0 0.25 0.7071067811865475 0.25 ) copy.
	retVals at: 1 put: (1/4).
	1 to: numVals size do: [ :ndx |
		self value: [smallInt2 raisedTo: ((numVals at: ndx) negated)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'raisedTo:'
	].

	self value: [smallInt2 raisedTo: 0] should: [:r | r = 1]
		conformTo: #'number' selector: #'raisedTo:'.

	self value: [0 raisedTo: smallInt2] should: [:r | r = 0]
		conformTo: #'number' selector: #'raisedTo:'.

	self value: [smallInt2 raisedTo: 1] should: [:r | r = smallInt2]
		conformTo: #'number' selector: #'raisedTo:'.

	"It is erroneous if the receiver equals zero
		and the operand is less than or equal to zero,"
	self value: [0 raisedTo: -2] shouldRaise: ArithmeticError.

	"	or if the receiver is less than zero."
	self value: [smallInt2 negated raisedTo: 2] shouldRaise: ArithmeticError.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXreciprocal
	" <number>#reciprocal (returnRule - :receiver) "
	#'Numeric'.

	self value: [smallInt2 reciprocal] should: [:r | r = (1.0/smallInt2)]
		conformTo: #'number' selector: #'reciprocal'
		ruleReceiver: smallInt2.

	self value: [smallInt2 negated reciprocal]
		should: [:r | r = (1/(smallInt2 negated))]
		conformTo: #'number' selector: #'reciprocal'
		ruleReceiver: (smallInt2 negated).

	self value: [largePosInt2000000000 reciprocal]
		should: [:r | r = (1/largePosInt2000000000)]
		conformTo: #'number' selector: #'reciprocal'
		ruleReceiver: largePosInt2000000000.

	self value: [largeNegInt2000000000 reciprocal]
		should: [:r | r = (1/largeNegInt2000000000)]
		conformTo: #'number' selector: #'reciprocal'
		ruleReceiver: largeNegInt2000000000.

	"Signal a ZeroDivide exception if the receiver is equal to zero."
	self value: [0 reciprocal] shouldRaise: ZeroDivide.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXremX
	" <number>#rem: "
	| retVals ndx num2 int |
	#'Numeric'.
	"Within the limits of representation, the following invariant should hold:
		(receiver quo: operand)*operand + (receiver rem: operand) = receiver"
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	numList := #( 5 5.0 5.0s3 ).
	int := 26.
	retVals := #(1 1.0 1.000s3 ).
	ndx := 0.
	numList do: [ :num |
		ndx := ndx + 1.
		self value: [int rem: num]
			should: [:r | r = (retVals at: ndx)
					& ((int quo: num) * num + (int rem: num) = int)]
			conformTo: #'number' selector: #'rem:'
	].

	numList := numList collect: [ :num | num negated ].
	ndx := 0.
	numList do: [ :num |
		ndx := ndx + 1.
		self value: [int rem: num]
			should: [:r | r = (retVals at: ndx)
					& ((int quo: num) * num + (int rem: num) = int)]
			conformTo: #'number' selector: #'rem:'
	].

	int := -26.
	numList := #( 5 5.0 5.0s3 ).
	retVals := retVals collect: [ :num | num negated ].
	ndx := 0.
	numList do: [ :num |
		ndx := ndx + 1.
		self should: [(int rem: num) = (retVals at: ndx)
					& ((int quo: num) * num + (int rem: num) = int)]
	].

	numList := numList collect: [ :num | num negated ].
	ndx := 0.
	numList do: [ :num |
		ndx := ndx + 1.
		self should: [(int rem: num) = (retVals at: ndx)
					& ((int quo: num) * num + (int rem: num) = int)]
	].

	int := 26.
	num2 := (5/2).
	self value: [int rem: num2]
		should: [:r | r = 1
				& ((int quo: num2) * num2 + (int rem: num2) = int)]
		conformTo: #'number' selector: #'rem:'.

	int :=  10000000001.
	numList := #(-2000000000 2000000000).
	retVals := #(1 1.0 1.000s3 ).
	ndx := 0.
	numList do: [ :num |
		self value: [int rem: num]
			should: [:r | r = (retVals at: 1)
					& ((int quo: num) * num + (int rem: num) = int)]
			conformTo: #'number' selector: #'rem:'
	].

	"If either the receiver or operand are of type <Float> and the operand has a value of zero, the result is implementation defined.  The implementation may signal the ZeroDivide exception or provide a continuation value "
	self value: [smallInt2 rem: 0.0] shouldRaise: ZeroDivide.
	self value: [smallInt2 rem: 0] shouldRaise: ZeroDivide.
	self value: [smallInt2 rem: 0s0] shouldRaise: ZeroDivide.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXremainderIntegerDivideOp
	" <number>#\\ (returnRule - :receiver :operand) "
	"The remainder has the same sign as operand.
	Within the limits of representation, the following invariant should hold:

		(receiver // operand) * operand + (receiver \\ operand) = receiver
 "
	| retVals recList ndx |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	recList := #( 26 -26000000001 26000000001 26.0 0 26.0s3 ) copy.
	recList at: 5 put: (53/2).
	retVals := #(1 4 1 1.0 0 1.000s3 ) copy.
	retVals at: 5 put: (3/2).
	ndx := 0.
	recList do: [ :rec |
		ndx := ndx + 1.
		self value: [rec \\ 5]
			should: [:r | r = (retVals at: ndx)
					& ((rec // 5) * 5 + (rec \\ 5) = rec)]
			conformTo: #'number' selector: #'\\'
			ruleReceiver: rec operand:  5.
	].

	"The remainder has the same sign as operand."
	retVals := #(-4 -1 -4 -4.0 0 -4.000s3 ) copy.
	retVals at: 5 put: (-7/2).
	ndx := 0.
	recList do: [ :rec |
		ndx := ndx + 1.
		self value: [rec \\ -5]
			should: [:r | r = (retVals at: ndx)
					& ((rec // -5) * -5 + (rec \\ -5) = rec)]
			conformTo: #'number' selector: #'\\'
			ruleReceiver: rec operand:  -5.
	].

	self should: [26 \\ 5 = 1 & ((26 // 5) * 5 + (26 \\ 5) = 26)].
	self should: [26 \\ -5 = -4 & ((26 // -5) * -5 + (26 \\ -5) = 26)].

	self should: [0 \\ smallInt2 = 0].
	self should: [0 \\ largeNegInt2000000000 = 0].
	self should: [0 \\ largePosInt2000000000 = 0].

	"If the operand is zero, the implementation may signal
		the ZeroDivide exception or provide a continuation value."
	self value: [smallInt2 \\ 0] shouldRaise: ZeroDivide.
	self value: [largeNegInt2000000000 \\ 0] shouldRaise: ZeroDivide.
	self value: [largePosInt2000000000 \\ 0] shouldRaise: ZeroDivide.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXroundToX
	" <number>#roundTo: (returnRule - :receiver :operand) "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(2 0 0 2.0 2 2.000s3).
	1 to: numList size do: [ :ndx |
		self value: [smallInt2 roundTo: (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'roundTo:'
			ruleReceiver: smallInt2 operand: (numList at: ndx)
	].

	self should: [(0 roundTo: smallInt2) = 0].

	"The result is undefined if factor equals zero."
	self value: [smallInt2 / 0] shouldRaise: ZeroDivide.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXrounded
	" <number>#rounded "
	#'Numeric'.
	self value: [2 rounded] should: [:r | r = 2]
		conformTo: #'number' selector: #'rounded'.
	self value: [-2 rounded] should: [:r | r = -2]
		conformTo: #'number' selector: #'rounded'.
	self value: [-2000000000 rounded] should: [:r | r = -2000000000]
		conformTo: #'number' selector: #'rounded'.
	self value: [2000000000 rounded] should: [:r | r = 2000000000]
		conformTo: #'number' selector: #'rounded'.
	self value: [0 rounded] should: [:r | r = 0]
		conformTo: #'number' selector: #'rounded'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXsign
	" <number>#sign "
	#'Numeric'.
	self value: [2 sign] should: [:r | r = 1]
		conformTo: #'number' selector: #'sign'.
	self value: [2000000000 sign] should: [:r | r = 1]
		conformTo: #'number' selector: #'sign'.
	self value: [0 sign] should: [:r | r = 0]
		conformTo: #'number' selector: #'sign'.
	self value: [-2 sign] should: [:r | r = -1]
		conformTo: #'number' selector: #'sign'.
	self value: [-2000000000 sign] should: [:r | r = -1]
		conformTo: #'number' selector: #'sign'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXsqrt
	" <number>#sqrt "
	#'Numeric'.
	self value: [4 sqrt] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'sqrt'.
	self value: [2000000000 sqrt] should: [:r | r closeTo: 44721.3595499958]
		conformTo: #'number' selector: #'sqrt'.
	self value: [0 sqrt] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'sqrt'.

	"The result is undefined if the receiver is less than zero."
	self value: [-2000000000 sqrt] shouldRaise: ArithmeticError.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXsquared
	" <number>#squared (Return Values: <RECEIVER>)"
	| rcvr |
	#'Numeric'.
	self value: [smallInt2 squared] should: [:r | r = 4]
		conformTo: #'number' selector: #'squared' opRECEIVER: smallInt2.

	rcvr := -2.
	self value: [rcvr squared] should: [:r | r = 4]
		conformTo: #'number' selector: #'squared' opRECEIVER: rcvr.

	self value: [largeNegInt2000000000 squared]
		should: [:r | r = 4000000000000000000]
		conformTo: #'number' selector: #'squared'
		opRECEIVER: largeNegInt2000000000.

	self value: [largePosInt2000000000 squared]
		should: [:r | r = 4000000000000000000]
		conformTo: #'number' selector: #'squared'
		opRECEIVER: largePosInt2000000000.

	rcvr := 0.
	self value: [rcvr squared] should: [:r | r = 0]
		conformTo: #'number' selector: #'squared' opRECEIVER: rcvr.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXstrictlyPositive
	" <number>#strictlyPositive "
	#'Numeric'.
	self value: [2 strictlyPositive] should: [:r | r]
		conformTo: #'number' selector: #'strictlyPositive'.
	self value: [2000000000 strictlyPositive] should: [:r | r]
		conformTo: #'number' selector: #'strictlyPositive'.

	self value: [0 strictlyPositive] shouldnt: [:r | r]
		conformTo: #'number' selector: #'strictlyPositive'.
	self value: [-2 strictlyPositive] shouldnt: [:r | r]
		conformTo: #'number' selector: #'strictlyPositive'.
	self value: [-2000000000 strictlyPositive] shouldnt: [:r | r]
		conformTo: #'number' selector: #'strictlyPositive'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXsubtractOp
	" <number>#- (returnRule - :receiver :operand) "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."

	retVals := #(0 2000000002 -1999999998 0.0s3 0 0.0) copy.
	retVals at: 5 put: (3/2).
	1 to: numList size do: [ :ndx |
		self value: [smallInt2 - (numList at: ndx)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'-'
			ruleReceiver: smallInt2 operand: (numList at: ndx)
	].

	retVals := #(-2000000002 0 -4000000000 -2000000002.0s3 0 -2000000002.0) copy.
	retVals at: 5 put: (-4000000001/2).
	1 to: numList size do: [ :ndx |
		self value: [largeNegInt2000000000 - (numList at: ndx)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'-'
			ruleReceiver: largeNegInt2000000000
			operand: (numList at: ndx)
	].

	retVals := #(1999999998 4000000000 0  1999999998.0s3 0  1999999998.0) copy.
	retVals at: 5 put: (3999999999/2).
	1 to: numList size do: [ :ndx |
		self value: [largePosInt2000000000 - (numList at: ndx)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'-'
			ruleReceiver: largePosInt2000000000
			operand: (numList at: ndx)
	].
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtoX
	" <number>#to: "
	| start middleNdx stop2 |
	#'Numeric'.
	start := 1.
	numList := #( 2 2.0 0 2.0s3 ) copy.
	numList at: 3 put: (5/2).
	numList do: [ :stop |
		self value: [start to: stop]
			should: [:r | (r size = 2)
					". . . the last element in the sequence . . . is . . .[:]
						receiver + ((stop - receiver) // 1)"
					& (r last = (start + ((stop - start) // 1)))
					"The elements conform to the receiver's protocol."
					& (r allSatisfy: [ :elem |
						elem class conformsToProtocolNamed: #'integer'])
			]
			conformTo: #'number' selector: #'to:'
	].

	stop2 := 2000000000.
	middleNdx := 1000000000.	"Check conformance of first, middle and last."
	self value: [start to: stop2]
		should: [:r | (r size = 2000000000)
				". . . the last element in the sequence . . . is . . .[:]
					receiver + ((stop - receiver) // 1)"
				& (r last = (start + ((stop2 - start) // 1)))
				"The elements conform to the receiver's protocol."
				& ((Array with: (r at: 1)
						with: (r at: middleNdx)
						with: (r at: 3)
				) allSatisfy: [ :elem |
					elem class conformsToProtocolNamed: #'integer'])
		]
		conformTo: #'number' selector: #'to:'.

	start := -2000000000.
	stop2 := -1.
	middleNdx := 1000000000.	"Check conformance of first, middle and last."
	self value: [start to: stop2]
		should: [:r | (r size = 2000000000)
				". . . the last element in the sequence . . . is . . .[:]
					receiver + ((stop - receiver) // 1)"
				& (r last = (start + ((stop2 - start) // 1)))
				"The elements conform to the receiver's protocol."
				& ((Array with: (r at: 1)
						with: (r at: middleNdx)
						with: (r at: 3)
				) allSatisfy: [ :elem |
					elem class conformsToProtocolNamed: #'integer'])
		]
		conformTo: #'number' selector: #'to:'.

	"The interval answered will be empty if the receiver is greater than stop."
	self value: [1 to: -1]
		should: [:r | (r isEmpty)] conformTo: #'number' selector: #'to:'
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtoXbyX
	" <number>#to:by: "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtoXbyXdoX
	" <number>#to:by:do: "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtoXdoX
	" <number>#to:do: "
	#'Numeric'.
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtruncateToX
	" <number>#truncateTo: (returnRule - :receiver :operand) "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(2 0 0 2.0 2 2.000s3).
	1 to: numList size do: [ :ndx |
		self value: [smallInt2 truncateTo: (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'truncateTo:'
			ruleReceiver: smallInt2 operand: (numList at: ndx)
	].

	self should: [(0 truncateTo: smallInt2) = 0].
! !

!IntegerANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtruncated
	" <number>#truncated "
	self value: [2 truncated] should: [:r | r = 2]
		conformTo: #'number' selector: #'truncated'.
	self value: [-2 truncated] should: [:r | r = -2]
		conformTo: #'number' selector: #'truncated'.
	self value: [-2000000000 truncated] should: [:r | r = -2000000000]
		conformTo: #'number' selector: #'truncated'.
	self value: [2000000000 truncated] should: [:r | r = 2000000000]
		conformTo: #'number' selector: #'truncated'.
	self value: [0 truncated] should: [:r | r = 0]
		conformTo: #'number' selector: #'truncated'.
! !


!IntervalANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXkeysAndValuesDoX
	" <sequencedReadableCollection>#keysAndValuesDo: "
	#'Collection'.
! !

!IntervalANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXlast
	" <sequencedReadableCollection>#last "
	#'Collection'.
! !

!IntervalANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:51'!
cannonicalObject
	^1 to: 4! !

!IntervalANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:52'!
protocol
	^#Interval! !


!IntervalANSITest class methodsFor: 'instance creation' stamp: 'rej 5/27/2000 16:16'!
helperClassesDo: aBlock
	super helperClassesDo: aBlock.
	aBlock value: SequencedReadableCollectionHelper
! !


!IntervalFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXfromXtoX
	" <Interval factory>#from:to: "
	#'Collection'.
! !

!IntervalFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXfromXtoXbyX
	" <Interval factory>#from:to:by: "
	#'Collection'.
! !

!IntervalFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:53'!
cannonicalObject
	^Interval! !

!IntervalFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:52'!
protocol
	^#'Interval factory'! !


!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXclass
	" <Object>#class "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdefaultAction
	" <Error>#defaultAction "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdescription
	" <exceptionDescription>#description "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdoesNotUnderstandX
	" <Object>#doesNotUnderstand: "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXequalityOp
	" <Object>#= "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXerrorX
	" <Object>#error: "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXhash
	" <Object>#hash "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityHash
	" <Object>#identityHash "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityOp
	" <Object>#== "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisKindOfX
	" <Object>#isKindOf: "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisMemberOfX
	" <Object>#isMemberOf: "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisNested
	" <signaledException>#isNested "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisNil
	" <Object>#isNil "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisResumable
	" <MessageNotUnderstood>#isResumable "
	#'Exception'.
	self value: [	[ MessageNotUnderstood signal
				] on: MessageNotUnderstood do: [ :mnu |
					mnu return: mnu isResumable ] ]
		should: [:r | r]
		conformTo: #'MessageNotUnderstood' selector: #'isResumable'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXmessage
	" <MessageNotUnderstood>#message "
	#'Exception'.
	self value: [ [ 1 bob ] on: MessageNotUnderstood do: [ :mnu |
					mnu return: mnu message ] ]
		should: [:r | (r selector = #'bob') & (r arguments = Array new)]
		conformTo: #'MessageNotUnderstood' selector: #'message'.

	self value: [ [ 1 bob: 2 ] on: MessageNotUnderstood do: [ :mnu |
					mnu return: mnu message ] ]
		should: [:r | (r selector = #'bob:') & (r arguments = #( 2 ))]
		conformTo: #'MessageNotUnderstood' selector: #'message'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXmessageText
	" <exceptionDescription>#messageText "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXmessageTextX
	" <exceptionBuilder>#messageText: (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotEqualityOp
	" <Object>#~= "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotIdentityOp
	" <Object>#~~ "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotNil
	" <Object>#notNil "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXouter
	" <signaledException>#outer "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXpass
	" <signaledException>#pass "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformX
	" <Object>#perform: "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithArgumentsX
	" <Object>#perform:withArguments: "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithX
	" <Object>#perform:with: "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithX
	" <Object>#perform:with:with: "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithXwithX
	" <Object>#perform:with:with:with: "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintOnX
	" <Object>#printOn: "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintString
	" <Object>#printString "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXreceiver
	" <MessageNotUnderstood>#receiver "
	#'Exception'.
	self value: [ [ 1 bob ] on: MessageNotUnderstood do: [ :mnu |
					mnu return: mnu receiver ] ]
		should: [:r | r = 1]
		conformTo: #'MessageNotUnderstood' selector: #'receiver'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXresignalAsX
	" <signaledException>#resignalAs: "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXrespondsToX
	" <Object>#respondsTo: "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXresume
	" <signaledException>#resume "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXresumeX
	" <signaledException>#resume: "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXretry
	" <signaledException>#retry "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXretryUsingX
	" <signaledException>#retryUsing: "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXreturn
	" <signaledException>#return "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXreturnX
	" <signaledException>#return: "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsignal
	" <exceptionSignaler>#signal "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsignalX
	" <exceptionSignaler>#signal: "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXtag
	" <exceptionDescription>#tag "
	#'Exception'.
! !

!MessageNotUnderstoodANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXyourself
	" <Object>#yourself (Return Values: <RECEIVER>) "
	#'Exception'.
! !


!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXclass
	" <Object>#class "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXconcatenateOp
	" <exceptionSelector>#, "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdoesNotUnderstandX
	" <Object>#doesNotUnderstand: "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXequalityOp
	" <Object>#= "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXerrorX
	" <Object>#error: "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXhandlesX
	" <MessageNotUnderstoodSelector>#handles: "
	#'Exception'.
	self value: [	[ MessageNotUnderstood signal
				] on: MessageNotUnderstood do: [ :mnu |
					mnu return: (MessageNotUnderstood handles: mnu) ] ]
		should: [:r | r]
		conformTo: #'MessageNotUnderstoodSelector' selector: #'handles:'.

	self value: [	[ MessageNotUnderstood signal
				] on: MessageNotUnderstood do: [ :mnu |
					mnu return: (Error handles: mnu) ] ]
		should: [:r | r]
		conformTo: #'MessageNotUnderstoodSelector' selector: #'handles:'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXhash
	" <Object>#hash "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityHash
	" <Object>#identityHash "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityOp
	" <Object>#== "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisKindOfX
	" <Object>#isKindOf: "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisMemberOfX
	" <Object>#isMemberOf: "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisNil
	" <Object>#isNil "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotEqualityOp
	" <Object>#~= "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotIdentityOp
	" <Object>#~~ "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotNil
	" <Object>#notNil "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformX
	" <Object>#perform: "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithArgumentsX
	" <Object>#perform:withArguments: "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithX
	" <Object>#perform:with: "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithX
	" <Object>#perform:with:with: "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithXwithX
	" <Object>#perform:with:with:with: "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintOnX
	" <Object>#printOn: "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintString
	" <Object>#printString "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXrespondsToX
	" <Object>#respondsTo: "
	#'Exception'.
! !

!MessageNotUnderstoodSelectorANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXyourself
	" <Object>#yourself (Return Values: <RECEIVER>) "
	#'Exception'.
! !


!MonadicBlockANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 10:32'!
setUp
	super setUp.
	blk1args := [ :arg1 | Array with: arg1 ].
! !

!MonadicBlockANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXargumentCount
	" <monadicValuable>#argumentCount "
	#'Valuable'.
	self value: [blk1args argumentCount] should: [:r | r = 1]
		conformTo: #'monadicValuable' selector: #'argumentCount'.
! !

!MonadicBlockANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXvalueWithArgumentsX
	" <valuable>#valueWithArguments: "
	#'Valuable'.
	self value: [blk1args valueWithArguments: #(1)]
		should: [:r | r = #(1)]
		conformTo: #'valuable' selector: #'valueWithArguments:'.
! !

!MonadicBlockANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXvalueX
	" <monadicValuable>#value: "
	#'Valuable'.
	self value: [blk1args value: 1] should: [:r | r = #(1)]
		conformTo: #'monadicValuable' selector: #'value:'.
! !

!MonadicBlockANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:30'!
cannonicalObject
	^blk1args! !

!MonadicBlockANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:31'!
protocol
	^#'monadicBlock'! !


!NilANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 14:37'!
cannonicalObject
	^nil! !

!NilANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 14:36'!
protocol
	^#'nil'! !

!NilANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXprintString
	" <nil>#printString "
	#'Fundamental'.
	self value: [nil printString] should: [:r | r = 'nil']
		conformTo: #'nil' selector: #'printString'.
! !


!NiladicBlockANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 10:35'!
setUp
	super setUp.
	blk0args := [ Array new ].
	canonicalObject := [3+4]
! !

!NiladicBlockANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXargumentCount
	" <niladicValuable>#argumentCount "
	#'Valuable'.
	self value: [blk0args argumentCount] should: [:r | r = 0]
		conformTo: #'niladicValuable' selector: #'argumentCount'.
! !

!NiladicBlockANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXensureX
	" <niladicBlock>#ensure: "
	| flag tmp |
	#'Valuable'.
	flag := 0.
	self value: [	[#( 1 2 ) size] ensure: [flag := 1] ]
		should: [:r | r = 2 & flag = 1]
		conformTo: #'niladicBlock' selector: #'ensure:'.

#'todo'."I don't think this is a good test."
	flag := 0.
	[tmp := [#( 1 2 ) siz] ensure: [ flag := 1 ].
	] on: MessageNotUnderstood do: [ :mnu | mnu return ].
	self value: [tmp] should: [:r | flag = 1]
		conformTo: #'niladicBlock' selector: #'ensure:'.

	self value: [ [#( 1 2 ) siz] ensure: [ flag := 1 ] ]
		shouldRaise: MessageNotUnderstood.

#'todo'."or this ."
	flag := 0.

	[tmp := [Error signal] ensure: [ flag := 1 ].
	] on: Error do: [ :error | error return ].
	self value: [ tmp ] should: [:r | flag = 1]
		conformTo: #'niladicBlock' selector: #'ensure:'.
	self value: [ [Error signal] ensure: [ flag := 1 ] ]
		shouldRaise: Error.

#'testAnom'. "??? I think the ensure block should not be evaluated as per:
	Activation of an exception handler from within the receiver is not in and of itself an abnormal termination.  However, if the exception handler for an exception that is not resumable results in termination of the receiver or if its handler block contains a return statement that results in abnormal termination of the receiver, then terminationBlock will be evaluated after evaluation of the exception handler.
 
	flag := 0.
	[tmp := [Notification signal] ensure: [ flag := 1 ].
	] on: Notification do: [ :notification | notification resume ].
	self value: [ tmp ] should: [:r | flag = 0]
		conformTo: #'niladicBlock' selector: #'ensure:'.
???"
	self value: [ [Notification signal] ensure: [] ]
		shouldRaise: Notification.
! !

!NiladicBlockANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXifCurtailedX
	" <niladicBlock>#ifCurtailed: "
	| flag tmp |
	#'Valuable'.
	self value: [ [flag := 0] ifCurtailed: [flag := 1] ]
		should: [:r | r = 0 & flag = 0]
		conformTo: #'niladicBlock' selector: #'ifCurtailed:'.

#'testAnom'. "??? r = nil, but I think it should be -1.  Not sure?
	[tmp := [Error signal. 0] ifCurtailed: [flag := 1].
	] on: Error do: [ :error | error return: -1 ].
	self value: [ tmp ] should: [:r | r = -1 & flag = 1]
		conformTo: #'niladicBlock' selector: #'ifCurtailed:'.
???"

	[tmp := [Notification signal. 0] ifCurtailed: [flag := 1].
	] on: Notification do: [ :notification | notification resume ].
	self value: [ tmp ] should: [:r | r = 0 & flag = 0]
		conformTo: #'niladicBlock' selector: #'ifCurtailed:'.
! !

!NiladicBlockANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXonXdoX
	" <niladicBlock>#on:do: "
	#'Valuable'.
	self value: [ [#( 1 2 ) size] on: Error do: [ :error | error return: -1] ]
		should: [:r | r = 2]
		conformTo: #'niladicBlock' selector: #'on:do:'.

	self value: [[Error signal. 0] on: Error do: [:error | error return: -1]]
		should: [:r | r = -1]
		conformTo: #'niladicBlock' selector: #'on:do:'.
! !

!NiladicBlockANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXvalue
	" <niladicValuable>#value "
	#'Valuable'.
	self value: [blk0args value] should: [:r | r = #()]
		conformTo: #'niladicValuable' selector: #'value'.
! !

!NiladicBlockANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXvalueWithArgumentsX
	" <valuable>#valueWithArguments: "
	#'Valuable'.
	self value: [blk0args valueWithArguments: #()] should: [:r | r = #()]
		conformTo: #'valuable' selector: #'valueWithArguments:'.
! !

!NiladicBlockANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXwhileFalse
	" <niladicValuable>#whileFalse "
	| sum |
	#'Valuable'.
	sum := 0.
	self value: [ [(sum := sum + 1) >= 3] whileFalse]
		should: [:r | sum = 3]
		conformTo: #'niladicValuable' selector: #'whileFalse'.
! !

!NiladicBlockANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXwhileFalseX
	" <niladicValuable>#whileFalse: "
	| element aReadStream |
	#'Valuable'.
	aReadStream := ReadStream on: (Array with: 1 with: 2 with: 3).
	self value: [[aReadStream atEnd] whileFalse: [
					element := aReadStream next]]
		should: [:r | element = 3]
		conformTo: #'niladicValuable' selector: #'whileFalse:'.

	element := 0.
	self value: [ [element = 0] whileFalse: [element := 1] ]
		should: [:r | element =  0]
		conformTo: #'niladicValuable' selector: #'whileFalse:'.
! !

!NiladicBlockANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXwhileTrue
	" <niladicValuable>#whileTrue "
	| sum |
	#'Valuable'.
	sum := 0.
	self value: [ [(sum := sum + 1) < 4 ] whileTrue ]
		should: [:r | sum = 4]
		conformTo: #'niladicValuable' selector: #'whileTrue'.
! !

!NiladicBlockANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXwhileTrueX
	" <niladicValuable>#whileTrue: "
	| sum |
	#'Valuable'.
	sum := 0.
	self value: [ [sum < 4 ] whileTrue: [sum := sum + 1] ]
		should: [:r | sum = 4]
		conformTo: #'niladicValuable' selector: #'whileTrue:'.

	sum := 0.
	self value: [ [sum < 0 ] whileTrue: [sum := sum + 1] ]
		should: [:r | sum = 0]
		conformTo: #'niladicValuable' selector: #'whileTrue:'.
! !

!NiladicBlockANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:29'!
cannonicalObject
	^canonicalObject! !

!NiladicBlockANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:32'!
protocol
	^#'niladicBlock'! !


!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXclass
	" <Object>#class "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdefaultAction
	" <Notification>#defaultAction "
	#'Exception'.
	self value: [Notification signal] should: [:r | r = nil]
		conformTo: #'Notification' selector: #'defaultAction'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdescription
	" <exceptionDescription>#description "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdoesNotUnderstandX
	" <Object>#doesNotUnderstand: "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXequalityOp
	" <Object>#= "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXerrorX
	" <Object>#error: "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXhash
	" <Object>#hash "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityHash
	" <Object>#identityHash "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityOp
	" <Object>#== "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisKindOfX
	" <Object>#isKindOf: "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisMemberOfX
	" <Object>#isMemberOf: "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisNested
	" <signaledException>#isNested "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisNil
	" <Object>#isNil "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisResumable
	" <Notification>#isResumable "
	#'Exception'.
	self value: [ [ Notification signal ] on: Notification do: [ :aNotification |
					aNotification return: aNotification isResumable ] ]
		should: [:r | r]
		conformTo: #'Notification' selector: #'isResumable'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXmessageText
	" <exceptionDescription>#messageText "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXmessageTextX
	" <exceptionBuilder>#messageText: (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotEqualityOp
	" <Object>#~= "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotIdentityOp
	" <Object>#~~ "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotNil
	" <Object>#notNil "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXouter
	" <signaledException>#outer "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXpass
	" <signaledException>#pass "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformX
	" <Object>#perform: "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithArgumentsX
	" <Object>#perform:withArguments: "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithX
	" <Object>#perform:with: "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithX
	" <Object>#perform:with:with: "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithXwithX
	" <Object>#perform:with:with:with: "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintOnX
	" <Object>#printOn: "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintString
	" <Object>#printString "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXresignalAsX
	" <signaledException>#resignalAs: "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXrespondsToX
	" <Object>#respondsTo: "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXresume
	" <signaledException>#resume "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXresumeX
	" <signaledException>#resume: "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXretry
	" <signaledException>#retry "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXretryUsingX
	" <signaledException>#retryUsing: "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXreturn
	" <signaledException>#return "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXreturnX
	" <signaledException>#return: "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsignal
	" <exceptionSignaler>#signal "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsignalX
	" <exceptionSignaler>#signal: "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXtag
	" <exceptionDescription>#tag "
	#'Exception'.
! !

!NotificationANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXyourself
	" <Object>#yourself (Return Values: <RECEIVER>) "
	#'Exception'.
! !


!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXallSubclasses
	" <classDescription>#allSubclasses "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXallSuperclasses
	" <classDescription>#allSuperclasses "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXclass
	" <Object>#class "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXconcatenateOp
	" <exceptionSelector>#, "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdoesNotUnderstandX
	" <Object>#doesNotUnderstand: "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXequalityOp
	" <Object>#= "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXerrorX
	" <Object>#error: "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXhandlesX
	" <Exception class>#handles: "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXhash
	" <Object>#hash "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityHash
	" <Object>#identityHash "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityOp
	" <Object>#== "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisKindOfX
	" <Object>#isKindOf: "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisMemberOfX
	" <Object>#isMemberOf: "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisNil
	" <Object>#isNil "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXname
	" <classDescription>#name "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnew
	" <Notification class>#new "
	#'Exception'.
	self value: [Notification new]
		should: [:r | true "??? r = Notification signal ???"]
		conformTo: #'Notification class' selector: #'new'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotEqualityOp
	" <Object>#~= "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotIdentityOp
	" <Object>#~~ "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotNil
	" <Object>#notNil "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformX
	" <Object>#perform: "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithArgumentsX
	" <Object>#perform:withArguments: "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithX
	" <Object>#perform:with: "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithX
	" <Object>#perform:with:with: "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithXwithX
	" <Object>#perform:with:with:with: "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintOnX
	" <Object>#printOn: "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintString
	" <Object>#printString "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXrespondsToX
	" <Object>#respondsTo: "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsignal
	" <Exception class>#signal "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsignalX
	" <exceptionSignaler>#signal: "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsubclasses
	" <classDescription>#subclasses "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsuperclass
	" <classDescription>#superclass "
	#'Exception'.
! !

!NotificationClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXyourself
	" <Object>#yourself (Return Values: <RECEIVER>) "
	#'Exception'.
! !


!ObjectANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 13:47'!
cannonicalObject
	^object! !

!ObjectANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 13:47'!
protocol
	^#Object! !

!ObjectANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 10:28'!
setUp
	super setUp.
	object := Object new. 
! !


!ObjectClassANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXallSubclasses
	" <classDescription>#allSubclasses "
	#'Fundamental'.
"	Each element of the result collection supports the protocol <classDescription>."
#todo. "can't tell of a class that must be present in ANSI ???"
	self value: [Number allSubclasses]
		should: [:r |
			 (r allSatisfy: [ :element |
				element class conformsToProtocolNamed: #'classDescription'
			]) & (r isEmpty not)
		]
		conformTo: #'classDescription' selector: #'allSubclasses'.
	self value: [Symbol allSubclasses]
		should: [:r |
			 r allSatisfy: [ :element |
				element class conformsToProtocolNamed: #'classDescription'
		]	]
		conformTo: #'classDescription' selector: #'allSubclasses'.
! !

!ObjectClassANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXallSuperclasses
	" <classDescription>#allSuperclasses "
	#'Fundamental'.
"	Each element of the result collection supports the protocol <classDescription>."
#todo. "can't tell of a class that must be present in ANSI ???"
	self value: [Fraction allSuperclasses]
		should: [:r |
			 (r allSatisfy: [ :element |
				element class conformsToProtocolNamed: #'classDescription'
			]) & (r isEmpty not)
		]
		conformTo: #'classDescription' selector: #'allSuperclasses'.

	self value: [Object allSuperclasses]
		should: [:r |
			 r allSatisfy: [ :element |
				element class conformsToProtocolNamed: #'classDescription'
		]	]
		conformTo: #'classDescription' selector: #'allSuperclasses'.
! !

!ObjectClassANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXname
	" <classDescription>#name "
	#'Fundamental'.
	self value: [Object name] should: [:r | r asString = 'Object']
		conformTo: #'classDescription' selector: #'name'.
! !

!ObjectClassANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXnew
	" <Object class>#new "
	#'Fundamental'.
	self value: [Object new] should: [:r | r class = Object]
		conformTo: #'Object class' selector: #'new'.
! !

!ObjectClassANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXsubclasses
	" <classDescription>#subclasses "
	#'Fundamental'.
	self value: [Number subclasses]
		should: [:r |
			 (r allSatisfy: [ :element |
				element class conformsToProtocolNamed: #'classDescription'
			]) & (r isEmpty not)
		]
		conformTo: #'classDescription' selector: #'subclasses'.
	self value: [Symbol subclasses]
		should: [:r |
			 r allSatisfy: [ :element |
				element conformsToProtocolNamed: #'classDescription'
		]	]
		conformTo: #'classDescription' selector: #'subclasses'.
! !

!ObjectClassANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 16:59'!
testXsuperclass
	" <classDescription>#superclass "
	#'Fundamental'.
"	If the receiver is a class object, return the class objects defined by the class definitions from which the class definition of the receiver directly inherits.  If the class definition of the receiver has no superclasses, return nil."
	#'Fundamental'.
	self value: [Fraction superclass]
		should: [:r | 
			r isNil ifTrue: [
				r conformsToProtocolNamed: #'classDescription'
			] ifFalse: [
				r class conformsToProtocolNamed: #'classDescription'
		]	]
		conformTo: #'classDescription' selector: #'superclass'.

	self value: [Object superclass]
		should: [:r | 
			r isNil ifTrue: [
				r class class conformsToProtocolNamed: #'classDescription'
			] ifFalse: [
				r class conformsToProtocolNamed: #'classDescription'
		]	]
		conformTo: #'classDescription' selector: #'superclass'.
! !

!ObjectClassANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 15:17'!
cannonicalObject
	^Object! !

!ObjectClassANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 15:16'!
protocol
	^#'Object class'! !


!ObjectHelper methodsFor: 'initializing' stamp: 'djm 3/17/2000 19:34'!
object: anObject
	object := anObject! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/17/2000 19:33'!
cannonicalObject
	^object! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/18/2000 09:21'!
protocol
	^testCase protocol! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/17/2000 19:32'!
testXclass
	" <Object>#class "
	#'Fundamental'.
	self value: [self cannonicalObject class]
		should: [:r | true]
		conformTo: self protocol selector: #'class'.

	self value: [self cannonicalObject class class]
		should: [:r | true "unspecified"]
		conformTo: self protocol selector: #'class'.
! !

!ObjectHelper methodsFor: 'testing'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Fundamental'.
	self assertSend: #copy  
! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/17/2000 18:25'!
testXdoesNotUnderstandX
	" <Object>#doesNotUnderstand: "
	#'Fundamental'.

	self value: [self cannonicalObject fooXzzYZ] shouldRaise: MessageNotUnderstood.
! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/16/2000 14:42'!
testXequalityOp
	" <Object>#= "
	| newObject object1 |
	#'Fundamental'.
"	The value of receiver = comparand is true if and only if the value of comparand = receiver would also be true. If the value of receiver = comparand is true then the receiver and comparand must have equivalent hash values.  Or more formally:

	receiver = comparand	=>
	receiver hash = comparand hash
"	
	object1 := self cannonicalObject.
	self value: [object1 = object1]
		should: [:r | r and: [object1 hash = object1 hash] ]
		conformTo: #'Object' selector: #'='.

	newObject := Object new.
	self should: [(object1 ~= newObject) and: [object1 hash ~= newObject hash] ].
! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/18/2000 13:47'!
testXerrorX
	" <Object>#error: "
	#'Fundamental'.
	self value: [	[self cannonicalObject error: 'dummy'
				]	on: Error
					do: [ :error |  error return: true ].
				]
		should: [:r | r]
		conformTo: self protocol selector: #'error:'.

	self value: [self cannonicalObject error: 'dummy'] shouldRaise: Error.
! !

!ObjectHelper methodsFor: 'testing'!
testXhash
	" <Object>#hash "
	| |
	#'Fundamental'.
"	Any two objects that are considered equivalent using the #= message must have the same hash value.  More formally:

	receiver = comparand	=>
	receiver hash = comparand hash
"

	self assertSend: #hash  
! !

!ObjectHelper methodsFor: 'testing'!
testXidentityHash
	" <Object>#identityHash "
	#'Fundamental'.
	self assertSend: #identityHash  
! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/16/2000 14:48'!
testXidentityOp
	" <Object>#== "
	| newObject object1 |
	#'Fundamental'.
"	The value of receiver == comparand is true if and only if the value of comparand == receiver would also be true. If the value of receiver == comparand is true then the receiver and comparand must have equivalent identity hash values.  Or more formally:

	receiver == comparand =>
	receiver identityHash = comparand identityHash
"
	object1 := self cannonicalObject.
	self value: [object1 == object1]
		should: [:r | r and: [object1 identityHash = object1 identityHash] ]
		conformTo: #'Object' selector: #'=='.

	newObject := Object new.
	self should: [(object1 ~~ newObject) and: [object1 identityHash ~~ newObject identityHash] ].

! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/17/2000 11:12'!
testXisKindOfX
	" <Object>#isKindOf:"
	#Fundamental.
	"	The return value is unspecified if the receiver is a class object or 
	candidateClass is not a class object.
	"
	#todo.
	"Fix find a test for unspecified rule above ???"
	self
		value: [self cannonicalObject isKindOf: Object]
		should: [:r | r]
		conformTo: self protocol
		selector: #isKindOf:.
	"Metaclass tests:"
	self
		value: [self cannonicalObject class isKindOf: Object class]
		should: [:r | "unspecified"
			true]
		conformTo: self protocol
		selector: #isKindOf:.
	self
		shouldnt: [self cannonicalObject == nil
				ifTrue: [false]
				ifFalse: [self cannonicalObject isKindOf: UndefinedObject]]! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/17/2000 11:23'!
testXisMemberOfX
	" <Object>#isMemberOf: "
	#'Fundamental'.
"	The return value is unspecified if the receiver is a class object or candidateClass is not a class object.
"
#todo. "Fix find a test for unspecified rule above ???"
	self value: [self cannonicalObject isMemberOf: self cannonicalObject class]
		should: [:r | r] conformTo: self protocol selector: #'isMemberOf:'.
	self shouldnt: [#'aSymbol' isMemberOf: Object].
! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/17/2000 10:54'!
testXisNil
	" <Object>#isNil"
	#Fundamental.
	"	The messages #isNil and #notNil must be implemented to produce 
	consistent results.  For a given receiver if the result of #isNil is true 
	then the result of #notNil must be false.
	"
	self
		value: [self cannonicalObject isNil = (self cannonicalObject == nil)]
		should: [:r | r]
		conformTo: #Object
		selector: #isNil! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/16/2000 14:52'!
testXnotEqualityOp
	" <Object>#~= "
	| newObject |
	#'Fundamental'.
"	The value of receiver ~= comparand is true if and only if the value of comparand ~= receiver would also be true.
"
	newObject := Object new.
	self value: [self cannonicalObject ~= newObject]
		should: [:r | r & (newObject ~= self cannonicalObject)]
		conformTo: self protocol selector: #'~='.

	self value: [self cannonicalObject ~= self cannonicalObject] shouldnt: [:r | r]
		conformTo: self protocol selector: #'~='.
! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/17/2000 15:53'!
testXnotIdentityOp
	" <Object>#== "
	| object1 |
	#'Fundamental'.
"	The value of receiver == comparand is true if and only if the value of comparand == receiver would also be true. If the value of receiver == comparand is true then the receiver and comparand must have equivalent identity hash values.  Or more formally:

	receiver == comparand =>
	receiver identityHash = comparand identityHash
"
	object1 := self cannonicalObject.
	self value: [object1 ~~ Object new]
		should: [:r | r ]
		conformTo: self protocol selector: #'~~'.

! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/17/2000 10:54'!
testXnotNil
	" <Object>#isNil"
	#Fundamental.
	"	The messages #isNil and #notNil must be implemented to produce 
	consistent results.  For a given receiver if the result of #isNil is true 
	then the result of #notNil must be false.
	"
	self
		value: [self cannonicalObject notNil = (self cannonicalObject ~~ nil)]
		should: [:r | r]
		conformTo: #Object
		selector: #notNil! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/17/2000 18:38'!
testXperformX
	" <Object>#perform: "
	#'Fundamental'.
"	If the receiver does not have a method for selector normal message-not-understood processing is performed as if the computed message hand been sent using a message send expression.
	The perform messages and #respondsTo: must be implemented to produce consistent results.  A message to perform a selector, selector, for a given receiver will result in a message-not-understood condition if and only if the value of receiver respondsTo: selector is false.
	Behavior is undefined if the number of arguments does not match that implicitly required by  the syntactic form of the selector.
"
	self value: [self cannonicalObject perform: #'yourself']
		should: [:r | r == r ]
		conformTo: self protocol selector: #'perform:'.

	self value: [self cannonicalObject perform: #'3+4']
		shouldRaise: MessageNotUnderstood.

! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/18/2000 14:37'!
testXperformXwithArgumentsX
	" <Object>#perform:withArguments: "
	#'Fundamental'.
"	If the receiver does not have a method for the selector normal message-not-understood processing is performed as if the computed message hand been sent using a message send expression.  If this occurs, selector and arguments could be captured.
	The perform messages and #respondsTo: must be implemented to produce consistent results. A message to perform a selector, selector, for a given receiver will result in a message-not-understood condition if and only if the value of receiver respondsTo: selector is false.
	Behavior is undefined if the number of elements in arguments does not match that implicitly required by  the syntactic form of the selector.
"
	self value: [self cannonicalObject perform: #'3+4' withArguments: #()]
		shouldRaise: MessageNotUnderstood.
	self value: [self cannonicalObject perform: #'notNil' withArguments: #( 1 )]
		shouldRaise: Error.

	self value: [self cannonicalObject perform: #'yourself' withArguments: #()]
		should: [:r | (self cannonicalObject respondsTo: #'yourself')]
		conformTo: self protocol selector: #'perform:withArguments:'.
! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/18/2000 13:57'!
testXperformXwithX
	" <Object>#perform:with: "
	#'Fundamental'.
"	If the receiver does not have a method for selector normal message-not-understood processing is performed as if the computed message hand been sent using a message send expression.
	The perform messages and #respondsTo: must be implemented to produce consistent results.  A message to perform a selector, selector, for a given receiver will result in a message-not-understood condition if and only if the value of receiver respondsTo: selector is false.
	Behavior is undefined if the number of arguments does not match that implicitly required by  the syntactic form of the selector.
"
	self value: [self cannonicalObject perform: #'selector' with: #()]
		shouldRaise: MessageNotUnderstood.
	self value: [self cannonicalObject perform: #'isNil' with: 1]
		shouldRaise: Error.

	self value: [self cannonicalObject perform: #'~~' with: 1]
		should: [:r | r & (self cannonicalObject respondsTo: #'~~')]
		conformTo: self protocol selector: #'perform:with:'.
! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/18/2000 14:18'!
testXperformXwithXwithX
	" <Object>#perform:with:with: "
	#'Fundamental'.
"	If the receiver does not have a method for selector normal message-not-understood processing is performed as if the computed message hand been sent using a message send expression.
	The perform messages and #respondsTo: must be implemented to produce consistent results.  A message to perform a selector, selector, for a given receiver will result in a message-not-understood condition if and only if the value of receiver respondsTo: selector is false.
	Behavior is undefined if the number of arguments does not match that implicitly required by  the syntactic form of the selector.
"
	self value: [self cannonicalObject perform: #'selector' with: #() with: #()]
		shouldRaise: MessageNotUnderstood.
	self value: [self cannonicalObject perform: #'isNil' with: 1 with: 1]
		shouldRaise: Error.

	self value: [self cannonicalObject perform: #perform:with: with: #'~~' with: 1]
		should: [:r | r & (self cannonicalObject respondsTo: #perform:with:)]
		conformTo: self protocol selector: #'perform:with:'.
! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/18/2000 14:28'!
testXperformXwithXwithXwithX
	" <Object>#perform:with:with:with: "
	#'Fundamental'.

	self notDone! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/17/2000 10:58'!
testXprintOnX
	" <Object>#printOn: "
	| resultStream |
	#'Fundamental'.
"	The string of characters that would be the result of sending the message #printString to the receiver is written to target.
"
	self value: [resultStream := WriteStream on: (String new: 10).
			self cannonicalObject printOn: resultStream]
		should: [:r | (resultStream contents) = self cannonicalObject printString]
		conformTo: self protocol selector: #'printOn:'.
! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/17/2000 10:56'!
testXprintString
	" <Object>#printString "
	#'Fundamental'.
	self value: [self cannonicalObject printString]
		should: [:r | true]
		conformTo: self protocol selector: #'printString'.
! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/18/2000 13:32'!
testXrespondsToX
	" <Object>#respondsTo: "
	#'Fundamental'.
	self value: [self cannonicalObject respondsTo: #'isNil'] should: [:r | r]
		conformTo: self protocol selector: #'respondsTo:'.

	self value: [self cannonicalObject respondsTo: #'selector'] shouldnt: [:r | r]
		conformTo: self protocol selector: #'respondsTo:'.
! !

!ObjectHelper methodsFor: 'testing' stamp: 'djm 3/17/2000 18:29'!
testXyourself
	| anObject |
	" <Object>#yourself (Return Values: <RECEIVER>) "
	#'Fundamental'.
	anObject := self cannonicalObject.
	self value: [anObject yourself] should: [:r | r == anObject]
		conformTo: self protocol selector: #'yourself'! !


!ObjectHelper class methodsFor: 'initialize-release' stamp: 'rej 5/24/2000 12:21'!
initialize
	super initialize! !


!OrderedCollectionANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:53'!
cannonicalObject
	^OrderedCollection with: 1 with: 2 with: 3 with: 4! !

!OrderedCollectionANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:54'!
protocol
	^#OrderedCollection! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXaddAllFirstX
	" <OrderedCollection>#addAllFirst: "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXaddAllLastX
	" <OrderedCollection>#addAllLast: "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXaddAllX
	" <extensibleCollection>#addAll: "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXaddAllXafterIndexX
	" <OrderedCollection>#addAll:afterIndex: "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXaddAllXafterX
	" <OrderedCollection>#addAll:after: "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:15'!
testXaddAllXbeforeIndexX
	" <OrderedCollection>#addAll:beforeIndex: "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXaddAllXbeforeX
	" <OrderedCollection>#addAll:before: "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXaddFirstX
	" <OrderedCollection>#addFirst: "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXaddLastX
	" <OrderedCollection>#addLast: "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXaddX
	" <OrderedCollection>#add: "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXaddXafterIndexX
	" <OrderedCollection>#add:afterIndex: "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXaddXafterX
	" <OrderedCollection>#add:after: "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXaddXbeforeIndexX
	" <OrderedCollection>#add:beforeIndex: "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXaddXbeforeX
	" <OrderedCollection>#add:before: "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXremoveAllX
	" <extensibleCollection>#removeAll: "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXremoveAtIndexX
	" <sequencedContractibleCollection>#removeAtIndex: "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXremoveFirst
	" <sequencedContractibleCollection>#removeFirst "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXremoveLast
	" <sequencedContractibleCollection>#removeLast "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXremoveX
	" <extensibleCollection>#remove: "
	#'Collection'.
! !

!OrderedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXremoveXifAbsentX
	" <extensibleCollection>#remove:ifAbsent: "
	#'Collection'.
! !


!OrderedCollectionANSITest class methodsFor: 'instance creation' stamp: 'rej 5/27/2000 16:16'!
helperClassesDo: aBlock
	super helperClassesDo: aBlock.
	aBlock value: SequencedCollectionHelper.
	aBlock value: SequencedReadableCollectionHelper
! !


!OrderedCollectionFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXnew
	" <OrderedCollection factory>#new "
	#'Collection'.
! !

!OrderedCollectionFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXnewX
	" <OrderedCollection factory>#new: "
	#'Collection'.
! !

!OrderedCollectionFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXwithAllX
	" <OrderedCollection factory>#withAll: "
	#'Collection'.
! !

!OrderedCollectionFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXwithX

	" <OrderedCollection factory>#with: "
	#'Collection'.
! !

!OrderedCollectionFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXwithXwithX
	" <OrderedCollection factory>#with:with: "
	#'Collection'.
! !

!OrderedCollectionFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXwithXwithXwithX
	" <OrderedCollection factory>#with:with:with: "
	#'Collection'.
! !

!OrderedCollectionFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXwithXwithXwithXwithX
	" <OrderedCollection factory>#with:with:with:with: "
	#'Collection'.
! !

!OrderedCollectionFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:54'!
cannonicalObject
	^OrderedCollection! !

!OrderedCollectionFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:55'!
protocol
	^#'OrderedCollection factory'! !


!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 10:46'!
setUp
	super setUp.
	" Requires that a file named 'ansiTestFile.junk' exists in the current directory. "

"	| aPossiblyNewFile |
	aPossiblyNewFile := FileStream write: 'ansiTestFile.junk'.
	aPossiblyNewFile close.
"
"	readFileStream := FileStream read: 'ansiTestFile.junk' "! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/16/2000 18:23'!
tearDown
	"readFileStream close."! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXatEnd
	" <gettableStream>#atEnd "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXclose
	" <sequencedStream>#close "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXcontents
	" <FileStream>#contents "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXdoX
	" <gettableStream>#do: "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXexternalType
	" <FileStream>#externalType "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXisBinary
	" <FileStream>#isBinary "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXisEmpty
	" <sequencedStream>#isEmpty "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXisText
	" <FileStream>#isText "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnext
	" <gettableStream>#next "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnextLine
	" <gettableStream>#nextLine "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnextMatchForX
	" <gettableStream>#nextMatchFor: "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnextX
	" <readFileStream>#next: "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXpeek
	" <gettableStream>#peek "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXpeekForX
	" <gettableStream>#peekFor: "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXposition
	" <sequencedStream>#position "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXpositionX
	" <sequencedStream>#position: "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXreset
	" <sequencedStream>#reset "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXsetToEnd
	" <sequencedStream>#setToEnd "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXskipToX
	" <gettableStream>#skipTo: "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXskipX
	" <gettableStream>#skip: "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXupToX
	" <readFileStream>#upTo: "
	#'File Stream'.
! !

!ReadFileStreamANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 18:12'!
cannonicalObject
	^readFileStream! !

!ReadFileStreamANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:54'!
protocol
	^#'readFileStream'! !


!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 10:42'!
setUp
	super setUp.
	readStream := ReadStream on: 'this is a string'! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXatEnd
	" <gettableStream>#atEnd "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXclose
	" <sequencedStream>#close "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXcontents
	" <collectionStream>#contents "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXdoX
	" <gettableStream>#do: "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXisEmpty
	" <sequencedStream>#isEmpty "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnext
	" <gettableStream>#next "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnextLine
	" <gettableStream>#nextLine "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnextMatchForX
	" <gettableStream>#nextMatchFor: "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnextX
	" <ReadStream>#next: "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXpeek
	" <gettableStream>#peek "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXpeekForX
	" <gettableStream>#peekFor: "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXposition
	" <sequencedStream>#position "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXpositionX
	" <sequencedStream>#position: "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXreset
	" <sequencedStream>#reset "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXsetToEnd
	" <sequencedStream>#setToEnd "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXskipToX
	" <gettableStream>#skipTo: "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXskipX
	" <gettableStream>#skip: "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXupToX
	" <ReadStream>#upTo: "
	#'Stream'.
! !

!ReadStreamANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:37'!
cannonicalObject
	^readStream! !

!ReadStreamANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:09'!
protocol
	^#'ReadStream'! !


!ReadStreamFactoryANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:30'!
cannonicalObject
	^ReadStream! !

!ReadStreamFactoryANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:30'!
protocol
	^#'ReadStream factory'! !

!ReadStreamFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXonX
	" <ReadStream factory>#on: "
	#'Stream'.
! !


!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 10:43'!
setUp
	super setUp.
	readWriteStream := ReadWriteStream on: 'some string'! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXatEnd
	" <gettableStream>#atEnd "
	#'Stream'.
! !


!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXclose
	" <sequencedStream>#close "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXcontents
	" <collectionStream>#contents "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXcr
	" <puttableStream>#cr "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXdoX
	" <gettableStream>#do: "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXflush
	" <puttableStream>#flush "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXisEmpty
	" <sequencedStream>#isEmpty "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnext
	" <gettableStream>#next "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnextLine
	" <gettableStream>#nextLine "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnextMatchForX
	" <gettableStream>#nextMatchFor: "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnextPutAllX
	" <puttableStream>#nextPutAll: "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnextPutX
	" <puttableStream>#nextPut: "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnextX
	" <ReadStream>#next: "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXpeek
	" <gettableStream>#peek "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXpeekForX
	" <gettableStream>#peekFor: "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXposition
	" <sequencedStream>#position "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXpositionX
	" <sequencedStream>#position: "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXreset
	" <sequencedStream>#reset "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXsetToEnd
	" <sequencedStream>#setToEnd "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXskipToX
	" <gettableStream>#skipTo: "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXskipX
	" <gettableStream>#skip: "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXspace
	" <puttableStream>#space "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXtab
	" <puttableStream>#tab "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXupToX
	" <ReadStream>#upTo: "
	#'Stream'.
! !

!ReadWriteStreamANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:39'!
cannonicalObject
	^readWriteStream! !

!ReadWriteStreamANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:38'!
protocol
	^#'ReadWriteStream'! !


!ReadWriteStreamFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXwithX
	" <ReadWriteStream factory>#with: "
	#'Stream'.
! !

!ReadWriteStreamFactoryANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:42'!
cannonicalObject
	^ReadWriteStream! !

!ReadWriteStreamFactoryANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:41'!
protocol
	^#'ReadWriteStream factory'! !


!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 15:04'!
setUp
	super setUp.
	smallInt2 := 2.
	largeNegInt2000000000 := -2000000000.
	largePosInt2000000000 := 2000000000.
	float2 := 2.0.
	fractionHalf := 1/2.
	sclDec2s3 := 2.0s3.
	numList := Array new: 6.
	numList at: 1 put: smallInt2.
	numList at: 2 put: largeNegInt2000000000.
	numList at: 3 put: largePosInt2000000000.
	numList at: 4 put: float2.
	numList at: 5 put: fractionHalf.
	numList at: 6 put: sclDec2s3.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testLiterals
	#'Numeric'.
	self should: [123s = 123s0].
	self should: [123s = 123s0].
	self should: [123s0 = 123s0].

	self should: [123.0s = 123.0s1].
	self should: [123s1 = 123.0s1].
	self should: [123.0s1 = 123.0s1].

	self should: [123.000s = 123.000s3].
	self should: [123s3 = 123.000s3].
	self should: [123.0s3 = 123.000s3].
	self should: [123.00s3 = 123.000s3].
	self should: [123.000s3 = 123.000s3].
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXabs
	" <number>#abs (Return Values: <RECEIVER>) "
	| rcvr |
	#'Numeric'.
	rcvr := 2.0s3.
	self value: [rcvr abs] should: [:r | r = 2.0s3]
		conformTo: #'number' selector: #'abs' opRECEIVER: rcvr.
	rcvr := 2.0s3.
	self value: [rcvr abs] should: [:r | r = 2.0s3]
		conformTo: #'number' selector: #'abs' opRECEIVER: rcvr.
	rcvr := 0.0s3.
	self value: [rcvr abs] should: [:r | r = 0s3]
		conformTo: #'number' selector: #'abs' opRECEIVER: rcvr.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXaddOp
	" <number>#+ (returnRule - :receiver :operand) "
	| retVals tmpRec tmpResult |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(4.0s3 -1999999998.0s3 2000000002.0s3 4.0 0 4.0s3) copy.
	retVals at: 5 put: (5/2).
	1 to: numList size do: [ :ndx |
		self value: [sclDec2s3 + (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'+'
			ruleReceiver: sclDec2s3 operand: (numList at: ndx)
	].

	"If the return value conforms to <scaledDecimal> then the scale of the result is at least the scale of the receiver after conversion if necessary."
	tmpRec := 26.5s2.
	tmpResult := tmpRec + 5.0s1.
	self should: [tmpResult = 31.50s2 & (tmpResult scale >= tmpRec scale)].

	tmpRec := 26.5s2.
	tmpResult := tmpRec + 5.0s4.
	self should: [tmpResult = 31.5000s4 & (tmpResult scale >= tmpRec scale)].

	tmpRec := -26.5s2.
	tmpResult := tmpRec + 5.0s4.
	self should: [tmpResult = -21.5000s4 & (tmpResult scale >= tmpRec scale)].
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasFloat
	" <number>#asFloat "
	#'Numeric'.
	self value: [2.0s3 asFloat] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'asFloat'.
	self value: [-2.0s3 asFloat] should: [:r | r = -2.0]
		conformTo: #'number' selector: #'asFloat'.
	self value: [0.0s3 asFloat] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'asFloat'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasFloatD
	" <number>#asFloatD "
	#'Numeric'.
	self value: [2.0s3 asFloatD] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'asFloatD'.
	self value: [-2.0s3 asFloatD] should: [:r | r = -2.0]
		conformTo: #'number' selector: #'asFloatD'.
	self value: [0.0s3 asFloatD] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'asFloatD'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasFloatE
	" <number>#asFloatE "
	#'Numeric'.
	self value: [2.0s3 asFloatE] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'asFloatE'.
	self value: [-2.0s3 asFloatE] should: [:r | r = -2.0]
		conformTo: #'number' selector: #'asFloatE'.
	self value: [0.0s3 asFloatE] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'asFloatE'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasFloatQ
	" <number>#asFloatQ "
	#'Numeric'.
	self value: [2.0s3 asFloatQ] should: [:r | r = 2.0]
		conformTo: #'number' selector: #'asFloatQ'.
	self value: [-2.0s3 asFloatQ] should: [:r | r = -2.0]
		conformTo: #'number' selector: #'asFloatQ'.
	self value: [0.0s3 asFloatQ] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'asFloatQ'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasFraction
	" <number>#asFraction "
	#'Numeric'.

	self value: [2.0s3 asFraction] should: [:r | r = 2]
		conformTo: #'number' selector: #'asFraction'.
	self value: [-2.5s3 asFraction] should: [:r | r = (-5/2)]
		conformTo: #'number' selector: #'asFraction'.
	self value: [0.0s3 asFraction] should: [:r | r = 0]
		conformTo: #'number' selector: #'asFraction'.

	"Scale less than required to represent value:"
	self value: [0.25s1 asFraction] should: [:r | r = (1/4)]
		conformTo: #'number' selector: #'asFraction'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasInteger
	" <number>#asInteger "
	#'Numeric'.
	self value: [2.0s3 asInteger] should: [:r | r = 2]
		conformTo: #'number' selector: #'asInteger'.
	self value: [2.1s3 asInteger] should: [:r | r = 2]
		conformTo: #'number' selector: #'asInteger'.
	self value: [2.5s3 asInteger] should: [:r | r = 3]
		conformTo: #'number' selector: #'asInteger'.
	self value: [-2.0s3 asInteger] should: [:r | r = -2]
		conformTo: #'number' selector: #'asInteger'.
	self value: [-2.1s3 asInteger] should: [:r | r = -2]
		conformTo: #'number' selector: #'asInteger'.
	self value: [-2.5s3 asInteger] should: [:r | r = -3]
		conformTo: #'number' selector: #'asInteger'.
	self value: [0.0s3 asInteger] should: [:r | r = 0]
		conformTo: #'number' selector: #'asInteger'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXasScaledDecimalX
	" <number>#asScaledDecimal: "
	#'Numeric'.
	self value: [2.0s3 asScaledDecimal: 3]
		should: [:r | r = 2.0s3 & (r scale = 3)]
		conformTo: #'number' selector: #'asScaledDecimal:'.
	self value: [-2.0s3 asScaledDecimal: 2]
		should: [:r | r = -2.0s2 & (r scale = 2)]
		conformTo: #'number' selector: #'asScaledDecimal:'.
	self value: [0.0s3 asScaledDecimal: 0]
		should: [:r | r = 0.0s0 & (r scale = 0)]
		conformTo: #'number' selector: #'asScaledDecimal:'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXbetweenXandX
	" <magnitude>#between:and: "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
#'todo'."It is erroneous if the receiver  and min or max are not comparable"

	self value: [2.0s3 between: 1 and: 3]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [-2000000002.0s3 between: -2000000003 and: -2000000001]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2000000002.0s3 between: 2000000001 and: 2000000003]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2.0s3 between: 1.0 and: 3.0]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2.0s3 between: (3/2) and: (5/2)]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2.0s3 between: 1.0s3 and: 3.0s3]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.

	self value: [2.0s3 between: (3/2) and: 2000000003]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2.0s3 between: -2000000001 and: 3.0]
		should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.

	"Num between: Num and: Num -> true"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx)
					between: (numList at: ndx)
					and: (numList at: ndx)]
			should: [:r | r] conformTo: #'magnitude' selector: #'between:and:'
	].

	self value: [2.0s3 between: 3 and: 4]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [-2000000000.0s3 between: -2000000003 and: -2000000005]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2000000000.0s3 between: 2000000003 and: 2000000005]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2.0s3 between: 3.0 and: 5.0]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2.0s3 between: (5/2) and: (7/2)]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
	self value: [2.0s3 between: 3.0s3 and: 5.0s3]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.

	"??? min not min but max and vice versa -> false ???"
	self value: [2.0s3 between: 3 and: 1]
		shouldnt: [:r | r] conformTo: #'magnitude' selector: #'between:and:'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXceiling
	" <number>#ceiling "
	#'Numeric'.
	self value: [2.0s3 ceiling] should: [:r | r = 2]
		conformTo: #'number' selector: #'ceiling'.
	self value: [2.1s3 ceiling] should: [:r | r = 3]
		conformTo: #'number' selector: #'ceiling'.
	self value: [2.5s3 ceiling] should: [:r | r = 3]
		conformTo: #'number' selector: #'ceiling'.
	self value: [-2.0s3 ceiling] should: [:r | r = -2]
		conformTo: #'number' selector: #'ceiling'.
	self value: [-2.1s3 ceiling] should: [:r | r = -2]
		conformTo: #'number' selector: #'ceiling'.
	self value: [-2.5s3 ceiling] should: [:r | r = -2]
		conformTo: #'number' selector: #'ceiling'.
	self value: [0.0s3 ceiling] should: [:r | r = 0]
		conformTo: #'number' selector: #'ceiling'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Numeric'.
"	Return a new object that must be as similar as possible to the receiver in its initial state and behavior.  Any operation that changes the state of the new object should not as a side-effect change the state or behavior of the receiver.  Similarly, any change to the receiver should not as a side-effect change the new object.
	If the receiver is an identity object, return the receiver.
"
#todo. "??? add change-side-effect test ???"
	self value: [sclDec2s3 copy] should: [:r | (r = sclDec2s3) & (r ~~ sclDec2s3)]
		conformTo: #'Object' selector: #'copy' opRECEIVER: sclDec2s3.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXdivideOp
	" <number>#/ (returnRule - :receiver :operand) "
	| retVals tmpRec tmpResult |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(1.0s3 -0.000000001s9 0.000000001s9 1.0 4  1.0s3).
	1 to: numList size do: [ :ndx |
		self value: [sclDec2s3 / (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'/'
			ruleReceiver: sclDec2s3 operand: (numList at: ndx)
	].
	self value: [2.0s15 / -2000000000]
		should: [:r | r = -0.000000001000000s15]
		conformTo: #'number' selector: #'/'
		ruleReceiver: 2.0s15 operand: -2000000000.

	"If the return value conforms to <scaledDecimal> then the scale of the result is at least the scale of the receiver after conversion if necessary."
	tmpRec := 26.5s2.
	tmpResult := tmpRec / 5.0s1.
	self should: [tmpResult = 5.30s2 & (tmpResult scale >= tmpRec scale)].

	tmpRec := 26.5s2.
	tmpResult := tmpRec / 5.0s4.
	self should: [tmpResult = 5.3000s4
					& (tmpResult scale >= tmpRec scale)].

	tmpRec := -26.5s2.
	tmpResult := tmpRec / 5.0s4.
	self should: [tmpResult = -5.3000s4
					& (tmpResult scale >= tmpRec scale)].

	self value: [0.0s / sclDec2s3] should: [:r | r = 0.0s]
		conformTo: #'number' selector: #'/'
		ruleReceiver: sclDec2s3 operand: 0.0s.

	"The implementation must signal the ZeroDivide exception."
	self value: [sclDec2s3 / 0.0s] shouldRaise: ZeroDivide.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXequalityOp
	" <number>#= "
	#'Numeric'.
"
	receiver = comparand	=>
	receiver hash = comparand hash
"
	self value: [sclDec2s3 = sclDec2s3]
		should: [:r | r & (sclDec2s3 hash = sclDec2s3 hash) ]
		conformTo: #'number' selector: #'='.
	self should: [5.1s2 = 5.1s1 & (5.1s2 hash = 5.1s1 hash)].
	self value: [ sclDec2s3 = 2.1s3 ]
		shouldnt: [ :r | r | (sclDec2s3 hash = 2.1s3 hash) ]
		conformTo: #'number' selector: #'='.

"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	self value: [ sclDec2s3 = 2 ]
		should: [ :r | r  ifTrue: [ sclDec2s3 hash = 2 hash ]
							ifFalse: [ sclDec2s3 hash ~= 2 hash ]  ]
		conformTo: #'number' selector: #'='.
	self value: [ -2000000000.0s3 = -2000000000 ]
		should: [ :r | r ifTrue: [ -2000000000.0s3 hash = -2000000000 hash ]
						ifFalse: [ -2000000000.0s3 hash ~= -2000000000 hash ]  ]
		conformTo: #'number' selector: #'='.
	self value: [ 2000000000.0s3 = 2000000000 ]
		should: [ :r | r ifTrue: [ 2000000000.0s3 hash = 2000000000 hash ]
						ifFalse: [ 2000000000.0s3 hash ~= 2000000000 hash ]  ]
		conformTo: #'number' selector: #'='.
	self value: [ sclDec2s3 = 2.0 ]
		should: [ :r | r ifTrue: [ sclDec2s3 hash = 2.0 hash ]
						ifFalse: [ sclDec2s3 hash ~= 2.0 hash ]  ]
		conformTo: #'number' selector: #'='.
	self value: [ 2.5s3 = (5/2) ]
		should: [ :r | r ifTrue: [ 2.5s3 hash = (5/2) hash ]
						ifFalse: [ 2.5s3 hash ~= (5/2) hash ]  ]
		conformTo: #'number' selector: #'='.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXfloor
	" <number>#floor "
	#'Numeric'.
	self value: [2.0s3 floor] should: [:r | r = 2]
		conformTo: #'number' selector: #'floor'.
	self value: [2.1s3 floor] should: [:r | r = 2]
		conformTo: #'number' selector: #'floor'.
	self value: [2.5s3 floor] should: [:r | r = 2]
		conformTo: #'number' selector: #'floor'.
	self value: [-2.0s3 floor] should: [:r | r = -2]
		conformTo: #'number' selector: #'floor'.
	self value: [-2.1s3 floor] should: [:r | r = -3]
		conformTo: #'number' selector: #'floor'.
	self value: [-2.5s3 floor] should: [:r | r = -3]
		conformTo: #'number' selector: #'floor'.
	self value: [0.0s3 floor] should: [:r | r = 0]
		conformTo: #'number' selector: #'floor'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXfractionPart
	" <number>#fractionPart (Return Values: <RECEIVER>)"
	| rcvr |
	#'Numeric'.
	"Within the limits of representation, the following invariants should hold:

		receiver integerPart + receiver fractionPart = receiver
		receiver \\1 = receiver fractionPart	(RAH - erroneous, add #'abs')
"
	rcvr := 26.5s3.
	self value: [rcvr fractionPart]
		should: [:r | r = 0.5s3 & (rcvr integerPart + rcvr fractionPart = rcvr)
					& (rcvr \\ 1 = rcvr fractionPart abs)]
		conformTo: #'number' selector: #'fractionPart' opRECEIVER: rcvr.

	rcvr := -26.5s3.
	self value: [rcvr fractionPart]
		should: [:r | r = -0.5s3 & (rcvr integerPart + rcvr fractionPart = rcvr)
					& (rcvr \\ 1 = rcvr fractionPart abs)]
		conformTo: #'number' selector: #'fractionPart' opRECEIVER: rcvr.

	rcvr := 0.0s3.
	self value: [rcvr fractionPart]
		should: [:r | r = 0s3 & (rcvr integerPart + rcvr fractionPart = rcvr)
					& (rcvr \\ 1 = rcvr fractionPart abs)]
		conformTo: #'number' selector: #'fractionPart' opRECEIVER: rcvr.

	rcvr := 0.0s3.
	self value: [rcvr fractionPart]
		should: [:r | r = 0s3 & (rcvr integerPart + rcvr fractionPart = rcvr)
					& (rcvr \\ 1 = rcvr fractionPart abs)]
		conformTo: #'number' selector: #'fractionPart' opRECEIVER: rcvr.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXgreaterThanOp
	" <number>#> "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."

#'todo'."It is erroneous if the receiver and operand are not comparable."
	self value: [5.1s1 > 5.1s2] shouldnt: [:r | r]
		conformTo: #'number' selector: #'>'.
	self value: [-5.1s1 > -5.2s2] should: [:r | r]
		conformTo: #'number' selector: #'>'.

	"Small > Big -> false"
	#( 2 2000000000 2.0 2.0s3 ) do: [ :tstNum |
		self value: [0.3s3 > tstNum] shouldnt: [:r | r]
			conformTo: #'number' selector: #'>'
	].
	self value: [-2000000005.0s3 > -2000000000] shouldnt: [:r | r]
		conformTo: #'number' selector: #'>'.
	self value: [0.25s3 > (1/2)] shouldnt: [:r | r]
		conformTo: #'number' selector: #'>'.

	"Num > Num -> false"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) > (numList at: ndx)]
			shouldnt: [:r | r ] conformTo: #'number' selector: #'>'
	].

	"Big > Small -> true"
	#( 2 2.0 2.0s3 ) do: [ :tstNum |
		self value: [5.0s3 > tstNum] should: [:r | r]
			conformTo: #'number' selector: #'>'
	].
	self value: [9000000000s3 > 2000000000] should: [:r | r]
		conformTo: #'number' selector: #'>'.
	self value: [-1000000005.0s3 > -2000000000] should: [:r | r]
		conformTo: #'number' selector: #'>'.
	self value: [9.0s3 > (1/2)] should: [:r | r] conformTo: #'number' selector: #'>'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXgreaterThanOrEqualToOp
	" <magnitude>#>= "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."

#'todo'."It is erroneous if the receiver and operand are not comparable."
	self value: [5.1s1 >= 5.1s2] should: [:r | r]
		conformTo: #'magnitude' selector: #'>='.
	self value: [-5.1s1 >= -5.9s2] should: [:r | r]
		conformTo: #'magnitude' selector: #'>='.

	"Small >= Big -> false"
	#( 2 2000000000 2.0 2.0s3 ) do: [ :tstNum |
		self value: [0.3s3 >= tstNum] shouldnt: [:r | r]
			conformTo: #'magnitude' selector: #'>='
	].
	self value: [-2000000005.0s3 >= -2000000000] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'>='.
	self value: [0.25s3 >= (1/2)] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'>='.

	"Num >= Num -> true"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) >= (numList at: ndx)]
			should: [:r | r ] conformTo: #'magnitude' selector: #'>='
	].

	"Big >= Small -> true"
	#( 2 2.0 2.0s3 ) do: [ :tstNum |
		self value: [5.0s3 >= tstNum] should: [:r | r]
			conformTo: #'magnitude' selector: #'>='
	].
	self value: [9000000000s3 >= 2000000000] should: [:r | r]
		conformTo: #'magnitude' selector: #'>='.
	self value: [-1000000005.0s3 >= -2000000000] should: [:r | r]
		conformTo: #'magnitude' selector: #'>='.
	self value: [9.0s3 >= (1/2)] should: [:r | r]
		conformTo: #'magnitude' selector: #'>='.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXintegerDivideOp
	" <number>#// "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	"The sign of the result is positive if the receiver and operand
		have the same sign, and negative if the signs are different."
	retVals := #(1 -1 0 1 4 1).
	1 to: numList size do: [ :ndx |
		self value: [sclDec2s3 // (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'//'.
	].

	retVals := #(-1 0 -1 -1 -4 -1).
	1 to: numList size do: [ :ndx |
		self value: [sclDec2s3 // ((numList at: ndx) negated)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'//'
	].

	self should: [25.5s3 // 5.1s3 = 5].
	self should: [25.5s3 // 5 = 5].
	self should: [25500000000.5s3 // 5000000000 = 5].
	self should: [-25500000000.5s3 // -5000000000 = 5].
	self should: [25.5s3 // (51/10) = 5].
	self should: [25.5s3 // 5.1 = 5].

	self value: [0s // sclDec2s3] should: [:r | r = 0s]
		conformTo: #'number' selector: #'//'.

	"If the operand has a value of zero the ZeroDivide exception is signaled."
	self value: [sclDec2s3 // 0s] shouldRaise: ZeroDivide.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXintegerPart
	" <number>#integerPart (returnRule - :receiver) "
	| rcvr |
	#'Numeric'.
	rcvr := 2.5s3.
	self value: [rcvr integerPart] should: [:result | result = 2.0s3]
		conformTo: #'number' selector: #'integerPart' ruleReceiver: rcvr.

	rcvr := 2.0s3.
	self value: [rcvr integerPart] should: [:r | r = 2.0s3]
		conformTo: #'number' selector: #'integerPart' ruleReceiver: rcvr.

	rcvr := -2.0s3.
	self value: [rcvr integerPart] should: [:result | result = -2.0s3]
		conformTo: #'number' selector: #'integerPart' ruleReceiver: rcvr.

	rcvr := 0.0s3.
	self value: [rcvr integerPart] should: [:result | result = 0s3]
		conformTo: #'number' selector: #'integerPart' ruleReceiver: rcvr.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 10:51'!

testXlessThanOp
	" <number>#< "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
#'todo'."It is erroneous if the receiver and operand are not comparable."
	self value: [5.1s1 < 5.1s2] shouldnt: [:r | r]
		conformTo: #'number' selector: #'<'.

	"Small < Big -> true"
	#( 2 2000000000 2.0 2.0s3 ) do: [ :tstNum |
		self value: [0.3s3 < tstNum] should: [:r | r]
			conformTo: #'number' selector: #'<'
	].
	self value: [-2000000005.0s3 < -2000000000] should: [:r | r]
		conformTo: #'number' selector: #'<'.
	self value: [0.25s3 < (1/2)] should: [:r | r]
		conformTo: #'number' selector: #'<'.

	"Num < Num -> false"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) < (numList at: ndx)]
			shouldnt: [:r | r ] conformTo: #'number' selector: #'<'
	].

	"Big < Small -> false"
	#( 2 2.0 2.0s3 ) do: [ :tstNum |
		self value: [5.0s3 < tstNum] shouldnt: [:r | r]
			conformTo: #'number' selector: #'<'
	].
	self value: [9000000000s3 < 2000000000] shouldnt: [:r | r]
		conformTo: #'number' selector: #'<'.
	self value: [-1000000005.0s3 < -2000000000] shouldnt: [:r | r]
		conformTo: #'number' selector: #'<'.
	self value: [9.0s3 < (1/2)] shouldnt: [:r | r] conformTo: #'number' selector: #'<'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXlessThanOrEqualToOp
	" <magnitude>#<= "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."

#'todo'."It is erroneous if the receiver and operand are not comparable."
	self value: [5.1s1 <= 5.1s2] should: [:r | r]
		conformTo: #'magnitude' selector: #'<='.

	"Small <= Big -> true"
	#( 2 2000000000 2.0 2.0s3 ) do: [ :tstNum |
		self value: [0.3s3 <= tstNum] should: [:r | r]
			conformTo: #'magnitude' selector: #'<='
	].
	self value: [-2000000005.0s3 <= -2000000000] should: [:r | r]
		conformTo: #'magnitude' selector: #'<='.
	self value: [0.25s3 <= (1/2)] should: [:r | r]
		conformTo: #'magnitude' selector: #'<='.

	"Num <= Num -> false"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) <= (numList at: ndx)]
			should: [:r | r ] conformTo: #'magnitude' selector: #'<='
	].

	"Big <= Small -> false"
	#( 2 2.0 2.0s3 ) do: [ :tstNum |
		self value: [5.0s3 <= tstNum] shouldnt: [:r | r]
			conformTo: #'magnitude' selector: #'<='
	].
	self value: [9000000000s3 <= 2000000000] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'<='.
	self value: [-1000000005.0s3 <= -2000000000] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'<='.
	self value: [9.0s3 <= (1/2)] shouldnt: [:r | r]
		conformTo: #'magnitude' selector: #'<='.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXmaxX
	" <magnitude>#max: "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
#'todo'."It is erroneous if the receiver and operand are not comparable."

	self value: [2.0s3 max: 3] should: [:r | r = 3]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [-3000000000.0s3 max: -2000000000]
		should: [:r | r = -2000000000]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [2000000000.0s3 max: 2000000003]
		should: [:r | r = 2000000003]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [2.0s3 max: 3.0] should: [:r | r = 3.0]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [2.0s3 max: (5/2)] should: [:r | r = (5/2)]
		conformTo: #'magnitude' selector: #'max:'.
	self value: [2.0s3 max: 3.0s3] should: [:r | r = 3.0s3]
		conformTo: #'magnitude' selector: #'max:'.

	"Num max: Num -> Num"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) max: (numList at: ndx)]
			should: [:r | r = (numList at: ndx)]
			conformTo: #'magnitude' selector: #'max:'
	].
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXminX
	" <magnitude>#min: "
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
#'todo'."It is erroneous if the receiver and operand are not comparable."

	self value: [2.0s3 min: 1] should: [:r | r = 1]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [-1000000000.0s3 min: -2000000000]
		should: [:r | r = -2000000000]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [2000000003.0s3 min: 2000000001]
		should: [:r | r = 2000000001]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [2.0s3 min: 1.0] should: [:r | r = 1.0]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [2.0s3 min: (3/2)] should: [:r | r = (3/2)]
		conformTo: #'magnitude' selector: #'min:'.
	self value: [2.0s3 min: 1.0s5] should: [:r | r = 1.0s5]
		conformTo: #'magnitude' selector: #'min:'.

	"Num min: Num -> Num"
	1 to: numList size do: [ :ndx |
		self value: [(numList at: ndx) min: (numList at: ndx)]
			should: [:r | r = (numList at: ndx)]
			conformTo: #'magnitude' selector: #'min:'
	].
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXmultiplyOp
	" <number>#* (returnRule - :receiver :operand) "
	| retVals tmpRec tmpResult |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(4.0s3 -4000000000.0s3 4000000000.0s3 4.0 1 4.0s3).
	1 to: numList size do: [ :ndx |
		self value: [sclDec2s3 * (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'*'
			ruleReceiver: sclDec2s3 operand: (numList at: ndx)
	].

	"If the return value conforms to <scaledDecimal> then the scale of the result is at least the scale of the receiver after conversion if necessary."
	tmpRec := 26.5s2.
	tmpResult := tmpRec * 5.0s1.
	self should: [tmpResult = 132.50s2 & (tmpResult scale >= tmpRec scale)].

	tmpRec := 26.5s2.
	tmpResult := tmpRec * 5.0s4.
	self should: [tmpResult = 132.5000s4 & (tmpResult scale >= tmpRec scale)].

	tmpRec := -26.5s2.
	tmpResult := tmpRec * 5.0s4.
	self should: [tmpResult = -132.5000s4 & (tmpResult scale >= tmpRec scale)].
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXnegated
	" <number>#negated (Return Values: <RECEIVER>)"
	| rcvr |
	#'Numeric'.
	rcvr := 2.0s3.
	self value: [rcvr negated] should: [:r | r = -2.0s3]
		conformTo: #'number' selector: #'negated' opRECEIVER: rcvr.

	rcvr := -2.0s3.
	self value: [rcvr negated] should: [:r | r = 2.0s3]
		conformTo: #'number' selector: #'negated' opRECEIVER: rcvr.

	rcvr := 0.0s3.
	self value: [rcvr negated] should: [:r | r = 0s3]
		conformTo: #'number' selector: #'negated' opRECEIVER: rcvr.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXnegative
	" <number>#negative "
	#'Numeric'.
	self value: [-2.0s3 negative] should: [:r | r]
		conformTo: #'number' selector: #'negative'.
	self value: [2.0s3 negative] shouldnt: [:r | r]
		conformTo: #'number' selector: #'negative'.
	self value: [0.0s3 negative] shouldnt: [:r | r]
		conformTo: #'number' selector: #'negative'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXpositive
	" <number>#positive "
	#'Numeric'.
	self value: [2.0s3 positive] should: [:r | r]
		conformTo: #'number' selector: #'positive'.
	self value: [0.0s3 positive] should: [:r | r]
		conformTo: #'number' selector: #'positive'.
	self value: [-2.0s3 positive] shouldnt: [:r | r]
		conformTo: #'number' selector: #'positive'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXprintString
	" <number>#printString "
	#'Numeric'.
#'todo'."??? Uncommented fails--compiler error?.
	self value: [26.5s0 printString] should: [:r | r = '26s0']
		conformTo: #'number' selector: #'printString'.
	self value: [26.5s1 printString] should: [:r | r = '26.5s1']
		conformTo: #'number' selector: #'printString'.
	self value: [26.5s2 printString] should: [:r | r = '26.50s2']
		conformTo: #'number' selector: #'printString'.
"	self value: [26.5s3 printString] should: [:r | r = '26.500s3']
		conformTo: #'number' selector: #'printString'.
	self value: [-26.5s1 printString] should: [:r | r = '-26.5s1']
		conformTo: #'number' selector: #'printString'.
	self value: [0.00s printString] should: [:r | r = '0.00s2']
		conformTo: #'number' selector: #'printString'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXquoX
	" <number>#quo: "
	| retVals |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #( 1 0 0 1 4 1 ).
	1 to: numList size do: [ :ndx |
		self value: [sclDec2s3 quo: (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'quo:'.
	].

	retVals := #( -1 0 0 -1 -4 -1 ).
	1 to: numList size do: [ :ndx |
		self value: [sclDec2s3 quo: ((numList at: ndx) negated)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'quo:'
	].

	self should: [(25.5s3 quo: 5.1s3) = 5].
	self should: [(25.5s3 quo: 5) = 5].
	self should: [(25500000000.5s3 quo: 5000000000) = 5].
	self should: [(-25500000000.5s3 quo: -5000000000) = 5].
	self should: [(25.5s3 quo: (51/10)) = 5].
	self should: [(25.5s3 quo: 5.1) = 5].

	self value: [0s quo: sclDec2s3] should: [:r | r = 0s]
		conformTo: #'number' selector: #'quo:'.

	"If the operand has a value of zero the ZeroDivide exception is signaled."
	self value: [sclDec2s3 quo: 0s] shouldRaise: ZeroDivide.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXraisedToIntegerX
	" <number>#raisedToInteger: (Return Values: <RECEIVER>)"
	| rcvr |
	#'Numeric'.
	rcvr := 5.1s2.
	self value: [rcvr raisedToInteger: 0] should: [:r | r = 1.0s2]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.

	self value: [rcvr raisedToInteger: 1] should: [:r | r = rcvr]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.

	self value: [rcvr raisedToInteger: 2] should: [:r | r = 26.01s2]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.

	self value: [rcvr negated raisedToInteger: 2] should: [:r | r = 26.01s2]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.

	self value: [rcvr raisedToInteger: -2]
		should: [:r | r = 0.0384467512495194s2]
		conformTo: #'number' selector: #'raisedToInteger:'
		opRECEIVER: rcvr.

	"It is erroneous if the operand does not conform to the protocol <integer>."
	self value: [rcvr raisedToInteger: 2.0s2]
		shouldRaise: ArithmeticError.

	self value: [0.0s2 raisedToInteger: -2] shouldRaise: ZeroDivide.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXraisedToX
	" <number>#raisedTo: "
	| numVals retVals |
	#'Numeric'.
	numVals := #(2 2.0 0 2.0s3 ) copy.
	numVals at: 3 put: (1/2).
	retVals := #(4.000s3 4.0 1.414213562373095 4.0 ).
	1 to: numVals size do: [ :ndx |
		self value: [sclDec2s3 raisedTo: (numVals at: ndx)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'raisedTo:'.
	].

	retVals := #(0.250s3 0.25 0.7071067811865475 0.25 ).
	1 to: numVals size do: [ :ndx |
		self value: [sclDec2s3 raisedTo: ((numVals at: ndx) negated)]
			should: [:r | r closeTo: (retVals at: ndx)]
			conformTo: #'number' selector: #'raisedTo:'
	].

	self value: [sclDec2s3 raisedTo: 0.0s2] should: [:r | r = 1.0s2]
		conformTo: #'number' selector: #'raisedTo:'.

	self value: [0.0s2 raisedTo: sclDec2s3] should: [:r | r = 0.0s2]
		conformTo: #'number' selector: #'raisedTo:'.

	self value: [sclDec2s3 raisedTo: 1.0s2] should: [:r | r = sclDec2s3]
		conformTo: #'number' selector: #'raisedTo:'.

	"It is erroneous if the receiver equals zero
		and the operand is less than or equal to zero,"
	self value: [0.0s2 raisedTo: -2.0s2] shouldRaise: ArithmeticError.

	"	or if the receiver is less than zero."
	self value: [sclDec2s3 negated raisedTo: 2.0s2]
		shouldRaise: ArithmeticError.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXreciprocal
	" <number>#reciprocal (returnRule - :receiver) "
	#'Numeric'.
	self value: [sclDec2s3 reciprocal] should: [:r | r = (1.0s2/sclDec2s3)]
		conformTo: #'number' selector: #'reciprocal'
		ruleReceiver: sclDec2s3.

	self value: [sclDec2s3 negated reciprocal]
		should: [:r | r = (1.0s2/(sclDec2s3 negated))]
		conformTo: #'number' selector: #'reciprocal'
		ruleReceiver: (sclDec2s3 negated).

	"Signal a ZeroDivide exception if the receiver is equal to zero."
	self value: [0.0s2 reciprocal] shouldRaise: ZeroDivide.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXremX
	" <number>#rem: "
	| num2 sd retVals ndx |
	#'Numeric'.
	"Within the limits of representation, the following invariant should hold:
		(receiver quo: operand)*operand + (receiver rem: operand) = receiver"
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	sd := 26.5s03.
	numList := #( 5 5.0 5.0s3 ).
	retVals := #( 1.500s3 1.5 1.500s3 ).
	ndx := 0.
	numList do: [ :num |
		ndx := ndx + 1.
		self value: [sd rem: num]
			should: [ :r | r = (retVals at: ndx)
					& ((sd quo: num) * num + (sd rem: num) = sd)]
			conformTo: #'number' selector: #'rem:'
	].

	numList := numList collect: [ :num | num negated ].
	ndx := 0.
	numList do: [ :num |
		ndx := ndx + 1.
		self value: [sd rem: num]
			should: [ :r | r = (retVals at: ndx)
					& ((sd quo: num) * num + (sd rem: num) = sd)]
			conformTo: #'number' selector: #'rem:'
	].

	sd := -26.5s3.
	numList := #( 5 5.0 5.0s3 ).
	retVals := retVals collect: [ :num | num negated ].
	ndx := 0.
	numList do: [ :num |
		ndx := ndx + 1.
		self should: [(sd rem: num) = (retVals at: ndx)
				& ((sd quo: num) * num + (sd rem: num) = sd)]
	].

	numList := numList collect: [ :num | num negated ].
	ndx := 0.
	numList do: [ :num |
		ndx := ndx + 1.
		self should: [(sd rem: num) = (retVals at: ndx)
					& ((sd quo: num) * num + (sd rem: num) = sd)]
	].

	sd := 26.5s3.
	num2 := (5/2).
	self value: [sd rem: num2]
		should: [:r | r = 1.5s3
				& ((sd quo: num2) * num2 + (sd rem: num2) = sd)]
		conformTo: #'number' selector: #'rem:'.

	numList := #( -2000000000 2000000000 ).
	sd :=  10000000001.5s3.
	numList do: [ :num |
		self value: [sd rem: num]
			should: [:r | r = 1.5s3
					& ((sd quo: num) * num + (sd rem: num) = sd)]
			conformTo: #'number' selector: #'rem:'
	].

	"If either the receiver or operand are of type <Float> and the operand has a value of zero, the result is implementation defined.  The implementation may signal the ZeroDivide exception or provide a continuation value "
	self value: [sclDec2s3 rem: 0.0] shouldRaise: ZeroDivide.
	self value: [sclDec2s3 rem: 0] shouldRaise: ZeroDivide.
	self value: [sclDec2s3 rem: 0.0s3] shouldRaise: ZeroDivide.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXremainderIntegerDivideOp
	" <number>#\\ (returnRule - :receiver :operand) "
	"The remainder has the same sign as operand.
	Within the limits of representation, the following invariant should hold:

		(receiver // operand) * operand + (receiver \\ operand) = receiver
 "
	| retVals recList ndx tmpRec tmpResult |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	recList := #( 26 -26000000001 26000000001 26.0 0 26.0s3 ) copy.
	recList at: 5 put: (53/2).
	retVals := #(1.0s3 4.0s3 1.0s3 1.0 0 1.0s3 ) copy.
	retVals at: 5 put: (3/2).
	ndx := 0.
	recList do: [ :rec |
		ndx := ndx + 1.
		self value: [rec \\ 5.0s3]
			should: [:r | r = (retVals at: ndx)
					& ((rec // 5.0s3) * 5.0s3 + (rec \\ 5.0s3) = rec)]
			conformTo: #'number' selector: #'\\'
			ruleReceiver: rec operand:  5.0s3.
	].

	"The remainder has the same sign as operand."
	retVals := #(-4.0s3 -1.0s3 -4.0s3 -4.0 0 -4.0s3 ) copy.
	retVals at: 5 put: (-7/2).
	ndx := 0.
	recList do: [ :rec |
		ndx := ndx + 1.
		self value: [rec \\ -5.0s3]
			should: [:r | r = (retVals at: ndx)
					& ((rec // -5.0s3) * -5.0s3 + (rec \\ -5.0s3) = rec)]
			conformTo: #'number' selector: #'\\'
			ruleReceiver: rec operand:  -5.0s3.
	].

	self should: [26.5s3 \\ 5.0s3 = 1.5s3
				& ((26.5s3 // 5.0s3) * 5.0s3 + (26.5s3 \\ 5.0s3) = 26.5s3)].
	self should: [26.5s3 \\ -5.0s3 = -3.5s3
				& ((26.5s3 // -5.0s3) * -5.0s3 + (26.5s3 \\ -5.0s3) = 26.5s3)].

	"If the return value conforms to <scaledDecimal> then the scale of the result is at least the scale of the receiver after conversion if necessary."
	tmpRec := 26.5s2.
	tmpResult := tmpRec \\ 5.0s1.
	self should: [tmpResult = 1.50s2 & (tmpResult scale >= tmpRec scale)].

	tmpRec := 26.5s2.
	tmpResult := tmpRec \\ 5.0s4.
	self should: [tmpResult = 1.5000s4
				& (tmpResult scale >= tmpRec scale)].

	tmpRec := -26.5s2.
	tmpResult := tmpRec \\ 5.0s4.
	self should: [tmpResult = 3.5000s4
				& (tmpResult scale >= tmpRec scale)].

	self should: [0.0s3 \\ sclDec2s3 = 0.0s3].

	"If the operand is zero, the implementation may signal
		the ZeroDivide exception or provide a continuation value."
	self value: [sclDec2s3 \\ 0.0s3] shouldRaise: ZeroDivide.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXroundToX
	" <number>#roundTo: (returnRule - :receiver :operand) "
	| retVals saveR |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(2.000s3 0.000s3 0.000s3 2.0 2 2.000s3).
	1 to: numList size do: [ :ndx |
		self value: [sclDec2s3 roundTo: (numList at: ndx)]
			should: [:r | (saveR := r) = (retVals at: ndx)]
			conformTo: #'number' selector: #'roundTo:'
			ruleReceiver: sclDec2s3 operand: (numList at: ndx)
	].

	self should: [((0 roundTo: sclDec2s3) = 0s3) & (saveR scale = 3)].

	"The result is undefined if factor equals zero."
	self value: [sclDec2s3 / 0.0s3] shouldRaise: ZeroDivide. 
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXrounded
	" <number>#rounded "
	#'Numeric'.
	self value: [2.0s3 rounded] should: [:r | r = 2]
		conformTo: #'number' selector: #'rounded'.
	self value: [2.1s3 rounded] should: [:r | r = 2]
		conformTo: #'number' selector: #'rounded'.
	self value: [2.5s3 rounded] should: [:r | r = 3]
		conformTo: #'number' selector: #'rounded'.
	self value: [-2.0s3 rounded] should: [:r | r = -2]
		conformTo: #'number' selector: #'rounded'.
	self value: [-2.1s3 rounded] should: [:r | r = -2]
		conformTo: #'number' selector: #'rounded'.
	self value: [-2.5s3 rounded] should: [:r | r = -3]
		conformTo: #'number' selector: #'rounded'.
	self value: [0.0s3 rounded] should: [:r | r = 0]
		conformTo: #'number' selector: #'rounded'.	
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXscale
	" <scaledDecimal>#scale "
	#'Numeric'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXsign
	" <number>#sign "
	#'Numeric'.
	self value: [2.0s3 sign] should: [:r | r = 1]
		conformTo: #'number' selector: #'sign'.
	self value: [0.0s3 sign] should: [:r | r = 0]
		conformTo: #'number' selector: #'sign'.
	self value: [-2.0s3 sign] should: [:r | r = -1]
		conformTo: #'number' selector: #'sign'. 
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXsqrt
	" <number>#sqrt "
	#'Numeric'.
	self value: [26.01s0 sqrt] should: [:r | r closeTo: 5.1]
		conformTo: #'number' selector: #'sqrt'.
	self value: [26.01s1 sqrt] should: [:r | r closeTo: 5.1]
		conformTo: #'number' selector: #'sqrt'.
	self value: [26.01s2 sqrt] should: [:r | r closeTo: 5.1]
		conformTo: #'number' selector: #'sqrt'.
	self value: [26.01s3 sqrt] should: [:r | r closeTo: 5.1]
		conformTo: #'number' selector: #'sqrt'.
	self value: [0.0s3 sqrt] should: [:r | r = 0.0]
		conformTo: #'number' selector: #'sqrt'.

	"The result is undefined if the receiver is less than zero."
	self value: [-1.0s3 sqrt] shouldRaise: ArithmeticError.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXsquared
	" <number>#squared (Return Values: <RECEIVER>)"
	| rcvr |
	#'Numeric'.
	rcvr := 5.1s3.
	self value: [rcvr squared] should: [:r | (r = 26.010s3) & (r scale = 3)]
		conformTo: #'number' selector: #'squared' opRECEIVER: rcvr.

#'todo'."??? Uncommented fails--compiler error?.
	rcvr := -5.1s3.
	self value: [rcvr squared] should: [:r | (r = 26.010s3) & (r scale = 3)]
		conformTo: #'number' selector: #'squared' opRECEIVER: rcvr.

	rcvr := 5.1s2.
	self value: [rcvr squared] should: [:r | (r = 26.01s2) & (r scale = 2)]
		conformTo: #'number' selector: #'squared' opRECEIVER: rcvr.

	rcvr := 5.1s1.
	self value: [rcvr squared] should: [:r | (r = 26.0s1) & (r scale = 1)]
		conformTo: #'number' selector: #'squared' opRECEIVER: rcvr.

	self halt.
	rcvr := 5.1s0.
	self value: [rcvr squared] should: [:r | (r = 26.010s3) & (r scale = 0)]
		conformTo: #'number' selector: #'squared' opRECEIVER: rcvr.

	rcvr := 0.0s3.
	self value: [rcvr squared] should: [:r | (r = 0.000s3) & (r scale = 3)]
		conformTo: #'number' selector: #'squared' opRECEIVER: rcvr.
"! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXstrictlyPositive
	" <number>#strictlyPositive "
	#'Numeric'.
	self value: [2.0s3 strictlyPositive] should: [:r | r]
		conformTo: #'number' selector: #'strictlyPositive'.

	self value: [0.0s3 strictlyPositive] shouldnt: [:r | r]
		conformTo: #'number' selector: #'strictlyPositive'.
	self value: [-2.0s3 strictlyPositive] shouldnt: [:r | r]
		conformTo: #'number' selector: #'strictlyPositive'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXsubtractOp
	" <number>#- (returnRule - :receiver :operand) "
	| retVals tmpRec tmpResult |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(0.0s3 2000000002.0s3 -1999999998.0s3 0.0 1.5s3 0.0s3).
	1 to: numList size do: [ :ndx |
		self value: [sclDec2s3 - (numList at: ndx)]
			should: [:r | r = (retVals at: ndx)]
			conformTo: #'number' selector: #'-'
			ruleReceiver: sclDec2s3 operand: (numList at: ndx)
	].

	"If the return value conforms to <scaledDecimal> then the scale of the result is at least the scale of the receiver after conversion if necessary."
	tmpRec := 26.5s2.
	tmpResult := tmpRec - 5.0s1.
	self should: [tmpResult = 21.50s2 & (tmpResult scale >= tmpRec scale)].

	tmpRec := 26.5s2.
	tmpResult := tmpRec - 5.0s4.
	self should: [tmpResult = 21.5000s4 & (tmpResult scale >= tmpRec scale)].

	tmpRec := -26.5s2.
	tmpResult := tmpRec - 5.0s4.
	self should: [tmpResult =  -31.5000s4 & (tmpResult scale >= tmpRec scale)].
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtoX
	" <number>#to: "
	| start middleNdx stop2 |
	#'Numeric'.
	start := 1.0s3.
	numList := #( 2 2.0 0 2.0s3 ) copy.
	numList at: 3 put: (5/2).
	numList do: [ :stop |
		self value: [start to: stop]
			should: [:r | (r size = 2)
					". . . the last element in the sequence . . . is . . .[:]
						receiver + ((stop - receiver) // 1)"
					& (r last = (start + ((stop - start) // 1)))
					"The elements conform to the receiver's protocol."
					& (r allSatisfy: [ :elem |
						elem class conformsToProtocolNamed: #'scaledDecimal'])
			]
			conformTo: #'number' selector: #'to:'
	].

	stop2 := 2000000000s3.
	middleNdx := 1000000000s3.	"Check conformance of first, middle and last."
	self value: [start to: stop2]
		should: [:r | (r size = 2000000000)
				". . . the last element in the sequence . . . is . . .[:]
					receiver + ((stop - receiver) // 1)"
				& (r last = (start + ((stop2 - start) // 1)))
				"The elements conform to the receiver's protocol."
				& ((Array with: (r at: 1)
						with: (r at: middleNdx)
						with: (r at: 3)
				) allSatisfy: [ :elem |
					elem class conformsToProtocolNamed: #'scaledDecimal'])
		]
		conformTo: #'number' selector: #'to:'.

	start := -2000000000.0s3.
	stop2 := -1s3.
	middleNdx := 1000000000.	"Check conformance of first, middle and last."
	self value: [start to: stop2]
		should: [:r | (r size = 2000000000)
				". . . the last element in the sequence . . . is . . .[:]
					receiver + ((stop - receiver) // 1)"
				& (r last = (start + ((stop2 - start) // 1)))
				"The elements conform to the receiver's protocol."
				& ((Array with: (r at: 1)
						with: (r at: middleNdx)
						with: (r at: 3)
				) allSatisfy: [ :elem |
					elem class conformsToProtocolNamed: #'scaledDecimal'])
		]
		conformTo: #'number' selector: #'to:'.

	"The interval answered will be empty if the receiver is greater than stop."
	self value: [1.0s3 to: -1.0s3]
		should: [:r | (r isEmpty)] conformTo: #'number' selector: #'to:'
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtoXbyX
	" <number>#to:by: "
	#'Numeric'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtoXbyXdoX
	" <number>#to:by:do: "
	#'Numeric'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtoXdoX
	" <number>#to:do: "
	#'Numeric'.
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtruncateToX
	" <number>#truncateTo: (returnRule - :receiver :operand) "
	| retVals saveR |
	#'Numeric'.
"	#( 2 -2000000000 2000000000 2.0 1/2 2.0s3 )."
	retVals := #(2.000s3 0.000s3 0.000s3 2.0 2 2.000s3).
	1 to: numList size do: [ :ndx |
		self value: [sclDec2s3 truncateTo: (numList at: ndx)]
			should: [:r | (saveR := r) = (retVals at: ndx)]
			conformTo: #'number' selector: #'truncateTo:'
			ruleReceiver: sclDec2s3 operand: (numList at: ndx)
	].

	self should: [((0 truncateTo: sclDec2s3) = 0s3) & (saveR scale = 3)].
! !

!ScaledDecimalANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:01'!
testXtruncated
	" <number>#truncated "
	#'Numeric'.
	self value: [2.0s3 truncated] should: [:r | r = 2]
		conformTo: #'number' selector: #'truncated'.
	self value: [2.1s3 truncated] should: [:r | r = 2]
		conformTo: #'number' selector: #'truncated'.
	self value: [2.5s3 truncated] should: [:r | r = 2]
		conformTo: #'number' selector: #'truncated'.
	self value: [-2.0s3 truncated] should: [:r | r = -2]
		conformTo: #'number' selector: #'truncated'.
	self value: [-2.1s3 truncated] should: [:r | r = -2]
		conformTo: #'number' selector: #'truncated'.
	self value: [-2.5s3 truncated] should: [:r | r = -2]
		conformTo: #'number' selector: #'truncated'.
	self value: [0.0s3 truncated] should: [:r | r = 0]
		conformTo: #'number' selector: #'truncated'.
! !

!ScaledDecimalANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:18'!
cannonicalObject
	^sclDec2s3! !

!ScaledDecimalANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 16:17'!
protocol
	^#'scaledDecimal'! !


!SelectorANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 15:15'!
cannonicalObject
	^#isNil! !

!SelectorANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 15:15'!
protocol
	^#'selector'! !


!SequencedCollectionHelper methodsFor: 'testing'!
object
	^testCase cannonicalObject! !

!SequencedCollectionHelper methodsFor: 'testing'!
testXatAllPutX
	" <sequencedCollection>#atAllPut: "
	#'Collection'.
! !

!SequencedCollectionHelper methodsFor: 'testing' stamp: 'rej 5/26/2000 05:45'!
testXatAllXputX
	" <sequencedCollection>#atAll:put: "
	#'Collection'.
! !

!SequencedCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXatXputX
	" <sequencedCollection>#at:put: "
	#'Collection'.
! !

!SequencedCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXkeysAndValuesDoX
	" <sequencedReadableCollection>#keysAndValuesDo: "
	#'Collection'.
! !

!SequencedCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXlast
	" <sequencedReadableCollection>#last "
	#'Collection'.
! !

!SequencedCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXreplaceFromXtoXwithObjectX
	" <sequencedCollection>#replaceFrom:to:withObject: "
	#'Collection'.
! !

!SequencedCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXreplaceFromXtoXwithX
	" <sequencedCollection>#replaceFrom:to:with: "
	#'Collection'.
! !

!SequencedCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXreplaceFromXtoXwithXstartingAtX
	" <sequencedCollection>#replaceFrom:to:with:startingAt: "
	#'Collection'.
! !

!SequencedCollectionHelper methodsFor: 'accessing' stamp: 'rej 5/27/2000 08:55'!
object: anObject! !


!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXafterX
	" <sequencedReadableCollection>#after: "
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXatX
	" <sequencedReadableCollection>#at: "
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXatXifAbsentX
	" <sequencedReadableCollection>#at:ifAbsent: "
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXbeforeX
	" <sequencedReadableCollection>#before: "
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXconcatenateOp
	" <sequencedReadableCollection>#, (Return Values: <RECEIVER>)"
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXcopyFromXtoX
	" <sequencedReadableCollection>#copyFrom:to: (Return Values: <RECEIVER>)"
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXcopyReplaceAllXwithX
	" <sequencedReadableCollection>#copyReplaceAll:with: (Return Values: <RECEIVER>)"
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXcopyReplaceFromXtoXwithObjectX
	" <sequencedReadableCollection>#copyReplaceFrom:to:withObject: (Return Values: <RECEIVER>)"
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXcopyReplaceFromXtoXwithX
	" <sequencedReadableCollection>#copyReplaceFrom:to:with: (Return Values: <RECEIVER>)"
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXcopyReplacingXwithObjectX
	" <sequencedReadableCollection>#copyReplacing:withObject: (Return Values: <RECEIVER>)"
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXcopyWithX
	" <sequencedReadableCollection>#copyWith: (Return Values: <RECEIVER>)"
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXcopyWithoutX
	" <sequencedReadableCollection>#copyWithout: (Return Values: <RECEIVER>)"
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXequalityOp
	" <sequencedReadableCollection>#= "
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXfindFirstX
	" <sequencedReadableCollection>#findFirst: "
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXfindLastX
	" <sequencedReadableCollection>#findLast: "
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXfirst
	" <sequencedReadableCollection>#first "
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXfromXtoXdoX
	" <sequencedReadableCollection>#from:to:do: "
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXfromXtoXkeysAndValuesDoX
	" <sequencedReadableCollection>#from:to:keysAndValuesDo: "
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXindexOfSubCollectionXstartingAtX
	" <sequencedReadableCollection>#indexOfSubCollection:startingAt: "
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXindexOfSubCollectionXstartingAtXifAbsentX
	" <sequencedReadableCollection>#indexOfSubCollection:startingAt:ifAbsent: "
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXindexOfX
	" <sequencedReadableCollection>#indexOf: "
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXindexOfXifAbsentX
	" <sequencedReadableCollection>#indexOf:ifAbsent: "
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXreverse
	" <sequencedReadableCollection>#reverse (Return Values: <RECEIVER>)"
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXreverseDoX
	" <sequencedReadableCollection>#reverseDo: "
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'testing' stamp: 'rej 5/25/2000 23:13'!
testXwithXdoX
	" <sequencedReadableCollection>#with:do: "
	#'Collection'.
! !

!SequencedReadableCollectionHelper methodsFor: 'accessing' stamp: 'rej 5/27/2000 08:55'!
object: anObject! !


!SetANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXaddAllX
	" <Set>#addAll: "
	#'Collection'.
! !

!SetANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXaddX
	" <Set>#add: "
	#'Collection'.
! !

!SetANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXremoveAllX
	" <extensibleCollection>#removeAll: "
	#'Collection'.
! !

!SetANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXremoveX
	" <extensibleCollection>#remove: "
	#'Collection'.
! !

!SetANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXremoveXifAbsentX
	" <extensibleCollection>#remove:ifAbsent: "
	#'Collection'.
! !

!SetANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 07:11'!
cannonicalObject
	^Set with: 1 with: 2 with: 3 with: 4! !

!SetANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 06:57'!
protocol
	^#Set! !


!SetFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXnew
	" <Set factory>#new "
	#'Collection'.
! !

!SetFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:16'!
testXnewX
	" <Set factory>#new: "
	#'Collection'.
! !

!SetFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXwithAllX
	" <Set factory>#withAll: "
	#'Collection'.
! !

!SetFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXwithX
	" <Set factory>#with: "
	#'Collection'.
! !

!SetFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXwithXwithX
	" <Set factory>#with:with: "
	#'Collection'.
! !

!SetFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXwithXwithXwithX
	" <Set factory>#with:with:with: "
	#'Collection'.
! !

!SetFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXwithXwithXwithXwithX
	" <Set factory>#with:with:with:with: "
	#'Collection'.
! !

!SetFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 07:10'!
cannonicalObject
	^Set! !

!SetFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 07:02'!
protocol
	^#'Set factory'! !


!SortedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXaddAllX
	" <extensibleCollection>#addAll: "
	#'Collection'.
! !

!SortedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXaddX
	" <SortedCollection>#add: "
	#'Collection'.
! !

!SortedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXremoveAllX
	" <extensibleCollection>#removeAll: "
	#'Collection'.
! !

!SortedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXremoveAtIndexX
	" <sequencedContractibleCollection>#removeAtIndex: "
	#'Collection'.
! !

!SortedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXremoveFirst
	" <sequencedContractibleCollection>#removeFirst "
	#'Collection'.
! !

!SortedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXremoveLast
	" <sequencedContractibleCollection>#removeLast "
	#'Collection'.
! !

!SortedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXremoveX
	" <extensibleCollection>#remove: "
	#'Collection'.
! !

!SortedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXremoveXifAbsentX
	" <extensibleCollection>#remove:ifAbsent: "
	#'Collection'.
! !

!SortedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXsortBlock
	" <SortedCollection>#sortBlock "
	#'Collection'.
! !

!SortedCollectionANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXsortBlockX
	" <SortedCollection>#sortBlock: "
	#'Collection'.
! !

!SortedCollectionANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 07:05'!
cannonicalObject
	^SortedCollection with: 1 with: 2 with: 3 with: 4! !

!SortedCollectionANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 07:05'!
protocol
	^#SortedCollection! !


!SortedCollectionANSITest class methodsFor: 'instance creation' stamp: 'rej 5/27/2000 16:17'!
helperClassesDo: aBlock
	super helperClassesDo: aBlock.
	aBlock value: SequencedCollectionHelper.
	aBlock value: SequencedReadableCollectionHelper
! !


!SortedCollectionFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXnew
	" <SortedCollection factory>#new "
	#'Collection'.
! !

!SortedCollectionFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXnewX
	" <SortedCollection factory>#new: "
	#'Collection'.
! !

!SortedCollectionFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXsortBlockX
	" <SortedCollection factory>#sortBlock: "
	#'Collection'.
! !

!SortedCollectionFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXwithAllX
	" <SortedCollection factory>#withAll: "
	#'Collection'.
! !

!SortedCollectionFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXwithX
	" <SortedCollection factory>#with: "
	#'Collection'.
! !

!SortedCollectionFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXwithXwithX
	" <SortedCollection factory>#with:with: "
	#'Collection'.
! !

!SortedCollectionFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXwithXwithXwithX
	" <SortedCollection factory>#with:with:with: "
	#'Collection'.
! !

!SortedCollectionFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXwithXwithXwithXwithX
	" <SortedCollection factory>#with:with:with:with: "
	#'Collection'.
! !

!SortedCollectionFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 07:06'!
cannonicalObject
	^SortedCollection! !

!SortedCollectionFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 07:06'!
protocol
	^#'SortedCollection factory'! !


!StringANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXasLowercase
	" <readableString>#asLowercase "
	#'Collection'.
! !

!StringANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXasString
	" <String>#asString "
	#'Collection'.
! !

!StringANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXasSymbol
	" <readableString>#asSymbol "
	#'Collection'.
! !

!StringANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXasUppercase
	" <readableString>#asUppercase "
	#'Collection'.
! !

!StringANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXbetweenXandX
	" <magnitude>#between:and: "
	#'Collection'.
! !

!StringANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXgreaterThanOp
	" <readableString>#> "
	#'Collection'.
! !

!StringANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXgreaterThanOrEqualToOp
	" <readableString>#>= "
	#'Collection'.
! !

!StringANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXlessThanOp
	" <readableString>#< "
	#'Collection'.
! !

!StringANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXlessThanOrEqualToOp
	" <readableString>#<= "
	#'Collection'.
! !

!StringANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXmaxX
	" <magnitude>#max: "
	#'Collection'.
! !

!StringANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXminX
	" <magnitude>#min: "
	#'Collection'.
! !

!StringANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:17'!
testXsameAsX
	" <readableString>#sameAs: "
	#'Collection'.
! !

!StringANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXsubStringsX
	" <readableString>#subStrings: "
	#'Collection'.
! !

!StringANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 07:07'!
cannonicalObject
	^'abcd'! !

!StringANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 07:07'!
protocol
	^#String! !


!StringANSITest class methodsFor: 'instance creation' stamp: 'rej 5/27/2000 16:18'!
helperClassesDo: aBlock
	super helperClassesDo: aBlock.
	aBlock value: SequencedCollectionHelper.
	aBlock value: SequencedReadableCollectionHelper
! !


!StringFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXnew
	" <String factory>#new "
	#'Collection'.
! !

!StringFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXnewX
	" <String factory>#new: "
	#'Collection'.
! !

!StringFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXwithAllX
	" <String factory>#withAll: "
	#'Collection'.
! !

!StringFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXwithX
	" <String factory>#with: "
	#'Collection'.
! !

!StringFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXwithXwithX
	" <String factory>#with:with: "
	#'Collection'.
! !

!StringFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXwithXwithXwithX
	" <String factory>#with:with:with: "
	#'Collection'.
! !

!StringFactoryANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXwithXwithXwithXwithX
	" <String factory>#with:with:with:with: "
	#'Collection'.
! !

!StringFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 07:08'!
cannonicalObject
	^String! !

!StringFactoryANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 07:08'!
protocol
	^#'String factory'! !


!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/27/2000 09:40'!
setUp
	super setUp.
	smalltalkSymbol := #'Smalltalk'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXasLowercase
	" <readableString>#asLowercase "
	#'Collection'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXasString
	" <symbol>#asString "
	#'Collection'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXasSymbol
	" <symbol>#asSymbol (Return Values: <RECEIVER>) "
	#'Collection'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXasUppercase
	" <readableString>#asUppercase "
	#'Collection'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXbetweenXandX
	" <magnitude>#between:and: "
	#'Collection'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Collection'.

#todo. "??? add change-side-effect test ???"
	
"
If the receiver is an identity object, return the receiver.
"
	self value: [smalltalkSymbol copy]
		should: [:r | (r = smalltalkSymbol) & (r == smalltalkSymbol)]
		conformTo: #'Object' selector: #'copy' opRECEIVER: smalltalkSymbol.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXequalityOp
	" <sequencedReadableCollection>#= "
	#'Collection'.
"	The value of receiver = comparand is true if and only if the value of comparand = receiver would also be true. If the value of receiver = comparand is true then the receiver and comparand must have equivalent hash values.  Or more formally:

	receiver = comparand	=>
	receiver hash = comparand hash
Refinement: <sequenceReadableCollection>
Unless specifically refined, the receiver and operand are equivalent if all of the following are true:
1. The receiver and operand are instances of the same class.
2. They answer the same value for the #size message.
3. For all indices of the receiver, the element in the receiver at a given index is equivalent to the element in operand at the same index.
Element lookup is defined by the #at: message for the receiver and operand.
"
#todo. "??? add Refinement: test ???"
	self value: [smalltalkSymbol = smalltalkSymbol]
		should: [:r | r and: [smalltalkSymbol hash = smalltalkSymbol hash] ]
		conformTo: #'sequencedReadableCollection' selector: #'='.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXgreaterThanOp
	" <readableString>#> "
	#'Collection'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXgreaterThanOrEqualToOp
	" <readableString>#>= "
	#'Collection'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXhash
	" <Object>#hash "
	#'Collection'.
"	Any two objects that are considered equivalent using the #= message must have the same hash value.  More formally:

	receiver = comparand	=>
	receiver hash = comparand hash
"
		#'Fundamental'.
	self shouldnt: [smalltalkSymbol = 'Smalltalk'].
	self shouldnt: [smalltalkSymbol hash = 'Smalltalk' hash].
	self value: [smalltalkSymbol hash]
		should: [:r | r = smalltalkSymbol hash]
		conformTo: #'Object' selector: #'hash'.
	self value: [smalltalkSymbol hash]
		shouldnt: [:r | r = #'smalltalk' hash]
		conformTo: #'Object' selector: #'hash'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXidentityHash
	" <Object>#identityHash "
	#'Collection'.
	self value: [smalltalkSymbol identityHash]
		should: [:r | r = smalltalkSymbol identityHash]
		conformTo: #'Object' selector: #'identityHash'.

	self value: [smalltalkSymbol identityHash]
		shouldnt: [:r | r = #'smalltalk' identityHash]
		conformTo: #'Object' selector: #'identityHash'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXidentityOp
	" <Object>#== "
	#'Collection'.
"	The value of receiver == comparand is true if and only if the value of comparand == receiver would also be true. If the value of receiver == comparand is true then the receiver and comparand must have equivalent identity hash values.  Or more formally:

	receiver == comparand =>
	receiver identityHash = comparand identityHash
"
	self value: [smalltalkSymbol == smalltalkSymbol]
		should: [:r | r] conformTo: #'Object' selector: #'=='.

	self value: [smalltalkSymbol == #'smalltalk']
		shouldnt: [:r | r] conformTo: #'Object' selector: #'=='.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXisKindOfX
	" <Object>#isKindOf: "
	#'Collection'.
"	The return value is unspecified if the receiver is a class object or candidateClass is not a class object.
"
#todo. "Fix find a test for unspecified rule above ???"
	self value: [smalltalkSymbol isKindOf: Symbol]
		should: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.

	"Metaclass tests:"
	self value: [smalltalkSymbol class isKindOf: (Symbol class)]
		should: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.

	"Inherit tests:"
	self value: [smalltalkSymbol class isKindOf: (Object class)]
		should: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.

	self value: [smalltalkSymbol isKindOf: Number]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'isKindOf:'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXisMemberOfX
	" <Object>#isMemberOf: "
	#'Collection'.
"	The return value is unspecified if the receiver is a class object or candidateClass is not a class object.
"
#todo. "Fix find a test for unspecified rule above ???"
	self value: [smalltalkSymbol isMemberOf: Symbol]
		should: [:r | r] conformTo: #'Object' selector: #'isMemberOf:'.

	"Metaclass tests:"
	self value: [smalltalkSymbol class isMemberOf: (Symbol class)]
		should: [:r | r] conformTo: #'Object' selector: #'isMemberOf:'.

	"Fail inherit tests:"
	self value: [smalltalkSymbol class isMemberOf: (Object class)]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'isMemberOf:'.

	self value: [smalltalkSymbol isMemberOf: Number]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'isMemberOf:'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXkeysAndValuesDoX
	" <sequencedReadableCollection>#keysAndValuesDo: "
	#'Collection'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXlast
	" <sequencedReadableCollection>#last "
	#'Collection'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXlessThanOp
	" <readableString>#< "
	#'Collection'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXlessThanOrEqualToOp
	" <readableString>#<= "
	#'Collection'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXmaxX
	" <magnitude>#max: "
	#'Collection'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXminX
	" <magnitude>#min: "
	#'Collection'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXnotEqualityOp
	" <Object>#~= "
	#'Collection'.
"	The value of receiver ~= comparand is true if and only if the value of
comparand ~= receiver would also be true.
"
	self value: [smalltalkSymbol ~= #'smalltalk']
		should: [:r | r] conformTo: #'Object' selector: #'~='.

	self value: [smalltalkSymbol ~= smalltalkSymbol]
		shouldnt: [:r | r] conformTo: #'Object' selector: #'~='.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXnotIdentityOp
	" <Object>#~~ "
	#'Collection'.
"	The value of receiver ~~ comparand is true if and only if the value of comparand ~~ receiver would also be true.
"
	self value: [smalltalkSymbol ~~ #'smalltalk'] should: [:r | r]
		conformTo: #'Object' selector: #'~~'.

	self value: [smalltalkSymbol ~~ smalltalkSymbol] shouldnt: [:r | r]
		conformTo: #'Object' selector: #'~~'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXsameAsX
	" <readableString>#sameAs: "
	#'Collection'.
! !

!SymbolANSITest methodsFor: 'testing' stamp: 'rej 5/25/2000 23:18'!
testXsubStringsX
	" <readableString>#subStrings: "
	#'Collection'.
! !

!SymbolANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 07:09'!
cannonicalObject
	^#abcd! !

!SymbolANSITest methodsFor: 'constants' stamp: 'rej 5/27/2000 09:45'!
protocol
	^#symbol! !


!SymbolANSITest class methodsFor: 'instance creation' stamp: 'rej 5/27/2000 16:19'!
helperClassesDo: aBlock
	super helperClassesDo: aBlock.
	aBlock value: SequencedReadableCollectionHelper
! !


!TranscriptANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXcr
	" <puttableStream>#cr "
	#'Stream'.
! !

!TranscriptANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXflush
	" <puttableStream>#flush "
	#'Stream'.
! !

!TranscriptANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnextPutAllX
	" <puttableStream>#nextPutAll: "
	#'Stream'.
! !

!TranscriptANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnextPutX
	" <puttableStream>#nextPut: "
	#'Stream'.
! !

!TranscriptANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXspace
	" <puttableStream>#space "
	#'Stream'.
! !

!TranscriptANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXtab
	" <puttableStream>#tab "
	#'Stream'.
! !

!TranscriptANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:44'!
cannonicalObject
	^Transcript
	! !

!TranscriptANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:43'!
protocol
	^#'Transcript'
	! !


!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXclass
	" <Object>#class "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdefaultAction
	" <Warning>#defaultAction "
	| tmp theText |
	#'Exception'.
	theText := 'the text'.
	self value: [[	Warning signal: 'the text'
			] on: Warning do: [ :aWarning |
				tmp := aWarning messageText ]]
		should: [:r | true "UNSPECIFIED" & tmp = theText]
		conformTo: #'Warning' selector: #'defaultAction'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdescription
	" <exceptionDescription>#description "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdoesNotUnderstandX
	" <Object>#doesNotUnderstand: "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXequalityOp
	" <Object>#= "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXerrorX
	" <Object>#error: "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXhash
	" <Object>#hash "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityHash
	" <Object>#identityHash "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityOp
	" <Object>#== "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisKindOfX
	" <Object>#isKindOf: "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisMemberOfX
	" <Object>#isMemberOf: "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisNested
	" <signaledException>#isNested "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisNil
	" <Object>#isNil "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisResumable
	" <Notification>#isResumable "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXmessageText
	" <exceptionDescription>#messageText "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXmessageTextX
	" <exceptionBuilder>#messageText: (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotEqualityOp
	" <Object>#~= "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotIdentityOp
	" <Object>#~~ "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotNil
	" <Object>#notNil "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXouter
	" <signaledException>#outer "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXpass
	" <signaledException>#pass "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformX
	" <Object>#perform: "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithArgumentsX
	" <Object>#perform:withArguments: "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithX
	" <Object>#perform:with: "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithX
	" <Object>#perform:with:with: "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithXwithX
	" <Object>#perform:with:with:with: "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintOnX
	" <Object>#printOn: "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintString
	" <Object>#printString "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXresignalAsX
	" <signaledException>#resignalAs: "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXrespondsToX
	" <Object>#respondsTo: "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXresume
	" <signaledException>#resume "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXresumeX
	" <signaledException>#resume: "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXretry
	" <signaledException>#retry "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXretryUsingX
	" <signaledException>#retryUsing: "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXreturn
	" <signaledException>#return "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXreturnX
	" <signaledException>#return: "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsignal
	" <exceptionSignaler>#signal "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsignalX
	" <exceptionSignaler>#signal: "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXtag
	" <exceptionDescription>#tag "
	#'Exception'.
! !

!WarningANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXyourself
	" <Object>#yourself (Return Values: <RECEIVER>) "
	#'Exception'.
! !


!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXallSubclasses
	" <classDescription>#allSubclasses "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXallSuperclasses
	" <classDescription>#allSuperclasses "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXclass
	" <Object>#class "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXconcatenateOp
	" <exceptionSelector>#, "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdoesNotUnderstandX
	" <Object>#doesNotUnderstand: "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXequalityOp
	" <Object>#= "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXerrorX
	" <Object>#error: "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXhandlesX
	" <Exception class>#handles: "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXhash
	" <Object>#hash "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityHash
	" <Object>#identityHash "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityOp
	" <Object>#== "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisKindOfX
	" <Object>#isKindOf: "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisMemberOfX
	" <Object>#isMemberOf: "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisNil
	" <Object>#isNil "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXname
	" <classDescription>#name "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnew
	" <Warning class>#new "
	#'Exception'.
	self value: [Warning new] should: [:r | true "??? r = Warning signal ???"]
		conformTo: #'Warning class' selector: #'new'.


! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotEqualityOp
	" <Object>#~= "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotIdentityOp
	" <Object>#~~ "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotNil
	" <Object>#notNil "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformX
	" <Object>#perform: "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithArgumentsX
	" <Object>#perform:withArguments: "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithX
	" <Object>#perform:with: "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithX
	" <Object>#perform:with:with: "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithXwithX
	" <Object>#perform:with:with:with: "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintOnX
	" <Object>#printOn: "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintString
	" <Object>#printString "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXrespondsToX
	" <Object>#respondsTo: "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsignal
	" <Exception class>#signal "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsignalX
	" <exceptionSignaler>#signal: "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsubclasses
	" <classDescription>#subclasses "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsuperclass
	" <classDescription>#superclass "
	#'Exception'.
! !

!WarningClassANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXyourself
	" <Object>#yourself (Return Values: <RECEIVER>) "
	#'Exception'.
! !


!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 10:47'!
setUp
	super setUp.
	" This method will create a file named 'ansiTestFile.junk' in the current directory
	if it does not already exist. "

	"writeFileStream := FileStream write: 'ansiTestFile.junk'"
! !

!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/16/2000 18:23'!
tearDown
	"writeFileStream close"! !

!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXclose
	" <sequencedStream>#close "
	#'File Stream'.
! !

!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXcontents
	" <FileStream>#contents "
	#'File Stream'.
! !

!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXcr
	" <puttableStream>#cr "
	#'File Stream'.
! !

!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXexternalType
	" <FileStream>#externalType "
	#'File Stream'.
! !

!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXflush
	" <puttableStream>#flush "
	#'File Stream'.
! !

!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXisBinary
	" <FileStream>#isBinary "
	#'File Stream'.
! !

!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXisEmpty
	" <sequencedStream>#isEmpty "
	#'File Stream'.
! !

!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXisText
	" <FileStream>#isText "
	#'File Stream'.
! !

!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnextPutAllX
	" <puttableStream>#nextPutAll: "
	#'File Stream'.
! !

!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnextPutX
	" <puttableStream>#nextPut: "
	#'File Stream'.
! !

!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXposition
	" <sequencedStream>#position "
	#'File Stream'.
! !

!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXpositionX
	" <sequencedStream>#position: "
	#'File Stream'.
! !

!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXreset
	" <sequencedStream>#reset "
	#'File Stream'.
! !

!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXsetToEnd
	" <sequencedStream>#setToEnd "
	#'File Stream'.
! !

!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXspace
	" <puttableStream>#space "
	#'File Stream'.
! !

!WriteFileStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXtab
	" <puttableStream>#tab "
	#'File Stream'.
! !

!WriteFileStreamANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 18:17'!
cannonicalObject
	^writeFileStream! !

!WriteFileStreamANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 18:15'!
protocol
	^#'writeFileStream'! !


!WriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/18/2000 10:43'!
setUp
	super setUp.
	writeStream := WriteStream on: String new! !

!WriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXclose
	" <sequencedStream>#close "
	#'Stream'.
! !

!WriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXcontents
	" <collectionStream>#contents "
	#'Stream'.
! !

!WriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXcr
	" <puttableStream>#cr "
	#'Stream'.
! !

!WriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXflush
	" <puttableStream>#flush "
	#'Stream'.
! !

!WriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXisEmpty
	" <sequencedStream>#isEmpty "
	#'Stream'.
! !

!WriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnextPutAllX
	" <puttableStream>#nextPutAll: "
	#'Stream'.
! !

!WriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXnextPutX
	" <puttableStream>#nextPut: "
	#'Stream'.
! !

!WriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXposition
	" <sequencedStream>#position "
	#'Stream'.
! !

!WriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXpositionX
	" <sequencedStream>#position: "
	#'Stream'.
! !

!WriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXreset
	" <sequencedStream>#reset "
	#'Stream'.
! !

!WriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXsetToEnd
	" <sequencedStream>#setToEnd "
	#'Stream'.
! !

!WriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXspace
	" <puttableStream>#space "
	#'Stream'.
! !

!WriteStreamANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXtab
	" <puttableStream>#tab "
	#'Stream'.
! !

!WriteStreamANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:45'!
cannonicalObject
	^writeStream! !

!WriteStreamANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:45'!
protocol
	^#'WriteStream'! !


!WriteStreamFactoryANSITest methodsFor: 'testing' stamp: 'djm 3/14/2000 17:03'!
testXwithX
	" <WriteStream factory>#with: "
	#'Stream'.
! !

!WriteStreamFactoryANSITest methodsFor: 'constants' stamp: 'djm 3/16/2000 17:48'!
cannonicalObject
	^WriteStream! !

!WriteStreamFactoryANSITest methodsFor: 'constants' stamp: 'djm 3/17/2000 15:29'!
protocol
	^#'WriteStream factory'! !


!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXclass
	" <Object>#class "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdefaultAction
	" <Error>#defaultAction "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdescription
	" <exceptionDescription>#description "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdividend
	" <ZeroDivide>#dividend "
	#'Exception'.
	self value: [	[(ZeroDivide dividend: 1) signal
				] on: ZeroDivide do: [ :aZeroDivide |
					aZeroDivide return: (aZeroDivide dividend) ] ]
		should: [:r | r = 1] conformTo: #'ZeroDivide' selector: #'dividend'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdoesNotUnderstandX
	" <Object>#doesNotUnderstand: "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXequalityOp
	" <Object>#= "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXerrorX
	" <Object>#error: "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXhash
	" <Object>#hash "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityHash
	" <Object>#identityHash "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityOp
	" <Object>#== "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisKindOfX
	" <Object>#isKindOf: "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisMemberOfX
	" <Object>#isMemberOf: "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisNested
	" <signaledException>#isNested "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisNil
	" <Object>#isNil "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisResumable
	" <ZeroDivide>#isResumable "
	#'Exception'.
	self value: [	[(ZeroDivide dividend: 1) signal
				] on: ZeroDivide do: [ :aZeroDivide |
					aZeroDivide return: aZeroDivide isResumable ] ]
		should: [:r | r] conformTo: #'ZeroDivide' selector: #'isResumable'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXmessageText
	" <exceptionDescription>#messageText "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXmessageTextX
	" <exceptionBuilder>#messageText: (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotEqualityOp
	" <Object>#~= "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotIdentityOp
	" <Object>#~~ "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotNil
	" <Object>#notNil "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXouter
	" <signaledException>#outer "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXpass
	" <signaledException>#pass "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformX
	" <Object>#perform: "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithArgumentsX
	" <Object>#perform:withArguments: "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithX
	" <Object>#perform:with: "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithX
	" <Object>#perform:with:with: "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithXwithX
	" <Object>#perform:with:with:with: "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintOnX
	" <Object>#printOn: "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintString
	" <Object>#printString "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXresignalAsX
	" <signaledException>#resignalAs: "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXrespondsToX
	" <Object>#respondsTo: "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXresume
	" <signaledException>#resume "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXresumeX
	" <signaledException>#resume: "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXretry
	" <signaledException>#retry "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXretryUsingX
	" <signaledException>#retryUsing: "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXreturn
	" <signaledException>#return "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXreturnX
	" <signaledException>#return: "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsignal
	" <exceptionSignaler>#signal "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsignalX
	" <exceptionSignaler>#signal: "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXtag
	" <exceptionDescription>#tag "
	#'Exception'.
! !

!ZeroDivideANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXyourself
	" <Object>#yourself (Return Values: <RECEIVER>) "
	#'Exception'.
! !


!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXclass
	" <Object>#class "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXconcatenateOp
	" <exceptionSelector>#, "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXcopy
	" <Object>#copy (Return Values: <RECEIVER>) "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdividendX
	" <ZeroDivide factory>#dividend: "
	| dividendTmp msgResult |
	#'Exception'.
	self value: [	[(msgResult := ZeroDivide dividend: 1) signal
				] on: ZeroDivide do: [ :aZeroDivide |
					dividendTmp := aZeroDivide dividend.
					aZeroDivide return: msgResult ] ]
		should: [:r | dividendTmp = 1]
		conformTo: #'ZeroDivide factory' selector: #'dividend:'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXdoesNotUnderstandX
	" <Object>#doesNotUnderstand: "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXequalityOp
	" <Object>#= "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXerrorX
	" <Object>#error: "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXhandlesX
	" <exceptionSelector>#handles: "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXhash
	" <Object>#hash "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityHash
	" <Object>#identityHash "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXidentityOp
	" <Object>#== "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisKindOfX
	" <Object>#isKindOf: "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisMemberOfX
	" <Object>#isMemberOf: "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXisNil
	" <Object>#isNil "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnew
	" <exceptionInstantiator>#new "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotEqualityOp
	" <Object>#~= "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotIdentityOp
	" <Object>#~~ "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXnotNil
	" <Object>#notNil "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformX
	" <Object>#perform: "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithArgumentsX
	" <Object>#perform:withArguments: "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithX
	" <Object>#perform:with: "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithX
	" <Object>#perform:with:with: "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXperformXwithXwithXwithX
	" <Object>#perform:with:with:with: "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintOnX
	" <Object>#printOn: "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXprintString
	" <Object>#printString "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXrespondsToX
	" <Object>#respondsTo: "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsignal
	" <ZeroDivide factory>#signal "
	| msgResult |
	#'Exception'.
	self value: [	[msgResult := (ZeroDivide dividend: 1) signal
				] on: ZeroDivide do: [ :aZeroDivide |
					aZeroDivide return: msgResult ] ]
		should: [:r | true "unspecified"]
		conformTo: #'ZeroDivide factory' selector: #'signal'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXsignalX
	" <exceptionSignaler>#signal: "
	#'Exception'.
! !

!ZeroDivideFactoryANSITest methodsFor: 'testing' stamp: 'tfei 3/13/2000 15:02'!
testXyourself
	" <Object>#yourself (Return Values: <RECEIVER>) "
	#'Exception'.
! !


CollectionHelper initialize!
ObjectHelper initialize!

