"=====================================================================
|
|   Smalltalk built in methods.  These are read in by the system 
|   initially, to prepare the execution environment.
|
|
 ======================================================================"

"======================================================================
|
| Copyright 2001 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LIB.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

Object subclass: #ObjectMemory
       instanceVariableNames: ''
       classVariableNames: ''
       poolDictionaries: ''
       category: 'Language-Implementation'
!

ObjectMemory comment: 'I provide a few methods that enable one to tune the
virtual machine''s usage of memory.  In addition, I can signal to my
dependants some `events'' that can happen during the virtual machine''s
life.'!


!ObjectMemory class methodsFor: 'dependancy'!

update: aspect
    "Do any global tasks for the ObjectMemory events."
    aspect == #returnFromSnapshot ifFalse: [ ^self ].

    ContextPart checkPresenceOfJIT.
! !

!ObjectMemory class methodsFor: 'saving the image'!

snapshot
    "Save a snapshot on the image file that was loaded on startup."
    self snapshot: File image
! !


!ObjectMemory class methodsFor: 'initialization'!

initialize
    "Initialize the globals"

    "This method is called after all the kernel Smalltalk classes have been
     loaded.  It generally performs any initializations that might depend on
     the full Smalltalk class hierarchy being defined. After this is file is
     loaded, some 'advanced' class definitions are loaded (CFuncs, Autoload,
     exception handling, ...) and then the binary image is saved."

    Smalltalk at: #Dependencies put: (IdentityDictionary new).

    Fraction initialize.
    LargeInteger initialize.
    Date initialize.
    Time initialize.
    FileDescriptor initialize.
    Delay initialize.

    Smalltalk addFeature: #Kernel.
    KernelInitialized := true.
    self addDependent: self.
    self changed: #returnFromSnapshot
! !

ObjectMemory initialize!
