/***********************************************************************
 *
 *  Gtk+ wrappers for GNU Smalltalk
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 2001, 2003 Free Software Foundation, Inc.
 * Written by Paolo Bonzini and Norman Jordan.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/

#include "config.h"
#include "gstpub.h"

#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <glib.h>

#ifdef STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif

#include "blox-gtk.h"

VMProxy *_blox_vm_proxy;
static GHashTable *h_event_data = NULL;
static GHashTable *h_callback = NULL;
static int pending_quit_count = 0;

static void blox_gtk_init ();
static gint cleanup_callback_data (GtkWidget *widget, gpointer data);
static void connect_signal (OOP widget, char *event_name, OOP event_handler,
			    OOP user_data);
static void my_gtk_main_iteration ();
static void my_gtk_main_iteration_do (gboolean blocking);
static gboolean should_quit ();


void
connect_signal (OOP widget, char *event_name, OOP event_handler,
		OOP user_data)
{
  eventData *data;
  eventData *newEventData;
  const char *widgetClassName;
  GtkWidget *cWidget = _blox_vm_proxy->OOPToCObject (widget);
  void *signalFunc = NULL;
  GtkType currentType;

  newEventData = (eventData *) malloc (sizeof (eventData));
  newEventData->eventHandler = event_handler;
  newEventData->data = user_data;
  newEventData->widget = widget;
  _blox_vm_proxy->registerOOP (event_handler);
  _blox_vm_proxy->registerOOP (user_data);
  _blox_vm_proxy->registerOOP (widget);
  newEventData->next = NULL;

  currentType = GTK_OBJECT_TYPE (cWidget);
  widgetClassName = gtk_type_name (currentType);
  signalFunc =
    g_hash_table_lookup (g_hash_table_lookup (h_callback, widgetClassName),
			 event_name);

  while (signalFunc == NULL && strcmp (widgetClassName, "GtkObject") != 0)
    {
      currentType = gtk_type_parent (currentType);
      widgetClassName = gtk_type_name (currentType);
      signalFunc =
	g_hash_table_lookup (g_hash_table_lookup
			     (h_callback, widgetClassName), event_name);
    }

  if (signalFunc == NULL)
    return;

  gtk_signal_connect (GTK_OBJECT (cWidget), event_name,
		      GTK_SIGNAL_FUNC (signalFunc), newEventData);

  if (h_event_data == NULL)
    h_event_data = g_hash_table_new (g_direct_hash, g_direct_equal);

  data = g_hash_table_lookup (h_event_data, cWidget);
  if (data == NULL)
    {
      g_hash_table_insert (h_event_data, cWidget, newEventData);

      gtk_signal_connect_after (GTK_OBJECT (cWidget), "destroy",
				GTK_SIGNAL_FUNC (cleanup_callback_data),
				NULL);
    }
  else
    {
      while (data->next)
	data = data->next;

      data->next = newEventData;
    }
}


void
blox_gtk_init ()
{
  int argc = 1;
  gchar *argvArray[] = { "gst", NULL };
  gchar **argv = argvArray;
  gtk_init (&argc, &argv);

  h_callback = _blox_create_callback_hash ();
}


gint
cleanup_callback_data (GtkWidget * widget, gpointer data)
{
  eventData *ed, *nextEventData;

  ed = g_hash_table_lookup (h_event_data, widget);
  if (ed != NULL)
    g_hash_table_remove (h_event_data, widget);

  while (ed != NULL)
    {
      nextEventData = ed->next;
      _blox_vm_proxy->unregisterOOP (ed->eventHandler);
      _blox_vm_proxy->unregisterOOP (ed->data);
      _blox_vm_proxy->unregisterOOP (ed->widget);
      free (ed);
      ed = nextEventData;
    }

  return (FALSE);
}

void
my_gtk_main_iteration ()
{
  while (gtk_events_pending ())
    pending_quit_count += gtk_main_iteration_do (TRUE);
}

void
my_gtk_main_iteration_do (gboolean blocking)
{
  while (gtk_events_pending ())
    pending_quit_count += gtk_main_iteration_do (blocking);
}

gboolean
should_quit ()
{
  if (!pending_quit_count)
    return FALSE;

  pending_quit_count--;
  return TRUE;
}

void
gst_initModule (proxy)
     VMProxy *proxy;
{
  _blox_vm_proxy = proxy;
  _blox_vm_proxy->defineCFunc ("bloxGtkInit", blox_gtk_init);
  _blox_vm_proxy->defineCFunc ("bloxGtkConnectSignal", connect_signal);
  _blox_vm_proxy->defineCFunc ("bloxGtkMainIteration", my_gtk_main_iteration);
  _blox_vm_proxy->defineCFunc ("bloxGtkMainIterationDo", my_gtk_main_iteration_do);
  _blox_vm_proxy->defineCFunc ("bloxGtkShouldQuit", should_quit);

  h_event_data = NULL;
}
