/*
 *  sig_tables.c - lookup tables used in generating the signature
 *  Copyright (C) 2000  eTantrum, Inc.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

double _sp_sig_pcm_envelope[] =
{
    0.49259183496028713378, 0.49355439785391075347, 0.49451789845162213988,
    0.49548233490492904485, 0.49644770535637222642, 0.49741400793952222914,
    0.49838124077897583142, 0.49934940199035349195, 0.50031848968029535296,
    0.50128850194645935279, 0.50225943687751750666, 0.5032312925531534642,
    0.50420406704405951182, 0.50517775841193413022, 0.50615236470947944092,
    0.50712788398039843063, 0.50810431425939284189, 0.5090816535721605085,
    0.51005989993539357918, 0.51103905135677563099, 0.512019105834980226,
    0.51300006135966880194, 0.51398191591148822965, 0.51496466746206959186,
    0.51594831397402607376, 0.51693285340095129765, 0.51791828368741787969,
    0.51890460276897576453, 0.51989180857215078202, 0.52087989901444353702,
    0.52186887200432785505, 0.52285872544124956107, 0.52384945721562570231,
    0.52484106520884343805, 0.52583354729325870736, 0.52682690133219600703,
    0.52782112517994717038, 0.52881621668177081208, 0.52981217367389177308,
    0.53080899398350089857, 0.53180667542875392773, 0.53280521581877160475,
    0.53380461295363956786, 0.53480486462440779416, 0.53580596861309104373,
    0.53680792269266808248, 0.53781072462708245929, 0.53881437217124250605,
    0.53981886307102155964, 0.54082419506325818404, 0.54183036587575672538,
    0.54283737322728808916, 0.54384521482758985123, 0.544853888377367368,
    0.54586339156829422059, 0.54687372208301365806, 0.5478848775951389305,
    0.54889685576925462129, 0.54990965426091786838, 0.55092327071665925242,
    0.55193770277398468416, 0.55295294806137640364, 0.5539690041982943125,
    0.55498586879517808335, 0.55600353945344849205, 0.55702201376550897205,
    0.55804128931474816788, 0.55906136367554104538, 0.56008223441325155623,
    0.56110389908423452532, 0.56212635523583742714, 0.56314960040640382744,
    0.56417363212527449345, 0.56519844791279050256, 0.56622404528029601778,
    0.56725042173014028624, 0.56827757475568119183, 0.56930550184128736468,
    0.57033420046234140077, 0.57136366808524330363, 0.57239390216741292683,
    0.57342490015729341568, 0.57445665949435475994, 0.5754891776090966804,
    0.57652245192305295873, 0.57755647984879376899, 0.57859125878993056258,
    0.57962678614111906583, 0.5806630592880634989, 0.58170007560752035047,
    0.58273783246730226359, 0.58377632722628258755, 0.58481555723439926364,
    0.58585551983265926612, 0.58689621235314293202, 0.58793763211900851307,
    0.58897977644449672763, 0.59002264263493553464, 0.59106622798674479657,
    0.5921105297874412754, 0.59315554531564340657, 0.5942012718410766281,
    0.59524770662457837656, 0.59629484691810319408, 0.59734268996472839053,
    0.59839123299865903949, 0.59944047324523419551, 0.60049040792093189012,
    0.60154103423337490497, 0.60259234938133687809, 0.60364435055474807701,
    0.60469703493470150502, 0.6057503996934586743, 0.60680444199445615627,
    0.6078591589923116878, 0.60891454783283049945, 0.60997060565301219892,
    0.61102732958105654415, 0.61208471673637099286, 0.61314276422957691981,
    0.61420146916251650016, 0.61526082862826014797, 0.61632083971111295551,
    0.61738149948662190969, 0.61844280502158377466, 0.61950475337405164211,
    0.62056734159334281387, 0.62163056672004612935, 0.62269442578602984817,
    0.6237589158144489776, 0.62482403381975348822, 0.62588977680769597445,
    0.62695614177533987021, 0.62802312571106733152, 0.62909072559458734109,
    0.63015893839694481215, 0.63122776108052780497, 0.63229719059907674161,
    0.63336722389769328778, 0.63443785791284801334, 0.6355090895723902733,
    0.63658091579555642348, 0.63765333349297881327, 0.63872633956669533362,
    0.63979993091015829876, 0.64087410440824343905, 0.64194885693725989295,
    0.64302418536495897783, 0.64410008655054451499, 0.64517655734468171147,
    0.64625359458950759617, 0.6473311951186404567, 0.64840935575719005346,
    0.64948807332176716756, 0.65056734462049481404, 0.6516471664530170127,
    0.65272753561051055637, 0.65380844887569466994, 0.6548899030228414464,
    0.65597189481778728215, 0.65705442101794253595, 0.65813747837230340831,
    0.65922106362146215552, 0.66030517349761830292, 0.66138980472459030224,
    0.6624749540178255236, 0.6635606180844131341, 0.66464679362309453392,
    0.66573347732427490264, 0.66682066587003518965, 0.66790835593414366045,
    0.66899654418206788709, 0.67008522727098618343, 0.67117440184980059481,
    0.67226406455914766713, 0.6733542120314117696, 0.67444484089073719613,
    0.67553594775303971165, 0.676627529226020763, 0.67771958190917835907,
    0.67881210239382061555, 0.67990508726307885556, 0.68099853309191948902,
    0.68209243644715844557, 0.68318679388747272085, 0.68428160196341469845,
    0.68537685721742536149, 0.6864725561838469492, 0.68756869538893705673,
    0.68866527135088240197, 0.68976228057981214814, 0.69085971957781144859,
    0.69195758483893587965, 0.69305587284922576252, 0.69415458008671870882,
    0.69525370302146571877, 0.69635323811554428186, 0.69745318182307269872,
    0.69855353059022584628, 0.69965428085524794533, 0.70075542904846865877,
    0.7018569715923169694, 0.70295890490133727813, 0.70406122538220261564,
    0.70516392943373129576, 0.70626701344690123729, 0.70737047380486561821,
    0.70847430688296797463, 0.70957850904875796605, 0.71068307666200658534,
    0.71178800607472247908, 0.71289329363116649141, 0.71399893566786920562,
    0.71510492851364559908, 0.71621126848961158551, 0.71731795190919989125,
    0.71842497507817726365, 0.71953233429465912607, 0.72064002584912778548,
    0.72174804602444797563, 0.72285639109588395446, 0.72396505733111582437,
    0.72507404099025651867, 0.72618333832586945409, 0.727292945582984518,
    0.72840285899911560996, 0.72951307480427829422, 0.73062358922100656411,
    0.73173439846437082767, 0.73284549874199467201, 0.73395688625407318195,
    0.73506855719339081467, 0.73618050774533838609, 0.73729273408793150058,
    0.73840523239182898063, 0.73951799882035007538, 0.74063102952949344537,
    0.74174432066795514817, 0.7428578683771470681, 0.74397166879121578997,
    0.74508571803706036274, 0.7462000122343516173, 0.7473145474955513734,
    0.74842931992593042523, 0.74954432562358797032, 0.75065956067947081642,
    0.75177502117739258836, 0.75289070319405249077, 0.75400660279905529215,
    0.75512271605493064275, 0.75623903901715250342, 0.75735556773415901866,
    0.75847229824737194548, 0.75958922659121719256, 0.76070634879314369403,
    0.76182366087364472573, 0.7629411588462771121, 0.76405883871768187632,
    0.76517669648760466838, 0.76629472814891563814, 0.76741292968763086257,
    0.76853129708293244082, 0.76964982630718870027, 0.77076851332597651201,
    0.7718873540981004977, 0.77300634457561523405, 0.77412548070384590293,
    0.77524475842140960768, 0.77636417366023646736, 0.77748372234559137706,
    0.77860340039609488016, 0.77972320372374559483, 0.78084312823394097514,
    0.78196316982550018171, 0.78308332439068462083, 0.78420358781522103708,
    0.78532395597832271861, 0.78644442475271247872, 0.78756499000464419424,
    0.788685647593925232, 0.78980639337393931942, 0.790927223191668749,
    0.7920481328877168048, 0.79316911829633085507, 0.79429017524542500084,
    0.79541129955660261341, 0.79653248704517998213, 0.79765373352020896291,
    0.79877503478450007091, 0.7998963866346460172, 0.80101778486104513455,
    0.80213922524792402591, 0.80326070357336232242, 0.80438221560931533194,
    0.80550375712163846398, 0.80662532387010998924, 0.80774691160845646376,
    0.8088685160843752664, 0.80999013303955957888, 0.81111175820972236661,
    0.81223338732462013745, 0.81335501610807836581, 0.81447664027801469633,
    0.81559825554646436796, 0.8167198576196046389, 0.81784144219777887841,
    0.81896300497552265707, 0.82008454164158739452, 0.8212060478789658946,
    0.82232751936491754741, 0.82344895177099297623, 0.82457034076305968373,
    0.8256916820013278091, 0.82681297114037421991, 0.8279342038291693795,
    0.82905537571110277106, 0.83017648242400732261, 0.83129751960018694046,
    0.83241848286644148924, 0.83353936784409232708, 0.8346601701490090619,
    0.83578088539163575277, 0.83690150917701655597, 0.83802203710482237042,
    0.83914246476937703889, 0.84026278775968399337, 0.84138300165945301146,
    0.84250310204712619555, 0.84362308449590572845, 0.84474294457377929746,
    0.84586267784354873811, 0.84698227986285512525, 0.84810174618420774983,
    0.84922107235500943201, 0.85034025391758538692, 0.85145928640920953701,
    0.85257816536213226755, 0.85369688630360773818, 0.85481544475592174948,
    0.85593383623641960956, 0.85705205625753289045, 0.8581701003268082939,
    0.85928796394693529592, 0.86040564261577379135, 0.86152313182638240452,
    0.86264042706704691099, 0.86375752382130777107, 0.86487441756798955073,
    0.86599110378122845511, 0.86710757793050063924, 0.86822383548065196202,
    0.86933987189192496459, 0.87045568261998951254, 0.87157126311596988533,
    0.87268660882647464128, 0.8738017151936255944, 0.8749165776550861251,
    0.87603119164409104513, 0.87714555258947590755, 0.87825965591570531732,
    0.8793734970429037956, 0.88048707138688342422, 0.881600374359175043,
    0.8827134013670568935, 0.88382614781358470601, 0.88493860909762123157,
    0.88605078061386610688, 0.88716265775288594142, 0.88827423590114396035,
    0.88938551044103086873, 0.89049647675089405041, 0.89160713020506821014,
    0.89271746617390546064, 0.89382748002380663088, 0.89493716711725035395,
    0.89604652281282426429, 0.89715554246525575088, 0.89826422142544248839,
    0.89937255504048296828, 0.90048053865370769611, 0.9015881676047096116,
    0.90269543722937561903, 0.90380234285991722931, 0.90490887982490186836,
    0.90601504344928418533, 0.90712082905443680581, 0.90822623195818230624,
    0.90933124747482407813, 0.91043587091517830245, 0.91154009758660525797,
    0.91264392279304074052, 0.91374734183502825946, 0.91485035000975034603,
    0.91595294261106052769, 0.91705511492951552466, 0.91815686225240666918,
    0.91925817986379254609, 0.92035906304453041216, 0.9214595070723093917,
    0.92255950722168167388, 0.92365905876409559738, 0.92475815696792751375,
    0.92585679709851465002, 0.9269549744181871942, 0.92805268418630160188,
    0.92914992165927245971, 0.93024668209060568103, 0.93134296073093114643,
    0.93243875282803589943, 0.93353405362689634295, 0.93462885836971187903,
    0.93572316229593777148, 0.93681696064231845256, 0.9379102486429201635,
    0.93900302152916481635, 0.94009527452986274554, 0.94118700287124701376,
    0.9422782017770053864, 0.94336886646831541459, 0.94445899216387696473,
    0.94554857407994619134, 0.94663760743036939882, 0.94772608742661612613,
    0.94881400927781389676, 0.94990136819078163644, 0.95098815937006353494,
    0.95207437801796279686, 0.95316001933457650264, 0.95424507851782913725,
    0.95532955076350678514, 0.95641343126529154706, 0.95749671521479573499,
    0.95857939780159662213, 0.95966147421326997158, 0.96074293963542511943,
    0.96182378925174016882, 0.96290401824399463049, 0.9639836217921062822,
    0.96506259507416436438, 0.96614093326646521831, 0.96721863154354625891,
    0.96829568507822172396, 0.96937208904161697998, 0.97044783860320371627,
    0.97152292893083513903, 0.97259735519078083232, 0.97367111254776184115,
    0.97474419616498619856, 0.97581660120418367566, 0.97688832282564197484,
    0.97795935618824092472, 0.97902969644948845129, 0.98009933876555677124,
    0.98116827829131647576, 0.98223651018037294591, 0.98330402958510221278,
    0.98437083165668548546, 0.98543691154514656549, 0.98650226439938615286,
    0.98756688536721781713, 0.98863076959540507893, 0.98969391222969571587,
    0.99075630841485895495, 0.99181795329472077771, 0.99287884201220033553,
    0.99393896970934558777, 0.99499833152737049424, 0.99605692260668954319,
    0.99711473808695583188, 0.99817177310709592764, 0.9992280228053469493,
    1.0002834823192929825, 1.0013381467859006069, 1.0023920113415569766,
    1.0034450711221047925, 1.0044973212628791615, 1.005548756898745566,
    1.0065993731641342812, 1.0076491651930787885, 1.0086981281192521909,
    1.0097462570760034062, 1.0107935471963940266, 1.0118399936132358441,
    1.0128855914591272658, 1.0139303358664903953, 1.0149742219676078925,
    1.0160172448946600543, 1.0170593997797614527, 1.0181006817549989041,
    1.0191410859524683286, 1.0201806075043107214, 1.0212192415427514547,
    1.0222569832001360268, 1.0232938276089671437, 1.0243297699019431324,
    1.0253648052119950229, 1.0263989286723229633, 1.0274321354164352993,
    1.028464420578184102, 1.0294957792918044692, 1.0305262066919504971,
    1.0315556979137341376, 1.0325842480927620581, 1.0336118523651731671,
    1.0346385058676770274, 1.0356642037375907162, 1.036688941112877016,
    1.0377127131321819409, 1.0387355149348727057, 1.0397573416610754737,
    1.0407781884517131044, 1.0417980504485433446, 1.0428169227941956887,
    1.0438348006322113459, 1.04485167910707899, 1.0458675533642742828,
    1.0468824185502967339, 1.0478962698127090025, 1.0489091023001739789,
    1.0499209111624931978, 1.0509316915506450307, 1.051941438616822877,
    1.0529501475144729117, 1.0539578133983329433, 1.0549644314244703835,
    1.0559699967503197726, 1.0569745045347223034, 1.0579779499379633467,
    1.0589803281218110875, 1.059981634249554272, 1.0609818634860408437,
    1.0619810109977174672, 1.0629790719526659437, 1.0639760415206429567,
    1.0649719148731182639, 1.0659666871833131108, 1.0669603536262382004,
    1.0679529093787334393, 1.0689443496195052408, 1.069934669529165383,
    1.0709238642902698668, 1.0719119290873573291, 1.072898859106987679,
    1.0738846495377805113, 1.0748692955704539642, 1.0758527923978631335,
    1.0768351352150387079, 1.0778163192192262709, 1.0787963396099238267,
    1.0797751915889217678, 1.0807528703603406228, 1.0817293711306699144,
    1.082704689108807683, 1.0836788195060977902, 1.0846517575363703312,
    1.0856234984159796042, 1.0865940373638418581, 1.0875633696014763707,
    1.0885314903530423081, 1.0894983948453782485, 1.0904640783080410404,
    1.0914285359733446601, 1.0923917630763986253, 1.0933537548551477414,
    1.0943145065504096269, 1.0952740134059149035, 1.0962322706683447215,
    1.0971892735873713942, 1.0981450174156952571, 1.09909949740908508,
    1.100052708826416481, 1.10100464692971034, 1.1019553069841718784,
    1.1029046842582308496, 1.103852774023578398, 1.1047995715552065832,
    1.1057450721314490139, 1.1066892710340168193, 1.1076321635480403938,
    1.1085737449621055895, 1.1095140105682954612, 1.1104529556622266817,
    1.1113905755430899536, 1.112326865513688201, 1.113261820880476316,
    1.1141954369535986835, 1.1151277090469291497, 1.116058632478110102,
    1.116988202568589994, 1.1179164146436639804, 1.118843264032511442,
    1.1197687460682355098, 1.120692856087901923, 1.1216155894325774423,
    1.1225369414473693741, 1.1234569074814639844, 1.1243754828881651342,
    1.1252926630249342477, 1.1262084432534276157, 1.1271228189395359198,
    1.1280357854534237561, 1.1289473381695669385, 1.1298574724667926894,
    1.1307661837283176087, 1.131673467341786532, 1.1325793186993118322,
    1.1334837331975118335, 1.1343867062375490029, 1.1352882332251694741,
    1.1361883095707416835, 1.1370869306892947836, 1.137984092000556835,
    1.1388797889289952181, 1.1397740169038530489, 1.1406667713591895907,
    1.1415580477339180021, 1.1424478414718439723, 1.1433361480217045791,
    1.1442229628372073691, 1.1451082813770674385, 1.1459920991050476236,
    1.1468744114899962483, 1.1477552140058846497, 1.1486345021318482562,
    1.1495122713522223368, 1.150388517156582191, 1.1512632350397808967,
    1.1521364205019875016, 1.153008069048726103, 1.1538781761909135959,
    1.154746737444898752, 1.15561374833249908, 1.1564792043810410149,
    1.157343101123396778, 1.1582054340980234564, 1.1590661988490005285,
    1.1599253909260682782, 1.1607830058846668742, 1.1616390392859725633,
    1.1624934866969383052, 1.1633463436903292987, 1.1641976058447631726,
    1.1650472687447466225, 1.1658953279807142689, 1.1667417791490657386,
    1.1675866178522049665, 1.1684298396985768331, 1.169271440302705356,
    1.1701114152852321038, 1.1709497602729537213, 1.1717864708988594558,
    1.1726215428021691256, 1.1734549716283706466, 1.1742867530292588896,
    1.1751168826629712072, 1.1759453561940269584, 1.1767721692933645894,
    1.1775973176383782715, 1.1784207969129567584, 1.1792426028075206901,
    1.1800627310190585639, 1.1808811772511662586, 1.1816979372140827831,
    1.1825130066247286909, 1.1833263812067427168, 1.1841380566905197469,
    1.1849480288132470118, 1.1857562933189420562, 1.1865628459584895982,
    1.187367682489679499, 1.1881707986772420682, 1.1889721902928864772,
    1.1897718531153380628, 1.1905697829303731883, 1.1913659755308589894,
    1.1921604267167877911, 1.1929531322953157435, 1.1937440880807981269,
    1.1945332898948270994, 1.1953207335662681121, 1.1961064149312961025,
    1.1968903298334330199, 1.1976724741235833527, 1.1984528436600712098,
    1.1992314343086767359, 1.2000082419426727487, 1.2007832624428600443,
    1.2015564916976055887, 1.2023279256028764905, 1.2030975600622781929,
    1.2038653909870897785, 1.2046314142962994964, 1.2053956259166425102,
    1.2061580217826350925, 1.2069185978366112622, 1.2076773500287600882,
    1.2084342743171585521, 1.2091893666678104058, 1.2099426230546799221,
    1.2106940394597285326, 1.2114436118729499103, 1.2121913362924066071,
    1.2129372087242640266, 1.2136812251828270615, 1.2144233816905753987,
    1.2151636742781981582, 1.2159020989846303085, 1.2166386518570870834,
    1.2173733289510990652, 1.2181061263305483777, 1.2188370400677026595,
    1.2195660662432508126, 1.2202932009463371976, 1.2210184402745973831,
    1.221741780334192562, 1.222463217239844413, 1.2231827471148695174,
    1.2239003660912148863, 1.224616070309491267, 1.2253298559190091144,
    1.2260417190778114538, 1.2267516559527098519, 1.2274596627193181675,
    1.2281657355620863026, 1.228869870674335063, 1.2295720642582901316,
    1.2302723125251162628, 1.2309706116949510335, 1.231666957996938816,
    1.2323613476692651947, 1.233053776959190051, 1.233744242123081758,
    1.2344327394264511533, 1.2351192651439841796, 1.2358038155595763019,
    1.2364863869663658136, 1.2371669756667671436, 1.237845577972504385,
    1.2385221902046437137, 1.2391968086936280269, 1.239869429779308696,
    1.2405400498109799834, 1.2412086651474107946, 1.2418752721568779851,
    1.2425398672171994452, 1.2432024467157669623, 1.2438630070495784175,
    1.2445215446252704261, 1.2451780558591518666, 1.2458325371772349666,
    1.2464849850152681654, 1.247135395818769199, 1.2477837660430566302,
    1.2484300921532816009, 1.2490743706244609168, 1.2497165979415085779,
    1.2503567705992673087, 1.2509948851025411987, 1.2516309379661270107,
    1.2522649257148461555, 1.2528968448835753335, 1.2535266920172800642,
    1.2541544636710437732, 1.2547801564101010996, 1.2554037668098680935,
    1.256025291455974191, 1.2566447269442917456, 1.2572620698809697792,
    1.257877316882462404, 1.2584904645755607966, 1.2591015095974245064,
    1.2597104485956107656, 1.2603172782281066855, 1.2609219951633585666,
    1.2615245960803032066, 1.2621250776683974326, 1.2627234366276491873,
    1.2633196696686477267, 1.2639137735125927087, 1.2645057448913257225,
    1.2650955805473589333, 1.2656832772339059456, 1.2662688317149102257,
    1.2668522407650768535, 1.2674335011698998343, 1.2680126097256936291,
    1.2685895632396206878, 1.269164358529722092, 1.2697369924249468642,
    1.2703074617651799461, 1.2708757634012721738, 1.2714418941950691444,
    1.2720058510194398593, 1.2725676307583053681, 1.2731272303066683005,
    1.2736846465706397336, 1.2742398764674700562, 1.2747929169255749482,
    1.2753437648845653563, 1.2758924172952754716, 1.2764388711197900417,
    1.2769831233314727914, 1.2775251709149948454, 1.2780650108663622611,
    1.2786026401929431184, 1.2791380559134966077, 1.2796712550581985646,
    1.2802022346686707799, 1.2807309917980074232, 1.2812575235108025762,
    1.2817818268831771, 1.2823038990028057249, 1.2828237369689443614,
    1.2833413378924567461, 1.2838566988958408643, 1.2843698171132564845,
    1.2848806896905504704, 1.2853893137852843154, 1.285895686566759899,
    1.2863998052160459107, 1.2869016669260040509, 1.2874012689013152322,
    1.2878986083585046707, 1.2883936825259691972, 1.2888864886440016821,
    1.289377023964816793, 1.2898652857525776394, 1.290351271283419976,
    1.2908349778454779599, 1.2913164027389096855, 1.2917955432759216094,
    1.2922723967807940859, 1.2927469605899062355, 1.2932192320517603701,
    1.2936892085270073061, 1.2941568873884699009, 1.2946222660211690325,
    1.2950853418223464697, 1.2955461122014899633, 1.296004574580357005,
    1.2964607263929996961, 1.2969145650857873964, 1.2973660881174311488,
    1.2978152929590078823, 1.2982621770939835049, 1.2987067380182362175,
    1.2991489732400802737, 1.2995888802802890716, 1.3000264566721184689,
    1.3004616999613292094, 1.3008946077062113478, 1.3013251774776051217,
    1.3017534068589255991, 1.302179293446183328, 1.3026028348480083174,
    1.30302402868567202, 1.3034428725931095361, 1.3038593642169413744,
    1.3042735012164961006, 1.3046852812638316532, 1.3050947020437582147,
    1.3055017612538584171, 1.3059064566045099909, 1.3063087858189070811,
    1.3067087466330808976, 1.3071063367959221413, 1.3075015540692014326,
    1.3078943962275895174, 1.3082848610586794713, 1.308672946363007572,
    1.3090586499540721732, 1.3094419696583561308, 1.309822903315346343,
    1.3102014487775544005, 1.3105776039105359043, 1.310951366592911338,
    1.3113227347163864955, 1.3116917061857709115, 1.3120582789189985107,
    1.3124224508471469264, 1.3127842199144570401, 1.3131435840783520774,
    1.3135005413094575921, 1.3138550895916192296, 1.314207226921922711,
    1.3145569513107127069, 1.3149042607816112671, 1.3152491533715364724,
    1.3155916271307201981, 1.3159316801227285421, 1.3162693104244778119,
    1.3166045161262538432, 1.3169372953317295405, 1.3172676461579833074,
    1.3175955667355165879, 1.3179210552082702979, 1.3182441097336452529,
    1.3185647284825157133, 1.318882909639250034, 1.3191986514017257637,
    1.3195119519813474085, 1.3198228096030635292, 1.3201312225053822846,
    1.3204371889403903051, 1.3207407071737666815, 1.3210417754848007288,
    1.3213403921664086393, 1.3216365555251483599, 1.321930263881236689,
    1.3222215155685643762, 1.3225103089347123309, 1.322796642340967388,
    1.3230805141623369625, 1.3233619227875657032, 1.323640866619149481,
    1.3239173440733511544, 1.3241913535802156687, 1.3244628935835844885,
    1.324731962541110919, 1.3249985589242738726, 1.3252626812183925242,
    1.3255243279226420761, 1.3257834975500657482, 1.3260401886275903216,
    1.326294399696039461, 1.3265461293101485918, 1.3267953760385764461,
    1.3270421384639212725, 1.3272864151827319379, 1.3275282048055232487,
    1.327767505956787053, 1.3280043172750073399, 1.3282386374126713413,
    1.3284704650362839651, 1.3286997988263786752, 1.3289266374775319246,
    1.3291509796983738134, 1.3293728242116014115, 1.3295921697539907491,
    1.3298090150764079187, 1.33002335894382262, 1.3302352001353181521,
    1.3304445374441038474, 1.3306513696775268407, 1.3308556956570825047,
    1.3310575142184262187, 1.3312568242113846928, 1.3314536244999657377,
    1.3316479139623709216, 1.3318396914910042295, 1.3320289559924840539,
    1.3322157063876525207, 1.3323999416115868133, 1.3325816606136082765,
    1.3327608623572935187, 1.3329375458204826277, 1.3331117099952907168,
    1.3332833538881163626, 1.3334524765196513751, 1.3336190769248899013,
    1.3337831541531379731, 1.3339447072680223894, 1.3341037353474998195,
    1.3342602374838647972, 1.3344142127837590461, 1.334565660368180362,
    1.3347145793724897178, 1.3348609689464210337, 1.3350048282540876166,
    1.3351461564739917076, 1.3352849527990306999, 1.3354212164365069082,
    1.3355549466081326759, 1.3356861425500397011, 1.3358148035127852538,
    1.335940928761359725, 1.336064517575193733, 1.3361855692481647839,
    1.3363040830886039334, 1.3364200584193022259, 1.3365334945775175779,
    1.3366443909149812175, 1.3367527467979030131, 1.3368585616069781352,
    1.3369618347373934952, 1.3370625655988312985, 1.3371607536154781481,
    1.3372563982260277093, 1.3373494988836862607, 1.3374400550561797996,
    1.3375280662257571507, 1.3376135318891964054, 1.3376964515578080306,
    1.3377768247574413074, 1.3378546510284874405, 1.3379299299258848865,
    1.3380026610191229075, 1.3380728438922462331, 1.3381404781438586138,
    1.3382055633871272615, 1.3382680992497855144, 1.3383280853741370553,
    1.338385521417059687, 1.3384404070500075523, 1.338492741959015353,
    1.3385425258447003483, 1.3385897584222663514, 1.3386344394215052844,
    1.3386765685868002862, 1.3387161456771285994, 1.3387531704660629028,
    1.3387876427417741976, 1.3388195623070338058, 1.338848928979214481,
    1.338875742590293294, 1.3389000029868523001, 1.3389217100300805363,
    1.3389408635957753546, 1.3389574635743426434, 1.3389715098707999363,
    1.338983002404774636, 1.3389919411105073443, 1.3389983259368505308,
    1.3390021568472700864, 1.3390034338198455455, 1.3390021568472700864,
    1.3389983259368505308, 1.3389919411105073443, 1.338983002404774636,
    1.3389715098707999363, 1.3389574635743426434, 1.3389408635957753546,
    1.3389217100300805363, 1.3389000029868523001, 1.338875742590293294,
    1.338848928979214481, 1.3388195623070338058, 1.3387876427417741976,
    1.3387531704660629028, 1.3387161456771285994, 1.3386765685868002862,
    1.3386344394215052844, 1.3385897584222663514, 1.3385425258447003483,
    1.338492741959015353, 1.3384404070500075523, 1.338385521417059687,
    1.3383280853741370553, 1.3382680992497855144, 1.3382055633871272615,
    1.3381404781438586138, 1.3380728438922462331, 1.3380026610191229075,
    1.3379299299258848865, 1.3378546510284874405, 1.3377768247574413074,
    1.3376964515578080306, 1.3376135318891964054, 1.3375280662257571507,
    1.3374400550561797996, 1.3373494988836862607, 1.3372563982260277093,
    1.3371607536154781481, 1.3370625655988312985, 1.3369618347373934952,
    1.3368585616069781352, 1.3367527467979030131, 1.3366443909149812175,
    1.3365334945775175779, 1.3364200584193022259, 1.3363040830886039334,
    1.3361855692481647839, 1.336064517575193733, 1.335940928761359725,
    1.3358148035127852538, 1.3356861425500397011, 1.3355549466081326759,
    1.3354212164365069082, 1.3352849527990306999, 1.3351461564739917076,
    1.3350048282540876166, 1.3348609689464210337, 1.3347145793724897178,
    1.334565660368180362, 1.3344142127837590461, 1.3342602374838647972,
    1.3341037353474998195, 1.3339447072680223894, 1.3337831541531379731,
    1.3336190769248899013, 1.3334524765196513751, 1.3332833538881163626,
    1.3331117099952907168, 1.3329375458204826277, 1.3327608623572935187,
    1.3325816606136082765, 1.3323999416115868133, 1.3322157063876525207,
    1.3320289559924840539, 1.3318396914910042295, 1.3316479139623709216,
    1.3314536244999657377, 1.3312568242113846928, 1.3310575142184262187,
    1.3308556956570825047, 1.3306513696775268407, 1.3304445374441038474,
    1.3302352001353181521, 1.33002335894382262, 1.3298090150764079187,
    1.3295921697539907491, 1.3293728242116014115, 1.3291509796983738134,
    1.3289266374775319246, 1.3286997988263786752, 1.3284704650362839651,
    1.3282386374126713413, 1.3280043172750073399, 1.327767505956787053,
    1.3275282048055232487, 1.3272864151827319379, 1.3270421384639212725,
    1.3267953760385764461, 1.3265461293101485918, 1.326294399696039461,
    1.3260401886275903216, 1.3257834975500657482, 1.3255243279226420761,
    1.3252626812183925242, 1.3249985589242738726, 1.324731962541110919,
    1.3244628935835844885, 1.3241913535802156687, 1.3239173440733511544,
    1.323640866619149481, 1.3233619227875657032, 1.3230805141623369625,
    1.322796642340967388, 1.3225103089347123309, 1.3222215155685643762,
    1.321930263881236689, 1.3216365555251483599, 1.3213403921664086393,
    1.3210417754848007288, 1.3207407071737666815, 1.3204371889403903051,
    1.3201312225053822846, 1.3198228096030635292, 1.3195119519813474085,
    1.3191986514017257637, 1.318882909639250034, 1.3185647284825157133,
    1.3182441097336452529, 1.3179210552082702979, 1.3175955667355165879,
    1.3172676461579833074, 1.3169372953317295405, 1.3166045161262538432,
    1.3162693104244778119, 1.3159316801227285421, 1.3155916271307201981,
    1.3152491533715364724, 1.3149042607816112671, 1.3145569513107127069,
    1.314207226921922711, 1.3138550895916192296, 1.3135005413094575921,
    1.3131435840783520774, 1.3127842199144570401, 1.3124224508471469264,
    1.3120582789189985107, 1.3116917061857709115, 1.3113227347163864955,
    1.310951366592911338, 1.3105776039105359043, 1.3102014487775544005,
    1.309822903315346343, 1.3094419696583561308, 1.3090586499540721732,
    1.308672946363007572, 1.3082848610586794713, 1.3078943962275895174,
    1.3075015540692014326, 1.3071063367959221413, 1.3067087466330808976,
    1.3063087858189070811, 1.3059064566045099909, 1.3055017612538584171,
    1.3050947020437582147, 1.3046852812638316532, 1.3042735012164961006,
    1.3038593642169413744, 1.3034428725931095361, 1.30302402868567202,
    1.3026028348480083174, 1.302179293446183328, 1.3017534068589255991,
    1.3013251774776051217, 1.3008946077062113478, 1.3004616999613292094,
    1.3000264566721184689, 1.2995888802802890716, 1.2991489732400802737,
    1.2987067380182362175, 1.2982621770939835049, 1.2978152929590078823,
    1.2973660881174311488, 1.2969145650857873964, 1.2964607263929996961,
    1.296004574580357005, 1.2955461122014899633, 1.2950853418223464697,
    1.2946222660211690325, 1.2941568873884699009, 1.2936892085270073061,
    1.2932192320517603701, 1.2927469605899062355, 1.2922723967807940859,
    1.2917955432759216094, 1.2913164027389096855, 1.2908349778454779599,
    1.290351271283419976, 1.2898652857525776394, 1.289377023964816793,
    1.2888864886440016821, 1.2883936825259691972, 1.2878986083585046707,
    1.2874012689013152322, 1.2869016669260040509, 1.2863998052160459107,
    1.285895686566759899, 1.2853893137852843154, 1.2848806896905504704,
    1.2843698171132564845, 1.2838566988958408643, 1.2833413378924567461,
    1.2828237369689443614, 1.2823038990028057249, 1.2817818268831771,
    1.2812575235108025762, 1.2807309917980074232, 1.2802022346686707799,
    1.2796712550581985646, 1.2791380559134966077, 1.2786026401929431184,
    1.2780650108663622611, 1.2775251709149948454, 1.2769831233314727914,
    1.2764388711197900417, 1.2758924172952754716, 1.2753437648845653563,
    1.2747929169255749482, 1.2742398764674700562, 1.2736846465706397336,
    1.2731272303066683005, 1.2725676307583053681, 1.2720058510194398593,
    1.2714418941950691444, 1.2708757634012721738, 1.2703074617651799461,
    1.2697369924249468642, 1.269164358529722092, 1.2685895632396206878,
    1.2680126097256936291, 1.2674335011698998343, 1.2668522407650768535,
    1.2662688317149102257, 1.2656832772339059456, 1.2650955805473589333,
    1.2645057448913257225, 1.2639137735125927087, 1.2633196696686477267,
    1.2627234366276491873, 1.2621250776683974326, 1.2615245960803032066,
    1.2609219951633585666, 1.2603172782281066855, 1.2597104485956107656,
    1.2591015095974245064, 1.2584904645755607966, 1.257877316882462404,
    1.2572620698809697792, 1.2566447269442917456, 1.256025291455974191,
    1.2554037668098680935, 1.2547801564101010996, 1.2541544636710437732,
    1.2535266920172800642, 1.2528968448835753335, 1.2522649257148461555,
    1.2516309379661270107, 1.2509948851025411987, 1.2503567705992673087,
    1.2497165979415085779, 1.2490743706244609168, 1.2484300921532816009,
    1.2477837660430566302, 1.247135395818769199, 1.2464849850152681654,
    1.2458325371772349666, 1.2451780558591518666, 1.2445215446252704261,
    1.2438630070495784175, 1.2432024467157669623, 1.2425398672171994452,
    1.2418752721568779851, 1.2412086651474107946, 1.2405400498109799834,
    1.239869429779308696, 1.2391968086936280269, 1.2385221902046437137,
    1.237845577972504385, 1.2371669756667671436, 1.2364863869663658136,
    1.2358038155595763019, 1.2351192651439841796, 1.2344327394264511533,
    1.233744242123081758, 1.233053776959190051, 1.2323613476692651947,
    1.231666957996938816, 1.2309706116949510335, 1.2302723125251162628,
    1.2295720642582901316, 1.228869870674335063, 1.2281657355620863026,
    1.2274596627193181675, 1.2267516559527098519, 1.2260417190778114538,
    1.2253298559190091144, 1.224616070309491267, 1.2239003660912148863,
    1.2231827471148695174, 1.222463217239844413, 1.221741780334192562,
    1.2210184402745973831, 1.2202932009463371976, 1.2195660662432508126,
    1.2188370400677026595, 1.2181061263305483777, 1.2173733289510990652,
    1.2166386518570870834, 1.2159020989846303085, 1.2151636742781981582,
    1.2144233816905753987, 1.2136812251828270615, 1.2129372087242640266,
    1.2121913362924066071, 1.2114436118729499103, 1.2106940394597285326,
    1.2099426230546799221, 1.2091893666678104058, 1.2084342743171585521,
    1.2076773500287600882, 1.2069185978366112622, 1.2061580217826350925,
    1.2053956259166425102, 1.2046314142962994964, 1.2038653909870897785,
    1.2030975600622781929, 1.2023279256028764905, 1.2015564916976055887,
    1.2007832624428600443, 1.2000082419426727487, 1.1992314343086767359,
    1.1984528436600712098, 1.1976724741235833527, 1.1968903298334330199,
    1.1961064149312961025, 1.1953207335662681121, 1.1945332898948270994,
    1.1937440880807981269, 1.1929531322953157435, 1.1921604267167877911,
    1.1913659755308589894, 1.1905697829303731883, 1.1897718531153380628,
    1.1889721902928864772, 1.1881707986772420682, 1.187367682489679499,
    1.1865628459584895982, 1.1857562933189420562, 1.1849480288132470118,
    1.1841380566905197469, 1.1833263812067427168, 1.1825130066247286909,
    1.1816979372140827831, 1.1808811772511662586, 1.1800627310190585639,
    1.1792426028075206901, 1.1784207969129567584, 1.1775973176383782715,
    1.1767721692933645894, 1.1759453561940269584, 1.1751168826629712072,
    1.1742867530292588896, 1.1734549716283706466, 1.1726215428021691256,
    1.1717864708988594558, 1.1709497602729537213, 1.1701114152852321038,
    1.169271440302705356, 1.1684298396985768331, 1.1675866178522049665,
    1.1667417791490657386, 1.1658953279807142689, 1.1650472687447466225,
    1.1641976058447631726, 1.1633463436903292987, 1.1624934866969383052,
    1.1616390392859725633, 1.1607830058846668742, 1.1599253909260682782,
    1.1590661988490005285, 1.1582054340980234564, 1.157343101123396778,
    1.1564792043810410149, 1.15561374833249908, 1.154746737444898752,
    1.1538781761909135959, 1.153008069048726103, 1.1521364205019875016,
    1.1512632350397808967, 1.150388517156582191, 1.1495122713522223368,
    1.1486345021318482562, 1.1477552140058846497, 1.1468744114899962483,
    1.1459920991050476236, 1.1451082813770674385, 1.1442229628372073691,
    1.1433361480217045791, 1.1424478414718439723, 1.1415580477339180021,
    1.1406667713591895907, 1.1397740169038530489, 1.1388797889289952181,
    1.137984092000556835, 1.1370869306892947836, 1.1361883095707416835,
    1.1352882332251694741, 1.1343867062375490029, 1.1334837331975118335,
    1.1325793186993118322, 1.131673467341786532, 1.1307661837283176087,
    1.1298574724667926894, 1.1289473381695669385, 1.1280357854534237561,
    1.1271228189395359198, 1.1262084432534276157, 1.1252926630249342477,
    1.1243754828881651342, 1.1234569074814639844, 1.1225369414473693741,
    1.1216155894325774423, 1.120692856087901923, 1.1197687460682355098,
    1.118843264032511442, 1.1179164146436639804, 1.116988202568589994,
    1.116058632478110102, 1.1151277090469291497, 1.1141954369535986835,
    1.113261820880476316, 1.112326865513688201, 1.1113905755430899536,
    1.1104529556622266817, 1.1095140105682954612, 1.1085737449621055895,
    1.1076321635480403938, 1.1066892710340168193, 1.1057450721314490139,
    1.1047995715552065832, 1.103852774023578398, 1.1029046842582308496,
    1.1019553069841718784, 1.10100464692971034, 1.100052708826416481,
    1.09909949740908508, 1.0981450174156952571, 1.0971892735873713942,
    1.0962322706683447215, 1.0952740134059149035, 1.0943145065504096269,
    1.0933537548551477414, 1.0923917630763986253, 1.0914285359733446601,
    1.0904640783080410404, 1.0894983948453782485, 1.0885314903530423081,
    1.0875633696014763707, 1.0865940373638418581, 1.0856234984159796042,
    1.0846517575363703312, 1.0836788195060977902, 1.082704689108807683,
    1.0817293711306699144, 1.0807528703603406228, 1.0797751915889217678,
    1.0787963396099238267, 1.0778163192192262709, 1.0768351352150387079,
    1.0758527923978631335, 1.0748692955704539642, 1.0738846495377805113,
    1.072898859106987679, 1.0719119290873573291, 1.0709238642902698668,
    1.069934669529165383, 1.0689443496195052408, 1.0679529093787334393,
    1.0669603536262382004, 1.0659666871833131108, 1.0649719148731182639,
    1.0639760415206429567, 1.0629790719526659437, 1.0619810109977174672,
    1.0609818634860408437, 1.059981634249554272, 1.0589803281218110875,
    1.0579779499379633467, 1.0569745045347223034, 1.0559699967503197726,
    1.0549644314244703835, 1.0539578133983329433, 1.0529501475144729117,
    1.051941438616822877, 1.0509316915506450307, 1.0499209111624931978,
    1.0489091023001739789, 1.0478962698127090025, 1.0468824185502967339,
    1.0458675533642742828, 1.04485167910707899, 1.0438348006322113459,
    1.0428169227941956887, 1.0417980504485433446, 1.0407781884517131044,
    1.0397573416610754737, 1.0387355149348727057, 1.0377127131321819409,
    1.036688941112877016, 1.0356642037375907162, 1.0346385058676770274,
    1.0336118523651731671, 1.0325842480927620581, 1.0315556979137341376,
    1.0305262066919504971, 1.0294957792918044692, 1.028464420578184102,
    1.0274321354164352993, 1.0263989286723229633, 1.0253648052119950229,
    1.0243297699019431324, 1.0232938276089671437, 1.0222569832001360268,
    1.0212192415427514547, 1.0201806075043107214, 1.0191410859524683286,
    1.0181006817549989041, 1.0170593997797614527, 1.0160172448946600543,
    1.0149742219676078925, 1.0139303358664903953, 1.0128855914591272658,
    1.0118399936132358441, 1.0107935471963940266, 1.0097462570760034062,
    1.0086981281192521909, 1.0076491651930787885, 1.0065993731641342812,
    1.005548756898745566, 1.0044973212628791615, 1.0034450711221047925,
    1.0023920113415569766, 1.0013381467859006069, 1.0002834823192929825,
    0.9992280228053469493, 0.99817177310709592764, 0.99711473808695583188,
    0.99605692260668954319, 0.99499833152737049424, 0.99393896970934558777,
    0.99287884201220033553, 0.99181795329472077771, 0.99075630841485895495,
    0.98969391222969571587, 0.98863076959540507893, 0.98756688536721781713,
    0.98650226439938615286, 0.98543691154514656549, 0.98437083165668548546,
    0.98330402958510221278, 0.98223651018037294591, 0.98116827829131647576,
    0.98009933876555677124, 0.97902969644948845129, 0.97795935618824092472,
    0.97688832282564197484, 0.97581660120418367566, 0.97474419616498619856,
    0.97367111254776184115, 0.97259735519078083232, 0.97152292893083513903,
    0.97044783860320371627, 0.96937208904161697998, 0.96829568507822172396,
    0.96721863154354625891, 0.96614093326646521831, 0.96506259507416436438,
    0.9639836217921062822, 0.96290401824399463049, 0.96182378925174016882,
    0.96074293963542511943, 0.95966147421326997158, 0.95857939780159662213,
    0.95749671521479573499, 0.95641343126529154706, 0.95532955076350678514,
    0.95424507851782913725, 0.95316001933457650264, 0.95207437801796279686,
    0.95098815937006353494, 0.94990136819078163644, 0.94881400927781389676,
    0.94772608742661612613, 0.94663760743036939882, 0.94554857407994619134,
    0.94445899216387696473, 0.94336886646831541459, 0.9422782017770053864,
    0.94118700287124701376, 0.94009527452986274554, 0.93900302152916481635,
    0.9379102486429201635, 0.93681696064231845256, 0.93572316229593777148,
    0.93462885836971187903, 0.93353405362689634295, 0.93243875282803589943,
    0.93134296073093114643, 0.93024668209060568103, 0.92914992165927245971,
    0.92805268418630160188, 0.9269549744181871942, 0.92585679709851465002,
    0.92475815696792751375, 0.92365905876409559738, 0.92255950722168167388,
    0.9214595070723093917, 0.92035906304453041216, 0.91925817986379254609,
    0.91815686225240666918, 0.91705511492951552466, 0.91595294261106052769,
    0.91485035000975034603, 0.91374734183502825946, 0.91264392279304074052,
    0.91154009758660525797, 0.91043587091517830245, 0.90933124747482407813,
    0.90822623195818230624, 0.90712082905443680581, 0.90601504344928418533,
    0.90490887982490186836, 0.90380234285991722931, 0.90269543722937561903,
    0.9015881676047096116, 0.90048053865370769611, 0.89937255504048296828,
    0.89826422142544248839, 0.89715554246525575088, 0.89604652281282426429,
    0.89493716711725035395, 0.89382748002380663088, 0.89271746617390546064,
    0.89160713020506821014, 0.89049647675089405041, 0.88938551044103086873,
    0.88827423590114396035, 0.88716265775288594142, 0.88605078061386610688,
    0.88493860909762123157, 0.88382614781358470601, 0.8827134013670568935,
    0.881600374359175043, 0.88048707138688342422, 0.8793734970429037956,
    0.87825965591570531732, 0.87714555258947590755, 0.87603119164409104513,
    0.8749165776550861251, 0.8738017151936255944, 0.87268660882647464128,
    0.87157126311596988533, 0.87045568261998951254, 0.86933987189192496459,
    0.86822383548065196202, 0.86710757793050063924, 0.86599110378122845511,
    0.86487441756798955073, 0.86375752382130777107, 0.86264042706704691099,
    0.86152313182638240452, 0.86040564261577379135, 0.85928796394693529592,
    0.8581701003268082939, 0.85705205625753289045, 0.85593383623641960956,
    0.85481544475592174948, 0.85369688630360773818, 0.85257816536213226755,
    0.85145928640920953701, 0.85034025391758538692, 0.84922107235500943201,
    0.84810174618420774983, 0.84698227986285512525, 0.84586267784354873811,
    0.84474294457377929746, 0.84362308449590572845, 0.84250310204712619555,
    0.84138300165945301146, 0.84026278775968399337, 0.83914246476937703889,
    0.83802203710482237042, 0.83690150917701655597, 0.83578088539163575277,
    0.8346601701490090619, 0.83353936784409232708, 0.83241848286644148924,
    0.83129751960018694046, 0.83017648242400732261, 0.82905537571110277106,
    0.8279342038291693795, 0.82681297114037421991, 0.8256916820013278091,
    0.82457034076305968373, 0.82344895177099297623, 0.82232751936491754741,
    0.8212060478789658946, 0.82008454164158739452, 0.81896300497552265707,
    0.81784144219777887841, 0.8167198576196046389, 0.81559825554646436796,
    0.81447664027801469633, 0.81335501610807836581, 0.81223338732462013745,
    0.81111175820972236661, 0.80999013303955957888, 0.8088685160843752664,
    0.80774691160845646376, 0.80662532387010998924, 0.80550375712163846398,
    0.80438221560931533194, 0.80326070357336232242, 0.80213922524792402591,
    0.80101778486104513455, 0.7998963866346460172, 0.79877503478450007091,
    0.79765373352020896291, 0.79653248704517998213, 0.79541129955660261341,
    0.79429017524542500084, 0.79316911829633085507, 0.7920481328877168048,
    0.790927223191668749, 0.78980639337393931942, 0.788685647593925232,
    0.78756499000464419424, 0.78644442475271247872, 0.78532395597832271861,
    0.78420358781522103708, 0.78308332439068462083, 0.78196316982550018171,
    0.78084312823394097514, 0.77972320372374559483, 0.77860340039609488016,
    0.77748372234559137706, 0.77636417366023646736, 0.77524475842140960768,
    0.77412548070384590293, 0.77300634457561523405, 0.7718873540981004977,
    0.77076851332597651201, 0.76964982630718870027, 0.76853129708293244082,
    0.76741292968763086257, 0.76629472814891563814, 0.76517669648760466838,
    0.76405883871768187632, 0.7629411588462771121, 0.76182366087364472573,
    0.76070634879314369403, 0.75958922659121719256, 0.75847229824737194548,
    0.75735556773415901866, 0.75623903901715250342, 0.75512271605493064275,
    0.75400660279905529215, 0.75289070319405249077, 0.75177502117739258836,
    0.75065956067947081642, 0.74954432562358797032, 0.74842931992593042523,
    0.7473145474955513734, 0.7462000122343516173, 0.74508571803706036274,
    0.74397166879121578997, 0.7428578683771470681, 0.74174432066795514817,
    0.74063102952949344537, 0.73951799882035007538, 0.73840523239182898063,
    0.73729273408793150058, 0.73618050774533838609, 0.73506855719339081467,
    0.73395688625407318195, 0.73284549874199467201, 0.73173439846437082767,
    0.73062358922100656411, 0.72951307480427829422, 0.72840285899911560996,
    0.727292945582984518, 0.72618333832586945409, 0.72507404099025651867,
    0.72396505733111582437, 0.72285639109588395446, 0.72174804602444797563,
    0.72064002584912778548, 0.71953233429465912607, 0.71842497507817726365,
    0.71731795190919989125, 0.71621126848961158551, 0.71510492851364559908,
    0.71399893566786920562, 0.71289329363116649141, 0.71178800607472247908,
    0.71068307666200658534, 0.70957850904875796605, 0.70847430688296797463,
    0.70737047380486561821, 0.70626701344690123729, 0.70516392943373129576,
    0.70406122538220261564, 0.70295890490133727813, 0.7018569715923169694,
    0.70075542904846865877, 0.69965428085524794533, 0.69855353059022584628,
    0.69745318182307269872, 0.69635323811554428186, 0.69525370302146571877,
    0.69415458008671870882, 0.69305587284922576252, 0.69195758483893587965,
    0.69085971957781144859, 0.68976228057981214814, 0.68866527135088240197,
    0.68756869538893705673, 0.6864725561838469492, 0.68537685721742536149,
    0.68428160196341469845, 0.68318679388747272085, 0.68209243644715844557,
    0.68099853309191948902, 0.67990508726307885556, 0.67881210239382061555,
    0.67771958190917835907, 0.676627529226020763, 0.67553594775303971165,
    0.67444484089073719613, 0.6733542120314117696, 0.67226406455914766713,
    0.67117440184980059481, 0.67008522727098618343, 0.66899654418206788709,
    0.66790835593414366045, 0.66682066587003518965, 0.66573347732427490264,
    0.66464679362309453392, 0.6635606180844131341, 0.6624749540178255236,
    0.66138980472459030224, 0.66030517349761830292, 0.65922106362146215552,
    0.65813747837230340831, 0.65705442101794253595, 0.65597189481778728215,
    0.6548899030228414464, 0.65380844887569466994, 0.65272753561051055637,
    0.6516471664530170127, 0.65056734462049481404, 0.64948807332176716756,
    0.64840935575719005346, 0.6473311951186404567, 0.64625359458950759617,
    0.64517655734468171147, 0.64410008655054451499, 0.64302418536495897783,
    0.64194885693725989295, 0.64087410440824343905, 0.63979993091015829876,
    0.63872633956669533362, 0.63765333349297881327, 0.63658091579555642348,
    0.6355090895723902733, 0.63443785791284801334, 0.63336722389769328778,
    0.63229719059907674161, 0.63122776108052780497, 0.63015893839694481215,
    0.62909072559458734109, 0.62802312571106733152, 0.62695614177533987021,
    0.62588977680769597445, 0.62482403381975348822, 0.6237589158144489776,
    0.62269442578602984817, 0.62163056672004612935, 0.62056734159334281387,
    0.61950475337405164211, 0.61844280502158377466, 0.61738149948662190969,
    0.61632083971111295551, 0.61526082862826014797, 0.61420146916251650016,
    0.61314276422957691981, 0.61208471673637099286, 0.61102732958105654415,
    0.60997060565301219892, 0.60891454783283049945, 0.6078591589923116878,
    0.60680444199445615627, 0.6057503996934586743, 0.60469703493470150502,
    0.60364435055474807701, 0.60259234938133687809, 0.60154103423337490497,
    0.60049040792093189012, 0.59944047324523419551, 0.59839123299865903949,
    0.59734268996472839053, 0.59629484691810319408, 0.59524770662457837656,
    0.5942012718410766281, 0.59315554531564340657, 0.5921105297874412754,
    0.59106622798674479657, 0.59002264263493553464, 0.58897977644449672763,
    0.58793763211900851307, 0.58689621235314293202, 0.58585551983265926612,
    0.58481555723439926364, 0.58377632722628258755, 0.58273783246730226359,
    0.58170007560752035047, 0.5806630592880634989, 0.57962678614111906583,
    0.57859125878993056258, 0.57755647984879376899, 0.57652245192305295873,
    0.5754891776090966804, 0.57445665949435475994, 0.57342490015729341568,
    0.57239390216741292683, 0.57136366808524330363, 0.57033420046234140077,
    0.56930550184128736468, 0.56827757475568119183, 0.56725042173014028624,
    0.56622404528029601778, 0.56519844791279050256, 0.56417363212527449345,
    0.56314960040640382744, 0.56212635523583742714, 0.56110389908423452532,
    0.56008223441325155623, 0.55906136367554104538, 0.55804128931474816788,
    0.55702201376550897205, 0.55600353945344849205, 0.55498586879517808335,
    0.5539690041982943125, 0.55295294806137640364, 0.55193770277398468416,
    0.55092327071665925242, 0.54990965426091786838, 0.54889685576925462129,
    0.5478848775951389305, 0.54687372208301365806, 0.54586339156829422059,
    0.544853888377367368, 0.54384521482758985123, 0.54283737322728808916,
    0.54183036587575672538, 0.54082419506325818404, 0.53981886307102155964,
    0.53881437217124250605, 0.53781072462708245929, 0.53680792269266808248,
    0.53580596861309104373, 0.53480486462440779416, 0.53380461295363956786,
    0.53280521581877160475, 0.53180667542875392773, 0.53080899398350089857,
    0.52981217367389177308, 0.52881621668177081208, 0.52782112517994717038,
    0.52682690133219600703, 0.52583354729325870736, 0.52484106520884343805,
    0.52384945721562570231, 0.52285872544124956107, 0.52186887200432785505,
    0.52087989901444353702, 0.51989180857215078202, 0.51890460276897576453,
    0.51791828368741787969, 0.51693285340095129765, 0.51594831397402607376,
    0.51496466746206959186, 0.51398191591148822965, 0.51300006135966880194,
    0.512019105834980226, 0.51103905135677563099, 0.51005989993539357918,
    0.5090816535721605085, 0.50810431425939284189, 0.50712788398039843063,
    0.50615236470947944092, 0.50517775841193413022, 0.50420406704405951182,
    0.5032312925531534642, 0.50225943687751750666, 0.50128850194645935279,
    0.50031848968029535296, 0.49934940199035349195, 0.49838124077897583142,
    0.49741400793952222914, 0.49644770535637222642, 0.49548233490492904485,
    0.49451789845162213988, 0.49355439785391075347
};
    
    
