/* Rttstavningsprogrammet Stava. Version 1.8 1997-06-25
   Copyright (C) 1990-1997 Joachim Hollman och Viggo Kann


   Spridningslicens fr rttstavningsprogrammet STAVA
   ==================================================
 
Vi ser grna att Stavaprogrammet sprids ickekommersiellt.  
Drfr tillter vi anvndning och kopiering av hela eller 
delar av Stavaprogrammet fr ickekommersiellt bruk.
 
Den som vill anvnda programmet eller delar av koden i ett
kommersiellt sammanhang mste frst kontakta ngon av oss
s vi kan komma verens om ett avtal.

Stavas konstruktrer:

Docent Viggo Kann  viggo@nada.kth.se
Nada, KTH
100 44 Stockholm
 
Tekn. Dr. Joachim Hollman joachim@nada.kth.se
*/

/* #define ENGELSKA */ /* Engelsk stavningskontroll */
#ifndef ENGELSKA
#define SVENSKA /* Svensk stavningskontroll */
#define VERSION "Stava version 1.8"
#else
#define VERSION "Spell version 1.8"
#endif
#define RATTSTAVA /* Vljaren -r som ger rttstavningsfrslag kan anvndas */
/* #define ISO8BITAR */
/* Definiera ISO8BITAR om ttabitstecken ISO8859-1 ska anvndas som
   standard, dvs utan att -8 behver ges. -7 ger d sjubitstecken.
   I infilerna kan alltid bde 7- och 8-bitsbokstver anvndas. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "suffix.h"

#ifdef __GNUC__
#define INLINE inline
#define VOLATILE volatile
#else
#define INLINE
#define VOLATILE
#endif

#ifdef SVENSKA
#include "stava.h"
#endif
#ifdef ENGELSKA
#define ISO8BITAR
#include "spell.h"
#endif
#define liten(t)       (97<=t && t<=125)
#define stor(t)        (65<=t && t<=93)
#define Liten(t)       (t+32) /* Krver att t r en stor bokstav */
#define Stor(t)        (t-32) /* Krver att t r en liten bokstav */

#define KOLLAORD(o) { if (ILexikon(o)) return 1; else\
                      if (Finns2(o)) return 1; }
#define KOLLAORDPETIG(o) { if (ILexikon(o)) return 1; else\
                           if (Finns2Petig(o,0)) return 1; }

static unsigned char tabell[STORLEK];
static char lexfNamn[100], ordfNamn[100], xlexfNamn[100], utlexfNamn[100];
static FILE *lexf, *ordf, *xlexf;
static long pow2[PTAL][LANGD];   /* NP, NW */
static int filter = 0;
static int bindestreck;
static int xLasOrdlista = 1, xInforOrdlista = 0;
static int xAndelser = 0, xForkortningar = 0, xNamn = 0, xDatatermer = 0;
static int xTex = 0, xHtml = 0;
static int xSammansatta = 0, xKort = 0, xEndastEtt = 0, xSkrivLexikon = 0;
static int xIntePetig = 1;
static int laserOrdlista = 0, inforOrdlista = 0;
#ifdef ENGELSKA
static int angettTeckenkod = 1; /* Talar om ifall teckenkod explicit angetts */
#else
static int angettTeckenkod = 0; /* Talar om ifall teckenkod explicit angetts */
#endif
#ifdef ISO8BITAR
static int x8bitar = ISOCODE;
#else
static int x8bitar = 0;
#endif
static char **infiler = NULL;   /* vektor med pekare till infilnamn */
static int antalInfiler = 0;    /* sista anvnda texten i infiler */
static int fleraInfiler = 0;    /* sant om antalInfiler > 1 */
static int aktuelltFilnr = 0;   /* vilken av filerna som stavningskollas fn */
static char **ordlistor = NULL; /* vektor med pekare till ordlistenamn */
static int antalOrdlistor = 0;  /* sista anvnda texten i ordlistor */
static char **enstakaOrd = NULL; /* vektor med pekare till ord som ska rttstavas */
static int antalEnstakaOrd = 0;  /* antal anvnda ord i enstakaOrd */
static char *bokstavsTabell;    /* versttning kod -> intern */
static char *tillISOTabell;     /* versttning kod -> ISO Latin-1 */

static INLINE int Finns(unsigned char *ord);
#ifndef ENGELSKA
static int Finns2(unsigned char *ord);
static int Finns2Petig(unsigned char *ord, int fyrKoll);
#endif

static char ISO_ASCII[256] = {
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O',
'P','Q','R','S','T','U','V','W','X','Y','Z',0,0,0,0,0,
0,'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o',
'p','q','r','s','t','u','v','w','x','y','z',0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
'A','A','A','A','[',']','[','C','E','E','E','E','I','I','I','I',
'D','N','O','O','O','O','\\',0,'\\','U','U','U','Y','Y',0,0,
'a','a','a','a','{','}','{','c','e','e','e','e','i','i','i','i',
'd','n','o','o','o','o','|',0,'|','u','u','u','y','y',0,'y'};

static char MAC_ASCII[256] = {
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O',
'P','Q','R','S','T','U','V','W','X','Y','Z',0,0,0,0,0,
0,'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o',
'p','q','r','s','t','u','v','w','x','y','z',0,0,0,0,0,
'[',']',0,0,0,'\\',0,0,0,0,'{',0,'}',0,0,0,0,0,0,0,0,0,0,0,0,0,'|',0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

static char DOS_ASCII[256] = {
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O',
'P','Q','R','S','T','U','V','W','X','Y','Z',0,0,0,0,0,
0,'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o',
'p','q','r','s','t','u','v','w','x','y','z',0,0,0,0,0,
0,0,0,0,'{',0,'}',0,0,0,0,0,0,0,'[',']',0,0,0,0,'|',0,0,0,0,'\\',0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

static unsigned char ASCII_ISO[128] = {
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O',
'P','Q','R','S','T','U','V','W','X','Y','Z',
0xc4 /*  (AE) */, 0xd6 /*  (OE) */, 0xc5 /*  (AA) */, 0,0,
0,'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o',
'p','q','r','s','t','u','v','w','x','y','z',
0xe4 /*  (ae) */, 0xf6 /*  (oe) */, 0xe5 /*  (aa) */, 0,0};

static char MAC_ISO[256] = {
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O',
'P','Q','R','S','T','U','V','W','X','Y','Z',0,0,0,0,0,
0,'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o',
'p','q','r','s','t','u','v','w','x','y','z',0,0,0,0,0,
'','',0,0,0,'',0,0,0,0,'',0,'',0,0,0,0,0,0,0,0,0,0,0,0,0,'',0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

static char DOS_ISO[256] = {
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O',
'P','Q','R','S','T','U','V','W','X','Y','Z',0,0,0,0,0,
0,'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o',
'p','q','r','s','t','u','v','w','x','y','z',0,0,0,0,0,
0,0,0,0,'',0,'',0,0,0,0,0,0,0,'','',0,0,0,0,'',0,0,0,0,'',0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

static char ISO_ISO[256] = {
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

static char ASCII_ASCII[256] = {
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O',
'P','Q','R','S','T','U','V','W','X','Y','Z','[','\\',']',0,0,
0,'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o',
'p','q','r','s','t','u','v','w','x','y','z','{','|','}',0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

static char dubbelBokstavsTabell[256] = {
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,'-',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O',
'P','Q','R','S','T','U','V','W','X','Y','Z','[','\\',']',0,0,
0,'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o',
'p','q','r','s','t','u','v','w','x','y','z','{','|','}',0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
'A','A','A','A','[',']','[','C','E','E','E','E','I','I','I','I',
'D','N','O','O','O','O','\\',0,'\\','U','U','U','Y','Y',0,0,
'a','a','a','a','{','}','{','c','e','e','e','e','i','i','i','i',
'd','n','o','o','o','o','|',0,'|','u','u','u','y','y',0,'y'};

#ifdef SVENSKA
static char bindebokstav[128] = {
/* 's' str fr bokstver som i sammansttningar kan f s efter sig */
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,' ','s','s','s',' ','s','s','s',' ','s','s','s','s','s',' ',
's','s','s',' ','s',' ','s','s',' ',' ',' ',' ',' ',' ',0,0,
0,' ','s','s','s',' ','s','s','s',' ','s','s','s','s','s',' ',
's','s','s',' ','s',' ','s','s',' ',' ',' ',' ',' ',' ',0,0};
#endif /* SVENSKA */

struct EntityTable {
  char *entity;
  unsigned char letter;
};
#define NOOFENTITIES 62
/* latin1Entities verstter HTML-&-namn till bokstver */
static struct EntityTable latin1Entities[NOOFENTITIES] = {
{"AElig", ''}, /* capital AE diphthong (ligature) */
{"Aacute", ''}, /* capital A, acute accent */
{"Acirc", ''}, /* capital A, circumflex accent */
{"Agrave", ''}, /* capital A, grave accent */
{"Aring", ''}, /* capital A, ring */
{"Atilde", ''}, /* capital A, tilde */
{"Auml", ''}, /* capital A, dieresis or umlaut mark */
{"Ccedil", ''}, /* capital C, cedilla */
{"ETH", ''}, /* capital Eth, Icelandic */
{"Eacute", ''}, /* capital E, acute accent */
{"Ecirc", ''}, /* capital E, circumflex accent */
{"Egrave", ''}, /* capital E, grave accent */
{"Euml", ''}, /* capital E, dieresis or umlaut mark */
{"Iacute", ''}, /* capital I, acute accent */
{"Icirc", ''}, /* capital I, circumflex accent */
{"Igrave", ''}, /* capital I, grave accent */
{"Iuml", ''}, /* capital I, dieresis or umlaut mark */
{"Ntilde", ''}, /* capital N, tilde */
{"Oacute", ''}, /* capital O, acute accent */
{"Ocirc", ''}, /* capital O, circumflex accent */
{"Ograve", ''}, /* capital O, grave accent */
{"Oslash", ''}, /* capital O, slash */
{"Otilde", ''}, /* capital O, tilde */
{"Ouml", ''}, /* capital O, dieresis or umlaut mark */
{"THORN", ''}, /* capital THORN, Icelandic */
{"Uacute", ''}, /* capital U, acute accent */
{"Ucirc", ''}, /* capital U, circumflex accent */
{"Ugrave", ''}, /* capital U, grave accent */
{"Uuml", ''}, /* capital U, dieresis or umlaut mark */
{"Yacute", ''}, /* capital Y, acute accent */
{"aacute", ''}, /* small a, acute accent */
{"acirc", ''}, /* small a, circumflex accent */
{"aelig", ''}, /* small ae diphthong (ligature) */
{"agrave", ''}, /* small a, grave accent */
{"aring", ''}, /* small a, ring */
{"atilde", ''}, /* small a, tilde */
{"auml", ''}, /* small a, dieresis or umlaut mark */
{"ccedil", ''}, /* small c, cedilla */
{"eacute", ''}, /*small e, acute accent */
{"ecirc", ''}, /* small e, circumflex accent */
{"egrave", ''}, /* small e, grave accent */
{"eth", ''}, /* small eth, Icelandic */
{"euml", ''}, /* small e, dieresis or umlaut mark */
{"iacute", ''}, /* small i, acute accent */
{"icirc", ''}, /* small i, circumflex accent */
{"igrave", ''}, /* small i, grave accent */
{"iuml", ''}, /* small i, dieresis or umlaut mark */
{"ntilde", ''}, /* small n, tilde */
{"oacute", ''}, /* small o, acute accent */
{"ocirc", ''}, /* small o, circumflex accent */
{"ograve", ''}, /* small o, grave accent */
{"oslash", ''}, /* small o, slash */
{"otilde", ''}, /* small o, tilde */
{"ouml", ''}, /* small o, dieresis or umlaut mark */
{"szlig", ''}, /* small sharp s, German (sz ligature) */
{"thorn", ''}, /* small thorn, Icelandic */
{"uacute", ''}, /* small u, acute accent */
{"ucirc", ''}, /* small u, circumflex accent */
{"ugrave", ''}, /* small u, grave accent */
{"uuml", ''}, /* small u, dieresis or umlaut mark */
{"yacute", ''}, /* small y, acute accent */
{"yuml", ''} /* small y, dieresis or umlaut mark */
};

static INLINE int ILexikon(char *ord)
{ register i,j;
  register unsigned long h;

  j = 0; h = 0;
  while (ord[j] != '\0') {
    h = h + ord[j] * pow2[0][j];
    j++;
  }
  if (j >= 18) { /* om ordet r lngre n 18 tecken kan h flda ver */
    for (i = 0; i < PTAL; i++) {
      h = 0;
      for (j = 0; j < 17; j++)
        h = h + ord[j] * pow2[i][j];
      while (ord[j] != '\0') { /* Koll att j < LANGD behvs inte */
        h = (h + ord[j] * pow2[i][j]) % p[i];
	j++;
      }
      if (!(tabell[h>>3] & (1<<((int) h & 07)))) return 0;
    }
    return 1;
  }
  h = h % p[0];
  if (!(tabell[h>>3] & (1<<((int) h & 07)))) return 0;
  for (i = 1; i < PTAL; i++) {
    j = 0; h = 0;
    while (ord[j] != '\0') {
      h = h + ord[j] * pow2[i][j];
      j++;
    }
    h = h % p[i];

    if (!(tabell[h>>3] & (1<<((int) h & 07))))   {
      return 0;
    }
  }
  return 1;
}

/* LagraOrd hashar in ordet i lexikonet */
static INLINE void LagraOrd(char *ord)
{ register int i, j;
  register unsigned long h;

  j = 0; h = 0;
  while (ord[j] != '\0') {
    h = h + ord[j] * pow2[0][j];
    j++;
  }
  if (j >= 18) { /* om ordet r lngre n 18 tecken kan h flda ver */
    for (i = 0; i < PTAL; i++) {
      h = 0;
      for (j = 0; j < 17; j++)
        h = h + ord[j] * pow2[i][j];
      while (ord[j] != '\0') { /* Koll att j < LANGD behvs inte */
        h = (h + ord[j] * pow2[i][j]) % p[i];
	j++;
      }
      tabell[h>>3] |= 1<<((int) h & 07);
    }
    return;
  }
  h = h % p[0];
  tabell[h>>3] |= 1<<((int) h & 07);
  for (i = 1; i < PTAL; i++) {
    j = 0; h = 0;
    while (ord[j] != '\0') {
      h = h + ord[j] * pow2[i][j];
      j++;
    }
    h = h % p[i];
    tabell[h>>3] |= 1<<((int) h & 07);
  }
}

#ifdef RATTSTAVA
static int xRattstavningsforslag = 0;
static unsigned char fyrtabell[FYRSTORLEK];
static FILE *fyrf;
static char **fyrOrd;
static int fyrAntalOrd = 0, fyrMaxAntalOrd = 0;

/* FyrKollaHela kollar om ett ords alla fyrgrafer r tilltna */
static INLINE int FyrKollaHela(char *ord)
{ static char buf[LANGD+4];
  char *s;
  long l;
  int plats;
  sprintf(buf, "-%s-", ord);
  for (s = buf; *s; s++)
    if (*s >= 'a' && *s <= '}') *s -= 'a'; else
    if (*s >= 'A' && *s <= ']') *s -= 'A'; else
      *s = 29;
  *s = '/';
  for (plats = 3; buf[plats] != '/'; plats++) {
    l = ((buf[plats - 3] * 30L + buf[plats - 2]) * 30L + buf[plats - 1]) * 30L +
        buf[plats];
    if (!(fyrtabell[l >> 3] & (1 << ((int) l & 07)))) {
      return plats;
    }
  }
  return 0;
}

/* LagraFyrgrafer ser till att ett ords alla fyrgrafer r tilltna */
static INLINE void LagraFyrgrafer(char *ord)
{ static char buf[LANGD+4];
  char *s;
  long l;
  int plats;
  sprintf(buf, "-%s-", ord);
  for (s = buf; *s; s++)
    if (*s >= 'a' && *s <= '}') *s -= 'a'; else
    if (*s >= 'A' && *s <= ']') *s -= 'A'; else
      *s = 29;
  *s = '/';
  for (plats = 3; buf[plats] != '/'; plats++) {
    l = ((buf[plats - 3] * 30L + buf[plats - 2]) * 30L + buf[plats - 1]) * 30L +
        buf[plats];
    fyrtabell[l >> 3] |= (1 << ((int) l & 07));
  }
}

/* FyrKoll kollar om ett ords fyrgrafer r tilltna, plats anger index i
ord fr en ndring. Om plats r negativt kollas hela ordet.
extra r antalet extra positioner som r ndrade */
static int FyrKoll(char *ord, int plats, int extra)
{ char buf[LANGD+4];
  char *s;
  long l;
  sprintf(buf, "-%s-", ord);
  for (s = buf; *s; s++)
    if (*s >= 'a' && *s <= '}') *s -= 'a'; else
    if (*s >= 'A' && *s <= ']') *s -= 'A'; else
      *s = 29;
  *s = '/';
  if (plats >= 2) {
    plats++;
    buf[plats + 4 + extra] = '/';
  } else {
    if (plats >= 0) buf[plats + 5 + extra] = '/';
    plats = 3;
  }
  while (buf[plats] != '/') {
    l = ((buf[plats - 3] * 30L + buf[plats - 2]) * 30L + buf[plats - 1]) * 30L +
        buf[plats];
    if (!(fyrtabell[l >> 3] & (1 << ((int) l & 07)))) return 0;
    plats++;
  }
  return 1;
}

static void FyrAdderaOrd(char *ord)
{ int i;
  if (strlen(ord) <= 1) return; /* Strunta i enbokstavsord */
  if (fyrMaxAntalOrd == 0) {
    fyrMaxAntalOrd = 20;
    fyrOrd = (char **) malloc(sizeof(char *) * fyrMaxAntalOrd);
  } else {
    for (i = 0; i < fyrAntalOrd; i++) {
      if (!strcmp(ord, fyrOrd[i])) return;
      if (!strcmp(ord + 1, fyrOrd[i] + 1))
	if (abs(*ord - *fyrOrd[i]) == 'a' - 'A') return;
    }
    if (fyrAntalOrd >= fyrMaxAntalOrd) {
      fyrMaxAntalOrd += 20;
      fyrOrd = (char **) realloc(fyrOrd, sizeof(char *) * fyrMaxAntalOrd);
    }
  }
  fyrOrd[fyrAntalOrd] = (char *) malloc(strlen(ord)+1);
  strcpy(fyrOrd[fyrAntalOrd], ord);
  fyrAntalOrd++;
}

static void FyrSudda(void)
{ int i;
  for (i = 0; i < fyrAntalOrd; i++) free(fyrOrd[i]);
  fyrAntalOrd = 0;
}

/* S_byt byter plats p tv bokstver i taget, dr den frsta bokstaven har
   index mellan fran och till i ord */
static void S_byt(char *ord, int len, int fran, int till)
{ int i;
  char t;
  if (till >= len - 1) till = len - 2;
  if (fran < 0) fran = 0;
  for (i = fran; i <= till; i++) {
    t = ord[i]; ord[i] = ord[i+1]; ord[i+1] = t;
    if (FyrKoll(ord, i, 1)) if (ILexikon(ord)) FyrAdderaOrd(ord);
    t = ord[i]; ord[i] = ord[i+1]; ord[i+1] = t;
  }
}

/* S_in skjuter in ett nytt tecken i en position i taget mellan fran och till
   i ord */
static void S_in(char *ord, int len, int fran, int till)
{ int i;
  char t, buf[LANGD+1];
  if (till > len) till = len;
  if (fran < 0) fran = 0;
  if (fran == 0) {
    strcpy(buf + 1, ord);
    for (t = 'A'; t <= ']'; t++) {
      buf[0] = t;
      if (FyrKoll(buf, 0, 0)) if (ILexikon(buf)) FyrAdderaOrd(buf);
    }
  } else strcpy(buf, ord);
  for (i = fran; i <= till; i++) {
    strcpy(buf + i + 1, ord + i);
    for (t = 'a'; t <= '}'; t++) {
      buf[i] = t;
      if (FyrKoll(buf, i, 0)) if (ILexikon(buf)) FyrAdderaOrd(buf);
    }
    buf[i] = ord[i];
  }
}

/* S_bort tar bort ett tecken i en position i taget mellan fran och till
i ord. Drefter provas alla mjliga tecken som utbyte. */
static void S_bort(char *ord, int len, int fran, int till)
{ int i;
  char buf[LANGD];
  if (fran < 0) fran = 0;
  if (till >= len) till = len - 1;
  if (fran > 0) strncpy(buf, ord, fran);
  for (i = fran; i <= till; i++) {
    strcpy(buf + i, ord + i + 1);
    if (FyrKoll(buf, i, -1)) if (ILexikon(buf)) FyrAdderaOrd(buf);
    S_in(buf, len-1, i, i);
    buf[i] = ord[i];
  }
}

static void GenereraAlternativaOrd(char *ord)
{ int felplats, len = strlen(ord);
  int fyrresultat[LANGD+1], vanstrastefel = -1, hograstefel = -1, diff;
  char buf[LANGD+2], *s;
  long l;

  sprintf(buf, "-%s-", ord);
  for (s = buf; *s; s++)
    if (*s >= 'a' && *s <= '}') *s -= 'a'; else
    if (*s >= 'A' && *s <= ']') *s -= 'A'; else
      *s = 29;
  *s = '/';
  for (felplats = len - 2; felplats >= 0; felplats--) {
    l = ((buf[felplats] * 30L + buf[felplats + 1]) * 30L + buf[felplats + 2]) *
         30L + buf[felplats + 3];
    fyrresultat[felplats] = !(fyrtabell[l >> 3] & (1 << ((int) l & 07)));
    if (hograstefel < 0) if (fyrresultat[felplats]) hograstefel = felplats;
  }
  if (hograstefel >= 0) {
    for (felplats = 0; felplats <= hograstefel; felplats++)
      if (fyrresultat[felplats]) {
	vanstrastefel = felplats;
	break;
      }
    diff = hograstefel - vanstrastefel;
    if (diff <= 4) {
      S_byt(ord, len, hograstefel - 2, vanstrastefel + 2);
      if (diff <= 3) {
	S_bort(ord, len, hograstefel - 1, vanstrastefel + 2);
	if (diff <= 2) S_in(ord, len, hograstefel, vanstrastefel + 2);
      }
    }
  } else {
    S_byt(ord, len, 0, len - 2);
    S_bort(ord, len, 0, len - 1);
    S_in(ord, len, 0, len);
  }
}
#endif /* RATTSTAVA */

void InitieraBokstavsTabeller(void)
{ int i;
  switch (x8bitar) {
   case 0:
    bokstavsTabell = ASCII_ASCII;
    tillISOTabell = ASCII_ISO;
    if (xTex) bokstavsTabell['/'] = '/';
    break;
   case MACCODE:
    bokstavsTabell = MAC_ASCII;
    tillISOTabell = MAC_ISO;
    if (xTex) bokstavsTabell['\\'] = '/';
    break;
   case DOSCODE:
    bokstavsTabell = DOS_ASCII;
    tillISOTabell = DOS_ISO;
    if (xTex) bokstavsTabell['\\'] = '/';
    break;
   case ISOCODE:
   default:
    bokstavsTabell = ISO_ASCII;
    tillISOTabell = ISO_ISO;
    if (xTex) bokstavsTabell['\\'] = '/';
    break;
  }
  /* fyll i 0-flt med standardvrde i bokstavstabellen till ISO */
  for (i = 0; i < 256; i++)
    if (tillISOTabell[i] == 0) tillISOTabell[i] = i;
#ifdef ENGELSKA
  bokstavsTabell['\''] = '\''; /* Apostrof tillts i engelska */
  dubbelBokstavsTabell['\''] = '\'';
#endif /* ENGELSKA */
}

static INLINE void SkrivOrd(unsigned char *s)
{
  if (x8bitar) {
    while (*s) putchar(ASCII_ISO[*s++]);
  } else printf("%s", s);
}

static INLINE int SkippaRestenAvOrdet(void)
{ int t;
  while ((t = getc(ordf)) != EOF) {
    if (bokstavsTabell[t]) continue;
    if (t == '-') continue;
    if (xTex && t == '/') {
      t = getc(ordf);
      if (t == '\'' || t == '`' || t == '^' || t == '"' || t == '=' || 
	  t == '.' || t == '~') continue;
    }
    return 1;
  }
  return 0;
}

/* SkippaInledandeVariabel hoppar ver blanka, ev citattecken och ev
   variabelnamn som inleds med dollartecken */
static void SkippaInledandeVariabel(void)
{ int u;
  u = getc(ordf);
  while (u == ' ' || u == 10) u = getc(ordf);
  if (u == '"') u = getc(ordf);
  if (u == '$') {
    u = getc(ordf);
    while (u >= 'A') u = getc(ordf);
    return;
  }
  ungetc(u, ordf);
}

/* SkippaTill skippar MHTML-kommandon fram till angivet tecken */
static int SkippaTill(int c)
{ int u;
  u = getc(ordf);
  if (c == ']' && u == 't') {
    u = getc(ordf);
    if (u == 'y' &&
	(u = getc(ordf)) == 'p') {
      u = getc(ordf);
      while (u == ' ' || u == 10) u = getc(ordf);
      if (u == '"') SkippaTill('"');
      else SkippaTill(' ');
      SkippaInledandeVariabel();
      return 0;
    } else if (u == 'e' &&
	       (u = getc(ordf)) == 'x' &&
	       (u = getc(ordf)) == 't') {
      SkippaInledandeVariabel();
      return 0;
    }
  }
  while (1) {
    if (u == EOF || u == '\n') return 0;
    else if (u == '\\') getc(ordf);
    else if (u == c) return 1;
    else if (u == '[') if (SkippaTill(']') == 0) return 0;
    u = getc(ordf);
  }
}

static INLINE int CheckLatin1Entity(void)
{ char entity[LANGD+1];
  int u, i = 0;
  int lo, hi, m;
  while (1) {
    u = getc(ordf);
    if (u == EOF) return EOF;
    if (u == '\n' || u == ';' || u == ' ') break;
    if (i < LANGD) entity[i++] = u;
  }
  entity[i] = '\0';
  if (isdigit(*entity)) {
    sscanf(entity, "%d", &u);
    return u;
  }
  lo = 0; hi = NOOFENTITIES - 1;
  while (lo < hi) {
    m = (hi + lo) / 2;
    i = strcmp(latin1Entities[m].entity, entity);
    if (i == 0) return latin1Entities[m].letter;
    if (i < 0) lo = m + 1; else hi = m - 1;
  }
  if (lo == hi && strcmp(latin1Entities[lo].entity, entity) == 0)
    return latin1Entities[lo].letter;
  return 0;
}

static int TagOrd(char *s, char *urord)
{ int t, u, i, nyrad;
 start:
  do {
    i = 0;
    bindestreck = 0;
    do {
      u = getc(ordf);
      if (u == EOF) return 0;
      if (xHtml) {
	if (u == '&') {
	  u = CheckLatin1Entity();
	  if (u == EOF) return 0;
	} else
	  if (u == '<') {
	    while (1) {
	       u = getc(ordf);
	       if (u == EOF) return 0;
	       if (u == '\n' || u == '>') break;
	    }
	  } else
	    if (u == '[' && x8bitar) SkippaTill(']');
      }
    } while (!(t = bokstavsTabell[u]) || t == '-');

    while (1) {
      if (t == '-' || (xTex && t == '/')) {
	/* I Tex behandlas /- precis som bara - */
	if (t == '/') if ((u = getc(ordf)) != '-') {
	  if (u == '\'' || u == '`' || u == '^' || u == '~') {
	    if ((u = getc(ordf)) != EOF)
	      if ((t = bokstavsTabell[u])) continue;
	  }
	  ungetc(u, ordf);
	  goto ordSlut;
	}
	u = getc(ordf);
	if (u == ' ' || u == '\t' || u == '\n') {
	  nyrad = (u == '\n');
	  while (1) {
	    if ((u = getc(ordf)) == EOF) goto ordSlut;
	    if (u == '\n') nyrad = 1;
	    else if (u != ' ' && u != '\t') break;
	  }
	  if (!nyrad) {
	    ungetc(u, ordf);
	    goto ordSlut;
	  }
	}
	if (u == '&' && xHtml) {
	  u = CheckLatin1Entity();
	  if (u == EOF) goto ordSlut;
	}
	if ((t = bokstavsTabell[u])) {
	  if (t == '-' || (xTex && t == '/')) goto ordSlut;
	  if (i > 0) { 
	    s[i] = urord[i] = '-';
	    if (++i >= LANGD) {
	      if (!SkippaRestenAvOrdet()) return 0;
	      goto start;
	    }
	    bindestreck++;
	  }
	} else goto ordSlut;
      }
#ifdef ENGELSKA
      if (t == '\'') {
	int nastaTecken = getc(ordf);
	if (nastaTecken == EOF) goto ordSlut;
	if (nastaTecken == '\'') {
	  /* Vi har lst '' dvs tv apostrofer i rad */
	  if (i == 0) goto start; else goto ordSlut;
	}
	ungetc(nastaTecken, ordf);
      }
#endif /* ENGELSKA */
      s[i] = t;
      urord[i] = u;
      if (++i >= LANGD) {
	if (!SkippaRestenAvOrdet()) return 0;
	goto start;
      }
      if ((u = getc(ordf)) == EOF) break;
      if (u == '&' && xHtml) {
	u = CheckLatin1Entity();
	if (u == EOF) goto ordSlut;
      }
      if (!(t = bokstavsTabell[u])) break;
    }
    if (xHtml) {
      if (u == '<' || (u == '[' && x8bitar)) ungetc(u, ordf);
    }
   ordSlut: ;
  } while (i < ORDMIN);
  s[i] = urord[i] = '\0';
  return 1;
}

static INLINE void SuddaBindestreck(char *ordin, char *ordut)
{
  if (xSammansatta) if (ordin[1] == '-')
    ordin += 2; /* Gr om t ex c-uppgiften till uppgiften */
  while (*ordin)
    if (*ordin == '-') ordin++;
    else *ordut++ = *ordin++;
  *ordut = '\0';
}

static void Initiera(void)
{
  int i,j;
  long h;
  for (i = 0; i < PTAL; i++) {
    h = pow2[i][0] = ETT14;
    for (j = 1; j < LANGD; j++) {
      h = (h << VSHIFT)%p[i];
      pow2[i][j] = h;
    }
  }
  InitieraBokstavsTabeller();
  if (xAndelser) {
    if (InitSuf()) {
#ifdef ISO8BITAR
      fprintf(stderr, "Fel vid initiering av ndelsetabellen\n");
#else
      fprintf(stderr, "Fel vid initiering av {ndelsetabellen\n");
#endif
      exit(1);
    }
  }
}

#ifndef ENGELSKA
/* Prefix kollar om argumentet r ett tilltet frled i sammansttningar */
static INLINE int Prefix(char *ord)
{ char ord2[LANGD];
  if (strcmp(ord, "anti") == 0) return 1;
  if (strcmp(ord, "auto") == 0) return 1;
  /* Fyll p med flera prefix hr */
  if (xAndelser && Suffix2(ord,ord2)) {
    if (strlen(ord2) < ORDMIN) return 0;
    if (ILexikon(ord2) && (xIntePetig || FyrKollaHela(ord2))) return 1;
  }
  return 0;
}
#endif /* not ENGELSKA */

static INLINE int Finns(unsigned char *ord)
{
#ifdef ENGELSKA
  { char ord2[LANGD];
    if (ILexikon(ord) && (xIntePetig || FyrKollaHela(ord))) return 1;
    if (xAndelser && Suffix(ord,ord2)) {
      if (strlen(ord2) < ORDMIN) return 0;
      if (ILexikon(ord2) && (xIntePetig || FyrKollaHela(ord2))) return 1;
    }
    return 0;
  }
#else
  if (!xIntePetig) {
    int i = FyrKollaHela(ord);
    if (i > 0) {
      if (xSammansatta) return Finns2Petig(ord, i);
      if (xAndelser) {
	char ord2[LANGD];
	if (Suffix(ord,ord2)) {
	  if (strlen(ord2) < ORDMIN) return 0;
	  if (ILexikon(ord2)) return 1;
	  if (xSammansatta) if (Finns2Petig(ord2, i)) return 1;
	}
      }
      return 0;
    }
  }
  if (ILexikon(ord)) return 1;
  if (xAndelser) {
    char ord2[LANGD];
    if (Suffix(ord,ord2)) {
      if (strlen(ord2) < ORDMIN) return 0;
      if (ILexikon(ord2)) return 1;
      if (xSammansatta) if (Finns2(ord2)) return 1;
    }
  }
  if (xSammansatta) if (Finns2(ord)) return 1;
  return 0;
#endif
}

#ifndef ENGELSKA
/* Finns2 kollar om ett ord r sammansatt */
static int Finns2(unsigned char *ord)
{ char ord1[LANGD], ord2[LANGD];
  int i, j, l = strlen(ord);
  i = l / 2;
  j = l - i;
  if (i < DELORDMIN) return 0; /* Ordet mste vara minst 2*DELORDMIN */
                        /* bokstver fr att kunna vara en sammansttning */
  strncpy(ord1, ord, i);
  if (i == j) { /* jmnt antal bokstver - kolla delning i mitten */
    ord1[i] = '\0';
    if (ILexikon(ord1)) {
      /* Hr kan man kolla suffix */
      KOLLAORD(ord + i)
      if (ord[i] == 's' && i > DELORDMIN && bindebokstav[ord[i-1]] == 's')
	KOLLAORD(ord + i + 1)
    } else if (Prefix(ord1)) { KOLLAORD(ord + i) }
    i--;
    j++;
  }
  strncpy(ord2, ord, j);
  for (; i >= DELORDMIN; i--, ord2[j] = ord[j], j++) {
    ord1[i] = '\0';
    ord2[j] = '\0';
    if (ILexikon(ord1)) {
      KOLLAORD(ord + i)
      if (ord[i] == 's' && bindebokstav[ord[i-1]] == 's')
	KOLLAORD(ord + i + 1)
    } else if (Prefix(ord1)) { KOLLAORD(ord + i) }
    if (ILexikon(ord2)) {
      KOLLAORD(ord + j)
      if (ord[j] == 's' && i > DELORDMIN && bindebokstav[ord[j-1]] == 's')
	KOLLAORD(ord + j + 1)
    } else if (Prefix(ord2)) { KOLLAORD(ord + j) }
  }
  return 0;
}
  
/* Finns2Petig kollar om ett ord r sammansatt och har tilltna fyrgrafer */
static int Finns2Petig(unsigned char *ord, int fyrKoll)
{ char ord1[LANGD];
  int i, l = strlen(ord);
  if (fyrKoll > 0) i = fyrKoll; else i = FyrKollaHela(ord);
  if (i == 0) return Finns2(ord); /* Bara tilltna fyrgrafer */
  i--;
  if (i > l - DELORDMIN) i = l - DELORDMIN;
  strncpy(ord1, ord, i);
  for (; i >= DELORDMIN; i--) {
    ord1[i] = '\0';
    if (ILexikon(ord1)) {
      KOLLAORDPETIG(ord + i)
      if (ord[i] == 's' && bindebokstav[ord[i-1]] == 's')
	KOLLAORDPETIG(ord + i + 1)
    } else if (Prefix(ord1)) { KOLLAORD(ord + i) }
  }
  return 0;
}
#endif
  
static int OppnaNastaInfil(void)
{
  while (aktuelltFilnr < antalInfiler) {
    strcpy(ordfNamn, infiler[aktuelltFilnr++]);
    if (!(ordf = fopen(ordfNamn,"r"))) {
#ifdef ISO8BITAR
      fprintf(stderr,"Kan inte ppna filen %s\n", ordfNamn);
#else
      fprintf(stderr,"Kan inte |ppna filen %s\n", ordfNamn);
#endif
      continue;
    }
    if (!angettTeckenkod) { /* Gissa om 7- eller 8-bitsteckenkod anvnds */
      int i, t, gissadKod = x8bitar;
      for (i = 0; i < 1000; i++) {
	if ((t = getc(ordf)) == EOF) break;
	if (t > 127) {
	  if (DOS_ASCII[t]) gissadKod = DOSCODE;
	  else if (MAC_ASCII[t]) gissadKod = MACCODE;
	  else gissadKod = ISOCODE;
	  break;
	}
      }
      rewind(ordf);
      if (gissadKod != x8bitar) {
	x8bitar = gissadKod;
	InitieraBokstavsTabeller();
      }
    }
    return 1;
  }
  return 0;
}

static void OppnaFiler(void)
{
  if (antalInfiler == 0) {
    filter = 1;
    ordf = stdin;
    strcpy(ordfNamn, "stdio");
  } else {
    if (antalInfiler > 1) fleraInfiler = 1;
    if (!OppnaNastaInfil()) exit(1);
  }
  /* \ppna lexikonfilen: */
  if (!(lexf = fopen(lexfNamn,"r"))) {
#ifdef ISO8BITAR
    fprintf(stderr,"Kan inte ppna filen %s\n", lexfNamn);
#else
    fprintf(stderr,"Kan inte |ppna filen %s\n", lexfNamn);
#endif
    exit(1);
  }
#ifdef RATTSTAVA
  if (xRattstavningsforslag || !xIntePetig)
    if (!(fyrf = fopen(XFYRGRAFER, "r"))) {
#ifdef ISO8BITAR
      fprintf(stderr,"Kan inte ppna filen %s\n", XFYRGRAFER);
#else
      fprintf(stderr,"Kan inte |ppna filen %s\n", XFYRGRAFER);
#endif
      exit(1);
    }
#endif
}

static void OppnaUtfil(void)
{
  if (!laserOrdlista) {
    strcpy(xlexfNamn, ordfNamn);
    strcat(xlexfNamn, DOKUMENTORDLISTEEFTERNAMN);
  }
  if ((xlexf = fopen(xlexfNamn,"a"))) inforOrdlista = 1;
  else {
#ifdef ISO8BITAR
    fprintf(stderr, "Kan inte skriva p filen %s\n", xlexfNamn);
#else
    fprintf(stderr, "Kan inte skriva p} filen %s\n", xlexfNamn);
#endif
    inforOrdlista = 0;
  }
}

static void StangFiler(void)
{
  if (antalInfiler > 0) fclose(ordf);
  if (inforOrdlista) fclose(xlexf);
}

static long TagExtraOrdlista(FILE *xlexf)
{ long antal = 0;
  char *s, buf[LANGD];
  buf[LANGD - 1] = '\0';
  while (fgets(buf, LANGD - 1, xlexf)) {
    s = buf;
    while ((*s = dubbelBokstavsTabell[(unsigned char) (*s)])) s++;
    if (*buf) {
      LagraOrd(buf);
      if (xRattstavningsforslag || !xIntePetig) LagraFyrgrafer(buf);
      antal++;
    }
  }
  fclose(xlexf);
  return antal;
}

static void TagStandardOrdlista(char *namn)
{
  if ((xlexf = fopen(namn, "r"))) TagExtraOrdlista(xlexf);
}

static void TagLexikon(void)
{ int i;
  long antal = 0;
  char slask;

  if (fread(tabell, sizeof(unsigned char), STORLEK, lexf) != STORLEK
      || fread(&slask, sizeof(char), 1, lexf) == 1) {
#ifdef ISO8BITAR
    fprintf(stderr, "%s har fel format fr att vara en lexikonfil\n",lexfNamn);
#else
    fprintf(stderr, "%s har fel format f|r att vara en lexikonfil\n",lexfNamn);
#endif
    fclose(lexf);
    exit(1);
  }
  fclose(lexf);
#ifdef RATTSTAVA
  if (xRattstavningsforslag || !xIntePetig) {
    if (fread(fyrtabell, sizeof(unsigned char), FYRSTORLEK, fyrf) != 
        FYRSTORLEK || fread(&slask, sizeof(char), 1, fyrf) == 1) {
#ifdef ISO8BITAR
      fprintf(stderr, "%s har fel format fr att vara en fyrgraffil\n",
	      XFYRGRAFER);
#else
      fprintf(stderr, "%s har fel format f|r att vara en fyrgraffil\n",
	      XFYRGRAFER);
#endif
      fclose(fyrf);
      exit(1);
    }
    fclose(fyrf);
  }
#endif
  for (i = 0; i < antalOrdlistor; i++) {
    if (!(xlexf = fopen(ordlistor[i], "r")))
#ifdef ISO8BITAR
      fprintf(stderr, "Kan inte lsa ordlistan %s\n", ordlistor[i]);
#else
      fprintf(stderr, "Kan inte l{sa ordlistan %s\n", ordlistor[i]);
#endif
    else antal += TagExtraOrdlista(xlexf);
  }
  if (!xKort) { /* KLISTFIL innehller redan fljande tre ordlistor */
    if (xForkortningar) TagStandardOrdlista(XFORKORTNINGAR);
    if (xNamn) TagStandardOrdlista(XNAMN);
    if (xDatatermer) TagStandardOrdlista(XDATATERMER);
  }
  if (xTex) TagStandardOrdlista(XTEX);
}

static void TagNastaExtraOrdlista(void)
{
  strcpy(xlexfNamn, ordfNamn);
  strcat(xlexfNamn, DOKUMENTORDLISTEEFTERNAMN);
  if ((xlexf = fopen(xlexfNamn, "r"))) {
    laserOrdlista = 1;
    TagExtraOrdlista(xlexf);
  } else laserOrdlista = 0;
}

static void SkrivLexikon(void)
{
  if (!(lexf = fopen(utlexfNamn,"w"))) {
#ifdef ISO8BITAR
    fprintf(stderr,"Kan inte ppna filen %s\n", utlexfNamn);
#else
    fprintf(stderr,"Kan inte |ppna filen %s\n", utlexfNamn);
#endif
    exit(1);
  }
  fwrite(tabell, sizeof(unsigned char), STORLEK, lexf);
  fclose(lexf);
}

static INLINE void VersalerGemena(register char *ordin, register char *ord,
			    register char *Ord)
{ register int i;
  int baraGemena, baraVersaler;
  baraGemena = baraVersaler = 1;
  for (i = 0; ordin[i] != '\0'; i++) {
    if (stor(ordin[i])) {
      baraGemena = 0;
      ord[i] = Liten(ordin[i]);
    } else {
      baraVersaler = 0;
      ord[i] = ordin[i];
    }
  }
  if (baraGemena) ord[0] = Ord[0] = '\0';
  else {
    ord[i] = '\0';
    if (baraVersaler) {
      Ord[0] = ordin[0];
      strcpy(Ord + 1, ord + 1);
    } else Ord[0] = '\0';
  }
#ifdef OLD
  if (!(baraGemena || baraVersaler))
    if (!(stor(ordin[0]) && liten(ordin[1])))
      /* omvxlande versaler och gemena oregelbundet, br endast
	 accepteras exakt */
      ord[0] = Ord[0] = '\0';
#endif
}

/* EnvArg hmtar en environmentvariabel och bryter upp den i argv och argc */
static int EnvArg(char *namn, int *argc, char ***argv)
{ char *s, *start, *env, **v;
  int antal = 0, len, i;
  extern char *getenv();

  if (!(env = getenv(namn))) return -1;
  while (*env == ' ' || *env == '\t') env++;
  s = env;
  while (*s) {
    antal++;
    while (*s && *s != ' ' && *s != '\t') s++;
    while (*s == ' ' || *s == '\t') s++;
  }
  *argc = antal + 1;
  *argv = v = (char **) calloc(antal + 2, sizeof(char *));
  for (i = 1, s = env; i <= antal; i++) {
    start = s;
    len = 0;
    while (*s && *s != ' ' && *s != '\t') { len++; s++; }
    v[i] = (char *) calloc(len + 1, sizeof(char));
    strncpy(v[i], start, len);
    while (*s == ' ' || *s == '\t') s++;
  }
  return antal;
}

static char LasFilnamn(char *argumenttyp, char valjare, char *filnamn, int *i, 
		int argc, char **argv)
{
  if (*i + 1 < argc)
    if (argv[*i + 1][0] != '-') {
      strcpy(filnamn, argv[++(*i)]);
      return 0;
    }
#ifdef ISO8BITAR
  fprintf(stderr, "%s mste ges efter -%c.\n", argumenttyp, valjare);
#else
  fprintf(stderr, "%s m}ste ges efter -%c.\n", argumenttyp, valjare);
#endif
  return 1;
}

static void KollaArg(int filnamnTillatna, int argc, char **argv)
{ int i, fel = 0;
  char *s;

  if (ordlistor)
    ordlistor = (char **) realloc(ordlistor,
				  sizeof(char *) * (antalOrdlistor + argc/2));
  else ordlistor = (char **) malloc(sizeof(char *) * (argc/2));
  if (filnamnTillatna) infiler = (char **) malloc(sizeof(char *) * argc);
  enstakaOrd = malloc(sizeof(char *) * (argc / 2));
  for (i = 1; i < argc; i++) {
    s = argv[i];
    if (*s == '-') {
      s++;
      while (*s) {
	switch (*(s++)) {
	 case 'q': /* Ls inte filens ordlista */
	 case 'Q': xLasOrdlista = 0; break;

	 case 'e': /* Endast ett felmeddelande fr varje felstavat ord */
	 case 'E': xEndastEtt = 1; break;
	
	 case 'k': /* Kort lista med fel - acceptera s mycket som mjligt */
	 case 'K':
	  xKort = xEndastEtt = 1;
	  xSammansatta = xAndelser = xForkortningar = xNamn = xDatatermer = 1;
	  break;

#ifdef RATTSTAVA
	 case 'r': /* Ge rttstavningsfrslag */
	           xRattstavningsforslag = 1; break;

	 case 'p': /* Var petig, dvs kolla rimliga bokstavskombinationer */
	           xIntePetig = 0; break;
#endif
	 case 's': /* Godknn alla sammansttningar */
	           xSammansatta = 1; break;

	 case 'a': /* Godknn alla ndelser */
	           xAndelser = 1; break;

	 case 'f': /* Ls in tillggsordlistan med frkortningar */
	           xForkortningar = 1; break;

	 case 'n': /* Ls in tillggsordlistan med namn */
	           xNamn = 1; break;

	 case 'd': /* Ls in tillggsordlistan med datatermer */
	           xDatatermer = 1; break;

	 case 't': /* Ls in tillggsordlistan med TeX-termer */
	           xTex = 1; break;

	 case 'h': /* Html-mod */
	           xHtml = 1; break;

 	 case 'M': x8bitar = MACCODE; /* Anvnd Macteckenkodning */
	           angettTeckenkod = 1; break;
 	 case 'D': x8bitar = DOSCODE; /* Anvnd DOSteckenkodning */
	           angettTeckenkod = 1; break;
	 case '8': x8bitar = ISOCODE; /* Anvnd ISO 8859-1 */
	           angettTeckenkod = 1; break;
	 case '7': x8bitar = 0; /* Anvnd normala 7-bitstecken */
                   angettTeckenkod = 1; break;

	 case 'v': /* Rapportera version */
	 case 'V':
	  printf("%s\n", VERSION);
	  break;

	 case 'w': /* Stavningskolla ett enda ord */
	  if (i + 1 < argc && argv[i+1][0] != '-') {
	    enstakaOrd[antalEnstakaOrd] = malloc(strlen(argv[i+1]) + 1);
	    strcpy(enstakaOrd[antalEnstakaOrd], argv[i+1]);
	    antalEnstakaOrd++;
	    i++;
	  } else 
#ifdef ISO8BITAR
	    fprintf(stderr, "Ett ord mste ges efter -w\n");
#else
	    fprintf(stderr, "Ett ord m}ste ges efter -w\n");
#endif
	  break;
	  
	 case 'o': /* Ls tillggsordlista */
	  if (i + 1 < argc)
	    ordlistor[antalOrdlistor] = (char *) malloc(strlen(argv[i+1]) + 1);
	  if (LasFilnamn("Filnamn", 'o', ordlistor[antalOrdlistor], &i, argc, argv))
	    fel++;
	  else antalOrdlistor++;
	  break;
	  
	 case 'i': /* Infr ord i dokumentordlistan */
	           xInforOrdlista = 1; break;

	 case 'l': /* Ls frn annat lexikon */
	  if (LasFilnamn("Filnamn", 'l', lexfNamn, &i, argc, argv)) fel++;
	  break;

	 case 'u': /* Utlexikonfilnamn */
	  if (LasFilnamn("Filnamn", 'u', utlexfNamn, &i, argc, argv)) fel++;
	  else xSkrivLexikon = xEndastEtt = 1;
	  break;

	 case 'H': /* Hjlp */
	 case '?': fel++;
	  break;

	 default:
#ifdef ISO8BITAR
	  fprintf(stderr, "Oknd vljare: %c\n", *(s-1));
#else
	  fprintf(stderr, "Ok{nd v{ljare: %c\n", *(s-1));
#endif
	  fel++;
	  break;
	}
      }
    } else {
      if (filnamnTillatna) infiler[antalInfiler++] = argv[i];
#ifdef ISO8BITAR
      else fprintf(stderr, "Oknd vljare: %s\n", argv[i]);
#else
      else fprintf(stderr, "Ok{nd v{ljare: %s\n", argv[i]);
#endif
    }
  }
  if (fel) {
    fprintf(stderr, "%s\n", VERSION);
    fprintf(stderr, "Syntax:\n");
#ifdef ISO8BITAR
    fprintf(stderr,
	    " %s [-o ordlista] [-afnsdqiektr78MD] infiler\n", PROGRAMNAMN);
/* [-o ordlista] [-l lexikonfil] [-u utlexikonfil] [-afnsdqiektr7] infiler */
    fprintf(stderr,
" a (ndelser), f(rkortningar), n(amn), s(ammansttningar), d(atatermer),\n");
    fprintf(stderr,
" q (ls inte %s-fil), i(nfr i %s-fil), e(n felrapport per ord),\n",
    DOKUMENTORDLISTEEFTERNAMN, DOKUMENTORDLISTEEFTERNAMN);
    fprintf(stderr,
" k (kort lista med fel, samma som -eafnsd), t(exfil), h(tml-fil),\n");
    fprintf(stderr,
" r(ttstavningsfrslag), p (extra petig kontroll),\n");
    fprintf(stderr,
" Teckenkodsvljare: 8 (Unix/Windows), M (Mac), D (DOS), 7 (7-bitskod)\n");
    fprintf(stderr,
"Fullstndig information finns i WWW p\n");
    fprintf(stderr,
"http://www.nada.kth.se/stava/1.8/manual.html\n");
#else
    fprintf(stderr,
	    " %s [-o ordlista] [-afnsdqiektr78MD] infiler\n", PROGRAMNAMN);
/* [-o ordlista] [-l lexikonfil] [-u utlexikonfil] [-afnsdqiektr8] infiler */
    fprintf(stderr,
" a ({ndelser), f(|rkortningar), n(amn), s(ammans{ttningar), d(atatermer),\n");
    fprintf(stderr,
" q (l{s inte %s-fil), i(nf|r i %s-fil), e(n felrapport per ord),\n",
    DOKUMENTORDLISTEEFTERNAMN, DOKUMENTORDLISTEEFTERNAMN);
    fprintf(stderr,
" k (kort lista med fel, samma som -eafnsd), t(exfil), h(tml-fil),\n");
    fprintf(stderr,
" r({ttstavningsf|rslag), p (extra petig kontroll),\n");
    fprintf(stderr,
" Teckenkodsv{ljare: 8 (Unix/Windows), M (Mac), D (DOS), 7 (7-bitskod)\n");
    fprintf(stderr,
"Fullst{ndig information finns i WWW p}\n");
    fprintf(stderr,
"http://www.nada.kth.se/stava/1.8/manual.html\n");
#endif
    exit(1);
  }
}

/* KollaOrd kollar ordet som det r, med bara sm bokstver och, om det
   bara innehller versaler, med stor begynnelsebokstav */
static INLINE int KollaOrd(char *ordin)
{ static char ord[LANGD], Ord[LANGD];
  if (Finns(ordin)) return 1;
  VersalerGemena(ordin,ord,Ord);
  if (*ord) if (Finns(ord)) return 1;
  if (*Ord) if (Finns(Ord)) return 1;
  return 0;
}

/* KollaDelar kollar alla ordets delar som r avskiljda med bindestreck
   var fr sej och returnerar sant d alla finns */
static INLINE int KollaDelar(char *ordin, char *ord2)
{ char *t;
  do {
    t = ord2;
    while (*ordin && *ordin != '-') *t++ = *ordin++;
    *t = '\0';
    if (t - ord2 >= ORDMIN) if (!KollaOrd(ord2)) return 0;
  } while (*ordin++);
  return 1;
}

INLINE void StavaOrd(char *ordin, char *urord)
{ char ord2[LANGD + 3];
  if (KollaOrd(ordin)) return;
  if (bindestreck) {
    if (xSammansatta) if (KollaDelar(ordin, ord2)) return;
    SuddaBindestreck(ordin, ord2);
    if (KollaOrd(ord2)) return;
  }
#ifdef RATTSTAVA
  if (xRattstavningsforslag) {
    char Ord[LANGD];
    int Capitalized = 0, i;
    if (stor(ordin[0])) {
      Capitalized = 1;
      for (i = 1; ordin[i] != '\0'; i++) {
	if (stor(ordin[i])) {
	  Capitalized = 0;
	  break;
	}
      }
    }
    FyrSudda();
    if (fleraInfiler) printf("%s:\t%s: ", ordfNamn, urord);
    else printf("%s: ", urord);
    GenereraAlternativaOrd(ordin);
    if (fyrAntalOrd == 0) {
      VersalerGemena(ordin, ord2, Ord);
      if (*ord2) GenereraAlternativaOrd(ord2);
    } else if (Capitalized) {
      ordin[0] = Liten(ordin[0]);
      GenereraAlternativaOrd(ordin);
    }
    if (fyrAntalOrd > 0) {
      for (i = 0; i < fyrAntalOrd; i++) {
	if (Capitalized && liten(*fyrOrd[i])) 
	  *fyrOrd[i] = Stor(*fyrOrd[i]);
	SkrivOrd(fyrOrd[i]);
	putchar(' ');
      }
      putchar('\n');
    } else printf("? hittar inga liknande ord\n");
  } else
#endif
    if (fleraInfiler) printf("%s:\t%s\n", ordfNamn, urord);
    else printf("%s\n", urord);
  if (inforOrdlista) fprintf(xlexf,"%s\n", urord);
  if (xEndastEtt) {
    LagraOrd(ordin);
    if (xRattstavningsforslag || !xIntePetig) LagraFyrgrafer(ordin);
  }
}

int main(int argc, char **argv)
{ char ordin[LANGD], urord[LANGD], **envv;
  int envc;

  *lexfNamn = '\0';
  *xlexfNamn = '\0';
  if (EnvArg(ENVIRONMENTVARIABELNAMN, &envc, &envv) > 0) 
    KollaArg(0, envc, envv);
  KollaArg(1, argc, argv);
  if (!*lexfNamn) strcpy(lexfNamn, xKort ? KLISTFIL : LISTFIL);
  else xKort = 0; /* s inlsning av diverse lexikon inte hindras */
  Initiera();
  OppnaFiler();
  TagLexikon();
  if (antalEnstakaOrd > 0) {
    int i;
    unsigned char *t, *u;
    for (i = 0; i < antalEnstakaOrd; i++) {
      bindestreck = 0;
      strcpy(urord, enstakaOrd[i]);
      for (t = ordin, u = urord; (*t = bokstavsTabell[*u]) != 0; t++, u++)
	if (*t == '-') bindestreck++;
      if (strlen(ordin) >= ORDMIN)
	StavaOrd(ordin, urord);
    }
  }
  if (antalEnstakaOrd == 0 || antalInfiler > 0) {
    do {
      if (xLasOrdlista) TagNastaExtraOrdlista();
      if (xInforOrdlista) OppnaUtfil();
      while (TagOrd(ordin, urord))
	StavaOrd(ordin, urord);
      StangFiler();
    } while (OppnaNastaInfil());
  }
  if (xSkrivLexikon) SkrivLexikon();
  return 0;
}
