/* stava.h r en inkuderingsfil till stava.c */
/*
   Copyright (C) 1990-1997
   Joachim Hollman och Viggo Kann
   joachim@nada.kth.se viggo@nada.kth.se

   Fr spridninglicens, se inledningskommentaren i stava.c
*/

#define PROGRAMNAMN    "stava"
#define ENVIRONMENTVARIABELNAMN        "STAVA"
/* Datafilsnamn om inget annat anges */
#define LISTFIL        "/usr/local/lib/stava/list"
#define KLISTFIL       "/usr/local/lib/stava/klist"
#define XFORKORTNINGAR "/usr/local/lib/stava/forkortningar"
#define XNAMN          "/usr/local/lib/stava/namn"
#define XDATATERMER    "/usr/local/lib/stava/datatermer"
#define XTEX           "/usr/local/lib/stava/tex"
#define XFYRGRAFER     "/usr/local/lib/stava/fyrgraf"
#define DOKUMENTORDLISTEEFTERNAMN ".ord"
#define STORLEK 500000       /* Antal 8-bitarselement i bitvektorn */
#define FYRSTORLEK 101250    /* Antal 8-bitarselement i fyrgrafsbitvektorn */
#define LANGD 50             /* Lngsta tilltna ord */
#define DELORDMIN 3          /* Minsta tillta ordlngd i sammansttningar */
#define ORDMIN 2             /* Ord som r kortare n ORDMIN hoppas ver */
#define VSHIFT 7             /* Hur mycket nsta pow2 r vnstershiftad */

#define ISOCODE 1            /* vrde p variabeln x8bitar fr ISO 8859-1 */
#define MACCODE 2            /* vrde p variabeln x8bitar fr Mackodning */
#define DOSCODE 3            /* vrde p variabeln x8bitar fr Doskodning */

#define PTAL 14              /* Antal hashningar */
#define ETT14 1<<14
static long p[PTAL] = { /* De PTAL primtalen nrmast mindre n 8*STORLEK */
  3999971,
  3999949,
  3999929,
  3999923,
  3999917,
  3999901,
  3999893,
  3999871,
  3999859,
  3999851,
  3999803,
  3999791,
  3999781,
  3999773
};
