/* suffix.c r en ndelsehanteringsmodel som anropas av stava.c */
/*
   Copyright (C) 1990-1997
   Joachim Hollman och Viggo Kann
   joachim@nada.kth.se viggo@nada.kth.se

   Fr spridninglicens, se inledningskommentaren i stava.c
*/

/* #define ENGELSKA */ /* Engelsk stavningskontroll */
#ifndef ENGELSKA
#define SVENSKA /* Svensk stavningskontroll */
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "suffix.h"

#ifdef SVENSKA
#define TABSTORL 220
#define SUFSTORL 74
#define SUF2STORL 5

static tabell2;

static char *suffixtab[2 * SUFSTORL] = {
	"ad",		"a",
	"ade",		"a",
	"ades",		"a",
	"aktig",	"",
	"an",		"a",
	"ande",		"a",
	"anden",        "a",
	"andena",       "a",
	"andet",        "a",
	"ar",		"a",
	"are",		"",
	"aren",		"a",
	"arens",	"a",
	"ares",		"a",
	"arna",		"",
	"arnas",	"",
	"as",		"a",
	"ast",		"",
	"aste",		"",
	"at",		"a",
	"ats",		"a",
	"bar",		"a",
	"bart",		"a",
	"sbar",		"sbar",
	"sbart",	"sbart",
	"de",		"a",
	"des",		"a",
	"else",		"a",
	"elsen",	"a",
	"elser",	"a",
	"elserna",	"a",
	"en",		"",
	"ens",		"",
	"ende",		"",
	"endet",	"",
	"er",		"a",
	"erat",		"era",
	"ers",		"",
	"erna",		"",
	"ernas",	"",
	"et",		"",
	"ets",		"",
	"het",		"",
	"heten",	"",
	"hetens",	"",
	"heter",	"",
	"heterna",	"",
	"heternas",	"",
	"ing",		"a",
	"ingar",	"a",
	"ingen",	"a",
	"isering",	"",
	"isk",		"",
	"iska",		"",
	"iskt",		"",
	"na",           "en",
	"nad",          "na",
	"nad",          "na",
	"nades",        "na",
	"nde",          "nna",
	"ning",         "a",
	"ningar",       "a",
	"ningars",      "a",
	"ningarna",     "a",
	"ningarnas",    "a",
	"ningen",       "a",
	"ningens",      "a",
	"nings",        "a",
	"or",           "a",
	"orna",         "a",
	"ornas",        "a",
	"ors",          "a",
	"rer",          "r",
	"s",            ""  };

static char *suffix2tab[2 * SUF2STORL] = {
        "else",     "a",
	"hets",     "",
	"ings",     "a",
	"iserings", "",
	"nings",    "a" };
#endif /* SVENSKA */
#ifdef ENGELSKA
#define TABSTORL 20
#define SUFSTORL 5

static char *suffixtab[2 * SUFSTORL] = {
	"ally",         "al",
	"s",            "",
	"es'",          "",
	"s'",           "",
	"'s",           "" };
#endif /* ENGELSKA */

static char tecken[TABSTORL];
static int missl[TABSTORL], lyckad[TABSTORL];
static char *kod[TABSTORL];
static int fri;

static char *LetaOrd(char *ord, int *slutpos, int rad)
{ int j;
  char *slutkod = NULL;
  for (j = strlen(ord) - 1; j >= 0; j--) {
    while (ord[j] != tecken[rad] )
      if (missl[rad]) rad = missl[rad];
      else return slutkod;
    if (kod[rad]) {
      slutkod = kod[rad];
      *slutpos = j;
    }
    if (lyckad[rad]) rad = lyckad[rad];
    else return slutkod;
  }
  return slutkod;
}

int Suffix(char *ord, char *ord2)
{ int slutpos;
  char *sufbyte;
  sufbyte = LetaOrd(ord, &slutpos, 1);
  if (!sufbyte) return 0;
  strncpy(ord2, ord, slutpos);
  strcpy(ord2 + slutpos, sufbyte);
  return 1;
}

#ifdef SVENSKA
int Suffix2(char *ord, char *ord2)
{ int slutpos;
  char *sufbyte;
  sufbyte = LetaOrd(ord, &slutpos, tabell2);
  if (!sufbyte) return 0;
  strncpy(ord2, ord, slutpos);
  strcpy(ord2 + slutpos, sufbyte);
  return 1;
}
#endif

static int PlaceraOrd(char *ord, char *slutkod)
{ int rad = 0, j, senasterad = 0;
  for (j = strlen(ord) - 1; j >= 0; j--) {
    while (ord[j] != tecken[rad])
      if (missl[rad]) rad = missl[rad];
      else {
	missl[rad] = fri;
	tecken[fri] = ord[j];
	rad = fri;
	if (++fri >= TABSTORL) return 1;
	goto stoppaInResten;
      }
    if (lyckad[rad]) {
      senasterad = rad;
      rad = lyckad[rad];
    } else goto stoppaInResten;
  }
  kod[senasterad] = slutkod;
  return 0;
 stoppaInResten:
  j--;
  for (; j >= 0; j--){
    lyckad[rad] = fri;
    tecken[fri] = ord[j];
    rad = fri;
    if (++fri >= TABSTORL) return 1;
  }
  kod[rad] = slutkod;
  return 0;
}

int InitSuf(void)
{ int i;
  for (i = 0; i < TABSTORL; i++) {
    tecken[i] = '?';
    missl[i] = lyckad[i] = 0;
    kod[i] = NULL;
  }
  fri = 1;
  for (i = 0; i < SUFSTORL; i++) {
    if (PlaceraOrd(suffixtab[i*2], suffixtab[i*2+1])) return 1;
  }
#ifdef SVENSKA
  missl[0] = lyckad[0] = 0;
  tabell2 = fri;
  for (i = 0; i < SUF2STORL; i++) {
    if (PlaceraOrd(suffix2tab[i*2], suffix2tab[i*2+1])) return 1;
  }
#endif
  return 0;
}
