'\" 
'\" Copyright (c) 2001 by Andreas Kupries <a.kupries@westend.com>
'\" All rights reserved.
'\" 
'\" RCS: @(#) $Id: csv.n,v 1.4 2001/07/06 22:58:05 andreas_kupries Exp $
'\" 
.so man.macros
.TH csv n 1.0 Csv "CSV processing"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
::csv \- Procedures to handle CSV data
.SH SYNOPSIS
\fBpackage require csv ?0.1?\fR
.sp
\fB::csv::join\fR \fIvalues {sepChar ,}\fR
.sp
\fB::csv::joinlist\fR \fIvalues {sepChar ,}\fR
.sp
\fB::csv::read2matrix\fR \fIchan m {sepChar ,}\fR
.sp
\fB::csv::read2queue\fR \fIchan q {sepChar ,}\fR
.sp
\fB::csv::report\fR \fIcmd matrix ?chan?\fR
.sp
\fB::csv::split\fR \fIline {sepChar ,}\fR
.sp
\fB::csv::split2queue\fR \fIq line {sepChar ,}\fR
.sp
\fB::csv::writematrix\fR \fIm chan {sepChar ,}\fR
.sp
\fB::csv::writequeue\fR \fIq chan {sepChar ,}\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fB::csv\fR package provides commands to manipulate information in
CSV format (CSV = Comma Separated Values).
.SH COMMANDS
.PP
The following commands are available:
.TP
\fB::csv::join\fR \fIvalues {sepChar ,}\fR
Takes a list of values and returns a string in CSV format containing
these values. The separator character can be defined by the caller,
but this is optional. The default is ",".
.TP
\fB::csv::joinlist\fR \fIvalues {sepChar ,}\fR
Takes a list of lists of values and returns a string in CSV format
containing these values. The separator character can be defined by the
caller, but this is optional. The default is ",". Each element of the
outer list is considered a record, these are separated by newlines in
the result. The elements of each record are formatted as usual (via
\fB::csv::join\fR).
.TP
\fB::csv::read2matrix\fR \fIchan m {sepChar ,}\fR
A wrapper around \fB::csv::split2matrix\fR (see below) reading from
CSV-formatted lines from the specified channel (until EOF) and adding
it to the given matrix.
.TP
\fB::csv::read2queue\fR \fIchan q {sepChar ,}\fR
A wrapper around \fB::csv::split2queue\fR (see below) reading from
CSV-formatted lines from the specified channel (until EOF) and adding
it to the given queue.
.TP
\fB::csv::report\fR \fIcmd matrix ?chan?\fR
A report command which can be used by the matrix methods
\fBformat 2string\fR and \fBformat 2chan\fR. For the latter this
command delegates the work to \fB::csv::writematrix\fR. \fIcmd\fR is
expected to be either "printmatrix" or "printmatrix2channel". The
channel argument, \fIchan\fR, has to be present for the latter and
must not be present for the first.
.TP
\fB::csv::split\fR \fIline {sepChar ,}\fR
converts a \fIline\fR in CSV format into a list of the values
contained in the line. The character used to separate the values from
each other can be defined by the caller, via \fIsepChar\fR, but this
is optional. The default is ",".
.TP
\fB::csv::split2matrix\fR \fIm line {sepChar ,}\fR
The same as \fB::csv::split\fR, but appends the resulting list as a
new row to the matrix \fIm\fR, using the method \fBadd row\fR. It is the
responsibility of the caller to ensure that the matrix has enough
columns to contain the full line. If there are not enough columns the
list of values is silently truncated at the end to fit.
.TP
\fB::csv::split2queue\fR \fIq line {sepChar ,}\fR
The same as \fB::csv::split\fR, but appending the resulting list as a
single item to the queue \fIq\fR, using the method \fBput\fR.
.TP
\fB::csv::writematrix\fR \fIm chan {sepChar ,}\fR
A wrapper around \fB::csv::join\fR taking all rows in the matrix
\fIm\fR and writing them CSV formatted into the channel \fIchan\fR.
.TP
\fB::csv::writequeue\fR \fIq chan {sepChar ,}\fR
A wrapper around \fB::csv::join\fR taking all items in the queue
\fIq\fR (assumes that they are lists) and writing them CSV formatted
into the channel \fIchan\fR.
.SH FORMAT
.PP
Each record of a csv file (comma-separated values, as exported e.g. by
Excel) is a set of ASCII values separated by ",". For other languages
it may be ";" however, although this is not important for this case
(The functions provided here allow any separator character).
.PP
If a value contains itself the separator ",", then it (the value) is
put between "".
.PP
If a value contains ", it is replaced by "".
.SH EXAMPLE
.PP
The record
.TP
*
123,"123,521.2","Mary says ""Hello, I am Mary"""
.PP
is parsed as follows:
.TP
a)
123
.TP
b)
123,521.2
.TP
c)
Mary says "Hello, I am Mary"
.SH SEE ALSO
.SH KEYWORDS
csv
'\" -*- nroff -*-
