'\"
'\" Copyright (c) 2001 by ActiveState Tool Corp.
'\" All rights reserved.
'\" 
'\" RCS: @(#) $Id: log.n,v 1.2 2001/07/06 18:30:52 andreas_kupries Exp $
'\" 
.so man.macros
.TH log n 1.0 Log "Logging facility"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
::log \- Procedures to log messages of libraries and applications.
.SH SYNOPSIS
\fBpackage require log ?1.0?\fR
.sp
\fB::log::levels\fR
.sp
\fB::log::lv2longform\fR \fIlevel\fR
.sp
\fB::log::lv2color\fR \fIlevel\fR
.sp
\fB::log::lv2priority\fR \fIlevel\fR
.sp
\fB::log::lv2cmd\fR \fIlevel\fR
.sp
\fB::log::lv2channel\fR \fIlevel\fR
.sp
\fB::log::lvCompare\fR \fIlevel1 level2\fR
.sp
\fB::log::lvSuppress\fR \fIlevel {suppress 1}\fR
.sp
\fB::log::lvSuppressLE\fR \fIlevel {suppress 1}\fR
.sp
\fB::log::lvIsSuppressed\fR \fIlevel\fR
.sp
\fB::log::lvCmd\fR \fIlevel cmd\fR
.sp
\fB::log::lvCmdForall\fR \fIcmd\fR
.sp
\fB::log::lvChannel\fR \fIlevel chan\fR
.sp
\fB::log::lvChannelForall\fR \fIchan\fR
.sp
\fB::log::lvColor\fR \fIlevel color\fR
.sp
\fB::log::lvColorForall\fR \fIcolor\fR
.sp
\fB::log::log\fR \fIlevel text\fR
.sp
\fB::log::logMsg\fR \fItext\fR
.sp
\fB::log::logError\fR \fItext\fR
.sp
\fB::log::Puts\fR \fIlevel text\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fB::log\fR package provides commands that allow libraries and
applications to selectively log information about their internal
operation and state.
.PP
Each message given to the log facility is associated with a
\fIlevel\fR determining the importance of the message. The user can
then select which levels to log, what commands to use for the logging
of each level and the channel to write the message to. The latter is
relevant only if the standard command (\fB::log::Puts\fR) to log
messages provided by \fB::log\fR is used. Apprehending the usage of
this facility in graphical applications, i.e. \fBtk\fR-based ones, it
also allows the user to associate colors with the message levels.
.PP
The following commands are available:
.TP
\fB::log::levels\fR
Returns the names of all known levels, in alphabetical order.
.TP
\fB::log::lv2longform\fR \fIlevel\fR
Converts any unique abbreviation of a level name to the full level
name.
.TP
\fB::log::lv2color\fR \fIlevel\fR
Converts any level name including unique abbreviations to the
corresponding color.
.TP
\fB::log::lv2priority\fR \fIlevel\fR
Converts any level name including unique abbreviations to the
corresponding priority.
.TP
\fB::log::lv2cmd\fR \fIlevel\fR
Converts any level name including unique abbreviations to the command
prefix used to write messages with that level.
.TP
\fB::log::lv2channel\fR \fIlevel\fR
Converts any level name including unique abbreviations to the channel
used by \fB::log::Puts\fR to write messages with that level.
.TP
\fB::log::lvCompare\fR \fIlevel1 level2\fR
Compares two levels (including unique abbreviations) with respect to
their priority. This command can be used by the -command option of
lsort. The result is one of -1, 0 or 1 or an error. A result of -1
signals that level1 is of less priority than level2. 0 signals that
both levels have the same priority. 1 signals that level1 has higher
priority than level2.
.TP
\fB::log::lvSuppress\fR \fIlevel {suppress 1}\fR
(Un)suppresses the output of messages having the specified
level. Unique abbreviations for the level are allowed here too.
.TP
\fB::log::lvSuppressLE\fR \fIlevel {suppress 1}\fR
(Un)suppresses the output of messages having the specified level or
one of lesser priority. Unique abbreviations for the level are allowed
here too.
.TP
\fB::log::lvIsSuppressed\fR \fIlevel\fR
Asks the package whether the specified level is currently
suppressed. Unique abbreviations of level names are allowed.
.TP
\fB::log::lvCmd\fR \fIlevel cmd\fR
Defines for the specified level with which command to write the
messages having this level. Unique abbreviations of level names are
allowed. The command is actually a command prefix and this facility
will append 2 arguments before calling it, the level of the message
and the message itself, in this order.
.TP
\fB::log::lvCmdForall\fR \fIcmd\fR
Defines for all known levels with which command to write the messages
having this level. The command is actually a command prefix and this
facility will append 2 arguments before calling it, the level of the
message and the message itself, in this order.
.TP
\fB::log::lvChannel\fR \fIlevel chan\fR
Defines for the specified level into which channel \fB::log::Puts\fR
(the standard command) shall write the messages having this
level. Unique abbreviations of level names are allowed. The command is
actually a command prefix and this facility will append 2 arguments
before calling it, the level of the message and the message itself, in
this order.
.TP
\fB::log::lvChannelForall\fR \fIchan\fR
Defines for all known levels with which which channel
\fB::log::Puts\fR (the standard command) shall write the messages
having this level. The command is actually a command prefix and this
facility will append 2 arguments before calling it, the level of the
message and the message itself, in this order.
.TP
\fB::log::lvColor\fR \fIlevel color\fR
Defines for the specified level the color to return for it in a call
to \fB::log::lv2color\fR. Unique abbreviations of level names are
allowed.
.TP
\fB::log::lvColorForall\fR \fIcolor\fR
Defines for all known levels the color to return for it in a call to
\fB::log::lv2color\fR. Unique abbreviations of level names are
allowed.
.TP
\fB::log::log\fR \fIlevel text\fR
Log a message according to the specifications for commands, channels
and suppression. In other words: The command will do nothing if the
specified level is suppressed. If it is not suppressed the actual
logging is delegated to the specified command. If there is no command
specified for the level the message won't be logged. The standard
command \fB::log::Puts\fR will write the message to the channel
specified for the given level. If no channel is specified for the
level the message won't be logged. Unique abbreviations of level names
are allowed. Errors in the actual logging command are \fBnot\fR
caught, but propagated to the caller, as they may indicate
misconfigurations of the log facility or errors in the callers code
itself.
.TP
\fB::log::logMsg\fR \fItext\fR
Convenience wrapper around \fB::log::log\fR. Equivalent to
\fB::log::log info text\fR.
.TP
\fB::log::logError\fR \fItext\fR
Convenience wrapper around \fB::log::log\fR. Equivalent to
\fB::log::log error text\fR.
.TP
\fB::log::Puts\fR \fIlevel text\fR
The standard log command, it writes messages and their levels to
user-specified channels. Assumes that the suppression checks were done
by the caller. Expects full level names, abbreviations are \fBnot
allowed\fR.

.SH SEE ALSO
.SH KEYWORDS
log, log level, message level, message
