'\" 
'\" Copyright (c) 2001 ActiveState Tool Corp.
'\" All rights reserved.
'\" 
'\" RCS: @(#) $Id: md5.n,v 1.3 2001/07/06 18:30:52 andreas_kupries Exp $
'\" 
.so man.macros
.TH md5 n 1.0 Md5 "md5 hash"
.BS
'\" Note: do not modify the .SH NAME line immediately below!
.SH NAME
::md5::md5 \- Perform md5 hashing
.SH SYNOPSIS
\fBpackage require md5 ?1.2?\fR
.sp
\fB::md5::md5\fR \fImsg\fR?
.sp
\fB::md5::hmac\fR \fIkey text\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides commands to compute a MD5 digests of arbitrary
messages.
.SH COMMANDS
.TP
\fB::md5::md5\fR \fImsg\fR
The command takes a message and returns the MD5 digest of this message
as a hexadecimal string.
.TP
\fB::md5::hmac\fR \fIkey text\fR
The command takes a key string and a text and returns the hmac of the
text under the chosen key as a hexadecimal string.
.SH EXAMPLES
.PP
.CS
% md5::md5 "hello world"
5eb63bbbe01eeed093cb22bb8f5acdc3
.CE
.PP
.CS
% md5::hmac "our little secret" "hello world"
61a922114c8aaf5050098be6d3a7daf0
.CE
.SH KEYWORDS
md5, hashing, security
