'\" 
'\" Copyright (c) 2001 ActiveState Tool Corp.
'\" All rights reserved.
'\" 
'\" RCS: @(#) $Id: sha1.n,v 1.2 2001/07/06 18:30:52 andreas_kupries Exp $
'\" 
.so man.macros
.TH sha1 n 1.0 Sha1 "sha1 hash"
.BS
'\" Note: do not modify the .SH NAME line immediately below!
.SH NAME
::sha1::sha1 \- Perform sha1 hashing
.SH SYNOPSIS
\fBpackage require sha1 ?1.0?\fR
.sp
\fB::sha1::sha1\fR \fImsg\fR?
.sp
\fB::sha1::hmac\fR \fIkey text\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides commands to compute a SHA1 digests of arbitrary
messages.
.SH COMMANDS
.TP
\fB::sha1::sha1\fR \fImsg\fR
The command takes a message and returns the SHA1 digest of this message
as a hexadecimal string.
.TP
\fB::sha1::hmac\fR \fIkey text\fR
The command takes a key string and a text and returns the hmac of the
text under the chosen key as a hexadecimal string.
.SH EXAMPLES
.PP
.CS
% sha1::sha1 "hello world"
2aae6c35c94fcfb415dbe95f408b9ce91ee846ed
.CE
.PP
.CS
% sha1::hmac "our little secret" "hello world"
a7ed9d62819b9788e22171d9108a00c370104526
.CE
.SH KEYWORDS
sha1, hashing, security
