'\"
'\" Copyright (c) 1998-2000 by Ajuba Solutions.
'\" All rights reserved.
'\" 
'\" RCS: @(#) $Id: graph.n,v 1.3 2001/07/06 18:30:52 andreas_kupries Exp $
'\" 
.so man.macros
.TH graph n 1.0 Struct "Tcl Data Structures"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
::struct::graph \- Create and manipulate directed graph objects
.SH SYNOPSIS
\fBpackage require struct ?1.0?\fR
.sp
\fB::struct::graph\fR \fIgraphName\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fB::struct::graph\fR command creates a new graph object with an
associated global Tcl command whose name is \fIgraphName\fR.  This command
may be used to invoke various operations on the graph.
It has the
following general form:
.CS
\fIgraphName option \fR?\fIarg arg ...\fR?
.CE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.
.PP
A directed graph is a structure containing two collections of
elements, called \fInodes\fR and \fIarcs\fR resp., together with a
relation ("connectivity") that places a general structure upon the
nodes and arcs.

Each arc is connected to two nodes, one of which is called the
\fIsource\fR and the other the \fItarget\fR. This imposes a direction
upon the arc, which is said to go from the source to the target. It is
allowed that source and target of an arc are the same node. Such an
arc is called a \fIloop\fR. Whenever a node is source or target of an
arc both are said to be \fIadjacent\fR. This extends into a relation
between nodes, i.e. if two nodes are connected through at least one
arc they are said to be \fIadjacent\fR too.

Each node can be the source and target for any number of arcs. The
former are called the \fIoutgoing arcs\fR of the node, the latter the
\fIincoming arcs\fR of the node. The number of edges in either set is
called the \fIin-\fR resp. the \fIout-degree\fR of the node.

In addition to maintaining the node and arc relationships, this graph
implementation allows any number of keyed values to be associated with
each node and arc.
.PP
The following commands are possible for graph objects:
.TP
\fIgraphName \fBdestroy\fR
Destroy the graph, including its storage space and associated command.
.TP
\fIgraphName\fR \fBarc delete\fR \fIarc\fR ?\fIarc\fR ...?
Remove the specified arcs from the graph.
.TP
\fIgraphName\fR \fBarc exists\fR \fIarc\fR
Return true if the specified \fIarc\fR exists in the graph.
.TP
\fIgraphName\fR \fBarc get\fR \fIarc\fR ?\fI-key key\fR?
Return the value associated with the key \fIkey\fR for the
\fIarc\fR.  If no key is specified, the key \fBdata\fR is assumed.
.TP
\fIgraphName \fBarc insert\fR \fIstart\fR \fIend\fR ?\fIchild\fR?
Insert an arc named \fIchild\fR into the graph beginning at the node
\fIstart\fR and ending at the node \fIend\fR. If the name of the new
arc is not specified the system will generate a unique name of the
form \fBarc\fR\fIx\fR.
.TP
\fIgraphName\fR \fBarc set\fR \fIarc\fR ?\fI-key key\fR? ?\fIvalue\fR?
Set or get one of the keyed values associated with an arc.  If no key
is specified, the key \fBdata\fR is assumed.  Each arc that is added
to a graph has the value "" assigned to the key \fBdata\fR
automatically.  An arc may have any number of keyed values associated
with it.  If \fIvalue\fR is not specified, this command returns the
current value assigned to the key; if \fIvalue\fR is specified, this
command assigns that value to the key.
.TP
\fIgraphName\fR \fBarc source\fR \fIarc\fR
Return the node the given \fIarc\fR begins at.
.TP
\fIgraphName\fR \fBarc target\fR \fIarc\fR
Return the node the given \fIarc\fR ends at.
.TP
\fIgraphName\fR \fBarc unset\fR \fIarc\fR ?\fI-key key\fR?
Remove a keyed value from the arc \fIarc\fR.  If no key is
specified, the key \fBdata\fR is assumed.
.TP
\fIgraphName\fR \fBarcs\fR ?-in|-out|-adj|-inner|-embedding \fInodelist\fR?

Return a list of arcs in the graph. If no restriction is specified a
list containing all arcs is returned. If one of the five possible
restrictions is specified only arcs satisfying that restriction are
returned. All restrictions involve a list of nodes, specified after
the key for the restriction itself.
.IP
\fB-in\fR
Return a list of all arcs whose target is one of the nodes in the
\fInodelist\fR.
.IP
\fB-out\fR
Return a list of all arcs whose source is one of the nodes in the
\fInodelist\fR.
.IP
\fB-adj\fR
Return a list of all arcs adjacent to at least one of the nodes in
the \fInodelist\fR. This is the union of the nodes returned by
\fB-in\fR and \fB-out\fR.
.IP
\fB-inner\fR
Return a list of all arcs adjacent to two of the nodes in the
\fInodelist\fR. This is the set of arcs in the subgraph spawned by
the specified nodes.
.IP
\fB-embedding\fR
Return a list of all arcs adjacent to exactly one of the nodes in the
\fInodelist\fR. This is the set of arcs connecting the subgraph
spawned by the specified nodes to the rest of the graph.
.TP
\fIgraphName\fR \fBnode degree\fR ?-in|-out? \fInode\fR
Return the number of arcs adjacent to the specified \fInode\fR. If
one of the restrictions \fB-in\fR or \fB-out\fR is given only the
incoming resp. outgoing arcs are counted.
.TP
\fIgraphName\fR \fBnode delete\fR \fInode\fR ?\fInode\fR ...?
Remove the specified nodes from the graph.  All of the nodes' arcs
will be removed as well to prevent unconnected arcs.
.TP
\fIgraphName\fR \fBnode exists\fR \fInode\fR
Return true if the specified \fInode\fR exists in the graph.
.TP
\fIgraphName\fR \fBnode get\fR \fInode\fR ?\fI-key key\fR?
Return the value associated with the key \fIkey\fR for the
\fInode\fR.  If no key is specified, the key \fBdata\fR is assumed.
.TP
\fIgraphName \fBnode insert\fR ?\fIchild\fR?
Insert a node named \fIchild\fR into the graph. The nodes has no arcs
connected to it. If the name of the new child is not specified the
system will generate a unique name of the form \fBnode\fR\fIx\fR.
.TP
\fIgraphName\fR \fBnode opposite\fR \fInode\fR \fIarc\fR
Return the node at the other end of the specified \fIarc\fR, which
has to be adjacent to the given \fInode\fR.
.TP
\fIgraphName\fR \fBnode set\fR \fInode\fR ?\fI-key key\fR? ?\fIvalue\fR?
Set or get one of the keyed values associated with a node.  If no key
is specified, the key \fBdata\fR is assumed.  Each node that is added
to a graph has the value "" assigned to the key \fBdata\fR
automatically.  A node may have any number of keyed values associated
with it.  If \fIvalue\fR is not specified, this command returns the
current value assigned to the key; if \fIvalue\fR is specified, this
command assigns that value to the key.
.TP
\fIgraphName\fR \fBnode unset\fR \fInode\fR ?\fI-key key\fR?
Remove a keyed value from the node \fInode\fR.  If no key is
specified, the key \fBdata\fR is assumed.
.TP
\fIgraphName\fR \fBnodes\fR ?-in|-out|-adj|-inner|-embedding \fInodelist\fR?
Return a list of nodes in the graph. If no restriction is specified a
list containing all nodes is returned. If one of the five possible
restrictions is specified only nodes satisfying that restriction are
returned. All restrictions involve a list of nodes, specified after
the key for the restriction itself.

The possible restrictions are the same as for method \fBarcs\fR. The
set of nodes to return is computed as the union of all source and
target nodes for all the arcs satisfying the restriction as defined
for \fBarcs\fR.
.TP
\fIgraphName\fR \fBswap\fR \fInode1\fR \fInode2\fR
Swap the position of \fInode1\fR and \fInode2\fR in the graph.
.TP
\fIgraphName\fR \fBwalk\fR \fInode\fR ?\fI-order order\fR? ?\fI-type type\fR? ?\fI-dir direction\fR? \fI-command cmd\fR

Perform a breadth-first or depth-first walk of the graph starting at
the node \fInode\fR going in either the direction of outgoing or
opposite to the incoming arcs.

The type of walk, breadth-first or depth-first, is determined by the
value of \fItype\fR; \fBbfs\fR indicates breadth-first, \fBdfs\fR
indicates depth-first.  Depth-first is the default.

The order of the walk, pre-order, post-order or both-order is
determined by the value of \fIorder\fR; \fBpre\fR indicates pre-order,
\fBpost\fR indicates post-order, \fBboth\fR indicates
both-order. Pre-order is the default. Pre-order walking means that a
node is visited before any of its neighbors (as defined by the
\fIdirection\fR, see below). Post-order walking means that a parent is
visited after any of its neighbors. Both-order walking means that a
node is visited before \fBand\fR after any of its neighbors. The
combination of a bread-first walk with post- or both-order is illegal.

The direction of the walk is determined by the value of \fIdir\fR;
\fBbackward\fR indicates the direction opposite to the incoming arcs,
\fBforward\fR indicates the direction of the outgoing arcs.

As the walk progresses, the command \fIcmd\fR will be evaluated at
each node, with the mode of the call (\fBenter\fR or \fBleave\fR) and
values \fIgraphName\fR and the name of the current node appended. For
a pre-order walk all nodes are Bentered, for a post-order all nodes
are left. In a both-order walk the first visit of a node \fBenter\fRs
it, the second visit \fBleave\fRs it.

.SH KEYWORDS
graph
