// $Date: 2001/07/16 12:55:47 $  $Author: tonner $  $Revision: 1.22 $ 

/*--
generate::TeX.mu -- TeX-output of expressions

--*/

proc() begin

/*++
generate::TeX -- return TeX-formatted string for expression

generate::TeX(e,...)

e - expression
++*/

generate::TeX:= proc() 
  local i;
begin 
    case args(0)
    of 0 do
    	""; break;
    of 1 do
    	generate::tex(args(1),0); break;
    otherwise
    	_concat(generate::tex(args(1),20),
    		(",", generate::tex(args(i),20)) $ i=2..args(0));
    end_case 
end_proc ;

/*++
generate::TeXdef -- define TeX-string for expression

generate::TeXdef(e, s)

e - expression
s - TeX-string
++*/

generate::TeXdef:= (()->((
    if args(0) <> 2 then error("wrong no of args") end_if;
    if domtype(args(2)) <> DOM_STRING then error("no TeX string") end_if;
    generate::TeXdefs[args(1)]:= args(2)
)));

// ------------------------ internas ----------------------- 

// table of user-defined TeX-strings 

generate::TeXdefs:= table(
        hold(PI)="\\pi",
        hold(E)="e",
        I="i",
	hold(EULER)="\\gamma",
    op(map([

hold(Delta), hold(Phi), hold(Gamma), hold(Lambda), hold(Pi), hold(Theta),
hold(Sigma), hold(Upsilon), hold(Omega), hold(Xi), hold(Psi), hold(alpha),
hold(beta), hold(chi), hold(delta), hold(epsilon), hold(varepsilon),
hold(phi), hold(varphi), hold(gamma), hold(eta), hold(iota), hold(kappa),
hold(lambda), hold(mu), hold(nu), hold(pi), hold(varpi), hold(theta),
hold(vartheta), hold(rho), hold(varrho), hold(sigma), hold(varsigma),
hold(tau), hold(upsilon), hold(omega), hold(xi), hold(psi), hold(zeta),
hold(partial), hold(aleph), hold(Im), hold(Re), hold(wp), 

hold(sin), hold(sinh), hold(cos), hold(cosh), hold(tan), hold(tanh), 
hold(cot), hold(coth), hold(csc), hold(csch), hold(sec), hold(sech)
    ], (()->(args(1)="\\".args(1))))),
    
hold(arcsin)="\\arcsin", hold(arccos)="\\arccos", hold(arctan)="\\arctan"
    ):

/*--
generate::tex -- return TeX-formatted string for expression

generate::tex(e,p)

e - expression
p - priority of enclosing expression
--*/

generate::tex:= (()->((
    if contains(generate::TeXdefs, args(1)) then
	generate::TeXdefs[args(1)]
    else
	slot(domtype(args(1)), "TeX")(args());
        if % = FAIL then
          DOM_IDENT::TeX(args())
        else
           %
        end_if
    end_if;
)));

/*--
generate::TeXquote -- quote TeX-string

generate::TeXquote(s,ep,sp)

s - TeX string
ep - priority of enclosing expression
sp - priority of this expression
--*/

generate::TeXquote:= (()->((
    //if args(2)<=args(3) then args(1) else "\\left(".args(1)."\\right)" end_if)));
    // <= corrected to <; 16-02-99 WMS
    if args(2)<args(3) then args(1) else "\\left(".args(1)."\\right)" end_if)));

/*--
generate::TeXseq -- create TeX string for sequence

generate::TeXseq(lb,rb,e,...)

lb, rb - strings with left and right brackets
e      - expression
--*/

generate::TeXseq:= proc() 
  local i;
begin 
  _concat(
    args(1),
    (case args(0)
     of 2 do ""; break;
     of 3 do generate::tex(args(3), 0); break;
     otherwise
     	generate::tex(args(3), 20),
     	((",", generate::tex(args(i), 20)) $ i=4..args(0));
     end_case),
    args(2)) 
end_proc ;

/*--
generate::TeXoperator -- TeX formatting of operator

generate::TeXoperator(sym, ep, tp, op,...)

sym - operator symbol
ep  - priority of enclosing expression
tp  - priority of this expression
op  - operands
--*/

generate::TeXoperator:= proc() 
  local i;
begin 
    case args(0)
    of 3 do ""; break;
    of 4 do generate::tex(args(4), args(2)); break;
    otherwise
    	generate::TeXquote(
    	    _concat(generate::tex(args(4), args(3)),
    	    	    (args(1), generate::tex(args(i), args(3)))
    	    	     $ i=5..args(0)),
	    args(2), args(3))
    end_case
end_proc;

/*--
generate::TeXfun -- TeX formatting function calls

generate::TeXfun(o,p,e,...)

o - TeX string of operator
p - priority of enclosing expression
e - operand expressions
--*/

generate::TeXfun:= proc() 
  local i;
begin 
    args(1).generate::TeXseq("\\left(", "\\right)", args(i) $ i=3..args(0))
end_proc ;

/* uncomment the following procedure if you prefer f(x) to be
  formatted as 'f x' instead of 'f(x)'... */
/*
generate::TeXfun:= proc() local s, i; begin
    case args(0)
    of 2 do
    	args(1)."\\left(\\right)";
    	break;
    of 3 do
    	s:= generate::tex(args(3),140);
    	if substring(s,0,7) = "\\left(" then
    	    args(1).s
    	else
    	    generate::TeXquote(args(1)." ".s, args(2), 140)
    	end_if;
    	break;
    otherwise
    	args(1).generate::TeXseq("\\left(", "\\right)", args(i) $ i=3..args(0))
    end_case
end_proc;
*/

// ------------- TeX formatting of domain elements ------------- 

DOM_INT::TeX:= (()->(expr2text(args(1))));
DOM_RAT::TeX:= DOM_INT::TeX;
DOM_BOOL::TeX:= DOM_INT::TeX;
DOM_FAIL::TeX:= DOM_INT::TeX;
DOM_NIL::TeX:= DOM_INT::TeX;
DOM_NULL::TeX:= "";
DOM_SET::TeX:= (()->(generate::TeXseq("\\left\\{", "\\right\\}", op(args(1)))));
DOM_LIST::TeX:= (()->(generate::TeXseq("\\left[", "\\right]", op(args(1)))));
DOM_POLY::TeX:= (()->(generate::tex(expr(args(1)), args(2))));

DOM_COMPLEX::TeX:= (()->(
    (if iszero(op(args(1),1)) then
     	generate::tex(op(args(1),2),0)." i"
     else
	generate::TeXquote(
		generate::tex(op(args(1),1),0)."+".generate::tex(op(args(1),2),0)." i",
		args(2),120)
     end_if)));
     
DOM_TABLE::TeX:= proc() 
  local i;
begin _concat(
    "\\begin{eqnarray*}\n",
    (if nops(args(1)) = 0 then null() else
    	generate::tex(op(args(1),[1,1]),60)," & = & ",
    	generate::tex(op(args(1),[1,2]),60),"\\\\\n",
    	((generate::tex(op(args(1),[i,1]),60)," & = & ",
    	  generate::tex(op(args(1),[i,2]),60),"\\\\\n")
    	 $ i=2..nops(args(1)))
     end_if),
     "\\end{eqnarray}") 
end_proc ;

DOM_ARRAY::TeX:= proc(a) local n, m, p, i, j; begin
    if op(a,[0,1]) = 1 then
        n:= op(a,[0,2,1]);
        m:= op(a,[0,2,2]);
    	_concat(
    	    "\\begin{array}{", ("c" $ (m - n + 1)), "}\n",
    	    generate::tex(a[n],20),
    	    ((" & ", generate::tex(a[i]),20) $ i=(n+1)..m),
    	    "\n\\end{array}")
    elif op(a,[0,1]) = 2 then
        n:= op(a,[0,3,1]);
        m:= op(a,[0,3,2]);
	_concat(
    	    "\\begin{array}{", ("c" $ (m - n + 1)), "}\n",
    	    ((generate::tex(a[j,n],20),
    	      ((" & ", generate::tex(a[j,i],20))
    	      $ i=(n+1)..m), "\\\\\n")
    	     $ j=op(a,[0,2])),
    	    "\\end{array}")
    else
    	p:= proc() local i; begin 
    	    if nops(args(1)) = op(a,[0,1]) then
    	    	"(".generate::tex(op(args(1)),60).") & = & ".
    	    	generate::tex(a[op(args(1))],60)."\\\\\n"
    	    else
    	    	_concat(p(args(1).[i]) $ i=op(a,[0,nops(args(1))+2]))
    	    end_if
    	 end_proc ;
    	"\\begin{eqnarray*}\n".p([])."\\end{eqnarray}"
    end_if
end_proc;

DOM_FLOAT::TeX:= proc(x) local p; begin

    // p removes trailing zeros 
    p:= proc(s) local m; begin
	if strmatch(s, "\*.\*") then
    	    s:= text2list(s, ["."]);
    	    m:= s[3];
    	    while substring(m, length(m)-1, 1) = "0" do
    	        if length(m) = 1 then break end_if;
    	        m:= substring(m, 0, length(m)-1)
    	    end_while;
    	    s[1].".".m
	else
	    s
	end_if
    end_proc;
    
    x:= expr2text(x);
    if strmatch(x, "\*e\*") then
	x:= text2list(x, ["e"]);
	x[1]:= p(x[1]);
	generate::TeXquote(_concat(x[1]," 10^",
	    (if length(x[3]) = 1 then x[3] else "{".x[3]."}" end_if)),
	    args(2), 130)
    else
	p(x)
    end_if
end_proc;

DOM_STRING::TeX:= proc(x) begin
    // change _ into \_ 
    if strmatch(x, "\*_\*") then
	x:= _concat(op(subs(text2list(x, ["_"]), "_"="\\_")))
    end_if;
    "\\mbox{\"".x."\"}"
end_proc;

DOM_IDENT::TeX:= proc(x) begin
    // change _ into \_ 
    x:= expr2text(x);
    if strmatch(x, "\*_\*") then
	x:= _concat(op(subs(text2list(x, ["_"]), "_"="\\_")))
    end_if;
    if length(x) = 1 then x else "\\mbox{".x."}" end_if;
end_proc;

DOM_EXPR::TeX:= proc(x) local f; begin
    f:= op(x,0);
    if domtype(f) = DOM_IDENT then
	f: f := eval(%);
    	if domtype(f) = DOM_FUNC_ENV and f::TeX <> FAIL then
            f::TeX(f, x, args(2))
	else
            generate::TeXfun(generate::tex(op(x,0)), args(2), op(x))
    	end_if
    else
    	generate::TeXfun(generate::tex(f,140), args(2), op(x))
    end_if
end_proc;

DOM_DOMAIN::TeX:= (()->((
    if (args(1))::Name <> FAIL then
        if domtype((args(1))::Name) = DOM_STRING then
            generate::tex(text2expr((args(1))::Name), args(2))
        else
	    generate::tex((args(1))::Name, args(2))
        end_if
    elif (args(1))::key <> FAIL then
        if domtype((args(1))::key) = DOM_STRING then
            generate::tex(text2expr((args(1))::key), args(2))
        else
	    generate::tex((args(1))::key, args(2))
        end_if
    else
        generate::tex(hold(newDomain)(), args(2))
    end_if
))):

// ------------------- TeX formatting of func-env's ------------------- 
/*--
Each TeX-formatting routine must have the form
	myformatfunc(fenv, expr, prio)
where fenv is the func-env of this routine, expr is the original expression
causing this call (the operator of expr was evaluated to fenv) and prio is
the priority of the enclosing expression.
--*/

_mult::TeX :=
proc( arg1, arg2, arg3 )
  local list, str;
begin
  list := generate::splitProduct(arg2);
  if nops( op(list, 3)) = 0 then
    // no denumerator 
    str := generate::TeXoperator("\\, ", arg3, 130, op(op(list,2)));
  else
    str := _concat( "\\frac{".
                 generate::TeXoperator("\\, ",arg3, 130, op(op(list,2))).
                 "}{".
                 generate::TeXoperator("\\, ",arg3, 130, op(op(list,3))).
                 "}");
  end_if;
  if op(list,1) = -1 then
    generate::TeXquote( "- ".str , arg3, 120);
  else
    str;
  end_if;
end_proc:

_divide::TeX := 
proc( arg1, arg2, arg3 )
  local str;
begin
  str := _concat( "\\frac{".
               generate::TeXoperator("\\, ",arg3, 130, op(arg2,1)).
               "}{".
               generate::TeXoperator("\\, ",arg3, 130, op(arg2,2)).
               "}");
end_proc:

_negate::TeX :=
proc( arg1, arg2, arg3 )
  local str;
begin
  str := generate::TeXoperator(" ",arg3, 120, op(arg2,1)) ;
  generate::TeXquote( "- ".str , arg3, 120); 
end_proc:

_subtract::TeX :=
proc( arg1, arg2, arg3 )
  local str;
begin
  str := _concat( 
               generate::TeXoperator(" ",arg3, 120, op(arg2,1)).
               " - ".
               generate::TeXoperator(" ",arg3, 120, op(arg2,2)) 
               );
  generate::TeXquote( str , arg3, 120);
end_proc:

_invert::TeX :=
proc( arg1, arg2, arg3 )
  local str;
begin
  str := _concat( "\\frac{1}{".
               generate::TeXoperator(" ",arg3, 130, op(arg2,1)).
               "}");
end_proc:

_plus::TeX :=
//   proc() local s, i, o; begin 
    proc() local tmp, s, i, o; begin
        case nops(args(2))
        of 0 do return("");
        of 1 do return(generate::tex(op(args(2),1), args(3)));
        end_case;
        tmp:= generate::sortSum(args(2));
             
        s:= "";   /* generate::tex(op(tmp, 1), 120); */
        for i from 1 to nops(tmp) do
          o:= op(tmp, i);
             if generate::isNeg(o) then
               s:= s." - ".generate::tex(- o, 120); next;
             else
               if i > 1 then
                 s:= s." + ";
               end_if;
               s := s.generate::tex(o, 120)
             end_if;
         end_for;
             
        generate::TeXquote(s, args(3), 120)
    end_proc:

_power::TeX :=
    proc() local s; begin
    	if testtype(op(args(2),2), Type::Real) then
    	    if op(args(2),2) = -1 then
    	        return("\\frac{1}{".generate::tex(op(args(2),1),0)."}")
    	    end_if;
    	    if op(args(2),2) < 0 then
    	    	return("\\frac{1}{".
    	    	       _power::TeX(_power,
    	    	       		op(args(2),1)^(-op(args(2),2)), 0)."}")
    	    end_if;
    	    if op(args(2),2) = 1/2 then
    	        return("\\sqrt{".generate::tex(op(args(2),1),0)."}")
    	    end_if;
    	    if domtype(op(args(2),2)) = DOM_RAT then
    	        if op(args(2),[2,1]) = 1 then
		    return("\\sqrt[".expr2text(op(args(2),[2,2]))."]{".
		    	   generate::tex(op(args(2),1),0)."}")
    	        else
		    return("\\sqrt[".expr2text(op(args(2),[2,2]))."]{".
		           _power::TeX(_power,
                             op(args(2),1)^op(args(2),[2,1]), 0)."}")
    	        end_if
    	    end_if
    	end_if;
    	s:= generate::tex(op(args(2),2),0);
    	if length(s) <> 1 then s:= "{".s."}" end_if;
	generate::TeXquote(generate::tex(op(args(2),1), 150)."^".s, args(3), 150)
    end_proc:

diff::TeX :=
    proc()
      local res, l, t, x, i;
    begin
      l:= [ op(args(2),2..nops(args(2))) ];
      t:= table();
      for x in l do
        if contains(t, x) then
          t[x]:= t[x] + 1
        else
          t[x]:= 1
        end_if
      end_for;

      t:= _concat(("\\partial ", generate::TeX(op(t,[i,1])^op(t,[i,2])))
                  $ i=1..nops(t));

      if nops(l) = 1 then 
        res := "\\frac{\\partial"
      else
        res := "\\frac{\\partial^".generate::TeX(nops(l))
      end_if;
      generate::TeXquote(res."}{".t."} ".
                         generate::tex(op(args(2),1), 135), args(3), 135)
    end_proc:

D::TeX := proc()
          begin
            generate::TeXquote(
              if nops(args(2)) = 1 then
                "D ".generate::tex(op(args(2),1), 135)
              else
                generate::TeX(hold(_index)(hold(D), op(op(args(2),1))))." ".
                generate::tex(op(args(2),2), 135)
              end_if, args(3), 135);
            end_proc:

int::TeX := proc()
            begin
              generate::TeXquote(
    	          if type(op(args(2),2)) = "_equal" then
    	            _concat("\\int_{", generate::tex(op(args(2),[2,2,1]),0),
    	                    "}^{", generate::tex(op(args(2),[2,2,2]),0), "} ",
    	                    generate::tex(op(args(2),1),0),
    	                    " d ", generate::tex(op(args(2),[2,1]),140))
             	 else
    	            _concat("\\int ", generate::tex(op(args(2),1),0),
    	                    " d ", generate::tex(op(args(2),2),140))
                end_if, args(3), 140);
              end_proc:
    	 
sum::TeX := proc()
            begin
              generate::TeXquote(
    	          if type(op(args(2),2)) = "_equal" then
    	            _concat("\\sum_{", generate::tex(op(args(2),[2,1])=op(args(2),[2,2,1]),0),
    	                    "}^{", generate::tex(op(args(2),[2,2,2]),0), "} ",
    	                    generate::tex(op(args(2),1),125))
    	          else
    	            _concat("\\sum_{", generate::tex(op(args(2),2),0), "} ",
    	    	              generate::tex(op(args(2),1),125))
    	          end_if, args(3), 125);
            end_proc:
              
_index::TeX :=
  proc()
    local s, i;
  begin
    s:= generate::TeXseq("", "", op(args(2),i) $ i=2..nops(args(2)));
    if length(s) <> 1 then s:= "{".s."}" end_if;
    generate::TeXquote(generate::tex(op(args(2),1), 200)."_".s, args(3), 200)
  end_proc:

_not::TeX :=
    () -> generate::TeXquote("\\neg ".generate::tex(op(args(2),1),180),
                             args(3), 180):

/* remove comment if you prefer e^x instead of exp(x)...
exp::TeX :=
    ()->_power::TeX(exp, hold(_power)(hold(e), op(args(2),1)),
    			       args(3)):
*/

_stmtseq::TeX   := () -> generate::TeXoperator("; ", args(3), 10, op(args(2))):
_exprseq::TeX   := () -> generate::TeXoperator(", ", args(3), 20, op(args(2))):
_or::TeX        := () -> generate::TeXoperator(" \\vee ", args(3), 30,
                                               op(args(2))):
_and::TeX       := () -> generate::TeXoperator(" \\wedge ", args(3), 40,
                                               op(args(2))):
_less::TeX      := () -> generate::TeXoperator(" < ", args(3), 60,
                                               op(args(2))):
_leequal::TeX   := () -> generate::TeXoperator(" \\leq ", args(3), 60,
                                               op(args(2))):
_equal::TeX     := () -> generate::TeXoperator(" = ", args(3), 60,
                                               op(args(2))):
_unequal::TeX   := () -> generate::TeXoperator(" \\neq ", args(3), 60,
                                               op(args(2))):
_range::TeX     := () -> generate::TeXoperator(" \\ldots ", args(3), 70,
                                               op(args(2))):
_mod::TeX       := () -> generate::TeXoperator(" \\mbox{mod} ", args(3), 80,
                                               op(args(2))):
_div::TeX       := () -> generate::TeXoperator(" \\mbox{div} ", args(3), 80,
                                               op(args(2))):
_union::TeX     := () -> generate::TeXoperator(" \\cup ", args(3), 90,
                                               op(args(2))):
_minus::TeX     := () -> generate::TeXoperator(" \\setminus ", args(3), 100,
                                               op(args(2))):
_intersect::TeX := () -> generate::TeXoperator(" \\cap ", args(3), 110,
                                               op(args(2))):
_fconcat::TeX   := () -> generate::TeXoperator(" \\circ ", args(3), 140,
                                               op(args(2))):
_concat::TeX    := () -> generate::TeXoperator(" \\cdot ", args(3), 170,
                                               op(args(2))):

piecewise:
piecewise::TeX :=
proc(pw)
begin
  "\\left\\{\n\\begin{array}{ll}\n".
  _concat((generate::TeX(piecewise::expression(pw,i))." & \\mbox{if}\\, ".
          generate::TeX(piecewise::condition(pw, i))."\\\\\n") $i=1..extnops(pw)).
  "\\end{array}\n\\right."
end_proc:

_in:
_in::TeX:= (arg1, arg2, arg3) -> generate::TeXoperator("\\in ", arg3, 60, op(arg2)):

Series::Puiseux:
Series::Puiseux::TeX := x -> generate::TeX(Series::Puiseux::print(x)):
end_proc():

// end of file 
