/**
  generate::isNeg  :  

  Domains with own representation which may contain signed values
  have to provide a isNeg method in order to produce good looking 
  outputs.  It order to check some operands of an element these
  methods may call this function.


  WARNING:  This is a library equivalent of an internal kernel
            function.  Changes have to be done in MIO_is_neg as
            well !!!
*/
generate::isNeg :=
proc(x) : DOM_BOOL
  local isneg, re, negate;
  option noDebug;
begin
  negate := x::dom::_negate;
  if (isneg := x::dom::isNeg) <> FAIL and negate <> FAIL then
    return(isneg(x));
  end_if;
  
  case domtype(x)
    of DOM_INT do
    of DOM_RAT do
    of DOM_FLOAT do
       return(bool(x<0));
       break;

    of DOM_COMPLEX do
       re := op(x,1);
       if re <> 0 then
         return(bool(re<0));
       else
         return(bool(op(x,2)<0));
       end_if;
       break;

    of DOM_EXPR do
       case type(x) 
           of "_negate" do
               return(TRUE);
	       break;

           of "_plus" do
               return(_and(map(op(x), generate::isNeg)));
	       break;

	   of "_mult" do
	       if contains({DOM_COMPLEX, DOM_FLOAT, DOM_INT, DOM_RAT}, 
			   domtype(op(x, nops(x)))) then
		  return(generate::isNeg(op(x, nops(x))));
               end_if;
	       if contains({DOM_COMPLEX, DOM_FLOAT, DOM_INT, DOM_RAT}, 
			   domtype(op(x, 1))) then
		  return(generate::isNeg(op(x, 1)));
               end_if;
               return(FALSE);
               break;
       end_case;
   end_case;
   FALSE
end_proc:


/*--
generate::sortSum  --  rearranges the succession of the summands in
                       a sum. The first summand is positive if
                       possible. 

generate::sortSum( SUM )

       SUM  --   a "_plus"- expression

Puts the first nonnegative summand in the first position of
the sum.

>> -a*b*3-c*d*(-2);

                              - 3 a b + 2 c d

>> generate::sortSum(%);

                               2 c d - 3 a b

This function is used by the kernel, by generate::TeX and by the
typesetting system for determining the output order of terms of a
_plus-expression.

--*/

generate::sortSum :=
proc(SuM)
  local i, list, lastOp;
//  option noDebug;
begin
  if testargs() then
    if not testtype(SuM, "_plus") then
      error("\"_plus\"-expression expected");
    end_if;
  end_if;
  if nops(SuM) = 1 then
    return(SuM);
  end_if;
  list := [op(SuM)];
  lastOp := op(list, nops(list));
  if domtype(lastOp) = DOM_COMPLEX and op(lastOp, 1) <> 0 then
    list := [op(SuM, 1..nops(list)-1), op(lastOp,1), I*op(lastOp,2)]
  end_if;
  if generate::isNeg( op(list,1)) then
    for i from 2 to nops(list) do
      if not generate::isNeg(op(list, i)) then
        return(hold(_plus) (op(subsop(list, 1=op(list, i), i=op(list, 1)))));
      end_if;
    end_for;
  end_if;
  hold(_plus)(op(list));
end_proc:

