
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : modify.scm
;; DESCRIPTION : routines for modifying a document
;; COPYRIGHT   : (C) 2001  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; General subroutines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (insert-object obj)
  (insert (object->tree obj)))

(define (make-expand-arg s)
  (make-expand-arity s 1))

(define (make-inactive name nrargs)
  (make-deactivated name nrargs name))

(define (make-inactive-arg name arg nrargs)
  (make-deactivated-arg name nrargs name arg))

(define (make-inactive-message name nrargs message)
  (make-deactivated name nrargs message))

(define (make-inactive-apply-arg s)
  (make-inactive-apply)
  (insert-string s)
  (insert-argument)
  (set-message "Press <Return> to activate" s))

(define (make-inactive-apply-args s n)
  (make-inactive "apply" n)
  (insert-string s)
  (insert-argument)
  (set-message "Press <Return> to activate" s))

(define (make-line-with var val)
  (if (not (selection-active-normal?))
      (select-line))
  (make-with var val)
  (insert-return)
  (remove-backwards))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Routines for formatting markup
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (make-inactive-surround) (make-inactive "surround" 3))
(define (make-inactive-group) (make-inactive "group" 1))
(define (make-inactive-float) (make-inactive "float" 3))
(define (make-inactive-repeat) (make-inactive "repeat" 2))
(define (make-inactive-decorate-atoms) (make-inactive "datoms" 2))
(define (make-inactive-decorate-lines) (make-inactive "dlines" 2))
(define (make-inactive-decorate-pages) (make-inactive "dpages" 2))

(define (make-page-break)
  (make-format "page break")
  (insert-return))

(define (make-new-page)
  (make-format "new page")
  (insert-return))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Routines for macro handling and main executable markup
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (make-inactive-assign) (make-inactive "assign" 2))
(define (make-inactive-with) (make-inactive "with" 3))
(define (make-inactive-var-expand) (make-inactive "var_expand" 1))
(define (make-inactive-expand) (make-inactive "expand" 1))
(define (make-inactive-apply) (make-inactive "apply" 1))
(define (make-inactive-include) (make-inactive "include" 1))
(define (make-inactive-macro) (make-inactive "macro" 1))
(define (make-inactive-function) (make-inactive "func" 1))
(define (make-inactive-eval) (make-inactive-message "eval" 1 "evaluate"))
(define (make-inactive-value) (make-inactive "value" 1))
(define (make-inactive-argument) (make-inactive-message "arg" 1 "argument"))
(define (make-inactive-quote) (make-inactive "quote" 1))
(define (make-inactive-delay) (make-inactive "delay" 1))
(define (make-inactive-hold) (make-inactive "hold" 1))
(define (make-inactive-release) (make-inactive "release" 1))

(define (make-include s) (insert-object `(include ,s)))
(define (make-tuple) (make-active "tuple" 1))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Routines for inserting computational markup
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (make-inactive-or) (make-inactive "or" 2))
(define (make-inactive-xor) (make-inactive "xor" 2))
(define (make-inactive-and) (make-inactive "and" 2))
(define (make-inactive-not) (make-inactive "not" 1))
(define (make-inactive-plus) (make-inactive "plus" 2))
(define (make-inactive-minus) (make-inactive "minus" 2))
(define (make-inactive-times) (make-inactive "times" 2))
(define (make-inactive-over) (make-inactive "over" 2))
(define (make-inactive-div) (make-inactive "div" 2))
(define (make-inactive-mod) (make-inactive "mod" 2))
(define (make-inactive-merge) (make-inactive "merge" 2))
(define (make-inactive-length) (make-inactive "length" 1))
(define (make-inactive-range) (make-inactive "range" 3))
(define (make-inactive-number) (make-inactive "number" 2))
(define (make-inactive-date) (make-inactive "date" 1))
(define (make-inactive-translate) (make-inactive "translate" 3))
(define (make-inactive-is-tuple) (make-inactive "is_tuple" 1))
(define (make-inactive-look-up) (make-inactive "look_up" 2))
(define (make-inactive-equal) (make-inactive "equal" 2))
(define (make-inactive-unequal)
  (make-inactive-message "unequal" 2 "not equal"))
(define (make-inactive-less) (make-inactive "less" 2))
(define (make-inactive-lesseq)
  (make-inactive-message "lesseq" 2 "less or equal"))
(define (make-inactive-greater) (make-inactive "greater" 2))
(define (make-inactive-greatereq)
  (make-inactive-message "greatereq" 2 "greater or equal"))
(define (make-inactive-if) (make-inactive "if" 2))
(define (make-inactive-case) (make-inactive "case" 2))
(define (make-inactive-for) (make-inactive "for" 4))
(define (make-inactive-while) (make-inactive "while" 2))
(define (make-inactive-extern) (make-inactive "extern" 2))
(define (make-inactive-authorize) (make-inactive "authorize" 2))

(define (make-date)
  (if (equal? (get-env "language") "english")
      (insert-tree (object->tree '(date "%B %d, %Y")))
      (insert-tree (object->tree '(date "%d %B %Y")))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Routines for inserting miscellaneous content
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (make-inactive-symbol) (make-inactive "symbol" 1))
(define (make-inactive-latex)
  (make-inactive "latex" 1)
  (set-message "Type a latex command followed by return" "latex"))
(define (make-inactive-hybrid)
  (make-inactive "hybrid" 1)
  (set-message
   "tab: insert argument, return: activate or execute latex command"
   "hybrid"))
(define (make-inactive-label) (make-inactive "label" 1))
(define (make-inactive-reference) (make-inactive "reference" 1))
(define (make-inactive-pageref) (make-inactive "pageref" 1))
(define (make-inactive-write) (make-inactive "write" 1))
(define (make-inactive-action) (make-inactive "action" 2))
(define (make-inactive-specific s) (make-inactive-arg "specific" s 2))
(define (make-inactive-hyperlink) 
  (make-inactive-message "hlink" 2 "hyperlink"))
(define (make-inactive-tag) (make-inactive "tag" 2))
(define (make-inactive-meaning) (make-inactive "meaning" 2))
(define (make-inline-image l)
  (eval (cons 'make-postscript (cons (car l) (cons #f (cdr l))))))
(define (make-link-image l)
  (eval (cons 'make-postscript (cons (car l) (cons #t (cdr l))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Making titles
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (make-title-expand s)
  (if (inside? "address") (go-end-of "address"))
  (go-end-line)
  (insert-return)
  (make-expand-arg s))

(define (make-title-apply s)
  (if (inside? "address") (go-end-of "address"))
  (go-end-line)
  (make-inactive-apply-arg s))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The multi-purpose return key
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (return-inside-table)
  (let ((x (inside-which '("table" "document"))))
    (if (equal? x "document")
	(insert-return)
	(begin
	  (table-insert-row #t)
	  (table-go-to (table-which-row) 1)))))

(define (make-return-inside x)
  (cond ((equal? x "item*") (go-end-of "item*"))
	((equal? x "equation") (go-end-of "equation") (insert-return))
	((equal? x "input") (process-input))
	((equal? x "table") (return-inside-table))
	((in? x '("itemize" "itemize-minus" "itemize-dot" "itemize-arrow"
		  "enumerate" "enumerate-numeric" "enumerate-roman"
		  "enumerate-Roman" "enumerate-alpha" "enumerate-Alpha"
		  "description")) (make-item))
	(else (insert-return))))

(define (make-return)
  (cond ((is-deactivated?) (activate))
	((inside-section?) (go-end-line) (insert-return))
	(else (make-return-inside
	       (inside-which
		'("item*" "equation" "equation*" "table" "input"
		  "itemize" "itemize-minus" "itemize-dot" "itemize-arrow"
		  "enumerate" "enumerate-numeric" "enumerate-roman"
		  "enumerate-Roman" "enumerate-alpha" "enumerate-Alpha"
		  "description"))))))
