
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : maxima.scm
;; DESCRIPTION : Special support for maxima
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Specific conversion routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (maxima-input-var-row r)
  (if (not (null? r))
      (begin
	(display ", ")
	(cas-input (car r))
	(maxima-input-var-row (cdr r)))))

(define (maxima-input-row r)
  (display "[")
  (cas-input (car r))
  (maxima-input-var-row (cdr r))
  (display "]"))

(define (maxima-input-var-rows t)
  (if (not (null? t))
      (begin
	(display ", ")
	(maxima-input-row (car t))
	(maxima-input-var-rows (cdr t)))))

(define (maxima-input-rows t)
  (display "matrix(")
  (maxima-input-row (car t))
  (maxima-input-var-rows (cdr t))
  (display ")"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Initialization
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(connection-declare "maxima" "tm_maxima")
(connection-format "maxima" "verbatim" "generic")
(connection-filter-in "maxima" "filter-maxima-in")
(set! session-menu (menu-merge session-menu
  '(("maxima" (make-session "maxima" "default")))))
(set! texmacs-session-help-icons (menu-merge texmacs-session-help-icons
  '(if (and (equal? (get-env "prog language") "maxima")
	    (file-exists? "$MAXIMA_DIRECTORY/info" "maxima_toc.html"))
       |
       ((balloon (icon "tm_help.xpm") "Maxima manual")
	(load-html-buffer "$MAXIMA_DIRECTORY/info/maxima_toc.html")))))
    
(define (in-maxima?) (equal? (get-env "prog language") "maxima"))

(set! cas-input-current-cas "maxima")
(cas-input-set! 'rows maxima-input-rows)
(display "")
