
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : emacs.scm
;; DESCRIPTION : emacs control keys
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (kill-line)
  (selection-set-start)
  (go-end-line)
  (selection-set-end)
  (cut "primary"))

(define (replace-start-forward what by)
  (replace-start what by #t))

(set-keymap (always?)
  ("C-c" "" "emacs mode specific prefix command")
  ("C-x" "" "emacs prefix command")

  ("C-a" (go-start-line))
  ("C-b" (go-left))
  ("C-d" (remove-forwards))
  ("C-e" (go-end-line))
  ("C-f" (go-right))
  ("C-g" (selection-cancel))
  ("C-j" (insert-return))
  ("C-k" (kill-line))
  ("C-l" (recenter-window))
  ("C-m" (insert-return))
  ("C-n" (go-down))
  ("C-o" (open-line))
  ("C-p" (go-up))
  ("C-q" (make-inactive-symbol))
  ("C-r" (search-start #f))
  ("C-s" (search-start #t))
  ("C-t" (transpose-chars))
  ("C-v" (go-page-up))
  ("C-w" (cut "primary"))
  ("C-y" (paste "primary"))
  ("C-insert" (copy "primary"))
  ("C-\\" (toggle-input-method))
  ("C-]" (abort-recursive-edit))
  ("C-_" (undo))
  ("C-/" (undo))
  ("C-space" (selection-set-start) (select-from-keyboard #t))
  ("C-=" (interactive '("Replace:" "Replace by:") 'replace-start-forward))

  ("C-x k" (kill-buffer))
  ("C-x C-c" (safely-quit-TeXmacs))
  ("C-x C-f" (interactive '("File name:") 'load-buffer))
  ("C-x C-s" (save-buffer))
  ("C-x C-w" (interactive '("Save as:") 'save-buffer)))
