
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : keymaps.scm
;; DESCRIPTION : setup shorthands for many mathematical symbols
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(set-keymap (in-math?)
  ("E-E-l" "" "Insert a large left delimiter")
  ("E-E-m" "" "Insert a large separator")
  ("E-E-r" "" "Insert a large right delimiter")
  ("E-E-@" "" "Insert a big circled operator")
  ("E-E-L" "" "Insert an integral with limits")
  ("E-L" "" "Insert a left script")

  ("(" "(")
  (")" ")")
  ("[" "[")
  ("]" "]")
  ("{" "{")
  ("}" "}")
  ("| ," "<lfloor>")
  ("| '" "<lceil>")
  ("| acute" "<lceil>")
  (", |" "<rfloor>")
  ("' |" "<rceil>")
  ("acute |" "<rceil>")
  ("[ [ *" "<llbracket>")
  ("] ] *" "<rrbracket>")

  ("A-a" "<alpha>")
  ("A-b" "<beta>")
  ("A-g" "<gamma>")
  ("A-d" "<delta>")
  ("A-e" "<varepsilon>")
  ("A-e *" "<epsilon>")
  ("A-e * *" "<backepsilon>")
  ("A-z" "<zeta>")
  ("A-h" "<eta>")
  ("A-q" "<theta>")
  ("A-q *" "<vartheta>")
  ("A-j" "<theta>")
  ("A-j *" "<vartheta>")
  ("A-i" "<iota>")
  ("A-k" "<kappa>")
  ("A-k *" "<varkappa>")
  ("A-l" "<lambda>")
  ("A-m" "<mu>")
  ("A-n" "<nu>")
  ("A-x" "<xi>")
  ("A-o" "<omicron>")
  ("A-p" "<pi>")
  ("A-p *" "<varpi>")
  ("A-r" "<rho>")
  ("A-r *" "<varrho>")
  ("A-s" "<sigma>")
  ("A-s *" "<varsigma>")
  ("A-t" "<tau>")
  ("A-u" "<upsilon>")
  ("A-f" "<varphi>")
  ("A-f *" "<phi>")
  ("A-y" "<psi>")
  ("A-c" "<chi>")
  ("A-w" "<omega>")
  ("A-w *" "<mho>")
  ("A-v" "<omega>")
  ("A-v *" "<mho>")

  ("A-A" "<Alpha>")
  ("A-B" "<Beta>")
  ("A-G" "<Gamma>")
  ("A-D" "<Delta>")
  ("A-E" "<Epsilon>")
  ("A-E *" "<Backepsilon>")
  ("A-Z" "<Zeta>")
  ("A-H" "<Eta>")
  ("A-Q" "<Theta>")
  ("A-J" "<Theta>")
  ("A-I" "<Iota>")
  ("A-K" "<Kappa>")
  ("A-L" "<Lambda>")
  ("A-M" "<Mu>")
  ("A-N" "<Nu>")
  ("A-X" "<Xi>")
  ("A-O" "<Omicron>")
  ("A-P" "<Pi>")
  ("A-R" "<Rho>")
  ("A-S" "<Sigma>")
  ("A-T" "<Tau>")
  ("A-U" "<Upsilon>")
  ("A-F" "<Phi>")
  ("A-Y" "<Psi>")
  ("A-C" "<Chi>")
  ("A-W" "<Omega>")
  ("A-W *" "<Mho>")
  ("A-V" "<Omega>")
  ("A-V *" "<Mho>")

  ("E-E-a" "<amalg>")
  ("E-E-d" "<partial>")
  ("E-E-p" "<wp>")
  ("E-E-n" "<cap>")
  ("E-E-n *" "<sqcap>")
  ("E-E-u" "<cup>")
  ("E-E-u *" "<sqcup>")
  ("E-E-w" "<wedge>")
  ("E-E-w *" "<curlywedge>")
  ("E-E-w * *" "<curlywedgeuparrow>")
  ("E-E-w * * *" "<curlywedgedownarrow>")
  ("E-E-w * * * *" "<wedges>")
  ("E-E-v" "<vee>")
  ("E-E-v *" "<curlyvee>")
  ("E-E-v * *" "<curlyveeuparrow>")
  ("E-E-v * * *" "<curlyveedownarrow>")
  ("E-E-x" "<times>")

  ("<" "<less>")
  (">" "<gtr>")
  ("< /" "<nless>")
  ("> /" "<ngtr>")
  ("< =" "<leqslant>")
  ("> =" "<geqslant>")
  ("< = /" "<nleqslant>")
  ("> = /" "<ngeqslant>")
  ("< = *" "<leq>")
  ("> = *" "<geq>")
  ("< = * /" "<nleq>")
  ("> = * /" "<ngeq>")
  ("< <" "<ll>")
  ("< < <" "<lll>")
  ("> >" "<gg>")
  ("> > >" "<ggg>")
  ("< < =" "<lleq>")
  ("< < < =" "<llleq>")
  ("> > =" "<ggeq>")
  ("> > > =" "<gggeq>")
  ("< < /" "<nll>")
  ("< < < /" "<nlll>")
  ("> > /" "<ngg>")
  ("> > > /" "<nggg>")
  ("< < = /" "<nlleq>")
  ("< < < = /" "<nllleq>")
  ("> > = /" "<nggeq>")
  ("> > > = /" "<ngggeq>")
  ("< ." "<lessdot>")
  (". >" "<gtrdot>")
  ("< = ." "<lesseqdot>")
  (". > =" "<gtreqdot>")

  ("< *" "<prec>")
  ("> *" "<succ>")
  ("< * /" "<nprec>")
  ("> * /" "<nsucc>")
  ("< * =" "<preccurlyeq>")
  ("> * =" "<succcurlyeq>")
  ("< * = /" "<npreccurlyeq>")
  ("> * = /" "<nsucccurlyeq>")
  ("< * = *" "<preceq>")
  ("> * = *" "<succeq>")
  ("< * = * /" "<npreceq>")
  ("> * = * /" "<nsucceq>")
  ("< * = * / *" "<precneqq>")
  ("> * = * / *" "<succneqq>")
  ("< < *" "<precprec>")
  ("< < < *" "<precprecprec>")
  ("> > *" "<succsucc>")
  ("> > > *" "<succsuccsucc>")
  ("< < * =" "<precpreceq>")
  ("< < < * =" "<precprecpreceq>")
  ("> > * =" "<succsucceq>")
  ("> > > * =" "<succsuccsucceq>")
  ("< < * /" "<nprecprec>")
  ("< < < * /" "<nprecprecprec>")
  ("> > * /" "<nsuccsucc>")
  ("> > > * /" "<nsuccsuccsucc>")
  ("< < * = /" "<nprecpreceq>")
  ("< < < * = /" "<nprecprecpreceq>")
  ("> > * = /" "<nsuccsucceq>")
  ("> > > * = /" "<nsuccsuccsucceq>")
  ("< * ." "<precdot>")
  (". > *" "<dotsucc>")
  ("< * = ." "<preceqdot>")
  (". > * =" "<dotsucceq>")
  ("< < * *" "<llangle>")
  ("> > * *" "<rrangle>")

  ("< >" "<lessgtr>")
  ("> <" "<gtrless>")
  ("< ~" "<lesssim>")
  ("< ~ ~" "<lessapprox>")
  ("< * ~" "<precsim>")
  ("< * ~ ~" "<precapprox>")
  ("> ~" "<gtrsim>")
  ("> ~ ~" "<gtrapprox>")
  ("> * ~" "<gtrsim>")
  ("> * ~ ~" "<gtrapprox>")
  ("< = * *" "<leqq>")
  ("> = * *" "<geqq>")
  ("< = * >" "<lesseqgtr>")
  ("> = * <" "<gtreqless>")
  ("< = * * >" "<lesseqqgtr>")
  ("> = * * <" "<gtreqqless>")
  ("< > /" "<nlessgtr>")
  ("> < /" "<ngtrless>")
  ("< ~ /" "<nlesssim>")
  ("< ~ / *" "<lnsim>")
  ("< ~ ~ /" "<nlessapprox>")
  ("< ~ ~ / *" "<lnapprox>")
  ("< * ~ /" "<nprecsim>")
  ("< * ~ / *" "<precnsim>")
  ("< * ~ ~ /" "<nprecapprox>")
  ("< * ~ ~ / *" "<precnapprox>")
  ("> ~ /" "<ngtrsim>")
  ("> ~ / *" "<gnsim>")
  ("> ~ ~ /" "<ngtrapprox>")
  ("> ~ ~ / *" "<gnapprox>")
  ("> * ~ /" "<nsuccsim>")
  ("> * ~ / *" "<succnsim>")
  ("> * ~ ~ /" "<nsuccapprox>")
  ("> * ~ ~ / *" "<succnapprox>")
  ("< = * * /" "<nleqq>")
  ("> = * * /" "<ngeqq>")
  ("< = * > /" "<nlesseqgtr>")
  ("> = * < /" "<ngtreqless>")
  ("< = * * > /" "<nlesseqqgtr>")
  ("> = * * < /" "<ngtreqqless>")
  ("< = * / *" "<lneq>")
  ("< = * * / *" "<lneqq>")
  ("< = * * / * *" "<lvertneqq>")
  ("> = * / *" "<gneq>")
  ("> = * * / *" "<gneqq>")
  ("> = * * / * *" "<gvertneqq>")

  ("- >" "<rightarrow>")
  ("< -" "<leftarrow>")
  ("< - >" "<leftrightarrow>")
  ("- - >" "<longrightarrow>")
  ("< - -" "<longleftarrow>")
  ("< - - >" "<longleftrightarrow>")
  ("= >" "<Rightarrow>")
  ("< = * * *" "<Leftarrow>")
  ("< = >" "<Leftrightarrow>")
  ("= = >" "<Longrightarrow>")
  ("< = =" "<Longleftarrow>")
  ("< = = >" "<Longleftrightarrow>")
  ("| - >" "<mapsto>")
  ("| - - >" "<longmapsto>")
  ("< - |" "<mapsfrom>")
  ("< - - |" "<longmapsfrom>")
  ("| - > *" "<hookrightarrow>")
  ("< - | *" "<hookleftarrow>")
  ("~ >" "<rightsquigarrow>")
  ("< ~ >" "<leftrightsquigarrow>")
  ("< - <" "<leftarrowtail>")
  ("> - >" "<rightarrowtail>")
  ("- > - >" "<rightrightarrows>")
  ("< - < -" "<leftleftarrows>")
  ("- > < -" "<rightleftarrows>")
  ("- > < - *" "<rightleftharpoons>")
  ("< - - > *" "<leftrightarrows>")
  ("< - - > * *" "<leftrightharpoons>")
  ("- > >" "<twoheadrightarrow>")
  ("< < -" "<twoheadleftarrow>")
  ("- - > >" "<longtwoheadrightarrow>")
  ("< < - -" "<longtwoheadleftarrow>")
  ("- > /" "<nrightarrow>")
  ("< - /" "<nleftarrow>")
  ("< - > /" "<nleftrightarrow>")
  ("= > /" "<nRightarrow>")
  ("< = * * * /" "<nLeftarrow>")
  ("< = > /" "<nLeftrightarrow>")
  ("< - > -" "<leftrightarroweq>")
  ("- | >" "<rightarrowtriangle>")
  ("< | -" "<leftarrowtriangle>")
  ("< | - | >" "<leftrightarrowtriangle>")
  ("| - | >" "<longmapstotriangle>")
  ("- - | >" "<longrightarrowtriangle>")
  ("< | - -" "<longleftarrowtriangle>")
  ("< | - - | >" "<longleftrightarrowtriangle>")
  ("| - - | >" "<longmapstotriangle>")
  ("< - < *" "<leftprec>")
  ("> * - >" "<succright>")
  ("< - < * =" "<leftpreceq>")
  ("> * = - >" "<succeqright>")

  ("@" "<circ>")
  ("@ /" "<varnothing>")
  ("@ +" "<oplus>")
  ("@ -" "<ominus>")
  ("@ x" "<otimes>")
  ("@ :" "<oover>")
  ("@ ." "<odot>")
  ("@ R" "<circledR>")
  ("@ S" "<circledS>")
  ("@ / *" "<oslash>")
  ("@ \\" "<obslash>")
  ("@ <" "<olessthan>")
  ("@ >" "<ogreaterthan>")
  ("@ &" "<owedge>")
  ("@ |" "<obar>")
  ("@ | *" "<ovee>")
  ("@ v" "<ovee>")
  ("@ @" "<infty>")
  ("@ @ *" "<varocircle>")
  ("- @ @" "-<infty>")
  ("@ *" "<box>")
  ("@ * +" "<boxplus>")
  ("@ * -" "<boxminus>")
  ("@ * x" "<boxtimes>")
  ("@ * ." "<boxdot>")
  ("@ * /" "<boxslash>")
  ("@ * \\" "<boxbslash>")
  ("@ * @" "<boxcircle>")
  ("@ * @ *" "<boxbox>")
  ("@ * |" "<boxbar>")
  ("@ * *" "<bullet>")
  ("@ * * *" "<blacksquare>")

  ("= *" "<asymp>")
  ("= * *" "<equiv>")
  ("= * * *" "<asympasymp>")
  ("= * * * *" "<simsim>")
  ("~" "<sim>")
  ("~ ~" "<approx>")
  ("~ ~ -" "<approxeq>")
  ("~ -" "<simeq>")
  ("~ =" "<cong>")
  ("= /" "<neq>")
  ("= * /" "<nasymp>")
  ("= * * /" "<nequiv>")
  ("= * * * /" "<nasympasymp>")
  ("= * * * * /" "<nsimsim>")
  ("~ /" "<nsim>")
  ("~ ~ /" "<napprox>")
  ("~ - /" "<nsimeq>")
  ("~ = /" "<ncong>")
    
  ("|" "|")
  ("| *" "<shortmid>")
  ("| * *" "<varshortmid>")
  ("| |" "<||>")
  ("| | |" "<interleave>")
  ("| | *" "<shortparallel>")
  ("| -" "<vdash>")
  ("| - -" "<longvdash>")
  ("| | -" "<Vdash>")
  ("| | - -" "<longVdash>")
  ("| | | -" "<Vvdash>")
  ("| | | - -" "<longVvdash>")
  ("- |" "<dashv>")
  ("- - |" "<longdashv>")
  ("| =" "<vDash>")
  ("| = =" "<longvDash>")
  ;; ("| | =" "<VDash>")
  ;; ("| | = =" "<longVDash>")
  ("| /" "<nmid>")
  ("| | /" "<nparallel>")
  ("| * /" "<nshortmid>")
  ("| | * /" "<nshortparallel>")
  ("| - /" "<nvdash>")
  ("| | - /" "<nVdash>")
  ;; ("- | /" "<ndashv>")
  ;; ("- | | /" "<ndashV>")
  ("| = /" "<nvDash>")
  ;; ("| | = /" "<nVDash>")
  ;; ("= | /" "<nDashv>")
  ;; ("= | | /" "<nDashV>")
    
  ("< |" "<vartriangleleft>")
  ("< | *" "<blacktriangleleft>")
  ("< | /" "<ntriangleleft>")
  ("< | =" "<trianglelefteqslant>")
  ("< | = /" "<ntrianglelefteqslant>")
  ("< | = *" "<trianglelefteq>")
  ("< | = * /" "<ntriangleqleft>")
  ("| >" "<vartriangleright>")
  ("| > *" "<blacktriangleright>")
  ("| > /" "<ntriangleright>")
  ("| > =" "<trianglerighteq>")
  ("| > = /" "<ntriangleqright>")
  ("| > = *" "<trianglerighteqslant>")
  ("| > = * /" "<ntrianglerighteqslant>")
    
  ("- *" "<um>")
  ("+ -" "<pm>")
  ("+ - *" "<upm>")
  ("- +" "<mp>")
  ("- + *" "<ump>")
  ("@ =" "<circeq>")
  ("= @" "<eqcirc>")
  ("- @" "<multimap>")
  (". =" "<doteq>")
  (". ." "<ldots>")
  (". . *" "<cdots>")
  (". . * *" "<hdots>")
  (". . * * *" "<vdots>")
  (". . * * * *" "<ddots>")
  (". . * * * * *" "<udots>")
  (": =" "<assign>")
  ("+ =" "<plusassign>")
  ("- =" "<minusassign>")
  ("/ *" "<div>")
  ("* *" "<ast>")
  ("* * *" "<times>")
  ("* * * *" "<cdot>")

  ("< * *" "<subset>")
  ("> * *" "<supset>")
  ("< * * /" "<nsubset>")
  ("> * * /" "<nsupset>")
  ("< * * =" "<subseteq>")
  ("> * * =" "<supseteq>")
  ("< * * = /" "<nsubseteq>")
  ("> * * = /" "<nsupseteq>")
  ("< * * = *" "<subseteqq>")
  ("> * * = *" "<supseteqq>")
  ("< * * = /" "<nsubseteq>")
  ("> * * = /" "<nsupseteq>")
  ("< * * = * /" "<nsubseteqq>")
  ("> * * = * /" "<nsupseteqq>")
  ("< * * = / *" "<subsetneq>")
  ("> * * = / *" "<supsetneq>")
  ("< * * = / * *" "<varsubsetneq>")
  ("> * * = / * *" "<varsupsetneq>")
  ("< * * = * / *" "<subsetneqq>")
  ("> * * = * / *" "<supsetneqq>")
  ("< * * = * / * *" "<varsubsetneqq>")
  ("> * * = * / * *" "<varsupsetneqq>")
  ("< * * +" "<subsetplus>")
  ("> * * +" "<supsetplus>")
  ("< * * + =" "<subsetpluseq>")
  ("> * * + =" "<supsetpluseq>")
  ("< * * = +" "<subsetpluseq>")
  ("> * * = +" "<supsetpluseq>")
  ("< * * *" "<in>")
  ("> * * *" "<ni>")
  ("< * * * /" "<nin>")
  ("> * * * /" "<nni>")

  ("< * * * *" "<sqsubset>")
  ("> * * * *" "<sqsupset>")
  ("< * * * * /" "<nsqsubset>")
  ("> * * * * /" "<nsqsupset>")
  ("< * * * * =" "<sqsubseteq>")
  ("> * * * * =" "<sqsupseteq>")
  ("< * * * * = /" "<nsqsubseteq>")
  ("> * * * * = /" "<nsqsupseteq>")

  ("< * * * * *" "<langle>")
  ("> * * * * *" "<rangle>")
  ("< * * * * * *" "<leftslice>")
  ("> * * * * * *" "<rightslice>"))
