
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : icon-menu.scm
;; DESCRIPTION : the default icon menus of TeXmacs
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Main icons
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define texmacs-main-icons
  '((=> (balloon (icon "tm_new.xpm") "Open a new buffer")
	("new buffer" "E-F2" (new-buffer))
	("open new window" "E-S-F2" (open-window))
	("clone window" "E-C-F2" (clone-window)))
    (=> (balloon (icon "tm_open.xpm") "Load a file")
	("load buffer" "F2" (choose-file "Load file" "" 'load-buffer))
	("revert buffer" "C-F2" (revert-buffer))
	("load in new window" "S-F2"
	 (choose-file "Load file" "" 'load-in-new-window))
	---
	("import#verbatim"
	  (choose-file "Load verbatim file" "" 'load-verbatim-buffer))
	("import#html"
          (choose-file "Load html file" "html" 'load-html-buffer))
	("import#LaTeX"
          (choose-file "Load LaTeX file" "latex" 'load-latex-buffer))
	("import#scheme"
          (choose-file "Load scheme file" "scheme" 'load-scheme-buffer)))
    (=> (balloon (icon "tm_save.xpm") "Save this buffer")
	("save buffer" "F3" (save-buffer))
	("save buffer as" "S-F3"
	 (choose-file "Save TeXmacs file" "TeXmacs" 'save-buffer))
	---
	("export as#verbatim"
	  (choose-file "Save verbatim file" "" 'save-verbatim-buffer))
	("export as#LaTeX"
	  (choose-file "Save LaTeX file" "latex" 'save-latex-buffer))
	("export as#scheme"
	  (choose-file "Save scheme file" "scheme" 'save-scheme-buffer))
	("export as#postscript"
	  (choose-file "File postscript file" "postscript"
		       'export-postscript)))
    (=> (balloon (icon "tm_print.xpm") "Print") (link print-menu))
    (=> (balloon (icon "tm_style.xpm") "Select a document style")
	("no style" (init-style "none"))
	---
	(link style-menu)
	---
	("other style" (interactive '("Document style:") 'init-style)))
    (=> (balloon (icon "tm_language.xpm") "Select a language")
	("British"
	 (begin
	   (init-env "language" "british")
	   (set-output-language "british")))
	("Czech"
	 (begin
	   (init-env "language" "czech")
	   (set-output-language "czech")))
	("Dutch"
	 (begin
	   (init-env "language" "dutch")
	   (set-output-language "dutch")))
	("English"
	 (begin
	   (init-env "language" "english")
	   (set-output-language "english")))
	("French"
	 (begin
	   (init-env "language" "french")
	   (set-output-language "french")))
	("German"
	 (begin
	   (init-env "language" "german")
	   (set-output-language "german")))
	("Hungarian"
	 (begin
	   (init-env "language" "hungarian")
	   (set-output-language "hungarian")))
	("Polish"
	 (begin
	   (init-env "language" "polish")
	   (set-output-language "polish")))
	("Portuguese"
	 (begin
	   (init-env "language" "portuguese")
	   (set-output-language "portuguese")))
	("Romanian"
	 (begin
	   (init-env "language" "romanian")
	   (set-output-language "romanian")))
	("Russian"
	 (begin
	   (init-env "language" "russian")
	   (init-env "font" "cyrillic")
	   (set-output-language "russian")))
	("Spanish"
	 (begin
	   (init-env "language" "spanish")
	   (set-output-language "spanish")))
	("Swedish"
	 (begin
	   (init-env "language" "swedish")
	   (set-output-language "swedish"))))
    (=> (balloon (icon "tm_cancel.xpm") "Close")
	("close buffer" "C-x k" (kill-buffer))
	("close window" (kill-window))
	("close TeXmacs" "C-x C-c" (safely-quit-TeXmacs)))
    |
    ((balloon (icon "tm_cut.xpm") "Cut text#(E-x)") (cut "primary"))
    ((balloon (icon "tm_copy.xpm") "Copy text#(E-c)") (copy "primary"))
    ((balloon (icon "tm_paste.xpm") "Paste text#(E-p)") (paste "primary"))
    (if (not (in-search-mode?))
	((balloon (icon "tm_find.xpm") "Find text#(C-s)") (search-start #t)))
    (if (in-search-mode?)
	((balloon (icon "tm_find_next.xpm") "Find next match#(C-s)")
	  (search-button-next)))
    ((balloon (icon "tm_replace.xpm") "Query replace#(C-=)")
      (interactive '("Replace:" "Replace by:") 'replace-start-forward))
    ((balloon (icon "tm_spell.xpm") "Check text for spelling errors#(E-$)")
      (spell-start))
    ((balloon (icon "tm_undo.xpm") "Undo last changes#(E-[)") (undo))
    ((balloon (icon "tm_redo.xpm") "Redo undone changes#(E-])") (redo))
    |
    (=> (balloon (icon "tm_math.xpm") "Insert mathematics")
	(if (not (equal? (get-env "mode") "math"))
	    ("formula" "$" (make-with "mode" "math"))
	    (if (style-has? "basic-style")
		("equation"
		 (begin (make-big-expand "equation*") (temp-proof-fix)))
		("equations"
		 (begin (make-expand-arg "eqnarray*") (temp-proof-fix)))
		("numbered equation"
		 (begin (make-big-expand "equation") (temp-proof-fix)))))
	(if (equal? (get-env "mode") "math")
	    ("text" "E-$" (make-with "mode" "text"))))
    (=> (balloon (icon "tm_table.xpm") "Insert a table")
	(link insert-table-menu))
    (=> (balloon (icon "tm_image.xpm") "Insert a picture")
	(link insert-image-menu))
    (=> (balloon (icon "tm_link.xpm") "Insert a link")
	(link insert-link-menu))
    (if (style-has? "program-style")
	(=> (balloon (icon "tm_shell.xpm")
		     "Start an interactive session")
	    (link session-menu)
	    ---
	    ("other" (interactive
              '("Session type:" "Session name:") 'make-session))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Icons for text mode
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define texmacs-text-icons
  '((if (style-has? "book-style")
	(=> (balloon (icon "tm_chapter.xpm") "Start a new chapter")
	    ("chapter" "E-s 0" (make-section-arg "chapter"))
	    ("appendix" (make-section-arg "appendix"))
	    ("prologue" (make-section "prologue"))
	    ("epilogue" (make-section "epilogue"))))
    (if (style-has? "make-title")
	(if (inside? "make-title")
	    (=> (balloon (icon "tm_title.xpm") "Enter a title")
		("title" (make-title-expand "title"))
		("author" (make-title-expand "author"))
		("address" (make-title-expand "address"))
		("date" (make-title-expand "title-date"))
		---
		;;("running title" (make-title-apply "title*"))
		;;("running author" (make-title-apply "author*"))
		("address block" (make-expand-arg "address-block"))
		("today" (begin (make-title-expand "title-date")
				(make-date)))))
	(if (not (inside? "make-title"))
	    (=> (balloon (icon "tm_title.xpm") "Enter a title")
		("make title" (begin (make-big-expand "make-title")
				     (make-expand-arg "title")))
		("abstract" (make-big-expand "abstract")))))
    ;;(=> (balloon (icon "tm_title.xpm") "Enter a title")
    ;;("title" (make-inactive-apply-arg "title"))
    ;;("author" (make-inactive-apply-arg "author"))
    ;;("address" (make-inactive-apply-arg "address"))
    ;;("make title" (make-section "maketitle"))
    ;;---
    ;;("abstract" (make-big-expand "abstract"))))
    (if (style-has? "section")
	(=> (balloon (icon "tm_section.xpm") "Start a new section")
	    ("section" "E-s 1" (make-section-arg "section"))
	    ("subsection" "E-s 2" (make-section-arg "subsection"))
	    ("subsubsection" "E-s 3" (make-section-arg "subsubsection"))
	    (if (style-has? "paragraph")
		---
		("paragraph" "E-s 4" (make-section-arg "paragraph"))
		("subparagraph" "E-s 5" (make-section-arg "subparagraph")))))
    (if (style-has? "basic-style")
	(=> (balloon (icon "tm_theorem.xpm") "Insert an environment")
	    (if (style-has? "theorem-style")
		("theorem" (make-big-expand "theorem"))
		("proposition" (make-big-expand "proposition"))
		("lemma" (make-big-expand "lemma"))
		("corollary" (make-big-expand "corollary"))
		("proof" (make-big-expand "proof"))
		("axiom" (make-big-expand "axiom"))
		("definition" (make-big-expand "definition"))
		---
		("remark" (make-big-expand "remark"))
		("note" (make-big-expand "note"))
		("example" (make-big-expand "example"))
		("exercise" (make-big-expand "exercise"))
		("warning" (make-big-expand "warning"))
		---)
	    ("verbatim" (make-big-expand "verbatim"))
	    ("code" (make-big-expand "code"))
	    ("quote" (make-big-expand "quote"))
	    ("quotation" (make-big-expand "quotation"))
	    ("verse" (make-big-expand "verse"))))
    (=> (balloon (icon "tm_parstyle.xpm") "Set paragraph mode")
	((balloon (icon "tm_left.xpm") "Align text to the left")
	 (make-line-with "paragraph mode" "left"))
	((balloon (icon "tm_center.xpm") "Center text")
	 (make-line-with "paragraph mode" "center"))
	((balloon (icon "tm_right.xpm") "Align text to the right")
	 (make-line-with "paragraph mode" "right"))
	((balloon (icon "tm_justify.xpm") "Justify text")
	 (make-line-with "paragraph mode" "justify")))
    (=> (balloon (icon "tm_parindent.xpm") "Set paragraph margins")
	("left margin" (interactive '("Left margin:") 'set-left-margin))
	("right margin" (interactive '("Right margin:") 'set-right-margin))
	("first indentation"
	 (interactive '("First indentation:") 'set-first-indent)))
    (if (and (style-has? "float-style"))
	(if (not (inside? "float"))
	    (=> (balloon (icon "tm_pageins.xpm") "Make a page insertion")
		(link insert-page-insertion-menu)))
	(if (inside? "float")
	    (=> (balloon (icon "tm_floatpos.xpm") "Position floating object")
		(link position-float-menu))))
;;  ((balloon (icon "tm_footnote.xpm") "Insert a footnote") ())
;;  ((balloon (icon "tm_margin.xpm") "Insert a marginal note") ())
;;  ((balloon (icon "tm_floating.xpm") "Insert a floating object") ())
;;  ((balloon (icon "tm_multicol.xpm") "Start multicolumn context") ())
    (if (style-has? "automatic-style")
	(=> (balloon (icon "tm_index.xpm")
		     "Insert automatically generated content")
	    ("table of contents" (make-aux "table-of-contents" "toc"))
	    ("bibliography" (interactive
	      '("Bibliography style:" "Bibliography file:") 'make-bib))
	    ("index" (make-aux "the-index" "idx"))
	    ("glossary" (make-aux "the-glossary" "gly"))
;;	    ("list of figures" (make-aux "list-of-figures" "lof"))
;;	    ("list of tables" (make-aux "list-of-tables" "lot"))
	    ))
    (if (style-has? "list-style")
	|
	(=> (balloon (icon "tm_itemize.xpm") "Itemize")
	    ("default" "E-I" (make-list "itemize"))
	    ---
	    ("minus" (make-list "itemize-minus"))
	    ("dot" (make-list "itemize-dot"))
	    ("arrow" (make-list "itemize-arrow")))
	(=> (balloon (icon "tm_enumerate.xpm") "Enumerate")
	    ("default" "E-E" (make-list "enumerate"))
	    ---
	    ("1, 2, 3, ..." (make-list "enumerate-numeric"))
	    ("i, ii, iii, ..." (make-list "enumerate-roman"))
	    ("I, II, III, ..." (make-list "enumerate-Roman"))
	    ("a, b, c, ..." (make-list "enumerate-alpha"))
	    ("A, B, C, ..." (make-list "enumerate-Alpha")))
	((balloon (icon "tm_description.xpm") "Description#(E-D)")
	 (make-list "description"))
	(if (or (inside-list?) (inside-description?))
	    ((balloon (icon "tm_item.xpm") "Insert a new item#(E-N)")
	     (make-item))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Icons for math mode
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define texmacs-math-icons
  '(((balloon (icon "tm_fraction.xpm") "Insert a fraction#(E-F)")
      (make-fraction))
    ((balloon (icon "tm_sqrt.xpm") "Insert a square root#(E-S)")
      (make-sqrt))
    ((balloon (icon "tm_root.xpm") "Insert an n-th root#(E-R)")
      (make-var-sqrt))
    ((balloon (icon "tm_sub.xpm") "Make a subscript#(_)")
      (make-script #f #t))
    ((balloon (icon "tm_sup.xpm") "Make a superscript#(^)")
      (make-script #t #t))
    (=> (balloon (icon "tm_hat.xpm") "Insert an accent")
	((icon "tm_hat.xpm") "E-^" (make-wide "^"))
	((icon "tm_tilda.xpm") "E-~" (make-wide "~"))
	((icon "tm_bar.xpm") "E-B" (make-wide "<bar>"))
	((icon "tm_vect.xpm") "E-V" (make-wide "<vect>"))
	((icon "tm_check.xpm") "E-V" (make-wide "<check>"))
	((icon "tm_breve.xpm") "E-U" (make-wide "<breve>"))
	((icon "tm_dot.xpm") "E-." (make-wide "<dot>"))
	((icon "tm_ddot.xpm") "E-\"" (make-wide "<ddot>"))
	((icon "tm_acute.xpm") "E-'" (make-wide "<acute>"))
	((icon "tm_grave.xpm") "E-`" (make-wide "<grave>")))
    |
    (=> (balloon (icon "tm_bigop.xpm") "Insert a big operator")
	(tile 8 (link big-operator-menu)))
    (=> (balloon (icon "tm_bigleft.xpm") "Insert a large left delimiter")
	(tile 8 (link left-delimiter-menu)))
    (=> (balloon (icon "tm_bigsep.xpm") "Insert a large separator")
	(tile 8 (link middle-delimiter-menu)))
    (=> (balloon (icon "tm_bigright.xpm") "Insert a large right delimiter")
	(tile 8 (link right-delimiter-menu)))
    (=> (balloon (icon "tm_greek.xpm") "Insert a greek character")
	(tile 8 (link lower-greek-menu))
	---
	(tile 8 (link upper-greek-menu)))
    (=> (balloon (icon "tm_binop.xpm") "Insert a binary operation")
	(tile 8 (link binary-operation-menu)))
    (=> (balloon (icon "tm_binrel.xpm") "Insert a binary relation")
	(tile 8 (link binary-relation-menu-1))
	---
	(tile 8 (link binary-relation-menu-2)))
    (=> (balloon (icon "tm_arrow.xpm") "Insert an arrow")
	(tile 9 (link horizontal-arrow-menu))
	---
	(tile 8 (link vertical-arrow-menu))
	---
	(tile 6 (link long-arrow-menu)))
    (=> (balloon (icon "tm_miscsymb.xpm") "Insert a miscellaneous symbol")
	(tile 8 (link miscellaneous-symbol-menu))
	---
	(tile 6 (link dots-menu)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Icons for computer algebra sessions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define texmacs-session-icons
  '((if (in-cas-with-converters?)
	(=> (balloon (icon "tm_cas_input.xpm") "Input mode")
	    ("textual input" (session-use-math-input #f))
	    ("mathematical input" (session-use-math-input #t))))
    ((balloon (icon "tm_stop.xpm") "Interrupt execution")
      (connection-interrupt))
    ((balloon (icon "tm_clsession.xpm") "Close session")
      (connection-stop))
    (if (in-math?)
	|)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Icons for modifying text properties
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define texmacs-modifier-icons
  '(|
    (if (in-prog?)
	((balloon (icon "tm_bold.xpm") "Write bold text#(E-C-b)")
	 (make-with "prog font series" "bold"))
	((balloon (icon "tm_italic.xpm") "Write italic text#(E-C-i)")
	 (make-with "prog font shape" "italic"))
	((balloon (icon "tm_sansserif.xpm") "Use a sans serif font#(E-C-s)")
	 (make-with "prog font family" "ss")))
    (if (and (in-text?) (style-has? "basic-style"))
	;;((balloon
	;;(text (roman rm bold right 12 600) "S")
	;;"Write bold text#(E-C-b)")
	;;(make-with "font series" "bold"))
	((balloon (icon "tm_strong.xpm") "Write strong text#(E-s s)")
	 (make-expand-arg "strong"))
	((balloon (icon "tm_emphasize.xpm") "Emphasize text#(E-s e)")
	 (make-expand-arg "em"))
	((balloon (icon "tm_verbatim.xpm") "Write verbatim text#(E-s v)")
	 (make-expand-arg "verbatim"))
	((balloon (icon "tm_sansserif.xpm") "Write sample text#(E-s p)")
	 (make-expand-arg "samp"))
	((balloon (icon "tm_name.xpm") "Write a name#(E-s n)")
	 (make-expand-arg "name")))
    (if (and (in-text?) (not (style-has? "basic-style")))
	((balloon (icon "tm_bold.xpm") "Write bold text#(E-C-b)")
	 (make-with "font series" "bold"))
	((balloon (icon "tm_italic.xpm") "Write italic text#(E-C-i)")
	 (make-with "font shape" "italic"))
	((balloon (icon "tm_typewriter.xpm") "Use a typewriter font#(E-C-t)")
	 (make-with "font family" "tt"))
	((balloon (icon "tm_sansserif.xpm") "Use a sans serif font#(E-C-s)")
	 (make-with "font family" "ss"))
	((balloon (icon "tm_smallcaps.xpm") "Use small capitals#(E-C-p)")
	 (make-with "font shape" "small-caps")))
    (if (in-math?)
	((balloon (icon "tm_mathbold.xpm") "Write bold mathematics#(E-C-b)")
	 (make-with "math font series" "bold"))
	((balloon (icon "tm_cal.xpm") "Use a calligraphic font#(E-C-C)")
	 (make-with "math font" "cal"))
	((balloon (icon "tm_frak.xpm") "Use the fraktur font#(E-C-F)")
	 (make-with "math font" "Euler"))
	((balloon (icon "tm_bbb.xpm") "Use the blackboard bold font#(E-C-B)")
	 (make-with "math font" "Bbb*")))
    (=> (balloon (icon "tm_color.xpm") "Select a foreground color")
	(link color-menu))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Icons for manipulation of tables
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define texmacs-table-insert-icons
  '(((balloon (icon "tm_table_arow.xpm")
	      "Insert row above (E-up)")
     (table-insert-row #f))
    ((balloon (icon "tm_table_brow.xpm")
	      "Insert row below (E-down)")
     (table-insert-row #t))
    ((balloon (icon "tm_table_lcol.xpm")
	      "Insert column to the left (E-left)")
     (table-insert-column #f))
    ((balloon (icon "tm_table_rcol.xpm")
	      "Insert column to the right (E-right)")
     (table-insert-column #t))
    ---
    ((balloon (icon "tm_table_drow.xpm")
	      "Delete row (E-t h delete)")
     (table-delete-row #f))
    ((balloon (icon "tm_table_dcol.xpm")
	      "Delete column (E-t v delete)")
     (table-delete-column #f))))

(define texmacs-table-hpos-icons
  '(((balloon (icon "tm_table_left.xpm")
	      "Align table at the left (E-t H l)")
     (table-set-halign "l"))
    ((balloon (icon "tm_table_hcenter.xpm")
	      "Align table at the horizontal center (E-t H c)")
     (table-set-halign "c"))
    ((balloon (icon "tm_table_right.xpm")
	      "Align table to the right (E-t H r)")
     (table-set-halign "r"))
    ((icon "tm_empty.xpm") (noop))
    ((balloon (icon "tm_table_bleft.xpm")
	      "Align table at base of left column (E-t H L)")
     (table-set-halign "L"))
    ((balloon (icon "tm_table_bhcenter.xpm")
	      "Align table at base of middle column (E-t H C)")
     (table-set-halign "C"))
    ((balloon (icon "tm_table_bright.xpm")
	      "Align table at base of right column (E-t H R)")
     (table-set-halign "R"))
    ((balloon (icon "tm_table_hbase.xpm")
	      "Align table at base of origin column (E-t H O)")
     (table-set-halign "O"))))

(define texmacs-table-vpos-icons
  '(((balloon (icon "tm_table_bottom.xpm")
	      "Align table at the bottom (E-t V b)")
     (table-set-valign "b"))
    ((balloon (icon "tm_table_vcenter.xpm")
	      "Align table at the center (E-t V c)")
     (table-set-valign "c"))
    ((balloon (icon "tm_table_top.xpm")
	      "Align table at the top (E-t V t)")
     (table-set-valign "t"))
    ((balloon (icon "tm_table_vfrac.xpm")
	      "Align table at fraction bar height (E-t V f)")
     (table-set-valign "f"))
    ((balloon (icon "tm_table_bbottom.xpm")
	      "Align table at the base of bottom row (E-t V B)")
     (table-set-valign "B"))
    ((balloon (icon "tm_table_bvcenter.xpm")
	      "Align table at the base of middle row (E-t V C)")
     (table-set-valign "C"))
    ((balloon (icon "tm_table_btop.xpm")
	      "Align table at the base of top row (E-t V T)")
     (table-set-valign "T"))
    ((balloon (icon "tm_table_vbase.xpm")
	      "Align table at the base of origin row (E-t V O)")
     (table-set-valign "O"))))

(define texmacs-cell-mode-icons
  '(((balloon (icon "tm_cell_by_cell.xpm")
	      "Perform operations on cells (E-t m c)")
     (set-cell-mode "cell"))
    ((balloon (icon "tm_cell_by_row.xpm")
	      "Perform operations on rows (E-t m h)")
     (set-cell-mode "row"))
    ((balloon (icon "tm_cell_by_column.xpm")
	      "Perform operations on columns (E-t m v)")
     (set-cell-mode "column"))
    ((balloon (icon "tm_cell_by_table.xpm")
	      "Perform operations on entire table (E-t m t)")
     (set-cell-mode "table"))))

(define texmacs-cell-pos-icons
  '(((balloon (icon "tm_cell_left.xpm")
	      "Align cell to the left (E-t h l)")
     (cell-set-halign "l"))
    ((balloon (icon "tm_cell_hcenter.xpm")
	      "Horizontally center the cell (E-t h c)")
     (cell-set-halign "c"))
    ((balloon (icon "tm_cell_hbase.xpm")
	      "Horizontally align cell to the base (E-t h R)")
     (cell-set-halign "R"))
    ((balloon (icon "tm_cell_right.xpm")
	      "Align cell to the right (E-t h r)")
     (cell-set-halign "r"))
    ((balloon (icon "tm_cell_bottom.xpm")
	      "Align cell to the bottom (E-t v b)")
     (cell-set-valign "b"))
    ((balloon (icon "tm_cell_vbase.xpm")
	      "Vertically align cell to the base (E-t v B)")
     (cell-set-valign "B"))
    ((balloon (icon "tm_cell_vcenter.xpm")
	      "Vertically center the cell (E-t v c)")
     (cell-set-valign "c"))
    ((balloon (icon "tm_cell_top.xpm")
	      "Align cell to the top (E-t v t)")
     (cell-set-valign "t"))))

(define texmacs-cell-size-icons
  '(((balloon (icon "tm_cell_width.xpm")
	      "Set width of cell (E-t h s)")
     (cell-set-width-ia))
    ((balloon (icon "tm_cell_hmin.xpm")
	      "Width is minimum of specified width and box width (E-t h m)")
     (cell-set-hmode "min"))
    ((balloon (icon "tm_cell_hexact.xpm")
	      "Width is exactly the specified width (E-t h e)")
     (cell-set-hmode "exact"))
    ((balloon (icon "tm_cell_hmax.xpm")
	      "Width is maximum of specified width and box width (E-t h M)")
     (cell-set-hmode "max"))
    ((balloon (icon "tm_cell_height.xpm")
	      "Set height of cell (E-t v s)")
     (cell-set-height-ia))
    ((balloon (icon "tm_cell_vmin.xpm")
	      "Height is minimum of specified height and box height (E-t v m)")
     (cell-set-vmode "min"))
    ((balloon (icon "tm_cell_vexact.xpm")
	      "Height is exactly the specified height (E-t v e)")
     (cell-set-vmode "exact"))
    ((balloon (icon "tm_cell_vmax.xpm")
	      "Height is maximum of specified height and box height (E-t v M)")
     (cell-set-vmode "max"))))

(define texmacs-cell-decoration-icons
  '(((balloon (icon "tm_decorate_left.xpm")
	      "Use left hand column as border (E-t b left)")
     (table-column-decoration #f))
    ((balloon (icon "tm_decorate_right.xpm")
	      "Use right hand column as border (E-t b right)")
     (table-column-decoration #t))
    ((balloon (icon "tm_decorate_up.xpm")
	      "Use row above as border (E-t b up)")
     (table-row-decoration #f))
    ((balloon (icon "tm_decorate_down.xpm")
	      "Use row below as border (E-t b down)")
     (table-row-decoration #t))))

(define texmacs-table-icons
  '(|
    (=> (balloon (icon "tm_table_insert.xpm")
		 "Insert or delete rows or columns")
	(link texmacs-table-insert-icons))
    (=> (balloon (icon "tm_table_pos.xpm") "Position the table")
	(tile 4 (link texmacs-table-hpos-icons))
	---
	(tile 4 (link texmacs-table-vpos-icons)))
    (=> (balloon (icon "tm_table_special.xpm") "Set special table properties")
	(link table-special-menu))
    |
    (if (equal? (get-cell-mode) "cell")
	(=> (balloon (icon "tm_cell_cell.xpm")
		     "Change cell operation mode")
	    (link texmacs-cell-mode-icons)))
    (if (equal? (get-cell-mode) "row")
	(=> (balloon (icon "tm_cell_row.xpm")
		     "Change cell operation mode")
	    (link texmacs-cell-mode-icons)))
    (if (equal? (get-cell-mode) "column")
	(=> (balloon (icon "tm_cell_column.xpm")
		     "Change cell operation mode")
	    (link texmacs-cell-mode-icons)))
    (if (equal? (get-cell-mode) "table")
	(=> (balloon (icon "tm_cell_table.xpm")
		     "Change cell operation mode")
	    (link texmacs-cell-mode-icons)))
    (=> (balloon (icon "tm_cell_pos.xpm") "Modify cell alignment")
	(tile 4 (link texmacs-cell-pos-icons)))
    (=> (balloon (icon "tm_cell_size.xpm") "Modify cell size")
	(tile 4 (link texmacs-cell-size-icons)))
    (=> (balloon (icon "tm_cell_border.xpm") "Change border of cell")
	(link cell-border-menu))
    (=> (balloon (icon "tm_cell_background.xpm")
		 "Set background color of cell")
	(link cell-color-menu))
    (=> (balloon (icon "tm_cell_special.xpm") "Set special cell properties")
	(link  cell-special-menu))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Help icon
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define texmacs-session-help-icons
  '())

(define texmacs-help-icons
  '((link texmacs-session-help-icons)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Interface
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define texmacs-context-icons
  '((if (in-text?) (link texmacs-text-icons))
    (if (in-session?) (link texmacs-session-icons))
    (if (in-math?) (link texmacs-math-icons))
    (link texmacs-modifier-icons)
    (if (inside? "table") (link texmacs-table-icons))
    (link texmacs-help-icons)))
