
/******************************************************************************
* MODULE     : gg_string.gen.h
* DESCRIPTION: strings with reference counting,
*              which can also be used as buffers
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#ifndef _GG_STRING
#define _GG_STRING
#include "gg_malloc.h"
#include <string.h>

class string_rep {
  int ref_count;
  int n;

public:
  char* a;

  string_rep (int n=0);
  inline ~string_rep () { delete[] a; }

  friend class string;
  friend inline int N (string a);
};

class string {
  string_rep* rep;
  
public:
  inline string (string_rep* rep2);
  inline string (const string& x);
  inline ~string ();
  inline string_rep* operator -> ();
  inline string& operator = (string x);
  inline string (): rep (new string_rep()) {}
  inline string (int n): rep (new string_rep (n)) {}
  string (char c);
  string (char *a);
  string (const char *a);
  string (char *a, int n);
  inline char& operator [] (int i) { return rep->a[i]; }
  string operator () (int start, int end);
  bool   operator () (char* s);            // string is equal to s
  bool   operator () (char* s, int start); // string starts with s at pos start
  void   resize (int n2);
  bool   operator == (string a);
  bool   operator != (string a);
};

inline string::string (string_rep* rep2): rep(rep2) {}
inline string::string (const string& x): rep(x.rep) { rep->ref_count++; }
inline string::~string () { if ((--rep->ref_count)==0) delete rep; }
inline string_rep* string::operator -> () { return rep; }
inline int N (string a) { return a->n; }
inline string& string::operator = (string x) {
  x.rep->ref_count++;
  if ((--rep->ref_count)==0) delete rep;
  rep=x.rep;
  return *this;
}

string   copy (string a);
ostream& operator << (ostream& out, string a);
string&  operator << (string& a, char);
string&  operator << (string& a, string b);
string   operator * (string a, string b);
int      hash (string s);

bool   equal     (string s, char *a);
int    as_int    (string s);
double as_double (string s);
char*  as_charp  (string s);
string as_string (int i);
string as_string (double x);
string as_string (char* s);
bool   is_int    (string s);
bool   is_double (string s);
bool   is_charp  (string s);
bool   is_id     (string s);

void   system    (string s);

volatile void
fatal_error (char* message="unknown", char* routine="unknown", char* file="");

#endif
