
/******************************************************************************
* MODULE     : file.gen.h
* DESCRIPTION: file handling
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <tree.gen.h>

#module file
#import tree
#include <stdio.h>

typedef int SI;
typedef unsigned int SN;
typedef short HI;
typedef unsigned short HN;
typedef char QI;
typedef unsigned char QN;

/******************************************************************************
* The file data type
******************************************************************************/

class file_rep: concrete_struct {
  string dir;
  string name;

public:
  FILE*  fp;       // temporarily public (see pk-load.gen.cc)
  string os_name;  // unique os name, temporarily public (see file.gen.cc)

  file_rep (string name, char* rw_flag);
  file_rep (string dir, string name, char* rw_flag);
  bool is_open ();
  void check_open (char* routine, char* in);
  ~file_rep ();

  friend class file;
  friend bool eof (file f);
  friend file& operator >> (file& f, QI& c);
  friend file& operator >> (file& f, QN& c);
  friend file& operator >> (file& f, HI& c);
  friend file& operator >> (file& f, HN& c);
  friend file& operator >> (file& f, SI& c);
  friend file& operator >> (file& f, string& s);
  friend file& operator << (file& f, string s);
};

class file {
#import concrete_null (file, file_rep)
  file (string name, char* rw_flag);
  file (string dir, string name, char* rw_flag);
};
#import code_concrete_null (file, file_rep)

/******************************************************************************
* Routines for manipulating files
******************************************************************************/

bool load_string (string file_name, string& s, bool fatal=FALSE);
bool load_string (string dir, string file_name, string& s, bool fatal=FALSE);
bool save_string (string file_name, string s, bool fatal=FALSE);
bool save_string (string dir, string file_name, string s, bool fatal=FALSE);
bool load_tree (string file_name, tree& t, bool fatal=FALSE);
bool load_tree (string dir, string file_name, tree& t, bool fatal=FALSE);
bool save_tree (string file_name, tree t, bool fatal=FALSE);
bool save_tree (string dir, string file_name, tree t, bool fatal=FALSE);

tree   xpm_load (string file_name);
void   xpm_size (string file_name, int& w, int& h);
string ps_load (string image, string type);
void   ps_bounding_box (string im, string tp, int& x1,int& y1,int& x2,int& y2);
bool   is_web_file (string file_name);
bool   file_exists (string file_name);
bool   file_exists (string dir, string file_name);
string get_unique_file_name (string dir, string name, bool fatal=TRUE);
string get_temp_file_name ();
string get_radical_file_name (string name);
string get_tail_file_name (string name);
string get_relative_file_name (string base, string name, bool fatal=TRUE);
string get_delta_file_name (string base, string name);
string get_file_type (string file_name);
string get_file_format (string file_name);
bool   has_no_name (string s);

int    system (string s);
string eval_system (string s);
string var_eval_system (string s);
string get_env (string var);
void   set_env (string var, string with);
void   recursive_kill (int pid);
bool   guile_eval (string s);
extern int script_status; // 0: never accept, 1: prompt, 2: always accept

#endmodule // file
