
/******************************************************************************
* MODULE     : iterator.gen.h
* DESCRIPTION: dynamic iterators
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <tree.gen.h>

#module iterator (T)
#import tree

extern int iterator_count;
class iterator_rep<T>: public abstract_struct {
public:
  inline iterator_rep<T> () { DEBUG(iterator_count++); }
  inline virtual ~iterator_rep<T> () { DEBUG(iterator_count--); }
  virtual bool busy () = 0;
  virtual T next () = 0;
  virtual int remains ();
};

class iterator<T> {
#import abstract (iterator<T>, iterator_rep<T>)
  operator tree ();
};
#import code_abstract (iterator<T>, iterator_rep<T>)

ostream& operator << (ostream& out, iterator<T> it);

#endmodule // iterator (T)

#module hashmap_iterator (T,U)
#import iterator (T)
iterator<T> iterate (hashmap<T,U> h);
#endmodule // hashmap_iterator (T,U)

#module hashset_iterator (T)
#import iterator (T)
iterator<T> iterate (hashset<T> h);
#endmodule // hashset_iterator (T)
