
/******************************************************************************
* MODULE     : connect.gen.h
* DESCRIPTION: Connection of extern packages to TeXmacs
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <tree.gen.h>
#include <resource.gen.h>

#module connect
#import tree

#define CONNECTION_DEAD    0
#define WAITING_FOR_INPUT  1
#define WAITING_FOR_OUTPUT 2

bool   package_declared (string name);
void   package_declare (string name, string lib, string symbol, string init);
void   package_format (string name, string in, string out);
bool   package_installed (string name);
string package_install (string name);
tree   package_evaluate (string name, string session, tree expr);
string package_execute (string name, string session, string expr);

bool   connection_declared (string name);
void   connection_declare (string name, string cmd, string pipe_info= "");
void   connection_format (string name, string in_prot, string out_prot);
void   connection_filter_tree_in (string name, string filter);
void   connection_filter_string_in (string name, string filter);
void   connection_filter_string_out (string name, string filter);
void   connection_filter_tree_out (string name, string filter);
string connection_start (string name, string session, bool again= FALSE);
void   connection_write (string name, string session, tree t);
tree   connection_read (string name, string session,
			int try_ms= 0, string channel= "output");
void   connection_interrupt (string name, string session);
void   connection_stop (string name, string session);
void   connection_stop_all ();
int    connection_status (string name, string session);
string connection_shell_command (string session, string cmd);
tree   connection_eval (string name, string session, tree t);
void   connection_exec (string name, string session, string s);

string translate_prg (string s, string from, string to);
string symbol_install (string lib, string symb, pointer& f);
void   listen_to_pipes ();

#endmodule // connect
