
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : build-glue-basic.scm
;; DESCRIPTION : Building basic glue
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public licence and comes WITHOUT
;; ANY WARRENTY WHATSOEVER. See the file $TEXMACS_PATH/LICENCE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(output-copyright "build-glue-basic.scm")

(output "\n#module code_glue_basic\n")

(build
  ""
  "initialize_glue_basic"

  (tree->object tree_to_scheme_tree (scheme_tree tree))
  (object->tree scheme_tree_to_tree (tree scheme_tree))
  (tree->string coerce_tree_string (string tree))
  (string->tree coerce_string_tree (tree string))
  (use-ec-fonts? use_ec_fonts (bool))
  (file-exists? file_exists (bool string string))
  (tex-file-exists? tex_file_exists (bool string))
  (unique-file-name get_unique_file_name (string string string))
  (newer? is_newer (bool string string))

  (package-declare package_declare (void string string string string))
  (package-format package_format (void string string string))
  (connection-declare connection_declare (void string string))
  (connection-format connection_format (void string string string))
  (connection-filter-tree-in connection_filter_tree_in (void string string))
  (connection-filter-in connection_filter_string_in (void string string))
  (connection-filter-out connection_filter_string_out (void string string))
  (connection-filter-tree-out connection_filter_tree_out (void string string))
  (connection-exec connection_exec (void string string string))
  (connection-eval connection_eval (scheme_tree string string scheme_tree))

  (get-locale-language get_locale_language (string))
  (menu-merge menu_merge (scheme_tree scheme_tree scheme_tree)

  (thomas-test thomas_test (void string))))

(output "\n#endmodule //code_glue_basic\n")
