
/******************************************************************************
* MODULE     : texmacs.gen.cc
* DESCRIPTION: main program
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <dir.gen.h>
#include <server.gen.h>
#include <widget.gen.h>

#module code_texmacs
#import dir
#import server
#import widget

extern bool   char_clip;
extern bool   install_guile (int, char**, void (*) (int,char**));
extern string the_init_file;
extern string the_init_buffer_file;
extern int    install_status;

/******************************************************************************
* Creation of TeXmacs window
******************************************************************************/

int geometry_w= 800, geometry_h= 600;
int geometry_x= 0  , geometry_y= 0;

window
texmacs_window (widget wid) {
  int W, H;
  int w= geometry_w, h= geometry_h;
  int x= geometry_x, y= geometry_y;
  wid->dis->get_extents (W, H); W /= PIXEL; H /= PIXEL;
  if (x < 0) x= W + x + 1 - w;
  if (y < 0) y= H + y + 1 - h;
  return plain_window (wid, "TeXmacs", w*PIXEL, h*PIXEL, x*PIXEL, (-y)*PIXEL);
}

/******************************************************************************
* Real main program for encaptulation of guile
******************************************************************************/

void
TeXmacs_main (int argc, char** argv) {
  int i;
  bool flag= TRUE;
  string the_default_font;
  for (i=1; i<argc; i++)
    if (((argv[i][0] == '-') || (argv[i][0] == '+')) && (argv[i][1] != '\0')) {
      string s= argv[i];
      if ((N(s)>=2) && (s(0,2)=="--")) s= s (1, N(s));
      if ((s == "-s") || (s == "-silent")) flag= FALSE;
      else if ((s == "-e") || (s == "-events")) debug (1, TRUE);
      else if ((s == "-d") || (s == "-debug")) debug (2, TRUE);
      else if ((s == "-fn") || (s == "-font")) {
	i++;
	if (i<argc) the_default_font= argv[i];	
      }
      else if ((s == "-g") || (s == "-geometry")) {
	i++;
	if (i<argc) {
	  string g= argv[i];
	  int j=0, j1, j2, j3;
	  for (j=0; j<N(g); j++)
	    if (g[j] == 'x') break;
	  j1=j; if (j<N(g)) j++;
	  for (; j<N(g); j++)
	    if ((g[j] == '+') || (g[j] == '-')) break;
	  j2=j; if (j<N(g)) j++;
	  for (; j<N(g); j++)
	    if ((g[j] == '+') || (g[j] == '-')) break;
	  j3=j;
	  if (j1<N(g)) {
	    geometry_w= max (as_int (g (0, j1)), 320);
	    geometry_h= max (as_int (g (j1+1, j2)), 200);
	  }
	  if (j3<N(g)) { 
	    if (g[j2] == '-') geometry_x= as_int (g (j2, j3)) - 1;
	    else geometry_x= as_int (g (j2+1, j3));
	    if (g[j3] == '-') geometry_y= as_int (g (j3, N(g))) - 1;
	    else geometry_y= as_int (g (j3+1, N(g)));
	  }
	}
      }
      else if ((s == "-b") || (s == "-initialize-buffer")) {
	i++;
	if (i<argc) the_init_buffer_file= argv[i];
      }
      else if ((s == "-i") || (s == "-initialize")) {
	i++;
	if (i<argc) the_init_file= argv[i];
      }
      else if ((s == "-v") || (s == "-version")) {
	cout << "\n";
	cout << "TeXmacs version " << TEXMACS_VERSION << "\n";
	cout << TEXMACS_COPYRIGHT << "\n";
	cout << "\n";
	exit (0);
      }
      else if ((s == "-p") || (s == "-path")) {
	system ("echo $TEXMACS_PATH");
	exit (0);
      }
      else if ((s == "-bp") || (s == "-binpath")) {
	system ("echo $TEXMACS_BIN_PATH");
	exit (0);
      }
      else if ((s == "-x") || (s == "manual")) {
	system ("xdvi $TEXMACS_PATH/doc/dvi/texmacs.dvi &");
        exit (0);
      }
      else if ((s == "-Oc") || (s == "-no-char-clipping")) char_clip= FALSE;
      else if ((s == "+Oc") || (s == "-char-clipping")) char_clip= TRUE;
      else {
	cout << "\n";
	cout << "Options for TeXmacs:\n\n";
	cout << "  -b [file]  Specify scheme buffers initialization file\n";
	cout << "  -d         For debugging purposes\n";
	cout << "  -fn [font] Set the default TeX font\n";
	cout << "  -e         Display all widget events\n";
	cout << "  -g [geom]  Set geometry of window in pixels\n";
	cout << "  -h         Display this help message\n";
	cout << "  -i [file]  Specify scheme initialization file\n";
	cout << "  -p         Get the TeXmacs path\n";
	cout << "  -s         Do not inform about loaded files\n";
	cout << "  -v         Display current TeXmacs version\n";
	cout << "  -x         Consult the TeXmacs manual using xdvi\n";
	cout << "  -Oc        TeX characters bitmap clipping off\n";
	cout << "  +Oc        TeX characters bitmap clipping on (default)\n";
	cout << "\n";
	exit (0);
      }
    }
  if (flag) debug (0, TRUE);

  cout << "\n";
  if (debug (2)) cout << "TeXmacs] Installing TeX...\n";
  install_tex ();
  if (debug (2)) cout << "TeXmacs] Opening display...\n";
  display dis= open_display (argc, argv);
  dis->set_default_font (the_default_font);
  if (debug (2)) cout << "TeXmacs] Starting server...\n";
  server sv (dis);

  for (i=1; i<argc; i++) {
    string s= argv[i];
    if ((N(s)>=2) && (s(0,2)=="--")) s= s (1, N(s));
    if ((s[0] != '-') && (s[0] != '+')) {
      if (debug (2)) cout << "TeXmacs] Loading " << s << "...\n";
      sv->load_buffer (".", s, "generic", 1);
    }
    if ((s == "-b") || (s == "-initialize-buffer") ||
	(s == "-fn") || (s == "-font") ||
	(s == "-i") || (s == "-initialize") ||
	(s == "-g") || (s == "-geometry")) i++;
  }
  if (install_status == 1) {
    if (debug (2)) cout << "TeXmacs] Loading welcome message...\n";
    sv->load_buffer (".", "startup/readme", "help", 1);
  }
  else if (install_status == 2) {
    if (debug (2)) cout << "TeXmacs] Loading upgrade message...\n";
    sv->load_buffer (".", "startup/upgrade-last", "help", 1);
  }
  if (sv->no_bufs ()) {
    if (debug (2)) cout << "TeXmacs] Creating 'no name' buffer...\n";
    sv->open_window ();
  }

  if (debug (2)) cout << "TeXmacs] Starting event loop...\n";
  dis->delayed_message (sv->get_meta(), "auto save", 120000);
  dis->delayed_message (sv->get_meta(), "banner", 100);
  dis->event_loop ();

  if (debug (2)) cout << "TeXmacs] Closing display...\n";
  close_display (dis);
  if (debug (2)) cout << "TeXmacs] Good bye...\n";
}

/******************************************************************************
* Main program
******************************************************************************/

int
main (int argc, char** argv) {
  install_texmacs ();
  install_guile (argc, argv, TeXmacs_main);
  return 0;
}

#endmodule // code_texmacs
