
/******************************************************************************
* MODULE     : tm_config.gen.h
* DESCRIPTION: Configuration routines for TeXmacs server
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <server.gen.h>
#include <hashmap.gen.h>

#module tm_config
#import server
#import hashmap (string, string)
#import hashmap (string, tree)

class tm_config_rep: virtual public server_rep {
protected:
  string in_lan;                       // current input language
  string out_lan;                      // current output language
  hashmap<string,tree>   latex_cmds;   // latex (or user) commands
  hashmap<string,string> latex_help;   // help for latex (or user) commands
  hashmap<string,tree>   keymap;       // the current key map
  hashmap<string,string> shorthands;   // current shorthands
  hashmap<string,string> help_message; // help message for keymap or shorthand

public:
  tm_config_rep ();
  ~tm_config_rep ();

  /* Set and get input and output languages */
  void   set_input_language (string s);
  void   set_output_language (string s);
  string get_input_language ();
  string get_output_language ();

  /* Font setup */
  void set_font_rules (scheme_tree rules);

  /* Keyboard behaviour */
  void set_latex_commands (scheme_tree cmds);
  void set_latex_symbols (scheme_tree syms);
  bool get_latex_command (string which, string& help, scheme_tree& p);

  void insert_key_binding (string pred, string key, scheme_tree im);
  void delete_key_binding (string key);
  void delete_key_binding (string pred, string key);
  scheme_tree find_key_binding (string key);
  scheme_tree find_key_binding (string pred, string key);
  void determine_sub_key_bindings (string pred, string s);
  void set_keymap (scheme_tree preds, scheme_tree cmds);
  void remove_keymap (scheme_tree preds, scheme_tree cmds);
  void get_keycomb (string mode, int& status,
		    scheme_tree& keym, string& shorth, string& help);
};

#endmodule // tm_config
