
/******************************************************************************
* MODULE     : tm_server.gen.h
* DESCRIPTION: Main current graphical interface for user applications
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <timer.gen.h>
#include <tm_config.gen.h>
#include <tm_buffer.gen.h>
#include <tm_layout.gen.h>
#include <tm_scheme.gen.h>

#module tm_server
#import timer
#import tm_config
#import tm_buffer
#import tm_layout
#import tm_scheme

class tm_server_rep:
  public tm_config_rep,
  public tm_data_rep,
  public tm_layout_rep,
  public tm_scheme_rep
{
protected:
  display dis;     // current display
  tm_view vw;      // current editor
  int banner_nr;   // how far in banner

public:
  tm_server_rep (display dis);
  ~tm_server_rep ();
  void advance_banner ();

  /* Get and set objects associated to server */
  server_rep* get_server ();
  display     get_display ();
  tm_view     get_view (bool must_be_valid= TRUE);
  void        set_view (tm_view vw);
  tm_buffer   get_buffer ();
  editor      get_editor ();
  tm_window   get_window ();
  tm_widget   get_meta ();

  /* Routines concerning the current editor widget */
  void get_visible (SI& x1, SI& y1, SI& x2, SI& y2);
  void scroll_where (SI& x, SI& y);
  void scroll_to (SI x, SI y);
  void set_extents (SI x1, SI y1, SI x2, SI y2);
  void set_left_footer (string s);
  void set_right_footer (string s);
  void set_message (string left, string right);
  void interactive (string name, string& s, command call_back);

  /* Miscellaneous routines */
  void   interpose_handler ();
  void   wait_handler (string message, string arg);
  void   set_script_status (int i);
  void   focus_on_editor (editor ed);
  void   set_printing_command (string s);
  void   set_printer_page_type (string s);
  void   set_printer_dpi (string dpi);
  void   postscript_gc (string which);
  void   inclusions_gc (string which);
  bool   is_yes (string s);
  void   quit ();
  void   declare (string name, string lib, string symb, string init);
  tree   evaluate (string name, string session, tree expr);
  string execute  (string name, string session, string expr);
  void   shell    (string s);
};

#endmodule // tm_server
