
/******************************************************************************
* MODULE     : composite_event.gen.h
* DESCRIPTION: Events for modification of composite widgets
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <event.gen.h>
#include <Event/event_codes.gen.h>

#module composite_event
#import event
#import event_codes

/******************************************************************************
* Events for composite widgets
******************************************************************************/

struct clean_event_rep: public event_rep {
  clean_event_rep ();
  operator tree ();
};
#import event (clean_event, clean_event_rep)

struct insert_event_rep: public event_rep {
  string s; widget w;
  insert_event_rep (string s, widget w);
  operator tree ();
};
#import event (insert_event, insert_event_rep)

struct remove_event_rep: public event_rep {
  string s;
  remove_event_rep (string s);
  operator tree ();
};
#import event (remove_event, remove_event_rep)

#endmodule // composite_event
