#
# TCL Library
#

#
# $Id: errors.tcl,v 1.5 2000/09/29 04:21:22 dorothyr Exp $
#
# Procedures for unimplemented procedures and error messages used by
# TkCVS.
#

proc cvsok {mess} {
# Sometimes cancel is meaningless, we just want an acknowlegement
  global cvscfg

  set title {Acknowledge!}
  tk_dialog .confirm $title $mess warning 0 OK
}

proc cvsconfirm {mess} {
  global cvscfg

  if {$cvscfg(confirm_prompt) == "true"} {
    set title {Confirm!}
    tk_dialog .confirm $title $mess warning 0 OK Cancel
  } else {
    return 0
  }
}

proc cvsfail {mess} {
  global cvscfg

  set title {TkCVS Warning!}
  tk_dialog .warn $title $mess warning 0 Dismiss
}

proc cvserror {mess} {
# Suggest reserving this for fatal errors that
# warrant an exit from tkcvs -dr
  global cvscfg

  set title {TkCVS Error!}
  tk_dialog .error $title $mess error 0 {Bye Bye}
  exit 1
}

