#!/bin/sh
#-*-tcl-*-
# the next line restarts using wish \
exec wish "$0" -- ${1+"$@"}

#
# $Id: doinstall.tcl,v 1.4 2000/09/29 04:44:53 dorothyr Exp $
#

proc show_paths {INSTALLROOT} {
  global tcl_platform
  global TKCVS TKDIFF
  global LIBDIR BINDIR MANDIR

  if {$tcl_platform(platform) == "windows"} {
    set BINDIR [file join $INSTALLROOT bin]
    set LIBDIR [file join $INSTALLROOT lib]
    set MANDIR ""
  } else {
    set BINDIR [file join $INSTALLROOT bin]
    set LIBDIR [file join $INSTALLROOT lib]
    set MANDIR [file join $INSTALLROOT man mann]
  }

  set msg(1) [file join $BINDIR $TKCVS]
  set msg(2) [file join $BINDIR $TKDIFF]
  set msg(3) [file join $LIBDIR tkcvs *.tcl]
  set msg(4) [file join $LIBDIR tkcvs bitmaps *.gif]
  if {$tcl_platform(platform) == "unix"} {
     set msg(5) [file join $MANDIR tkcvs.n]
  }
  foreach m [lsort [array names msg]] {
    if {[winfo exists .messages.$m]} {
      destroy .messages.$m
    }
    global var$m
    set var$m $msg($m)
    label .messages.$m -text $msg($m) -justify left -textvariable var$m
    pack .messages.$m -side top -anchor w
  }
}

proc doinstall {INSTALLROOT } {
  global tcl_platform
  global TKCVS TKDIFF
  global LIBDIR BINDIR MANDIR

  file mkdir $INSTALLROOT

  #
  # Some directories we have to create.
  #
  set TCDIR [file join $LIBDIR tkcvs]
  set GFDIR [file join $LIBDIR tkcvs bitmaps]

  foreach dir [concat $BINDIR $GFDIR $TCDIR] {
    file mkdir $dir
  }

  set destfile [file join $BINDIR $TKCVS]
  puts "Installing $TKCVS in $BINDIR"
  set blank [open [file join tkcvs tkcvs.blank] "r"]
  set filled [open $destfile "w"]
  while {! [eof $blank]} {
    gets $blank line
    regsub -all {_TCDIR_} $line "$LIBDIR" line
    puts $filled $line
  }
  close $blank
  close $filled
  puts "Installing $TKDIFF in $BINDIR"
  file copy -force [file join tkdiff tkdiff] [file join $BINDIR $TKDIFF]

  if {$tcl_platform(platform) == "unix"} {
    file attributes $destfile -permissions 0755
    file attributes [file join $BINDIR $TKDIFF] -permissions 0755
    file mkdir $MANDIR
    puts "Installing manpage tkcvs.n in $MANDIR"
    file copy -force [file join tkcvs tkcvs.n] $MANDIR
  }

  puts "Installing tcl files in $TCDIR"
  cd tkcvs
  foreach tclfile [glob *.tcl tclIndex] {
    puts "  $tclfile"
    file copy -force $tclfile $TCDIR
  }

  puts "Installing icons in $GFDIR"
  cd [file join .. bitmaps]
  foreach pixfile [glob *.gif *.xbm] {
    puts "  $pixfile"
    file copy -force $pixfile $GFDIR
  }
  cd ..
  puts "Finished!"

  destroy .bottom.do
  destroy .bottom.not
  button .bottom.done -text "Finished!" -command {destroy .}
  pack .bottom.done
}

################################################################################

# Check Tcl/TK version
if {$tk_version < 8.1} {
   tk_dialog .wrongversion "Tcl/Tk too old" \
   "TkCVS requires Tcl/Tk 8.1 or better!" \
   error 0 {Bye Bye}
   exit 1
}

# Some rational and reasonable defaults.

if {$tcl_platform(platform) == "windows"} {
  set INSTALLROOT "C:\\"
  set TKCVS "tkcvs.tcl"
  set TKDIFF "tkdiff.tcl"
} else {
  set INSTALLROOT [file join  /usr local]
  set TKCVS "tkcvs"
  set TKDIFF "tkdiff"
}

# Override INSTALLROOT if specified
if {[llength $argv] == 1} {
  set INSTALLROOT [lindex $argv 0]
}
frame .title
label .title.lbl -text "TkCVS Installer" -font {Helvetica -14 bold}
pack .title -side top
pack .title.lbl -side top
frame .entry
label .entry.instlbl -text "Installation Root"
entry .entry.instent -textvariable INSTALLROOT
bind .entry.instent <Return> {show_paths $INSTALLROOT}
pack .entry -side top -pady 10
pack .entry.instlbl -side left
pack .entry.instent -side left

frame .messages -relief groove -bd 2
pack .messages -side top -expand y -fill x
label .messages.adv -text "These files will be installed:"
pack .messages.adv -side top
show_paths $INSTALLROOT

frame .bottom
button .bottom.do -text "Install" -command {doinstall $INSTALLROOT}
button .bottom.not -text "Cancel" -command {destroy .}
pack .bottom -side top
pack .bottom.do -side left
pack .bottom.not -side left

