.\" $Id: tkcvs.n,v 1.9 2000/09/16 04:31:21 dorothyr Exp $
.\"
.TH TkCVS n Release 6.4
.SH NAME
TkCVS - a Tk/Tcl Graphical Interface to CVS
.SH SYNOPSIS
.B tkcvs
[\-dir directory] [\-root cvsroot] [\-win workdir|module]
.SH DESCRIPTION
.LP
TkCVS is a Tcl/Tk-based graphical interface to the CVS configuration management system.  It displays the status of the files in the current working directory, and proves buttons and menus to execute CVS commands on the selected files.  TkDiff is included for browsing and merging your changes.
.LP
TkCVS extends CVS with a method to produce a browsable, "user friendly" listing of modules in the repository.  This requires some manual editing of the CVSROOT/modules file the first time - see the online help.
.SP
.SH OPTIONS
.LP
TkCVS accepts the following options.
.TP
.BI -dir " directory"
Start TkCVS in the specified directory.
.TP
.B -help
Print a usage message.
.TP
.BI -root " cvsroot"
Set $CVSROOT to the specified repository.
.TP
.B -win  {workdir|module}
Start by displaying the directory browser (the default)
or the Module Browser.  If you start with the Module Browser,
the directory browser is iconified.
.LP
For example, if you want to browse the modules located in /jaz/repository, you would type
.LP
.RS
    tkcvs -win module -root /jaz/repository.
.RE
.SP
.SH WORKING WITH TkCVS
.LP
To work with files from the repository using TkCVS, first you need to select a directory (sometimes called a sandbox) to work in. You can create a subdirectory from your home directory (I use develop for all of my development software, you may like to use src or progs), or you may work from your home directory.
.LP
After selecting this directory and navigating into it using the directory display, you can select a module to work with.  In CVS, groups of files are arranged into modules for easy access.
.LP
TkCVS arranges modules into directories and subdirectories in a tree structure much in the same way that you would arrange them in your home directory.  You can navigate through the TkCVS module tree using the Module Browser window.
.SS Working with files from the repository
.LP
Using the Module Browser window, you can select a module to check out.  Each module has a module code which is displayed as you browse through the module tree.  When you check out a module, a new directory is created in your working directory with the same name as the module code.
.LP
You can then change into the new directory that TkCVS has created, and all of the files in that module will be in the directory.  You can use the simple file management and editing features of TkCVS to work with files in this directory, or you may use your own text editor, word processor, or whatever to work with the files.
.LP
Once you have finished your edits (or whenever you have reached a stable stage in your development, or possibly even on a daily basis), you can check files back in to TkCVS using the Check In button.
.SS Tagging and Branching
.LP
You can tag particular versions of a module or file in the repository.  Normally you will do this when your programs are ready to be released into a testing or production environment.  Tagging is useful for taking snapshots of what the repository contained at a particular date (for example you can tag all of the files associated with a particular software release).
.LP
You can also create branches based on tags or on particular versions of the files in the repository. This allows you to go back and fix particular bugs or make important patches to an earlier release of software while still being able to work on the latest version.
.LP
You can use symbolic tag names to refer to versions of files in the repository, instead of just numeric version numbers. For example you can use the tag name software_release_1_5 to indicate release 1.5 of a group of files destined for a customer site.
.SS Exporting
.LP
Once a software release has been tagged, you can use a special type of check out called an export. This allows you to more cleanly check out files from the repository,  without all of the administrivia that CVS requires you to have while working on the files.  This type of facility is useful for delivery of a software release to a customer.
.SS Importing
.LP
TkCVS contains a special dialog to allow users to import new files into the repository. New modules can be assigned places within the repository, as well as descriptive names (so that other people know what they are for).
.SS Working inside the repository
.LP
TkCVS contains some features that enable it to work inside the repository.  The Module Browser window displays the directories and modules within the repository in a tree structured manner.
.LP
The Module Browser can invoke a file browser window that enables you to list the files within the module, and view a specific version of a file and see its branches and tags.
.LP
The log browser window contains a graphical display of a revision log for a file, and enables you to see the differences between two versions of a file by clicking on the versions in the display.
.SS Other Features
.LP
Other features of TkCVS allow you to tag files, add new files or delete files from the repository, or view and print reports about the repository contents.  You can also search the module database for module codes, module names, and keywords within a module name.
.SP
.SH CHECKING OUT MODULES
.LP
To check out a module, first display the Module Browser using the Module Browse button. Note that you do not have to check out modules using this dialog -- you can use it for just browsing through the modules in the repository.
.LP
Once you have found the module you are looking for in the module tree, you can check it out by pressing the Check Out button, or export it using the Export button (see the section on Exporting later in this manual).
.SP
.SH TAGGING AND BRANCHING
.LP
CVS uses a system of tags to indicate places in the development cycle when the repository (or parts of it) are in a stable state. These tags can be applied to modules in the repository or to files within a module.
.SS Tagging Modules
.LP
To tag a module, first select the module using the Module Browser (note that you may tag a module or a directory tree -- to tag an entire directory tree including all of its sub-directories and modules, select the top level directory of the tree).
.LP
Enter the tag name into the Tag A entry box.  A tag name may be any alphanumeric string, but may not contain any spaces or dots.  It must begin with a letter instead of a number. Sample tag names include things like software-release-1-0 or integration-test-release.
.LP
If you also enter a tag name into the Tag B entry box, then all files in that module that are currently tagged with Tag B will be also tagged with Tag A.
.LP
Select the \fBTag->Tag Module\fR menu item from the menu on the Module Browser dialog, and the module or directory will be tagged with the tag name that you have entered.
.SS Tagging Files
.LP
You may tag individual files from within the directory browser.  This is mostly useful when you only want to tag part of the files in a module, or when you are re-tagging certain files within an already tagged module.
.LP
Select the files that are to be tagged, and select the Tag button or the \fBFile->Tag Files\fR item from the menu.  This will request that you enter a tag name. The selected files will then be tagged with this tag name.
.SS Updating to a Tag
.LP
Once a file or module has been tagged within the repository, you may use the tag name for checking out files, or updating files to a tag name.
.LP
If a tag name is entered in the Tag A field of the browser window when you select a module for check out, then the tagged version of the module (rather than the latest version) will be checked out of the repository.
.SS Branching
.LP
CVS also supports the concept of branching files. When you are applying a tag, the tag may be applied as a branch tag, which means that all versions based on this tag will be placed on a branch of the main version tree instead of on the trunk.
.LP
You should update files to a branch tag before you change them if you want your changes to not affect the head version.
.LP
To read more about branching and branch tags, read the cvs manual page.
.SP
.SH EXPORTING
.LP
An important use of tagging modules is to indicate when a new release of software is ready to be delivered, and to mark the versions of all of the files in that release within the repository.
.LP
When a release is about to be made, you may export it from the repository.  This is like a check-out, except for the following:
.LP
*  Exported directories do not contain the CVS or administrative directories, and are therefore cleaner (but cannot be used for checking files back in to the repository).
.LP
*  Exported files do keyword expansion differently from non-exported  files  (to  ensure that the keyword information is not lost should the file be imported into CVS at a different site).
.LP
To export a module or directory, press the Export button at the bottom of the Module Browser. You must supply a tag name when you are exporting a module -- you cannot just export the default (head) version. This is to make sure that you have the tag in place so that you can reproduce the exported files at a later date. This is called good configuration management.
.SP
.SH IMPORTING NEW MODULES
.LP
Before importing a new module, first check to make sure that you have write permission to the repository. Ask the configuration management staff at your organisation to determine whether you can write to the repository.
.LP
You should also take some time and view how the repository is structured using the Module Browser (see above). You will need to provide a directory name for your module (which should not be already in use) and so you will need to know that the parent directory for your module exists in the repository first. Although a module can be imported without the parent directory existing, this means that the CVS modules file must be patched manually after the operation is finised to insert the directory name in the correct place in the file.
.LP
To import a module, first enter the directory where the module is located. Make sure that there is nothing in this directory except the files that you want to import (create a new empty directory first and copy the files from the module into it if necessary).
.LP
Once this is done, press the Import button. You will need to enter the following details:
.TP
.I Module Directory:
The location in the module tree where your new module will be put.  This directory must not already exist, although its parent directory must exist.
.TP
.I Module Description:
A one-line descriptive title for your module.  This will be displayed in the right-hand column of the browser.
.TP
.I Version Number:
The current version number of the module. This should be a number of the form X.Y.Z where .Y and .Z are optional. You can leave this blank, in which case 1 will be used as the first version number.
.TP
.I Module Code:
A module code for the module.  This code must not already exist in the repository. I strongly suggest that your organisation settles on a single unambiguous code for modules. One possibility is something like:
.LP
.RS
    [project code]-[subsystem code]-[module code]
.RE
.LP
Using this scheme, you could have a 3 digit project code, a 3 letter subsystem code, and a 4 letter module code for each module, and everything would be easy to locate.
.LP
Once you have entered these details, press the OK button to import the module.
.SH CREATING NEW DIRECTORIES
.LP
TkCVS is not a file manager! You can't use it to create directories within your home directory.
.LP
You can, however, use it to create new directories within the repository if the repository is not remote.  This is best done while importing new modules. If you are about to import a new module, and the parent directory does not exist in the repository, you can create it using the New Directory button.
.LP
Press this button and a dialog will appear allowing you to create the new directory.  You must enter the following information:
.TP
.I New Directory Location:
Where (within the module tree) the new directory will be created.  This directory should not already exist, but the parent directory must exist.
.TP
.I New Directory Name:
This is a one-line descriptive name for the new directory.  Something like Accounting software or Test data for my files should be sufficient.
.LP
Once you have entered this information, press the OK button to create the directory.
.LP
You may use this dialog multiple times in one session to create multiple directories, or an entire tree of directories in your repository.
.SP
.SH CURRENT DIRECTORY DISPLAY
.LP
The current directory display shows:
.LP
*  The name of the current directory,
.LP
*  The location of the current repository, and the location of the current directory in the CVS repository.  This will only be shown if the current directory is contained in the CVS repository. If it is not contained in the repository you may import it using the Import button.
.LP
*  A Directory Tag name, if the directory is contained in the CVS repository and it has been checked out against a particular CVS version tag.
.LP
*  A list of the files in the current directory.  You may select a file by clicking on it once with the left mouse button.  You may select a group of files by dragging over them with the mouse or holding the shift key while clicking. You may select a group of non-contiguous files by holding the control key while clicking.
.LP
*  If cvscfg(econtrol) is set, a list of people editing the files.  This column is only useful if your site uses "cvs watch" and/or "cvs edit".
.LP
You may move into a directory by double-clicking on it.
.LP
Double clicking on a file will load the file into a suitable editor so you can change it.  A different editor can be used for different file types.
.SS File Status
.LP
When you are in a directory that is contained in the CVS repository, a file status will be shown next to each file.  The various statuses that can be shown are:
.TP
.B Up-to-date
The file is up to date with respect to the repository.
.TP
.B ?
The file is not contained in the repository. You may need to add the file to the repository by pressing the "Add" button.
.TP
.B Locally Modified
The file has been modified in the current directory since being checked out of the repository.
.TP
.B Locally Added
The file has been added to the repository. This file will become permanent in the repository once a commit is made.
.TP
.B [directory:CVS]
The file is a directory which has been checked out from the CVS repository.
.TP
.B [directory:RCS]
The file is a directory which is maintained using RCS.
.TP
.B [directory:SCCS]
The file is a directory which is maintained using SCCS.
.TP
.B [directory]
The file is a directory.
.SS Editors Display
.LP
If the option cvscfg(econtrol)=1 has been set then an extra column will appear in the current directory display labelled "editors".  This gives the edit status of each of the files in the current directory so it can be easily seen who is currently editing the file. If there are multiple editors then each one is seperated by a slash.  Refer to the CVS documentation for details of how to set up the repository for using the "cvs edit" feature using "cvs watch on", etc.
.SS File Filters
.LP
You can specify file matching patterns to instruct TkCVS which files you wish to see.  You can also specify patterns telling it which files to remove when you press the "Clean" button or select the \fBFile->Cleanup\fR menu item.
.SP
.SH BUTTONS
.LP
The big button at the upper right opens the Module Browser.
.TP
.I Module Browse:
Opens a Module Browser window.  PUSH THIS BUTTON!  The Module Browser is useful and will teach you all kinds of things about CVS.
.LP
There are a number of buttons at the bottom of the window. Pressing on one of these causes the following actions:
.TP
.I Edit:
Press this button to load the selected files in to an appropriate editor.
.TP
.I Delete:
Press this button to delete the selected files. The files will not be removed from the repository. To remove the files from the repository as well as delete them, press the "Remove" button instead.
.TP
.I Unselect:
Press this button to un-select all of the selected files.
.TP
.I Refresh:
Press this button to re-read the current directory.  You might want to do this immediately after a check-in or update, and also if you add new files to the directory.
.TP
.I Log (Branch) Browse:
This button will bring up the log browser window for each of the selected files in the window. This window is described later.
.TP
.I Diff:
This compares the selected files with the equivalent files in the repository. A separate program called "TkDiff" (also supplied with TkCVS) is used to do this.  For more information on TkDiff, see TkDiff's help menu.
.TP
.I Add Files:
Press this button when you want to add new files to the repository.  You can do this when you have created a new file in the current directory. You must create the file before adding it to the repository.  To add some files, first select them in the list above the buttons. Then press the Add Files button.  The files that you have added to the repository will be committed next time you press the Check In button.
.TP
.I Remove:
This button will remove files.  To remove a file, first select the file in the list above the buttons. Then press the Remove button.  The file will disappear from the directory and from the file list, and will be removed from the repository next time you press the Check In button.
.TP
.I Merge Conflict:
If a file's status says "Needs Merge", "Conflict", or is marked with a "C" in CVS Check, there was a difference which CVS needs help to reconcile.  This button invokes TkDiff with the -conflict option, opening a merge window to help you merge the differences.
.TP
.I Check In:
This button commits your changes to the repository.  This includes adding new files and removing deleted files.  When you press this button, a dialog will appear asking you for the version number of the files you want to commit, and a comment.  You need only enter a version number if you want to bring the files in the repository up to the next major version number. For example, if a file is version 1.10, and you do not enter a version number, it will be checked in as version 1.11. If you enter the version number 3, then it will be checked in as version 3.0 instead.
.TP
.I Update:
This updates your sandbox directory with any changes committed to the repository by other developers.
.TP
.I Tag:
This button will tag the selected files.  The -F (force) option will move the tag if it already exists on the file.  The -b (branch) option will create a new branch.
.TP
.I Set Edit Flag:
This button sets the edit flag on the selected files, enabling other developers to see that you are currently editting those files (See "cvs edit" in the CVS documentation).
.TP
.I Reset Edit Flag:
This button resets the edit flag on the selected files, enabling other developers to see that you are no longer editting those files (See "cvs edit" in the CVS documentation).  As the current version of cvs waits on a prompt for "cvs unedit" if changes have been made to the file in question (to ask if you want to revert the changes to the current revision), the current action of tkcvs is to abort the unedit (by piping in nothing to stdin).  Therefore, to lose the changes and revert to the current revision, it is necessary to delete the file and do an update (this will also clear the edit flag). To keep the changes, make a copy of the file, delete the original, update, and then move the saved copy back to the original filename.
.TP
.I Quit:
Press this button to leave TkCVS.
.SP
.SH THE MODULE BROWSER
.LP
Most of the file related actions of TkCVS are performed within the main window. The module related actions of TkCVS are performed within the Module Browser. The Module Browser is displayed using the Module Browse button from the main window.
.LP
When the dialog is displayed, it shows 2 columns. The first column is a tree showing the module codes and directory names of all of the items in the repository.  The icon shows whether the item is a directory (which may contain other directories or modules), or whether it is a module (which may be checked out from TkCVS).  It is possible for an item to be both a module and a directory.  If it has a red ball on it, you can check it out.  If it shows a plain folder icon, you have to open the folder to get to the items that you can check out.
.LP
The second column shows descriptive titles of the items in the repository.
.LP
You can exit the Module Browser by pressing the Close button.
.SP
.SS Module Browser Menu
.LP
The Module Browser also contains a menu, with the following options:
.TP
.B Reports
This menu contains 4 options. These are Module Tree, Modules Sorted by Name, Version Tree, and Version Listing by Name.
.LP
These perform the same functions as the equivalent items on the TkCVS main menu, except for the following note:
.LP
Each of these options restricts itself to the currently selected module or directory in the Module Browser.  The version reports do not report the head version, instead they report the version number attached to the tag name given in the Tag A field of the Module Browser.
.LP
The next 3 items are Search Repository by Code, Search Repository by Name, and Search Repository by Keyword.
.LP
These can help you find a module's location within the repository.
.TP
.B Checkouts
The items on this menu run cvs history commands.  They show which modules are checked out by whom.
.TP
.B Patch->Make Patch File
This item creates a Larry Wall format patch(1) file in the current directory of the module selected. A tag name must be entered into the Tag A field of the Module Browser. If a second tag name is entered into the Tag B field, then the patch file will contain differences between the two tagged versions of the module. Otherwise the patch file will contain differences between the head version and the tagged version of the module.
.TP
.B Patch->View Patch Summary
This item displays a short summary of the differences between two versions of a module. A tag name must be entered into the Tag A field of the Module Browser. If a second tag name is entered into the field, then the summary will list the changes between the two tagged versions of the module. Otherwise the summary will list differences between the head version and the tagged version of the module.
.TP
.B Tag
See the section titled Tagging and Branching for more information on the options on this menu.
.SP
.SS Module Browser Buttons
.LP
The Module Browser contains the following buttons:
.TP
.I Who:
Shows which modules are checked out by whom.
.TP
.I File Browse:
Displays a list of the selected module's files.
.TP
.I Unselect:
Press this button to un-select the selected module.
.TP
.I Check Out:
Checks out the current version of a module. If a tag name is entered into the Tag A field, then the tagged version is checked out rather than the head version.
.TP
.I Export:
Exports the current version of a module. If a tag name is entered into the Tag A field, then the tagged version is exported rather than the head version.  See the section titled Exporting for more information on exporting modules from the repository.
.TP
.I Tag:
This button tags an entire module.
.TP
.I Branch Tag:
This creates a branch of a module by giving it a branch tag.
.TP
.I Patch Summary:
This item displays a short summary of the differences between two versions of a module. A tag name must be entered into the Tag A field of the Module Browser. If a second tag name is entered into the field, then the summary will list the changes between the two tagged versions of the module. Otherwise the summary will list differences between the head version and the tagged version of the module.
.TP
.I Create Patch File:
This item creates a Larry Wall format patch(1) file in the current directory of the module selected. A tag name must be entered into the Tag A field of the Module Browser. If a second tag name is entered into the Tag B field, then the patch file will contain differences between the two tagged versions of the module. Otherwise the patch file will contain differences between the head version and the tagged version of the module.
.TP
.I Import:
This item will import the contents of the current directory (the one shown in the Current Directory Display) into the repository as a module.  See the section titled Importing for more information.
.TP
.I Close:
This button closes the Module Browser.
.SP
.SH THE FILE BROWSER
.LP
Pressing the \fBFile Browse\fR button in the Module Browser window displays the TkCVS file browser. This window shows a list of each file contained in the selected module.  The buttons are:
.TP
.I View:
This displays a window showing the contents of the file. The file may be viewed but not edited using this window. (To edit a file in the repository, you must check the file out of the repository).  If a tag name or version number is entered into the Version / Tag field at the top of the window, the specified version of the file is displayed, and not the head version.
.TP
.I Log (Branch):
This displays the log browser window for the file.
.TP
.I Tags:
Lists the file's tags.
.TP
.I Close:
This button closes the file browser.
.SP
.SH THE LOG BROWSER
.LP
The TkCVS Log Browser window enables you to view a graphical display of the revision log of a file, including all previous versions, and any branched versions.
.LP
You can get to the log browser window in two ways, either by selecting a file within the main window of TkCVS and pressing the Log Browse button, or by selecting a file in the file browser window (available from within the Module Browser) and pressing the Log Browse button.
.LP
The two forms of the log browser are slightly different.  From within the main window it is possible to perform merge operations on a file, and the results of the merge are stored in the current directory. From within the Module Browser (working directly within the repository) merge operations are not possible.
.SS Log Browser Window
.LP
The log browser window has three components. These are the file name and version information section at the top, the log display in the middle, and a row of buttons along the bottom.
.SS Log Display
.LP
The main log display is fairly self explanatory. It shows a group of boxes connected by small lines indicating the main trunk of the file development (on the left hand side) and any branches that the file has (which spread out to the right of the main trunk).
.LP
Each box contains the version number and author of the version.
.SS Version Numbers
.LP
Once a file is loaded into the log browser, up to two version numbers may be selected. The primary version is selected by clicking the left mouse button on a version box in the main log display.
.LP
The secondary version (Version B) is selected by clicking the right mouse button on a version box in the main log display.
.LP
Operations such as "View" and "Merge Branch to Head" always operate only on the primary version selected.
.LP
Operations such as "Diff" and "Merge Changes to Head" require two versions to be selected.
.SS Log Browser Buttons
.LP
The log browser contains the following buttons:
.TP
.I View:
Pressing this button displays a window containing the primary version of the file selected.
.TP
.I Diff:
Pressing this button runs the "tkdiff" program (by John Klassa) to display the differences between version A and version B.
.TP
.I Merge Branch to Head:
To use this button, first select a branch version of the file as the primary version.  The changes made along the branch up to that version will then be merged into the head version, and stored in the current directory. The version of the file in the current directory will be over-written.
.TP
.I Merge Changes to Head:
To use this button, first select two versions anywhere in the file log (although two adjacent branch versions are more commonly selected). It is expected that in most cases version B will be later than version A.  CVS will then calculate the changes made between the two versions selected and merge the differences to the head version.  Note that if version A is later (higher on the trunk or further along the branch) than version B, a "reverse diff" will be created. This will have the effect of removing the changes from the head version.  For example, if the head version is 1.6, version A is 1.5, and version B is 1.3, this button will remove all of the changes made between versions 1.3 and 1.5 from the head version.  It may not make sense to select two branch versions on different branches for this function.
.TP
.I View Tags:
This button displays a window showing the tags contained in the file.
.TP
.I Close:
This button closes the Log Browser.
.SP
.SH CONFIGURATION FILES
.LP
There are two configuration files for TkCVS. The first is stored in the directory in which the *.tcl files for TkCVS are installed. This is called tkcvs_def.tcl.  You can put a file called site_def in that directory, too.  That's a good place for site-specific things like tagcolours.  Unlike tkcvs_def.tcl, it will not be overwritten when you install a newer version of TkCVS.
.LP
Values in the site configuration files can be over-ridden at the user level by placing a .tkcvs file in your home directory. Commands in either of these files should be Tcl scripts. In other words, to set a variable name, you should have the following command in your .tkcvs file:
.LP
.RS
    set variable-name value
.RE
.LP
for example:
.LP
.RS
    set cvscfg(papersize) A4
.RE
.LP
The following variables are supported by TkCVS:
.SS Startup
.TP
.B cvscfg(y_size)
Number of files that the main working listbox should accomodate
.TP
.B cvscfg(startwindow)
Which window you want to see on startup. (workdir or module)
.TP
.B cvscfg(cvsroot)
If set, it overrides the CVSROOT envronment variable.
.SS GUI
.TP
.B cvscfg(guifont)
Font for menus, buttons, and labels
.TP
.B cvscfg(listboxfont)
Font for text in list boxes
.TP
.B cvscfg(glb_background)
Background colour to use for all items in TkCVS
.TP
.B cvscfg(glb_highlight)
Background colour to use for highlighted items
.TP
.B cvscfg(bt_lookhere)
Background colour for buttons and scrollbars
.TP
.B cvscfg(bt_pressme)
Background colour for active buttons and scrollbars
.TP
.B cvscfg(tool_colour)
Colour of the ToolTips popup labels
.SS Log browser
.TP
.B cvscfg(tagdepth)
Number of tags you want to see for each revision on the branching diagram before it says "more..." and offers a popup to show the rest
.TP
.B cvscfg(tagcolour,tagstring)
Colors for marking tags. For example "set cvscfg(tagcolour,tkcvs_r6) Purple"
.SS User preferences
.TP
.B cvscfg(allfiles)
Set this to 0 to see normal files only in the directory browser, set it to 1 to see all files including hidden files.
.TP
.B cvscfg(auto_status)
Set the default for automatic statusing of a CVS controlled directory. Automatic updates are done when a directory is entered and after some operations.
.TP
.B cvscfg(checkrecursive)
Report Check recursively (onvalue {}, offvalue -l)
.TP
.B cvscfg(confirm_prompt)
Ask for confirmation before performing an operation(true or false)
.TP
.B cvscfg(econtrol)
Set this to 1 to turn on an extra column in the directory browser showing the current editors of each file. Set to 0 to turn off this feature.
.TP
.B cvscfg(editor)
Preferred default editor
.TP
.B cvscfg(editors)
String pairs giving the editor-command and string-match-pattern, for deciding which editor to use
.TP
.B cvscfg(editorargs)
Command-line arguments to send to the default editing program.
.TP
.B cvscfg(ldetail)
Detail level for status reports (summary, verbose)
.TP
.B cvscfg(rdetail)
Detail for repostitory and workdir reports (terse, summary, verbose)
.TP
.B cvscfg(recurse)
Whether reports are recursive (true or false)
.SS File filters
.TP
.B cvscfg(file_filter)
Pattern for which files to list. Empty string is equilivant to the entire directory (minus hidden files)
.TP
.B cvscfg(ignore_file_filter)
Pattern used in the workdir listbox filter for files to be ignored
.TP
.B cvscfg(clean_these)
Pattern to be used for cleaning a directory (removing unwanted files)
.SS System
.TP
.B cvscfg(print_cmd)
System command used for printing. lpr, enscript -Ghr, etc)
.TP
.B cvscfg(shell)
What you want to happen when you ask for a shell
.SS Portability
.TP
.B cvscfg(aster)
File mask for all files (* for unix, *.* for windows)
.TP
.B cvscfg(null)
The null device. /dev/null for unix, nul for windows
.TP
.B cvscfg(tkdiff)
How to start tkdiff. Example sh /usr/local/bin/tkdiff
.TP
.B cvscfg(tmpdir)
Directory in which to do behind-the-scenes checkouts. Usually /tmp or /var/tmp)
.TP
.B cvscfg(thisdir)
CVS-DOS doesn't like a dot in some execs. ("." for unix, "" for windows)
.SS Printed reports
.TP
.B cvscfg(papersize)
Paper size for PostScript reports. A4 for international, 8x11 for US)
.TP
.B cvscfg(pointsize)
Point size for body of PostScript reports
.TP
.B cvscfg(headingsize)
Point size to use for heading text in PostScript reports
.TP
.B cvscfg(subheadingsize)
Point size for subheadings in PostScript reports
.SS Debugging
.TP
.B cvscfg(log_classes)
For debugging: C=CVS commands, F=File creation/deletion, T=Function entry/exit tracing, D=Debugging
.TP
.B cvscfg(logging)
Logging (debugging) on or off
.SP
.SH ENVIRONMENT VARIABLES
.LP
You should have the CVSROOT environment variable pointing to the location of your CVS repository before you run TkCVS.  It will still allow you to work with different repositories within the same session.
.SP
.SH USER CONFIGURABLE MENU EXTENSIONS
.LP
It is possible to extend the TkCVS menu by inserting additional commands into the .tkcvs or tkcvs_def.tcl files.  These extensions appear on an extra menu to the right of the TkCVS Options menu.
.LP
To create new menu entries on the user-defined menu, set the following variables:
.SS cvsmenu(command)
.LP
Setting a variable with this name to a value like "commandname" causes the CVS command "cvs commandname" to be run when this menu option is selected. For example, the following line:
.LP
.RS
    set cvsmenu(update_A) "update -A"
.RE
.LP
Causes a new menu option titled "update_A" to be added to the user defined menu that will run the command "cvs update -A" on the selected files when it is activated.
.LP
(This example command, for versions of CVS later than 1.3, will force an update to the head version of a file, ignoring any sticky tags or versions attached to the file).
.SS usermenu(command)
.LP
Setting a variable with this name to a value like "commandname" causes the command "commandname" to be run when this menu option is selected. For example, the following line:
.LP
.RS
    set cvsmenu(view) "cat"
.RE
.LP
Causes a new menu option titled "update_A" to be added to the User defined menu that will run the command "cat" on the selected files when it is activated.
.LP
Any user-defined commands will be passed a list of file names corresponding to the files selected on the directory listing on the main menu as arguments.
.LP
The output of the user defined commands will be displayed in a window when the command is finished.
.SP
.SH CVS "modules" FILE
.LP
CVS maintains a file called modules in the $CVSROOT/CVSROOT directory in which it stores the location of all of the modules in the CVS repository. TkCVS maintains a set of backwards - compatible extensions to this file to store the names of directories and modules.
.LP
If you haven't put anything in your CVSROOT/modules file, do so.  See the "Administrative Files" section of the CVS manual.  Then, you can add the TkCVS extensions.
.SS Directory Name
.LP
#D [TAB] directory [TAB] directory name.
.SS Module Name
.LP
#M [TAB] module code [TAB] module name
.LP
Where module code is the same as the module code that CVS uses to refer to the module in the modules file.
.LP
The #M line must be after the #D line for the directory in which the module is contained, but must be before the line containing the module code line used by CVS.
.TP
.I eg:
.RS
#D      softproj        Software Development Projects
.RE
.RS
#D      softproj/choc   Chocolate Detection Project
.RE
.RS
#M      sniffer Chocolate Sniffer
.RE
.RS
sniffer softproj/choc/sniffer
.RE
.RS
#M      snuff   Chocolate Snuffler
.RE
.RS
snuff   softproj/choc/snuffler
.RE
.RS
#M      biter   Chocolate Biter
.RE
.RS
biter   softproj/choc/biter
.RE
.LP
When you are installing TkCVS, you may like to add these additional lines to the modules file (remember to check out the modules module from the repository, and then commit it again when you have finished the edits).
.LP
These extension lines commence with a "#" character, so CVS interprets them as comments. Only TkCVS uses them for naming modules. They can be safely left in the file whether you are using TkCVS or not (in fact they are a useful reference when browsing your modules file).
.SP
.SH SEE ALSO
cvs(1)
.SH AUTHOR
Del (del@babel.babel.com.au)
