#
# $Id: tkcvs_def.tcl,v 1.27 2000/09/29 04:25:12 dorothyr Exp $
#
# TkCVS defaults file.
#
# This file is read by TkCVS on startup.  It will be installed
# automatically by the "configure" script.
#
# Defaults in the .tkcvs file in the user's home directory will
# over-ride this file.
#

# Print setup.
set cvscfg(papersize) "A4"
set cvscfg(pointsize) 9
set cvscfg(headingsize) 14
set cvscfg(subheadingsize) 12

# If you want to use "cvs edit", uncomment this.
#set cvscfg(econtrol) true

# Number of tags you want to see for each revision on the branching
# diagram before it says "more..."
set cvscfg(tagdepth) 6

# If you want the module browser to come up on startup, uncomment this.
#set cvscfg(startwindow) "module"

# Colours.  "Colors" that is if you are a yanqui who can't spell.
# Added support for monochrome machines. -sj
if { [winfo depth .] == 1 } {

    set cvscfg(glb_background)      "white"
    set cvscfg(glb_highlight)       "black"
    set cvscfg(bt_lookhere)         "white"
    set cvscfg(bt_pressme)          "black"
    set cvscfg(tool_colour)          "white"

} else {

    # These colours are entered into the options database, see below.
    # configure -background
    # set cvscfg(glb_background)      "SkyBlue2"
    # configure -highlightcolor
    # The selected item in the module tree gets this one
    # set cvscfg(glb_highlight)       "green"
    # set cvscfg(bt_lookhere)         "LightSteelBlue"
    # set cvscfg(bt_pressme)          "green"

    # This is the colour of the ToolTips popup windows.
    set cvscfg(tool_colour)          "LightGoldenrod1"

    # These colours are used to support tag marking.
    # set cvscfg(tagcolour,tkcvs_r6)  "Purple"
    # set cvscfg(tagcolour,tkcvs_r5)  "Blue"
    # set cvscfg(tagcolour,tkcvs_r4)  "Green"
    # set cvscfg(tagcolour,tkcvs_r3)  "Yellow"
    # set cvscfg(tagcolour,tkcvs_r2)  "Orange"
    # set cvscfg(tagcolour,tkcvs_r1)  "Red"
}

#
# If you want to configure the colours via the above options,
# then you will also need to un-comment these lines.  Otherwise
# you can use the Xdefaults method of colouring the windows.
#
# option add *background                 $cvscfg(glb_background)
# option add *activeBackground           $cvscfg(glb_highlight)
# option add *Button.background          $cvscfg(bt_lookhere)
# option add *Button.activeBackground    $cvscfg(bt_pressme)
# option add *Scrollbar.foreground       $cvscfg(bt_lookhere)
# option add *Scrollbar.activeForeground $cvscfg(bt_pressme)
#
# To use the Xdefaults method, put lines like the following into
# your .Xdefaults or .Xresources file:
#
# tkcvs*background:			SkyBlue2
# tkcvs*activeBackground:		green
# tkcvs*Button.background:		LightSteelBlue
# tkcvs*Button.activeBackground:	green
# tkcvs*Scrollbar.background:		LightSteelBlue
# tkcvs*Scrollbar.activeBackground:	green

# Leave this option here so that TkCVS knows what its own background
# colour is.  This is so that it can erase things like file mark dots.
set cvscfg(glb_background) [option get . background Background]

# --------------------
# set the number of file names the listbox should accomodate. 
# -sj
set cvscfg(y_size)             24

# --------------------
# Platform specific configuration.
#
# Decide wether you are unlucky and have to run tkcvs on DOS/WIN
# some things will be setup in the following
#
# Please note that you may have to setup a bit more.
#
if {$tcl_platform(platform) == "windows"} {
    # cvs-dos doesn't like the dot "." in some sub-commands
    set cvscfg(thisdir) ""
    # file mask for all files
    set cvscfg(aster) "*.*"
    # null-device
    set cvscfg(null) "nul"
    # Font preferences for the GUI
    set cvscfg(guifont) {Helvetica -14 bold}
    set cvscfg(dialogfont) {Helvetica -14 bold}
    set cvscfg(listboxfont) {Helvetica -14 normal}
    #
    # Please don't ask me why you have to set -T on DOS,
    # experiments say you have! - CJ
    #
    #set cvs "cvs -T $cvscfg(tmpdir)"
    set cvs "cvs"
    set cvscfg(editor) "notepad"
    set cvscfg(editorargs) {}

    # set temp directory
    set cvscfg(tmpdir) "c:/temp"
    set cvscfg(tkdiff) "$TclExe [file join $ScriptBin tkdiff.tcl]"
    set cvscfg(print_cmd)          "pr"
    set cvscfg(shell)  ""
    #
    # Commands to change file attributes. For lock / unlock.
    # 12-Jan-2000 lcs
    #
    set cvscfg(chmod_ro_cmd) "attrib +R"
    set cvscfg(chmod_rw_cmd) "attrib -R"
    set cvscfg(allow_abort)  "no"
} else {
    set cvscfg(tmpdir) "/tmp"
    set cvscfg(thisdir) "."
    set cvscfg(aster) "*"
    set cvscfg(null) "/dev/null"
    # Font preferences for the GUI
    set cvscfg(guifont) {Helvetica -12 bold}
    set cvscfg(dialogfont) {Helvetica -14 bold}
    set cvscfg(listboxfont) {Helvetica -12 normal}
    #
    # Other defaults
    #
    # Full path to the CVS program if you want to give it,
    # otherwise the PATH environment variable will be searched.
    set cvs "cvs"
    # To override the default editor (setup when tkcvs is configured and 
    # installed) a user can set the cvscfg(editor) variable to the editor
    # of choice in their .tkcvs file (if they have one).
    #set cvscfg(editor) "dtpad"
    set cvscfg(editor) "xterm -e vi"
    set cvscfg(editorargs) {}
    # The file editor to be used may also be identified by pattern-matching the 
    # filename by setting the cvscfg(editors) variable.  This contains a series
    # of string pairs giving the editor-command and string-match-pattern.  The 
    # first pattern (see rules for [string match]) which matches the filename 
    # going down the list determines which editor is run.  If no patterns match 
    # or the option is not set, the cvscfg(editor) value will be used instead.
    # - anj@aps.anl.gov
    #set cvscfg(editors) {
    #    nedit *.html
    #    nedit *.c
    #    bitmap *.xbm
    #    gimp *.xpm
    #    gimp *.gif
    #}
    set cvscfg(tkdiff) "tkdiff"
    #set cvscfg(print_cmd)          "enscript -Ghr -fCourier8"
    set cvscfg(print_cmd)          "lpr"
    # Commands to change file attributes.
    # 12-Jan-2000 lcs
    set cvscfg(chmod_ro_cmd)   "chmod a-w"
    set cvscfg(chmod_rw_cmd)   "chmod u+w"
    set cvscfg(allow_abort)    "yes"
    # What do you want to happen when you ask for a shell?
    set cvscfg(shell) "xterm -name tkcvsxterm -n {TkCVS xterm}"
}

#
# --------------------
# User Menus
#
# Set any of these strings to a cvs command to add to the User Menu
set cvsmenu(Show_My_Checkouts) "history"
set cvsmenu(Show_All_Checkouts) "history -a"
# set usermenu(Merge_Conflicts) "$cvscfg(tkdiff) -conflict "


#
# --------------------
# Other defaults
# These can be set and saved from the GUI.
#

# Set this to 1 to see all files displayed in the directory
# browser (including hidden files) by default.
set cvscfg(allfiles)           0

# set the default log file detail to be reported; one of 
#   "latest"     latest log message on the current branch
#   "summary"    version number and comment string for all check-ins
#   "verbose"    all logfile detail possible, including symbolic tags
set cvscfg(ldetail)            "summary"

# set the default detail for repository and workdir reports; one of
#   "terse"      report "status" only and only on those files which 
#                are not "up-to-date"
#   "summary"    report the "status" and include "up-to-date"
#   "verbose"    provide the report as it would appear unmodified
set cvscfg(rdetail)            "summary"

# set the default pattern to be used by the filter.  Use any valid
# pattern that can be used for a pattern for 'ls'. An empty string
# is equilivant to the entire directory (minus hidden files); 
# i.e., ls *
set cvscfg(file_filter)        ""
set cvscfg(ignore_file_filter) "*.a *.o *~"
set cvscfg(clean_these)        "*.bak *~ *tmp #* *%"

# set the default for automatic statusing of a CVS controlled 
# directory.  Automatic updates are done when a directory is 
# entered and after some operations.
set cvscfg(auto_status)        true

# set the default value for confirmation prompting before performing an
# operation over selected files.
set cvscfg(confirm_prompt)     true

# some of the reporting operations could usefully be recursive.  Set
# the default value here.
set cvscfg(recurse)            false

# Kinds of messages for debugging:
#         C       CVS commands
#         F       File creation/deletion
#         T       Function entry/exit tracing
#         D       Debugging"
set cvscfg(log_classes) "CF"
# On (1) or off (0)
set cvscfg(logging)    0

#
# --------------------
# At the very end, look for a file called "site_def" in the installation
# directory.  That's a good place to define your tagcolours and other
# site-specific things.  It won't be overwritten by installs like this file is.
set tkcvs_path [lrange $auto_path 0 0]
if {[file exists [file join $tkcvs_path site_def]]} {
  source [file join $tkcvs_path site_def]
}

