/***************************************
*                                      *
*   frmConnect Create & Events         *
*                                      *
***************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <math.h> 
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h> 
#include <string.h>
#include <unistd.h>

#include <gdk/gdkkeysyms.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <libintl.h>
#define _(x) gettext(x)

#include "rdpfile.h"
#include "main.h"
#include "support.h"
#include "connect.h"
#include "rdpopen.h"
#include "rdpsave.h"
#include "mrulist.h"

rdp_file *g_rdp_file = NULL;
rdp_file *g_rdp_file_last = NULL;



/***************************************
*                                      *
*   frmConnect Create                  *
*                                      *
***************************************/

GtkWidget*
create_frmConnect (void)
{
  GtkWidget *frmConnect;
  
  GtkWidget *vbxComplete;
  GtkWidget *nbkComplete;
  GtkWidget *alnComplete;
  GtkWidget *vbxCompact;
  GtkWidget *alnCompact;

  GtkWidget *vbxMain;
  GtkWidget *vbxBanner;
  GtkWidget *imgBanner;
  const gchar *lang = (const gchar*)gtk_get_default_language();
  gchar *banner_lang;

  // General Tab Widgets
  GtkWidget *lblGeneralTab1;
  GtkWidget *vbxGeneralTab1;

    // Logon Frame Widgets
    GtkWidget *frameLogon;
    GtkWidget *tblLogon0;
    GtkWidget *tblLogon1;
    GtkWidget *lblLogonFrame;
    GtkWidget *lblLogonNote;
    GtkWidget *imgGeneralLogon;
    GtkWidget *lblComputer0;
    GtkWidget *cboComputer0;
    GtkWidget *txtComputer0;
    GtkWidget *lblUsername;
    GtkWidget *txtUsername;
    GtkWidget *lblPassword;
    GtkWidget *txtPassword;
    GtkWidget *lblDomain;
    GtkWidget *txtDomain;
    GtkWidget *lblClientHostname;
    GtkWidget *txtClientHostname;

    // Connection Frame Widgets
    GtkWidget *frameConnection;
    GtkWidget *lblConnectionFrame;
    GtkWidget *vbxConnection;
    GtkWidget *tblConnection;
    GtkWidget *hbbFileOps;
    GtkWidget *btnSaveAs;
    GtkWidget *btnOpen;
    GtkWidget *imgGeneralConnection;
    GtkWidget *lblFileOpsNote;

  // Display Tab Widgets
  GtkWidget *lblDisplayTab1;
  GtkWidget *vbxDisplayTab1;

    // Size Frame Widgets
    GtkWidget *frameSize;
    GtkWidget *lblSizeFrame;
    GtkWidget *hbxSize;
    GtkWidget *imgSize;
    GtkWidget *vbxSize;
    GtkWidget *optSize1;
    GtkWidget *optSize2;
    GtkWidget *optSize3;
    GtkWidget *alnSizeSlider;
    GtkWidget *tblSizeSlider;
    GtkWidget *lblSizeSmall;
    GtkWidget *lblSizeLarge;
    GtkWidget *sldSize;
    GtkWidget *lblSize;
    GtkWidget *alnAltFullSwitch;
    GtkWidget *chkAltFullSwitch;

    // Color Frame Widgets
    GtkWidget *frameColor;
    GtkWidget *lblColorFrame;
    GtkWidget *hbxColor;
    GtkWidget *imgColor;
    GtkWidget *vbxColor;
    GtkWidget *optColor1;
    GtkWidget *optColor2;
    GtkWidget *alnColorSlider;
    GtkWidget *tblColorSlider;
    GtkWidget *lblColorMore;
    GtkWidget *lblColorLess;
    GtkWidget *sldColor;
    GtkWidget *lblColor;
    GtkWidget *imgColorScale;

  // Local Resources Tab Widgets
  GtkWidget *lblLocalTab1;
  GtkWidget *vbxLocalTab1;

    // Sound Frame Widgets
    GtkWidget *frameSound;
    GtkWidget *lblSoundFrame;
    GtkWidget *tblSound;
    GtkWidget *imgSound;
    GtkWidget *cboSound;
    GtkWidget *txtSound;

    // Keyboard Frame Widgets
    GtkWidget *frameKeyboard;
    GtkWidget *lblKeyboardFrame;
    GtkWidget *tblKeyboard;
    GtkWidget *cboKeyboard;
    GtkWidget *txtKeyboard;
    GtkWidget *lblKeyboardLang;
    GtkWidget *cboKeyboardLang;
    GtkWidget *txtKeyboardLang;
    GtkWidget *lblKeyboard;
    GtkWidget *imgKeyboard;

  // Program Tab Widgets
  GtkWidget *lblProgramsTab1;

    // Program Frame Widgets
    GtkWidget *frameProgram;
    GtkWidget *lblProgramFrame;
    GtkWidget *tblProgram;
    GtkWidget *chkStartProgram;
    GtkWidget *imgProgram;
    GtkWidget *lblProgramPath;
    GtkWidget *txtProgramPath;
    GtkWidget *lblStartFolder;
    GtkWidget *txtStartFolder;

  // Performance Tab Widgets
  GtkWidget *lblPerformanceTab1;

    // Performance Frame Widgets
    GtkWidget *framePerform;
    GtkWidget *lblPerformFrame;
    GtkWidget *tblPerform;
    GtkWidget *imgPerform;
    GtkWidget *lblPerformanceOptions;
    GtkWidget *vbxExpChecks;
    GtkWidget *chkDesktopBackground;
    GtkWidget *chkWindowContent;
    GtkWidget *chkAnimation;
    GtkWidget *chkThemes;
    GtkWidget *chkBitmapCache;
    GtkWidget *chkNoMotionEvents;
    GtkWidget *chkEnableWMKeys;

  // Compact Mode Widgets
  GtkWidget *hbxCompact1;
  GtkWidget *lblComputer1;
  GtkWidget *cboComputer1;
  GtkWidget *txtComputer1;

  // Complete Button Box Widgets
  GtkWidget *hbbAppOps0;
  GtkWidget *btnConnect0;
  GtkWidget *alnConnect0;
  GtkWidget *hbxConnect0;
  GtkWidget *imgConnect0;
  GtkWidget *lblConnect0;
  GtkWidget *btnQuit0;
  GtkWidget *btnHelp0;
  GtkWidget *btnLess;
  GtkWidget *alnLess;
  GtkWidget *hbxLess;
  GtkWidget *imgLess;
  GtkWidget *lblLess;

  // Compact Button Box Widgets
  GtkWidget *hbbAppOps1;
  GtkWidget *btnConnect1;
  GtkWidget *alnConnect1;
  GtkWidget *hbxConnect1;
  GtkWidget *imgConnect1;
  GtkWidget *lblConnect1;
  GtkWidget *btnQuit1;
  GtkWidget *btnHelp1;
  GtkWidget *btnMore;
  GtkWidget *alnMore;
  GtkWidget *hbxMore;
  GtkWidget *imgMore;
  GtkWidget *lblMore;

  // RDP Picker Widgets
  GtkWidget *hbxQuickPick;
  GtkWidget *lblQuickPick;
  GtkWidget *cboQuickPick;
  GtkWidget *txtQuickPick;
  
  GList *cboSound_items = NULL;
  GList *cboKeyboard_items = NULL;
  GSList *optSize1_group = NULL;
  GSList *optColor1_group = NULL;

  GtkTooltips *tooltips;
  tooltips = gtk_tooltips_new ();

  /*
    This is the main form
  */
  frmConnect = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (frmConnect, "frmConnect");
  gtk_window_set_title (GTK_WINDOW (frmConnect), _("Terminal Server Client"));
  gtk_window_set_default_size (GTK_WINDOW (frmConnect), 405, -1);
  gtk_window_set_position (GTK_WINDOW (frmConnect), GTK_WIN_POS_CENTER);
  gtk_window_set_resizable (GTK_WINDOW (frmConnect), FALSE);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (frmConnect), TRUE);
  gtk_window_set_icon (GTK_WINDOW (frmConnect), create_pixbuf ("tsclient.png"));
  
  /*
    This is the main container
  */
  vbxMain = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxMain, "vbxMain");
  gtk_widget_show (vbxMain);
  gtk_container_add (GTK_CONTAINER (frmConnect), vbxMain);

  /*
    This is the banner at the top
  */
  vbxBanner = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxBanner, "vbxBanner");
  gtk_box_pack_start (GTK_BOX (vbxMain), vbxBanner, TRUE, TRUE, 1);
  gtk_widget_show (vbxBanner);

  banner_lang = g_strdup_printf ("banner-%s.png", g_strndup ((!lang)?"en":lang,2));
  imgBanner = create_pixmap (frmConnect, banner_lang);
  g_free (banner_lang);
  //imgBanner = create_pixmap (frmConnect, "banner.png");
  gtk_widget_set_name (imgBanner, "imgBanner");
  gtk_widget_show (imgBanner);
  gtk_box_pack_start (GTK_BOX (vbxBanner), imgBanner, FALSE, TRUE, 0);
  gtk_misc_set_alignment (GTK_MISC (imgBanner), 0.5, 0);

  /*
    This is the complete container
  */
  vbxComplete = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxComplete, "vbxComplete");
  gtk_box_pack_start (GTK_BOX (vbxMain), vbxComplete, TRUE, TRUE, 1);
  gtk_widget_show (vbxComplete);

  alnComplete = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alnComplete, "alnComplete");
  gtk_widget_show (alnComplete);
  gtk_container_add (GTK_CONTAINER (vbxComplete), alnComplete);
  
  /*
    This is the compact container
  */
  vbxCompact = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxCompact, "vbxCompact");
  gtk_box_pack_start (GTK_BOX (vbxMain), vbxCompact, TRUE, TRUE, 2);
  gtk_widget_show (vbxCompact);

  alnCompact = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alnCompact, "alnCompact");
  gtk_widget_show (alnCompact);
  gtk_container_add (GTK_CONTAINER (vbxCompact), alnCompact);
  
  hbxCompact1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbxCompact1, "hbxCompact1");
  gtk_box_pack_start (GTK_BOX (vbxCompact), hbxCompact1, TRUE, TRUE, 0);
  gtk_widget_show (hbxCompact1);
  
 /*
    This is the quick picker
  */
  hbxQuickPick = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbxQuickPick, "hbxQuickPick");
  gtk_box_pack_start (GTK_BOX (vbxMain), hbxQuickPick, TRUE, TRUE, 6);
  gtk_widget_show (hbxQuickPick);

  lblQuickPick = gtk_label_new_with_mnemonic (_("RDP Pic_ker:"));
  gtk_widget_set_name (lblQuickPick, "lblQuickPick");
  gtk_box_pack_start (GTK_BOX (hbxQuickPick), lblQuickPick, TRUE, TRUE, 0);
  gtk_widget_show (lblQuickPick);
  gtk_label_set_justify (GTK_LABEL (lblQuickPick), GTK_JUSTIFY_LEFT);

  cboQuickPick = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (cboQuickPick)->popwin),
                       "GladeParentKey", cboQuickPick);
  gtk_widget_set_name (cboQuickPick, "cboQuickPick");
  gtk_box_pack_start (GTK_BOX (hbxQuickPick), cboQuickPick, TRUE, TRUE, 0);
  //gtk_combo_set_case_sensitive (cboQuickPick, TRUE);
  gtk_combo_set_value_in_list (GTK_COMBO (cboQuickPick), TRUE, TRUE);
  gtk_widget_show (cboQuickPick);

  txtQuickPick = GTK_COMBO (cboQuickPick)->entry;
  gtk_entry_set_activates_default (GTK_ENTRY (txtQuickPick), TRUE);
  gtk_widget_set_name (txtQuickPick, "txtQuickPick");
  gtk_widget_set_sensitive ((GtkWidget *)txtQuickPick, FALSE);
  gtk_widget_show (txtQuickPick);
  
  /*
    This is the button box for the Compact mode
  */
  hbbAppOps1 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbbAppOps1, "hbbAppOps1");
  gtk_box_pack_start (GTK_BOX (vbxMain), hbbAppOps1, FALSE, TRUE, 1);
  gtk_widget_show (hbbAppOps1);
  gtk_container_set_border_width (GTK_CONTAINER (hbbAppOps1), 3);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbbAppOps1), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbbAppOps1), 6);

  btnConnect1 = gtk_button_new ();
  gtk_widget_set_name (btnConnect1, "btnConnect1");
  gtk_widget_show (btnConnect1);
  gtk_container_add (GTK_CONTAINER (hbbAppOps1), btnConnect1);
  GTK_WIDGET_SET_FLAGS (btnConnect1, GTK_CAN_DEFAULT);

  alnConnect1 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alnConnect1, "alnConnect1");
  gtk_widget_show (alnConnect1);
  gtk_container_add (GTK_CONTAINER (btnConnect1), alnConnect1);

  hbxConnect1 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbxConnect1, "hbxConnect1");
  gtk_widget_show (hbxConnect1);
  gtk_container_add (GTK_CONTAINER (alnConnect1), hbxConnect1);

  imgConnect1 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (imgConnect1, "imgConnect1");
  gtk_widget_show (imgConnect1);
  gtk_box_pack_start (GTK_BOX (hbxConnect1), imgConnect1, FALSE, FALSE, 0);

  lblConnect1 = gtk_label_new_with_mnemonic (_("Co_nnect"));
  gtk_widget_set_name (lblConnect1, "lblConnect1");
  gtk_widget_show (lblConnect1);
  gtk_box_pack_start (GTK_BOX (hbxConnect1), lblConnect1, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (lblConnect1), GTK_JUSTIFY_LEFT);


  btnQuit1 = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_set_name (btnQuit1, "btnQuit1");
  gtk_widget_show (btnQuit1);
  gtk_container_add (GTK_CONTAINER (hbbAppOps1), btnQuit1);

  btnHelp1 = gtk_button_new_from_stock ("gtk-help");
  gtk_widget_set_name (btnHelp1, "btnHelp1");
  gtk_widget_show (btnHelp1);
  gtk_container_add (GTK_CONTAINER (hbbAppOps1), btnHelp1);

  btnMore = gtk_button_new ();
  gtk_widget_set_name (btnMore, "btnMore");
  gtk_widget_show (btnMore);
  gtk_container_add (GTK_CONTAINER (hbbAppOps1), btnMore);

  alnMore = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alnMore, "alnMore");
  gtk_widget_show (alnMore);
  gtk_container_add (GTK_CONTAINER (btnMore), alnMore);

  hbxMore = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbxMore, "hbxMore");
  gtk_widget_show (hbxMore);
  gtk_container_add (GTK_CONTAINER (alnMore), hbxMore);

  imgMore = gtk_image_new_from_stock ("gtk-go-down", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (imgMore, "imgMore");
  gtk_widget_show (imgMore);
  gtk_box_pack_start (GTK_BOX (hbxMore), imgMore, FALSE, FALSE, 0);

  lblMore = gtk_label_new_with_mnemonic (_("_More"));
  gtk_widget_set_name (lblMore, "lblMore");
  gtk_widget_show (lblMore);
  gtk_box_pack_start (GTK_BOX (hbxMore), lblMore, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (lblMore), GTK_JUSTIFY_LEFT);

  /*
    This is the input for the Compact mode
  */
  
  lblComputer1 = gtk_label_new_with_mnemonic (_("Compu_ter:"));
  gtk_widget_set_name (lblComputer1, "lblComputer1");
  gtk_box_pack_start (GTK_BOX (hbxCompact1), lblComputer1, TRUE, TRUE, 0);
  gtk_widget_show (lblComputer1);
  gtk_label_set_justify (GTK_LABEL (lblComputer1), GTK_JUSTIFY_LEFT);
  //gtk_misc_set_alignment (GTK_MISC (lblComputer1), 0, 0.5);

  cboComputer1 = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (cboComputer1)->popwin),
                       "GladeParentKey", cboComputer1);
  gtk_widget_set_name (cboComputer1, "cboComputer1");
  gtk_box_pack_start (GTK_BOX (hbxCompact1), cboComputer1, TRUE, TRUE, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (cboComputer1), FALSE, FALSE);
  gtk_widget_show (cboComputer1);

  txtComputer1 = GTK_COMBO (cboComputer1)->entry;
  gtk_entry_set_activates_default (GTK_ENTRY (txtComputer1), TRUE);
  gtk_widget_set_name (txtComputer1, "txtComputer1");
  gtk_widget_show (txtComputer1);


  /*
    This is the notebook for the Complete mode
  */
  nbkComplete = gtk_notebook_new ();
  gtk_widget_set_name (nbkComplete, "nbkComplete");
  gtk_widget_show (nbkComplete);
  gtk_box_pack_start (GTK_BOX (vbxComplete), nbkComplete, TRUE, TRUE, 3);
  gtk_container_set_border_width (GTK_CONTAINER (nbkComplete), 3);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (nbkComplete), FALSE);

  vbxGeneralTab1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxGeneralTab1, "vbxGeneralTab1");
  gtk_widget_show (vbxGeneralTab1);
  gtk_container_add (GTK_CONTAINER (nbkComplete), vbxGeneralTab1);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (nbkComplete), vbxGeneralTab1,
                                      TRUE, TRUE, GTK_PACK_START);
                                      
  /*
    This is the button box for the Complete mode
  */

  hbbAppOps0 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbbAppOps0, "hbbAppOps0");
  gtk_widget_show (hbbAppOps0);
  gtk_box_pack_start (GTK_BOX (vbxMain), hbbAppOps0, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbbAppOps0), 3);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbbAppOps0), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbbAppOps0), 6);

  btnConnect0 = gtk_button_new ();
  gtk_widget_set_name (btnConnect0, "btnConnect0");
  gtk_widget_show (btnConnect0);
  gtk_container_add (GTK_CONTAINER (hbbAppOps0), btnConnect0);
  GTK_WIDGET_SET_FLAGS (btnConnect0, GTK_CAN_DEFAULT);


  alnConnect0 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alnConnect0, "alnConnect0");
  gtk_widget_show (alnConnect0);
  gtk_container_add (GTK_CONTAINER (btnConnect0), alnConnect0);

  hbxConnect0 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbxConnect0, "hbxConnect0");
  gtk_widget_show (hbxConnect0);
  gtk_container_add (GTK_CONTAINER (alnConnect0), hbxConnect0);

  imgConnect0 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (imgConnect0, "imgConnect0");
  gtk_widget_show (imgConnect0);
  gtk_box_pack_start (GTK_BOX (hbxConnect0), imgConnect0, FALSE, FALSE, 0);

  lblConnect0 = gtk_label_new_with_mnemonic (_("Co_nnect"));
  gtk_widget_set_name (lblConnect0, "lblConnect0");
  gtk_widget_show (lblConnect0);
  gtk_box_pack_start (GTK_BOX (hbxConnect0), lblConnect0, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (lblConnect0), GTK_JUSTIFY_LEFT);

  btnQuit0 = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_set_name (btnQuit0, "btnQuit0");
  gtk_widget_show (btnQuit0);
  gtk_container_add (GTK_CONTAINER (hbbAppOps0), btnQuit0);

  btnHelp0 = gtk_button_new_from_stock ("gtk-help");
  gtk_widget_set_name (btnHelp0, "btnHelp0");
  gtk_widget_show (btnHelp0);
  gtk_container_add (GTK_CONTAINER (hbbAppOps0), btnHelp0);

  btnLess = gtk_button_new ();
  gtk_widget_set_name (btnLess, "btnLess");
  gtk_widget_show (btnLess);
  gtk_container_add (GTK_CONTAINER (hbbAppOps0), btnLess);

  alnLess = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alnLess, "alnLess");
  gtk_widget_show (alnLess);
  gtk_container_add (GTK_CONTAINER (btnLess), alnLess);

  hbxLess = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbxLess, "hbxLess");
  gtk_widget_show (hbxLess);
  gtk_container_add (GTK_CONTAINER (alnLess), hbxLess);

  imgLess = gtk_image_new_from_stock ("gtk-go-up", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (imgLess, "imgLess");
  gtk_widget_show (imgLess);
  gtk_box_pack_start (GTK_BOX (hbxLess), imgLess, FALSE, FALSE, 0);

  lblLess = gtk_label_new_with_mnemonic (_("_Less"));
  gtk_widget_set_name (lblLess, "lblLess");
  gtk_widget_show (lblLess);
  gtk_box_pack_start (GTK_BOX (hbxLess), lblLess, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (lblLess), GTK_JUSTIFY_LEFT);

  frameLogon = gtk_frame_new (NULL);
  gtk_widget_set_name (frameLogon, "frameLogon");
  gtk_widget_show (frameLogon);
  gtk_box_pack_start (GTK_BOX (vbxGeneralTab1), frameLogon, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frameLogon), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frameLogon), GTK_SHADOW_NONE);

  lblLogonFrame = gtk_label_new (_("Logon Settings"));
  gtk_widget_set_name (lblLogonFrame, "lblLogonFrame");
  gtk_widget_show (lblLogonFrame);
  gtk_label_set_markup (GTK_LABEL (lblLogonFrame), g_strconcat ("<span weight=\"bold\">", _("Logon Settings"), "</span>", NULL));
  gtk_frame_set_label_widget (GTK_FRAME (frameLogon), lblLogonFrame);
  gtk_label_set_justify (GTK_LABEL (lblLogonFrame), GTK_JUSTIFY_LEFT);

  tblLogon0 = gtk_table_new (2, 2, FALSE);
  gtk_widget_set_name (tblLogon0, "tblLogon0");
  gtk_widget_show (tblLogon0);
  gtk_container_add (GTK_CONTAINER (frameLogon), tblLogon0);

  lblLogonNote = gtk_label_new (_("Type the name of the computer or choose a computer from the drop-down list."));
  gtk_widget_set_name (lblLogonNote, "lblLogonNote");
  gtk_widget_show (lblLogonNote);
  gtk_table_attach (GTK_TABLE (tblLogon0), lblLogonNote, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblLogonNote), GTK_JUSTIFY_LEFT);
  gtk_label_set_line_wrap (GTK_LABEL (lblLogonNote), TRUE);
  gtk_misc_set_alignment (GTK_MISC (lblLogonNote), 0, 0.5);

  imgGeneralLogon = create_pixmap (frmConnect, "computer.png");
  gtk_widget_set_name (imgGeneralLogon, "imgGeneralLogon");
  gtk_widget_show (imgGeneralLogon);
  gtk_table_attach (GTK_TABLE (tblLogon0), imgGeneralLogon, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (imgGeneralLogon), 3, 3);

  tblLogon1 = gtk_table_new (6, 2, FALSE);
  gtk_widget_set_name (tblLogon1, "tblLogon1");
  gtk_widget_show (tblLogon1);
  gtk_table_attach (GTK_TABLE (tblLogon0), tblLogon1, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_table_set_row_spacings (GTK_TABLE (tblLogon1), 6);
  gtk_table_set_col_spacings (GTK_TABLE (tblLogon1), 6);

  lblComputer0 = gtk_label_new_with_mnemonic (_("Compu_ter:"));
  gtk_widget_set_name (lblComputer0, "lblComputer0");
  gtk_widget_show (lblComputer0);
  gtk_table_attach (GTK_TABLE (tblLogon1), lblComputer0, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 6, 6);
  gtk_label_set_justify (GTK_LABEL (lblComputer0), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblComputer0), 0, 0.5);

  lblUsername = gtk_label_new_with_mnemonic (_("_User Name:"));
  gtk_widget_set_name (lblUsername, "lblUsername");
  gtk_widget_show (lblUsername);
  gtk_table_attach (GTK_TABLE (tblLogon1), lblUsername, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 6, 6);
  gtk_label_set_justify (GTK_LABEL (lblUsername), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblUsername), 0, 0.5);

  lblPassword = gtk_label_new_with_mnemonic (_("Pass_word:"));
  gtk_widget_set_name (lblPassword, "lblPassword");
  gtk_widget_show (lblPassword);
  gtk_table_attach (GTK_TABLE (tblLogon1), lblPassword, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 6, 6);
  gtk_label_set_justify (GTK_LABEL (lblPassword), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblPassword), 0, 0.5);

  lblDomain = gtk_label_new_with_mnemonic (_("Do_main:"));
  gtk_widget_set_name (lblDomain, "lblDomain");
  gtk_widget_show (lblDomain);
  gtk_table_attach (GTK_TABLE (tblLogon1), lblDomain, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 6, 6);
  gtk_label_set_justify (GTK_LABEL (lblDomain), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblDomain), 0, 0.5);

  lblClientHostname = gtk_label_new_with_mnemonic (_("C_lient Hostname:"));
  gtk_widget_set_name (lblClientHostname, "lblClientHostname");
  gtk_widget_show (lblClientHostname);
  gtk_table_attach (GTK_TABLE (tblLogon1), lblClientHostname, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 6, 6);
  gtk_label_set_justify (GTK_LABEL (lblClientHostname), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblClientHostname), 0, 0.5);

  cboComputer0 = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (cboComputer0)->popwin),
                       "GladeParentKey", cboComputer0);
  gtk_widget_set_name (cboComputer0, "cboComputer0");
  gtk_combo_set_value_in_list (GTK_COMBO (cboComputer0), FALSE, FALSE);
  gtk_widget_show (cboComputer0);
  gtk_table_attach (GTK_TABLE (tblLogon1), cboComputer0, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  txtComputer0 = GTK_COMBO (cboComputer0)->entry;
  gtk_widget_set_name (txtComputer0, "txtComputer0");
  gtk_entry_set_activates_default (GTK_ENTRY (txtComputer0), TRUE);
  gtk_widget_show (txtComputer0);


  txtUsername = gtk_entry_new ();
  gtk_widget_set_name (txtUsername, "txtUsername");
  gtk_widget_show (txtUsername);
  gtk_entry_set_activates_default (GTK_ENTRY (txtUsername), TRUE);
  gtk_table_attach (GTK_TABLE (tblLogon1), txtUsername, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  txtPassword = gtk_entry_new ();
  gtk_widget_set_name (txtPassword, "txtPassword");
  gtk_widget_show (txtPassword);
  gtk_entry_set_activates_default (GTK_ENTRY (txtPassword), TRUE);
  gtk_table_attach (GTK_TABLE (tblLogon1), txtPassword, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_visibility (GTK_ENTRY (txtPassword), FALSE);

  txtDomain = gtk_entry_new ();
  gtk_widget_set_name (txtDomain, "txtDomain");
  gtk_widget_show (txtDomain);
  gtk_entry_set_activates_default (GTK_ENTRY (txtDomain), TRUE);
  gtk_table_attach (GTK_TABLE (tblLogon1), txtDomain, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  txtClientHostname = gtk_entry_new ();
  gtk_widget_set_name (txtClientHostname, "txtClientHostname");
  gtk_widget_show (txtClientHostname);
  gtk_entry_set_activates_default (GTK_ENTRY (txtClientHostname), TRUE);
  gtk_table_attach (GTK_TABLE (tblLogon1), txtClientHostname, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);


  frameConnection = gtk_frame_new (NULL);
  gtk_widget_set_name (frameConnection, "frameConnection");
  gtk_widget_show (frameConnection);
  gtk_box_pack_start (GTK_BOX (vbxGeneralTab1), frameConnection, TRUE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frameConnection), GTK_SHADOW_NONE);

  lblConnectionFrame = gtk_label_new (_("Connection Settings"));
  gtk_widget_set_name (lblConnectionFrame, "lblConnectionFrame");
  gtk_widget_show (lblConnectionFrame);
  gtk_label_set_markup (GTK_LABEL (lblConnectionFrame), g_strconcat ("<span weight=\"bold\">", _("Connection Settings"), "</span>", NULL));
  gtk_frame_set_label_widget (GTK_FRAME (frameConnection), lblConnectionFrame);
  gtk_label_set_justify (GTK_LABEL (lblConnectionFrame), GTK_JUSTIFY_LEFT);

  vbxConnection = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxConnection, "vbxConnection");
  gtk_widget_show (vbxConnection);
  gtk_container_add (GTK_CONTAINER (frameConnection), vbxConnection);

  tblConnection = gtk_table_new (2, 2, FALSE);
  gtk_widget_set_name (tblConnection, "tblConnection");
  gtk_widget_show (tblConnection);
  gtk_box_pack_start (GTK_BOX (vbxConnection), tblConnection, TRUE, TRUE, 0);

  hbbFileOps = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbbFileOps, "hbbFileOps");
  gtk_widget_show (hbbFileOps);
  gtk_table_attach (GTK_TABLE (tblConnection), hbbFileOps, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbbFileOps), 3);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbbFileOps), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbbFileOps), 6);

  btnSaveAs = gtk_button_new_from_stock ("gtk-save-as");
  gtk_widget_set_name (btnSaveAs, "btnSaveAs");
  gtk_widget_show (btnSaveAs);
  gtk_container_add (GTK_CONTAINER (hbbFileOps), btnSaveAs);

  btnOpen = gtk_button_new_from_stock ("gtk-open");
  gtk_widget_set_name (btnOpen, "btnOpen");
  gtk_widget_show (btnOpen);
  gtk_container_add (GTK_CONTAINER (hbbFileOps), btnOpen);

  imgGeneralConnection = create_pixmap (frmConnect, "directory.png");
  gtk_widget_set_name (imgGeneralConnection, "imgGeneralConnection");
  gtk_widget_show (imgGeneralConnection);
  gtk_table_attach (GTK_TABLE (tblConnection), imgGeneralConnection, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (imgGeneralConnection), 3, 3);

  lblFileOpsNote = gtk_label_new (_("Save the current settings or open saved connection"));
  gtk_widget_set_name (lblFileOpsNote, "lblFileOpsNote");
  gtk_widget_show (lblFileOpsNote);
  gtk_table_attach (GTK_TABLE (tblConnection), lblFileOpsNote, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_line_wrap (GTK_LABEL (lblFileOpsNote), TRUE);
  gtk_label_set_justify (GTK_LABEL (lblFileOpsNote), GTK_JUSTIFY_LEFT);


  vbxDisplayTab1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxDisplayTab1, "vbxDisplayTab1");
  gtk_widget_show (vbxDisplayTab1);
  gtk_container_add (GTK_CONTAINER (nbkComplete), vbxDisplayTab1);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (nbkComplete), vbxDisplayTab1,
                                      TRUE, TRUE, GTK_PACK_START);

  frameSize = gtk_frame_new (NULL);
  gtk_widget_set_name (frameSize, "frameSize");
  gtk_widget_show (frameSize);
  gtk_box_pack_start (GTK_BOX (vbxDisplayTab1), frameSize, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frameSize), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frameSize), GTK_SHADOW_NONE);

  lblSizeFrame = gtk_label_new (_("Remote Desktop Size"));
  gtk_widget_set_name (lblSizeFrame, "lblSizeFrame");
  gtk_widget_show (lblSizeFrame);
  gtk_label_set_markup (GTK_LABEL (lblSizeFrame), g_strconcat ("<span weight=\"bold\">", _("Remote Desktop Size"), "</span>", NULL));
  gtk_frame_set_label_widget (GTK_FRAME (frameSize), lblSizeFrame);
  gtk_label_set_justify (GTK_LABEL (lblSizeFrame), GTK_JUSTIFY_LEFT);

  hbxSize = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbxSize, "hbxSize");
  gtk_container_add (GTK_CONTAINER (frameSize), hbxSize);
  gtk_widget_show (hbxSize);

  imgSize = create_pixmap (frmConnect, "size.png");
  gtk_widget_set_name (imgSize, "imgSize");
  gtk_widget_show (imgSize);
  gtk_box_pack_start (GTK_BOX (hbxSize), imgSize, FALSE, TRUE, 0);
  gtk_misc_set_alignment (GTK_MISC (imgSize), 0, 0);
  gtk_misc_set_padding (GTK_MISC (imgSize), 3, 3);

  vbxSize = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxSize, "vbxSize");
  gtk_box_pack_start (GTK_BOX (hbxSize), vbxSize, TRUE, TRUE, 0);
  gtk_widget_show (vbxSize);

  optSize1 = gtk_radio_button_new_with_mnemonic (NULL, _("Use default screen size"));
  gtk_widget_set_name (optSize1, "optSize1");
  gtk_widget_show (optSize1);
  gtk_box_pack_start (GTK_BOX (vbxSize), optSize1, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (optSize1), 3);
  gtk_tooltips_set_tip (tooltips, optSize1, _("Use the default screen size."), NULL);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (optSize1), optSize1_group);
  optSize1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (optSize1));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (optSize1), TRUE);

  optSize2 = gtk_radio_button_new_with_mnemonic (NULL, _("Use specified screen size"));
  gtk_widget_set_name (optSize2, "optSize2");
  gtk_widget_show (optSize2);
  gtk_box_pack_start (GTK_BOX (vbxSize), optSize2, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (optSize2), 3);
  gtk_tooltips_set_tip (tooltips, optSize2, _("Use the slider to choose the screen size to use."), NULL);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (optSize2), optSize1_group);
  optSize1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (optSize2));

  alnSizeSlider = gtk_alignment_new (0.5, 0.5, 0.88, 1);
  gtk_widget_set_name (alnSizeSlider, "alnSizeSlider");
  gtk_widget_show (alnSizeSlider);
  gtk_box_pack_start (GTK_BOX (vbxSize), alnSizeSlider, FALSE, TRUE, 0);

  tblSizeSlider = gtk_table_new (2, 3, FALSE);
  gtk_widget_set_name (tblSizeSlider, "tblSizeSlider");
  gtk_widget_show (tblSizeSlider);
  gtk_container_add (GTK_CONTAINER (alnSizeSlider), tblSizeSlider);
  gtk_container_set_border_width (GTK_CONTAINER (tblSizeSlider), 3);
  //gtk_table_set_row_spacings (GTK_TABLE (tblSizeSlider), 6);
  gtk_table_set_col_spacings (GTK_TABLE (tblSizeSlider), 6);

  lblSizeSmall = gtk_label_new (_("Small"));
  gtk_widget_set_name (lblSizeSmall, "lblSizeSmall");
  gtk_label_set_markup (GTK_LABEL (lblSizeSmall), g_strconcat ("<span style=\"italic\">", _("Small"), "</span>", NULL));
  gtk_widget_show (lblSizeSmall);
  gtk_table_attach (GTK_TABLE (tblSizeSlider), lblSizeSmall, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblSizeSmall), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblSizeSmall), 0, 0.5);

  lblSizeLarge = gtk_label_new (_("Large"));
  gtk_widget_set_name (lblSizeLarge, "lblSizeLarge");
  gtk_label_set_markup (GTK_LABEL (lblSizeLarge), g_strconcat ("<span style=\"italic\">", _("Large"), "</span>", NULL));
  gtk_widget_show (lblSizeLarge);
  gtk_table_attach (GTK_TABLE (tblSizeSlider), lblSizeLarge, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblSizeLarge), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblSizeLarge), 0, 0.5);

  sldSize = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 4, 1, 1, 0)));
  gtk_widget_set_name (sldSize, "sldSize");
  gtk_widget_show (sldSize);
  gtk_table_attach (GTK_TABLE (tblSizeSlider), sldSize, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_scale_set_draw_value (GTK_SCALE (sldSize), FALSE);
  gtk_range_set_update_policy (GTK_RANGE (sldSize), GTK_UPDATE_DISCONTINUOUS);

  lblSize = gtk_label_new (_("640 x 480 pixels"));
  gtk_widget_set_name (lblSize, "lblSize");
  gtk_widget_show (lblSize);
  gtk_table_attach (GTK_TABLE (tblSizeSlider), lblSize, 1, 2, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (lblSize), TRUE);
  gtk_misc_set_alignment (GTK_MISC (lblSize), 0, 0.5);

  optSize3 = gtk_radio_button_new_with_mnemonic (NULL, _("Operate in full screen mode"));
  gtk_widget_set_name (optSize3, "optSize3");
  gtk_widget_show (optSize3);
  gtk_box_pack_start (GTK_BOX (vbxSize), optSize3, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (optSize3), 3);
  gtk_tooltips_set_tip (tooltips, optSize3, _("Work in full screen mode."), NULL);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (optSize3), optSize1_group);
  optSize1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (optSize3));

  alnAltFullSwitch = gtk_alignment_new (0.5, 0.5, 0.88, 1);
  gtk_widget_set_name (alnAltFullSwitch, "alnAltFullSwitch");
  gtk_widget_show (alnAltFullSwitch);
  gtk_box_pack_start (GTK_BOX (vbxSize), alnAltFullSwitch, FALSE, FALSE, 0);
  gtk_widget_set_sensitive (alnAltFullSwitch, FALSE);

  chkAltFullSwitch = gtk_check_button_new_with_mnemonic (_("Use alternate full screen switch (-F)"));
  gtk_widget_set_name (chkAltFullSwitch, "chkAltFullSwitch");
  gtk_widget_show (chkAltFullSwitch);
  gtk_container_add (GTK_CONTAINER (alnAltFullSwitch), chkAltFullSwitch);
  gtk_container_set_border_width (GTK_CONTAINER (chkAltFullSwitch), 3);
  gtk_tooltips_set_tip (tooltips, chkAltFullSwitch, _("Check this if you use rdesktop with the unified patches."), NULL);


  frameColor = gtk_frame_new (NULL);
  gtk_widget_set_name (frameColor, "frameColor");
  gtk_widget_show (frameColor);
  gtk_box_pack_start (GTK_BOX (vbxDisplayTab1), frameColor, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frameColor), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frameColor), GTK_SHADOW_NONE);

  lblColorFrame = gtk_label_new (_("Colors"));
  gtk_widget_set_name (lblColorFrame, "lblColorFrame");
  gtk_widget_show (lblColorFrame);
  gtk_label_set_markup (GTK_LABEL (lblColorFrame), g_strconcat ("<span weight=\"bold\">", _("Colors"), "</span>", NULL));
  gtk_frame_set_label_widget (GTK_FRAME (frameColor), lblColorFrame);
  gtk_label_set_justify (GTK_LABEL (lblColorFrame), GTK_JUSTIFY_LEFT);

  hbxColor = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbxColor, "hbxColor");
  gtk_container_add (GTK_CONTAINER (frameColor), hbxColor);
  gtk_widget_show (hbxColor);

  imgColor = create_pixmap (frmConnect, "colors.png");
  gtk_widget_set_name (imgColor, "imgColor");
  gtk_widget_show (imgColor);
  gtk_box_pack_start (GTK_BOX (hbxColor), imgColor, FALSE, TRUE, 0);
  gtk_misc_set_alignment (GTK_MISC (imgColor), 0, 0);
  gtk_misc_set_padding (GTK_MISC (imgColor), 3, 3);

  vbxColor = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxColor, "vbxColor");
  gtk_box_pack_start (GTK_BOX (hbxColor), vbxColor, TRUE, TRUE, 0);
  gtk_widget_show (vbxColor);

  optColor1 = gtk_radio_button_new_with_mnemonic (NULL, _("Use default color depth"));
  gtk_widget_set_name (optColor1, "optColor1");
  gtk_widget_show (optColor1);
  gtk_box_pack_start (GTK_BOX (vbxColor), optColor1, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (optColor1), 3);
  gtk_tooltips_set_tip (tooltips, optColor1, _("Use the default color depth."), NULL);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (optColor1), optColor1_group);
  optColor1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (optColor1));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (optColor1), TRUE);

  optColor2 = gtk_radio_button_new_with_mnemonic (NULL, _("Use specified color depth"));
  gtk_widget_set_name (optColor2, "optColor2");
  gtk_widget_show (optColor2);
  gtk_box_pack_start (GTK_BOX (vbxColor), optColor2, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (optColor2), 3);
  gtk_tooltips_set_tip (tooltips, optColor2, _("Use the slider to choose the color depth to use."), NULL);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (optColor2), optColor1_group);
  optColor1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (optColor2));

  alnColorSlider = gtk_alignment_new (0.5, 0.5, 0.88, 1);
  gtk_widget_set_name (alnColorSlider, "alnColorSlider");
  gtk_widget_show (alnColorSlider);
  gtk_box_pack_start (GTK_BOX (vbxColor), alnColorSlider, FALSE, TRUE, 0);

  tblColorSlider = gtk_table_new (3, 3, FALSE);
  gtk_widget_set_name (tblColorSlider, "tblColorSlider");
  gtk_widget_show (tblColorSlider);
  gtk_container_add (GTK_CONTAINER (alnColorSlider), tblColorSlider);
  gtk_container_set_border_width (GTK_CONTAINER (tblColorSlider), 3);
  //gtk_table_set_row_spacings (GTK_TABLE (tblColorSlider), 6);
  gtk_table_set_col_spacings (GTK_TABLE (tblColorSlider), 6);

  lblColorLess = gtk_label_new (_("Less"));
  gtk_widget_set_name (lblColorLess, "lblColorLess");
  gtk_label_set_markup (GTK_LABEL (lblColorLess), g_strconcat ("<span style=\"italic\">", _("Less"), "</span>", NULL));
  gtk_widget_show (lblColorLess);
  gtk_table_attach (GTK_TABLE (tblColorSlider), lblColorLess, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblColorLess), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblColorLess), 0, 0.5);

  lblColorMore = gtk_label_new (_("More"));
  gtk_widget_set_name (lblColorMore, "lblColorMore");
  gtk_label_set_markup (GTK_LABEL (lblColorMore), g_strconcat ("<span style=\"italic\">", _("More"), "</span>", NULL));
  gtk_widget_show (lblColorMore);
  gtk_table_attach (GTK_TABLE (tblColorSlider), lblColorMore, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblColorMore), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblColorMore), 0, 0.5);

  sldColor = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 3, 1, 1, 0)));
  gtk_widget_set_name (sldColor, "sldColor");
  gtk_widget_show (sldColor);
  gtk_table_attach (GTK_TABLE (tblColorSlider), sldColor, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_scale_set_draw_value (GTK_SCALE (sldColor), FALSE);
  gtk_range_set_update_policy (GTK_RANGE (sldColor), GTK_UPDATE_DISCONTINUOUS);

  lblColor = gtk_label_new (_("256 Colors"));
  gtk_widget_set_name (lblColor, "lblColor");
  gtk_widget_show (lblColor);
  gtk_table_attach (GTK_TABLE (tblColorSlider), lblColor, 1, 2, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (lblColor), TRUE);
  gtk_misc_set_alignment (GTK_MISC (lblColor), 0, 0.5);

  imgColorScale = create_pixmap (frmConnect, "colors-hi.png");
  gtk_widget_set_name (imgColorScale, "imgColorScale");
  gtk_widget_show (imgColorScale);
  gtk_table_attach (GTK_TABLE (tblColorSlider), imgColorScale, 1, 2, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (imgColorScale), 0, 0.5);


  vbxLocalTab1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxLocalTab1, "vbxLocalTab1");
  gtk_widget_show (vbxLocalTab1);
  gtk_container_add (GTK_CONTAINER (nbkComplete), vbxLocalTab1);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (nbkComplete), vbxLocalTab1,
                                      TRUE, TRUE, GTK_PACK_START);

  frameSound = gtk_frame_new (NULL);
  gtk_widget_set_name (frameSound, "frameSound");
  gtk_widget_show (frameSound);
  gtk_box_pack_start (GTK_BOX (vbxLocalTab1), frameSound, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frameSound), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frameSound), GTK_SHADOW_NONE);

  lblSoundFrame = gtk_label_new_with_mnemonic (_("Remote Computer _Sound (unsupported)"));
  gtk_widget_set_name (lblSoundFrame, "lblSoundFrame");
  gtk_widget_show (lblSoundFrame);
  gtk_label_set_markup (GTK_LABEL (lblSoundFrame), g_strconcat ("<span weight=\"bold\">", _("Remote Computer Sound (unsupported)"), "</span>", NULL));
  gtk_frame_set_label_widget (GTK_FRAME (frameSound), lblSoundFrame);
  gtk_label_set_justify (GTK_LABEL (lblSoundFrame), GTK_JUSTIFY_LEFT);

  tblSound = gtk_table_new (1, 2, FALSE);
  gtk_widget_set_name (tblSound, "tblSound");
  gtk_widget_show (tblSound);
  gtk_container_add (GTK_CONTAINER (frameSound), tblSound);
  gtk_table_set_col_spacings (GTK_TABLE (tblSound), 6);

  imgSound = create_pixmap (frmConnect, "sound.png");
  gtk_widget_set_name (imgSound, "imgSound");
  gtk_widget_show (imgSound);
  gtk_misc_set_padding (GTK_MISC (imgSound), 3, 3);
  gtk_table_attach (GTK_TABLE (tblSound), imgSound, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) 0, 0, 0);

  cboSound = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (cboSound)->popwin),
                       "GladeParentKey", cboSound);
  gtk_widget_set_name (cboSound, "cboSound");
  gtk_widget_show (cboSound);
  gtk_table_attach (GTK_TABLE (tblSound), cboSound, 1, 2, 0, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (cboSound), TRUE, TRUE);
  cboSound_items = g_list_append (cboSound_items, (gpointer) _("Bring to this computer"));
  cboSound_items = g_list_append (cboSound_items, (gpointer) _("Leave at remote computer"));
  cboSound_items = g_list_append (cboSound_items, (gpointer) _("Do not play"));
  gtk_combo_set_popdown_strings (GTK_COMBO (cboSound), cboSound_items);
  g_list_free (cboSound_items);
  
  txtSound = GTK_COMBO (cboSound)->entry;
  gtk_widget_set_name (txtSound, "txtSound");
  gtk_widget_show (txtSound);
  gtk_widget_set_sensitive (txtSound, FALSE);

  frameKeyboard = gtk_frame_new (NULL);
  gtk_widget_set_name (frameKeyboard, "frameKeyboard");
  gtk_widget_show (frameKeyboard);
  gtk_box_pack_start (GTK_BOX (vbxLocalTab1), frameKeyboard, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frameKeyboard), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frameKeyboard), GTK_SHADOW_NONE);

  lblKeyboardFrame = gtk_label_new_with_mnemonic (_("_Keyboard"));
  gtk_widget_set_name (lblKeyboardFrame, "lblKeyboardFrame");
  gtk_widget_show (lblKeyboardFrame);
  gtk_label_set_markup (GTK_LABEL (lblKeyboardFrame), g_strconcat ("<span weight=\"bold\">", _("Keyboard"), "</span>", NULL));
  gtk_frame_set_label_widget (GTK_FRAME (frameKeyboard), lblKeyboardFrame);
  gtk_label_set_justify (GTK_LABEL (lblKeyboardFrame), GTK_JUSTIFY_LEFT);

  tblKeyboard = gtk_table_new (2, 2, FALSE);
  gtk_widget_set_name (tblKeyboard, "tblKeyboard");
  gtk_widget_show (tblKeyboard);
  gtk_container_add (GTK_CONTAINER (frameKeyboard), tblKeyboard);
  gtk_table_set_col_spacings (GTK_TABLE (tblKeyboard), 6);

  cboKeyboard = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (cboKeyboard)->popwin),
                       "GladeParentKey", cboKeyboard);
  gtk_widget_set_name (cboKeyboard, "cboKeyboard");
  gtk_widget_show (cboKeyboard);
  gtk_table_attach (GTK_TABLE (tblKeyboard), cboKeyboard, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) _("On the local computer"));
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) _("On the remote computer"));
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) _("In full screen mode only"));
  gtk_combo_set_popdown_strings (GTK_COMBO (cboKeyboard), cboKeyboard_items);
  g_list_free (cboKeyboard_items);
  
  txtKeyboard = GTK_COMBO (cboKeyboard)->entry;
  gtk_widget_set_name (txtKeyboard, "txtKeyboard");
  gtk_widget_show (txtKeyboard);
  gtk_widget_set_sensitive (txtKeyboard, FALSE);


  lblKeyboardLang = gtk_label_new (_("Use the following keyboard language\n(2 char keycode)"));
  gtk_widget_set_name (lblKeyboardLang, "lblKeyboardLang");
  gtk_widget_show (lblKeyboardLang);
  gtk_table_attach (GTK_TABLE (tblKeyboard), lblKeyboardLang, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblKeyboardLang), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblKeyboardLang), 0, 0.5);

  cboKeyboardLang = gtk_combo_new ();
  gtk_object_set_data ( GTK_OBJECT ( GTK_COMBO ( cboKeyboardLang)->popwin ),
			"GladeParentLangKey", cboKeyboardLang );
  gtk_widget_set_name ( cboKeyboardLang, "cboKeyboardLang" );
  gtk_widget_show ( cboKeyboardLang );
  gtk_table_attach (GTK_TABLE (tblKeyboard), cboKeyboardLang, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  cboKeyboard_items = NULL;
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "be");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "bg");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "br");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "cf");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "ch");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "cz");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "dk");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "dv");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "et");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "fr");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "gk");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "gr");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "hu");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "is");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "it");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "jp");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "ko");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "la");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "nl");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "no");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "pl");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "po");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "ro");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "ru");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "sf");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "sl");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "sp");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "su");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "sv");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "tr");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "uk");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "us");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "usl");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "usr");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "yu");
  gtk_combo_set_popdown_strings (GTK_COMBO (cboKeyboardLang), cboKeyboard_items);
  g_list_free (cboKeyboard_items);  

  txtKeyboardLang = GTK_COMBO (cboKeyboardLang)->entry;
  gtk_widget_set_name (txtKeyboardLang, "txtKeyboardLang");
  gtk_widget_show (txtKeyboardLang);

  lblKeyboard = gtk_label_new (_("Apply Windows key combinations\n(for example ALT+TAB) (unsupported)"));
  gtk_widget_set_name (lblKeyboard, "lblKeyboard");
  gtk_widget_show (lblKeyboard);
  gtk_table_attach (GTK_TABLE (tblKeyboard), lblKeyboard, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblKeyboard), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblKeyboard), 0, 0.5);

  imgKeyboard = create_pixmap (frmConnect, "keyboard.png");
  gtk_widget_set_name (imgKeyboard, "imgKeyboard");
  gtk_widget_show (imgKeyboard);
  gtk_table_attach (GTK_TABLE (tblKeyboard), imgKeyboard, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) 0, 0, 0);
  gtk_misc_set_padding (GTK_MISC (imgKeyboard), 3, 3);

  frameProgram = gtk_frame_new (NULL);
  gtk_widget_set_name (frameProgram, "frameProgram");
  gtk_widget_show (frameProgram);
  gtk_container_add (GTK_CONTAINER (nbkComplete), frameProgram);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (nbkComplete), frameProgram,
                                      TRUE, TRUE, GTK_PACK_START);
  gtk_container_set_border_width (GTK_CONTAINER (frameProgram), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frameProgram), GTK_SHADOW_NONE);

  lblProgramFrame = gtk_label_new (_("Start a Program"));
  gtk_widget_set_name (lblProgramFrame, "lblProgramFrame");
  gtk_widget_show (lblProgramFrame);
  gtk_label_set_markup (GTK_LABEL (lblProgramFrame), g_strconcat ("<span weight=\"bold\">", _("Start a Program"), "</span>", NULL));
  gtk_frame_set_label_widget (GTK_FRAME (frameProgram), lblProgramFrame);
  gtk_label_set_justify (GTK_LABEL (lblProgramFrame), GTK_JUSTIFY_LEFT);

  tblProgram = gtk_table_new (2, 5, FALSE);
  gtk_widget_set_name (tblProgram, "tblProgram");
  gtk_widget_show (tblProgram);
  gtk_container_add (GTK_CONTAINER (frameProgram), tblProgram);

  imgProgram = create_pixmap (frmConnect, "program.png");
  gtk_widget_set_name (imgProgram, "imgProgram");
  gtk_widget_show (imgProgram);
  gtk_table_attach (GTK_TABLE (tblProgram), imgProgram, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_misc_set_padding (GTK_MISC (imgProgram), 3, 3);

  chkStartProgram = gtk_check_button_new_with_mnemonic (_("Start the following program on connection"));
  gtk_widget_set_name (chkStartProgram, "chkStartProgram");
  gtk_widget_show (chkStartProgram);
  gtk_table_attach (GTK_TABLE (tblProgram), chkStartProgram, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (chkStartProgram), 3);

  lblProgramPath = gtk_label_new (_("Program path and filename"));
  gtk_widget_set_name (lblProgramPath, "lblProgramPath");
  gtk_widget_show (lblProgramPath);
  gtk_table_attach (GTK_TABLE (tblProgram), lblProgramPath, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblProgramPath), GTK_JUSTIFY_LEFT);

  txtProgramPath = gtk_entry_new ();
  gtk_widget_set_name (txtProgramPath, "txtProgramPath");
  gtk_widget_show (txtProgramPath);
  gtk_table_attach (GTK_TABLE (tblProgram), txtProgramPath, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  lblStartFolder = gtk_label_new (_("Start in the following folder"));
  gtk_widget_set_name (lblStartFolder, "lblStartFolder");
  gtk_widget_show (lblStartFolder);
  gtk_table_attach (GTK_TABLE (tblProgram), lblStartFolder, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblStartFolder), GTK_JUSTIFY_LEFT);

  txtStartFolder = gtk_entry_new ();
  gtk_widget_set_name (txtStartFolder, "txtStartFolder");
  gtk_widget_show (txtStartFolder);
  gtk_table_attach (GTK_TABLE (tblProgram), txtStartFolder, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);


  framePerform = gtk_frame_new (NULL);
  gtk_widget_set_name (framePerform, "framePerform");
  gtk_widget_show (framePerform);
  gtk_container_add (GTK_CONTAINER (nbkComplete), framePerform);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (nbkComplete), framePerform,
                                      TRUE, TRUE, GTK_PACK_START);
  gtk_container_set_border_width (GTK_CONTAINER (framePerform), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (framePerform), GTK_SHADOW_NONE);

  lblPerformFrame = gtk_label_new (_("Optimize Performance"));
  gtk_widget_set_name (lblPerformFrame, "lblPerformFrame");
  gtk_widget_show (lblPerformFrame);
  gtk_label_set_markup (GTK_LABEL (lblPerformFrame), g_strconcat ("<span weight=\"bold\">", _("Optimize Performance"), "</span>", NULL));
  gtk_frame_set_label_widget (GTK_FRAME (framePerform), lblPerformFrame);
  gtk_label_set_justify (GTK_LABEL (lblPerformFrame), GTK_JUSTIFY_LEFT);

  tblPerform = gtk_table_new (2, 2, FALSE);
  gtk_widget_set_name (tblPerform, "tblPerform");
  gtk_widget_show (tblPerform);
  gtk_container_add (GTK_CONTAINER (framePerform), tblPerform);

  imgPerform = create_pixmap (frmConnect, "perform.png");
  gtk_widget_set_name (imgPerform, "imgPerform");
  gtk_widget_show (imgPerform);
  gtk_table_attach (GTK_TABLE (tblPerform), imgPerform, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_misc_set_padding (GTK_MISC (imgPerform), 3, 3);

  vbxExpChecks = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxExpChecks, "vbxExpChecks");
  gtk_widget_show (vbxExpChecks);
  gtk_table_attach (GTK_TABLE (tblPerform), vbxExpChecks, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  chkDesktopBackground = gtk_check_button_new_with_mnemonic (_("Desktop background (u)"));
  gtk_widget_set_name (chkDesktopBackground, "chkDesktopBackground");
  //gtk_widget_show (chkDesktopBackground);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), chkDesktopBackground, FALSE, FALSE, 0);

  chkWindowContent = gtk_check_button_new_with_mnemonic (_("Show content of window while dragging (u)"));
  gtk_widget_set_name (chkWindowContent, "chkWindowContent");
  //gtk_widget_show (chkWindowContent);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), chkWindowContent, FALSE, FALSE, 0);

  chkAnimation = gtk_check_button_new_with_mnemonic (_("Menu and window animation (u)"));
  gtk_widget_set_name (chkAnimation, "chkAnimation");
  //gtk_widget_show (chkAnimation);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), chkAnimation, FALSE, FALSE, 0);

  chkThemes = gtk_check_button_new_with_mnemonic (_("Themes (u)"));
  gtk_widget_set_name (chkThemes, "chkThemes");
  //gtk_widget_show (chkThemes);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), chkThemes, FALSE, FALSE, 0);

  chkBitmapCache = gtk_check_button_new_with_mnemonic (_("Enable bitmap caching"));
  gtk_widget_set_name (chkBitmapCache, "chkBitmapCache");
  gtk_widget_show (chkBitmapCache);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), chkBitmapCache, FALSE, FALSE, 0);

  chkNoMotionEvents = gtk_check_button_new_with_mnemonic (_("Do not send motion events"));
  gtk_widget_set_name (chkNoMotionEvents, "chkNoMotionEvents");
  gtk_widget_show (chkNoMotionEvents);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), chkNoMotionEvents, FALSE, FALSE, 0);

  chkEnableWMKeys = gtk_check_button_new_with_mnemonic (_("Enable window manager's key bindings"));
  gtk_widget_set_name (chkEnableWMKeys, "chkEnableWMKeys");
  gtk_widget_show (chkEnableWMKeys);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), chkEnableWMKeys, FALSE, FALSE, 0);




  lblPerformanceOptions = gtk_label_new (_("Options available for optimizing performance"));
  gtk_widget_set_name (lblPerformanceOptions, "lblPerformanceOptions");
  gtk_widget_show (lblPerformanceOptions);
  gtk_table_attach (GTK_TABLE (tblPerform), lblPerformanceOptions, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblPerformanceOptions), GTK_JUSTIFY_LEFT);
  gtk_label_set_line_wrap (GTK_LABEL (lblPerformanceOptions), TRUE);
  gtk_misc_set_alignment (GTK_MISC (lblPerformanceOptions), 0, 0.5);

  /*
    This is the labels for the notebook control
  */

  lblGeneralTab1 = gtk_label_new_with_mnemonic (_("_General"));
  gtk_widget_set_name (lblGeneralTab1, "lblGeneralTab1");
  gtk_widget_show (lblGeneralTab1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (nbkComplete), gtk_notebook_get_nth_page (GTK_NOTEBOOK (nbkComplete), 0), lblGeneralTab1);
  gtk_label_set_justify (GTK_LABEL (lblGeneralTab1), GTK_JUSTIFY_LEFT);

  lblDisplayTab1 = gtk_label_new_with_mnemonic (_("_Display"));
  gtk_widget_set_name (lblDisplayTab1, "lblDisplayTab1");
  gtk_widget_show (lblDisplayTab1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (nbkComplete), gtk_notebook_get_nth_page (GTK_NOTEBOOK (nbkComplete), 1), lblDisplayTab1);
  gtk_label_set_justify (GTK_LABEL (lblDisplayTab1), GTK_JUSTIFY_LEFT);

  lblLocalTab1 = gtk_label_new_with_mnemonic (_("Local _Resources"));
  gtk_widget_set_name (lblLocalTab1, "lblLocalTab1");
  gtk_widget_show (lblLocalTab1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (nbkComplete), gtk_notebook_get_nth_page (GTK_NOTEBOOK (nbkComplete), 2), lblLocalTab1);
  gtk_label_set_justify (GTK_LABEL (lblLocalTab1), GTK_JUSTIFY_LEFT);

  lblProgramsTab1 = gtk_label_new_with_mnemonic (_("_Programs"));
  gtk_widget_set_name (lblProgramsTab1, "lblProgramsTab1");
  gtk_widget_show (lblProgramsTab1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (nbkComplete), gtk_notebook_get_nth_page (GTK_NOTEBOOK (nbkComplete), 3), lblProgramsTab1);
  gtk_label_set_justify (GTK_LABEL (lblProgramsTab1), GTK_JUSTIFY_LEFT);

  lblPerformanceTab1 = gtk_label_new_with_mnemonic (_("Perf_ormance"));
  gtk_widget_set_name (lblPerformanceTab1, "lblPerformanceTab1");
  gtk_widget_show (lblPerformanceTab1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (nbkComplete), gtk_notebook_get_nth_page (GTK_NOTEBOOK (nbkComplete), 4), lblPerformanceTab1);
  gtk_label_set_justify (GTK_LABEL (lblPerformanceTab1), GTK_JUSTIFY_LEFT);


  gtk_label_set_mnemonic_widget (GTK_LABEL (lblComputer0), txtComputer1);
  gtk_label_set_mnemonic_widget (GTK_LABEL (lblComputer1), txtComputer0);
  gtk_label_set_mnemonic_widget (GTK_LABEL (lblUsername), txtUsername);
  gtk_label_set_mnemonic_widget (GTK_LABEL (lblPassword), txtPassword);
  gtk_label_set_mnemonic_widget (GTK_LABEL (lblDomain), txtDomain);
  gtk_label_set_mnemonic_widget (GTK_LABEL (lblClientHostname), txtClientHostname);

  gtk_signal_connect (GTK_OBJECT (frmConnect), "destroy_event",
                      GTK_SIGNAL_FUNC (gtk_main_quit),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (frmConnect), "delete_event",
                      GTK_SIGNAL_FUNC (gtk_main_quit),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnConnect0), "clicked",
                      GTK_SIGNAL_FUNC (on_btnConnect0_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnConnect1), "clicked",
                      GTK_SIGNAL_FUNC (on_btnConnect1_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnQuit0), "clicked",
                      GTK_SIGNAL_FUNC (on_btnQuit_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnQuit1), "clicked",
                      GTK_SIGNAL_FUNC (on_btnQuit_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnHelp0), "clicked",
                      GTK_SIGNAL_FUNC (on_btnHelp_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnHelp1), "clicked",
                      GTK_SIGNAL_FUNC (on_btnHelp_clicked),
                      NULL);

  gtk_signal_connect (GTK_OBJECT (optSize1), "clicked",
                      GTK_SIGNAL_FUNC (on_optSize1_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (optSize2), "clicked",
                      GTK_SIGNAL_FUNC (on_optSize2_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (optSize3), "clicked",
                      GTK_SIGNAL_FUNC (on_optSize3_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (sldSize), "value_changed",
                      GTK_SIGNAL_FUNC (on_sldSize_value_changed),
                      NULL);

  gtk_signal_connect (GTK_OBJECT (optColor1), "clicked",
                      GTK_SIGNAL_FUNC (on_optColor1_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (optColor2), "clicked",
                      GTK_SIGNAL_FUNC (on_optColor2_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (sldColor), "value_changed",
                      GTK_SIGNAL_FUNC (on_sldColor_value_changed),
                      NULL);

  gtk_signal_connect (GTK_OBJECT (btnSaveAs), "clicked",
                      GTK_SIGNAL_FUNC (on_btnSaveAs_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnOpen), "clicked",
                      GTK_SIGNAL_FUNC (on_btnOpen_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnMore), "clicked",
                      GTK_SIGNAL_FUNC (on_btnMore_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnLess), "clicked",
                      GTK_SIGNAL_FUNC (on_btnLess_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (txtQuickPick), "changed",
                      GTK_SIGNAL_FUNC (on_txtQuickPick_changed),
                      NULL);
  gtk_signal_connect ((gpointer) chkStartProgram, "toggled",
                      G_CALLBACK (on_chkStartProgram_toggled),
                      NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (frmConnect, frmConnect, "frmConnect");

  GLADE_HOOKUP_OBJECT (frmConnect, vbxComplete, "vbxComplete");
  GLADE_HOOKUP_OBJECT (frmConnect, nbkComplete, "nbkComplete");
  GLADE_HOOKUP_OBJECT (frmConnect, alnComplete, "alnComplete");
  //GLADE_HOOKUP_OBJECT (frmConnect, lblLess, "alnComplete");
  GLADE_HOOKUP_OBJECT (frmConnect, vbxCompact, "vbxCompact");
  GLADE_HOOKUP_OBJECT (frmConnect, alnCompact, "alnCompact");
  //GLADE_HOOKUP_OBJECT (frmConnect, lblLess, "alnCompact");

  GLADE_HOOKUP_OBJECT (frmConnect, vbxMain, "vbxMain");
  GLADE_HOOKUP_OBJECT (frmConnect, vbxBanner, "vbxBanner");
  GLADE_HOOKUP_OBJECT (frmConnect, imgBanner, "imgBanner");

  // General Tab Widgets
  GLADE_HOOKUP_OBJECT (frmConnect, lblGeneralTab1, "lblGeneralTab1");
  GLADE_HOOKUP_OBJECT (frmConnect, vbxGeneralTab1, "vbxGeneralTab1");

    // Logon Frame Widgets
    GLADE_HOOKUP_OBJECT (frmConnect, frameLogon, "frameLogon");
    GLADE_HOOKUP_OBJECT (frmConnect, lblLogonFrame, "lblLogonFrame");
    GLADE_HOOKUP_OBJECT (frmConnect, tblLogon0, "tblLogon0");
    GLADE_HOOKUP_OBJECT (frmConnect, tblLogon1, "tblLogon1");
    GLADE_HOOKUP_OBJECT (frmConnect, lblLogonNote, "lblLogonNote");
    GLADE_HOOKUP_OBJECT (frmConnect, imgGeneralLogon, "imgGeneralLogon");
    GLADE_HOOKUP_OBJECT (frmConnect, lblComputer0, "lblComputer0");
    GLADE_HOOKUP_OBJECT (frmConnect, cboComputer0, "cboComputer0");
    GLADE_HOOKUP_OBJECT (frmConnect, txtComputer0, "txtComputer0");
    GLADE_HOOKUP_OBJECT (frmConnect, lblUsername, "lblUsername");
    GLADE_HOOKUP_OBJECT (frmConnect, txtUsername, "txtUsername");
    GLADE_HOOKUP_OBJECT (frmConnect, lblPassword, "lblPassword");
    GLADE_HOOKUP_OBJECT (frmConnect, txtPassword, "txtPassword");
    GLADE_HOOKUP_OBJECT (frmConnect, lblDomain, "lblDomain");
    GLADE_HOOKUP_OBJECT (frmConnect, txtDomain, "txtDomain");
    GLADE_HOOKUP_OBJECT (frmConnect, lblClientHostname, "lblClientHostname");
    GLADE_HOOKUP_OBJECT (frmConnect, txtClientHostname, "txtClientHostname");

    // Connection Frame Widgets
    GLADE_HOOKUP_OBJECT (frmConnect, frameConnection, "frameConnection");
    GLADE_HOOKUP_OBJECT (frmConnect, lblConnectionFrame, "lblConnectionFrame");
    GLADE_HOOKUP_OBJECT (frmConnect, vbxConnection, "vbxConnection");
    GLADE_HOOKUP_OBJECT (frmConnect, tblConnection, "tblConnection");
    GLADE_HOOKUP_OBJECT (frmConnect, hbbFileOps, "hbbFileOps");
    GLADE_HOOKUP_OBJECT (frmConnect, btnSaveAs, "btnSaveAs");
    GLADE_HOOKUP_OBJECT (frmConnect, btnOpen, "btnOpen");
    GLADE_HOOKUP_OBJECT (frmConnect, imgGeneralConnection, "imgGeneralConnection");
    GLADE_HOOKUP_OBJECT (frmConnect, lblFileOpsNote, "lblFileOpsNote");

  // Display Tab Widgets
  GLADE_HOOKUP_OBJECT (frmConnect, lblDisplayTab1, "lblDisplayTab1");
  GLADE_HOOKUP_OBJECT (frmConnect, vbxDisplayTab1, "vbxDisplayTab1");

    // Size Frame Widgets
    GLADE_HOOKUP_OBJECT (frmConnect, frameSize, "frameSize");
    GLADE_HOOKUP_OBJECT (frmConnect, lblSizeFrame, "lblSizeFrame");
    GLADE_HOOKUP_OBJECT (frmConnect, hbxSize, "hbxSize");
    GLADE_HOOKUP_OBJECT (frmConnect, imgSize, "imgSize");
    GLADE_HOOKUP_OBJECT (frmConnect, vbxSize, "vbxSize");
    GLADE_HOOKUP_OBJECT (frmConnect, optSize1, "optSize1");
    GLADE_HOOKUP_OBJECT (frmConnect, optSize2, "optSize2");
    GLADE_HOOKUP_OBJECT (frmConnect, alnSizeSlider, "alnSizeSlider");
    GLADE_HOOKUP_OBJECT (frmConnect, tblSizeSlider, "tblSizeSlider");
    GLADE_HOOKUP_OBJECT (frmConnect, lblSizeSmall, "lblSizeSmall");
    GLADE_HOOKUP_OBJECT (frmConnect, lblSizeLarge, "lblSizeLarge");
    GLADE_HOOKUP_OBJECT (frmConnect, sldSize, "sldSize");
    GLADE_HOOKUP_OBJECT (frmConnect, lblSize, "lblSize");
    GLADE_HOOKUP_OBJECT (frmConnect, optSize3, "optSize3");
    GLADE_HOOKUP_OBJECT (frmConnect, alnAltFullSwitch, "alnAltFullSwitch");
    GLADE_HOOKUP_OBJECT (frmConnect, chkAltFullSwitch, "chkAltFullSwitch");

    // Color Frame Widgets
    GLADE_HOOKUP_OBJECT (frmConnect, frameColor, "frameColor");
    GLADE_HOOKUP_OBJECT (frmConnect, lblColorFrame, "lblColorFrame");
    GLADE_HOOKUP_OBJECT (frmConnect, hbxColor, "hbxColor");
    GLADE_HOOKUP_OBJECT (frmConnect, imgColor, "imgColor");
    GLADE_HOOKUP_OBJECT (frmConnect, vbxColor, "vbxColor");
    GLADE_HOOKUP_OBJECT (frmConnect, optColor1, "optColor1");
    GLADE_HOOKUP_OBJECT (frmConnect, optColor2, "optColor2");
    GLADE_HOOKUP_OBJECT (frmConnect, alnColorSlider, "alnColorSlider");
    GLADE_HOOKUP_OBJECT (frmConnect, tblColorSlider, "tblColorSlider");
    GLADE_HOOKUP_OBJECT (frmConnect, lblColorMore, "lblColorMore");
    GLADE_HOOKUP_OBJECT (frmConnect, lblColorLess, "lblColorLess");
    GLADE_HOOKUP_OBJECT (frmConnect, sldColor, "sldColor");
    GLADE_HOOKUP_OBJECT (frmConnect, lblColor, "lblColor");
    GLADE_HOOKUP_OBJECT (frmConnect, imgColorScale, "imgColorScale");

  // Local Resources Tab Widgets
  GLADE_HOOKUP_OBJECT (frmConnect, lblLocalTab1, "lblLocalTab1");
  GLADE_HOOKUP_OBJECT (frmConnect, vbxLocalTab1, "vbxLocalTab1");

    // Sound Frame Widgets
    GLADE_HOOKUP_OBJECT (frmConnect, frameSound, "frameSound");
    GLADE_HOOKUP_OBJECT (frmConnect, lblSoundFrame, "lblSoundFrame");
    GLADE_HOOKUP_OBJECT (frmConnect, tblSound, "tblSound");
    GLADE_HOOKUP_OBJECT (frmConnect, imgSound, "imgSound");
    GLADE_HOOKUP_OBJECT (frmConnect, cboSound, "cboSound");
    GLADE_HOOKUP_OBJECT (frmConnect, txtSound, "txtSound");

    // Keyboard Frame Widgets
    GLADE_HOOKUP_OBJECT (frmConnect, frameKeyboard, "frameKeyboard");
    GLADE_HOOKUP_OBJECT (frmConnect, lblKeyboardFrame, "lblKeyboardFrame");
    GLADE_HOOKUP_OBJECT (frmConnect, tblKeyboard, "tblKeyboard");
    GLADE_HOOKUP_OBJECT (frmConnect, cboKeyboard, "cboKeyboard");
    GLADE_HOOKUP_OBJECT (frmConnect, txtKeyboard, "txtKeyboard");
    GLADE_HOOKUP_OBJECT (frmConnect, lblKeyboardLang, "lblKeyboardLang");
    GLADE_HOOKUP_OBJECT (frmConnect, cboKeyboardLang, "cboKeyboardLang");
    GLADE_HOOKUP_OBJECT (frmConnect, txtKeyboardLang, "txtKeyboardLang");
    GLADE_HOOKUP_OBJECT (frmConnect, lblKeyboard, "lblKeyboard");
    GLADE_HOOKUP_OBJECT (frmConnect, imgKeyboard, "imgKeyboard");
  
  // Program Tab Widgets
  GLADE_HOOKUP_OBJECT (frmConnect, lblProgramsTab1, "lblProgramsTab1");

    // Program Frame Widgets
    GLADE_HOOKUP_OBJECT (frmConnect, frameProgram, "frameProgram");
    GLADE_HOOKUP_OBJECT (frmConnect, lblProgramFrame, "lblProgramFrame");
    GLADE_HOOKUP_OBJECT (frmConnect, tblProgram, "tblProgram");
    GLADE_HOOKUP_OBJECT (frmConnect, chkStartProgram, "chkStartProgram");
    GLADE_HOOKUP_OBJECT (frmConnect, imgProgram, "imgProgram");
    GLADE_HOOKUP_OBJECT (frmConnect, lblProgramPath, "lblProgramPath");
    GLADE_HOOKUP_OBJECT (frmConnect, txtProgramPath, "txtProgramPath");
    GLADE_HOOKUP_OBJECT (frmConnect, lblStartFolder, "lblStartFolder");
    GLADE_HOOKUP_OBJECT (frmConnect, txtStartFolder, "txtStartFolder");

  // Performance Tab Widgets
  GLADE_HOOKUP_OBJECT (frmConnect, lblPerformanceTab1, "lblPerformanceTab1");

    // Performance Frame Widgets
    GLADE_HOOKUP_OBJECT (frmConnect, framePerform, "framePerform");
    GLADE_HOOKUP_OBJECT (frmConnect, lblPerformFrame, "lblPerformFrame");
    GLADE_HOOKUP_OBJECT (frmConnect, tblPerform, "tblPerform");
    GLADE_HOOKUP_OBJECT (frmConnect, imgPerform, "imgPerform");
    GLADE_HOOKUP_OBJECT (frmConnect, lblPerformanceOptions, "lblPerformanceOptions");
    GLADE_HOOKUP_OBJECT (frmConnect, vbxExpChecks, "vbxExpChecks");
    GLADE_HOOKUP_OBJECT (frmConnect, chkDesktopBackground, "chkDesktopBackground");
    GLADE_HOOKUP_OBJECT (frmConnect, chkWindowContent, "chkWindowContent");
    GLADE_HOOKUP_OBJECT (frmConnect, chkAnimation, "chkAnimation");
    GLADE_HOOKUP_OBJECT (frmConnect, chkThemes, "chkThemes");
    GLADE_HOOKUP_OBJECT (frmConnect, chkBitmapCache, "chkBitmapCache");
    GLADE_HOOKUP_OBJECT (frmConnect, chkNoMotionEvents, "chkNoMotionEvents");
    GLADE_HOOKUP_OBJECT (frmConnect, chkEnableWMKeys, "chkEnableWMKeys");

  // Compact Mode Widgets
  GLADE_HOOKUP_OBJECT (frmConnect, hbxCompact1, "hbxCompact1");
  GLADE_HOOKUP_OBJECT (frmConnect, lblComputer1, "lblComputer1");
  GLADE_HOOKUP_OBJECT (frmConnect, cboComputer1, "cboComputer1");
  GLADE_HOOKUP_OBJECT (frmConnect, txtComputer1, "txtComputer1");

  // Complete Button Box Widgets
  GLADE_HOOKUP_OBJECT (frmConnect, hbbAppOps0, "hbbAppOps0");
  GLADE_HOOKUP_OBJECT (frmConnect, btnConnect0, "btnConnect0");
  GLADE_HOOKUP_OBJECT (frmConnect, alnConnect0, "alnConnect0");
  GLADE_HOOKUP_OBJECT (frmConnect, hbxConnect0, "hbxConnect0");
  GLADE_HOOKUP_OBJECT (frmConnect, imgConnect0, "imgConnect0");
  GLADE_HOOKUP_OBJECT (frmConnect, lblConnect0, "lblConnect0");
  GLADE_HOOKUP_OBJECT (frmConnect, btnQuit0, "btnQuit0");
  GLADE_HOOKUP_OBJECT (frmConnect, btnHelp0, "btnHelp0");
  GLADE_HOOKUP_OBJECT (frmConnect, btnLess, "btnLess");
  GLADE_HOOKUP_OBJECT (frmConnect, alnLess, "alnLess");
  GLADE_HOOKUP_OBJECT (frmConnect, hbxLess, "hbxLess");
  GLADE_HOOKUP_OBJECT (frmConnect, imgLess, "imgLess");
  GLADE_HOOKUP_OBJECT (frmConnect, lblLess, "lblLess");

  // Compact Button Box Widgets
  GLADE_HOOKUP_OBJECT (frmConnect, hbbAppOps1, "hbbAppOps1");
  GLADE_HOOKUP_OBJECT (frmConnect, btnConnect1, "btnConnect1");
  GLADE_HOOKUP_OBJECT (frmConnect, alnConnect1, "alnConnect1");
  GLADE_HOOKUP_OBJECT (frmConnect, hbxConnect1, "hbxConnect1");
  GLADE_HOOKUP_OBJECT (frmConnect, imgConnect1, "imgConnect1");
  GLADE_HOOKUP_OBJECT (frmConnect, lblConnect1, "lblConnect1");
  GLADE_HOOKUP_OBJECT (frmConnect, btnQuit1, "btnQuit1");
  GLADE_HOOKUP_OBJECT (frmConnect, btnHelp1, "btnHelp1");
  GLADE_HOOKUP_OBJECT (frmConnect, btnMore, "btnMore");
  GLADE_HOOKUP_OBJECT (frmConnect, alnMore, "alnMore");
  GLADE_HOOKUP_OBJECT (frmConnect, hbxMore, "hbxMore");
  GLADE_HOOKUP_OBJECT (frmConnect, imgMore, "imgMore");
  GLADE_HOOKUP_OBJECT (frmConnect, lblMore, "lblMore");

  // RDP Picker Widgets
  GLADE_HOOKUP_OBJECT (frmConnect, hbxQuickPick, "hbxQuickPick");
  GLADE_HOOKUP_OBJECT (frmConnect, lblQuickPick, "lblQuickPick");
  GLADE_HOOKUP_OBJECT (frmConnect, cboQuickPick, "cboQuickPick");
  GLADE_HOOKUP_OBJECT (frmConnect, txtQuickPick, "txtQuickPick");
  

  // remove the local resources page until it is supported
  // gtk_notebook_remove_page (GTK_NOTEBOOK (nbkComplete), 2);

  // hide the sound frame until it is supported
  gtk_widget_hide_all (frameSound);

  // toggle the start program thingy to false.  will be set after this by loading.
  gtk_toggle_button_set_active ((GtkToggleButton*) chkStartProgram, FALSE);
  gtk_widget_set_sensitive (txtProgramPath, FALSE);
  gtk_widget_set_sensitive (txtStartFolder, FALSE);
  
  gtk_widget_set_sensitive (alnSizeSlider, FALSE);
  gtk_toggle_button_set_active ((GtkToggleButton*) chkAltFullSwitch, FALSE);
  gtk_widget_set_sensitive (alnAltFullSwitch, FALSE);
  gtk_widget_set_sensitive (alnColorSlider, FALSE);

  return frmConnect;
}


/***************************************
*                                      *
*   Event Handlers                     *
*                                      *
***************************************/



void
on_btnConnect0_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *main_window;
  gchar *file_name;

  main_window = lookup_widget((GtkWidget*)button, "frmConnect");

  // save the damn thing
  rdp_file_init (g_rdp_file);
  rdp_file_get_screen (g_rdp_file, main_window);

  // get path to file
  file_name = g_build_path ("/", g_get_home_dir(), ".tsclient", "last.tsc", NULL);
  // save the damn thing
  rdp_file_init (g_rdp_file_last);
  rdp_file_get_screen (g_rdp_file_last, main_window);
  rdp_file_save (g_rdp_file_last, file_name);

  gtk_widget_hide (main_window);
  gtk_widget_destroy (main_window);

  if (!tsc_launch_rdesktop (g_rdp_file, 0, 0) == 0) {
    printf ("failed to launch rdesktop\n");
    // time to go now...
    //gtk_main_quit();
    //gtk_widget_hide (main_window);
    //gtk_widget_destroy (main_window);
  }
  // recreate the main window
  gConnect = create_frmConnect ();
  // set the window mode (complex)
  tsc_set_window_mode (gConnect, (int)WM_COMPLEX);
  rdp_file_set_screen (g_rdp_file, gConnect);
  mru_to_screen (gConnect);
  rdp_load_picker (gConnect);
  gtk_widget_show (gConnect);
}


void
on_btnConnect1_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *widget;
  GtkWidget *main_window;
  guint pos = 0;

  main_window = lookup_widget((GtkWidget*)button, "frmConnect");
  widget = lookup_widget (gConnect, "txtComputer1");

  // save the damn thing
  rdp_file_init (g_rdp_file);
  g_rdp_file->full_address = gtk_editable_get_chars ((GtkEditable*) widget, 0, -1);
  
  gtk_widget_hide (main_window);
  gtk_widget_destroy (main_window);

  if (!tsc_launch_rdesktop (g_rdp_file, 1, 0) == 0) {
    printf ("failed to launch rdesktop\n");
    // time to go now...
    //gtk_main_quit();
    //gtk_widget_hide (main_window);
    //gtk_widget_destroy (main_window);
  }
  // recreate the main window
  gConnect = create_frmConnect ();
  // set the window mode (complex)
  tsc_set_window_mode (gConnect, (int)WM_COMPACT);
  // reset the computer name
  widget = lookup_widget (gConnect, "txtComputer1");
  gtk_editable_delete_text ((GtkEditable*) widget, 0, -1);
  gtk_editable_insert_text((GtkEditable*) widget, g_rdp_file->full_address, strlen(g_rdp_file->full_address), &pos);
  mru_to_screen (gConnect);
  rdp_load_picker (gConnect);
  gtk_widget_show (gConnect);
}


void
on_btnQuit_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *main_window;
  gchar *file_name;

  main_window = gConnect;
  gtk_widget_hide (main_window);
  tsc_check_files ();

  // get path to file
  file_name = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", "last.tsc", NULL);

  // save the damn thing
  rdp_file_init (g_rdp_file_last);
  rdp_file_get_screen (g_rdp_file_last, main_window);
  rdp_file_save (g_rdp_file_last, file_name);

  g_free (file_name);

  gtk_main_quit();
}


void
on_btnHelp_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{

  tsc_about_dialog ();

}


void
on_btnMore_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *main_window;
  main_window = lookup_widget((GtkWidget*)button, "frmConnect");
  tsc_set_window_mode (main_window, (int)WM_COMPLEX);
}


void
on_btnLess_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *main_window;
  main_window = lookup_widget((GtkWidget*)button, "frmConnect");
  tsc_set_window_mode (main_window, (int)WM_COMPACT);
}


void
on_optSize1_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *aln_size, *aln_afss;

  aln_size = lookup_widget (gConnect, "alnSizeSlider");
  aln_afss = lookup_widget (gConnect, "alnAltFullSwitch");
  
  gtk_widget_set_sensitive (aln_size, FALSE);
  gtk_widget_set_sensitive (aln_afss, FALSE);

}


void
on_optSize2_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *aln_size, *aln_afss;

  aln_size = lookup_widget (gConnect, "alnSizeSlider");
  aln_afss = lookup_widget (gConnect, "alnAltFullSwitch");
  
  gtk_widget_set_sensitive (aln_size, TRUE);
  gtk_widget_set_sensitive (aln_afss, FALSE);

}


void
on_optSize3_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *aln_size, *aln_afss;

  aln_size = lookup_widget (gConnect, "alnSizeSlider");
  aln_afss = lookup_widget (gConnect, "alnAltFullSwitch");
  
  gtk_widget_set_sensitive (aln_size, FALSE);
  gtk_widget_set_sensitive (aln_afss, TRUE);

}


void
on_sldSize_value_changed               (GtkRange        *range,
                                        gpointer         user_data)
{
  GtkWidget *size_label;

  size_label = lookup_widget (gConnect, "lblSize");

  gtk_range_set_value ((GtkRange*) range, rint(gtk_range_get_value (range)));

  switch ((int) gtk_range_get_value (range)) {
  case 1:
    gtk_label_set_text ((GtkLabel*) size_label, _("800 x 600 pixels"));
    break;
  case 2:
    gtk_label_set_text ((GtkLabel*) size_label, _("1024 x 768 pixels"));
    break;
  case 3:
    gtk_label_set_text ((GtkLabel*) size_label, _("1152 x 864 pixels"));
    break;
  case 4:
    gtk_label_set_text ((GtkLabel*) size_label, _("1280 x 960 pixels"));
    break;
  default:
    gtk_label_set_text ((GtkLabel*) size_label, _("640 x 480 pixels"));
    break;
  }

}

void
on_optColor1_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *aln_color;

  aln_color = lookup_widget (gConnect, "alnColorSlider");
  
  gtk_widget_set_sensitive (aln_color, FALSE);

}


void
on_optColor2_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *aln_color;

  aln_color = lookup_widget (gConnect, "alnColorSlider");
  
  gtk_widget_set_sensitive (aln_color, TRUE);

}


void
on_sldColor_value_changed              (GtkRange        *range,
                                        gpointer         user_data)
{
  GtkWidget *cd_label, *img_color;
  gchar *path_name = NULL;

  cd_label = lookup_widget (gConnect, "lblColor");
  img_color = lookup_widget (gConnect, "imgColorScale");

  gtk_range_set_value ((GtkRange*) range, rint(gtk_range_get_value (range)));

  switch ((int) gtk_range_get_value (range)) {
  case 1:
    gtk_label_set_text ((GtkLabel*) cd_label, _("High Color (15 bit)"));
    path_name = find_pixmap_file ("colors-lo.png");
    break;
  case 2:
    gtk_label_set_text ((GtkLabel*) cd_label, _("High Color (16 bit)"));
    path_name = find_pixmap_file ("colors-hi.png");
    break;
  case 3:
    gtk_label_set_text ((GtkLabel*) cd_label, _("True Color (24 bit)"));
    path_name = find_pixmap_file ("colors-hi.png");
    break;
  default:
    gtk_label_set_text ((GtkLabel*) cd_label, _("256 Colors"));
    path_name = find_pixmap_file ("colors-lo.png");
    break;
  }
  gtk_image_set_from_file ((GtkImage*)img_color, path_name);
  g_free (path_name);

}


void
on_btnSaveAs_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *frmRDPSave;
  gchar *path_name;

  path_name = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", "/", NULL);
  
  frmRDPSave = create_frmRDPSave ();
  gtk_window_set_title ((GtkWindow*) frmRDPSave, _("Input a filename to save as..."));
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (frmRDPSave), path_name);
  gtk_widget_show (frmRDPSave);
  gdk_window_raise (frmRDPSave->window);
  g_free (path_name);
}

void
on_btnOpen_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *frmRDPOpen;
  gchar *path_name;

  path_name = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", "/", NULL);
  
  frmRDPOpen = create_frmRDPOpen ();
  gtk_window_set_title ((GtkWindow*) frmRDPOpen, _("Choose an RDP file to open..."));
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (frmRDPOpen), path_name);
  gtk_widget_show (frmRDPOpen);
  gdk_window_raise (frmRDPOpen->window);
  g_free (path_name);
}

void
on_txtQuickPick_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget *main_window;
  gchar *file_name;
  main_window = lookup_widget((GtkWidget*)editable, "frmConnect");
  // build path to file
  file_name = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", gtk_editable_get_chars (editable, 0, -1), NULL);
  // check for file in ~/
  if (g_file_test (file_name, G_FILE_TEST_EXISTS)) {
    // load if exists
    rdp_file_init (g_rdp_file);
    rdp_file_load (g_rdp_file, file_name);

    if (tsc_launch_rdesktop (g_rdp_file, 0, 0) == 0) {
      // get path to file
      file_name = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", "last.tsc", NULL);
      // save the damn thing
      rdp_file_init (g_rdp_file_last);
      rdp_file_get_screen (g_rdp_file_last, main_window);
      rdp_file_save (g_rdp_file_last, file_name);
      // time to go now...
      gtk_widget_hide (main_window);
      gtk_widget_destroy (main_window);
    }
  }
  g_free (file_name);

}


void
on_chkStartProgram_toggled             (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget *txtProgramPath, *txtStartFolder;
  txtProgramPath = lookup_widget (GTK_WIDGET (gConnect), "txtProgramPath");
  txtStartFolder = lookup_widget (GTK_WIDGET (gConnect), "txtStartFolder");

  if (gtk_toggle_button_get_active (togglebutton)) {
    gtk_widget_set_sensitive (txtProgramPath, TRUE);
    gtk_widget_set_sensitive (txtStartFolder, TRUE);
  } else {
    gtk_widget_set_sensitive (txtProgramPath, FALSE);
    gtk_widget_set_sensitive (txtStartFolder, FALSE);
  }
  
}

