/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h> 
#include <sys/stat.h> 
#include <stdio.h>

#include <gtk/gtk.h>
#include <glib.h>
#include <string.h>

#include <libintl.h>
#define _(x) gettext(x)

#include "rdpfile.h"
#include "main.h"
#include "support.h"
#include "mrulist.h"
#include "connect.h"


int
main (int argc, char *argv[])
{
  gint i;
  gint imode = (gint)WM_COMPACT;
  gchar *rdp_file_name = g_build_path ("/", g_get_home_dir(), ".tsclient", "last.tsc", NULL);

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);

  //printf ("\n\nLanguage: %s\n\n", gtk_get_default_language ());

  //add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");
  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps/tsclient/");

  //printf ("\n\nargc: %d\n\n", argc);
  // start at 1 because 0 contains binary name
  for (i = 1; i < argc; i++) {
    if (strcmp("--help", argv[i]) == 0 || strcmp("-h", argv[i]) == 0) {
      tsc_print_help ();
      return 0;
    }
    if (strcmp("--version", argv[i]) == 0 || strcmp("-v", argv[i]) == 0) {
      tsc_print_version ();
      return 0;
    }
    if (strcmp("-x", argv[i]) == 0) {
      if (g_file_test (argv[i+1], G_FILE_TEST_EXISTS)) {
        rdp_file_name = argv[i+1];
        g_rdp_file = g_new (rdp_file, 1);
        rdp_file_init (g_rdp_file);
        rdp_file_load (g_rdp_file, rdp_file_name);
        //printf ("\n\nrdp_file_name: %s\n\n", rdp_file_name);
        if (tsc_launch_rdesktop (g_rdp_file, 0, 1) == 0) {
          g_free (g_rdp_file);
          return 0;
        }
      }
    }
    if (g_file_test (argv[i], G_FILE_TEST_EXISTS)) {
      rdp_file_name = argv[i];
      continue;
    }
    if (strcmp("--full", argv[i]) == 0 || strcmp("-f", argv[i]) == 0) {
      imode = (gint)WM_COMPLEX;
      continue;
    }
  }

  // create the main window
  gConnect = create_frmConnect ();
  // set the window mode (compact)
  tsc_set_window_mode (gConnect, imode);
  gtk_widget_show (gConnect);

  // load mru & picker
  mru_to_screen (gConnect);
  rdp_load_picker (gConnect);

  // init the global rdp_file
  g_rdp_file = g_new (rdp_file, 1);
  rdp_file_init (g_rdp_file);

  // Get the last.tsc for last used settings and load
  tsc_check_files ();
  g_rdp_file_last = g_new (rdp_file, 1);
  rdp_file_init (g_rdp_file_last);
  // printf ("\n\nrdp_file_name: %s\n\n", rdp_file_name);
  rdp_file_load (g_rdp_file_last, rdp_file_name);
  rdp_file_set_screen (g_rdp_file_last, gConnect);

  g_free (rdp_file_name);

  gtk_main ();
  return 0;
}

void tsc_print_help () {

  printf ("\n");
  printf ("  Usage: tsclient [OPTION]... [FILE]...\n\n");
  printf ("  FILE           an rdp format file containing options\n");
  printf ("  -f, --full     display full mode window\n");
  printf ("  -h, --help     display this help and exit\n");
  printf ("  -v, --version  output version information and exit\n");
  printf ("  -x FILE        launch rdesktop with options specified in FILE\n");
  printf ("\n");
  return;

}


void tsc_print_version () {

  printf ("\n");
  printf ("  Terminal Server Client for GNOME\n");
  printf ("  a frontend for rdesktop\n");
  printf ("  tsclient version "VERSION"\n");
  printf ("\n");
  return;

}

