/***************************************
*                                      *
*   frmConnect Create & Events         *
*                                      *
***************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <math.h> 
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h> 
#include <string.h>
#include <unistd.h>

#include <gdk/gdkkeysyms.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <libintl.h>
#define _(x) gettext(x)

#include "rdpfile.h"
#include "main.h"
#include "support.h"
#include "connect.h"
#include "rdpopen.h"
#include "rdpsave.h"
#include "about.h"
#include "mrulist.h"



/***************************************
*                                      *
*   frmConnect Create                  *
*                                      *
***************************************/

GtkWidget*
create_frmConnect (void)
{
  GtkWidget *frmConnect;
  
  GtkWidget *alnColorDepth;

  GtkWidget *chkStartProgram;
  GtkWidget *chkDesktopBackground;
  GtkWidget *chkWindowContent;
  GtkWidget *chkAnimation;
  GtkWidget *chkThemes;
  GtkWidget *chkBitmapCache;
  GtkWidget *chkNoMotionEvents;
  GtkWidget *chkEnableWMKeys;
  GtkWidget *chkAltFullSwitch;

  GtkWidget *imgBanner;
  GtkWidget *imgGeneralLogon;
  GtkWidget *imgGeneralConnection;
  GtkWidget *imgDesktopSize;
  GtkWidget *imgColorDepth;
  GtkWidget *imgColors;
  GtkWidget *imgSound;
  GtkWidget *imgKeyboard;
  GtkWidget *imgPerform;
  GtkWidget *imgAbout;

  GtkWidget *alnComplete;
  GtkWidget *alnCompact;

  GtkWidget *vbxMain;
  GtkWidget *vbxBanner;
  GtkWidget *vbxComplete;
  GtkWidget *vbxCompact;
  GtkWidget *vbxDisplayTab1;
  GtkWidget *vbxLocalTab1;
  GtkWidget *tblProgram;
  GtkWidget *vbxExpChecks;
  GtkWidget *vbxGeneralTab1;
  GtkWidget *vbxConnection;
  GtkWidget *vbxAboutTab1;
  
  GtkWidget *hbxCompact1;
  
  GtkWidget *lblComputer0;
  GtkWidget *lblComputer1;
  GtkWidget *lblUsername;
  GtkWidget *lblPassword;
  GtkWidget *lblDomain;
  GtkWidget *lblDeskSize;
  GtkWidget *lblColorDepth;
  GtkWidget *lblUnsupportedNote;

  GtkWidget *txtComputer1;
  GtkWidget *txtComputer0;
  GtkWidget *txtUsername;
  GtkWidget *txtPassword;
  GtkWidget *txtDomain;
  GtkWidget *txtSound;
  GtkWidget *txtKeyboard;
  GtkWidget *txtKeyboardLang;
  GtkWidget *txtProgramPath;
  GtkWidget *txtStartFolder;
  GtkWidget *txtPerform;
  GtkWidget *txtAbout;

  GtkWidget *btnSaveAs;
  GtkWidget *btnOpen;
  GtkWidget *btnQuit0;
  GtkWidget *btnQuit1;
  GtkWidget *btnLess;
  GtkWidget *btnMore;
  
  GtkWidget *sldDeskSize;
  GtkWidget *sldColorDepth;

  GtkWidget *cboPerform;
  GtkWidget *cboKeyboard;
  GtkWidget *cboKeyboardLang;
  GtkWidget *cboSound;
  GtkWidget *cboComputer0;
  GtkWidget *cboComputer1;

  GtkWidget *frameLogon;
  GtkWidget *frameConnection;
  GtkWidget *frameDeskSize;
  GtkWidget *frameColors;
  GtkWidget *frameSound;
  GtkWidget *frameKeyboard;
  GtkWidget *frameProgram;
  GtkWidget *framePerform;
  GtkWidget *frameAbout;

  GtkWidget *tblSound;
  GtkWidget *imgProgram;
  GtkWidget *hbxAbout;

  GtkWidget *hbbAppOps0;
  GtkWidget *btnConnect0;
  GtkWidget *alnConnect0;
  GtkWidget *hbxConnect0;
  GtkWidget *imgConnect0;
  GtkWidget *lblConnect0;
  GtkWidget *alnLess;
  GtkWidget *hbxLess;
  GtkWidget *imgLess;
  GtkWidget *lblLess;
  GtkWidget *hbbAppOps1;
  GtkWidget *btnConnect1;
  GtkWidget *alnConnect1;
  GtkWidget *hbxConnect1;
  GtkWidget *imgConnect1;
  GtkWidget *lblConnect1;
  GtkWidget *alnMore;
  GtkWidget *hbxMore;
  GtkWidget *imgMore;
  GtkWidget *lblMore;

  GtkWidget *nbkComplete;
  GtkWidget *lblGeneralTab1;
  GtkWidget *lblDisplayTab1;
  GtkWidget *lblLocalTab1;
  GtkWidget *lblProgramsTab1;
  GtkWidget *lblExperienceTab1;
  GtkWidget *lblAboutTab1;
  
  GtkWidget *tblLogon1;
  GtkWidget *hbbFileOps;
  
  GtkWidget *tblDeskSize0;
  GtkWidget *tblDeskSize1;
  GtkWidget *tblKeyboard;
  GtkWidget *tblPerform;
  GtkWidget *tblColorDepth0;
  GtkWidget *tblColorDepth1;
  GtkWidget *tblConnection;
  GtkWidget *tblLogon0;
  
  GtkWidget *lblSizeFrame;
  GtkWidget *lblSizeLess;
  GtkWidget *lblSizeMore;
  GtkWidget *lblSizeNote;
  GtkWidget *lblSoundFrame;
  GtkWidget *lblKeyboardFrame;
  GtkWidget *lblKeyboard;
  GtkWidget *lblKeyboardLang;
  GtkWidget *lblProgramFrame;
  GtkWidget *lblPerformFrame;
  GtkWidget *lblProgramPath;
  GtkWidget *lblStartFolder;
  GtkWidget *lblChooseSpeed;
  GtkWidget *lblAllow;
  GtkWidget *lblColorFrame;
  GtkWidget *lblColorLess;
  GtkWidget *lblColorMore;
  GtkWidget *lblColorNote;
  GtkWidget *lblConnectionFrame;
  GtkWidget *lblFileOpsNote;
  GtkWidget *lblLogonNote;
  GtkWidget *lblLogonFrame;
  GtkWidget *lblAboutFrame;
  GtkWidget *lblExtraFeatures;

  GtkWidget *hbxQuickPick;
  GtkWidget *lblQuickPick;
  GtkWidget *cboQuickPick;
  GtkWidget *txtQuickPick;
  
  GtkWidget *scwAbout;


  GList *cboSound_items = NULL;
  GList *cboKeyboard_items = NULL;
  GList *cboPerform_items = NULL;

  /*
    This is the main form
  */
  frmConnect = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (frmConnect, "frmConnect");
  gtk_window_set_title (GTK_WINDOW (frmConnect), _("Terminal Server Client"));
  gtk_window_set_position (GTK_WINDOW (frmConnect), GTK_WIN_POS_CENTER);
  gtk_window_set_resizable (GTK_WINDOW (frmConnect), FALSE);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (frmConnect), TRUE);
  gtk_window_set_icon (GTK_WINDOW (frmConnect), create_pixbuf ("tsclient.png"));
  
  /*
    This is the main container
  */
  vbxMain = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxMain, "vbxMain");
  gtk_widget_show (vbxMain);
  gtk_container_add (GTK_CONTAINER (frmConnect), vbxMain);

  /*
    This is the banner at the top
  */
  vbxBanner = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxBanner, "vbxBanner");
  gtk_box_pack_start (GTK_BOX (vbxMain), vbxBanner, TRUE, TRUE, 1);
  gtk_widget_show (vbxBanner);

  imgBanner = create_pixmap (frmConnect, "banner.png");
  //imgBanner = create_image_from_xpm (xpm_banner);
  gtk_widget_set_name (imgBanner, "imgBanner");
  gtk_widget_show (imgBanner);
  gtk_box_pack_start (GTK_BOX (vbxBanner), imgBanner, FALSE, TRUE, 0);
  gtk_misc_set_alignment (GTK_MISC (imgBanner), 0.5, 0);

  /*
    This is the complete container
  */
  vbxComplete = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxComplete, "vbxComplete");
  gtk_box_pack_start (GTK_BOX (vbxMain), vbxComplete, TRUE, TRUE, 1);
  gtk_widget_show (vbxComplete);

  alnComplete = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alnComplete, "alnComplete");
  gtk_widget_show (alnComplete);
  gtk_container_add (GTK_CONTAINER (vbxComplete), alnComplete);
  
  /*
    This is the compact container
  */
  vbxCompact = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxCompact, "vbxCompact");
  gtk_box_pack_start (GTK_BOX (vbxMain), vbxCompact, TRUE, TRUE, 2);
  gtk_widget_show (vbxCompact);

  alnCompact = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alnCompact, "alnCompact");
  gtk_widget_show (alnCompact);
  gtk_container_add (GTK_CONTAINER (vbxCompact), alnCompact);
  
  hbxCompact1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbxCompact1, "hbxCompact1");
  gtk_box_pack_start (GTK_BOX (vbxCompact), hbxCompact1, TRUE, TRUE, 0);
  gtk_widget_show (hbxCompact1);
  
 /*
    This is the quick picker
  */
  hbxQuickPick = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbxQuickPick, "hbxQuickPick");
  gtk_box_pack_start (GTK_BOX (vbxMain), hbxQuickPick, TRUE, TRUE, 6);
  gtk_widget_show (hbxQuickPick);

  lblQuickPick = gtk_label_new_with_mnemonic (_("RDP Pic_ker:"));
  gtk_widget_set_name (lblQuickPick, "lblQuickPick");
  gtk_box_pack_start (GTK_BOX (hbxQuickPick), lblQuickPick, TRUE, TRUE, 0);
  gtk_widget_show (lblQuickPick);
  gtk_label_set_justify (GTK_LABEL (lblQuickPick), GTK_JUSTIFY_LEFT);

  cboQuickPick = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (cboQuickPick)->popwin),
                       "GladeParentKey", cboQuickPick);
  gtk_widget_set_name (cboQuickPick, "cboQuickPick");
  gtk_box_pack_start (GTK_BOX (hbxQuickPick), cboQuickPick, TRUE, TRUE, 1);
  //gtk_combo_set_case_sensitive (cboQuickPick, TRUE);
  gtk_combo_set_value_in_list (GTK_COMBO (cboQuickPick), TRUE, TRUE);
  gtk_widget_show (cboQuickPick);

  txtQuickPick = GTK_COMBO (cboQuickPick)->entry;
  gtk_entry_set_activates_default (GTK_ENTRY (txtQuickPick), TRUE);
  gtk_widget_set_name (txtQuickPick, "txtQuickPick");
  gtk_widget_set_sensitive ((GtkWidget *)txtQuickPick, FALSE);
  gtk_widget_show (txtQuickPick);
  
  /*
    This is the button box for the Compact mode
  */
  hbbAppOps1 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbbAppOps1, "hbbAppOps1");
  gtk_box_pack_start (GTK_BOX (vbxMain), hbbAppOps1, FALSE, TRUE, 1);
  gtk_widget_show (hbbAppOps1);
  gtk_container_set_border_width (GTK_CONTAINER (hbbAppOps1), 3);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbbAppOps1), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbbAppOps1), 6);

  btnConnect1 = gtk_button_new ();
  gtk_widget_set_name (btnConnect1, "btnConnect1");
  gtk_widget_show (btnConnect1);
  gtk_container_add (GTK_CONTAINER (hbbAppOps1), btnConnect1);
  GTK_WIDGET_SET_FLAGS (btnConnect1, GTK_CAN_DEFAULT);

  alnConnect1 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alnConnect1, "alnConnect1");
  gtk_widget_show (alnConnect1);
  gtk_container_add (GTK_CONTAINER (btnConnect1), alnConnect1);

  hbxConnect1 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbxConnect1, "hbxConnect1");
  gtk_widget_show (hbxConnect1);
  gtk_container_add (GTK_CONTAINER (alnConnect1), hbxConnect1);

  imgConnect1 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (imgConnect1, "imgConnect1");
  gtk_widget_show (imgConnect1);
  gtk_box_pack_start (GTK_BOX (hbxConnect1), imgConnect1, FALSE, FALSE, 0);

  lblConnect1 = gtk_label_new_with_mnemonic (_("_Connect"));
  gtk_widget_set_name (lblConnect1, "lblConnect1");
  gtk_widget_show (lblConnect1);
  gtk_box_pack_start (GTK_BOX (hbxConnect1), lblConnect1, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (lblConnect1), GTK_JUSTIFY_LEFT);


  btnQuit1 = gtk_button_new_from_stock ("gtk-quit");
  gtk_widget_set_name (btnQuit1, "btnQuit1");
  gtk_widget_show (btnQuit1);
  gtk_container_add (GTK_CONTAINER (hbbAppOps1), btnQuit1);

  btnMore = gtk_button_new ();
  gtk_widget_set_name (btnMore, "btnMore");
  gtk_widget_show (btnMore);
  gtk_container_add (GTK_CONTAINER (hbbAppOps1), btnMore);

  alnMore = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alnMore, "alnMore");
  gtk_widget_show (alnMore);
  gtk_container_add (GTK_CONTAINER (btnMore), alnMore);

  hbxMore = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbxMore, "hbxMore");
  gtk_widget_show (hbxMore);
  gtk_container_add (GTK_CONTAINER (alnMore), hbxMore);

  imgMore = gtk_image_new_from_stock ("gtk-go-down", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (imgMore, "imgMore");
  gtk_widget_show (imgMore);
  gtk_box_pack_start (GTK_BOX (hbxMore), imgMore, FALSE, FALSE, 0);

  lblMore = gtk_label_new_with_mnemonic (_("_More"));
  gtk_widget_set_name (lblMore, "lblMore");
  gtk_widget_show (lblMore);
  gtk_box_pack_start (GTK_BOX (hbxMore), lblMore, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (lblMore), GTK_JUSTIFY_LEFT);

  /*
    This is the input for the Compact mode
  */
  lblComputer1 = gtk_label_new_with_mnemonic (_("Compu_ter:"));
  gtk_widget_set_name (lblComputer1, "lblComputer1");
  gtk_box_pack_start (GTK_BOX (hbxCompact1), lblComputer1, TRUE, TRUE, 0);
  gtk_widget_show (lblComputer1);
  gtk_label_set_justify (GTK_LABEL (lblComputer1), GTK_JUSTIFY_LEFT);
  //gtk_misc_set_alignment (GTK_MISC (lblComputer1), 0, 0.5);

  cboComputer1 = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (cboComputer1)->popwin),
                       "GladeParentKey", cboComputer1);
  gtk_widget_set_name (cboComputer1, "cboComputer1");
  gtk_box_pack_start (GTK_BOX (hbxCompact1), cboComputer1, TRUE, TRUE, 1);
  gtk_combo_set_value_in_list (GTK_COMBO (cboComputer1), FALSE, FALSE);
  gtk_widget_show (cboComputer1);

  txtComputer1 = GTK_COMBO (cboComputer1)->entry;
  gtk_entry_set_activates_default (GTK_ENTRY (txtComputer1), TRUE);
  gtk_widget_set_name (txtComputer1, "txtComputer1");
  gtk_widget_show (txtComputer1);


  /*
    This is the notebook for the Complete mode
  */
  nbkComplete = gtk_notebook_new ();
  gtk_widget_set_name (nbkComplete, "nbkComplete");
  gtk_widget_show (nbkComplete);
  gtk_box_pack_start (GTK_BOX (vbxComplete), nbkComplete, TRUE, TRUE, 3);
  gtk_container_set_border_width (GTK_CONTAINER (nbkComplete), 3);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (nbkComplete), FALSE);

  vbxGeneralTab1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxGeneralTab1, "vbxGeneralTab1");
  gtk_widget_show (vbxGeneralTab1);
  gtk_container_add (GTK_CONTAINER (nbkComplete), vbxGeneralTab1);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (nbkComplete), vbxGeneralTab1,
                                      TRUE, TRUE, GTK_PACK_START);
                                      
  /*
    This is the button box for the Complete mode
  */

  hbbAppOps0 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbbAppOps0, "hbbAppOps0");
  gtk_widget_show (hbbAppOps0);
  gtk_box_pack_start (GTK_BOX (vbxMain), hbbAppOps0, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbbAppOps0), 3);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbbAppOps0), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbbAppOps0), 6);

  btnConnect0 = gtk_button_new ();
  gtk_widget_set_name (btnConnect0, "btnConnect0");
  gtk_widget_show (btnConnect0);
  gtk_container_add (GTK_CONTAINER (hbbAppOps0), btnConnect0);
  GTK_WIDGET_SET_FLAGS (btnConnect0, GTK_CAN_DEFAULT);


  alnConnect0 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alnConnect0, "alnConnect0");
  gtk_widget_show (alnConnect0);
  gtk_container_add (GTK_CONTAINER (btnConnect0), alnConnect0);

  hbxConnect0 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbxConnect0, "hbxConnect0");
  gtk_widget_show (hbxConnect0);
  gtk_container_add (GTK_CONTAINER (alnConnect0), hbxConnect0);

  imgConnect0 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (imgConnect0, "imgConnect0");
  gtk_widget_show (imgConnect0);
  gtk_box_pack_start (GTK_BOX (hbxConnect0), imgConnect0, FALSE, FALSE, 0);

  lblConnect0 = gtk_label_new_with_mnemonic ("_Connect");
  gtk_widget_set_name (lblConnect0, "lblConnect0");
  gtk_widget_show (lblConnect0);
  gtk_box_pack_start (GTK_BOX (hbxConnect0), lblConnect0, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (lblConnect0), GTK_JUSTIFY_LEFT);


  btnQuit0 = gtk_button_new_from_stock ("gtk-quit");
  gtk_widget_set_name (btnQuit0, "btnQuit0");
  gtk_widget_show (btnQuit0);
  gtk_container_add (GTK_CONTAINER (hbbAppOps0), btnQuit0);

  btnLess = gtk_button_new ();
  gtk_widget_set_name (btnLess, "btnLess");
  gtk_widget_show (btnLess);
  gtk_container_add (GTK_CONTAINER (hbbAppOps0), btnLess);

  alnLess = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alnLess, "alnLess");
  gtk_widget_show (alnLess);
  gtk_container_add (GTK_CONTAINER (btnLess), alnLess);

  hbxLess = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbxLess, "hbxLess");
  gtk_widget_show (hbxLess);
  gtk_container_add (GTK_CONTAINER (alnLess), hbxLess);

  imgLess = gtk_image_new_from_stock ("gtk-go-up", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (imgLess, "imgLess");
  gtk_widget_show (imgLess);
  gtk_box_pack_start (GTK_BOX (hbxLess), imgLess, FALSE, FALSE, 0);

  lblLess = gtk_label_new_with_mnemonic (_("_Less"));
  gtk_widget_set_name (lblLess, "lblLess");
  gtk_widget_show (lblLess);
  gtk_box_pack_start (GTK_BOX (hbxLess), lblLess, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (lblLess), GTK_JUSTIFY_LEFT);

                                      
  frameLogon = gtk_frame_new (NULL);
  gtk_widget_set_name (frameLogon, "frameLogon");
  gtk_widget_show (frameLogon);
  gtk_box_pack_start (GTK_BOX (vbxGeneralTab1), frameLogon, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frameLogon), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frameLogon), GTK_SHADOW_NONE);

  lblLogonFrame = gtk_label_new ("Logon Settings");
  gtk_widget_set_name (lblLogonFrame, "lblLogonFrame");
  gtk_widget_show (lblLogonFrame);
  gtk_label_set_markup (GTK_LABEL (lblLogonFrame), "<span weight=\"bold\">Logon Settings</span>");
  gtk_frame_set_label_widget (GTK_FRAME (frameLogon), lblLogonFrame);
  gtk_label_set_justify (GTK_LABEL (lblLogonFrame), GTK_JUSTIFY_LEFT);

  tblLogon0 = gtk_table_new (2, 2, FALSE);
  gtk_widget_set_name (tblLogon0, "tblLogon0");
  gtk_widget_show (tblLogon0);
  gtk_container_add (GTK_CONTAINER (frameLogon), tblLogon0);

  lblLogonNote = gtk_label_new (_("Type the name of the computer or choose a computer from the drop-down list."));
  gtk_widget_set_name (lblLogonNote, "lblLogonNote");
  gtk_widget_show (lblLogonNote);
  gtk_table_attach (GTK_TABLE (tblLogon0), lblLogonNote, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblLogonNote), GTK_JUSTIFY_LEFT);
  gtk_label_set_line_wrap (GTK_LABEL (lblLogonNote), TRUE);
  gtk_misc_set_alignment (GTK_MISC (lblLogonNote), 0, 0.5);

  imgGeneralLogon = create_pixmap (frmConnect, "computer.png");
  gtk_widget_set_name (imgGeneralLogon, "imgGeneralLogon");
  gtk_widget_show (imgGeneralLogon);
  gtk_table_attach (GTK_TABLE (tblLogon0), imgGeneralLogon, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (imgGeneralLogon), 3, 3);

  tblLogon1 = gtk_table_new (6, 2, FALSE);
  gtk_widget_set_name (tblLogon1, "tblLogon1");
  gtk_widget_show (tblLogon1);
  gtk_table_attach (GTK_TABLE (tblLogon0), tblLogon1, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_table_set_row_spacings (GTK_TABLE (tblLogon1), 6);
  gtk_table_set_col_spacings (GTK_TABLE (tblLogon1), 6);

  lblComputer0 = gtk_label_new_with_mnemonic (_("Compu_ter:"));
  gtk_widget_set_name (lblComputer0, "lblComputer0");
  gtk_widget_show (lblComputer0);
  gtk_table_attach (GTK_TABLE (tblLogon1), lblComputer0, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 6, 6);
  gtk_label_set_justify (GTK_LABEL (lblComputer0), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblComputer0), 0, 0.5);

  lblUsername = gtk_label_new_with_mnemonic ("_User Name:");
  gtk_widget_set_name (lblUsername, "lblUsername");
  gtk_widget_show (lblUsername);
  gtk_table_attach (GTK_TABLE (tblLogon1), lblUsername, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 6, 6);
  gtk_label_set_justify (GTK_LABEL (lblUsername), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblUsername), 0, 0.5);

  lblPassword = gtk_label_new_with_mnemonic ("Pass_word:");
  gtk_widget_set_name (lblPassword, "lblPassword");
  gtk_widget_show (lblPassword);
  gtk_table_attach (GTK_TABLE (tblLogon1), lblPassword, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 6, 6);
  gtk_label_set_justify (GTK_LABEL (lblPassword), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblPassword), 0, 0.5);

  lblDomain = gtk_label_new_with_mnemonic ("Do_main:");
  gtk_widget_set_name (lblDomain, "lblDomain");
  gtk_widget_show (lblDomain);
  gtk_table_attach (GTK_TABLE (tblLogon1), lblDomain, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 6, 6);
  gtk_label_set_justify (GTK_LABEL (lblDomain), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblDomain), 0, 0.5);

  cboComputer0 = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (cboComputer0)->popwin),
                       "GladeParentKey", cboComputer0);
  gtk_widget_set_name (cboComputer0, "cboComputer0");
  gtk_combo_set_value_in_list (GTK_COMBO (cboComputer0), FALSE, FALSE);
  gtk_widget_show (cboComputer0);
  gtk_table_attach (GTK_TABLE (tblLogon1), cboComputer0, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  txtComputer0 = GTK_COMBO (cboComputer0)->entry;
  gtk_widget_set_name (txtComputer0, "txtComputer0");
  gtk_entry_set_activates_default (GTK_ENTRY (txtComputer0), TRUE);
  gtk_widget_show (txtComputer0);


  txtUsername = gtk_entry_new ();
  gtk_widget_set_name (txtUsername, "txtUsername");
  gtk_widget_show (txtUsername);
  gtk_entry_set_activates_default (GTK_ENTRY (txtUsername), TRUE);
  gtk_table_attach (GTK_TABLE (tblLogon1), txtUsername, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  txtPassword = gtk_entry_new ();
  gtk_widget_set_name (txtPassword, "txtPassword");
  gtk_widget_show (txtPassword);
  gtk_entry_set_activates_default (GTK_ENTRY (txtPassword), TRUE);
  gtk_table_attach (GTK_TABLE (tblLogon1), txtPassword, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_visibility (GTK_ENTRY (txtPassword), FALSE);

  txtDomain = gtk_entry_new ();
  gtk_widget_set_name (txtDomain, "txtDomain");
  gtk_widget_show (txtDomain);
  gtk_entry_set_activates_default (GTK_ENTRY (txtDomain), TRUE);
  gtk_table_attach (GTK_TABLE (tblLogon1), txtDomain, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);


  frameConnection = gtk_frame_new (NULL);
  gtk_widget_set_name (frameConnection, "frameConnection");
  gtk_widget_show (frameConnection);
  gtk_box_pack_start (GTK_BOX (vbxGeneralTab1), frameConnection, TRUE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frameConnection), GTK_SHADOW_NONE);

  lblConnectionFrame = gtk_label_new ("Connection Settings");
  gtk_widget_set_name (lblConnectionFrame, "lblConnectionFrame");
  gtk_widget_show (lblConnectionFrame);
  gtk_label_set_markup (GTK_LABEL (lblConnectionFrame), "<span weight=\"bold\">Connection Settings</span>");
  gtk_frame_set_label_widget (GTK_FRAME (frameConnection), lblConnectionFrame);
  gtk_label_set_justify (GTK_LABEL (lblConnectionFrame), GTK_JUSTIFY_LEFT);

  vbxConnection = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxConnection, "vbxConnection");
  gtk_widget_show (vbxConnection);
  gtk_container_add (GTK_CONTAINER (frameConnection), vbxConnection);

  tblConnection = gtk_table_new (2, 2, FALSE);
  gtk_widget_set_name (tblConnection, "tblConnection");
  gtk_widget_show (tblConnection);
  gtk_box_pack_start (GTK_BOX (vbxConnection), tblConnection, TRUE, TRUE, 0);

  hbbFileOps = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbbFileOps, "hbbFileOps");
  gtk_widget_show (hbbFileOps);
  gtk_table_attach (GTK_TABLE (tblConnection), hbbFileOps, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbbFileOps), 3);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbbFileOps), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbbFileOps), 6);

  btnSaveAs = gtk_button_new_from_stock ("gtk-save-as");
  gtk_widget_set_name (btnSaveAs, "btnSaveAs");
  gtk_widget_show (btnSaveAs);
  gtk_container_add (GTK_CONTAINER (hbbFileOps), btnSaveAs);

  btnOpen = gtk_button_new_from_stock ("gtk-open");
  gtk_widget_set_name (btnOpen, "btnOpen");
  gtk_widget_show (btnOpen);
  gtk_container_add (GTK_CONTAINER (hbbFileOps), btnOpen);

  imgGeneralConnection = create_pixmap (frmConnect, "directory.png");
  //imgGeneralConnection = create_image_from_xpm (xpm_directory);
  gtk_widget_set_name (imgGeneralConnection, "imgGeneralConnection");
  gtk_widget_show (imgGeneralConnection);
  gtk_table_attach (GTK_TABLE (tblConnection), imgGeneralConnection, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (imgGeneralConnection), 3, 3);

  lblFileOpsNote = gtk_label_new ("Save the current setting or open saved connection");
  gtk_widget_set_name (lblFileOpsNote, "lblFileOpsNote");
  gtk_widget_show (lblFileOpsNote);
  gtk_table_attach (GTK_TABLE (tblConnection), lblFileOpsNote, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_line_wrap (GTK_LABEL (lblFileOpsNote), TRUE);
  gtk_label_set_justify (GTK_LABEL (lblFileOpsNote), GTK_JUSTIFY_LEFT);


  vbxDisplayTab1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxDisplayTab1, "vbxDisplayTab1");
  gtk_widget_show (vbxDisplayTab1);
  gtk_container_add (GTK_CONTAINER (nbkComplete), vbxDisplayTab1);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (nbkComplete), vbxDisplayTab1,
                                      TRUE, TRUE, GTK_PACK_START);

  frameDeskSize = gtk_frame_new (NULL);
  gtk_widget_set_name (frameDeskSize, "frameDeskSize");
  gtk_widget_show (frameDeskSize);
  gtk_box_pack_start (GTK_BOX (vbxDisplayTab1), frameDeskSize, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frameDeskSize), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frameDeskSize), GTK_SHADOW_NONE);

  lblSizeFrame = gtk_label_new ("Remote desktop size");
  gtk_widget_set_name (lblSizeFrame, "lblSizeFrame");
  gtk_widget_show (lblSizeFrame);
  gtk_label_set_markup (GTK_LABEL (lblSizeFrame), "<span weight=\"bold\">Remote desktop size</span>");
  gtk_frame_set_label_widget (GTK_FRAME (frameDeskSize), lblSizeFrame);
  gtk_label_set_justify (GTK_LABEL (lblSizeFrame), GTK_JUSTIFY_LEFT);

  tblDeskSize0 = gtk_table_new (2, 2, FALSE);
  gtk_widget_set_name (tblDeskSize0, "tblDeskSize0");
  gtk_widget_show (tblDeskSize0);
  gtk_container_add (GTK_CONTAINER (frameDeskSize), tblDeskSize0);

  lblSizeNote = gtk_label_new ("Choose the size of your remote desktop.  Drag the slider all the way to the right to go fullscreen.");
  gtk_widget_set_name (lblSizeNote, "lblSizeNote");
  gtk_widget_show (lblSizeNote);
  gtk_table_attach (GTK_TABLE (tblDeskSize0), lblSizeNote, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblSizeNote), GTK_JUSTIFY_LEFT);
  gtk_label_set_line_wrap (GTK_LABEL (lblSizeNote), TRUE);
  gtk_misc_set_alignment (GTK_MISC (lblSizeNote), 0, 0.5);

  imgDesktopSize = create_pixmap (frmConnect, "size.png");
  //imgDesktopSize = create_image_from_xpm (xpm_size);
  gtk_widget_set_name (imgDesktopSize, "imgDesktopSize");
  gtk_widget_show (imgDesktopSize);
  gtk_table_attach (GTK_TABLE (tblDeskSize0), imgDesktopSize, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_misc_set_padding (GTK_MISC (imgDesktopSize), 3, 3);

  tblDeskSize1 = gtk_table_new (2, 3, FALSE);
  gtk_widget_set_name (tblDeskSize1, "tblDeskSize1");
  gtk_widget_show (tblDeskSize1);
  gtk_table_attach (GTK_TABLE (tblDeskSize0), tblDeskSize1, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_table_set_row_spacings (GTK_TABLE (tblDeskSize1), 6);

  lblSizeMore = gtk_label_new ("More");
  gtk_widget_set_name (lblSizeMore, "lblSizeMore");
  gtk_widget_show (lblSizeMore);
  gtk_table_attach (GTK_TABLE (tblDeskSize1), lblSizeMore, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 6, 6);
  gtk_label_set_justify (GTK_LABEL (lblSizeMore), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblSizeMore), 0, 0.5);

  lblSizeLess = gtk_label_new ("Less");
  gtk_widget_set_name (lblSizeLess, "lblSizeLess");
  gtk_widget_show (lblSizeLess);
  gtk_table_attach (GTK_TABLE (tblDeskSize1), lblSizeLess, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 6, 6);
  gtk_label_set_justify (GTK_LABEL (lblSizeLess), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblSizeLess), 0, 0.5);

  sldDeskSize = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 7, 1, 1, 1)));
  gtk_widget_set_name (sldDeskSize, "sldDeskSize");
  gtk_widget_show (sldDeskSize);
  gtk_table_attach (GTK_TABLE (tblDeskSize1), sldDeskSize, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_scale_set_draw_value (GTK_SCALE (sldDeskSize), FALSE);
  gtk_scale_set_digits (GTK_SCALE (sldDeskSize), 0);
  gtk_range_set_update_policy (GTK_RANGE (sldDeskSize), GTK_UPDATE_CONTINUOUS);

  lblDeskSize = gtk_label_new ("Default");
  gtk_widget_set_name (lblDeskSize, "lblDeskSize");
  gtk_widget_show (lblDeskSize);
  gtk_table_attach (GTK_TABLE (tblDeskSize1), lblDeskSize, 1, 2, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 6, 6);
  gtk_misc_set_alignment (GTK_MISC (lblDeskSize), 0, 0.5);

  chkAltFullSwitch = gtk_check_button_new_with_mnemonic ("Use alternate Full Screen switch (-F)");
  gtk_widget_set_name (chkAltFullSwitch, "chkAltFullSwitch");
  gtk_widget_show (chkAltFullSwitch);
  gtk_table_attach (GTK_TABLE (tblDeskSize1), chkAltFullSwitch, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (chkAltFullSwitch), 3);

  frameColors = gtk_frame_new (NULL);
  gtk_widget_set_name (frameColors, "frameColors");
  gtk_widget_show (frameColors);
  gtk_box_pack_start (GTK_BOX (vbxDisplayTab1), frameColors, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frameColors), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frameColors), GTK_SHADOW_NONE);

  lblColorFrame = gtk_label_new ("Colors (unsupported)");
  gtk_widget_set_name (lblColorFrame, "lblColorFrame");
  gtk_widget_show (lblColorFrame);
  gtk_label_set_markup (GTK_LABEL (lblColorFrame), "<span weight=\"bold\">Colors (unsupported)</span>");
  gtk_frame_set_label_widget (GTK_FRAME (frameColors), lblColorFrame);
  gtk_label_set_justify (GTK_LABEL (lblColorFrame), GTK_JUSTIFY_LEFT);

  alnColorDepth = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_set_name (alnColorDepth, "alnColorDepth");
  gtk_widget_show (alnColorDepth);
  gtk_container_add (GTK_CONTAINER (frameColors), alnColorDepth);

  tblColorDepth0 = gtk_table_new (2, 2, FALSE);
  gtk_widget_set_name (tblColorDepth0, "tblColorDepth0");
  gtk_widget_show (tblColorDepth0);
  gtk_container_add (GTK_CONTAINER (alnColorDepth), tblColorDepth0);

  //lblColorNote = gtk_label_new ("Note: Settings on the remote computer might override this settings.");
  lblColorNote = gtk_label_new ("Note: This setting previously changed colors to match the local X Server which is now automatic. Remote color setting is not supported yet.");
  gtk_widget_set_name (lblColorNote, "lblColorNote");
  gtk_widget_show (lblColorNote);
  gtk_table_attach (GTK_TABLE (tblColorDepth0), lblColorNote, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_label_set_line_wrap (GTK_LABEL (lblColorNote), TRUE);
  gtk_label_set_justify (GTK_LABEL (lblColorNote), GTK_JUSTIFY_LEFT);

  tblColorDepth1 = gtk_table_new (3, 3, FALSE);
  gtk_widget_set_name (tblColorDepth1, "tblColorDepth1");
  gtk_widget_show (tblColorDepth1);
  gtk_table_attach (GTK_TABLE (tblColorDepth0), tblColorDepth1, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  sldColorDepth = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 5, 1, 1, 1)));
  gtk_widget_set_name (sldColorDepth, "sldColorDepth");
  gtk_widget_show (sldColorDepth);
  gtk_table_attach (GTK_TABLE (tblColorDepth1), sldColorDepth, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_scale_set_draw_value (GTK_SCALE (sldColorDepth), FALSE);
  gtk_scale_set_digits (GTK_SCALE (sldColorDepth), 0);
  gtk_range_set_update_policy (GTK_RANGE (sldColorDepth), GTK_UPDATE_CONTINUOUS);
  //gtk_range_set_value ((GtkRange*) sldColorDepth, (gdouble)2);

  lblColorMore = gtk_label_new ("More");
  gtk_widget_set_name (lblColorMore, "lblColorMore");
  gtk_widget_show (lblColorMore);
  gtk_table_attach (GTK_TABLE (tblColorDepth1), lblColorMore, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 6, 6);
  gtk_label_set_justify (GTK_LABEL (lblColorMore), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblColorMore), 0, 0.5);

  lblColorLess = gtk_label_new ("Less");
  gtk_widget_set_name (lblColorLess, "lblColorLess");
  gtk_widget_show (lblColorLess);
  gtk_table_attach (GTK_TABLE (tblColorDepth1), lblColorLess, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 6, 6);
  gtk_label_set_justify (GTK_LABEL (lblColorLess), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblColorLess), 0, 0.5);

  imgColorDepth = create_pixmap (frmConnect, "colors-hi.png");
  //imgColorDepth = create_image_from_xpm (xpm_colors_hi);
  gtk_widget_set_name (imgColorDepth, "imgColorDepth");
  gtk_widget_show (imgColorDepth);
  gtk_table_attach (GTK_TABLE (tblColorDepth1), imgColorDepth, 1, 2, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (imgColorDepth), 0, 0.5);

  lblColorDepth = gtk_label_new ("Default");
  gtk_widget_set_name (lblColorDepth, "lblColorDepth");
  gtk_widget_show (lblColorDepth);
  gtk_table_attach (GTK_TABLE (tblColorDepth1), lblColorDepth, 1, 2, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblColorDepth), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblColorDepth), 0, 0.5);

  imgColors = create_pixmap (frmConnect, "colors.png");
  //imgColors = create_image_from_xpm (xpm_colors);
  gtk_widget_set_name (imgColors, "imgColors");
  gtk_widget_show (imgColors);
  gtk_table_attach (GTK_TABLE (tblColorDepth0), imgColors, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (imgColors), 3, 3);

  vbxLocalTab1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxLocalTab1, "vbxLocalTab1");
  gtk_widget_show (vbxLocalTab1);
  gtk_container_add (GTK_CONTAINER (nbkComplete), vbxLocalTab1);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (nbkComplete), vbxLocalTab1,
                                      TRUE, TRUE, GTK_PACK_START);

  frameSound = gtk_frame_new (NULL);
  gtk_widget_set_name (frameSound, "frameSound");
  gtk_widget_show (frameSound);
  gtk_box_pack_start (GTK_BOX (vbxLocalTab1), frameSound, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frameSound), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frameSound), GTK_SHADOW_NONE);
  //gtk_widget_set_sensitive (frameSound, FALSE);

  lblSoundFrame = gtk_label_new_with_mnemonic ("Remote Computer _Sound (unsupported)");
  gtk_widget_set_name (lblSoundFrame, "lblSoundFrame");
  gtk_widget_show (lblSoundFrame);
  gtk_label_set_markup (GTK_LABEL (lblSoundFrame), "<span weight=\"bold\">Remote Computer Sound (unsupported)</span>");
  gtk_frame_set_label_widget (GTK_FRAME (frameSound), lblSoundFrame);
  gtk_label_set_justify (GTK_LABEL (lblSoundFrame), GTK_JUSTIFY_LEFT);

  tblSound = gtk_table_new (1, 2, FALSE);
  gtk_widget_set_name (tblSound, "tblSound");
  gtk_widget_show (tblSound);
  gtk_container_add (GTK_CONTAINER (frameSound), tblSound);
  gtk_table_set_col_spacings (GTK_TABLE (tblSound), 6);

  imgSound = create_pixmap (frmConnect, "sound.png");
  //imgSound = create_image_from_xpm (xpm_sound);
  gtk_widget_set_name (imgSound, "imgSound");
  gtk_widget_show (imgSound);
  gtk_misc_set_padding (GTK_MISC (imgSound), 3, 3);
  gtk_table_attach (GTK_TABLE (tblSound), imgSound, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) 0, 0, 0);

  cboSound = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (cboSound)->popwin),
                       "GladeParentKey", cboSound);
  gtk_widget_set_name (cboSound, "cboSound");
  gtk_widget_show (cboSound);
  gtk_table_attach (GTK_TABLE (tblSound), cboSound, 1, 2, 0, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (cboSound), TRUE, TRUE);
  cboSound_items = g_list_append (cboSound_items, (gpointer) OPT_SOUND_BRING);
  cboSound_items = g_list_append (cboSound_items, (gpointer) OPT_SOUND_NOPLAY);
  cboSound_items = g_list_append (cboSound_items, (gpointer) OPT_SOUND_LEAVE);
  gtk_combo_set_popdown_strings (GTK_COMBO (cboSound), cboSound_items);
  g_list_free (cboSound_items);
  
  txtSound = GTK_COMBO (cboSound)->entry;
  gtk_widget_set_name (txtSound, "txtSound");
  gtk_widget_show (txtSound);
  gtk_widget_set_sensitive (txtSound, FALSE);

  frameKeyboard = gtk_frame_new (NULL);
  gtk_widget_set_name (frameKeyboard, "frameKeyboard");
  gtk_widget_show (frameKeyboard);
  gtk_box_pack_start (GTK_BOX (vbxLocalTab1), frameKeyboard, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frameKeyboard), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frameKeyboard), GTK_SHADOW_NONE);
  //gtk_widget_set_sensitive (frameKeyboard, FALSE);

  lblKeyboardFrame = gtk_label_new_with_mnemonic ("_Keyboard");
  gtk_widget_set_name (lblKeyboardFrame, "lblKeyboardFrame");
  gtk_widget_show (lblKeyboardFrame);
  gtk_label_set_markup (GTK_LABEL (lblKeyboardFrame), "<span weight=\"bold\">Keyboard</span>");
  gtk_frame_set_label_widget (GTK_FRAME (frameKeyboard), lblKeyboardFrame);
  gtk_label_set_justify (GTK_LABEL (lblKeyboardFrame), GTK_JUSTIFY_LEFT);

  tblKeyboard = gtk_table_new (2, 2, FALSE);
  gtk_widget_set_name (tblKeyboard, "tblKeyboard");
  gtk_widget_show (tblKeyboard);
  gtk_container_add (GTK_CONTAINER (frameKeyboard), tblKeyboard);
  gtk_table_set_col_spacings (GTK_TABLE (tblKeyboard), 6);

  cboKeyboard = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (cboKeyboard)->popwin),
                       "GladeParentKey", cboKeyboard);
  gtk_widget_set_name (cboKeyboard, "cboKeyboard");
  gtk_widget_show (cboKeyboard);
  gtk_table_attach (GTK_TABLE (tblKeyboard), cboKeyboard, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) OPT_KEY_LOCAL);
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) OPT_KEY_REMOTE);
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) OPT_KEY_FULL);
  gtk_combo_set_popdown_strings (GTK_COMBO (cboKeyboard), cboKeyboard_items);
  g_list_free (cboKeyboard_items);
  
  txtKeyboard = GTK_COMBO (cboKeyboard)->entry;
  gtk_widget_set_name (txtKeyboard, "txtKeyboard");
  gtk_widget_show (txtKeyboard);
  gtk_widget_set_sensitive (txtKeyboard, FALSE);


  lblKeyboardLang = gtk_label_new ("Use the following keyboard language\n(2 char keycode)");
  gtk_widget_set_name (lblKeyboardLang, "lblKeyboardLang");
  gtk_widget_show (lblKeyboardLang);
  gtk_table_attach (GTK_TABLE (tblKeyboard), lblKeyboardLang, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblKeyboardLang), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblKeyboardLang), 0, 0.5);

  cboKeyboardLang = gtk_combo_new ();
  gtk_object_set_data ( GTK_OBJECT ( GTK_COMBO ( cboKeyboardLang)->popwin ),
			"GladeParentLangKey", cboKeyboardLang );
  gtk_widget_set_name ( cboKeyboardLang, "cboKeyboardLang" );
  gtk_widget_show ( cboKeyboardLang );
  gtk_table_attach (GTK_TABLE (tblKeyboard), cboKeyboardLang, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  cboKeyboard_items = NULL;
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "be");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "bg");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "br");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "cf");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "ch");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "cz");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "dk");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "dv");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "et");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "fr");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "gk");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "gr");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "hu");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "is");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "it");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "jp");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "ko");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "la");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "nl");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "no");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "pl");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "po");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "ro");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "ru");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "sf");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "sl");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "sp");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "su");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "sv");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "tr");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "uk");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "us");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "usl");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "usr");
  cboKeyboard_items = g_list_append (cboKeyboard_items, (gpointer) "yu");
  gtk_combo_set_popdown_strings (GTK_COMBO (cboKeyboardLang), cboKeyboard_items);
  g_list_free (cboKeyboard_items);  

  txtKeyboardLang = GTK_COMBO (cboKeyboardLang)->entry;
  gtk_widget_set_name (txtKeyboardLang, "txtKeyboardLang");
  gtk_widget_show (txtKeyboardLang);

  lblKeyboard = gtk_label_new ("Apply Windows key combinations\n(for example ALT+TAB) (unsupported)");
  gtk_widget_set_name (lblKeyboard, "lblKeyboard");
  gtk_widget_show (lblKeyboard);
  gtk_table_attach (GTK_TABLE (tblKeyboard), lblKeyboard, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblKeyboard), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblKeyboard), 0, 0.5);

  imgKeyboard = create_pixmap (frmConnect, "keyboard.png");
  //imgKeyboard = create_image_from_xpm (xpm_keyboard);
  gtk_widget_set_name (imgKeyboard, "imgKeyboard");
  gtk_widget_show (imgKeyboard);
  gtk_table_attach (GTK_TABLE (tblKeyboard), imgKeyboard, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) 0, 0, 0);
  gtk_misc_set_padding (GTK_MISC (imgKeyboard), 3, 3);

  frameProgram = gtk_frame_new (NULL);
  gtk_widget_set_name (frameProgram, "frameProgram");
  gtk_widget_show (frameProgram);
  gtk_container_add (GTK_CONTAINER (nbkComplete), frameProgram);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (nbkComplete), frameProgram,
                                      TRUE, TRUE, GTK_PACK_START);
  gtk_container_set_border_width (GTK_CONTAINER (frameProgram), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frameProgram), GTK_SHADOW_NONE);
  //gtk_widget_set_sensitive (frameProgram, FALSE);

  lblProgramFrame = gtk_label_new ("Start a program");
  gtk_widget_set_name (lblProgramFrame, "lblProgramFrame");
  gtk_widget_show (lblProgramFrame);
  gtk_label_set_markup (GTK_LABEL (lblProgramFrame), "<span weight=\"bold\">Start a program</span>");
  gtk_frame_set_label_widget (GTK_FRAME (frameProgram), lblProgramFrame);
  gtk_label_set_justify (GTK_LABEL (lblProgramFrame), GTK_JUSTIFY_LEFT);

  tblProgram = gtk_table_new (2, 5, FALSE);
  gtk_widget_set_name (tblProgram, "tblProgram");
  gtk_widget_show (tblProgram);
  gtk_container_add (GTK_CONTAINER (frameProgram), tblProgram);

  imgProgram = create_pixmap (frmConnect, "program.png");
  gtk_widget_set_name (imgProgram, "imgProgram");
  gtk_widget_show (imgProgram);
  gtk_table_attach (GTK_TABLE (tblProgram), imgProgram, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_misc_set_padding (GTK_MISC (imgProgram), 3, 3);

  chkStartProgram = gtk_check_button_new_with_mnemonic ("Start the following program on connection");
  gtk_widget_set_name (chkStartProgram, "chkStartProgram");
  gtk_widget_show (chkStartProgram);
  gtk_table_attach (GTK_TABLE (tblProgram), chkStartProgram, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (chkStartProgram), 3);

  lblProgramPath = gtk_label_new ("Program path and filename");
  gtk_widget_set_name (lblProgramPath, "lblProgramPath");
  gtk_widget_show (lblProgramPath);
  gtk_table_attach (GTK_TABLE (tblProgram), lblProgramPath, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblProgramPath), GTK_JUSTIFY_LEFT);

  txtProgramPath = gtk_entry_new ();
  gtk_widget_set_name (txtProgramPath, "txtProgramPath");
  gtk_widget_show (txtProgramPath);
  gtk_table_attach (GTK_TABLE (tblProgram), txtProgramPath, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  lblStartFolder = gtk_label_new ("Start in the following folder");
  gtk_widget_set_name (lblStartFolder, "lblStartFolder");
  gtk_widget_show (lblStartFolder);
  gtk_table_attach (GTK_TABLE (tblProgram), lblStartFolder, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblStartFolder), GTK_JUSTIFY_LEFT);

  txtStartFolder = gtk_entry_new ();
  gtk_widget_set_name (txtStartFolder, "txtStartFolder");
  gtk_widget_show (txtStartFolder);
  gtk_table_attach (GTK_TABLE (tblProgram), txtStartFolder, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);


  framePerform = gtk_frame_new (NULL);
  gtk_widget_set_name (framePerform, "framePerform");
  gtk_widget_show (framePerform);
  gtk_container_add (GTK_CONTAINER (nbkComplete), framePerform);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (nbkComplete), framePerform,
                                      TRUE, TRUE, GTK_PACK_START);
  gtk_container_set_border_width (GTK_CONTAINER (framePerform), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (framePerform), GTK_SHADOW_NONE);

  lblPerformFrame = gtk_label_new ("Performance");
  gtk_widget_set_name (lblPerformFrame, "lblPerformFrame");
  gtk_widget_show (lblPerformFrame);
  gtk_label_set_markup (GTK_LABEL (lblPerformFrame), "<span weight=\"bold\">Performance</span>");
  gtk_frame_set_label_widget (GTK_FRAME (framePerform), lblPerformFrame);
  gtk_label_set_justify (GTK_LABEL (lblPerformFrame), GTK_JUSTIFY_LEFT);

  tblPerform = gtk_table_new (2, 2, FALSE);
  gtk_widget_set_name (tblPerform, "tblPerform");
  gtk_widget_show (tblPerform);
  gtk_container_add (GTK_CONTAINER (framePerform), tblPerform);

  imgPerform = create_pixmap (frmConnect, "perform.png");
  //imgPerform = create_image_from_xpm (xpm_help);
  gtk_widget_set_name (imgPerform, "imgPerform");
  gtk_widget_show (imgPerform);
  gtk_table_attach (GTK_TABLE (tblPerform), imgPerform, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_misc_set_padding (GTK_MISC (imgPerform), 3, 3);

  vbxExpChecks = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxExpChecks, "vbxExpChecks");
  gtk_widget_show (vbxExpChecks);
  gtk_table_attach (GTK_TABLE (tblPerform), vbxExpChecks, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  cboPerform = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (cboPerform)->popwin),
                       "GladeParentKey", cboPerform);
  gtk_widget_set_name (cboPerform, "cboPerform");
  gtk_widget_show (cboPerform);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), cboPerform, FALSE, FALSE, 0);
  cboPerform_items = g_list_append (cboPerform_items, (gpointer) OPT_PERF_28K);
  cboPerform_items = g_list_append (cboPerform_items, (gpointer) OPT_PERF_56K);
  cboPerform_items = g_list_append (cboPerform_items, (gpointer) OPT_PERF_BB);
  cboPerform_items = g_list_append (cboPerform_items, (gpointer) OPT_PERF_LAN);
  cboPerform_items = g_list_append (cboPerform_items, (gpointer) OPT_PERF_CUSTOM);
  gtk_combo_set_popdown_strings (GTK_COMBO (cboPerform), cboPerform_items);
  g_list_free (cboPerform_items);
  
  txtPerform = GTK_COMBO (cboPerform)->entry;
  gtk_widget_set_name (txtPerform, "txtPerform");
  gtk_widget_show (txtPerform);
  gtk_widget_set_sensitive (txtPerform, FALSE);

  lblAllow = gtk_label_new ("Allow the following");
  gtk_widget_set_name (lblAllow, "lblAllow");
  gtk_widget_show (lblAllow);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), lblAllow, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (lblAllow), GTK_JUSTIFY_LEFT);

  lblUnsupportedNote = gtk_label_new ("Options not yet supported indicated by (u).");
  gtk_widget_set_name (lblUnsupportedNote, "lblUnsupportedNote");
  gtk_widget_show (lblUnsupportedNote);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), lblUnsupportedNote, FALSE, FALSE, 0);
  gtk_label_set_line_wrap (GTK_LABEL (lblUnsupportedNote), TRUE);
  gtk_label_set_justify (GTK_LABEL (lblUnsupportedNote), GTK_JUSTIFY_LEFT);

  chkDesktopBackground = gtk_check_button_new_with_mnemonic ("Desktop background (u)");
  gtk_widget_set_name (chkDesktopBackground, "chkDesktopBackground");
  gtk_widget_show (chkDesktopBackground);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), chkDesktopBackground, FALSE, FALSE, 0);

  chkWindowContent = gtk_check_button_new_with_mnemonic ("Show content of window while dragging (u)");
  gtk_widget_set_name (chkWindowContent, "chkWindowContent");
  gtk_widget_show (chkWindowContent);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), chkWindowContent, FALSE, FALSE, 0);

  chkAnimation = gtk_check_button_new_with_mnemonic ("Menu and window animation (u)");
  gtk_widget_set_name (chkAnimation, "chkAnimation");
  gtk_widget_show (chkAnimation);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), chkAnimation, FALSE, FALSE, 0);

  chkThemes = gtk_check_button_new_with_mnemonic ("Themes (u)");
  gtk_widget_set_name (chkThemes, "chkThemes");
  gtk_widget_show (chkThemes);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), chkThemes, FALSE, FALSE, 0);

  chkBitmapCache = gtk_check_button_new_with_mnemonic ("Bitmap caching");
  gtk_widget_set_name (chkBitmapCache, "chkBitmapCache");
  gtk_widget_show (chkBitmapCache);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), chkBitmapCache, FALSE, FALSE, 0);

  lblExtraFeatures = gtk_label_new ("Extra Features");
  gtk_widget_set_name (lblExtraFeatures, "lblExtraFeatures");
  gtk_widget_show (lblExtraFeatures);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), lblExtraFeatures, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (lblExtraFeatures), GTK_JUSTIFY_LEFT);

  chkNoMotionEvents = gtk_check_button_new_with_mnemonic ("Do not send motion events");
  gtk_widget_set_name (chkNoMotionEvents, "chkNoMotionEvents");
  gtk_widget_show (chkNoMotionEvents);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), chkNoMotionEvents, FALSE, FALSE, 0);

  chkEnableWMKeys = gtk_check_button_new_with_mnemonic ("Enable window manager's key bindings");
  gtk_widget_set_name (chkEnableWMKeys, "chkEnableWMKeys");
  gtk_widget_show (chkEnableWMKeys);
  gtk_box_pack_start (GTK_BOX (vbxExpChecks), chkEnableWMKeys, FALSE, FALSE, 0);




  lblChooseSpeed = gtk_label_new ("Choose your connection speed to optimize Perform");
  gtk_widget_set_name (lblChooseSpeed, "lblChooseSpeed");
  gtk_widget_show (lblChooseSpeed);
  gtk_table_attach (GTK_TABLE (tblPerform), lblChooseSpeed, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblChooseSpeed), GTK_JUSTIFY_LEFT);
  gtk_label_set_line_wrap (GTK_LABEL (lblChooseSpeed), TRUE);
  gtk_misc_set_alignment (GTK_MISC (lblChooseSpeed), 0, 0.5);

  vbxAboutTab1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbxAboutTab1, "vbxAboutTab1");
  gtk_widget_show (vbxAboutTab1);
  gtk_container_add (GTK_CONTAINER (nbkComplete), vbxAboutTab1);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (nbkComplete), vbxAboutTab1,
                                      TRUE, TRUE, GTK_PACK_START);

  frameAbout = gtk_frame_new (NULL);
  gtk_widget_set_name (frameAbout, "frameAbout");
  gtk_widget_show (frameAbout);
  gtk_box_pack_start (GTK_BOX (vbxAboutTab1), frameAbout, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frameAbout), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frameAbout), GTK_SHADOW_NONE);

  lblAboutFrame = gtk_label_new ("About Terminal Server Client");
  gtk_widget_set_name (lblAboutFrame, "lblAboutFrame");
  gtk_widget_show (lblAboutFrame);
  gtk_label_set_markup (GTK_LABEL (lblAboutFrame), "<span weight=\"bold\">About Terminal Server Client</span>");
  gtk_frame_set_label_widget (GTK_FRAME (frameAbout), lblAboutFrame);
  gtk_label_set_justify (GTK_LABEL (lblAboutFrame), GTK_JUSTIFY_LEFT);

  hbxAbout = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbxAbout, "hbxAbout");
  gtk_widget_show (hbxAbout);
  gtk_container_add (GTK_CONTAINER (frameAbout), hbxAbout);

  imgAbout = create_pixmap (frmConnect, "tsclient.png");
  gtk_widget_set_name (imgAbout, "imgAbout");
  gtk_widget_show (imgAbout);
  gtk_box_pack_start (GTK_BOX (hbxAbout), imgAbout, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (imgAbout), 0.5, 0);
  gtk_misc_set_padding (GTK_MISC (imgAbout), 6, 6);

  scwAbout = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scwAbout, "scwAbout");
  gtk_widget_show (scwAbout);
  gtk_box_pack_start (GTK_BOX (hbxAbout), scwAbout, TRUE, TRUE, 6);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scwAbout), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  txtAbout = gtk_text_view_new ();
  gtk_widget_set_name (txtAbout, "txtAbout");
  gtk_widget_show (txtAbout);
  gtk_container_add (GTK_CONTAINER (scwAbout), txtAbout);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (txtAbout), FALSE);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (txtAbout), GTK_WRAP_WORD);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (txtAbout), FALSE);
  gtk_text_buffer_set_text (gtk_text_view_get_buffer (GTK_TEXT_VIEW (txtAbout)), (gchar*)TSC_APP_ABOUT_TEXT, -1);

  
  /*
    This is the labels for the notebook control
  */
  lblGeneralTab1 = gtk_label_new_with_mnemonic ("_General");
  gtk_widget_set_name (lblGeneralTab1, "lblGeneralTab1");
  gtk_widget_show (lblGeneralTab1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (nbkComplete), gtk_notebook_get_nth_page (GTK_NOTEBOOK (nbkComplete), 0), lblGeneralTab1);
  gtk_label_set_justify (GTK_LABEL (lblGeneralTab1), GTK_JUSTIFY_LEFT);

  lblDisplayTab1 = gtk_label_new_with_mnemonic ("_Display");
  gtk_widget_set_name (lblDisplayTab1, "lblDisplayTab1");
  gtk_widget_show (lblDisplayTab1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (nbkComplete), gtk_notebook_get_nth_page (GTK_NOTEBOOK (nbkComplete), 1), lblDisplayTab1);
  gtk_label_set_justify (GTK_LABEL (lblDisplayTab1), GTK_JUSTIFY_LEFT);

  lblLocalTab1 = gtk_label_new_with_mnemonic ("Local _Resources");
  gtk_widget_set_name (lblLocalTab1, "lblLocalTab1");
  gtk_widget_show (lblLocalTab1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (nbkComplete), gtk_notebook_get_nth_page (GTK_NOTEBOOK (nbkComplete), 2), lblLocalTab1);
  gtk_label_set_justify (GTK_LABEL (lblLocalTab1), GTK_JUSTIFY_LEFT);

  lblProgramsTab1 = gtk_label_new_with_mnemonic ("_Programs");
  gtk_widget_set_name (lblProgramsTab1, "lblProgramsTab1");
  gtk_widget_show (lblProgramsTab1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (nbkComplete), gtk_notebook_get_nth_page (GTK_NOTEBOOK (nbkComplete), 3), lblProgramsTab1);
  gtk_label_set_justify (GTK_LABEL (lblProgramsTab1), GTK_JUSTIFY_LEFT);

  lblExperienceTab1 = gtk_label_new_with_mnemonic ("_Experience");
  gtk_widget_set_name (lblExperienceTab1, "lblExperienceTab1");
  gtk_widget_show (lblExperienceTab1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (nbkComplete), gtk_notebook_get_nth_page (GTK_NOTEBOOK (nbkComplete), 4), lblExperienceTab1);
  gtk_label_set_justify (GTK_LABEL (lblExperienceTab1), GTK_JUSTIFY_LEFT);

  lblAboutTab1 = gtk_label_new_with_mnemonic ("_About");
  gtk_widget_set_name (lblAboutTab1, "lblAboutTab1");
  gtk_widget_show (lblAboutTab1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (nbkComplete), gtk_notebook_get_nth_page (GTK_NOTEBOOK (nbkComplete), 5), lblAboutTab1);
  gtk_label_set_justify (GTK_LABEL (lblAboutTab1), GTK_JUSTIFY_LEFT);



  gtk_label_set_mnemonic_widget (GTK_LABEL (lblComputer0), txtComputer1);
  gtk_label_set_mnemonic_widget (GTK_LABEL (lblComputer1), txtComputer0);
  gtk_label_set_mnemonic_widget (GTK_LABEL (lblUsername), txtUsername);
  gtk_label_set_mnemonic_widget (GTK_LABEL (lblPassword), txtPassword);
  gtk_label_set_mnemonic_widget (GTK_LABEL (lblDomain), txtDomain);

  gtk_signal_connect (GTK_OBJECT (frmConnect), "destroy_event",
                      GTK_SIGNAL_FUNC (gtk_main_quit),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (frmConnect), "delete_event",
                      GTK_SIGNAL_FUNC (gtk_main_quit),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnConnect0), "clicked",
                      GTK_SIGNAL_FUNC (on_btnConnect0_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnConnect1), "clicked",
                      GTK_SIGNAL_FUNC (on_btnConnect1_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnQuit0), "clicked",
                      GTK_SIGNAL_FUNC (on_btnQuit_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnQuit1), "clicked",
                      GTK_SIGNAL_FUNC (on_btnQuit_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (sldDeskSize), "value_changed",
                      GTK_SIGNAL_FUNC (on_sldDeskSize_value_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (sldColorDepth), "value_changed",
                      GTK_SIGNAL_FUNC (on_sldColorDepth_value_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnSaveAs), "clicked",
                      GTK_SIGNAL_FUNC (on_btnSaveAs_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnOpen), "clicked",
                      GTK_SIGNAL_FUNC (on_btnOpen_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnMore), "clicked",
                      GTK_SIGNAL_FUNC (on_btnMore_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnLess), "clicked",
                      GTK_SIGNAL_FUNC (on_btnLess_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (txtPerform), "changed",
                      GTK_SIGNAL_FUNC (on_txtPerform_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (txtQuickPick), "changed",
                      GTK_SIGNAL_FUNC (on_txtQuickPick_changed),
                      NULL);


  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (frmConnect, frmConnect, "frmConnect");
  GLADE_HOOKUP_OBJECT (frmConnect, vbxMain, "vbxMain");
  GLADE_HOOKUP_OBJECT (frmConnect, vbxBanner, "vbxBanner");
  GLADE_HOOKUP_OBJECT (frmConnect, vbxComplete, "vbxComplete");
  GLADE_HOOKUP_OBJECT (frmConnect, vbxCompact, "vbxCompact");
  GLADE_HOOKUP_OBJECT (frmConnect, imgBanner, "imgBanner");
  GLADE_HOOKUP_OBJECT (frmConnect, nbkComplete, "nbkComplete");
  GLADE_HOOKUP_OBJECT (frmConnect, vbxGeneralTab1, "vbxGeneralTab1");
  GLADE_HOOKUP_OBJECT (frmConnect, frameLogon, "frameLogon");
  GLADE_HOOKUP_OBJECT (frmConnect, tblLogon0, "tblLogon0");
  GLADE_HOOKUP_OBJECT (frmConnect, lblLogonNote, "lblLogonNote");
  GLADE_HOOKUP_OBJECT (frmConnect, imgGeneralLogon, "imgGeneralLogon");
  GLADE_HOOKUP_OBJECT (frmConnect, tblLogon1, "tblLogon1");
  GLADE_HOOKUP_OBJECT (frmConnect, lblComputer1, "lblComputer1");
  GLADE_HOOKUP_OBJECT (frmConnect, lblUsername, "lblUsername");
  GLADE_HOOKUP_OBJECT (frmConnect, lblPassword, "lblPassword");
  GLADE_HOOKUP_OBJECT (frmConnect, lblDomain, "lblDomain");
  GLADE_HOOKUP_OBJECT (frmConnect, txtComputer0, "txtComputer0");
  GLADE_HOOKUP_OBJECT (frmConnect, txtUsername, "txtUsername");
  GLADE_HOOKUP_OBJECT (frmConnect, txtPassword, "txtPassword");
  GLADE_HOOKUP_OBJECT (frmConnect, txtDomain, "txtDomain");
  GLADE_HOOKUP_OBJECT (frmConnect, lblLogonFrame, "lblLogonFrame");
  GLADE_HOOKUP_OBJECT (frmConnect, frameConnection, "frameConnection");
  GLADE_HOOKUP_OBJECT (frmConnect, vbxConnection, "vbxConnection");
  GLADE_HOOKUP_OBJECT (frmConnect, tblConnection, "tblConnection");
  GLADE_HOOKUP_OBJECT (frmConnect, hbbFileOps, "hbbFileOps");
  GLADE_HOOKUP_OBJECT (frmConnect, btnSaveAs, "btnSaveAs");
  GLADE_HOOKUP_OBJECT (frmConnect, btnOpen, "btnOpen");
  GLADE_HOOKUP_OBJECT (frmConnect, imgGeneralConnection, "imgGeneralConnection");
  GLADE_HOOKUP_OBJECT (frmConnect, lblFileOpsNote, "lblFileOpsNote");
  GLADE_HOOKUP_OBJECT (frmConnect, lblConnectionFrame, "lblConnectionFrame");
  GLADE_HOOKUP_OBJECT (frmConnect, vbxDisplayTab1, "vbxDisplayTab1");
  GLADE_HOOKUP_OBJECT (frmConnect, frameDeskSize, "frameDeskSize");
  GLADE_HOOKUP_OBJECT (frmConnect, tblDeskSize0, "tblDeskSize0");
  GLADE_HOOKUP_OBJECT (frmConnect, lblSizeNote, "lblSizeNote");
  GLADE_HOOKUP_OBJECT (frmConnect, imgDesktopSize, "imgDesktopSize");
  GLADE_HOOKUP_OBJECT (frmConnect, tblDeskSize1, "tblDeskSize1");
  GLADE_HOOKUP_OBJECT (frmConnect, lblSizeMore, "lblSizeMore");
  GLADE_HOOKUP_OBJECT (frmConnect, lblSizeLess, "lblSizeLess");
  GLADE_HOOKUP_OBJECT (frmConnect, sldDeskSize, "sldDeskSize");
  GLADE_HOOKUP_OBJECT (frmConnect, lblDeskSize, "lblDeskSize");
  GLADE_HOOKUP_OBJECT (frmConnect, lblSizeFrame, "lblSizeFrame");
  GLADE_HOOKUP_OBJECT (frmConnect, frameColors, "frameColors");
  GLADE_HOOKUP_OBJECT (frmConnect, alnColorDepth, "alnColorDepth");
  GLADE_HOOKUP_OBJECT (frmConnect, tblColorDepth0, "tblColorDepth0");
  GLADE_HOOKUP_OBJECT (frmConnect, lblColorNote, "lblColorNote");
  GLADE_HOOKUP_OBJECT (frmConnect, tblColorDepth1, "tblColorDepth1");
  GLADE_HOOKUP_OBJECT (frmConnect, sldColorDepth, "sldColorDepth");
  GLADE_HOOKUP_OBJECT (frmConnect, lblColorMore, "lblColorMore");
  GLADE_HOOKUP_OBJECT (frmConnect, lblColorLess, "lblColorLess");
  GLADE_HOOKUP_OBJECT (frmConnect, imgColorDepth, "imgColorDepth");
  GLADE_HOOKUP_OBJECT (frmConnect, lblColorDepth, "lblColorDepth");
  GLADE_HOOKUP_OBJECT (frmConnect, imgColors, "imgColors");
  GLADE_HOOKUP_OBJECT (frmConnect, lblColorFrame, "lblColorFrame");
  GLADE_HOOKUP_OBJECT (frmConnect, vbxLocalTab1, "vbxLocalTab1");
  GLADE_HOOKUP_OBJECT (frmConnect, frameSound, "frameSound");
  GLADE_HOOKUP_OBJECT (frmConnect, tblSound, "tblSound");
  GLADE_HOOKUP_OBJECT (frmConnect, hbxAbout, "hbxAbout");
  GLADE_HOOKUP_OBJECT (frmConnect, imgAbout, "imgAbout");
  GLADE_HOOKUP_OBJECT (frmConnect, imgSound, "imgSound");
  GLADE_HOOKUP_OBJECT (frmConnect, cboSound, "cboSound");
  GLADE_HOOKUP_OBJECT (frmConnect, txtSound, "txtSound");
  GLADE_HOOKUP_OBJECT (frmConnect, lblSoundFrame, "lblSoundFrame");
  GLADE_HOOKUP_OBJECT (frmConnect, frameKeyboard, "frameKeyboard");
  GLADE_HOOKUP_OBJECT (frmConnect, tblKeyboard, "tblKeyboard");
  GLADE_HOOKUP_OBJECT (frmConnect, cboKeyboard, "cboKeyboard");
  GLADE_HOOKUP_OBJECT (frmConnect, txtKeyboard, "txtKeyboard");
  GLADE_HOOKUP_OBJECT (frmConnect, lblKeyboardLang, "lblKeyboardLang");
  GLADE_HOOKUP_OBJECT (frmConnect, cboKeyboardLang, "cboKeyboardLang");
  GLADE_HOOKUP_OBJECT (frmConnect, txtKeyboardLang, "txtKeyboardLang");
  GLADE_HOOKUP_OBJECT (frmConnect, lblKeyboard, "lblKeyboard");
  GLADE_HOOKUP_OBJECT (frmConnect, imgKeyboard, "imgKeyboard");
  GLADE_HOOKUP_OBJECT (frmConnect, lblKeyboardFrame, "lblKeyboardFrame");
  
  GLADE_HOOKUP_OBJECT (frmConnect, lblGeneralTab1, "lblGeneralTab1");
  GLADE_HOOKUP_OBJECT (frmConnect, lblDisplayTab1, "lblDisplayTab1");
  GLADE_HOOKUP_OBJECT (frmConnect, lblLocalTab1, "lblLocalTab1");
  GLADE_HOOKUP_OBJECT (frmConnect, lblProgramsTab1, "lblProgramsTab1");
  GLADE_HOOKUP_OBJECT (frmConnect, lblExperienceTab1, "lblExperienceTab1");
  GLADE_HOOKUP_OBJECT (frmConnect, lblAboutTab1, "lblAboutTab1");
  
  GLADE_HOOKUP_OBJECT (frmConnect, frameProgram, "frameProgram");
  GLADE_HOOKUP_OBJECT (frmConnect, tblProgram, "tblProgram");
  GLADE_HOOKUP_OBJECT (frmConnect, chkStartProgram, "chkStartProgram");
  GLADE_HOOKUP_OBJECT (frmConnect, imgProgram, "imgProgram");
  GLADE_HOOKUP_OBJECT (frmConnect, lblProgramPath, "lblProgramPath");
  GLADE_HOOKUP_OBJECT (frmConnect, txtProgramPath, "txtProgramPath");
  GLADE_HOOKUP_OBJECT (frmConnect, lblStartFolder, "lblStartFolder");
  GLADE_HOOKUP_OBJECT (frmConnect, txtStartFolder, "txtStartFolder");
  GLADE_HOOKUP_OBJECT (frmConnect, lblProgramFrame, "lblProgramFrame");
  GLADE_HOOKUP_OBJECT (frmConnect, framePerform, "framePerform");
  GLADE_HOOKUP_OBJECT (frmConnect, tblPerform, "tblPerform");
  GLADE_HOOKUP_OBJECT (frmConnect, imgPerform, "imgPerform");
  GLADE_HOOKUP_OBJECT (frmConnect, vbxExpChecks, "vbxExpChecks");
  GLADE_HOOKUP_OBJECT (frmConnect, cboPerform, "cboPerform");
  GLADE_HOOKUP_OBJECT (frmConnect, txtPerform, "txtPerform");
  GLADE_HOOKUP_OBJECT (frmConnect, lblAllow, "lblAllow");
  GLADE_HOOKUP_OBJECT (frmConnect, lblUnsupportedNote, "lblUnsupportedNote");
  GLADE_HOOKUP_OBJECT (frmConnect, chkDesktopBackground, "chkDesktopBackground");
  GLADE_HOOKUP_OBJECT (frmConnect, chkWindowContent, "chkWindowContent");
  GLADE_HOOKUP_OBJECT (frmConnect, chkAnimation, "chkAnimation");
  GLADE_HOOKUP_OBJECT (frmConnect, chkThemes, "chkThemes");
  GLADE_HOOKUP_OBJECT (frmConnect, chkBitmapCache, "chkBitmapCache");
  GLADE_HOOKUP_OBJECT (frmConnect, lblExtraFeatures, "lblExtraFeatures");
  GLADE_HOOKUP_OBJECT (frmConnect, chkNoMotionEvents, "chkNoMotionEvents");
  GLADE_HOOKUP_OBJECT (frmConnect, chkEnableWMKeys, "chkEnableWMKeys");
  
  GLADE_HOOKUP_OBJECT (frmConnect, lblChooseSpeed, "lblChooseSpeed");
  GLADE_HOOKUP_OBJECT (frmConnect, lblPerformFrame, "lblPerformFrame");
  GLADE_HOOKUP_OBJECT (frmConnect, vbxAboutTab1, "vbxAboutTab1");
  GLADE_HOOKUP_OBJECT (frmConnect, frameAbout, "frameAbout");
  GLADE_HOOKUP_OBJECT (frmConnect, scwAbout, "scwAbout");
  GLADE_HOOKUP_OBJECT (frmConnect, txtAbout, "txtAbout");
  GLADE_HOOKUP_OBJECT (frmConnect, lblAboutFrame, "lblAboutFrame");
  GLADE_HOOKUP_OBJECT (frmConnect, hbbAppOps0, "hbbAppOps0");
  GLADE_HOOKUP_OBJECT (frmConnect, btnConnect0, "btnConnect0");
  GLADE_HOOKUP_OBJECT (frmConnect, alnConnect0, "alnConnect0");
  GLADE_HOOKUP_OBJECT (frmConnect, hbxConnect0, "hbxConnect0");
  GLADE_HOOKUP_OBJECT (frmConnect, imgConnect0, "imgConnect0");
  GLADE_HOOKUP_OBJECT (frmConnect, lblConnect0, "lblConnect0");
  GLADE_HOOKUP_OBJECT (frmConnect, btnQuit0, "btnQuit0");
  GLADE_HOOKUP_OBJECT (frmConnect, hbbAppOps1, "hbbAppOps1");
  GLADE_HOOKUP_OBJECT (frmConnect, btnConnect1, "btnConnect1");
  GLADE_HOOKUP_OBJECT (frmConnect, alnConnect1, "alnConnect1");
  GLADE_HOOKUP_OBJECT (frmConnect, hbxConnect1, "hbxConnect1");
  GLADE_HOOKUP_OBJECT (frmConnect, imgConnect1, "imgConnect1");
  GLADE_HOOKUP_OBJECT (frmConnect, lblConnect1, "lblConnect1");
  GLADE_HOOKUP_OBJECT (frmConnect, btnQuit1, "btnQuit1");
  GLADE_HOOKUP_OBJECT (frmConnect, lblComputer0, "lblComputer0");
  GLADE_HOOKUP_OBJECT (frmConnect, cboComputer0, "cboComputer0");
  GLADE_HOOKUP_OBJECT (frmConnect, cboComputer1, "cboComputer1");
  GLADE_HOOKUP_OBJECT (frmConnect, txtComputer1, "txtComputer1");
  GLADE_HOOKUP_OBJECT (frmConnect, btnLess, "btnLess");
  GLADE_HOOKUP_OBJECT (frmConnect, alnLess, "alnLess");
  GLADE_HOOKUP_OBJECT (frmConnect, hbxLess, "hbxLess");
  GLADE_HOOKUP_OBJECT (frmConnect, imgLess, "imgLess");
  GLADE_HOOKUP_OBJECT (frmConnect, lblLess, "lblLess");
  
  GLADE_HOOKUP_OBJECT (frmConnect, lblLess, "alnCompact");
  GLADE_HOOKUP_OBJECT (frmConnect, lblLess, "alnComplete");

  GLADE_HOOKUP_OBJECT (frmConnect, hbxQuickPick, "hbxQuickPick");
  GLADE_HOOKUP_OBJECT (frmConnect, lblQuickPick, "lblQuickPick");
  GLADE_HOOKUP_OBJECT (frmConnect, cboQuickPick, "cboQuickPick");
  GLADE_HOOKUP_OBJECT (frmConnect, txtQuickPick, "txtQuickPick");
  
  GLADE_HOOKUP_OBJECT (frmConnect, chkAltFullSwitch, "chkAltFullSwitch");

  return frmConnect;
}


/***************************************
*                                      *
*   Event Handlers                     *
*                                      *
***************************************/



void
on_btnConnect0_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *main_window;
  gchar *file_name;

  main_window = lookup_widget((GtkWidget*)button, "frmConnect");

  // save the damn thing
  rdp_file_init (g_rdp_file);
  rdp_file_get_screen (g_rdp_file, main_window);

  if (tsc_launch_rdesktop (g_rdp_file, 0) == 0) {
    // get path to file
    file_name = g_build_path ("/", g_get_home_dir(), ".tsclient", "last.tsc", NULL);
    // save the damn thing
    rdp_file_init (g_rdp_file_last);
    rdp_file_get_screen (g_rdp_file_last, main_window);
    rdp_file_save (g_rdp_file_last, file_name);
    // time to go now...
    gtk_main_quit();
    gtk_widget_hide (main_window);
    gtk_widget_destroy (main_window);
  }
}


void
on_btnConnect1_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *widget;
  GtkWidget *main_window;

  main_window = lookup_widget((GtkWidget*)button, "frmConnect");
  widget = lookup_widget (gConnect, "txtComputer1");

  // save the damn thing
  rdp_file_init (g_rdp_file);
  g_rdp_file->full_address = gtk_editable_get_chars ((GtkEditable*) widget, 0, -1);

  if (tsc_launch_rdesktop (g_rdp_file, 1) == 0) {
    // time to go now...
    gtk_main_quit();
    gtk_widget_hide (main_window);
    gtk_widget_destroy (main_window);
  }

}


void
on_btnQuit_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *main_window;
  gchar *file_name;

  main_window = gConnect;
  gtk_widget_hide (main_window);
  tsc_check_files ();

  // get path to file
  file_name = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", "last.tsc", NULL);

  // save the damn thing
  rdp_file_init (g_rdp_file_last);
  rdp_file_get_screen (g_rdp_file_last, main_window);
  rdp_file_save (g_rdp_file_last, file_name);

  gtk_main_quit();
}


void
on_btnMore_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *main_window;
  main_window = lookup_widget((GtkWidget*)button, "frmConnect");
  tsc_set_window_mode (main_window, (int*)WM_COMPLEX);
}


void
on_btnLess_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *main_window;
  main_window = lookup_widget((GtkWidget*)button, "frmConnect");
  tsc_set_window_mode (main_window, (int*)WM_COMPACT);
}


void
on_sldDeskSize_value_changed           (GtkRange        *range,
                                        gpointer         user_data)
{
  GtkWidget *desksize, *ds_label, *alt_fssw;

  desksize = lookup_widget (gConnect, "sldDeskSize");
  ds_label = lookup_widget (gConnect, "lblDeskSize");
  alt_fssw = lookup_widget (gConnect, "chkAltFullSwitch");


  gtk_range_set_value ((GtkRange*) range, rint(gtk_range_get_value (range)));

  switch ((int) gtk_range_get_value (range)) {
  case 0:
    gtk_label_set_text ((GtkLabel*) ds_label, "Default");
    gtk_widget_set_sensitive (alt_fssw, FALSE);
    break;
  case 1:
    gtk_label_set_text ((GtkLabel*) ds_label, "640 x 480 pixels");
    gtk_widget_set_sensitive (alt_fssw, FALSE);
    break;
  case 2:
    gtk_label_set_text ((GtkLabel*) ds_label, "800 x 600 pixels");
    gtk_widget_set_sensitive (alt_fssw, FALSE);
    break;
  case 3:
    gtk_label_set_text ((GtkLabel*) ds_label, "1024 x 768 pixels");
    gtk_widget_set_sensitive (alt_fssw, FALSE);
    break;
  case 4:
    gtk_label_set_text ((GtkLabel*) ds_label, "1152 x 864 pixels");
    gtk_widget_set_sensitive (alt_fssw, FALSE);
    break;
  case 5:
    gtk_label_set_text ((GtkLabel*) ds_label, "1280 x 960 pixels");
    gtk_widget_set_sensitive (alt_fssw, FALSE);
    break;
  case 6:
    gtk_label_set_text ((GtkLabel*) ds_label, "Full Screen");
    gtk_widget_set_sensitive (alt_fssw, TRUE);
    break;
  }

}

void
on_sldColorDepth_value_changed         (GtkRange        *range,
                                        gpointer         user_data)
{
  GtkWidget *cd_label, *img_color;
  gchar *pathname = NULL;

  cd_label = lookup_widget (gConnect, "lblColorDepth");
  img_color = lookup_widget (gConnect, "imgColorDepth");

  gtk_range_set_value ((GtkRange*) range, rint(gtk_range_get_value (range)));

  switch ((int) gtk_range_get_value (range)) {
  case 0:
    gtk_label_set_text ((GtkLabel*) cd_label, "Default");
    pathname = find_pixmap_file ("colors-hi.png");
    break;
  case 1:
    gtk_label_set_text ((GtkLabel*) cd_label, "256 Colors");
    pathname = find_pixmap_file ("colors-lo.png");
    break;
  case 2:
    gtk_label_set_text ((GtkLabel*) cd_label, "High Color (15 bit)");
    pathname = find_pixmap_file ("colors-lo.png");
    break;
  case 3:
    gtk_label_set_text ((GtkLabel*) cd_label, "High Color (16 bit)");
    pathname = find_pixmap_file ("colors-hi.png");
    break;
  case 4:
    gtk_label_set_text ((GtkLabel*) cd_label, "True Color (24 bit)");
    pathname = find_pixmap_file ("colors-hi.png");
    break;
  }
  gtk_image_set_from_file ((GtkImage*)img_color, pathname);
  g_free (pathname);

}


void
on_btnSaveAs_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *frmRDPSave;
  gchar *path_name;

  path_name = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", "/", NULL);
  
  frmRDPSave = create_frmRDPSave ();
  gtk_window_set_title ((GtkWindow*) frmRDPSave, "Input a filename to save as...");
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (frmRDPSave), path_name);
  gtk_widget_show (frmRDPSave);
  gdk_window_raise (frmRDPSave->window);
}

void
on_btnOpen_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *frmRDPOpen;
  gchar *path_name;

  path_name = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", "/", NULL);
  
  frmRDPOpen = create_frmRDPOpen ();
  gtk_window_set_title ((GtkWindow*) frmRDPOpen, "Choose an RDP file to open...");
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (frmRDPOpen), path_name);
  gtk_widget_show (frmRDPOpen);
  gdk_window_raise (frmRDPOpen->window);
}

void
on_txtQuickPick_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget *main_window;
  gchar *file_name;
  main_window = lookup_widget((GtkWidget*)editable, "frmConnect");
  // build path to file
  file_name = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", gtk_editable_get_chars (editable, 0, -1), NULL);
  // check for file in ~/
  if (g_file_test (file_name, G_FILE_TEST_EXISTS)) {
    // load if exists
    rdp_file_init (g_rdp_file);
    rdp_file_load (g_rdp_file, file_name);

    if (tsc_launch_rdesktop (g_rdp_file, 0) == 0) {
      // get path to file
      file_name = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", "last.tsc", NULL);
      // save the damn thing
      rdp_file_init (g_rdp_file_last);
      rdp_file_get_screen (g_rdp_file_last, main_window);
      rdp_file_save (g_rdp_file_last, file_name);
      // time to go now...
      gtk_widget_hide (main_window);
      gtk_widget_destroy (main_window);
    }
  }

}

void
on_txtPerform_changed                  (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget *txtPerform, *widget;
  gboolean bBitmapCache = FALSE;
  gboolean bDesktopBackground = FALSE;
  gboolean bWindowContent = FALSE;
  gboolean bAnimation = FALSE;
  gboolean bThemes = FALSE;

  txtPerform = lookup_widget ((GtkWidget *)editable, "txtPerform");
  
  if ( strcmp(OPT_PERF_28K, gtk_entry_get_text ((GtkEntry *)txtPerform) ) == 0) {
    bBitmapCache = TRUE;
  } else if (strcmp(OPT_PERF_56K, gtk_entry_get_text ((GtkEntry *)txtPerform)) == 0) {
    bThemes = TRUE;
    bBitmapCache = TRUE;
  } else if (strcmp(OPT_PERF_BB, gtk_entry_get_text ((GtkEntry *)txtPerform)) == 0) {
    bWindowContent = TRUE;
    bAnimation = TRUE;
    bThemes = TRUE;
    bBitmapCache = TRUE;
  } else if (strcmp(OPT_PERF_LAN, gtk_entry_get_text ((GtkEntry *)txtPerform)) == 0) {
    bDesktopBackground = TRUE;
    bWindowContent = TRUE;
    bAnimation = TRUE;
    bThemes = TRUE;
    bBitmapCache = TRUE;
  } else if (strcmp(OPT_PERF_CUSTOM, gtk_entry_get_text ((GtkEntry *)txtPerform)) == 0) {
    bThemes = TRUE;
    bBitmapCache = TRUE;
  }
  
  widget = lookup_widget (GTK_WIDGET (gConnect), "chkBitmapCache");
  if (bBitmapCache)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), FALSE);
  widget = lookup_widget (GTK_WIDGET (gConnect), "chkDesktopBackground");
  if (bDesktopBackground)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), FALSE);
  widget = lookup_widget (GTK_WIDGET (gConnect), "chkWindowContent");
  if (bWindowContent)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), FALSE);
  widget = lookup_widget (GTK_WIDGET (gConnect), "chkAnimation");
  if (bAnimation)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), FALSE);
  widget = lookup_widget (GTK_WIDGET (gConnect), "chkThemes");
  if (bThemes)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), FALSE);


}

