/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h> 
#include <sys/stat.h> 
#include <stdio.h>

#include <gtk/gtk.h>
#include <glib.h>
#include <string.h>

#include "rdpfile.h"
#include "main.h"
#include "support.h"
#include "mrulist.h"
#include "connect.h"

rdp_file *g_rdp_file = NULL;
rdp_file *g_rdp_file_last = NULL;

const gchar *OPT_SOUND_BRING  = "Bring to this computer";
const gchar *OPT_SOUND_LEAVE  = "Leave at remote computer";
const gchar *OPT_SOUND_NOPLAY = "Do not play";

const gchar *OPT_KEY_LOCAL    = "On the local computer";
const gchar *OPT_KEY_REMOTE   = "On the remote computer";
const gchar *OPT_KEY_FULL     = "In full screen mode only";

const gchar *OPT_PERF_28K     = "Modem (28.8 Kbps)";
const gchar *OPT_PERF_56K     = "Modem (56 Kbps)";
const gchar *OPT_PERF_BB      = "Broadband (128 Kbps - 1.5 Mbps)";
const gchar *OPT_PERF_LAN     = "LAN (10 Mbps or higher)";
const gchar *OPT_PERF_CUSTOM  = "Custom";


int
main (int argc, char *argv[])
{
  GtkWidget *widget;
  GList *server_items = NULL;
  GSList *server_list = NULL;
  int i;
  gchar *name = NULL;

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");

  // create the main window
  gConnect = create_frmConnect ();
  // set the window mode (compact)
  tsc_set_window_mode (gConnect, (int*)WM_COMPACT);
  gtk_widget_show (gConnect);

  // init the global rdp_file
  g_rdp_file = g_new (rdp_file, 1);
  rdp_file_init (g_rdp_file);

  // Get the last.tsc for last used settings and load
  tsc_check_files ();
  g_rdp_file_last = g_new (rdp_file, 1);
  rdp_file_init (g_rdp_file_last);
  rdp_file_load (g_rdp_file_last, g_build_path ("/", g_get_home_dir(), ".tsclient", "last.tsc", NULL));
  rdp_file_set_screen (g_rdp_file_last, gConnect);

  // Get the mru.tsc
  mru_file_to_list (&server_list);

  // load mru combos
  i = 0;
  while ((server_list != NULL && i <= 10))
  {
    name = server_list->data;
    server_items = g_list_append (server_items, (gpointer)name);
    server_list = server_list->next;
    i++;
  }
  widget = lookup_widget (gConnect, "cboComputer0");
  gtk_combo_set_popdown_strings (GTK_COMBO (widget), server_items);
  widget = lookup_widget (gConnect, "cboComputer1");
  gtk_combo_set_popdown_strings (GTK_COMBO (widget), server_items);
  g_list_free (server_items);

  load_rdp_picker (gConnect);

  gtk_main ();
  return 0;
}


