/***************************************
*                                      *
*   MRU File Handlers                  *
*                                      *
***************************************/


#include <glib.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h> 
#include <sys/stat.h> 
#include <dirent.h> 

#include "mrulist.h"
#include "rdpfile.h"
#include "support.h"


/***************************************
*                                      *
*   mru_file_to_list                   *
*                                      *
***************************************/

int mru_file_to_list (GSList** list)
{
  gchar *mymrufile;
  FILE* fptr;
  gchar buffer[MAX_SERVER_SIZE];
  gchar *name = NULL;
  int i;

  tsc_check_files();

  // create .tsclient dir in ~/
  mymrufile = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", "mru.tsc", NULL);

  /* open the file for reading */
  if((fptr = fopen(mymrufile, "r")) == NULL)
  {
    return 1;   /* bad fully qualified path to file */
  }

  /* Grab the first line, it may indicate a unicode file */
  buffer[0] = '\0';
  if(fgets(buffer, MAX_SERVER_SIZE, fptr) == NULL)
  {
    /* complete successfully */
    return 0;
  }

  i = 0;
  /* remember the first line is already in the buffer */
  do
  {
    if(buffer[strlen(buffer) - 1] == '\n') buffer[strlen(buffer) - 1] = '\0';
    if(buffer[strlen(buffer) - 1] == '\r') buffer[strlen(buffer) - 1] = '\0';
    buffer[MAX_SERVER_SIZE - 1] = '\0';
    name = g_strdup(buffer);
    /* append next structure to the list */
    *list = g_slist_append(*list, name);
    
    /* read the next flat file record */
    buffer[0] = '\n';
    i++;
  }
  while((fgets(buffer, MAX_SERVER_SIZE, fptr) != NULL && i <= 10));

  /* close file */
  fclose(fptr);

  /* complete successfully */
  return 0;
}


/***************************************
*                                      *
*   mru_list_to_file                   *
*                                      *
***************************************/
 
int mru_list_to_file (GSList** list)
{
  GSList* dptr = NULL;
  gchar *mymrufile;
  FILE* fptr;
  char buffer[MAX_SERVER_SIZE * 10];
  int i;
  
  tsc_check_files();

  // create mru.tsc dir in ~/.tsclient/
  mymrufile = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", "mru.tsc", NULL);

  /* open the file for writing*/
  if((fptr = fopen(mymrufile, "wt")) == NULL)
  {
    return 1;   /* bad fully qualified path to file */
  }

  /* write each record to the flat file in turn */
  buffer[0] = '\0';
  dptr = *list;
  i = 0;
  while((dptr != NULL && i <= 10))
  {
    /* combine the key, type, and value segments */
    strncat(buffer, (char*)dptr->data, MAX_SERVER_SIZE - 2);
    strcat(buffer, "\r");
    strcat(buffer, "\n");

    /* move forward */
    dptr = dptr->next;
    i++;
  }
  //strncat(buffer, '\0', 1);
  
  /* save flat file */
  if(fputs(buffer, fptr) == EOF)
  {
      return 2;   /* write failed */
  }

  /* close file */
  fclose(fptr);
 
  /* complete successfully */
  return 0;

  
}


/***************************************
*                                      *
*   mru_add_server                     *
*                                      *
***************************************/
 
int mru_add_server(char* server_name)
{
  GSList* list = NULL;

  mru_file_to_list (&list);
  
  if (g_slist_length (list) > 0) {
    list = g_slist_prepend (list, server_name);
  } else {
    list = g_slist_append (list, server_name);
  }

  mru_list_to_file (&list);
  
  /* complete successfully */
  return 0;
}


/***************************************
*                                      *
*   load_rdp_picker                    *
*                                      *
***************************************/
 
int load_rdp_picker (GtkWidget *main_window)
{
  DIR *dptr;
  gchar *path_name;
  struct dirent *dp;
  int i = 0;
  GList *combo_items = NULL;
  GtkWidget *hbox_combo;
  GtkCombo *combo;
  
  combo = (GtkCombo*)lookup_widget (main_window, "cboQuickPick");
  hbox_combo = lookup_widget (main_window, "hbxQuickPick");

  tsc_check_files();
  
  // create .tsclient dir in ~/
  path_name = g_build_path ((const gchar *)"/", g_get_home_dir(), ".tsclient", NULL);
  if ((dptr = opendir(path_name)) == NULL)
  {
    printf ("Can't open %s\n", path_name);
    return 1;
  }
  
  combo_items = g_list_append (combo_items, (gpointer) "");
  for (dp = readdir(dptr); dp != NULL; dp = readdir(dptr)) {
    if (strlen(dp->d_name) > 4) {
      if (dp->d_name[strlen(dp->d_name) - 3] == 'r'
          && dp->d_name[strlen(dp->d_name) - 2] == 'd'
          && dp->d_name[strlen(dp->d_name) - 1] == 'p') {
        combo_items = g_list_append (combo_items, (gpointer) dp->d_name);
        i++;
      }
    }
	}
  if (i < 1) {
    gtk_widget_hide (hbox_combo);
  } else {
    gtk_combo_set_popdown_strings (combo, combo_items);
  }
  g_list_free (combo_items);

  closedir(dptr);

  /* complete successfully */
  return 0;
  
}
