/***************************************
*                                      *
*   frmRDPSave Create & Events         *
*                                      *
***************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include "rdpfile.h"
#include "support.h"
#include "rdpsave.h"
#include "main.h"


/***************************************
*                                      *
*   frmRDPSave Create                  *
*                                      *
***************************************/

GtkWidget*
create_frmRDPSave (void)
{
  GtkWidget *frmRDPSave;
  GtkWidget *btnOk;
  GtkWidget *btnCancel;

  frmRDPSave = gtk_file_selection_new ("Select File");
  gtk_widget_set_name (frmRDPSave, "frmRDPSave");
  gtk_container_set_border_width (GTK_CONTAINER (frmRDPSave), 10);
  gtk_window_set_position (GTK_WINDOW (frmRDPSave), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (frmRDPSave), TRUE);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (frmRDPSave), TRUE);
  //gtk_window_set_icon (GTK_WINDOW (frmRDPSave), 
  //                     gdk_pixbuf_new_from_xpm_data ((const char**) xpm_tsclient));
  gtk_window_set_icon (GTK_WINDOW (frmRDPSave), create_pixbuf ("tsclient.png"));

  btnOk = GTK_FILE_SELECTION (frmRDPSave)->ok_button;
  gtk_widget_set_name (btnOk, "btnOk");
  gtk_widget_show (btnOk);
  GTK_WIDGET_SET_FLAGS (btnOk, GTK_CAN_DEFAULT);

  btnCancel = GTK_FILE_SELECTION (frmRDPSave)->cancel_button;
  gtk_widget_set_name (btnCancel, "btnCancel");
  gtk_widget_show (btnCancel);
  GTK_WIDGET_SET_FLAGS (btnCancel, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (btnOk), "clicked",
                      GTK_SIGNAL_FUNC (on_btnOk_Save_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btnCancel), "clicked",
                      GTK_SIGNAL_FUNC (on_btnCancel_Save_clicked),
                      NULL);

  gtk_widget_grab_default (btnOk);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (frmRDPSave, frmRDPSave, "frmRDPSave");
  GLADE_HOOKUP_OBJECT_NO_REF (frmRDPSave, btnOk, "btnOk");
  GLADE_HOOKUP_OBJECT_NO_REF (frmRDPSave, btnCancel, "btnCancel");

  return frmRDPSave;
}


/***************************************
*                                      *
*   frmRDPSave Events                  *
*                                      *
***************************************/

void
on_btnOk_Save_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *main_window;
  GtkWidget *this_window;
  gchar *file_name;

  main_window = gConnect;
  this_window = lookup_widget (GTK_WIDGET (button), "frmRDPSave");
  gtk_widget_hide (this_window);
  // get path to file
  file_name = (gchar *) gtk_file_selection_get_filename (GTK_FILE_SELECTION (this_window));

  // save the damn thing
  rdp_file_init (g_rdp_file);
  rdp_file_get_screen (g_rdp_file, main_window);
  rdp_file_save (g_rdp_file, file_name);

  gtk_widget_destroy (this_window);

}


void
on_btnCancel_Save_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *this_window;
  this_window = lookup_widget (GTK_WIDGET (button), "frmRDPSave");
  gtk_widget_hide (this_window);
  gtk_widget_destroy (this_window);
}

